/*
 * Decompiled with CFR 0.152.
 */
package zombie;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import zombie.GameProfiler;
import zombie.ZomboidFileSystem;
import zombie.core.skinnedmodel.animation.debug.AnimationPlayerRecorder;
import zombie.core.skinnedmodel.animation.debug.GenericNameValueRecordingFrame;
import zombie.util.IPooledObject;
import zombie.util.Pool;
import zombie.util.PooledObject;
import zombie.util.list.PZArrayUtil;

public final class GameProfileRecording
extends GenericNameValueRecordingFrame {
    private long m_startTime;
    private final Row m_rootRow = new Row();
    private final HashMap<String, Integer> m_keyValueTable = new HashMap();
    protected PrintStream m_outSegment = null;
    private long m_firstFrameNo = -1L;
    private final List<String> m_segmentFilePaths = new ArrayList<String>();
    private int m_numFramesPerFile = 60;
    private int m_currentSegmentFrameCount = 0;

    public GameProfileRecording(String string) {
        super(string, "_times");
        this.addColumnInternal("StartTime");
        this.addColumnInternal("EndTime");
        this.addColumnInternal("SegmentNo");
        this.addColumnInternal("Spans");
        this.addColumnInternal("key");
        this.addColumnInternal("Depth");
        this.addColumnInternal("StartTime");
        this.addColumnInternal("EndTime");
        this.addColumnInternal("Time Format");
        this.addColumnInternal("x * 100ns");
    }

    public void setNumFramesPerSegment(int n) {
        this.m_numFramesPerFile = n;
    }

    public void setStartTime(long l) {
        this.m_startTime = l;
    }

    public void logTimeSpan(GameProfiler.ProfileArea profileArea) {
        if (this.m_firstFrameNo == -1L) {
            this.m_firstFrameNo = this.m_frameNumber;
        }
        Span span = this.allocSpan(profileArea);
        Row row = this.m_rootRow;
        if (row.Spans.isEmpty()) {
            row.StartTime = span.StartTime;
        }
        row.EndTime = span.EndTime;
        row.Spans.add(span);
    }

    protected Span allocSpan(GameProfiler.ProfileArea profileArea) {
        int n = this.getOrCreateKey(profileArea.Key);
        long l = profileArea.StartTime - this.m_startTime;
        long l2 = profileArea.EndTime - this.m_startTime;
        Span span = Span.alloc();
        span.key = n;
        span.Depth = profileArea.Depth;
        span.StartTime = l;
        span.EndTime = l2;
        int n2 = profileArea.Children.size();
        for (int i = 0; i < n2; ++i) {
            GameProfiler.ProfileArea profileArea2 = profileArea.Children.get(i);
            Span span2 = this.allocSpan(profileArea2);
            span.Children.add(span2);
        }
        return span;
    }

    private int getOrCreateKey(String string) {
        Integer n = this.m_keyValueTable.get(string);
        if (n == null) {
            n = this.m_keyValueTable.size();
            this.m_keyValueTable.put(string, n);
            this.m_headerDirty = true;
        }
        return n;
    }

    @Override
    public String getValueAt(int n) {
        throw new RuntimeException("Not implemented. Use getValueAt(row, col)");
    }

    @Override
    protected void onColumnAdded() {
    }

    @Override
    public void reset() {
        this.m_rootRow.reset();
    }

    protected void openSegmentFile(boolean bl) {
        if (this.m_outSegment != null) {
            this.m_outSegment.flush();
            this.m_outSegment.close();
        }
        String string = String.format("%s%s_%04d", this.m_fileKey, this.m_valuesFileNameSuffix, this.m_segmentFilePaths.size());
        this.m_outSegment = AnimationPlayerRecorder.openFileStream(string, bl, this.m_segmentFilePaths::add);
        this.m_currentSegmentFrameCount = 0;
        this.m_headerDirty = true;
    }

    @Override
    public void close() {
        if (this.m_outSegment != null) {
            this.m_outSegment.close();
            this.m_outSegment = null;
        }
    }

    @Override
    public void closeAndDiscard() {
        super.closeAndDiscard();
        PZArrayUtil.forEach(this.m_segmentFilePaths, ZomboidFileSystem.instance::tryDeleteFile);
        this.m_segmentFilePaths.clear();
    }

    @Override
    protected void writeData() {
        if (this.m_outValues == null) {
            this.openValuesFile(false);
        }
        StringBuilder stringBuilder = this.m_lineBuffer;
        stringBuilder.setLength(0);
        ++this.m_currentSegmentFrameCount;
        if (this.m_outSegment == null || this.m_currentSegmentFrameCount >= this.m_numFramesPerFile) {
            this.openSegmentFile(false);
        }
        this.writeDataRow(stringBuilder, this.m_rootRow);
        this.m_outSegment.print(this.m_frameNumber);
        this.m_outSegment.println(stringBuilder);
        stringBuilder = this.m_lineBuffer;
        stringBuilder.setLength(0);
        this.writeFrameTimeRow(stringBuilder, this.m_rootRow, this.m_segmentFilePaths.size() - 1);
        this.m_outValues.print(this.m_frameNumber);
        this.m_outValues.println(stringBuilder);
    }

    private void writeDataRow(StringBuilder stringBuilder, Row row) {
        int n = row.Spans.size();
        for (int i = 0; i < n; ++i) {
            Span span = row.Spans.get(i);
            this.writeSpan(stringBuilder, row, span);
        }
    }

    private void writeFrameTimeRow(StringBuilder stringBuilder, Row row, int n) {
        GameProfileRecording.appendCell(stringBuilder, row.StartTime / 100L);
        GameProfileRecording.appendCell(stringBuilder, row.EndTime / 100L);
        GameProfileRecording.appendCell(stringBuilder, n);
    }

    private void writeSpan(StringBuilder stringBuilder, Row row, Span span) {
        long l = (span.StartTime - row.StartTime) / 100L;
        long l2 = (span.EndTime - span.StartTime) / 100L;
        GameProfileRecording.appendCell(stringBuilder, span.key);
        GameProfileRecording.appendCell(stringBuilder, span.Depth);
        GameProfileRecording.appendCell(stringBuilder, l);
        GameProfileRecording.appendCell(stringBuilder, l2);
        int n = span.Children.size();
        for (int i = 0; i < n; ++i) {
            Span span2 = span.Children.get(i);
            this.writeSpan(stringBuilder, row, span2);
        }
    }

    @Override
    protected void writeHeader() {
        super.writeHeader();
        this.m_outHeader.println();
        this.m_outHeader.println("Segmentation Info");
        this.m_outHeader.println("FirstFrame," + this.m_firstFrameNo);
        this.m_outHeader.println("NumFramesPerFile," + this.m_numFramesPerFile);
        this.m_outHeader.println("NumFiles," + this.m_segmentFilePaths.size());
        this.m_outHeader.println();
        this.m_outHeader.println("KeyNamesTable");
        this.m_outHeader.println("Index,Name");
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, Integer> entry : this.m_keyValueTable.entrySet()) {
            stringBuilder.setLength(0);
            stringBuilder.append(entry.getValue());
            stringBuilder.append(",");
            stringBuilder.append(entry.getKey());
            this.m_outHeader.println(stringBuilder);
        }
    }

    public static class Row {
        long StartTime;
        long EndTime;
        final List<Span> Spans = new ArrayList<Span>();

        public void reset() {
            IPooledObject.release(this.Spans);
        }
    }

    public static class Span
    extends PooledObject {
        int key;
        int Depth;
        long StartTime;
        long EndTime;
        final List<Span> Children = new ArrayList<Span>();
        private static final Pool<Span> s_pool = new Pool<Span>(Span::new);

        @Override
        public void onReleased() {
            super.onReleased();
            IPooledObject.release(this.Children);
        }

        public static Span alloc() {
            return s_pool.alloc();
        }
    }
}

