/*
 * Decompiled with CFR 0.152.
 */
package zombie;

import java.util.ArrayList;
import java.util.HashMap;
import zombie.GameTime;
import zombie.SandboxOptions;
import zombie.ZomboidGlobals;
import zombie.audio.BaseSoundEmitter;
import zombie.characters.BodyDamage.BodyDamage;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.core.Core;
import zombie.core.SpriteRenderer;
import zombie.debug.DebugLog;
import zombie.iso.IsoChunk;
import zombie.iso.IsoChunkMap;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWorld;
import zombie.iso.areas.IsoBuilding;

public final class FliesSound {
    public static final FliesSound instance = new FliesSound();
    private static final IsoGridSquare[] tempSquares = new IsoGridSquare[100];
    private final PlayerData[] playerData = new PlayerData[4];
    private final ArrayList<FadeEmitter> fadeEmitters = new ArrayList();
    private float fliesVolume = -1.0f;

    public FliesSound() {
        for (int i = 0; i < this.playerData.length; ++i) {
            this.playerData[i] = new PlayerData();
        }
    }

    public void Reset() {
        for (int i = 0; i < this.playerData.length; ++i) {
            this.playerData[i].Reset();
        }
    }

    public void update() {
        Object object;
        int n;
        if (SandboxOptions.instance.DecayingCorpseHealthImpact.getValue() == 1) {
            return;
        }
        for (n = 0; n < IsoPlayer.numPlayers; ++n) {
            object = IsoPlayer.players[n];
            if (object == null || ((IsoMovingObject)object).getCurrentSquare() == null) continue;
            this.playerData[n].update((IsoPlayer)object);
        }
        for (n = 0; n < this.fadeEmitters.size(); ++n) {
            object = this.fadeEmitters.get(n);
            if (!((FadeEmitter)object).update()) continue;
            this.fadeEmitters.remove(n--);
        }
    }

    public void render() {
        IsoChunkMap isoChunkMap = IsoWorld.instance.CurrentCell.ChunkMap[0];
        for (int i = 0; i < IsoChunkMap.ChunkGridWidth; ++i) {
            for (int j = 0; j < IsoChunkMap.ChunkGridWidth; ++j) {
                ChunkData chunkData;
                IsoChunk isoChunk = isoChunkMap.getChunk(j, i);
                if (isoChunk == null || (chunkData = isoChunk.corpseData) == null) continue;
                int n = (int)IsoPlayer.players[0].z;
                ChunkLevelData chunkLevelData = chunkData.levelData[n];
                for (int k = 0; k < chunkLevelData.emitters.length; ++k) {
                    FadeEmitter fadeEmitter = chunkLevelData.emitters[k];
                    if (fadeEmitter != null && fadeEmitter.emitter != null) {
                        this.paintSquare(fadeEmitter.sq.x, fadeEmitter.sq.y, fadeEmitter.sq.z, 0.0f, 1.0f, 0.0f, 1.0f);
                    }
                    if (chunkLevelData.refCount[k] <= 0) continue;
                    this.paintSquare(isoChunk.wx * 10 + 5, isoChunk.wy * 10 + 5, 0, 0.0f, 0.0f, 1.0f, 1.0f);
                }
                IsoBuilding isoBuilding = IsoPlayer.players[0].getCurrentBuilding();
                if (isoBuilding == null || chunkLevelData.buildingCorpseCount == null || !chunkLevelData.buildingCorpseCount.containsKey(isoBuilding)) continue;
                this.paintSquare(isoChunk.wx * 10 + 5, isoChunk.wy * 10 + 5, n, 1.0f, 0.0f, 0.0f, 1.0f);
            }
        }
    }

    private void paintSquare(int n, int n2, int n3, float f, float f2, float f3, float f4) {
        int n4 = Core.TileScale;
        int n5 = (int)IsoUtils.XToScreenExact(n, n2 + 1, n3, 0);
        int n6 = (int)IsoUtils.YToScreenExact(n, n2 + 1, n3, 0);
        SpriteRenderer.instance.renderPoly(n5, n6, n5 + 32 * n4, n6 - 16 * n4, n5 + 64 * n4, n6, n5 + 32 * n4, n6 + 16 * n4, f, f2, f3, f4);
    }

    public void chunkLoaded(IsoChunk isoChunk) {
        if (isoChunk.corpseData == null) {
            isoChunk.corpseData = new ChunkData(isoChunk.wx, isoChunk.wy);
        }
        isoChunk.corpseData.wx = isoChunk.wx;
        isoChunk.corpseData.wy = isoChunk.wy;
        isoChunk.corpseData.Reset();
    }

    public void corpseAdded(int n, int n2, int n3) {
        if (n3 < 0 || n3 >= 8) {
            DebugLog.General.error("invalid z-coordinate %d,%d,%d", n, n2, n3);
            return;
        }
        ChunkData chunkData = this.getChunkData(n, n2);
        if (chunkData == null) {
            return;
        }
        chunkData.corpseAdded(n, n2, n3);
        for (int i = 0; i < this.playerData.length; ++i) {
            if (chunkData.levelData[n3].refCount[i] <= 0) continue;
            this.playerData[i].forceUpdate = true;
        }
    }

    public void corpseRemoved(int n, int n2, int n3) {
        if (n3 < 0 || n3 >= 8) {
            DebugLog.General.error("invalid z-coordinate %d,%d,%d", n, n2, n3);
            return;
        }
        ChunkData chunkData = this.getChunkData(n, n2);
        if (chunkData == null) {
            return;
        }
        chunkData.corpseRemoved(n, n2, n3);
        for (int i = 0; i < this.playerData.length; ++i) {
            if (chunkData.levelData[n3].refCount[i] <= 0) continue;
            this.playerData[i].forceUpdate = true;
        }
    }

    public int getCorpseCount(IsoGameCharacter isoGameCharacter) {
        if (isoGameCharacter == null || isoGameCharacter.getCurrentSquare() == null) {
            return 0;
        }
        return this.getCorpseCount((int)isoGameCharacter.getX() / 10, (int)isoGameCharacter.getY() / 10, (int)isoGameCharacter.getZ(), isoGameCharacter.getBuilding());
    }

    private int getCorpseCount(int n, int n2, int n3, IsoBuilding isoBuilding) {
        int n4 = 0;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                Integer n5;
                ChunkData chunkData = this.getChunkData((n + j) * 10, (n2 + i) * 10);
                if (chunkData == null) continue;
                ChunkLevelData chunkLevelData = chunkData.levelData[n3];
                if (isoBuilding == null) {
                    n4 += chunkLevelData.corpseCount;
                    continue;
                }
                if (chunkLevelData.buildingCorpseCount == null || (n5 = chunkLevelData.buildingCorpseCount.get(isoBuilding)) == null) continue;
                n4 += n5.intValue();
            }
        }
        return n4;
    }

    private ChunkData getChunkData(int n, int n2) {
        IsoChunk isoChunk = IsoWorld.instance.CurrentCell.getChunkForGridSquare(n, n2, 0);
        if (isoChunk != null) {
            return isoChunk.corpseData;
        }
        return null;
    }

    private class PlayerData {
        int wx = -1;
        int wy = -1;
        int z = -1;
        IsoBuilding building = null;
        boolean forceUpdate = false;

        PlayerData() {
        }

        boolean isSameLocation(IsoPlayer isoPlayer) {
            IsoGridSquare isoGridSquare = isoPlayer.getCurrentSquare();
            if (isoGridSquare != null && isoGridSquare.getBuilding() != this.building) {
                return false;
            }
            return (int)isoPlayer.getX() / 10 == this.wx && (int)isoPlayer.getY() / 10 == this.wy && (int)isoPlayer.getZ() == this.z;
        }

        void update(IsoPlayer isoPlayer) {
            ChunkLevelData chunkLevelData;
            ChunkData chunkData;
            int n;
            int n2;
            if (!this.forceUpdate && this.isSameLocation(isoPlayer)) {
                return;
            }
            this.forceUpdate = false;
            int n3 = this.wx;
            int n4 = this.wy;
            int n5 = this.z;
            IsoGridSquare isoGridSquare = isoPlayer.getCurrentSquare();
            this.wx = isoGridSquare.getX() / 10;
            this.wy = isoGridSquare.getY() / 10;
            this.z = isoGridSquare.getZ();
            this.building = isoGridSquare.getBuilding();
            for (n2 = -1; n2 <= 1; ++n2) {
                for (n = -1; n <= 1; ++n) {
                    chunkData = FliesSound.this.getChunkData((this.wx + n) * 10, (this.wy + n2) * 10);
                    if (chunkData == null) continue;
                    chunkLevelData = chunkData.levelData[this.z];
                    chunkLevelData.update(this.wx + n, this.wy + n2, this.z, isoPlayer);
                }
            }
            if (n5 == -1) {
                return;
            }
            for (n2 = -1; n2 <= 1; ++n2) {
                for (n = -1; n <= 1; ++n) {
                    chunkData = FliesSound.this.getChunkData((n3 + n) * 10, (n4 + n2) * 10);
                    if (chunkData == null) continue;
                    chunkLevelData = chunkData.levelData[n5];
                    chunkLevelData.deref(isoPlayer);
                }
            }
        }

        void Reset() {
            this.z = -1;
            this.wy = -1;
            this.wx = -1;
            this.building = null;
            this.forceUpdate = false;
        }
    }

    private class FadeEmitter {
        private static final float FADE_IN_RATE = 0.01f;
        private static final float FADE_OUT_RATE = -0.01f;
        BaseSoundEmitter emitter = null;
        float volume = 1.0f;
        float targetVolume = 1.0f;
        IsoGridSquare sq = null;

        private FadeEmitter() {
        }

        boolean update() {
            if (this.emitter == null) {
                return true;
            }
            if (this.volume < this.targetVolume) {
                this.volume += 0.01f * (GameTime.getInstance().getMultiplier() / 1.6f);
                if (this.volume >= this.targetVolume) {
                    this.volume = this.targetVolume;
                    return true;
                }
            } else {
                this.volume += -0.01f * (GameTime.getInstance().getMultiplier() / 1.6f);
                if (this.volume <= 0.0f) {
                    this.volume = 0.0f;
                    this.emitter.stopAll();
                    this.emitter = null;
                    return true;
                }
            }
            this.emitter.setVolumeAll(this.volume);
            return false;
        }

        void Reset() {
            this.emitter = null;
            this.volume = 1.0f;
            this.targetVolume = 1.0f;
            this.sq = null;
        }
    }

    public class ChunkData {
        private int wx;
        private int wy;
        private final ChunkLevelData[] levelData = new ChunkLevelData[8];

        private ChunkData(int n, int n2) {
            this.wx = n;
            this.wy = n2;
            for (int i = 0; i < this.levelData.length; ++i) {
                this.levelData[i] = new ChunkLevelData();
            }
        }

        private void corpseAdded(int n, int n2, int n3) {
            IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n, n2, n3);
            IsoBuilding isoBuilding = isoGridSquare == null ? null : isoGridSquare.getBuilding();
            int n4 = n - this.wx * 10;
            int n5 = n2 - this.wy * 10;
            this.levelData[n3].corpseAdded(n4, n5, isoBuilding);
        }

        private void corpseRemoved(int n, int n2, int n3) {
            IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n, n2, n3);
            IsoBuilding isoBuilding = isoGridSquare == null ? null : isoGridSquare.getBuilding();
            int n4 = n - this.wx * 10;
            int n5 = n2 - this.wy * 10;
            this.levelData[n3].corpseRemoved(n4, n5, isoBuilding);
        }

        private void Reset() {
            for (int i = 0; i < this.levelData.length; ++i) {
                this.levelData[i].Reset();
            }
        }
    }

    private class ChunkLevelData {
        int corpseCount = 0;
        HashMap<IsoBuilding, Integer> buildingCorpseCount = null;
        final int[] refCount = new int[4];
        final FadeEmitter[] emitters = new FadeEmitter[4];

        ChunkLevelData() {
        }

        void corpseAdded(int n, int n2, IsoBuilding isoBuilding) {
            if (isoBuilding == null) {
                ++this.corpseCount;
            } else {
                Integer n3;
                if (this.buildingCorpseCount == null) {
                    this.buildingCorpseCount = new HashMap();
                }
                if ((n3 = this.buildingCorpseCount.get(isoBuilding)) == null) {
                    this.buildingCorpseCount.put(isoBuilding, 1);
                } else {
                    this.buildingCorpseCount.put(isoBuilding, n3 + 1);
                }
            }
        }

        void corpseRemoved(int n, int n2, IsoBuilding isoBuilding) {
            Integer n3;
            if (isoBuilding == null) {
                --this.corpseCount;
            } else if (this.buildingCorpseCount != null && (n3 = this.buildingCorpseCount.get(isoBuilding)) != null) {
                if (n3 > 1) {
                    this.buildingCorpseCount.put(isoBuilding, n3 - 1);
                } else {
                    this.buildingCorpseCount.remove(isoBuilding);
                }
            }
        }

        IsoGridSquare calcSoundPos(int n, int n2, int n3, IsoBuilding isoBuilding) {
            IsoChunk isoChunk = IsoWorld.instance.CurrentCell.getChunkForGridSquare(n * 10, n2 * 10, n3);
            if (isoChunk == null) {
                return null;
            }
            int n4 = 0;
            for (int i = 0; i < 10; ++i) {
                for (int j = 0; j < 10; ++j) {
                    IsoGridSquare isoGridSquare = isoChunk.getGridSquare(j, i, n3);
                    if (isoGridSquare == null || isoGridSquare.getStaticMovingObjects().isEmpty() || isoGridSquare.getBuilding() != isoBuilding) continue;
                    FliesSound.tempSquares[n4++] = isoGridSquare;
                }
            }
            if (n4 > 0) {
                return tempSquares[n4 / 2];
            }
            return null;
        }

        void update(int n, int n2, int n3, IsoPlayer isoPlayer) {
            int n4 = isoPlayer.PlayerIndex;
            this.refCount[n4] = this.refCount[n4] + 1;
            int n5 = FliesSound.this.getCorpseCount(n, n2, n3, isoPlayer.getCurrentBuilding());
            if ((double)BodyDamage.getSicknessFromCorpsesRate(n5) > ZomboidGlobals.FoodSicknessDecrease) {
                IsoBuilding isoBuilding = isoPlayer.getCurrentBuilding();
                IsoGridSquare isoGridSquare = this.calcSoundPos(n, n2, n3, isoBuilding);
                if (isoGridSquare == null) {
                    return;
                }
                if (this.emitters[isoPlayer.PlayerIndex] == null) {
                    this.emitters[isoPlayer.PlayerIndex] = new FadeEmitter();
                }
                FadeEmitter fadeEmitter = this.emitters[isoPlayer.PlayerIndex];
                if (fadeEmitter.emitter == null) {
                    fadeEmitter.emitter = IsoWorld.instance.getFreeEmitter(isoGridSquare.x, isoGridSquare.y, n3);
                    fadeEmitter.emitter.playSoundLoopedImpl("CorpseFlies");
                    fadeEmitter.emitter.setVolumeAll(0.0f);
                    fadeEmitter.volume = 0.0f;
                    FliesSound.this.fadeEmitters.add(fadeEmitter);
                } else {
                    fadeEmitter.sq.setHasFlies(false);
                    fadeEmitter.emitter.setPos(isoGridSquare.x, isoGridSquare.y, n3);
                    if (fadeEmitter.targetVolume != 1.0f && !FliesSound.this.fadeEmitters.contains(fadeEmitter)) {
                        FliesSound.this.fadeEmitters.add(fadeEmitter);
                    }
                }
                fadeEmitter.targetVolume = 1.0f;
                fadeEmitter.sq = isoGridSquare;
                isoGridSquare.setHasFlies(true);
            } else {
                FadeEmitter fadeEmitter = this.emitters[isoPlayer.PlayerIndex];
                if (fadeEmitter != null && fadeEmitter.emitter != null) {
                    if (!FliesSound.this.fadeEmitters.contains(fadeEmitter)) {
                        FliesSound.this.fadeEmitters.add(fadeEmitter);
                    }
                    fadeEmitter.targetVolume = 0.0f;
                    fadeEmitter.sq.setHasFlies(false);
                }
            }
        }

        void deref(IsoPlayer isoPlayer) {
            int n;
            int n2 = n = isoPlayer.PlayerIndex;
            this.refCount[n2] = this.refCount[n2] - 1;
            if (this.refCount[n] > 0) {
                return;
            }
            if (this.emitters[n] != null && this.emitters[n].emitter != null) {
                if (!FliesSound.this.fadeEmitters.contains(this.emitters[n])) {
                    FliesSound.this.fadeEmitters.add(this.emitters[n]);
                }
                this.emitters[n].targetVolume = 0.0f;
                this.emitters[n].sq.setHasFlies(false);
            }
        }

        void Reset() {
            this.corpseCount = 0;
            if (this.buildingCorpseCount != null) {
                this.buildingCorpseCount.clear();
            }
            for (int i = 0; i < 4; ++i) {
                this.refCount[i] = 0;
                if (this.emitters[i] == null) continue;
                this.emitters[i].Reset();
            }
        }
    }
}

