/*
 * Decompiled with CFR 0.152.
 */
package zombie;

import fmod.fmod.FMODSoundEmitter;
import fmod.fmod.FMOD_STUDIO_EVENT_CALLBACK;
import fmod.fmod.FMOD_STUDIO_EVENT_CALLBACK_TYPE;
import fmod.javafmod;
import java.util.ArrayDeque;
import java.util.ArrayList;
import org.joml.Vector2f;
import zombie.BaseAmbientStreamManager;
import zombie.GameTime;
import zombie.Lua.LuaEventManager;
import zombie.SandboxOptions;
import zombie.SoundManager;
import zombie.WorldSoundManager;
import zombie.audio.parameters.ParameterCameraZoom;
import zombie.audio.parameters.ParameterClosestWallDistance;
import zombie.audio.parameters.ParameterFogIntensity;
import zombie.audio.parameters.ParameterHardOfHearing;
import zombie.audio.parameters.ParameterInside;
import zombie.audio.parameters.ParameterMoodlePanic;
import zombie.audio.parameters.ParameterPowerSupply;
import zombie.audio.parameters.ParameterRainIntensity;
import zombie.audio.parameters.ParameterRoomSize;
import zombie.audio.parameters.ParameterRoomType;
import zombie.audio.parameters.ParameterSeason;
import zombie.audio.parameters.ParameterSnowIntensity;
import zombie.audio.parameters.ParameterStorm;
import zombie.audio.parameters.ParameterTemperature;
import zombie.audio.parameters.ParameterTimeOfDay;
import zombie.audio.parameters.ParameterWaterSupply;
import zombie.audio.parameters.ParameterWeatherEvent;
import zombie.audio.parameters.ParameterWindIntensity;
import zombie.audio.parameters.ParameterZone;
import zombie.audio.parameters.ParameterZoneWaterSide;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.math.PZMath;
import zombie.debug.DebugLog;
import zombie.debug.DebugType;
import zombie.input.Mouse;
import zombie.iso.Alarm;
import zombie.iso.BuildingDef;
import zombie.iso.IsoCamera;
import zombie.iso.IsoChunkMap;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMetaCell;
import zombie.iso.IsoMetaGrid;
import zombie.iso.IsoObject;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWorld;
import zombie.iso.RoomDef;
import zombie.iso.Vector2;
import zombie.iso.objects.RainManager;
import zombie.iso.weather.ClimateManager;
import zombie.network.GameClient;

public final class AmbientStreamManager
extends BaseAmbientStreamManager {
    public static int OneInAmbienceChance = 2500;
    public static int MaxAmbientCount = 20;
    public static float MaxRange = 1000.0f;
    private final ArrayList<Alarm> alarmList = new ArrayList();
    public static BaseAmbientStreamManager instance;
    public final ArrayList<Ambient> ambient = new ArrayList();
    public final ArrayList<WorldSoundEmitter> worldEmitters = new ArrayList();
    public final ArrayDeque<WorldSoundEmitter> freeEmitters = new ArrayDeque();
    public final ArrayList<AmbientLoop> allAmbient = new ArrayList();
    public final ArrayList<AmbientLoop> nightAmbient = new ArrayList();
    public final ArrayList<AmbientLoop> dayAmbient = new ArrayList();
    public final ArrayList<AmbientLoop> rainAmbient = new ArrayList();
    public final ArrayList<AmbientLoop> indoorAmbient = new ArrayList();
    public final ArrayList<AmbientLoop> outdoorAmbient = new ArrayList();
    public final ArrayList<AmbientLoop> windAmbient = new ArrayList();
    public boolean initialized = false;
    private FMODSoundEmitter electricityShutOffEmitter = null;
    private long electricityShutOffEvent = 0L;
    private int electricityShutOffState = -1;
    private final ParameterFogIntensity parameterFogIntensity = new ParameterFogIntensity();
    private final ParameterRainIntensity parameterRainIntensity = new ParameterRainIntensity();
    private final ParameterSeason parameterSeason = new ParameterSeason();
    private final ParameterSnowIntensity parameterSnowIntensity = new ParameterSnowIntensity();
    private final ParameterStorm parameterStorm = new ParameterStorm();
    private final ParameterTimeOfDay parameterTimeOfDay = new ParameterTimeOfDay();
    private final ParameterTemperature parameterTemperature = new ParameterTemperature();
    private final ParameterWeatherEvent parameterWeatherEvent = new ParameterWeatherEvent();
    private final ParameterWindIntensity parameterWindIntensity = new ParameterWindIntensity();
    private final ParameterZone parameterZoneDeepForest = new ParameterZone("ZoneDeepForest", "DeepForest");
    private final ParameterZone parameterZoneFarm = new ParameterZone("ZoneFarm", "Farm");
    private final ParameterZone parameterZoneForest = new ParameterZone("ZoneForest", "Forest");
    private final ParameterZone parameterZoneNav = new ParameterZone("ZoneNav", "Nav");
    private final ParameterZone parameterZoneTown = new ParameterZone("ZoneTown", "TownZone");
    private final ParameterZone parameterZoneTrailerPark = new ParameterZone("ZoneTrailerPark", "TrailerPark");
    private final ParameterZone parameterZoneVegetation = new ParameterZone("ZoneVegetation", "Vegitation");
    private final ParameterZoneWaterSide parameterZoneWaterSide = new ParameterZoneWaterSide();
    private final ParameterCameraZoom parameterCameraZoom = new ParameterCameraZoom();
    private final ParameterClosestWallDistance parameterClosestWallDistance = new ParameterClosestWallDistance();
    private final ParameterHardOfHearing parameterHardOfHearing = new ParameterHardOfHearing();
    private final ParameterInside parameterInside = new ParameterInside();
    private final ParameterMoodlePanic parameterMoodlePanic = new ParameterMoodlePanic();
    private final ParameterPowerSupply parameterPowerSupply = new ParameterPowerSupply();
    private final ParameterRoomSize parameterRoomSize = new ParameterRoomSize();
    private final ParameterRoomType parameterRoomType = new ParameterRoomType();
    private final ParameterWaterSupply parameterWaterSupply = new ParameterWaterSupply();
    private final Vector2 tempo = new Vector2();
    private final FMOD_STUDIO_EVENT_CALLBACK electricityShutOffEventCallback = new FMOD_STUDIO_EVENT_CALLBACK(){

        @Override
        public void timelineMarker(long l, String string, int n) {
            DebugLog.Sound.debugln("timelineMarker %s %d", string, n);
            if ("ElectricityOff".equals(string)) {
                IsoWorld.instance.setHydroPowerOn(false);
                AmbientStreamManager.this.checkHaveElectricity();
            }
        }
    };

    public static BaseAmbientStreamManager getInstance() {
        return instance;
    }

    @Override
    public void update() {
        int n;
        if (!this.initialized) {
            return;
        }
        if (GameTime.isGamePaused()) {
            return;
        }
        if (IsoPlayer.getInstance() == null) {
            return;
        }
        if (IsoPlayer.getInstance().getCurrentSquare() == null) {
            return;
        }
        this.updatePowerSupply();
        this.parameterFogIntensity.update();
        this.parameterRainIntensity.update();
        this.parameterSeason.update();
        this.parameterSnowIntensity.update();
        this.parameterStorm.update();
        this.parameterTemperature.update();
        this.parameterTimeOfDay.update();
        this.parameterWeatherEvent.update();
        this.parameterWindIntensity.update();
        this.parameterZoneDeepForest.update();
        this.parameterZoneFarm.update();
        this.parameterZoneForest.update();
        this.parameterZoneNav.update();
        this.parameterZoneVegetation.update();
        this.parameterZoneTown.update();
        this.parameterZoneTrailerPark.update();
        this.parameterZoneWaterSide.update();
        this.parameterCameraZoom.update();
        this.parameterClosestWallDistance.update();
        this.parameterHardOfHearing.update();
        this.parameterInside.update();
        this.parameterMoodlePanic.update();
        this.parameterPowerSupply.update();
        this.parameterRoomSize.update();
        this.parameterRoomType.update();
        this.parameterWaterSupply.update();
        float f = GameTime.instance.getTimeOfDay();
        for (int i = 0; i < this.worldEmitters.size(); ++i) {
            IsoGridSquare isoGridSquare;
            WorldSoundEmitter worldSoundEmitter = this.worldEmitters.get(i);
            if (worldSoundEmitter.daytime != null) {
                isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(worldSoundEmitter.x, worldSoundEmitter.y, worldSoundEmitter.z);
                if (isoGridSquare == null) {
                    worldSoundEmitter.fmodEmitter.stopAll();
                    SoundManager.instance.unregisterEmitter(worldSoundEmitter.fmodEmitter);
                    this.worldEmitters.remove(worldSoundEmitter);
                    this.freeEmitters.add(worldSoundEmitter);
                    --i;
                    continue;
                }
                if (f > worldSoundEmitter.dawn && f < worldSoundEmitter.dusk) {
                    if (worldSoundEmitter.fmodEmitter.isEmpty()) {
                        worldSoundEmitter.channel = worldSoundEmitter.fmodEmitter.playAmbientLoopedImpl(worldSoundEmitter.daytime);
                    }
                } else if (!worldSoundEmitter.fmodEmitter.isEmpty()) {
                    worldSoundEmitter.fmodEmitter.stopSound(worldSoundEmitter.channel);
                    worldSoundEmitter.channel = 0L;
                }
                if (worldSoundEmitter.fmodEmitter.isEmpty() || !IsoWorld.instance.emitterUpdate && !worldSoundEmitter.fmodEmitter.hasSoundsToStart()) continue;
                worldSoundEmitter.fmodEmitter.tick();
                continue;
            }
            if (IsoPlayer.getInstance() != null && IsoPlayer.getInstance().Traits.Deaf.isSet()) {
                worldSoundEmitter.fmodEmitter.stopAll();
                SoundManager.instance.unregisterEmitter(worldSoundEmitter.fmodEmitter);
                this.worldEmitters.remove(worldSoundEmitter);
                this.freeEmitters.add(worldSoundEmitter);
                --i;
                continue;
            }
            isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(worldSoundEmitter.x, worldSoundEmitter.y, worldSoundEmitter.z);
            if (isoGridSquare == null || worldSoundEmitter.fmodEmitter.isEmpty()) {
                worldSoundEmitter.fmodEmitter.stopAll();
                SoundManager.instance.unregisterEmitter(worldSoundEmitter.fmodEmitter);
                this.worldEmitters.remove(worldSoundEmitter);
                this.freeEmitters.add(worldSoundEmitter);
                --i;
                continue;
            }
            worldSoundEmitter.fmodEmitter.x = worldSoundEmitter.x;
            worldSoundEmitter.fmodEmitter.y = worldSoundEmitter.y;
            worldSoundEmitter.fmodEmitter.z = worldSoundEmitter.z;
            if (!IsoWorld.instance.emitterUpdate && !worldSoundEmitter.fmodEmitter.hasSoundsToStart()) continue;
            worldSoundEmitter.fmodEmitter.tick();
        }
        float f2 = GameTime.instance.getNight();
        boolean bl = IsoPlayer.getInstance().getCurrentSquare().isInARoom();
        boolean bl2 = RainManager.isRaining();
        for (n = 0; n < this.allAmbient.size(); ++n) {
            this.allAmbient.get((int)n).targVol = 1.0f;
        }
        for (n = 0; n < this.nightAmbient.size(); ++n) {
            this.nightAmbient.get((int)n).targVol *= f2;
        }
        for (n = 0; n < this.dayAmbient.size(); ++n) {
            this.dayAmbient.get((int)n).targVol *= 1.0f - f2;
        }
        for (n = 0; n < this.indoorAmbient.size(); ++n) {
            this.indoorAmbient.get((int)n).targVol = this.indoorAmbient.get((int)n).targVol * (bl ? 0.8f : 0.0f);
        }
        for (n = 0; n < this.outdoorAmbient.size(); ++n) {
            this.outdoorAmbient.get((int)n).targVol = this.outdoorAmbient.get((int)n).targVol * (bl ? 0.15f : 0.8f);
        }
        for (n = 0; n < this.rainAmbient.size(); ++n) {
            this.rainAmbient.get((int)n).targVol = this.rainAmbient.get((int)n).targVol * (bl2 ? 1.0f : 0.0f);
            if (this.rainAmbient.get((int)n).channel == 0L) continue;
            javafmod.FMOD_Studio_EventInstance_SetParameterByName(this.rainAmbient.get((int)n).channel, "RainIntensity", ClimateManager.getInstance().getPrecipitationIntensity());
        }
        for (n = 0; n < this.allAmbient.size(); ++n) {
            this.allAmbient.get(n).update();
        }
        for (n = 0; n < this.alarmList.size(); ++n) {
            this.alarmList.get(n).update();
            if (!this.alarmList.get((int)n).finished) continue;
            this.alarmList.remove(n);
            --n;
        }
        this.doOneShotAmbients();
    }

    @Override
    public void doOneShotAmbients() {
        for (int i = 0; i < this.ambient.size(); ++i) {
            Ambient ambient = this.ambient.get(i);
            if (ambient.finished()) {
                DebugLog.log(DebugType.Sound, "ambient: removing ambient sound " + ambient.name);
                this.ambient.remove(i--);
                continue;
            }
            ambient.update();
        }
    }

    @Override
    public void addRandomAmbient() {
        Object object;
        if (Core.GameMode.equals("LastStand") || Core.GameMode.equals("Tutorial")) {
            return;
        }
        ArrayList<IsoPlayer> arrayList = new ArrayList<IsoPlayer>();
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            object = IsoPlayer.players[i];
            if (object == null || !((IsoGameCharacter)object).isAlive()) continue;
            arrayList.add((IsoPlayer)object);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        IsoPlayer isoPlayer = (IsoPlayer)arrayList.get(Rand.Next(arrayList.size()));
        object = "";
        if (GameTime.instance.getHour() > 7 && GameTime.instance.getHour() < 21) {
            switch (Rand.Next(3)) {
                case 0: {
                    if (Rand.Next(10) >= 2) break;
                    object = "MetaDogBark";
                    break;
                }
                case 1: {
                    if (Rand.Next(10) >= 3) break;
                    object = "MetaScream";
                }
            }
        } else {
            switch (Rand.Next(5)) {
                case 0: {
                    if (Rand.Next(10) >= 2) break;
                    object = "MetaDogBark";
                    break;
                }
                case 1: {
                    if (Rand.Next(13) >= 3) break;
                    object = "MetaScream";
                    break;
                }
                case 2: {
                    object = "MetaOwl";
                    break;
                }
                case 3: {
                    object = "MetaWolfHowl";
                }
            }
        }
        if (((String)object).isEmpty()) {
            return;
        }
        float f = isoPlayer.x;
        float f2 = isoPlayer.y;
        double d = Rand.Next((float)(-Math.PI), (float)Math.PI);
        this.tempo.x = (float)Math.cos(d);
        this.tempo.y = (float)Math.sin(d);
        this.tempo.setLength(1000.0f);
        f += this.tempo.x;
        f2 += this.tempo.y;
        if (!GameClient.bClient) {
            System.out.println("playing ambient: " + (String)object + " at dist: " + Math.abs(f - isoPlayer.x) + "," + Math.abs(f2 - isoPlayer.y));
            Ambient ambient = new Ambient((String)object, f, f2, 50.0f, Rand.Next(0.2f, 0.5f));
            this.ambient.add(ambient);
        }
    }

    @Override
    public void addBlend(String string, float f, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        AmbientLoop ambientLoop = new AmbientLoop(0.0f, string, f);
        this.allAmbient.add(ambientLoop);
        if (bl) {
            this.indoorAmbient.add(ambientLoop);
        } else {
            this.outdoorAmbient.add(ambientLoop);
        }
        if (bl2) {
            this.rainAmbient.add(ambientLoop);
        }
        if (bl3) {
            this.nightAmbient.add(ambientLoop);
        }
        if (bl4) {
            this.dayAmbient.add(ambientLoop);
        }
    }

    @Override
    public void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
    }

    @Override
    public void doGunEvent() {
        Object object;
        ArrayList<IsoPlayer> arrayList = new ArrayList<IsoPlayer>();
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            object = IsoPlayer.players[i];
            if (object == null || !((IsoGameCharacter)object).isAlive()) continue;
            arrayList.add((IsoPlayer)object);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        IsoPlayer isoPlayer = (IsoPlayer)arrayList.get(Rand.Next(arrayList.size()));
        object = null;
        switch (Rand.Next(6)) {
            case 0: {
                object = "MetaAssaultRifle1";
                break;
            }
            case 1: {
                object = "MetaPistol1";
                break;
            }
            case 2: {
                object = "MetaShotgun1";
                break;
            }
            case 3: {
                object = "MetaPistol2";
                break;
            }
            case 4: {
                object = "MetaPistol3";
                break;
            }
            case 5: {
                object = "MetaShotgun1";
            }
        }
        float f = isoPlayer.x;
        float f2 = isoPlayer.y;
        int n = 600;
        double d = Rand.Next((float)(-Math.PI), (float)Math.PI);
        this.tempo.x = (float)Math.cos(d);
        this.tempo.y = (float)Math.sin(d);
        this.tempo.setLength(n - 100);
        WorldSoundManager.instance.addSound(null, (int)(f += this.tempo.x), (int)(f2 += this.tempo.y), 0, n, n);
        float f3 = 1.0f;
        Ambient ambient = new Ambient((String)object, f, f2, 700.0f, f3);
        this.ambient.add(ambient);
    }

    @Override
    public void doAlarm(RoomDef roomDef) {
        if (roomDef != null && roomDef.building != null && roomDef.building.bAlarmed) {
            roomDef.building.bAlarmed = false;
            roomDef.building.setAllExplored(true);
            this.alarmList.add(new Alarm(roomDef.x + roomDef.getW() / 2, roomDef.y + roomDef.getH() / 2));
        }
    }

    @Override
    public void stop() {
        for (AmbientLoop ambientLoop : this.allAmbient) {
            ambientLoop.stop();
        }
        this.allAmbient.clear();
        this.ambient.clear();
        this.dayAmbient.clear();
        this.indoorAmbient.clear();
        this.nightAmbient.clear();
        this.outdoorAmbient.clear();
        this.rainAmbient.clear();
        this.windAmbient.clear();
        this.alarmList.clear();
        if (this.electricityShutOffEmitter != null) {
            this.electricityShutOffEmitter.stopAll();
            this.electricityShutOffEvent = 0L;
        }
        this.electricityShutOffState = -1;
        this.initialized = false;
    }

    @Override
    public void addAmbient(String string, int n, int n2, int n3, float f) {
        if (!GameClient.bClient) {
            return;
        }
        Ambient ambient = new Ambient(string, n, n2, n3, f, true);
        this.ambient.add(ambient);
    }

    @Override
    public void addAmbientEmitter(float f, float f2, int n, String string) {
        WorldSoundEmitter worldSoundEmitter = this.freeEmitters.isEmpty() ? new WorldSoundEmitter() : this.freeEmitters.pop();
        worldSoundEmitter.x = f;
        worldSoundEmitter.y = f2;
        worldSoundEmitter.z = n;
        worldSoundEmitter.daytime = null;
        if (worldSoundEmitter.fmodEmitter == null) {
            worldSoundEmitter.fmodEmitter = new FMODSoundEmitter();
        }
        worldSoundEmitter.fmodEmitter.x = f;
        worldSoundEmitter.fmodEmitter.y = f2;
        worldSoundEmitter.fmodEmitter.z = n;
        worldSoundEmitter.channel = worldSoundEmitter.fmodEmitter.playAmbientLoopedImpl(string);
        worldSoundEmitter.fmodEmitter.randomStart();
        SoundManager.instance.registerEmitter(worldSoundEmitter.fmodEmitter);
        this.worldEmitters.add(worldSoundEmitter);
    }

    @Override
    public void addDaytimeAmbientEmitter(float f, float f2, int n, String string) {
        WorldSoundEmitter worldSoundEmitter = this.freeEmitters.isEmpty() ? new WorldSoundEmitter() : this.freeEmitters.pop();
        worldSoundEmitter.x = f;
        worldSoundEmitter.y = f2;
        worldSoundEmitter.z = n;
        if (worldSoundEmitter.fmodEmitter == null) {
            worldSoundEmitter.fmodEmitter = new FMODSoundEmitter();
        }
        worldSoundEmitter.fmodEmitter.x = f;
        worldSoundEmitter.fmodEmitter.y = f2;
        worldSoundEmitter.fmodEmitter.z = n;
        worldSoundEmitter.daytime = string;
        worldSoundEmitter.dawn = Rand.Next(7.0f, 8.0f);
        worldSoundEmitter.dusk = Rand.Next(19.0f, 20.0f);
        SoundManager.instance.registerEmitter(worldSoundEmitter.fmodEmitter);
        this.worldEmitters.add(worldSoundEmitter);
    }

    private void updatePowerSupply() {
        boolean bl;
        boolean bl2 = bl = GameTime.getInstance().NightsSurvived < SandboxOptions.getInstance().getElecShutModifier();
        if (this.electricityShutOffState == -1) {
            IsoWorld.instance.setHydroPowerOn(bl);
        }
        if (this.electricityShutOffState == 0 && bl) {
            IsoWorld.instance.setHydroPowerOn(true);
            this.checkHaveElectricity();
        }
        if (this.electricityShutOffState == 1 && !bl) {
            if (this.electricityShutOffEmitter == null) {
                this.electricityShutOffEmitter = new FMODSoundEmitter();
            }
            if (!this.electricityShutOffEmitter.isPlaying(this.electricityShutOffEvent)) {
                Vector2f vector2f = new Vector2f();
                this.getListenerPos(vector2f);
                BuildingDef buildingDef = this.getNearestBuilding(vector2f.x, vector2f.y, vector2f);
                if (buildingDef == null) {
                    this.electricityShutOffEmitter.setPos(-1000.0f, -1000.0f, 0.0f);
                } else {
                    this.electricityShutOffEmitter.setPos(vector2f.x, vector2f.y, 0.0f);
                }
                this.electricityShutOffEvent = this.electricityShutOffEmitter.playSound("WorldEventElectricityShutdown");
                if (this.electricityShutOffEvent != 0L) {
                    javafmod.FMOD_Studio_EventInstance_SetCallback(this.electricityShutOffEvent, this.electricityShutOffEventCallback, FMOD_STUDIO_EVENT_CALLBACK_TYPE.FMOD_STUDIO_EVENT_CALLBACK_TIMELINE_MARKER.bit);
                }
            }
        }
        int n = this.electricityShutOffState = bl ? 1 : 0;
        if (this.electricityShutOffEmitter != null) {
            this.electricityShutOffEmitter.tick();
        }
    }

    private void checkHaveElectricity() {
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            IsoChunkMap isoChunkMap = IsoWorld.instance.CurrentCell.ChunkMap[i];
            if (isoChunkMap.ignore) continue;
            for (int j = 0; j < 8; ++j) {
                for (int k = isoChunkMap.getWorldYMinTiles(); k <= isoChunkMap.getWorldYMaxTiles(); ++k) {
                    for (int i2 = isoChunkMap.getWorldXMinTiles(); i2 <= isoChunkMap.getWorldXMaxTiles(); ++i2) {
                        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(i2, k, j);
                        if (isoGridSquare == null) continue;
                        for (int i3 = 0; i3 < isoGridSquare.getObjects().size(); ++i3) {
                            IsoObject isoObject = isoGridSquare.getObjects().get(i3);
                            isoObject.checkHaveElectricity();
                        }
                    }
                }
            }
        }
    }

    public BuildingDef getNearestBuilding(float f, float f2, Vector2f vector2f) {
        IsoMetaGrid isoMetaGrid = IsoWorld.instance.getMetaGrid();
        int n = PZMath.fastfloor(f / 300.0f);
        int n2 = PZMath.fastfloor(f2 / 300.0f);
        BuildingDef buildingDef = null;
        float f3 = Float.MAX_VALUE;
        vector2f.set(0.0f);
        Vector2f vector2f2 = new Vector2f();
        for (int i = n2 - 1; i <= n2 + 1; ++i) {
            for (int j = n - 1; j <= n + 1; ++j) {
                IsoMetaCell isoMetaCell = isoMetaGrid.getCellData(j, i);
                if (isoMetaCell == null || isoMetaCell.info == null) continue;
                for (BuildingDef buildingDef2 : isoMetaCell.info.Buildings) {
                    float f4 = buildingDef2.getClosestPoint(f, f2, vector2f2);
                    if (!(f4 < f3)) continue;
                    f3 = f4;
                    buildingDef = buildingDef2;
                    vector2f.set(vector2f2);
                }
            }
        }
        return buildingDef;
    }

    private void getListenerPos(Vector2f vector2f) {
        IsoGameCharacter isoGameCharacter = null;
        vector2f.set(0.0f);
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            IsoPlayer isoPlayer = IsoPlayer.players[i];
            if (isoPlayer == null || isoGameCharacter != null && (!isoGameCharacter.isDead() || !isoPlayer.isAlive()) && (!isoGameCharacter.Traits.Deaf.isSet() || isoPlayer.Traits.Deaf.isSet())) continue;
            isoGameCharacter = isoPlayer;
            vector2f.set(isoGameCharacter.getX(), isoGameCharacter.getY());
        }
    }

    public static final class WorldSoundEmitter {
        public FMODSoundEmitter fmodEmitter;
        public float x;
        public float y;
        public float z;
        public long channel = -1L;
        public String daytime;
        public float dawn;
        public float dusk;
    }

    public static final class AmbientLoop {
        public static float volChangeAmount = 0.01f;
        public float targVol;
        public float currVol;
        public String name;
        public float volumedelta = 1.0f;
        public long channel = -1L;
        public final FMODSoundEmitter emitter = new FMODSoundEmitter();

        public AmbientLoop(float f, String string, float f2) {
            this.volumedelta = f2;
            this.channel = this.emitter.playAmbientLoopedImpl(string);
            this.targVol = f;
            this.currVol = 0.0f;
            this.update();
        }

        public void update() {
            if (this.targVol > this.currVol) {
                this.currVol += volChangeAmount;
                if (this.currVol > this.targVol) {
                    this.currVol = this.targVol;
                }
            }
            if (this.targVol < this.currVol) {
                this.currVol -= volChangeAmount;
                if (this.currVol < this.targVol) {
                    this.currVol = this.targVol;
                }
            }
            this.emitter.setVolumeAll(this.currVol * this.volumedelta);
            this.emitter.tick();
        }

        public void stop() {
            this.emitter.stopAll();
        }
    }

    public static final class Ambient {
        public float x;
        public float y;
        public String name;
        float radius;
        float volume;
        int worldSoundRadius;
        int worldSoundVolume;
        public boolean trackMouse = false;
        final FMODSoundEmitter emitter = new FMODSoundEmitter();

        public Ambient(String string, float f, float f2, float f3, float f4) {
            this(string, f, f2, f3, f4, false);
        }

        public Ambient(String string, float f, float f2, float f3, float f4, boolean bl) {
            this.name = string;
            this.x = f;
            this.y = f2;
            this.radius = f3;
            this.volume = f4;
            this.emitter.x = f;
            this.emitter.y = f2;
            this.emitter.z = 0.0f;
            this.emitter.playAmbientSound(string);
            this.update();
            LuaEventManager.triggerEvent("OnAmbientSound", string, Float.valueOf(f), Float.valueOf(f2));
        }

        public boolean finished() {
            return this.emitter.isEmpty();
        }

        public void update() {
            this.emitter.tick();
            if (this.trackMouse && IsoPlayer.getInstance() != null) {
                float f = Mouse.getXA();
                float f2 = Mouse.getYA();
                f -= (float)IsoCamera.getScreenLeft(IsoPlayer.getPlayerIndex());
                f2 -= (float)IsoCamera.getScreenTop(IsoPlayer.getPlayerIndex());
                int n = (int)IsoPlayer.getInstance().getZ();
                this.emitter.x = (int)IsoUtils.XToIso(f *= Core.getInstance().getZoom(IsoPlayer.getPlayerIndex()), f2 *= Core.getInstance().getZoom(IsoPlayer.getPlayerIndex()), n);
                this.emitter.y = (int)IsoUtils.YToIso(f, f2, n);
            }
            if (!GameClient.bClient && this.worldSoundRadius > 0 && this.worldSoundVolume > 0) {
                WorldSoundManager.instance.addSound(null, (int)this.x, (int)this.y, 0, this.worldSoundRadius, this.worldSoundVolume);
            }
        }

        public void repeatWorldSounds(int n, int n2) {
            this.worldSoundRadius = n;
            this.worldSoundVolume = n2;
        }

        private IsoGameCharacter getClosestListener(float f, float f2) {
            IsoPlayer isoPlayer = null;
            float f3 = Float.MAX_VALUE;
            for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                IsoPlayer isoPlayer2 = IsoPlayer.players[i];
                if (isoPlayer2 == null || isoPlayer2.getCurrentSquare() == null) continue;
                float f4 = isoPlayer2.getX();
                float f5 = isoPlayer2.getY();
                float f6 = IsoUtils.DistanceToSquared(f4, f5, f, f2);
                if (isoPlayer2.Traits.HardOfHearing.isSet()) {
                    f6 *= 4.5f;
                }
                if (isoPlayer2.Traits.Deaf.isSet()) {
                    f6 = Float.MAX_VALUE;
                }
                if (!(f6 < f3)) continue;
                isoPlayer = isoPlayer2;
                f3 = f6;
            }
            return isoPlayer;
        }
    }
}

