/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.input;

import org.lwjgl.glfw.GLFW;
import org.lwjglx.LWJGLException;
import org.lwjglx.Sys;
import org.lwjglx.input.Cursor;
import org.lwjglx.input.EventQueue;
import org.lwjglx.opengl.Display;

public class Mouse {
    private static boolean grabbed = false;
    private static int lastX = 0;
    private static int lastY = 0;
    private static int latestX = 0;
    private static int latestY = 0;
    private static int x = 0;
    private static int y = 0;
    private static EventQueue queue = new EventQueue(32);
    private static int[] buttonEvents = new int[queue.getMaxEvents()];
    private static boolean[] buttonEventStates = new boolean[queue.getMaxEvents()];
    private static int[] xEvents = new int[queue.getMaxEvents()];
    private static int[] yEvents = new int[queue.getMaxEvents()];
    private static int[] lastxEvents = new int[queue.getMaxEvents()];
    private static int[] lastyEvents = new int[queue.getMaxEvents()];
    private static long[] nanoTimeEvents = new long[queue.getMaxEvents()];
    private static boolean clipPostionToDisplay = true;
    static double scrollxpos = 0.0;
    static double scrollypos = 0.0;

    public static void addMoveEvent(double d, double d2) {
        latestX = (int)d;
        latestY = Display.getHeight() - (int)d2;
        Mouse.lastxEvents[Mouse.queue.getNextPos()] = xEvents[queue.getNextPos()];
        Mouse.lastyEvents[Mouse.queue.getNextPos()] = yEvents[queue.getNextPos()];
        Mouse.xEvents[Mouse.queue.getNextPos()] = latestX;
        Mouse.yEvents[Mouse.queue.getNextPos()] = latestY;
        Mouse.buttonEvents[Mouse.queue.getNextPos()] = -1;
        Mouse.buttonEventStates[Mouse.queue.getNextPos()] = false;
        Mouse.nanoTimeEvents[Mouse.queue.getNextPos()] = Sys.getNanoTime();
        queue.add();
    }

    public static void addButtonEvent(int n, boolean bl) {
        Mouse.lastxEvents[Mouse.queue.getNextPos()] = xEvents[queue.getNextPos()];
        Mouse.lastyEvents[Mouse.queue.getNextPos()] = yEvents[queue.getNextPos()];
        Mouse.xEvents[Mouse.queue.getNextPos()] = latestX;
        Mouse.yEvents[Mouse.queue.getNextPos()] = latestY;
        Mouse.buttonEvents[Mouse.queue.getNextPos()] = n;
        Mouse.buttonEventStates[Mouse.queue.getNextPos()] = bl;
        Mouse.nanoTimeEvents[Mouse.queue.getNextPos()] = Sys.getNanoTime();
        queue.add();
    }

    public static void poll() {
        if (!grabbed) {
            // empty if block
        }
        lastX = x;
        lastY = y;
        if (!grabbed && clipPostionToDisplay) {
            if (latestX < 0) {
                latestX = 0;
            }
            if (latestY < 0) {
                latestY = 0;
            }
            if (latestX > Display.getWidth() - 1) {
                latestX = Display.getWidth() - 1;
            }
            if (latestY > Display.getHeight() - 1) {
                latestY = Display.getHeight() - 1;
            }
        }
        x = latestX;
        y = latestY;
    }

    public static void create() throws LWJGLException {
    }

    public static boolean isCreated() {
        return Display.isCreated();
    }

    public static void setGrabbed(boolean bl) {
        GLFW.glfwSetInputMode((long)Display.getWindow(), (int)208897, (int)(bl ? 212995 : 212993));
        grabbed = bl;
    }

    public static boolean isGrabbed() {
        return grabbed;
    }

    public static boolean isButtonDown(int n) {
        return GLFW.glfwGetMouseButton((long)Display.getWindow(), (int)n) == 1;
    }

    public static boolean next() {
        return queue.next();
    }

    public static int getEventX() {
        return xEvents[queue.getCurrentPos()];
    }

    public static int getEventY() {
        return yEvents[queue.getCurrentPos()];
    }

    public static int getEventDX() {
        return xEvents[queue.getCurrentPos()] - lastxEvents[queue.getCurrentPos()];
    }

    public static int getEventDY() {
        return yEvents[queue.getCurrentPos()] - lastyEvents[queue.getCurrentPos()];
    }

    public static long getEventNanoseconds() {
        return nanoTimeEvents[queue.getCurrentPos()];
    }

    public static int getEventButton() {
        return buttonEvents[queue.getCurrentPos()];
    }

    public static boolean getEventButtonState() {
        return buttonEventStates[queue.getCurrentPos()];
    }

    public static int getEventDWheel() {
        return 0;
    }

    public static int getX() {
        return x;
    }

    public static int getY() {
        return y;
    }

    public static int getDX() {
        return x - lastX;
    }

    public static int getDY() {
        return y - lastY;
    }

    public static int getDWheel() {
        int n = (int)scrollypos;
        scrollypos = 0.0;
        return n;
    }

    public static int getButtonCount() {
        return 8;
    }

    public static void setClipMouseCoordinatesToWindow(boolean bl) {
        clipPostionToDisplay = bl;
    }

    public static void setCursorPosition(int n, int n2) {
        GLFW.glfwSetCursorPos((long)Display.getWindow(), (double)n, (double)n2);
    }

    public static Cursor setNativeCursor(Cursor cursor) throws LWJGLException {
        GLFW.glfwSetCursor((long)Display.getWindow(), (long)cursor.getHandle());
        return null;
    }

    public static void destroy() {
    }

    public static void updateCursor() {
    }

    public static void setDWheel(double d, double d2) {
        scrollypos += d2;
        scrollxpos += d;
    }
}

