/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.input;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWGamepadState;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjglx.input.GamepadState;

public final class Controller {
    private final String joystickName;
    private final String gamepadName;
    private final int buttonsCount;
    private final int axisCount;
    private final int hatCount;
    private final int id;
    private final boolean isGamepad;
    private final String guid;
    private final float[] deadZone;
    public GamepadState gamepadState = null;
    private static final String[] axisNames = new String[]{"left stick X", "left stick Y", "right stick X", "right stick Y", "left trigger", "right trigger"};
    private static final String[] buttonNames = new String[]{"A", "B", "X", "Y", "left bumper", "right bumper", "back", "start", "guide", "left stick", "right stick", "d-pad up", "d-pad right", "d-pad down", "d-pad left"};

    public Controller(int n) {
        Buffer buffer;
        this.id = n;
        Object object = GLFW.glfwGetJoystickName((int)n);
        if (object == null) {
            object = "ControllerName" + n;
        }
        this.joystickName = object;
        Object object2 = GLFW.glfwGetGamepadName((int)n);
        if (object2 == null) {
            object2 = "GamepadName" + n;
        }
        this.gamepadName = object2;
        this.isGamepad = GLFW.glfwJoystickIsGamepad((int)n);
        if (this.isGamepad) {
            this.axisCount = 6;
            this.buttonsCount = 15;
        } else {
            buffer = GLFW.glfwGetJoystickAxes((int)n);
            this.axisCount = buffer == null ? 0 : buffer.remaining();
            ByteBuffer byteBuffer = GLFW.glfwGetJoystickButtons((int)n);
            this.buttonsCount = byteBuffer == null ? 0 : byteBuffer.remaining();
        }
        buffer = GLFW.glfwGetJoystickHats((int)n);
        this.hatCount = buffer == null ? 0 : buffer.remaining();
        this.guid = GLFW.glfwGetJoystickGUID((int)n);
        this.deadZone = new float[this.axisCount];
        Arrays.fill(this.deadZone, 0.2f);
    }

    public int getID() {
        return this.id;
    }

    public String getGUID() {
        return this.guid;
    }

    public boolean isGamepad() {
        return this.isGamepad;
    }

    public String getJoystickName() {
        return this.joystickName;
    }

    public String getGamepadName() {
        return this.gamepadName;
    }

    public int getAxisCount() {
        return this.axisCount;
    }

    public float getAxisValue(int n) {
        if (this.gamepadState == null || !this.gamepadState.bPolled) {
            return 0.0f;
        }
        if (n < 0 || n >= 15) {
            return 0.0f;
        }
        return this.gamepadState.axesButtons.axes(n);
    }

    public int getButtonCount() {
        return this.buttonsCount;
    }

    public int getHatCount() {
        return this.hatCount;
    }

    public int getHatState() {
        if (this.gamepadState == null || !this.gamepadState.bPolled) {
            return 0;
        }
        return this.gamepadState.hatState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer getJoystickHats(int n, ByteBuffer byteBuffer) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        IntBuffer intBuffer = memoryStack.callocInt(1);
        try {
            long l = GLFW.nglfwGetJoystickHats((int)n, (long)MemoryUtil.memAddress((IntBuffer)intBuffer));
            byteBuffer.clear();
            byteBuffer.limit(intBuffer.get(0));
            if (l != 0L) {
                MemoryUtil.memCopy((long)l, (long)MemoryUtil.memAddress((ByteBuffer)byteBuffer), (long)intBuffer.get(0));
            }
            ByteBuffer byteBuffer2 = byteBuffer;
            return byteBuffer2;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public String getAxisName(int n) {
        return axisNames[n];
    }

    public float getXAxisValue() {
        return this.getAxisValue(0);
    }

    public float getYAxisValue() {
        return this.getAxisValue(1);
    }

    public float getDeadZone(int n) {
        return this.deadZone[n];
    }

    public void setDeadZone(int n, float f) {
        this.deadZone[n] = f;
    }

    public float getPovX() {
        if (this.gamepadState == null || !this.gamepadState.bPolled) {
            return 0.0f;
        }
        if ((this.gamepadState.hatState & 8) != 0) {
            return -1.0f;
        }
        if ((this.gamepadState.hatState & 2) != 0) {
            return 1.0f;
        }
        return 0.0f;
    }

    public float getPovY() {
        if (this.gamepadState == null || !this.gamepadState.bPolled) {
            return 0.0f;
        }
        if ((this.gamepadState.hatState & 1) != 0) {
            return -1.0f;
        }
        if ((this.gamepadState.hatState & 4) != 0) {
            return 1.0f;
        }
        return 0.0f;
    }

    public boolean isButtonPressed(int n) {
        if (this.gamepadState == null || !this.gamepadState.bPolled) {
            return false;
        }
        if (n < 0 || n >= 15) {
            return false;
        }
        return this.gamepadState.axesButtons.buttons(n) == 1;
    }

    public boolean isButtonRelease(int n) {
        if (this.gamepadState == null || !this.gamepadState.bPolled) {
            return false;
        }
        if (n < 0 || n >= 15) {
            return false;
        }
        return this.gamepadState.axesButtons.buttons(n) == 0;
    }

    public String getButtonName(int n) {
        if (n >= buttonNames.length) {
            return "Extra button " + (n - buttonNames.length + 1);
        }
        return buttonNames[n];
    }

    public void poll(GamepadState gamepadState) {
        if (GLFW.glfwGetGamepadState((int)this.id, (GLFWGamepadState)gamepadState.axesButtons)) {
            gamepadState.bPolled = true;
            ByteBuffer byteBuffer = this.getJoystickHats(this.id, gamepadState.hats);
            gamepadState.hatState = byteBuffer.remaining() == 0 ? 0 : (int)byteBuffer.get(0);
        } else {
            gamepadState.bPolled = false;
        }
    }
}

