/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public final class BufferUtils {
    public static ByteBuffer createByteBuffer(int n) {
        return ByteBuffer.allocateDirect(n).order(ByteOrder.nativeOrder());
    }

    public static ShortBuffer createShortBuffer(int n) {
        return BufferUtils.createByteBuffer(n << 1).asShortBuffer();
    }

    public static CharBuffer createCharBuffer(int n) {
        return BufferUtils.createByteBuffer(n << 1).asCharBuffer();
    }

    public static IntBuffer createIntBuffer(int n) {
        return BufferUtils.createByteBuffer(n << 2).asIntBuffer();
    }

    public static LongBuffer createLongBuffer(int n) {
        return BufferUtils.createByteBuffer(n << 3).asLongBuffer();
    }

    public static FloatBuffer createFloatBuffer(int n) {
        return BufferUtils.createByteBuffer(n << 2).asFloatBuffer();
    }

    public static DoubleBuffer createDoubleBuffer(int n) {
        return BufferUtils.createByteBuffer(n << 3).asDoubleBuffer();
    }

    public static int getElementSizeExponent(Buffer buffer) {
        if (buffer instanceof ByteBuffer) {
            return 0;
        }
        if (buffer instanceof ShortBuffer || buffer instanceof CharBuffer) {
            return 1;
        }
        if (buffer instanceof FloatBuffer || buffer instanceof IntBuffer) {
            return 2;
        }
        if (buffer instanceof LongBuffer || buffer instanceof DoubleBuffer) {
            return 3;
        }
        throw new IllegalStateException("Unsupported buffer type: " + buffer);
    }

    public static int getOffset(Buffer buffer) {
        return buffer.position() << BufferUtils.getElementSizeExponent(buffer);
    }

    public static void zeroBuffer(ByteBuffer byteBuffer) {
        BufferUtils.zeroBuffer0(byteBuffer, byteBuffer.position(), byteBuffer.remaining());
    }

    public static void zeroBuffer(ShortBuffer shortBuffer) {
        BufferUtils.zeroBuffer0(shortBuffer, (long)shortBuffer.position() * 2L, (long)shortBuffer.remaining() * 2L);
    }

    public static void zeroBuffer(CharBuffer charBuffer) {
        BufferUtils.zeroBuffer0(charBuffer, (long)charBuffer.position() * 2L, (long)charBuffer.remaining() * 2L);
    }

    public static void zeroBuffer(IntBuffer intBuffer) {
        BufferUtils.zeroBuffer0(intBuffer, (long)intBuffer.position() * 4L, (long)intBuffer.remaining() * 4L);
    }

    public static void zeroBuffer(FloatBuffer floatBuffer) {
        BufferUtils.zeroBuffer0(floatBuffer, (long)floatBuffer.position() * 4L, (long)floatBuffer.remaining() * 4L);
    }

    public static void zeroBuffer(LongBuffer longBuffer) {
        BufferUtils.zeroBuffer0(longBuffer, (long)longBuffer.position() * 8L, (long)longBuffer.remaining() * 8L);
    }

    public static void zeroBuffer(DoubleBuffer doubleBuffer) {
        BufferUtils.zeroBuffer0(doubleBuffer, (long)doubleBuffer.position() * 8L, (long)doubleBuffer.remaining() * 8L);
    }

    private static native void zeroBuffer0(Buffer var0, long var1, long var3);

    static native long getBufferAddress(Buffer var0);
}

