/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.text.NumberFormat;
import org.joml.Math;
import org.joml.Matrix3dc;
import org.joml.Matrix3fc;
import org.joml.Matrix3x2dc;
import org.joml.Matrix3x2fc;
import org.joml.Matrix4dc;
import org.joml.Matrix4fc;
import org.joml.Matrix4x3dc;
import org.joml.Matrix4x3fc;
import org.joml.MemUtil;
import org.joml.Options;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Runtime;
import org.joml.Vector2dc;
import org.joml.Vector2fc;
import org.joml.Vector2ic;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector3i;
import org.joml.Vector3ic;

public class Vector3d
implements Externalizable,
Vector3dc {
    private static final long serialVersionUID = 1L;
    public double x;
    public double y;
    public double z;

    public Vector3d() {
    }

    public Vector3d(double d) {
        this.x = d;
        this.y = d;
        this.z = d;
    }

    public Vector3d(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public Vector3d(Vector3fc vector3fc) {
        this.x = vector3fc.x();
        this.y = vector3fc.y();
        this.z = vector3fc.z();
    }

    public Vector3d(Vector3ic vector3ic) {
        this.x = vector3ic.x();
        this.y = vector3ic.y();
        this.z = vector3ic.z();
    }

    public Vector3d(Vector2fc vector2fc, double d) {
        this.x = vector2fc.x();
        this.y = vector2fc.y();
        this.z = d;
    }

    public Vector3d(Vector2ic vector2ic, double d) {
        this.x = vector2ic.x();
        this.y = vector2ic.y();
        this.z = d;
    }

    public Vector3d(Vector3dc vector3dc) {
        this.x = vector3dc.x();
        this.y = vector3dc.y();
        this.z = vector3dc.z();
    }

    public Vector3d(Vector2dc vector2dc, double d) {
        this.x = vector2dc.x();
        this.y = vector2dc.y();
        this.z = d;
    }

    public Vector3d(double[] dArray) {
        this.x = dArray[0];
        this.y = dArray[1];
        this.z = dArray[2];
    }

    public Vector3d(float[] fArray) {
        this.x = fArray[0];
        this.y = fArray[1];
        this.z = fArray[2];
    }

    public Vector3d(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
    }

    public Vector3d(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, n, byteBuffer);
    }

    public Vector3d(DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.get(this, doubleBuffer.position(), doubleBuffer);
    }

    public Vector3d(int n, DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.get(this, n, doubleBuffer);
    }

    @Override
    public double x() {
        return this.x;
    }

    @Override
    public double y() {
        return this.y;
    }

    @Override
    public double z() {
        return this.z;
    }

    public Vector3d set(Vector3dc vector3dc) {
        this.x = vector3dc.x();
        this.y = vector3dc.y();
        this.z = vector3dc.z();
        return this;
    }

    public Vector3d set(Vector3ic vector3ic) {
        this.x = vector3ic.x();
        this.y = vector3ic.y();
        this.z = vector3ic.z();
        return this;
    }

    public Vector3d set(Vector2dc vector2dc, double d) {
        this.x = vector2dc.x();
        this.y = vector2dc.y();
        this.z = d;
        return this;
    }

    public Vector3d set(Vector2ic vector2ic, double d) {
        this.x = vector2ic.x();
        this.y = vector2ic.y();
        this.z = d;
        return this;
    }

    public Vector3d set(Vector3fc vector3fc) {
        this.x = vector3fc.x();
        this.y = vector3fc.y();
        this.z = vector3fc.z();
        return this;
    }

    public Vector3d set(Vector2fc vector2fc, double d) {
        this.x = vector2fc.x();
        this.y = vector2fc.y();
        this.z = d;
        return this;
    }

    public Vector3d set(double d) {
        this.x = d;
        this.y = d;
        this.z = d;
        return this;
    }

    public Vector3d set(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        return this;
    }

    public Vector3d set(double[] dArray) {
        this.x = dArray[0];
        this.y = dArray[1];
        this.z = dArray[2];
        return this;
    }

    public Vector3d set(float[] fArray) {
        this.x = fArray[0];
        this.y = fArray[1];
        this.z = fArray[2];
        return this;
    }

    public Vector3d set(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
        return this;
    }

    public Vector3d set(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, n, byteBuffer);
        return this;
    }

    public Vector3d set(DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.get(this, doubleBuffer.position(), doubleBuffer);
        return this;
    }

    public Vector3d set(int n, DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.get(this, n, doubleBuffer);
        return this;
    }

    public Vector3d setFromAddress(long l) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil.MemUtilUnsafe.get(this, l);
        return this;
    }

    public Vector3d setComponent(int n, double d) throws IllegalArgumentException {
        switch (n) {
            case 0: {
                this.x = d;
                break;
            }
            case 1: {
                this.y = d;
                break;
            }
            case 2: {
                this.z = d;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this;
    }

    @Override
    public ByteBuffer get(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, byteBuffer.position(), byteBuffer);
        return byteBuffer;
    }

    @Override
    public ByteBuffer get(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, n, byteBuffer);
        return byteBuffer;
    }

    @Override
    public DoubleBuffer get(DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.put(this, doubleBuffer.position(), doubleBuffer);
        return doubleBuffer;
    }

    @Override
    public DoubleBuffer get(int n, DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.put(this, n, doubleBuffer);
        return doubleBuffer;
    }

    @Override
    public ByteBuffer getf(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.putf(this, byteBuffer.position(), byteBuffer);
        return byteBuffer;
    }

    @Override
    public ByteBuffer getf(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.putf(this, n, byteBuffer);
        return byteBuffer;
    }

    @Override
    public FloatBuffer get(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.put(this, floatBuffer.position(), floatBuffer);
        return floatBuffer;
    }

    @Override
    public FloatBuffer get(int n, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.put(this, n, floatBuffer);
        return floatBuffer;
    }

    @Override
    public Vector3dc getToAddress(long l) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil.MemUtilUnsafe.put(this, l);
        return this;
    }

    public Vector3d sub(Vector3dc vector3dc) {
        this.x -= vector3dc.x();
        this.y -= vector3dc.y();
        this.z -= vector3dc.z();
        return this;
    }

    @Override
    public Vector3d sub(Vector3dc vector3dc, Vector3d vector3d) {
        vector3d.x = this.x - vector3dc.x();
        vector3d.y = this.y - vector3dc.y();
        vector3d.z = this.z - vector3dc.z();
        return vector3d;
    }

    public Vector3d sub(Vector3fc vector3fc) {
        this.x -= (double)vector3fc.x();
        this.y -= (double)vector3fc.y();
        this.z -= (double)vector3fc.z();
        return this;
    }

    @Override
    public Vector3d sub(Vector3fc vector3fc, Vector3d vector3d) {
        vector3d.x = this.x - (double)vector3fc.x();
        vector3d.y = this.y - (double)vector3fc.y();
        vector3d.z = this.z - (double)vector3fc.z();
        return vector3d;
    }

    public Vector3d sub(double d, double d2, double d3) {
        this.x -= d;
        this.y -= d2;
        this.z -= d3;
        return this;
    }

    @Override
    public Vector3d sub(double d, double d2, double d3, Vector3d vector3d) {
        vector3d.x = this.x - d;
        vector3d.y = this.y - d2;
        vector3d.z = this.z - d3;
        return vector3d;
    }

    public Vector3d add(Vector3dc vector3dc) {
        this.x += vector3dc.x();
        this.y += vector3dc.y();
        this.z += vector3dc.z();
        return this;
    }

    @Override
    public Vector3d add(Vector3dc vector3dc, Vector3d vector3d) {
        vector3d.x = this.x + vector3dc.x();
        vector3d.y = this.y + vector3dc.y();
        vector3d.z = this.z + vector3dc.z();
        return vector3d;
    }

    public Vector3d add(Vector3fc vector3fc) {
        this.x += (double)vector3fc.x();
        this.y += (double)vector3fc.y();
        this.z += (double)vector3fc.z();
        return this;
    }

    @Override
    public Vector3d add(Vector3fc vector3fc, Vector3d vector3d) {
        vector3d.x = this.x + (double)vector3fc.x();
        vector3d.y = this.y + (double)vector3fc.y();
        vector3d.z = this.z + (double)vector3fc.z();
        return vector3d;
    }

    public Vector3d add(double d, double d2, double d3) {
        this.x += d;
        this.y += d2;
        this.z += d3;
        return this;
    }

    @Override
    public Vector3d add(double d, double d2, double d3, Vector3d vector3d) {
        vector3d.x = this.x + d;
        vector3d.y = this.y + d2;
        vector3d.z = this.z + d3;
        return vector3d;
    }

    public Vector3d fma(Vector3dc vector3dc, Vector3dc vector3dc2) {
        this.x = Math.fma(vector3dc.x(), vector3dc2.x(), this.x);
        this.y = Math.fma(vector3dc.y(), vector3dc2.y(), this.y);
        this.z = Math.fma(vector3dc.z(), vector3dc2.z(), this.z);
        return this;
    }

    public Vector3d fma(double d, Vector3dc vector3dc) {
        this.x = Math.fma(d, vector3dc.x(), this.x);
        this.y = Math.fma(d, vector3dc.y(), this.y);
        this.z = Math.fma(d, vector3dc.z(), this.z);
        return this;
    }

    public Vector3d fma(Vector3fc vector3fc, Vector3fc vector3fc2) {
        this.x = Math.fma((double)vector3fc.x(), (double)vector3fc2.x(), this.x);
        this.y = Math.fma((double)vector3fc.y(), (double)vector3fc2.y(), this.y);
        this.z = Math.fma((double)vector3fc.z(), (double)vector3fc2.z(), this.z);
        return this;
    }

    @Override
    public Vector3d fma(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3d vector3d) {
        vector3d.x = Math.fma((double)vector3fc.x(), (double)vector3fc2.x(), this.x);
        vector3d.y = Math.fma((double)vector3fc.y(), (double)vector3fc2.y(), this.y);
        vector3d.z = Math.fma((double)vector3fc.z(), (double)vector3fc2.z(), this.z);
        return vector3d;
    }

    public Vector3d fma(double d, Vector3fc vector3fc) {
        this.x = Math.fma(d, (double)vector3fc.x(), this.x);
        this.y = Math.fma(d, (double)vector3fc.y(), this.y);
        this.z = Math.fma(d, (double)vector3fc.z(), this.z);
        return this;
    }

    @Override
    public Vector3d fma(Vector3dc vector3dc, Vector3dc vector3dc2, Vector3d vector3d) {
        vector3d.x = Math.fma(vector3dc.x(), vector3dc2.x(), this.x);
        vector3d.y = Math.fma(vector3dc.y(), vector3dc2.y(), this.y);
        vector3d.z = Math.fma(vector3dc.z(), vector3dc2.z(), this.z);
        return vector3d;
    }

    @Override
    public Vector3d fma(double d, Vector3dc vector3dc, Vector3d vector3d) {
        vector3d.x = Math.fma(d, vector3dc.x(), this.x);
        vector3d.y = Math.fma(d, vector3dc.y(), this.y);
        vector3d.z = Math.fma(d, vector3dc.z(), this.z);
        return vector3d;
    }

    @Override
    public Vector3d fma(Vector3dc vector3dc, Vector3fc vector3fc, Vector3d vector3d) {
        vector3d.x = Math.fma(vector3dc.x(), (double)vector3fc.x(), this.x);
        vector3d.y = Math.fma(vector3dc.y(), (double)vector3fc.y(), this.y);
        vector3d.z = Math.fma(vector3dc.z(), (double)vector3fc.z(), this.z);
        return vector3d;
    }

    @Override
    public Vector3d fma(double d, Vector3fc vector3fc, Vector3d vector3d) {
        vector3d.x = Math.fma(d, (double)vector3fc.x(), this.x);
        vector3d.y = Math.fma(d, (double)vector3fc.y(), this.y);
        vector3d.z = Math.fma(d, (double)vector3fc.z(), this.z);
        return vector3d;
    }

    public Vector3d mulAdd(Vector3dc vector3dc, Vector3dc vector3dc2) {
        this.x = Math.fma(this.x, vector3dc.x(), vector3dc2.x());
        this.y = Math.fma(this.y, vector3dc.y(), vector3dc2.y());
        this.z = Math.fma(this.z, vector3dc.z(), vector3dc2.z());
        return this;
    }

    public Vector3d mulAdd(double d, Vector3dc vector3dc) {
        this.x = Math.fma(this.x, d, vector3dc.x());
        this.y = Math.fma(this.y, d, vector3dc.y());
        this.z = Math.fma(this.z, d, vector3dc.z());
        return this;
    }

    @Override
    public Vector3d mulAdd(Vector3dc vector3dc, Vector3dc vector3dc2, Vector3d vector3d) {
        vector3d.x = Math.fma(this.x, vector3dc.x(), vector3dc2.x());
        vector3d.y = Math.fma(this.y, vector3dc.y(), vector3dc2.y());
        vector3d.z = Math.fma(this.z, vector3dc.z(), vector3dc2.z());
        return vector3d;
    }

    @Override
    public Vector3d mulAdd(double d, Vector3dc vector3dc, Vector3d vector3d) {
        vector3d.x = Math.fma(this.x, d, vector3dc.x());
        vector3d.y = Math.fma(this.y, d, vector3dc.y());
        vector3d.z = Math.fma(this.z, d, vector3dc.z());
        return vector3d;
    }

    @Override
    public Vector3d mulAdd(Vector3fc vector3fc, Vector3dc vector3dc, Vector3d vector3d) {
        vector3d.x = Math.fma(this.x, (double)vector3fc.x(), vector3dc.x());
        vector3d.y = Math.fma(this.y, (double)vector3fc.y(), vector3dc.y());
        vector3d.z = Math.fma(this.z, (double)vector3fc.z(), vector3dc.z());
        return vector3d;
    }

    public Vector3d mul(Vector3dc vector3dc) {
        this.x *= vector3dc.x();
        this.y *= vector3dc.y();
        this.z *= vector3dc.z();
        return this;
    }

    public Vector3d mul(Vector3fc vector3fc) {
        this.x *= (double)vector3fc.x();
        this.y *= (double)vector3fc.y();
        this.z *= (double)vector3fc.z();
        return this;
    }

    @Override
    public Vector3d mul(Vector3fc vector3fc, Vector3d vector3d) {
        vector3d.x = this.x * (double)vector3fc.x();
        vector3d.y = this.y * (double)vector3fc.y();
        vector3d.z = this.z * (double)vector3fc.z();
        return vector3d;
    }

    @Override
    public Vector3d mul(Vector3dc vector3dc, Vector3d vector3d) {
        vector3d.x = this.x * vector3dc.x();
        vector3d.y = this.y * vector3dc.y();
        vector3d.z = this.z * vector3dc.z();
        return vector3d;
    }

    public Vector3d div(Vector3d vector3d) {
        this.x /= vector3d.x();
        this.y /= vector3d.y();
        this.z /= vector3d.z();
        return this;
    }

    public Vector3d div(Vector3fc vector3fc) {
        this.x /= (double)vector3fc.x();
        this.y /= (double)vector3fc.y();
        this.z /= (double)vector3fc.z();
        return this;
    }

    @Override
    public Vector3d div(Vector3fc vector3fc, Vector3d vector3d) {
        vector3d.x = this.x / (double)vector3fc.x();
        vector3d.y = this.y / (double)vector3fc.y();
        vector3d.z = this.z / (double)vector3fc.z();
        return vector3d;
    }

    @Override
    public Vector3d div(Vector3dc vector3dc, Vector3d vector3d) {
        vector3d.x = this.x / vector3dc.x();
        vector3d.y = this.y / vector3dc.y();
        vector3d.z = this.z / vector3dc.z();
        return vector3d;
    }

    @Override
    public Vector3d mulProject(Matrix4dc matrix4dc, double d, Vector3d vector3d) {
        double d2 = 1.0 / Math.fma(matrix4dc.m03(), this.x, Math.fma(matrix4dc.m13(), this.y, Math.fma(matrix4dc.m23(), this.z, matrix4dc.m33() * d)));
        double d3 = Math.fma(matrix4dc.m00(), this.x, Math.fma(matrix4dc.m10(), this.y, Math.fma(matrix4dc.m20(), this.z, matrix4dc.m30() * d))) * d2;
        double d4 = Math.fma(matrix4dc.m01(), this.x, Math.fma(matrix4dc.m11(), this.y, Math.fma(matrix4dc.m21(), this.z, matrix4dc.m31() * d))) * d2;
        double d5 = Math.fma(matrix4dc.m02(), this.x, Math.fma(matrix4dc.m12(), this.y, Math.fma(matrix4dc.m22(), this.z, matrix4dc.m32() * d))) * d2;
        vector3d.x = d3;
        vector3d.y = d4;
        vector3d.z = d5;
        return vector3d;
    }

    @Override
    public Vector3d mulProject(Matrix4dc matrix4dc, Vector3d vector3d) {
        double d = 1.0 / Math.fma(matrix4dc.m03(), this.x, Math.fma(matrix4dc.m13(), this.y, Math.fma(matrix4dc.m23(), this.z, matrix4dc.m33())));
        double d2 = Math.fma(matrix4dc.m00(), this.x, Math.fma(matrix4dc.m10(), this.y, Math.fma(matrix4dc.m20(), this.z, matrix4dc.m30()))) * d;
        double d3 = Math.fma(matrix4dc.m01(), this.x, Math.fma(matrix4dc.m11(), this.y, Math.fma(matrix4dc.m21(), this.z, matrix4dc.m31()))) * d;
        double d4 = Math.fma(matrix4dc.m02(), this.x, Math.fma(matrix4dc.m12(), this.y, Math.fma(matrix4dc.m22(), this.z, matrix4dc.m32()))) * d;
        vector3d.x = d2;
        vector3d.y = d3;
        vector3d.z = d4;
        return vector3d;
    }

    public Vector3d mulProject(Matrix4dc matrix4dc) {
        double d = 1.0 / Math.fma(matrix4dc.m03(), this.x, Math.fma(matrix4dc.m13(), this.y, Math.fma(matrix4dc.m23(), this.z, matrix4dc.m33())));
        double d2 = Math.fma(matrix4dc.m00(), this.x, Math.fma(matrix4dc.m10(), this.y, Math.fma(matrix4dc.m20(), this.z, matrix4dc.m30()))) * d;
        double d3 = Math.fma(matrix4dc.m01(), this.x, Math.fma(matrix4dc.m11(), this.y, Math.fma(matrix4dc.m21(), this.z, matrix4dc.m31()))) * d;
        double d4 = Math.fma(matrix4dc.m02(), this.x, Math.fma(matrix4dc.m12(), this.y, Math.fma(matrix4dc.m22(), this.z, matrix4dc.m32()))) * d;
        this.x = d2;
        this.y = d3;
        this.z = d4;
        return this;
    }

    @Override
    public Vector3d mulProject(Matrix4fc matrix4fc, Vector3d vector3d) {
        double d = 1.0 / Math.fma((double)matrix4fc.m03(), this.x, Math.fma((double)matrix4fc.m13(), this.y, Math.fma((double)matrix4fc.m23(), this.z, (double)matrix4fc.m33())));
        double d2 = ((double)matrix4fc.m00() * this.x + (double)matrix4fc.m10() * this.y + (double)matrix4fc.m20() * this.z + (double)matrix4fc.m30()) * d;
        double d3 = ((double)matrix4fc.m01() * this.x + (double)matrix4fc.m11() * this.y + (double)matrix4fc.m21() * this.z + (double)matrix4fc.m31()) * d;
        double d4 = ((double)matrix4fc.m02() * this.x + (double)matrix4fc.m12() * this.y + (double)matrix4fc.m22() * this.z + (double)matrix4fc.m32()) * d;
        vector3d.x = d2;
        vector3d.y = d3;
        vector3d.z = d4;
        return vector3d;
    }

    public Vector3d mulProject(Matrix4fc matrix4fc) {
        double d = 1.0 / Math.fma((double)matrix4fc.m03(), this.x, Math.fma((double)matrix4fc.m13(), this.y, Math.fma((double)matrix4fc.m23(), this.z, (double)matrix4fc.m33())));
        double d2 = ((double)matrix4fc.m00() * this.x + (double)matrix4fc.m10() * this.y + (double)matrix4fc.m20() * this.z + (double)matrix4fc.m30()) * d;
        double d3 = ((double)matrix4fc.m01() * this.x + (double)matrix4fc.m11() * this.y + (double)matrix4fc.m21() * this.z + (double)matrix4fc.m31()) * d;
        double d4 = ((double)matrix4fc.m02() * this.x + (double)matrix4fc.m12() * this.y + (double)matrix4fc.m22() * this.z + (double)matrix4fc.m32()) * d;
        this.x = d2;
        this.y = d3;
        this.z = d4;
        return this;
    }

    public Vector3d mul(Matrix3fc matrix3fc) {
        double d = Math.fma((double)matrix3fc.m00(), this.x, Math.fma((double)matrix3fc.m10(), this.y, (double)matrix3fc.m20() * this.z));
        double d2 = Math.fma((double)matrix3fc.m01(), this.x, Math.fma((double)matrix3fc.m11(), this.y, (double)matrix3fc.m21() * this.z));
        double d3 = Math.fma((double)matrix3fc.m02(), this.x, Math.fma((double)matrix3fc.m12(), this.y, (double)matrix3fc.m22() * this.z));
        this.x = d;
        this.y = d2;
        this.z = d3;
        return this;
    }

    public Vector3d mul(Matrix3dc matrix3dc) {
        double d = Math.fma(matrix3dc.m00(), this.x, Math.fma(matrix3dc.m10(), this.y, matrix3dc.m20() * this.z));
        double d2 = Math.fma(matrix3dc.m01(), this.x, Math.fma(matrix3dc.m11(), this.y, matrix3dc.m21() * this.z));
        double d3 = Math.fma(matrix3dc.m02(), this.x, Math.fma(matrix3dc.m12(), this.y, matrix3dc.m22() * this.z));
        this.x = d;
        this.y = d2;
        this.z = d3;
        return this;
    }

    @Override
    public Vector3d mul(Matrix3dc matrix3dc, Vector3d vector3d) {
        double d = Math.fma(matrix3dc.m00(), this.x, Math.fma(matrix3dc.m10(), this.y, matrix3dc.m20() * this.z));
        double d2 = Math.fma(matrix3dc.m01(), this.x, Math.fma(matrix3dc.m11(), this.y, matrix3dc.m21() * this.z));
        double d3 = Math.fma(matrix3dc.m02(), this.x, Math.fma(matrix3dc.m12(), this.y, matrix3dc.m22() * this.z));
        vector3d.x = d;
        vector3d.y = d2;
        vector3d.z = d3;
        return vector3d;
    }

    @Override
    public Vector3f mul(Matrix3dc matrix3dc, Vector3f vector3f) {
        double d = Math.fma(matrix3dc.m00(), this.x, Math.fma(matrix3dc.m10(), this.y, matrix3dc.m20() * this.z));
        double d2 = Math.fma(matrix3dc.m01(), this.x, Math.fma(matrix3dc.m11(), this.y, matrix3dc.m21() * this.z));
        double d3 = Math.fma(matrix3dc.m02(), this.x, Math.fma(matrix3dc.m12(), this.y, matrix3dc.m22() * this.z));
        vector3f.x = (float)d;
        vector3f.y = (float)d2;
        vector3f.z = (float)d3;
        return vector3f;
    }

    @Override
    public Vector3d mul(Matrix3fc matrix3fc, Vector3d vector3d) {
        double d = Math.fma((double)matrix3fc.m00(), this.x, Math.fma((double)matrix3fc.m10(), this.y, (double)matrix3fc.m20() * this.z));
        double d2 = Math.fma((double)matrix3fc.m01(), this.x, Math.fma((double)matrix3fc.m11(), this.y, (double)matrix3fc.m21() * this.z));
        double d3 = Math.fma((double)matrix3fc.m02(), this.x, Math.fma((double)matrix3fc.m12(), this.y, (double)matrix3fc.m22() * this.z));
        vector3d.x = d;
        vector3d.y = d2;
        vector3d.z = d3;
        return vector3d;
    }

    public Vector3d mul(Matrix3x2dc matrix3x2dc) {
        double d = Math.fma(matrix3x2dc.m00(), this.x, Math.fma(matrix3x2dc.m10(), this.y, matrix3x2dc.m20() * this.z));
        double d2 = Math.fma(matrix3x2dc.m01(), this.x, Math.fma(matrix3x2dc.m11(), this.y, matrix3x2dc.m21() * this.z));
        this.x = d;
        this.y = d2;
        return this;
    }

    @Override
    public Vector3d mul(Matrix3x2dc matrix3x2dc, Vector3d vector3d) {
        double d = Math.fma(matrix3x2dc.m00(), this.x, Math.fma(matrix3x2dc.m10(), this.y, matrix3x2dc.m20() * this.z));
        double d2 = Math.fma(matrix3x2dc.m01(), this.x, Math.fma(matrix3x2dc.m11(), this.y, matrix3x2dc.m21() * this.z));
        vector3d.x = d;
        vector3d.y = d2;
        vector3d.z = this.z;
        return vector3d;
    }

    public Vector3d mul(Matrix3x2fc matrix3x2fc) {
        double d = Math.fma((double)matrix3x2fc.m00(), this.x, Math.fma((double)matrix3x2fc.m10(), this.y, (double)matrix3x2fc.m20() * this.z));
        double d2 = Math.fma((double)matrix3x2fc.m01(), this.x, Math.fma((double)matrix3x2fc.m11(), this.y, (double)matrix3x2fc.m21() * this.z));
        this.x = d;
        this.y = d2;
        return this;
    }

    @Override
    public Vector3d mul(Matrix3x2fc matrix3x2fc, Vector3d vector3d) {
        double d = Math.fma((double)matrix3x2fc.m00(), this.x, Math.fma((double)matrix3x2fc.m10(), this.y, (double)matrix3x2fc.m20() * this.z));
        double d2 = Math.fma((double)matrix3x2fc.m01(), this.x, Math.fma((double)matrix3x2fc.m11(), this.y, (double)matrix3x2fc.m21() * this.z));
        vector3d.x = d;
        vector3d.y = d2;
        vector3d.z = this.z;
        return vector3d;
    }

    public Vector3d mulTranspose(Matrix3dc matrix3dc) {
        double d = Math.fma(matrix3dc.m00(), this.x, Math.fma(matrix3dc.m01(), this.y, matrix3dc.m02() * this.z));
        double d2 = Math.fma(matrix3dc.m10(), this.x, Math.fma(matrix3dc.m11(), this.y, matrix3dc.m12() * this.z));
        double d3 = Math.fma(matrix3dc.m20(), this.x, Math.fma(matrix3dc.m21(), this.y, matrix3dc.m22() * this.z));
        this.x = d;
        this.y = d2;
        this.z = d3;
        return this;
    }

    @Override
    public Vector3d mulTranspose(Matrix3dc matrix3dc, Vector3d vector3d) {
        double d = Math.fma(matrix3dc.m00(), this.x, Math.fma(matrix3dc.m01(), this.y, matrix3dc.m02() * this.z));
        double d2 = Math.fma(matrix3dc.m10(), this.x, Math.fma(matrix3dc.m11(), this.y, matrix3dc.m12() * this.z));
        double d3 = Math.fma(matrix3dc.m20(), this.x, Math.fma(matrix3dc.m21(), this.y, matrix3dc.m22() * this.z));
        vector3d.x = d;
        vector3d.y = d2;
        vector3d.z = d3;
        return vector3d;
    }

    public Vector3d mulTranspose(Matrix3fc matrix3fc) {
        double d = Math.fma((double)matrix3fc.m00(), this.x, Math.fma((double)matrix3fc.m01(), this.y, (double)matrix3fc.m02() * this.z));
        double d2 = Math.fma((double)matrix3fc.m10(), this.x, Math.fma((double)matrix3fc.m11(), this.y, (double)matrix3fc.m12() * this.z));
        double d3 = Math.fma((double)matrix3fc.m20(), this.x, Math.fma((double)matrix3fc.m21(), this.y, (double)matrix3fc.m22() * this.z));
        this.x = d;
        this.y = d2;
        this.z = d3;
        return this;
    }

    @Override
    public Vector3d mulTranspose(Matrix3fc matrix3fc, Vector3d vector3d) {
        double d = Math.fma((double)matrix3fc.m00(), this.x, Math.fma((double)matrix3fc.m01(), this.y, (double)matrix3fc.m02() * this.z));
        double d2 = Math.fma((double)matrix3fc.m10(), this.x, Math.fma((double)matrix3fc.m11(), this.y, (double)matrix3fc.m12() * this.z));
        double d3 = Math.fma((double)matrix3fc.m20(), this.x, Math.fma((double)matrix3fc.m21(), this.y, (double)matrix3fc.m22() * this.z));
        vector3d.x = d;
        vector3d.y = d2;
        vector3d.z = d3;
        return vector3d;
    }

    public Vector3d mulPosition(Matrix4fc matrix4fc) {
        double d = Math.fma((double)matrix4fc.m00(), this.x, Math.fma((double)matrix4fc.m10(), this.y, Math.fma((double)matrix4fc.m20(), this.z, (double)matrix4fc.m30())));
        double d2 = Math.fma((double)matrix4fc.m01(), this.x, Math.fma((double)matrix4fc.m11(), this.y, Math.fma((double)matrix4fc.m21(), this.z, (double)matrix4fc.m31())));
        double d3 = Math.fma((double)matrix4fc.m02(), this.x, Math.fma((double)matrix4fc.m12(), this.y, Math.fma((double)matrix4fc.m22(), this.z, (double)matrix4fc.m32())));
        this.x = d;
        this.y = d2;
        this.z = d3;
        return this;
    }

    public Vector3d mulPosition(Matrix4dc matrix4dc) {
        double d = Math.fma(matrix4dc.m00(), this.x, Math.fma(matrix4dc.m10(), this.y, Math.fma(matrix4dc.m20(), this.z, matrix4dc.m30())));
        double d2 = Math.fma(matrix4dc.m01(), this.x, Math.fma(matrix4dc.m11(), this.y, Math.fma(matrix4dc.m21(), this.z, matrix4dc.m31())));
        double d3 = Math.fma(matrix4dc.m02(), this.x, Math.fma(matrix4dc.m12(), this.y, Math.fma(matrix4dc.m22(), this.z, matrix4dc.m32())));
        this.x = d;
        this.y = d2;
        this.z = d3;
        return this;
    }

    public Vector3d mulPosition(Matrix4x3dc matrix4x3dc) {
        double d = Math.fma(matrix4x3dc.m00(), this.x, Math.fma(matrix4x3dc.m10(), this.y, Math.fma(matrix4x3dc.m20(), this.z, matrix4x3dc.m30())));
        double d2 = Math.fma(matrix4x3dc.m01(), this.x, Math.fma(matrix4x3dc.m11(), this.y, Math.fma(matrix4x3dc.m21(), this.z, matrix4x3dc.m31())));
        double d3 = Math.fma(matrix4x3dc.m02(), this.x, Math.fma(matrix4x3dc.m12(), this.y, Math.fma(matrix4x3dc.m22(), this.z, matrix4x3dc.m32())));
        this.x = d;
        this.y = d2;
        this.z = d3;
        return this;
    }

    public Vector3d mulPosition(Matrix4x3fc matrix4x3fc) {
        double d = Math.fma((double)matrix4x3fc.m00(), this.x, Math.fma((double)matrix4x3fc.m10(), this.y, Math.fma((double)matrix4x3fc.m20(), this.z, (double)matrix4x3fc.m30())));
        double d2 = Math.fma((double)matrix4x3fc.m01(), this.x, Math.fma((double)matrix4x3fc.m11(), this.y, Math.fma((double)matrix4x3fc.m21(), this.z, (double)matrix4x3fc.m31())));
        double d3 = Math.fma((double)matrix4x3fc.m02(), this.x, Math.fma((double)matrix4x3fc.m12(), this.y, Math.fma((double)matrix4x3fc.m22(), this.z, (double)matrix4x3fc.m32())));
        this.x = d;
        this.y = d2;
        this.z = d3;
        return this;
    }

    @Override
    public Vector3d mulPosition(Matrix4dc matrix4dc, Vector3d vector3d) {
        double d = Math.fma(matrix4dc.m00(), this.x, Math.fma(matrix4dc.m10(), this.y, Math.fma(matrix4dc.m20(), this.z, matrix4dc.m30())));
        double d2 = Math.fma(matrix4dc.m01(), this.x, Math.fma(matrix4dc.m11(), this.y, Math.fma(matrix4dc.m21(), this.z, matrix4dc.m31())));
        double d3 = Math.fma(matrix4dc.m02(), this.x, Math.fma(matrix4dc.m12(), this.y, Math.fma(matrix4dc.m22(), this.z, matrix4dc.m32())));
        vector3d.x = d;
        vector3d.y = d2;
        vector3d.z = d3;
        return vector3d;
    }

    @Override
    public Vector3d mulPosition(Matrix4fc matrix4fc, Vector3d vector3d) {
        double d = Math.fma((double)matrix4fc.m00(), this.x, Math.fma((double)matrix4fc.m10(), this.y, Math.fma((double)matrix4fc.m20(), this.z, (double)matrix4fc.m30())));
        double d2 = Math.fma((double)matrix4fc.m01(), this.x, Math.fma((double)matrix4fc.m11(), this.y, Math.fma((double)matrix4fc.m21(), this.z, (double)matrix4fc.m31())));
        double d3 = Math.fma((double)matrix4fc.m02(), this.x, Math.fma((double)matrix4fc.m12(), this.y, Math.fma((double)matrix4fc.m22(), this.z, (double)matrix4fc.m32())));
        vector3d.x = d;
        vector3d.y = d2;
        vector3d.z = d3;
        return vector3d;
    }

    @Override
    public Vector3d mulPosition(Matrix4x3dc matrix4x3dc, Vector3d vector3d) {
        double d = Math.fma(matrix4x3dc.m00(), this.x, Math.fma(matrix4x3dc.m10(), this.y, Math.fma(matrix4x3dc.m20(), this.z, matrix4x3dc.m30())));
        double d2 = Math.fma(matrix4x3dc.m01(), this.x, Math.fma(matrix4x3dc.m11(), this.y, Math.fma(matrix4x3dc.m21(), this.z, matrix4x3dc.m31())));
        double d3 = Math.fma(matrix4x3dc.m02(), this.x, Math.fma(matrix4x3dc.m12(), this.y, Math.fma(matrix4x3dc.m22(), this.z, matrix4x3dc.m32())));
        vector3d.x = d;
        vector3d.y = d2;
        vector3d.z = d3;
        return vector3d;
    }

    @Override
    public Vector3d mulPosition(Matrix4x3fc matrix4x3fc, Vector3d vector3d) {
        double d = Math.fma((double)matrix4x3fc.m00(), this.x, Math.fma((double)matrix4x3fc.m10(), this.y, Math.fma((double)matrix4x3fc.m20(), this.z, (double)matrix4x3fc.m30())));
        double d2 = Math.fma((double)matrix4x3fc.m01(), this.x, Math.fma((double)matrix4x3fc.m11(), this.y, Math.fma((double)matrix4x3fc.m21(), this.z, (double)matrix4x3fc.m31())));
        double d3 = Math.fma((double)matrix4x3fc.m02(), this.x, Math.fma((double)matrix4x3fc.m12(), this.y, Math.fma((double)matrix4x3fc.m22(), this.z, (double)matrix4x3fc.m32())));
        vector3d.x = d;
        vector3d.y = d2;
        vector3d.z = d3;
        return vector3d;
    }

    public Vector3d mulTransposePosition(Matrix4dc matrix4dc) {
        double d = Math.fma(matrix4dc.m00(), this.x, Math.fma(matrix4dc.m01(), this.y, Math.fma(matrix4dc.m02(), this.z, matrix4dc.m03())));
        double d2 = Math.fma(matrix4dc.m10(), this.x, Math.fma(matrix4dc.m11(), this.y, Math.fma(matrix4dc.m12(), this.z, matrix4dc.m13())));
        double d3 = Math.fma(matrix4dc.m20(), this.x, Math.fma(matrix4dc.m21(), this.y, Math.fma(matrix4dc.m22(), this.z, matrix4dc.m23())));
        this.x = d;
        this.y = d2;
        this.z = d3;
        return this;
    }

    @Override
    public Vector3d mulTransposePosition(Matrix4dc matrix4dc, Vector3d vector3d) {
        double d = Math.fma(matrix4dc.m00(), this.x, Math.fma(matrix4dc.m01(), this.y, Math.fma(matrix4dc.m02(), this.z, matrix4dc.m03())));
        double d2 = Math.fma(matrix4dc.m10(), this.x, Math.fma(matrix4dc.m11(), this.y, Math.fma(matrix4dc.m12(), this.z, matrix4dc.m13())));
        double d3 = Math.fma(matrix4dc.m20(), this.x, Math.fma(matrix4dc.m21(), this.y, Math.fma(matrix4dc.m22(), this.z, matrix4dc.m23())));
        vector3d.x = d;
        vector3d.y = d2;
        vector3d.z = d3;
        return vector3d;
    }

    public Vector3d mulTransposePosition(Matrix4fc matrix4fc) {
        double d = Math.fma((double)matrix4fc.m00(), this.x, Math.fma((double)matrix4fc.m01(), this.y, Math.fma((double)matrix4fc.m02(), this.z, (double)matrix4fc.m03())));
        double d2 = Math.fma((double)matrix4fc.m10(), this.x, Math.fma((double)matrix4fc.m11(), this.y, Math.fma((double)matrix4fc.m12(), this.z, (double)matrix4fc.m13())));
        double d3 = Math.fma((double)matrix4fc.m20(), this.x, Math.fma((double)matrix4fc.m21(), this.y, Math.fma((double)matrix4fc.m22(), this.z, (double)matrix4fc.m23())));
        this.x = d;
        this.y = d2;
        this.z = d3;
        return this;
    }

    @Override
    public Vector3d mulTransposePosition(Matrix4fc matrix4fc, Vector3d vector3d) {
        double d = Math.fma((double)matrix4fc.m00(), this.x, Math.fma((double)matrix4fc.m01(), this.y, Math.fma((double)matrix4fc.m02(), this.z, (double)matrix4fc.m03())));
        double d2 = Math.fma((double)matrix4fc.m10(), this.x, Math.fma((double)matrix4fc.m11(), this.y, Math.fma((double)matrix4fc.m12(), this.z, (double)matrix4fc.m13())));
        double d3 = Math.fma((double)matrix4fc.m20(), this.x, Math.fma((double)matrix4fc.m21(), this.y, Math.fma((double)matrix4fc.m22(), this.z, (double)matrix4fc.m23())));
        vector3d.x = d;
        vector3d.y = d2;
        vector3d.z = d3;
        return vector3d;
    }

    public double mulPositionW(Matrix4fc matrix4fc) {
        double d = Math.fma((double)matrix4fc.m03(), this.x, Math.fma((double)matrix4fc.m13(), this.y, Math.fma((double)matrix4fc.m23(), this.z, (double)matrix4fc.m33())));
        double d2 = Math.fma((double)matrix4fc.m00(), this.x, Math.fma((double)matrix4fc.m10(), this.y, Math.fma((double)matrix4fc.m20(), this.z, (double)matrix4fc.m30())));
        double d3 = Math.fma((double)matrix4fc.m01(), this.x, Math.fma((double)matrix4fc.m11(), this.y, Math.fma((double)matrix4fc.m21(), this.z, (double)matrix4fc.m31())));
        double d4 = Math.fma((double)matrix4fc.m02(), this.x, Math.fma((double)matrix4fc.m12(), this.y, Math.fma((double)matrix4fc.m22(), this.z, (double)matrix4fc.m32())));
        this.x = d2;
        this.y = d3;
        this.z = d4;
        return d;
    }

    @Override
    public double mulPositionW(Matrix4fc matrix4fc, Vector3d vector3d) {
        double d = Math.fma((double)matrix4fc.m03(), this.x, Math.fma((double)matrix4fc.m13(), this.y, Math.fma((double)matrix4fc.m23(), this.z, (double)matrix4fc.m33())));
        double d2 = Math.fma((double)matrix4fc.m00(), this.x, Math.fma((double)matrix4fc.m10(), this.y, Math.fma((double)matrix4fc.m20(), this.z, (double)matrix4fc.m30())));
        double d3 = Math.fma((double)matrix4fc.m01(), this.x, Math.fma((double)matrix4fc.m11(), this.y, Math.fma((double)matrix4fc.m21(), this.z, (double)matrix4fc.m31())));
        double d4 = Math.fma((double)matrix4fc.m02(), this.x, Math.fma((double)matrix4fc.m12(), this.y, Math.fma((double)matrix4fc.m22(), this.z, (double)matrix4fc.m32())));
        vector3d.x = d2;
        vector3d.y = d3;
        vector3d.z = d4;
        return d;
    }

    public double mulPositionW(Matrix4dc matrix4dc) {
        double d = Math.fma(matrix4dc.m03(), this.x, Math.fma(matrix4dc.m13(), this.y, Math.fma(matrix4dc.m23(), this.z, matrix4dc.m33())));
        double d2 = Math.fma(matrix4dc.m00(), this.x, Math.fma(matrix4dc.m10(), this.y, Math.fma(matrix4dc.m20(), this.z, matrix4dc.m30())));
        double d3 = Math.fma(matrix4dc.m01(), this.x, Math.fma(matrix4dc.m11(), this.y, Math.fma(matrix4dc.m21(), this.z, matrix4dc.m31())));
        double d4 = Math.fma(matrix4dc.m02(), this.x, Math.fma(matrix4dc.m12(), this.y, Math.fma(matrix4dc.m22(), this.z, matrix4dc.m32())));
        this.x = d2;
        this.y = d3;
        this.z = d4;
        return d;
    }

    @Override
    public double mulPositionW(Matrix4dc matrix4dc, Vector3d vector3d) {
        double d = Math.fma(matrix4dc.m03(), this.x, Math.fma(matrix4dc.m13(), this.y, Math.fma(matrix4dc.m23(), this.z, matrix4dc.m33())));
        double d2 = Math.fma(matrix4dc.m00(), this.x, Math.fma(matrix4dc.m10(), this.y, Math.fma(matrix4dc.m20(), this.z, matrix4dc.m30())));
        double d3 = Math.fma(matrix4dc.m01(), this.x, Math.fma(matrix4dc.m11(), this.y, Math.fma(matrix4dc.m21(), this.z, matrix4dc.m31())));
        double d4 = Math.fma(matrix4dc.m02(), this.x, Math.fma(matrix4dc.m12(), this.y, Math.fma(matrix4dc.m22(), this.z, matrix4dc.m32())));
        vector3d.x = d2;
        vector3d.y = d3;
        vector3d.z = d4;
        return d;
    }

    public Vector3d mulDirection(Matrix4fc matrix4fc) {
        double d = Math.fma((double)matrix4fc.m00(), this.x, Math.fma((double)matrix4fc.m10(), this.y, (double)matrix4fc.m20() * this.z));
        double d2 = Math.fma((double)matrix4fc.m01(), this.x, Math.fma((double)matrix4fc.m11(), this.y, (double)matrix4fc.m21() * this.z));
        double d3 = Math.fma((double)matrix4fc.m02(), this.x, Math.fma((double)matrix4fc.m12(), this.y, (double)matrix4fc.m22() * this.z));
        this.x = d;
        this.y = d2;
        this.z = d3;
        return this;
    }

    public Vector3d mulDirection(Matrix4dc matrix4dc) {
        double d = Math.fma(matrix4dc.m00(), this.x, Math.fma(matrix4dc.m10(), this.y, matrix4dc.m20() * this.z));
        double d2 = Math.fma(matrix4dc.m01(), this.x, Math.fma(matrix4dc.m11(), this.y, matrix4dc.m21() * this.z));
        double d3 = Math.fma(matrix4dc.m02(), this.x, Math.fma(matrix4dc.m12(), this.y, matrix4dc.m22() * this.z));
        this.x = d;
        this.y = d2;
        this.z = d3;
        return this;
    }

    public Vector3d mulDirection(Matrix4x3dc matrix4x3dc) {
        double d = Math.fma(matrix4x3dc.m00(), this.x, Math.fma(matrix4x3dc.m10(), this.y, matrix4x3dc.m20() * this.z));
        double d2 = Math.fma(matrix4x3dc.m01(), this.x, Math.fma(matrix4x3dc.m11(), this.y, matrix4x3dc.m21() * this.z));
        double d3 = Math.fma(matrix4x3dc.m02(), this.x, Math.fma(matrix4x3dc.m12(), this.y, matrix4x3dc.m22() * this.z));
        this.x = d;
        this.y = d2;
        this.z = d3;
        return this;
    }

    public Vector3d mulDirection(Matrix4x3fc matrix4x3fc) {
        double d = Math.fma((double)matrix4x3fc.m00(), this.x, Math.fma((double)matrix4x3fc.m10(), this.y, (double)matrix4x3fc.m20() * this.z));
        double d2 = Math.fma((double)matrix4x3fc.m01(), this.x, Math.fma((double)matrix4x3fc.m11(), this.y, (double)matrix4x3fc.m21() * this.z));
        double d3 = Math.fma((double)matrix4x3fc.m02(), this.x, Math.fma((double)matrix4x3fc.m12(), this.y, (double)matrix4x3fc.m22() * this.z));
        this.x = d;
        this.y = d2;
        this.z = d3;
        return this;
    }

    @Override
    public Vector3d mulDirection(Matrix4dc matrix4dc, Vector3d vector3d) {
        double d = Math.fma(matrix4dc.m00(), this.x, Math.fma(matrix4dc.m10(), this.y, matrix4dc.m20() * this.z));
        double d2 = Math.fma(matrix4dc.m01(), this.x, Math.fma(matrix4dc.m11(), this.y, matrix4dc.m21() * this.z));
        double d3 = Math.fma(matrix4dc.m02(), this.x, Math.fma(matrix4dc.m12(), this.y, matrix4dc.m22() * this.z));
        vector3d.x = d;
        vector3d.y = d2;
        vector3d.z = d3;
        return vector3d;
    }

    @Override
    public Vector3d mulDirection(Matrix4fc matrix4fc, Vector3d vector3d) {
        double d = Math.fma((double)matrix4fc.m00(), this.x, Math.fma((double)matrix4fc.m10(), this.y, (double)matrix4fc.m20() * this.z));
        double d2 = Math.fma((double)matrix4fc.m01(), this.x, Math.fma((double)matrix4fc.m11(), this.y, (double)matrix4fc.m21() * this.z));
        double d3 = Math.fma((double)matrix4fc.m02(), this.x, Math.fma((double)matrix4fc.m12(), this.y, (double)matrix4fc.m22() * this.z));
        vector3d.x = d;
        vector3d.y = d2;
        vector3d.z = d3;
        return vector3d;
    }

    @Override
    public Vector3d mulDirection(Matrix4x3dc matrix4x3dc, Vector3d vector3d) {
        double d = Math.fma(matrix4x3dc.m00(), this.x, Math.fma(matrix4x3dc.m10(), this.y, matrix4x3dc.m20() * this.z));
        double d2 = Math.fma(matrix4x3dc.m01(), this.x, Math.fma(matrix4x3dc.m11(), this.y, matrix4x3dc.m21() * this.z));
        double d3 = Math.fma(matrix4x3dc.m02(), this.x, Math.fma(matrix4x3dc.m12(), this.y, matrix4x3dc.m22() * this.z));
        vector3d.x = d;
        vector3d.y = d2;
        vector3d.z = d3;
        return vector3d;
    }

    @Override
    public Vector3d mulDirection(Matrix4x3fc matrix4x3fc, Vector3d vector3d) {
        double d = Math.fma((double)matrix4x3fc.m00(), this.x, Math.fma((double)matrix4x3fc.m10(), this.y, (double)matrix4x3fc.m20() * this.z));
        double d2 = Math.fma((double)matrix4x3fc.m01(), this.x, Math.fma((double)matrix4x3fc.m11(), this.y, (double)matrix4x3fc.m21() * this.z));
        double d3 = Math.fma((double)matrix4x3fc.m02(), this.x, Math.fma((double)matrix4x3fc.m12(), this.y, (double)matrix4x3fc.m22() * this.z));
        vector3d.x = d;
        vector3d.y = d2;
        vector3d.z = d3;
        return vector3d;
    }

    public Vector3d mulTransposeDirection(Matrix4dc matrix4dc) {
        double d = Math.fma(matrix4dc.m00(), this.x, Math.fma(matrix4dc.m01(), this.y, matrix4dc.m02() * this.z));
        double d2 = Math.fma(matrix4dc.m10(), this.x, Math.fma(matrix4dc.m11(), this.y, matrix4dc.m12() * this.z));
        double d3 = Math.fma(matrix4dc.m20(), this.x, Math.fma(matrix4dc.m21(), this.y, matrix4dc.m22() * this.z));
        this.x = d;
        this.y = d2;
        this.z = d3;
        return this;
    }

    @Override
    public Vector3d mulTransposeDirection(Matrix4dc matrix4dc, Vector3d vector3d) {
        double d = Math.fma(matrix4dc.m00(), this.x, Math.fma(matrix4dc.m01(), this.y, matrix4dc.m02() * this.z));
        double d2 = Math.fma(matrix4dc.m10(), this.x, Math.fma(matrix4dc.m11(), this.y, matrix4dc.m12() * this.z));
        double d3 = Math.fma(matrix4dc.m20(), this.x, Math.fma(matrix4dc.m21(), this.y, matrix4dc.m22() * this.z));
        vector3d.x = d;
        vector3d.y = d2;
        vector3d.z = d3;
        return vector3d;
    }

    public Vector3d mulTransposeDirection(Matrix4fc matrix4fc) {
        double d = Math.fma((double)matrix4fc.m00(), this.x, Math.fma((double)matrix4fc.m01(), this.y, (double)matrix4fc.m02() * this.z));
        double d2 = Math.fma((double)matrix4fc.m10(), this.x, Math.fma((double)matrix4fc.m11(), this.y, (double)matrix4fc.m12() * this.z));
        double d3 = Math.fma((double)matrix4fc.m20(), this.x, Math.fma((double)matrix4fc.m21(), this.y, (double)matrix4fc.m22() * this.z));
        this.x = d;
        this.y = d2;
        this.z = d3;
        return this;
    }

    @Override
    public Vector3d mulTransposeDirection(Matrix4fc matrix4fc, Vector3d vector3d) {
        double d = Math.fma((double)matrix4fc.m00(), this.x, Math.fma((double)matrix4fc.m01(), this.y, (double)matrix4fc.m02() * this.z));
        double d2 = Math.fma((double)matrix4fc.m10(), this.x, Math.fma((double)matrix4fc.m11(), this.y, (double)matrix4fc.m12() * this.z));
        double d3 = Math.fma((double)matrix4fc.m20(), this.x, Math.fma((double)matrix4fc.m21(), this.y, (double)matrix4fc.m22() * this.z));
        vector3d.x = d;
        vector3d.y = d2;
        vector3d.z = d3;
        return vector3d;
    }

    public Vector3d mul(double d) {
        this.x *= d;
        this.y *= d;
        this.z *= d;
        return this;
    }

    @Override
    public Vector3d mul(double d, Vector3d vector3d) {
        vector3d.x = this.x * d;
        vector3d.y = this.y * d;
        vector3d.z = this.z * d;
        return vector3d;
    }

    public Vector3d mul(double d, double d2, double d3) {
        this.x *= d;
        this.y *= d2;
        this.z *= d3;
        return this;
    }

    @Override
    public Vector3d mul(double d, double d2, double d3, Vector3d vector3d) {
        vector3d.x = this.x * d;
        vector3d.y = this.y * d2;
        vector3d.z = this.z * d3;
        return vector3d;
    }

    public Vector3d rotate(Quaterniondc quaterniondc) {
        return quaterniondc.transform(this, this);
    }

    @Override
    public Vector3d rotate(Quaterniondc quaterniondc, Vector3d vector3d) {
        return quaterniondc.transform(this, vector3d);
    }

    @Override
    public Quaterniond rotationTo(Vector3dc vector3dc, Quaterniond quaterniond) {
        return quaterniond.rotationTo(this, vector3dc);
    }

    @Override
    public Quaterniond rotationTo(double d, double d2, double d3, Quaterniond quaterniond) {
        return quaterniond.rotationTo(this.x, this.y, this.z, d, d2, d3);
    }

    public Vector3d rotateAxis(double d, double d2, double d3, double d4) {
        if (d3 == 0.0 && d4 == 0.0 && Math.absEqualsOne(d2)) {
            return this.rotateX(d2 * d, this);
        }
        if (d2 == 0.0 && d4 == 0.0 && Math.absEqualsOne(d3)) {
            return this.rotateY(d3 * d, this);
        }
        if (d2 == 0.0 && d3 == 0.0 && Math.absEqualsOne(d4)) {
            return this.rotateZ(d4 * d, this);
        }
        return this.rotateAxisInternal(d, d2, d3, d4, this);
    }

    @Override
    public Vector3d rotateAxis(double d, double d2, double d3, double d4, Vector3d vector3d) {
        if (d3 == 0.0 && d4 == 0.0 && Math.absEqualsOne(d2)) {
            return this.rotateX(d2 * d, vector3d);
        }
        if (d2 == 0.0 && d4 == 0.0 && Math.absEqualsOne(d3)) {
            return this.rotateY(d3 * d, vector3d);
        }
        if (d2 == 0.0 && d3 == 0.0 && Math.absEqualsOne(d4)) {
            return this.rotateZ(d4 * d, vector3d);
        }
        return this.rotateAxisInternal(d, d2, d3, d4, vector3d);
    }

    private Vector3d rotateAxisInternal(double d, double d2, double d3, double d4, Vector3d vector3d) {
        double d5 = d * 0.5;
        double d6 = Math.sin(d5);
        double d7 = d2 * d6;
        double d8 = d3 * d6;
        double d9 = d4 * d6;
        double d10 = Math.cosFromSin(d6, d5);
        double d11 = d10 * d10;
        double d12 = d7 * d7;
        double d13 = d8 * d8;
        double d14 = d9 * d9;
        double d15 = d9 * d10;
        double d16 = d7 * d8;
        double d17 = d7 * d9;
        double d18 = d8 * d10;
        double d19 = d8 * d9;
        double d20 = d7 * d10;
        double d21 = (d11 + d12 - d14 - d13) * this.x + (-d15 + d16 - d15 + d16) * this.y + (d18 + d17 + d17 + d18) * this.z;
        double d22 = (d16 + d15 + d15 + d16) * this.x + (d13 - d14 + d11 - d12) * this.y + (d19 + d19 - d20 - d20) * this.z;
        double d23 = (d17 - d18 + d17 - d18) * this.x + (d19 + d19 + d20 + d20) * this.y + (d14 - d13 - d12 + d11) * this.z;
        vector3d.x = d21;
        vector3d.y = d22;
        vector3d.z = d23;
        return vector3d;
    }

    public Vector3d rotateX(double d) {
        double d2 = Math.sin(d);
        double d3 = Math.cosFromSin(d2, d);
        double d4 = this.y * d3 - this.z * d2;
        double d5 = this.y * d2 + this.z * d3;
        this.y = d4;
        this.z = d5;
        return this;
    }

    @Override
    public Vector3d rotateX(double d, Vector3d vector3d) {
        double d2 = Math.sin(d);
        double d3 = Math.cosFromSin(d2, d);
        double d4 = this.y * d3 - this.z * d2;
        double d5 = this.y * d2 + this.z * d3;
        vector3d.x = this.x;
        vector3d.y = d4;
        vector3d.z = d5;
        return vector3d;
    }

    public Vector3d rotateY(double d) {
        double d2 = Math.sin(d);
        double d3 = Math.cosFromSin(d2, d);
        double d4 = this.x * d3 + this.z * d2;
        double d5 = -this.x * d2 + this.z * d3;
        this.x = d4;
        this.z = d5;
        return this;
    }

    @Override
    public Vector3d rotateY(double d, Vector3d vector3d) {
        double d2 = Math.sin(d);
        double d3 = Math.cosFromSin(d2, d);
        double d4 = this.x * d3 + this.z * d2;
        double d5 = -this.x * d2 + this.z * d3;
        vector3d.x = d4;
        vector3d.y = this.y;
        vector3d.z = d5;
        return vector3d;
    }

    public Vector3d rotateZ(double d) {
        double d2 = Math.sin(d);
        double d3 = Math.cosFromSin(d2, d);
        double d4 = this.x * d3 - this.y * d2;
        double d5 = this.x * d2 + this.y * d3;
        this.x = d4;
        this.y = d5;
        return this;
    }

    @Override
    public Vector3d rotateZ(double d, Vector3d vector3d) {
        double d2 = Math.sin(d);
        double d3 = Math.cosFromSin(d2, d);
        double d4 = this.x * d3 - this.y * d2;
        double d5 = this.x * d2 + this.y * d3;
        vector3d.x = d4;
        vector3d.y = d5;
        vector3d.z = this.z;
        return vector3d;
    }

    public Vector3d div(double d) {
        double d2 = 1.0 / d;
        this.x *= d2;
        this.y *= d2;
        this.z *= d2;
        return this;
    }

    @Override
    public Vector3d div(double d, Vector3d vector3d) {
        double d2 = 1.0 / d;
        vector3d.x = this.x * d2;
        vector3d.y = this.y * d2;
        vector3d.z = this.z * d2;
        return vector3d;
    }

    public Vector3d div(double d, double d2, double d3) {
        this.x /= d;
        this.y /= d2;
        this.z /= d3;
        return this;
    }

    @Override
    public Vector3d div(double d, double d2, double d3, Vector3d vector3d) {
        vector3d.x = this.x / d;
        vector3d.y = this.y / d2;
        vector3d.z = this.z / d3;
        return vector3d;
    }

    @Override
    public double lengthSquared() {
        return Math.fma(this.x, this.x, Math.fma(this.y, this.y, this.z * this.z));
    }

    public static double lengthSquared(double d, double d2, double d3) {
        return Math.fma(d, d, Math.fma(d2, d2, d3 * d3));
    }

    @Override
    public double length() {
        return Math.sqrt(Math.fma(this.x, this.x, Math.fma(this.y, this.y, this.z * this.z)));
    }

    public static double length(double d, double d2, double d3) {
        return Math.sqrt(Math.fma(d, d, Math.fma(d2, d2, d3 * d3)));
    }

    public Vector3d normalize() {
        double d = Math.invsqrt(Math.fma(this.x, this.x, Math.fma(this.y, this.y, this.z * this.z)));
        this.x *= d;
        this.y *= d;
        this.z *= d;
        return this;
    }

    @Override
    public Vector3d normalize(Vector3d vector3d) {
        double d = Math.invsqrt(Math.fma(this.x, this.x, Math.fma(this.y, this.y, this.z * this.z)));
        vector3d.x = this.x * d;
        vector3d.y = this.y * d;
        vector3d.z = this.z * d;
        return vector3d;
    }

    public Vector3d normalize(double d) {
        double d2 = Math.invsqrt(Math.fma(this.x, this.x, Math.fma(this.y, this.y, this.z * this.z))) * d;
        this.x *= d2;
        this.y *= d2;
        this.z *= d2;
        return this;
    }

    @Override
    public Vector3d normalize(double d, Vector3d vector3d) {
        double d2 = Math.invsqrt(Math.fma(this.x, this.x, Math.fma(this.y, this.y, this.z * this.z))) * d;
        vector3d.x = this.x * d2;
        vector3d.y = this.y * d2;
        vector3d.z = this.z * d2;
        return vector3d;
    }

    public Vector3d cross(Vector3dc vector3dc) {
        double d = Math.fma(this.y, vector3dc.z(), -this.z * vector3dc.y());
        double d2 = Math.fma(this.z, vector3dc.x(), -this.x * vector3dc.z());
        double d3 = Math.fma(this.x, vector3dc.y(), -this.y * vector3dc.x());
        this.x = d;
        this.y = d2;
        this.z = d3;
        return this;
    }

    public Vector3d cross(double d, double d2, double d3) {
        double d4 = Math.fma(this.y, d3, -this.z * d2);
        double d5 = Math.fma(this.z, d, -this.x * d3);
        double d6 = Math.fma(this.x, d2, -this.y * d);
        this.x = d4;
        this.y = d5;
        this.z = d6;
        return this;
    }

    @Override
    public Vector3d cross(Vector3dc vector3dc, Vector3d vector3d) {
        double d = Math.fma(this.y, vector3dc.z(), -this.z * vector3dc.y());
        double d2 = Math.fma(this.z, vector3dc.x(), -this.x * vector3dc.z());
        double d3 = Math.fma(this.x, vector3dc.y(), -this.y * vector3dc.x());
        vector3d.x = d;
        vector3d.y = d2;
        vector3d.z = d3;
        return vector3d;
    }

    @Override
    public Vector3d cross(double d, double d2, double d3, Vector3d vector3d) {
        double d4 = Math.fma(this.y, d3, -this.z * d2);
        double d5 = Math.fma(this.z, d, -this.x * d3);
        double d6 = Math.fma(this.x, d2, -this.y * d);
        vector3d.x = d4;
        vector3d.y = d5;
        vector3d.z = d6;
        return vector3d;
    }

    @Override
    public double distance(Vector3dc vector3dc) {
        double d = this.x - vector3dc.x();
        double d2 = this.y - vector3dc.y();
        double d3 = this.z - vector3dc.z();
        return Math.sqrt(Math.fma(d, d, Math.fma(d2, d2, d3 * d3)));
    }

    @Override
    public double distance(double d, double d2, double d3) {
        double d4 = this.x - d;
        double d5 = this.y - d2;
        double d6 = this.z - d3;
        return Math.sqrt(Math.fma(d4, d4, Math.fma(d5, d5, d6 * d6)));
    }

    @Override
    public double distanceSquared(Vector3dc vector3dc) {
        double d = this.x - vector3dc.x();
        double d2 = this.y - vector3dc.y();
        double d3 = this.z - vector3dc.z();
        return Math.fma(d, d, Math.fma(d2, d2, d3 * d3));
    }

    @Override
    public double distanceSquared(double d, double d2, double d3) {
        double d4 = this.x - d;
        double d5 = this.y - d2;
        double d6 = this.z - d3;
        return Math.fma(d4, d4, Math.fma(d5, d5, d6 * d6));
    }

    public static double distance(double d, double d2, double d3, double d4, double d5, double d6) {
        return Math.sqrt(Vector3d.distanceSquared(d, d2, d3, d4, d5, d6));
    }

    public static double distanceSquared(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = d - d4;
        double d8 = d2 - d5;
        double d9 = d3 - d6;
        return Math.fma(d7, d7, Math.fma(d8, d8, d9 * d9));
    }

    @Override
    public double dot(Vector3dc vector3dc) {
        return Math.fma(this.x, vector3dc.x(), Math.fma(this.y, vector3dc.y(), this.z * vector3dc.z()));
    }

    @Override
    public double dot(double d, double d2, double d3) {
        return Math.fma(this.x, d, Math.fma(this.y, d2, this.z * d3));
    }

    @Override
    public double angleCos(Vector3dc vector3dc) {
        double d = Math.fma(this.x, this.x, Math.fma(this.y, this.y, this.z * this.z));
        double d2 = Math.fma(vector3dc.x(), vector3dc.x(), Math.fma(vector3dc.y(), vector3dc.y(), vector3dc.z() * vector3dc.z()));
        double d3 = Math.fma(this.x, vector3dc.x(), Math.fma(this.y, vector3dc.y(), this.z * vector3dc.z()));
        return d3 / Math.sqrt(d * d2);
    }

    @Override
    public double angle(Vector3dc vector3dc) {
        double d = this.angleCos(vector3dc);
        d = d < 1.0 ? d : 1.0;
        d = d > -1.0 ? d : -1.0;
        return Math.acos(d);
    }

    @Override
    public double angleSigned(Vector3dc vector3dc, Vector3dc vector3dc2) {
        double d = vector3dc.x();
        double d2 = vector3dc.y();
        double d3 = vector3dc.z();
        return Math.atan2((this.y * d3 - this.z * d2) * vector3dc2.x() + (this.z * d - this.x * d3) * vector3dc2.y() + (this.x * d2 - this.y * d) * vector3dc2.z(), this.x * d + this.y * d2 + this.z * d3);
    }

    @Override
    public double angleSigned(double d, double d2, double d3, double d4, double d5, double d6) {
        return Math.atan2((this.y * d3 - this.z * d2) * d4 + (this.z * d - this.x * d3) * d5 + (this.x * d2 - this.y * d) * d6, this.x * d + this.y * d2 + this.z * d3);
    }

    public Vector3d min(Vector3dc vector3dc) {
        this.x = this.x < vector3dc.x() ? this.x : vector3dc.x();
        this.y = this.y < vector3dc.y() ? this.y : vector3dc.y();
        this.z = this.z < vector3dc.z() ? this.z : vector3dc.z();
        return this;
    }

    @Override
    public Vector3d min(Vector3dc vector3dc, Vector3d vector3d) {
        vector3d.x = this.x < vector3dc.x() ? this.x : vector3dc.x();
        vector3d.y = this.y < vector3dc.y() ? this.y : vector3dc.y();
        vector3d.z = this.z < vector3dc.z() ? this.z : vector3dc.z();
        return vector3d;
    }

    public Vector3d max(Vector3dc vector3dc) {
        this.x = this.x > vector3dc.x() ? this.x : vector3dc.x();
        this.y = this.y > vector3dc.y() ? this.y : vector3dc.y();
        this.z = this.z > vector3dc.z() ? this.z : vector3dc.z();
        return this;
    }

    @Override
    public Vector3d max(Vector3dc vector3dc, Vector3d vector3d) {
        vector3d.x = this.x > vector3dc.x() ? this.x : vector3dc.x();
        vector3d.y = this.y > vector3dc.y() ? this.y : vector3dc.y();
        vector3d.z = this.z > vector3dc.z() ? this.z : vector3dc.z();
        return vector3d;
    }

    public Vector3d zero() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        return this;
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat numberFormat) {
        return "(" + Runtime.format(this.x, numberFormat) + " " + Runtime.format(this.y, numberFormat) + " " + Runtime.format(this.z, numberFormat) + ")";
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeDouble(this.x);
        objectOutput.writeDouble(this.y);
        objectOutput.writeDouble(this.z);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.x = objectInput.readDouble();
        this.y = objectInput.readDouble();
        this.z = objectInput.readDouble();
    }

    public Vector3d negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    @Override
    public Vector3d negate(Vector3d vector3d) {
        vector3d.x = -this.x;
        vector3d.y = -this.y;
        vector3d.z = -this.z;
        return vector3d;
    }

    public Vector3d absolute() {
        this.x = Math.abs(this.x);
        this.y = Math.abs(this.y);
        this.z = Math.abs(this.z);
        return this;
    }

    @Override
    public Vector3d absolute(Vector3d vector3d) {
        vector3d.x = Math.abs(this.x);
        vector3d.y = Math.abs(this.y);
        vector3d.z = Math.abs(this.z);
        return vector3d;
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.x);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.y);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.z);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Vector3d vector3d = (Vector3d)object;
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(vector3d.x)) {
            return false;
        }
        if (Double.doubleToLongBits(this.y) != Double.doubleToLongBits(vector3d.y)) {
            return false;
        }
        return Double.doubleToLongBits(this.z) == Double.doubleToLongBits(vector3d.z);
    }

    @Override
    public boolean equals(Vector3dc vector3dc, double d) {
        if (this == vector3dc) {
            return true;
        }
        if (vector3dc == null) {
            return false;
        }
        if (!(vector3dc instanceof Vector3dc)) {
            return false;
        }
        if (!Runtime.equals(this.x, vector3dc.x(), d)) {
            return false;
        }
        if (!Runtime.equals(this.y, vector3dc.y(), d)) {
            return false;
        }
        return Runtime.equals(this.z, vector3dc.z(), d);
    }

    @Override
    public boolean equals(double d, double d2, double d3) {
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(d)) {
            return false;
        }
        if (Double.doubleToLongBits(this.y) != Double.doubleToLongBits(d2)) {
            return false;
        }
        return Double.doubleToLongBits(this.z) == Double.doubleToLongBits(d3);
    }

    public Vector3d reflect(Vector3dc vector3dc) {
        double d = vector3dc.x();
        double d2 = vector3dc.y();
        double d3 = vector3dc.z();
        double d4 = Math.fma(this.x, d, Math.fma(this.y, d2, this.z * d3));
        this.x -= (d4 + d4) * d;
        this.y -= (d4 + d4) * d2;
        this.z -= (d4 + d4) * d3;
        return this;
    }

    public Vector3d reflect(double d, double d2, double d3) {
        double d4 = Math.fma(this.x, d, Math.fma(this.y, d2, this.z * d3));
        this.x -= (d4 + d4) * d;
        this.y -= (d4 + d4) * d2;
        this.z -= (d4 + d4) * d3;
        return this;
    }

    @Override
    public Vector3d reflect(Vector3dc vector3dc, Vector3d vector3d) {
        double d = vector3dc.x();
        double d2 = vector3dc.y();
        double d3 = vector3dc.z();
        double d4 = Math.fma(this.x, d, Math.fma(this.y, d2, this.z * d3));
        vector3d.x = this.x - (d4 + d4) * d;
        vector3d.y = this.y - (d4 + d4) * d2;
        vector3d.z = this.z - (d4 + d4) * d3;
        return vector3d;
    }

    @Override
    public Vector3d reflect(double d, double d2, double d3, Vector3d vector3d) {
        double d4 = Math.fma(this.x, d, Math.fma(this.y, d2, this.z * d3));
        vector3d.x = this.x - (d4 + d4) * d;
        vector3d.y = this.y - (d4 + d4) * d2;
        vector3d.z = this.z - (d4 + d4) * d3;
        return vector3d;
    }

    public Vector3d half(Vector3dc vector3dc) {
        return this.set(this).add(vector3dc.x(), vector3dc.y(), vector3dc.z()).normalize();
    }

    public Vector3d half(double d, double d2, double d3) {
        return this.set(this).add(d, d2, d3).normalize();
    }

    @Override
    public Vector3d half(Vector3dc vector3dc, Vector3d vector3d) {
        return vector3d.set(this).add(vector3dc.x(), vector3dc.y(), vector3dc.z()).normalize();
    }

    @Override
    public Vector3d half(double d, double d2, double d3, Vector3d vector3d) {
        return vector3d.set(this).add(d, d2, d3).normalize();
    }

    @Override
    public Vector3d smoothStep(Vector3dc vector3dc, double d, Vector3d vector3d) {
        double d2 = d * d;
        double d3 = d2 * d;
        vector3d.x = (this.x + this.x - vector3dc.x() - vector3dc.x()) * d3 + (3.0 * vector3dc.x() - 3.0 * this.x) * d2 + this.x * d + this.x;
        vector3d.y = (this.y + this.y - vector3dc.y() - vector3dc.y()) * d3 + (3.0 * vector3dc.y() - 3.0 * this.y) * d2 + this.y * d + this.y;
        vector3d.z = (this.z + this.z - vector3dc.z() - vector3dc.z()) * d3 + (3.0 * vector3dc.z() - 3.0 * this.z) * d2 + this.z * d + this.z;
        return vector3d;
    }

    @Override
    public Vector3d hermite(Vector3dc vector3dc, Vector3dc vector3dc2, Vector3dc vector3dc3, double d, Vector3d vector3d) {
        double d2 = d * d;
        double d3 = d2 * d;
        vector3d.x = (this.x + this.x - vector3dc2.x() - vector3dc2.x() + vector3dc3.x() + vector3dc.x()) * d3 + (3.0 * vector3dc2.x() - 3.0 * this.x - vector3dc.x() - vector3dc.x() - vector3dc3.x()) * d2 + this.x * d + this.x;
        vector3d.y = (this.y + this.y - vector3dc2.y() - vector3dc2.y() + vector3dc3.y() + vector3dc.y()) * d3 + (3.0 * vector3dc2.y() - 3.0 * this.y - vector3dc.y() - vector3dc.y() - vector3dc3.y()) * d2 + this.y * d + this.y;
        vector3d.z = (this.z + this.z - vector3dc2.z() - vector3dc2.z() + vector3dc3.z() + vector3dc.z()) * d3 + (3.0 * vector3dc2.z() - 3.0 * this.z - vector3dc.z() - vector3dc.z() - vector3dc3.z()) * d2 + this.z * d + this.z;
        return vector3d;
    }

    public Vector3d lerp(Vector3dc vector3dc, double d) {
        this.x = Math.fma(vector3dc.x() - this.x, d, this.x);
        this.y = Math.fma(vector3dc.y() - this.y, d, this.y);
        this.z = Math.fma(vector3dc.z() - this.z, d, this.z);
        return this;
    }

    @Override
    public Vector3d lerp(Vector3dc vector3dc, double d, Vector3d vector3d) {
        vector3d.x = Math.fma(vector3dc.x() - this.x, d, this.x);
        vector3d.y = Math.fma(vector3dc.y() - this.y, d, this.y);
        vector3d.z = Math.fma(vector3dc.z() - this.z, d, this.z);
        return vector3d;
    }

    @Override
    public double get(int n) throws IllegalArgumentException {
        switch (n) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Vector3i get(int n, Vector3i vector3i) {
        vector3i.x = Math.roundUsing(this.x(), n);
        vector3i.y = Math.roundUsing(this.y(), n);
        vector3i.z = Math.roundUsing(this.z(), n);
        return vector3i;
    }

    @Override
    public Vector3f get(Vector3f vector3f) {
        vector3f.x = (float)this.x();
        vector3f.y = (float)this.y();
        vector3f.z = (float)this.z();
        return vector3f;
    }

    @Override
    public Vector3d get(Vector3d vector3d) {
        vector3d.x = this.x();
        vector3d.y = this.y();
        vector3d.z = this.z();
        return vector3d;
    }

    @Override
    public int maxComponent() {
        double d = Math.abs(this.x);
        double d2 = Math.abs(this.y);
        double d3 = Math.abs(this.z);
        if (d >= d2 && d >= d3) {
            return 0;
        }
        if (d2 >= d3) {
            return 1;
        }
        return 2;
    }

    @Override
    public int minComponent() {
        double d = Math.abs(this.x);
        double d2 = Math.abs(this.y);
        double d3 = Math.abs(this.z);
        if (d < d2 && d < d3) {
            return 0;
        }
        if (d2 < d3) {
            return 1;
        }
        return 2;
    }

    @Override
    public Vector3d orthogonalize(Vector3dc vector3dc, Vector3d vector3d) {
        double d;
        double d2;
        double d3;
        if (Math.abs(vector3dc.x()) > Math.abs(vector3dc.z())) {
            d3 = -vector3dc.y();
            d2 = vector3dc.x();
            d = 0.0;
        } else {
            d3 = 0.0;
            d2 = -vector3dc.z();
            d = vector3dc.y();
        }
        double d4 = Math.invsqrt(d3 * d3 + d2 * d2 + d * d);
        vector3d.x = d3 * d4;
        vector3d.y = d2 * d4;
        vector3d.z = d * d4;
        return vector3d;
    }

    public Vector3d orthogonalize(Vector3dc vector3dc) {
        return this.orthogonalize(vector3dc, this);
    }

    @Override
    public Vector3d orthogonalizeUnit(Vector3dc vector3dc, Vector3d vector3d) {
        return this.orthogonalize(vector3dc, vector3d);
    }

    public Vector3d orthogonalizeUnit(Vector3dc vector3dc) {
        return this.orthogonalizeUnit(vector3dc, this);
    }

    public Vector3d floor() {
        this.x = Math.floor(this.x);
        this.y = Math.floor(this.y);
        this.z = Math.floor(this.z);
        return this;
    }

    @Override
    public Vector3d floor(Vector3d vector3d) {
        vector3d.x = Math.floor(this.x);
        vector3d.y = Math.floor(this.y);
        vector3d.z = Math.floor(this.z);
        return vector3d;
    }

    public Vector3d ceil() {
        this.x = Math.ceil(this.x);
        this.y = Math.ceil(this.y);
        this.z = Math.ceil(this.z);
        return this;
    }

    @Override
    public Vector3d ceil(Vector3d vector3d) {
        vector3d.x = Math.ceil(this.x);
        vector3d.y = Math.ceil(this.y);
        vector3d.z = Math.ceil(this.z);
        return vector3d;
    }

    public Vector3d round() {
        this.x = Math.round(this.x);
        this.y = Math.round(this.y);
        this.z = Math.round(this.z);
        return this;
    }

    @Override
    public Vector3d round(Vector3d vector3d) {
        vector3d.x = Math.round(this.x);
        vector3d.y = Math.round(this.y);
        vector3d.z = Math.round(this.z);
        return vector3d;
    }

    @Override
    public boolean isFinite() {
        return Math.isFinite(this.x) && Math.isFinite(this.y) && Math.isFinite(this.z);
    }
}

