/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.joml.AxisAngle4d;
import org.joml.AxisAngle4f;
import org.joml.Math;
import org.joml.Matrix3d;
import org.joml.Matrix3dc;
import org.joml.Matrix3fc;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Matrix4x3dc;
import org.joml.Matrix4x3fc;
import org.joml.MemUtil;
import org.joml.Options;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Runtime;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3fc;
import org.joml.Vector4d;
import org.joml.Vector4dc;

public class Matrix4x3d
implements Externalizable,
Matrix4x3dc {
    private static final long serialVersionUID = 1L;
    double m00;
    double m01;
    double m02;
    double m10;
    double m11;
    double m12;
    double m20;
    double m21;
    double m22;
    double m30;
    double m31;
    double m32;
    int properties;

    public Matrix4x3d() {
        this.m00 = 1.0;
        this.m11 = 1.0;
        this.m22 = 1.0;
        this.properties = 28;
    }

    public Matrix4x3d(Matrix4x3dc matrix4x3dc) {
        this.set(matrix4x3dc);
    }

    public Matrix4x3d(Matrix4x3fc matrix4x3fc) {
        this.set(matrix4x3fc);
    }

    public Matrix4x3d(Matrix3dc matrix3dc) {
        this.set(matrix3dc);
    }

    public Matrix4x3d(Matrix3fc matrix3fc) {
        this.set(matrix3fc);
    }

    public Matrix4x3d(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        this.m00 = d;
        this.m01 = d2;
        this.m02 = d3;
        this.m10 = d4;
        this.m11 = d5;
        this.m12 = d6;
        this.m20 = d7;
        this.m21 = d8;
        this.m22 = d9;
        this.m30 = d10;
        this.m31 = d11;
        this.m32 = d12;
        this.determineProperties();
    }

    public Matrix4x3d(DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.get(this, doubleBuffer.position(), doubleBuffer);
        this.determineProperties();
    }

    public Matrix4x3d assume(int n) {
        this.properties = n;
        return this;
    }

    public Matrix4x3d determineProperties() {
        int n = 0;
        if (this.m00 == 1.0 && this.m01 == 0.0 && this.m02 == 0.0 && this.m10 == 0.0 && this.m11 == 1.0 && this.m12 == 0.0 && this.m20 == 0.0 && this.m21 == 0.0 && this.m22 == 1.0) {
            n |= 0x18;
            if (this.m30 == 0.0 && this.m31 == 0.0 && this.m32 == 0.0) {
                n |= 4;
            }
        }
        this.properties = n;
        return this;
    }

    @Override
    public int properties() {
        return this.properties;
    }

    @Override
    public double m00() {
        return this.m00;
    }

    @Override
    public double m01() {
        return this.m01;
    }

    @Override
    public double m02() {
        return this.m02;
    }

    @Override
    public double m10() {
        return this.m10;
    }

    @Override
    public double m11() {
        return this.m11;
    }

    @Override
    public double m12() {
        return this.m12;
    }

    @Override
    public double m20() {
        return this.m20;
    }

    @Override
    public double m21() {
        return this.m21;
    }

    @Override
    public double m22() {
        return this.m22;
    }

    @Override
    public double m30() {
        return this.m30;
    }

    @Override
    public double m31() {
        return this.m31;
    }

    @Override
    public double m32() {
        return this.m32;
    }

    Matrix4x3d _properties(int n) {
        this.properties = n;
        return this;
    }

    Matrix4x3d _m00(double d) {
        this.m00 = d;
        return this;
    }

    Matrix4x3d _m01(double d) {
        this.m01 = d;
        return this;
    }

    Matrix4x3d _m02(double d) {
        this.m02 = d;
        return this;
    }

    Matrix4x3d _m10(double d) {
        this.m10 = d;
        return this;
    }

    Matrix4x3d _m11(double d) {
        this.m11 = d;
        return this;
    }

    Matrix4x3d _m12(double d) {
        this.m12 = d;
        return this;
    }

    Matrix4x3d _m20(double d) {
        this.m20 = d;
        return this;
    }

    Matrix4x3d _m21(double d) {
        this.m21 = d;
        return this;
    }

    Matrix4x3d _m22(double d) {
        this.m22 = d;
        return this;
    }

    Matrix4x3d _m30(double d) {
        this.m30 = d;
        return this;
    }

    Matrix4x3d _m31(double d) {
        this.m31 = d;
        return this;
    }

    Matrix4x3d _m32(double d) {
        this.m32 = d;
        return this;
    }

    public Matrix4x3d m00(double d) {
        this.m00 = d;
        this.properties &= 0xFFFFFFEF;
        if (d != 1.0) {
            this.properties &= 0xFFFFFFF3;
        }
        return this;
    }

    public Matrix4x3d m01(double d) {
        this.m01 = d;
        this.properties &= 0xFFFFFFEF;
        if (d != 0.0) {
            this.properties &= 0xFFFFFFF3;
        }
        return this;
    }

    public Matrix4x3d m02(double d) {
        this.m02 = d;
        this.properties &= 0xFFFFFFEF;
        if (d != 0.0) {
            this.properties &= 0xFFFFFFF3;
        }
        return this;
    }

    public Matrix4x3d m10(double d) {
        this.m10 = d;
        this.properties &= 0xFFFFFFEF;
        if (d != 0.0) {
            this.properties &= 0xFFFFFFF3;
        }
        return this;
    }

    public Matrix4x3d m11(double d) {
        this.m11 = d;
        this.properties &= 0xFFFFFFEF;
        if (d != 1.0) {
            this.properties &= 0xFFFFFFF3;
        }
        return this;
    }

    public Matrix4x3d m12(double d) {
        this.m12 = d;
        this.properties &= 0xFFFFFFEF;
        if (d != 0.0) {
            this.properties &= 0xFFFFFFF3;
        }
        return this;
    }

    public Matrix4x3d m20(double d) {
        this.m20 = d;
        this.properties &= 0xFFFFFFEF;
        if (d != 0.0) {
            this.properties &= 0xFFFFFFF3;
        }
        return this;
    }

    public Matrix4x3d m21(double d) {
        this.m21 = d;
        this.properties &= 0xFFFFFFEF;
        if (d != 0.0) {
            this.properties &= 0xFFFFFFF3;
        }
        return this;
    }

    public Matrix4x3d m22(double d) {
        this.m22 = d;
        this.properties &= 0xFFFFFFEF;
        if (d != 1.0) {
            this.properties &= 0xFFFFFFF3;
        }
        return this;
    }

    public Matrix4x3d m30(double d) {
        this.m30 = d;
        if (d != 0.0) {
            this.properties &= 0xFFFFFFFB;
        }
        return this;
    }

    public Matrix4x3d m31(double d) {
        this.m31 = d;
        if (d != 0.0) {
            this.properties &= 0xFFFFFFFB;
        }
        return this;
    }

    public Matrix4x3d m32(double d) {
        this.m32 = d;
        if (d != 0.0) {
            this.properties &= 0xFFFFFFFB;
        }
        return this;
    }

    public Matrix4x3d identity() {
        if ((this.properties & 4) != 0) {
            return this;
        }
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.properties = 28;
        return this;
    }

    public Matrix4x3d set(Matrix4x3dc matrix4x3dc) {
        this.m00 = matrix4x3dc.m00();
        this.m01 = matrix4x3dc.m01();
        this.m02 = matrix4x3dc.m02();
        this.m10 = matrix4x3dc.m10();
        this.m11 = matrix4x3dc.m11();
        this.m12 = matrix4x3dc.m12();
        this.m20 = matrix4x3dc.m20();
        this.m21 = matrix4x3dc.m21();
        this.m22 = matrix4x3dc.m22();
        this.m30 = matrix4x3dc.m30();
        this.m31 = matrix4x3dc.m31();
        this.m32 = matrix4x3dc.m32();
        this.properties = matrix4x3dc.properties();
        return this;
    }

    public Matrix4x3d set(Matrix4x3fc matrix4x3fc) {
        this.m00 = matrix4x3fc.m00();
        this.m01 = matrix4x3fc.m01();
        this.m02 = matrix4x3fc.m02();
        this.m10 = matrix4x3fc.m10();
        this.m11 = matrix4x3fc.m11();
        this.m12 = matrix4x3fc.m12();
        this.m20 = matrix4x3fc.m20();
        this.m21 = matrix4x3fc.m21();
        this.m22 = matrix4x3fc.m22();
        this.m30 = matrix4x3fc.m30();
        this.m31 = matrix4x3fc.m31();
        this.m32 = matrix4x3fc.m32();
        this.properties = matrix4x3fc.properties();
        return this;
    }

    public Matrix4x3d set(Matrix4dc matrix4dc) {
        this.m00 = matrix4dc.m00();
        this.m01 = matrix4dc.m01();
        this.m02 = matrix4dc.m02();
        this.m10 = matrix4dc.m10();
        this.m11 = matrix4dc.m11();
        this.m12 = matrix4dc.m12();
        this.m20 = matrix4dc.m20();
        this.m21 = matrix4dc.m21();
        this.m22 = matrix4dc.m22();
        this.m30 = matrix4dc.m30();
        this.m31 = matrix4dc.m31();
        this.m32 = matrix4dc.m32();
        this.properties = matrix4dc.properties() & 0x1C;
        return this;
    }

    @Override
    public Matrix4d get(Matrix4d matrix4d) {
        return matrix4d.set4x3(this);
    }

    public Matrix4x3d set(Matrix3dc matrix3dc) {
        this.m00 = matrix3dc.m00();
        this.m01 = matrix3dc.m01();
        this.m02 = matrix3dc.m02();
        this.m10 = matrix3dc.m10();
        this.m11 = matrix3dc.m11();
        this.m12 = matrix3dc.m12();
        this.m20 = matrix3dc.m20();
        this.m21 = matrix3dc.m21();
        this.m22 = matrix3dc.m22();
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        return this.determineProperties();
    }

    public Matrix4x3d set(Matrix3fc matrix3fc) {
        this.m00 = matrix3fc.m00();
        this.m01 = matrix3fc.m01();
        this.m02 = matrix3fc.m02();
        this.m10 = matrix3fc.m10();
        this.m11 = matrix3fc.m11();
        this.m12 = matrix3fc.m12();
        this.m20 = matrix3fc.m20();
        this.m21 = matrix3fc.m21();
        this.m22 = matrix3fc.m22();
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        return this.determineProperties();
    }

    public Matrix4x3d set(Vector3dc vector3dc, Vector3dc vector3dc2, Vector3dc vector3dc3, Vector3dc vector3dc4) {
        this.m00 = vector3dc.x();
        this.m01 = vector3dc.y();
        this.m02 = vector3dc.z();
        this.m10 = vector3dc2.x();
        this.m11 = vector3dc2.y();
        this.m12 = vector3dc2.z();
        this.m20 = vector3dc3.x();
        this.m21 = vector3dc3.y();
        this.m22 = vector3dc3.z();
        this.m30 = vector3dc4.x();
        this.m31 = vector3dc4.y();
        this.m32 = vector3dc4.z();
        return this.determineProperties();
    }

    public Matrix4x3d set3x3(Matrix4x3dc matrix4x3dc) {
        this.m00 = matrix4x3dc.m00();
        this.m01 = matrix4x3dc.m01();
        this.m02 = matrix4x3dc.m02();
        this.m10 = matrix4x3dc.m10();
        this.m11 = matrix4x3dc.m11();
        this.m12 = matrix4x3dc.m12();
        this.m20 = matrix4x3dc.m20();
        this.m21 = matrix4x3dc.m21();
        this.m22 = matrix4x3dc.m22();
        this.properties &= matrix4x3dc.properties();
        return this;
    }

    public Matrix4x3d set(AxisAngle4f axisAngle4f) {
        double d = axisAngle4f.x;
        double d2 = axisAngle4f.y;
        double d3 = axisAngle4f.z;
        double d4 = axisAngle4f.angle;
        double d5 = Math.invsqrt(d * d + d2 * d2 + d3 * d3);
        d *= d5;
        d2 *= d5;
        d3 *= d5;
        double d6 = Math.sin(d4);
        double d7 = Math.cosFromSin(d6, d4);
        double d8 = 1.0 - d7;
        this.m00 = d7 + d * d * d8;
        this.m11 = d7 + d2 * d2 * d8;
        this.m22 = d7 + d3 * d3 * d8;
        double d9 = d * d2 * d8;
        double d10 = d3 * d6;
        this.m10 = d9 - d10;
        this.m01 = d9 + d10;
        d9 = d * d3 * d8;
        d10 = d2 * d6;
        this.m20 = d9 + d10;
        this.m02 = d9 - d10;
        d9 = d2 * d3 * d8;
        d10 = d * d6;
        this.m21 = d9 - d10;
        this.m12 = d9 + d10;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.properties = 16;
        return this;
    }

    public Matrix4x3d set(AxisAngle4d axisAngle4d) {
        double d = axisAngle4d.x;
        double d2 = axisAngle4d.y;
        double d3 = axisAngle4d.z;
        double d4 = axisAngle4d.angle;
        double d5 = Math.invsqrt(d * d + d2 * d2 + d3 * d3);
        d *= d5;
        d2 *= d5;
        d3 *= d5;
        double d6 = Math.sin(d4);
        double d7 = Math.cosFromSin(d6, d4);
        double d8 = 1.0 - d7;
        this.m00 = d7 + d * d * d8;
        this.m11 = d7 + d2 * d2 * d8;
        this.m22 = d7 + d3 * d3 * d8;
        double d9 = d * d2 * d8;
        double d10 = d3 * d6;
        this.m10 = d9 - d10;
        this.m01 = d9 + d10;
        d9 = d * d3 * d8;
        d10 = d2 * d6;
        this.m20 = d9 + d10;
        this.m02 = d9 - d10;
        d9 = d2 * d3 * d8;
        d10 = d * d6;
        this.m21 = d9 - d10;
        this.m12 = d9 + d10;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.properties = 16;
        return this;
    }

    public Matrix4x3d set(Quaternionfc quaternionfc) {
        return this.rotation(quaternionfc);
    }

    public Matrix4x3d set(Quaterniondc quaterniondc) {
        return this.rotation(quaterniondc);
    }

    public Matrix4x3d mul(Matrix4x3dc matrix4x3dc) {
        return this.mul(matrix4x3dc, this);
    }

    @Override
    public Matrix4x3d mul(Matrix4x3dc matrix4x3dc, Matrix4x3d matrix4x3d) {
        if ((this.properties & 4) != 0) {
            return matrix4x3d.set(matrix4x3dc);
        }
        if ((matrix4x3dc.properties() & 4) != 0) {
            return matrix4x3d.set(this);
        }
        if ((this.properties & 8) != 0) {
            return this.mulTranslation(matrix4x3dc, matrix4x3d);
        }
        return this.mulGeneric(matrix4x3dc, matrix4x3d);
    }

    private Matrix4x3d mulGeneric(Matrix4x3dc matrix4x3dc, Matrix4x3d matrix4x3d) {
        double d = this.m00;
        double d2 = this.m01;
        double d3 = this.m02;
        double d4 = this.m10;
        double d5 = this.m11;
        double d6 = this.m12;
        double d7 = this.m20;
        double d8 = this.m21;
        double d9 = this.m22;
        double d10 = matrix4x3dc.m00();
        double d11 = matrix4x3dc.m01();
        double d12 = matrix4x3dc.m02();
        double d13 = matrix4x3dc.m10();
        double d14 = matrix4x3dc.m11();
        double d15 = matrix4x3dc.m12();
        double d16 = matrix4x3dc.m20();
        double d17 = matrix4x3dc.m21();
        double d18 = matrix4x3dc.m22();
        double d19 = matrix4x3dc.m30();
        double d20 = matrix4x3dc.m31();
        double d21 = matrix4x3dc.m32();
        return matrix4x3d._m00(Math.fma(d, d10, Math.fma(d4, d11, d7 * d12)))._m01(Math.fma(d2, d10, Math.fma(d5, d11, d8 * d12)))._m02(Math.fma(d3, d10, Math.fma(d6, d11, d9 * d12)))._m10(Math.fma(d, d13, Math.fma(d4, d14, d7 * d15)))._m11(Math.fma(d2, d13, Math.fma(d5, d14, d8 * d15)))._m12(Math.fma(d3, d13, Math.fma(d6, d14, d9 * d15)))._m20(Math.fma(d, d16, Math.fma(d4, d17, d7 * d18)))._m21(Math.fma(d2, d16, Math.fma(d5, d17, d8 * d18)))._m22(Math.fma(d3, d16, Math.fma(d6, d17, d9 * d18)))._m30(Math.fma(d, d19, Math.fma(d4, d20, Math.fma(d7, d21, this.m30))))._m31(Math.fma(d2, d19, Math.fma(d5, d20, Math.fma(d8, d21, this.m31))))._m32(Math.fma(d3, d19, Math.fma(d6, d20, Math.fma(d9, d21, this.m32))))._properties(this.properties & matrix4x3dc.properties() & 0x10);
    }

    public Matrix4x3d mul(Matrix4x3fc matrix4x3fc) {
        return this.mul(matrix4x3fc, this);
    }

    @Override
    public Matrix4x3d mul(Matrix4x3fc matrix4x3fc, Matrix4x3d matrix4x3d) {
        if ((this.properties & 4) != 0) {
            return matrix4x3d.set(matrix4x3fc);
        }
        if ((matrix4x3fc.properties() & 4) != 0) {
            return matrix4x3d.set(this);
        }
        if ((this.properties & 8) != 0) {
            return this.mulTranslation(matrix4x3fc, matrix4x3d);
        }
        return this.mulGeneric(matrix4x3fc, matrix4x3d);
    }

    private Matrix4x3d mulGeneric(Matrix4x3fc matrix4x3fc, Matrix4x3d matrix4x3d) {
        double d = this.m00;
        double d2 = this.m01;
        double d3 = this.m02;
        double d4 = this.m10;
        double d5 = this.m11;
        double d6 = this.m12;
        double d7 = this.m20;
        double d8 = this.m21;
        double d9 = this.m22;
        double d10 = matrix4x3fc.m00();
        double d11 = matrix4x3fc.m01();
        double d12 = matrix4x3fc.m02();
        double d13 = matrix4x3fc.m10();
        double d14 = matrix4x3fc.m11();
        double d15 = matrix4x3fc.m12();
        double d16 = matrix4x3fc.m20();
        double d17 = matrix4x3fc.m21();
        double d18 = matrix4x3fc.m22();
        double d19 = matrix4x3fc.m30();
        double d20 = matrix4x3fc.m31();
        double d21 = matrix4x3fc.m32();
        return matrix4x3d._m00(Math.fma(d, d10, Math.fma(d4, d11, d7 * d12)))._m01(Math.fma(d2, d10, Math.fma(d5, d11, d8 * d12)))._m02(Math.fma(d3, d10, Math.fma(d6, d11, d9 * d12)))._m10(Math.fma(d, d13, Math.fma(d4, d14, d7 * d15)))._m11(Math.fma(d2, d13, Math.fma(d5, d14, d8 * d15)))._m12(Math.fma(d3, d13, Math.fma(d6, d14, d9 * d15)))._m20(Math.fma(d, d16, Math.fma(d4, d17, d7 * d18)))._m21(Math.fma(d2, d16, Math.fma(d5, d17, d8 * d18)))._m22(Math.fma(d3, d16, Math.fma(d6, d17, d9 * d18)))._m30(Math.fma(d, d19, Math.fma(d4, d20, Math.fma(d7, d21, this.m30))))._m31(Math.fma(d2, d19, Math.fma(d5, d20, Math.fma(d8, d21, this.m31))))._m32(Math.fma(d3, d19, Math.fma(d6, d20, Math.fma(d9, d21, this.m32))))._properties(this.properties & matrix4x3fc.properties() & 0x10);
    }

    @Override
    public Matrix4x3d mulTranslation(Matrix4x3dc matrix4x3dc, Matrix4x3d matrix4x3d) {
        return matrix4x3d._m00(matrix4x3dc.m00())._m01(matrix4x3dc.m01())._m02(matrix4x3dc.m02())._m10(matrix4x3dc.m10())._m11(matrix4x3dc.m11())._m12(matrix4x3dc.m12())._m20(matrix4x3dc.m20())._m21(matrix4x3dc.m21())._m22(matrix4x3dc.m22())._m30(matrix4x3dc.m30() + this.m30)._m31(matrix4x3dc.m31() + this.m31)._m32(matrix4x3dc.m32() + this.m32)._properties(matrix4x3dc.properties() & 0x10);
    }

    @Override
    public Matrix4x3d mulTranslation(Matrix4x3fc matrix4x3fc, Matrix4x3d matrix4x3d) {
        return matrix4x3d._m00(matrix4x3fc.m00())._m01(matrix4x3fc.m01())._m02(matrix4x3fc.m02())._m10(matrix4x3fc.m10())._m11(matrix4x3fc.m11())._m12(matrix4x3fc.m12())._m20(matrix4x3fc.m20())._m21(matrix4x3fc.m21())._m22(matrix4x3fc.m22())._m30((double)matrix4x3fc.m30() + this.m30)._m31((double)matrix4x3fc.m31() + this.m31)._m32((double)matrix4x3fc.m32() + this.m32)._properties(matrix4x3fc.properties() & 0x10);
    }

    public Matrix4x3d mulOrtho(Matrix4x3dc matrix4x3dc) {
        return this.mulOrtho(matrix4x3dc, this);
    }

    @Override
    public Matrix4x3d mulOrtho(Matrix4x3dc matrix4x3dc, Matrix4x3d matrix4x3d) {
        double d = this.m00 * matrix4x3dc.m00();
        double d2 = this.m11 * matrix4x3dc.m01();
        double d3 = this.m22 * matrix4x3dc.m02();
        double d4 = this.m00 * matrix4x3dc.m10();
        double d5 = this.m11 * matrix4x3dc.m11();
        double d6 = this.m22 * matrix4x3dc.m12();
        double d7 = this.m00 * matrix4x3dc.m20();
        double d8 = this.m11 * matrix4x3dc.m21();
        double d9 = this.m22 * matrix4x3dc.m22();
        double d10 = this.m00 * matrix4x3dc.m30() + this.m30;
        double d11 = this.m11 * matrix4x3dc.m31() + this.m31;
        double d12 = this.m22 * matrix4x3dc.m32() + this.m32;
        matrix4x3d.m00 = d;
        matrix4x3d.m01 = d2;
        matrix4x3d.m02 = d3;
        matrix4x3d.m10 = d4;
        matrix4x3d.m11 = d5;
        matrix4x3d.m12 = d6;
        matrix4x3d.m20 = d7;
        matrix4x3d.m21 = d8;
        matrix4x3d.m22 = d9;
        matrix4x3d.m30 = d10;
        matrix4x3d.m31 = d11;
        matrix4x3d.m32 = d12;
        matrix4x3d.properties = this.properties & matrix4x3dc.properties() & 0x10;
        return matrix4x3d;
    }

    public Matrix4x3d fma(Matrix4x3dc matrix4x3dc, double d) {
        return this.fma(matrix4x3dc, d, this);
    }

    @Override
    public Matrix4x3d fma(Matrix4x3dc matrix4x3dc, double d, Matrix4x3d matrix4x3d) {
        matrix4x3d._m00(Math.fma(matrix4x3dc.m00(), d, this.m00))._m01(Math.fma(matrix4x3dc.m01(), d, this.m01))._m02(Math.fma(matrix4x3dc.m02(), d, this.m02))._m10(Math.fma(matrix4x3dc.m10(), d, this.m10))._m11(Math.fma(matrix4x3dc.m11(), d, this.m11))._m12(Math.fma(matrix4x3dc.m12(), d, this.m12))._m20(Math.fma(matrix4x3dc.m20(), d, this.m20))._m21(Math.fma(matrix4x3dc.m21(), d, this.m21))._m22(Math.fma(matrix4x3dc.m22(), d, this.m22))._m30(Math.fma(matrix4x3dc.m30(), d, this.m30))._m31(Math.fma(matrix4x3dc.m31(), d, this.m31))._m32(Math.fma(matrix4x3dc.m32(), d, this.m32))._properties(0);
        return matrix4x3d;
    }

    public Matrix4x3d fma(Matrix4x3fc matrix4x3fc, double d) {
        return this.fma(matrix4x3fc, d, this);
    }

    @Override
    public Matrix4x3d fma(Matrix4x3fc matrix4x3fc, double d, Matrix4x3d matrix4x3d) {
        matrix4x3d._m00(Math.fma((double)matrix4x3fc.m00(), d, this.m00))._m01(Math.fma((double)matrix4x3fc.m01(), d, this.m01))._m02(Math.fma((double)matrix4x3fc.m02(), d, this.m02))._m10(Math.fma((double)matrix4x3fc.m10(), d, this.m10))._m11(Math.fma((double)matrix4x3fc.m11(), d, this.m11))._m12(Math.fma((double)matrix4x3fc.m12(), d, this.m12))._m20(Math.fma((double)matrix4x3fc.m20(), d, this.m20))._m21(Math.fma((double)matrix4x3fc.m21(), d, this.m21))._m22(Math.fma((double)matrix4x3fc.m22(), d, this.m22))._m30(Math.fma((double)matrix4x3fc.m30(), d, this.m30))._m31(Math.fma((double)matrix4x3fc.m31(), d, this.m31))._m32(Math.fma((double)matrix4x3fc.m32(), d, this.m32))._properties(0);
        return matrix4x3d;
    }

    public Matrix4x3d add(Matrix4x3dc matrix4x3dc) {
        return this.add(matrix4x3dc, this);
    }

    @Override
    public Matrix4x3d add(Matrix4x3dc matrix4x3dc, Matrix4x3d matrix4x3d) {
        matrix4x3d.m00 = this.m00 + matrix4x3dc.m00();
        matrix4x3d.m01 = this.m01 + matrix4x3dc.m01();
        matrix4x3d.m02 = this.m02 + matrix4x3dc.m02();
        matrix4x3d.m10 = this.m10 + matrix4x3dc.m10();
        matrix4x3d.m11 = this.m11 + matrix4x3dc.m11();
        matrix4x3d.m12 = this.m12 + matrix4x3dc.m12();
        matrix4x3d.m20 = this.m20 + matrix4x3dc.m20();
        matrix4x3d.m21 = this.m21 + matrix4x3dc.m21();
        matrix4x3d.m22 = this.m22 + matrix4x3dc.m22();
        matrix4x3d.m30 = this.m30 + matrix4x3dc.m30();
        matrix4x3d.m31 = this.m31 + matrix4x3dc.m31();
        matrix4x3d.m32 = this.m32 + matrix4x3dc.m32();
        matrix4x3d.properties = 0;
        return matrix4x3d;
    }

    public Matrix4x3d add(Matrix4x3fc matrix4x3fc) {
        return this.add(matrix4x3fc, this);
    }

    @Override
    public Matrix4x3d add(Matrix4x3fc matrix4x3fc, Matrix4x3d matrix4x3d) {
        matrix4x3d.m00 = this.m00 + (double)matrix4x3fc.m00();
        matrix4x3d.m01 = this.m01 + (double)matrix4x3fc.m01();
        matrix4x3d.m02 = this.m02 + (double)matrix4x3fc.m02();
        matrix4x3d.m10 = this.m10 + (double)matrix4x3fc.m10();
        matrix4x3d.m11 = this.m11 + (double)matrix4x3fc.m11();
        matrix4x3d.m12 = this.m12 + (double)matrix4x3fc.m12();
        matrix4x3d.m20 = this.m20 + (double)matrix4x3fc.m20();
        matrix4x3d.m21 = this.m21 + (double)matrix4x3fc.m21();
        matrix4x3d.m22 = this.m22 + (double)matrix4x3fc.m22();
        matrix4x3d.m30 = this.m30 + (double)matrix4x3fc.m30();
        matrix4x3d.m31 = this.m31 + (double)matrix4x3fc.m31();
        matrix4x3d.m32 = this.m32 + (double)matrix4x3fc.m32();
        matrix4x3d.properties = 0;
        return matrix4x3d;
    }

    public Matrix4x3d sub(Matrix4x3dc matrix4x3dc) {
        return this.sub(matrix4x3dc, this);
    }

    @Override
    public Matrix4x3d sub(Matrix4x3dc matrix4x3dc, Matrix4x3d matrix4x3d) {
        matrix4x3d.m00 = this.m00 - matrix4x3dc.m00();
        matrix4x3d.m01 = this.m01 - matrix4x3dc.m01();
        matrix4x3d.m02 = this.m02 - matrix4x3dc.m02();
        matrix4x3d.m10 = this.m10 - matrix4x3dc.m10();
        matrix4x3d.m11 = this.m11 - matrix4x3dc.m11();
        matrix4x3d.m12 = this.m12 - matrix4x3dc.m12();
        matrix4x3d.m20 = this.m20 - matrix4x3dc.m20();
        matrix4x3d.m21 = this.m21 - matrix4x3dc.m21();
        matrix4x3d.m22 = this.m22 - matrix4x3dc.m22();
        matrix4x3d.m30 = this.m30 - matrix4x3dc.m30();
        matrix4x3d.m31 = this.m31 - matrix4x3dc.m31();
        matrix4x3d.m32 = this.m32 - matrix4x3dc.m32();
        matrix4x3d.properties = 0;
        return matrix4x3d;
    }

    public Matrix4x3d sub(Matrix4x3fc matrix4x3fc) {
        return this.sub(matrix4x3fc, this);
    }

    @Override
    public Matrix4x3d sub(Matrix4x3fc matrix4x3fc, Matrix4x3d matrix4x3d) {
        matrix4x3d.m00 = this.m00 - (double)matrix4x3fc.m00();
        matrix4x3d.m01 = this.m01 - (double)matrix4x3fc.m01();
        matrix4x3d.m02 = this.m02 - (double)matrix4x3fc.m02();
        matrix4x3d.m10 = this.m10 - (double)matrix4x3fc.m10();
        matrix4x3d.m11 = this.m11 - (double)matrix4x3fc.m11();
        matrix4x3d.m12 = this.m12 - (double)matrix4x3fc.m12();
        matrix4x3d.m20 = this.m20 - (double)matrix4x3fc.m20();
        matrix4x3d.m21 = this.m21 - (double)matrix4x3fc.m21();
        matrix4x3d.m22 = this.m22 - (double)matrix4x3fc.m22();
        matrix4x3d.m30 = this.m30 - (double)matrix4x3fc.m30();
        matrix4x3d.m31 = this.m31 - (double)matrix4x3fc.m31();
        matrix4x3d.m32 = this.m32 - (double)matrix4x3fc.m32();
        matrix4x3d.properties = 0;
        return matrix4x3d;
    }

    public Matrix4x3d mulComponentWise(Matrix4x3dc matrix4x3dc) {
        return this.mulComponentWise(matrix4x3dc, this);
    }

    @Override
    public Matrix4x3d mulComponentWise(Matrix4x3dc matrix4x3dc, Matrix4x3d matrix4x3d) {
        matrix4x3d.m00 = this.m00 * matrix4x3dc.m00();
        matrix4x3d.m01 = this.m01 * matrix4x3dc.m01();
        matrix4x3d.m02 = this.m02 * matrix4x3dc.m02();
        matrix4x3d.m10 = this.m10 * matrix4x3dc.m10();
        matrix4x3d.m11 = this.m11 * matrix4x3dc.m11();
        matrix4x3d.m12 = this.m12 * matrix4x3dc.m12();
        matrix4x3d.m20 = this.m20 * matrix4x3dc.m20();
        matrix4x3d.m21 = this.m21 * matrix4x3dc.m21();
        matrix4x3d.m22 = this.m22 * matrix4x3dc.m22();
        matrix4x3d.m30 = this.m30 * matrix4x3dc.m30();
        matrix4x3d.m31 = this.m31 * matrix4x3dc.m31();
        matrix4x3d.m32 = this.m32 * matrix4x3dc.m32();
        matrix4x3d.properties = 0;
        return matrix4x3d;
    }

    public Matrix4x3d set(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        this.m00 = d;
        this.m10 = d4;
        this.m20 = d7;
        this.m30 = d10;
        this.m01 = d2;
        this.m11 = d5;
        this.m21 = d8;
        this.m31 = d11;
        this.m02 = d3;
        this.m12 = d6;
        this.m22 = d9;
        this.m32 = d12;
        return this.determineProperties();
    }

    public Matrix4x3d set(double[] dArray, int n) {
        this.m00 = dArray[n + 0];
        this.m01 = dArray[n + 1];
        this.m02 = dArray[n + 2];
        this.m10 = dArray[n + 3];
        this.m11 = dArray[n + 4];
        this.m12 = dArray[n + 5];
        this.m20 = dArray[n + 6];
        this.m21 = dArray[n + 7];
        this.m22 = dArray[n + 8];
        this.m30 = dArray[n + 9];
        this.m31 = dArray[n + 10];
        this.m32 = dArray[n + 11];
        return this.determineProperties();
    }

    public Matrix4x3d set(double[] dArray) {
        return this.set(dArray, 0);
    }

    public Matrix4x3d set(float[] fArray, int n) {
        this.m00 = fArray[n + 0];
        this.m01 = fArray[n + 1];
        this.m02 = fArray[n + 2];
        this.m10 = fArray[n + 3];
        this.m11 = fArray[n + 4];
        this.m12 = fArray[n + 5];
        this.m20 = fArray[n + 6];
        this.m21 = fArray[n + 7];
        this.m22 = fArray[n + 8];
        this.m30 = fArray[n + 9];
        this.m31 = fArray[n + 10];
        this.m32 = fArray[n + 11];
        return this.determineProperties();
    }

    public Matrix4x3d set(float[] fArray) {
        return this.set(fArray, 0);
    }

    public Matrix4x3d set(DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.get(this, doubleBuffer.position(), doubleBuffer);
        return this.determineProperties();
    }

    public Matrix4x3d set(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.getf(this, floatBuffer.position(), floatBuffer);
        return this.determineProperties();
    }

    public Matrix4x3d set(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
        return this.determineProperties();
    }

    public Matrix4x3d setFloats(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.getf(this, byteBuffer.position(), byteBuffer);
        return this.determineProperties();
    }

    public Matrix4x3d setFromAddress(long l) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil.MemUtilUnsafe.get(this, l);
        return this.determineProperties();
    }

    @Override
    public double determinant() {
        return (this.m00 * this.m11 - this.m01 * this.m10) * this.m22 + (this.m02 * this.m10 - this.m00 * this.m12) * this.m21 + (this.m01 * this.m12 - this.m02 * this.m11) * this.m20;
    }

    public Matrix4x3d invert() {
        return this.invert(this);
    }

    @Override
    public Matrix4x3d invert(Matrix4x3d matrix4x3d) {
        if ((this.properties & 4) != 0) {
            return matrix4x3d.identity();
        }
        if ((this.properties & 0x10) != 0) {
            return this.invertOrthonormal(matrix4x3d);
        }
        return this.invertGeneric(matrix4x3d);
    }

    private Matrix4x3d invertGeneric(Matrix4x3d matrix4x3d) {
        double d = this.m00 * this.m11;
        double d2 = this.m01 * this.m10;
        double d3 = this.m02 * this.m10;
        double d4 = this.m00 * this.m12;
        double d5 = this.m01 * this.m12;
        double d6 = this.m02 * this.m11;
        double d7 = 1.0 / ((d - d2) * this.m22 + (d3 - d4) * this.m21 + (d5 - d6) * this.m20);
        double d8 = this.m10 * this.m22;
        double d9 = this.m10 * this.m21;
        double d10 = this.m11 * this.m22;
        double d11 = this.m11 * this.m20;
        double d12 = this.m12 * this.m21;
        double d13 = this.m12 * this.m20;
        double d14 = this.m20 * this.m02;
        double d15 = this.m20 * this.m01;
        double d16 = this.m21 * this.m02;
        double d17 = this.m21 * this.m00;
        double d18 = this.m22 * this.m01;
        double d19 = this.m22 * this.m00;
        double d20 = (d10 - d12) * d7;
        double d21 = (d16 - d18) * d7;
        double d22 = (d5 - d6) * d7;
        double d23 = (d13 - d8) * d7;
        double d24 = (d19 - d14) * d7;
        double d25 = (d3 - d4) * d7;
        double d26 = (d9 - d11) * d7;
        double d27 = (d15 - d17) * d7;
        double d28 = (d - d2) * d7;
        double d29 = (d8 * this.m31 - d9 * this.m32 + d11 * this.m32 - d10 * this.m30 + d12 * this.m30 - d13 * this.m31) * d7;
        double d30 = (d14 * this.m31 - d15 * this.m32 + d17 * this.m32 - d16 * this.m30 + d18 * this.m30 - d19 * this.m31) * d7;
        double d31 = (d6 * this.m30 - d5 * this.m30 + d4 * this.m31 - d3 * this.m31 + d2 * this.m32 - d * this.m32) * d7;
        matrix4x3d.m00 = d20;
        matrix4x3d.m01 = d21;
        matrix4x3d.m02 = d22;
        matrix4x3d.m10 = d23;
        matrix4x3d.m11 = d24;
        matrix4x3d.m12 = d25;
        matrix4x3d.m20 = d26;
        matrix4x3d.m21 = d27;
        matrix4x3d.m22 = d28;
        matrix4x3d.m30 = d29;
        matrix4x3d.m31 = d30;
        matrix4x3d.m32 = d31;
        matrix4x3d.properties = 0;
        return matrix4x3d;
    }

    private Matrix4x3d invertOrthonormal(Matrix4x3d matrix4x3d) {
        double d = -(this.m00 * this.m30 + this.m01 * this.m31 + this.m02 * this.m32);
        double d2 = -(this.m10 * this.m30 + this.m11 * this.m31 + this.m12 * this.m32);
        double d3 = -(this.m20 * this.m30 + this.m21 * this.m31 + this.m22 * this.m32);
        double d4 = this.m01;
        double d5 = this.m02;
        double d6 = this.m12;
        matrix4x3d.m00 = this.m00;
        matrix4x3d.m01 = this.m10;
        matrix4x3d.m02 = this.m20;
        matrix4x3d.m10 = d4;
        matrix4x3d.m11 = this.m11;
        matrix4x3d.m12 = this.m21;
        matrix4x3d.m20 = d5;
        matrix4x3d.m21 = d6;
        matrix4x3d.m22 = this.m22;
        matrix4x3d.m30 = d;
        matrix4x3d.m31 = d2;
        matrix4x3d.m32 = d3;
        matrix4x3d.properties = 16;
        return matrix4x3d;
    }

    @Override
    public Matrix4x3d invertOrtho(Matrix4x3d matrix4x3d) {
        double d = 1.0 / this.m00;
        double d2 = 1.0 / this.m11;
        double d3 = 1.0 / this.m22;
        matrix4x3d.set(d, 0.0, 0.0, 0.0, d2, 0.0, 0.0, 0.0, d3, -this.m30 * d, -this.m31 * d2, -this.m32 * d3);
        matrix4x3d.properties = 0;
        return matrix4x3d;
    }

    public Matrix4x3d invertOrtho() {
        return this.invertOrtho(this);
    }

    public Matrix4x3d transpose3x3() {
        return this.transpose3x3(this);
    }

    @Override
    public Matrix4x3d transpose3x3(Matrix4x3d matrix4x3d) {
        double d = this.m00;
        double d2 = this.m10;
        double d3 = this.m20;
        double d4 = this.m01;
        double d5 = this.m11;
        double d6 = this.m21;
        double d7 = this.m02;
        double d8 = this.m12;
        double d9 = this.m22;
        matrix4x3d.m00 = d;
        matrix4x3d.m01 = d2;
        matrix4x3d.m02 = d3;
        matrix4x3d.m10 = d4;
        matrix4x3d.m11 = d5;
        matrix4x3d.m12 = d6;
        matrix4x3d.m20 = d7;
        matrix4x3d.m21 = d8;
        matrix4x3d.m22 = d9;
        matrix4x3d.properties = this.properties;
        return matrix4x3d;
    }

    @Override
    public Matrix3d transpose3x3(Matrix3d matrix3d) {
        matrix3d.m00(this.m00);
        matrix3d.m01(this.m10);
        matrix3d.m02(this.m20);
        matrix3d.m10(this.m01);
        matrix3d.m11(this.m11);
        matrix3d.m12(this.m21);
        matrix3d.m20(this.m02);
        matrix3d.m21(this.m12);
        matrix3d.m22(this.m22);
        return matrix3d;
    }

    public Matrix4x3d translation(double d, double d2, double d3) {
        if ((this.properties & 4) == 0) {
            this.identity();
        }
        this.m30 = d;
        this.m31 = d2;
        this.m32 = d3;
        this.properties = 24;
        return this;
    }

    public Matrix4x3d translation(Vector3fc vector3fc) {
        return this.translation(vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public Matrix4x3d translation(Vector3dc vector3dc) {
        return this.translation(vector3dc.x(), vector3dc.y(), vector3dc.z());
    }

    public Matrix4x3d setTranslation(double d, double d2, double d3) {
        this.m30 = d;
        this.m31 = d2;
        this.m32 = d3;
        this.properties &= 0xFFFFFFFB;
        return this;
    }

    public Matrix4x3d setTranslation(Vector3dc vector3dc) {
        return this.setTranslation(vector3dc.x(), vector3dc.y(), vector3dc.z());
    }

    @Override
    public Vector3d getTranslation(Vector3d vector3d) {
        vector3d.x = this.m30;
        vector3d.y = this.m31;
        vector3d.z = this.m32;
        return vector3d;
    }

    @Override
    public Vector3d getScale(Vector3d vector3d) {
        vector3d.x = Math.sqrt(this.m00 * this.m00 + this.m01 * this.m01 + this.m02 * this.m02);
        vector3d.y = Math.sqrt(this.m10 * this.m10 + this.m11 * this.m11 + this.m12 * this.m12);
        vector3d.z = Math.sqrt(this.m20 * this.m20 + this.m21 * this.m21 + this.m22 * this.m22);
        return vector3d;
    }

    public String toString() {
        DecimalFormat decimalFormat = new DecimalFormat(" 0.000E0;-");
        String string = this.toString(decimalFormat);
        StringBuffer stringBuffer = new StringBuffer();
        int n = Integer.MIN_VALUE;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == 'E') {
                n = i;
            } else {
                if (c == ' ' && n == i - 1) {
                    stringBuffer.append('+');
                    continue;
                }
                if (Character.isDigit(c) && n == i - 1) {
                    stringBuffer.append('+');
                }
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public String toString(NumberFormat numberFormat) {
        return Runtime.format(this.m00, numberFormat) + " " + Runtime.format(this.m10, numberFormat) + " " + Runtime.format(this.m20, numberFormat) + " " + Runtime.format(this.m30, numberFormat) + "\n" + Runtime.format(this.m01, numberFormat) + " " + Runtime.format(this.m11, numberFormat) + " " + Runtime.format(this.m21, numberFormat) + " " + Runtime.format(this.m31, numberFormat) + "\n" + Runtime.format(this.m02, numberFormat) + " " + Runtime.format(this.m12, numberFormat) + " " + Runtime.format(this.m22, numberFormat) + " " + Runtime.format(this.m32, numberFormat) + "\n";
    }

    @Override
    public Matrix4x3d get(Matrix4x3d matrix4x3d) {
        return matrix4x3d.set(this);
    }

    @Override
    public Quaternionf getUnnormalizedRotation(Quaternionf quaternionf) {
        return quaternionf.setFromUnnormalized(this);
    }

    @Override
    public Quaternionf getNormalizedRotation(Quaternionf quaternionf) {
        return quaternionf.setFromNormalized(this);
    }

    @Override
    public Quaterniond getUnnormalizedRotation(Quaterniond quaterniond) {
        return quaterniond.setFromUnnormalized(this);
    }

    @Override
    public Quaterniond getNormalizedRotation(Quaterniond quaterniond) {
        return quaterniond.setFromNormalized(this);
    }

    @Override
    public DoubleBuffer get(DoubleBuffer doubleBuffer) {
        return this.get(doubleBuffer.position(), doubleBuffer);
    }

    @Override
    public DoubleBuffer get(int n, DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.put(this, n, doubleBuffer);
        return doubleBuffer;
    }

    @Override
    public FloatBuffer get(FloatBuffer floatBuffer) {
        return this.get(floatBuffer.position(), floatBuffer);
    }

    @Override
    public FloatBuffer get(int n, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.putf(this, n, floatBuffer);
        return floatBuffer;
    }

    @Override
    public ByteBuffer get(ByteBuffer byteBuffer) {
        return this.get(byteBuffer.position(), byteBuffer);
    }

    @Override
    public ByteBuffer get(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, n, byteBuffer);
        return byteBuffer;
    }

    @Override
    public ByteBuffer getFloats(ByteBuffer byteBuffer) {
        return this.getFloats(byteBuffer.position(), byteBuffer);
    }

    @Override
    public ByteBuffer getFloats(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.putf(this, n, byteBuffer);
        return byteBuffer;
    }

    @Override
    public Matrix4x3dc getToAddress(long l) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil.MemUtilUnsafe.put(this, l);
        return this;
    }

    @Override
    public double[] get(double[] dArray, int n) {
        dArray[n + 0] = this.m00;
        dArray[n + 1] = this.m01;
        dArray[n + 2] = this.m02;
        dArray[n + 3] = this.m10;
        dArray[n + 4] = this.m11;
        dArray[n + 5] = this.m12;
        dArray[n + 6] = this.m20;
        dArray[n + 7] = this.m21;
        dArray[n + 8] = this.m22;
        dArray[n + 9] = this.m30;
        dArray[n + 10] = this.m31;
        dArray[n + 11] = this.m32;
        return dArray;
    }

    @Override
    public double[] get(double[] dArray) {
        return this.get(dArray, 0);
    }

    @Override
    public float[] get(float[] fArray, int n) {
        fArray[n + 0] = (float)this.m00;
        fArray[n + 1] = (float)this.m01;
        fArray[n + 2] = (float)this.m02;
        fArray[n + 3] = (float)this.m10;
        fArray[n + 4] = (float)this.m11;
        fArray[n + 5] = (float)this.m12;
        fArray[n + 6] = (float)this.m20;
        fArray[n + 7] = (float)this.m21;
        fArray[n + 8] = (float)this.m22;
        fArray[n + 9] = (float)this.m30;
        fArray[n + 10] = (float)this.m31;
        fArray[n + 11] = (float)this.m32;
        return fArray;
    }

    @Override
    public float[] get(float[] fArray) {
        return this.get(fArray, 0);
    }

    @Override
    public float[] get4x4(float[] fArray, int n) {
        MemUtil.INSTANCE.copy4x4(this, fArray, n);
        return fArray;
    }

    @Override
    public float[] get4x4(float[] fArray) {
        return this.get4x4(fArray, 0);
    }

    @Override
    public double[] get4x4(double[] dArray, int n) {
        MemUtil.INSTANCE.copy4x4(this, dArray, n);
        return dArray;
    }

    @Override
    public double[] get4x4(double[] dArray) {
        return this.get4x4(dArray, 0);
    }

    @Override
    public DoubleBuffer get4x4(DoubleBuffer doubleBuffer) {
        return this.get4x4(doubleBuffer.position(), doubleBuffer);
    }

    @Override
    public DoubleBuffer get4x4(int n, DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.put4x4(this, n, doubleBuffer);
        return doubleBuffer;
    }

    @Override
    public ByteBuffer get4x4(ByteBuffer byteBuffer) {
        return this.get4x4(byteBuffer.position(), byteBuffer);
    }

    @Override
    public ByteBuffer get4x4(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put4x4(this, n, byteBuffer);
        return byteBuffer;
    }

    @Override
    public DoubleBuffer getTransposed(DoubleBuffer doubleBuffer) {
        return this.getTransposed(doubleBuffer.position(), doubleBuffer);
    }

    @Override
    public DoubleBuffer getTransposed(int n, DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.putTransposed(this, n, doubleBuffer);
        return doubleBuffer;
    }

    @Override
    public ByteBuffer getTransposed(ByteBuffer byteBuffer) {
        return this.getTransposed(byteBuffer.position(), byteBuffer);
    }

    @Override
    public ByteBuffer getTransposed(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.putTransposed(this, n, byteBuffer);
        return byteBuffer;
    }

    @Override
    public FloatBuffer getTransposed(FloatBuffer floatBuffer) {
        return this.getTransposed(floatBuffer.position(), floatBuffer);
    }

    @Override
    public FloatBuffer getTransposed(int n, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.putfTransposed(this, n, floatBuffer);
        return floatBuffer;
    }

    @Override
    public ByteBuffer getTransposedFloats(ByteBuffer byteBuffer) {
        return this.getTransposed(byteBuffer.position(), byteBuffer);
    }

    @Override
    public ByteBuffer getTransposedFloats(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.putfTransposed(this, n, byteBuffer);
        return byteBuffer;
    }

    @Override
    public double[] getTransposed(double[] dArray, int n) {
        dArray[n + 0] = this.m00;
        dArray[n + 1] = this.m10;
        dArray[n + 2] = this.m20;
        dArray[n + 3] = this.m30;
        dArray[n + 4] = this.m01;
        dArray[n + 5] = this.m11;
        dArray[n + 6] = this.m21;
        dArray[n + 7] = this.m31;
        dArray[n + 8] = this.m02;
        dArray[n + 9] = this.m12;
        dArray[n + 10] = this.m22;
        dArray[n + 11] = this.m32;
        return dArray;
    }

    @Override
    public double[] getTransposed(double[] dArray) {
        return this.getTransposed(dArray, 0);
    }

    public Matrix4x3d zero() {
        this.m00 = 0.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = 0.0;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 0.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.properties = 0;
        return this;
    }

    public Matrix4x3d scaling(double d) {
        return this.scaling(d, d, d);
    }

    public Matrix4x3d scaling(double d, double d2, double d3) {
        if ((this.properties & 4) == 0) {
            this.identity();
        }
        this.m00 = d;
        this.m11 = d2;
        this.m22 = d3;
        boolean bl = Math.absEqualsOne(d) && Math.absEqualsOne(d2) && Math.absEqualsOne(d3);
        this.properties = bl ? 16 : 0;
        return this;
    }

    public Matrix4x3d scaling(Vector3dc vector3dc) {
        return this.scaling(vector3dc.x(), vector3dc.y(), vector3dc.z());
    }

    public Matrix4x3d rotation(double d, double d2, double d3, double d4) {
        if (d3 == 0.0 && d4 == 0.0 && Math.absEqualsOne(d2)) {
            return this.rotationX(d2 * d);
        }
        if (d2 == 0.0 && d4 == 0.0 && Math.absEqualsOne(d3)) {
            return this.rotationY(d3 * d);
        }
        if (d2 == 0.0 && d3 == 0.0 && Math.absEqualsOne(d4)) {
            return this.rotationZ(d4 * d);
        }
        return this.rotationInternal(d, d2, d3, d4);
    }

    private Matrix4x3d rotationInternal(double d, double d2, double d3, double d4) {
        double d5 = Math.sin(d);
        double d6 = Math.cosFromSin(d5, d);
        double d7 = 1.0 - d6;
        double d8 = d2 * d3;
        double d9 = d2 * d4;
        double d10 = d3 * d4;
        this.m00 = d6 + d2 * d2 * d7;
        this.m01 = d8 * d7 + d4 * d5;
        this.m02 = d9 * d7 - d3 * d5;
        this.m10 = d8 * d7 - d4 * d5;
        this.m11 = d6 + d3 * d3 * d7;
        this.m12 = d10 * d7 + d2 * d5;
        this.m20 = d9 * d7 + d3 * d5;
        this.m21 = d10 * d7 - d2 * d5;
        this.m22 = d6 + d4 * d4 * d7;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.properties = 16;
        return this;
    }

    public Matrix4x3d rotationX(double d) {
        double d2 = Math.sin(d);
        double d3 = Math.cosFromSin(d2, d);
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = d3;
        this.m12 = d2;
        this.m20 = 0.0;
        this.m21 = -d2;
        this.m22 = d3;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.properties = 16;
        return this;
    }

    public Matrix4x3d rotationY(double d) {
        double d2;
        double d3 = Math.sin(d);
        this.m00 = d2 = Math.cosFromSin(d3, d);
        this.m01 = 0.0;
        this.m02 = -d3;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m20 = d3;
        this.m21 = 0.0;
        this.m22 = d2;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.properties = 16;
        return this;
    }

    public Matrix4x3d rotationZ(double d) {
        double d2;
        double d3 = Math.sin(d);
        this.m00 = d2 = Math.cosFromSin(d3, d);
        this.m01 = d3;
        this.m02 = 0.0;
        this.m10 = -d3;
        this.m11 = d2;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.properties = 16;
        return this;
    }

    public Matrix4x3d rotationXYZ(double d, double d2, double d3) {
        double d4 = Math.sin(d);
        double d5 = Math.cosFromSin(d4, d);
        double d6 = Math.sin(d2);
        double d7 = Math.cosFromSin(d6, d2);
        double d8 = Math.sin(d3);
        double d9 = Math.cosFromSin(d8, d3);
        double d10 = -d4;
        double d11 = -d6;
        double d12 = -d8;
        double d13 = d5;
        double d14 = d4;
        double d15 = d10;
        double d16 = d5;
        double d17 = d7;
        double d18 = d15 * d11;
        double d19 = d16 * d11;
        this.m20 = d6;
        this.m21 = d15 * d7;
        this.m22 = d16 * d7;
        this.m00 = d17 * d9;
        this.m01 = d18 * d9 + d13 * d8;
        this.m02 = d19 * d9 + d14 * d8;
        this.m10 = d17 * d12;
        this.m11 = d18 * d12 + d13 * d9;
        this.m12 = d19 * d12 + d14 * d9;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.properties = 16;
        return this;
    }

    public Matrix4x3d rotationZYX(double d, double d2, double d3) {
        double d4 = Math.sin(d3);
        double d5 = Math.cosFromSin(d4, d3);
        double d6 = Math.sin(d2);
        double d7 = Math.cosFromSin(d6, d2);
        double d8 = Math.sin(d);
        double d9 = Math.cosFromSin(d8, d);
        double d10 = -d8;
        double d11 = -d6;
        double d12 = -d4;
        double d13 = d9;
        double d14 = d8;
        double d15 = d10;
        double d16 = d9;
        double d17 = d13 * d6;
        double d18 = d14 * d6;
        double d19 = d7;
        this.m00 = d13 * d7;
        this.m01 = d14 * d7;
        this.m02 = d11;
        this.m10 = d15 * d5 + d17 * d4;
        this.m11 = d16 * d5 + d18 * d4;
        this.m12 = d19 * d4;
        this.m20 = d15 * d12 + d17 * d5;
        this.m21 = d16 * d12 + d18 * d5;
        this.m22 = d19 * d5;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.properties = 16;
        return this;
    }

    public Matrix4x3d rotationYXZ(double d, double d2, double d3) {
        double d4 = Math.sin(d2);
        double d5 = Math.cosFromSin(d4, d2);
        double d6 = Math.sin(d);
        double d7 = Math.cosFromSin(d6, d);
        double d8 = Math.sin(d3);
        double d9 = Math.cosFromSin(d8, d3);
        double d10 = -d6;
        double d11 = -d4;
        double d12 = -d8;
        double d13 = d7;
        double d14 = d10;
        double d15 = d6;
        double d16 = d7;
        double d17 = d15 * d4;
        double d18 = d5;
        double d19 = d16 * d4;
        this.m20 = d15 * d5;
        this.m21 = d11;
        this.m22 = d16 * d5;
        this.m00 = d13 * d9 + d17 * d8;
        this.m01 = d18 * d8;
        this.m02 = d14 * d9 + d19 * d8;
        this.m10 = d13 * d12 + d17 * d9;
        this.m11 = d18 * d9;
        this.m12 = d14 * d12 + d19 * d9;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.properties = 16;
        return this;
    }

    public Matrix4x3d setRotationXYZ(double d, double d2, double d3) {
        double d4 = Math.sin(d);
        double d5 = Math.cosFromSin(d4, d);
        double d6 = Math.sin(d2);
        double d7 = Math.cosFromSin(d6, d2);
        double d8 = Math.sin(d3);
        double d9 = Math.cosFromSin(d8, d3);
        double d10 = -d4;
        double d11 = -d6;
        double d12 = -d8;
        double d13 = d5;
        double d14 = d4;
        double d15 = d10;
        double d16 = d5;
        double d17 = d7;
        double d18 = d15 * d11;
        double d19 = d16 * d11;
        this.m20 = d6;
        this.m21 = d15 * d7;
        this.m22 = d16 * d7;
        this.m00 = d17 * d9;
        this.m01 = d18 * d9 + d13 * d8;
        this.m02 = d19 * d9 + d14 * d8;
        this.m10 = d17 * d12;
        this.m11 = d18 * d12 + d13 * d9;
        this.m12 = d19 * d12 + d14 * d9;
        this.properties &= 0xFFFFFFF3;
        return this;
    }

    public Matrix4x3d setRotationZYX(double d, double d2, double d3) {
        double d4 = Math.sin(d3);
        double d5 = Math.cosFromSin(d4, d3);
        double d6 = Math.sin(d2);
        double d7 = Math.cosFromSin(d6, d2);
        double d8 = Math.sin(d);
        double d9 = Math.cosFromSin(d8, d);
        double d10 = -d8;
        double d11 = -d6;
        double d12 = -d4;
        double d13 = d9;
        double d14 = d8;
        double d15 = d10;
        double d16 = d9;
        double d17 = d13 * d6;
        double d18 = d14 * d6;
        double d19 = d7;
        this.m00 = d13 * d7;
        this.m01 = d14 * d7;
        this.m02 = d11;
        this.m10 = d15 * d5 + d17 * d4;
        this.m11 = d16 * d5 + d18 * d4;
        this.m12 = d19 * d4;
        this.m20 = d15 * d12 + d17 * d5;
        this.m21 = d16 * d12 + d18 * d5;
        this.m22 = d19 * d5;
        this.properties &= 0xFFFFFFF3;
        return this;
    }

    public Matrix4x3d setRotationYXZ(double d, double d2, double d3) {
        double d4 = Math.sin(d2);
        double d5 = Math.cosFromSin(d4, d2);
        double d6 = Math.sin(d);
        double d7 = Math.cosFromSin(d6, d);
        double d8 = Math.sin(d3);
        double d9 = Math.cosFromSin(d8, d3);
        double d10 = -d6;
        double d11 = -d4;
        double d12 = -d8;
        double d13 = d7;
        double d14 = d10;
        double d15 = d6;
        double d16 = d7;
        double d17 = d15 * d4;
        double d18 = d5;
        double d19 = d16 * d4;
        this.m20 = d15 * d5;
        this.m21 = d11;
        this.m22 = d16 * d5;
        this.m00 = d13 * d9 + d17 * d8;
        this.m01 = d18 * d8;
        this.m02 = d14 * d9 + d19 * d8;
        this.m10 = d13 * d12 + d17 * d9;
        this.m11 = d18 * d9;
        this.m12 = d14 * d12 + d19 * d9;
        this.properties &= 0xFFFFFFF3;
        return this;
    }

    public Matrix4x3d rotation(double d, Vector3dc vector3dc) {
        return this.rotation(d, vector3dc.x(), vector3dc.y(), vector3dc.z());
    }

    public Matrix4x3d rotation(double d, Vector3fc vector3fc) {
        return this.rotation(d, vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    @Override
    public Vector4d transform(Vector4d vector4d) {
        return vector4d.mul(this);
    }

    @Override
    public Vector4d transform(Vector4dc vector4dc, Vector4d vector4d) {
        return vector4dc.mul(this, vector4d);
    }

    @Override
    public Vector3d transformPosition(Vector3d vector3d) {
        vector3d.set(this.m00 * vector3d.x + this.m10 * vector3d.y + this.m20 * vector3d.z + this.m30, this.m01 * vector3d.x + this.m11 * vector3d.y + this.m21 * vector3d.z + this.m31, this.m02 * vector3d.x + this.m12 * vector3d.y + this.m22 * vector3d.z + this.m32);
        return vector3d;
    }

    @Override
    public Vector3d transformPosition(Vector3dc vector3dc, Vector3d vector3d) {
        vector3d.set(this.m00 * vector3dc.x() + this.m10 * vector3dc.y() + this.m20 * vector3dc.z() + this.m30, this.m01 * vector3dc.x() + this.m11 * vector3dc.y() + this.m21 * vector3dc.z() + this.m31, this.m02 * vector3dc.x() + this.m12 * vector3dc.y() + this.m22 * vector3dc.z() + this.m32);
        return vector3d;
    }

    @Override
    public Vector3d transformDirection(Vector3d vector3d) {
        vector3d.set(this.m00 * vector3d.x + this.m10 * vector3d.y + this.m20 * vector3d.z, this.m01 * vector3d.x + this.m11 * vector3d.y + this.m21 * vector3d.z, this.m02 * vector3d.x + this.m12 * vector3d.y + this.m22 * vector3d.z);
        return vector3d;
    }

    @Override
    public Vector3d transformDirection(Vector3dc vector3dc, Vector3d vector3d) {
        vector3d.set(this.m00 * vector3dc.x() + this.m10 * vector3dc.y() + this.m20 * vector3dc.z(), this.m01 * vector3dc.x() + this.m11 * vector3dc.y() + this.m21 * vector3dc.z(), this.m02 * vector3dc.x() + this.m12 * vector3dc.y() + this.m22 * vector3dc.z());
        return vector3d;
    }

    public Matrix4x3d set3x3(Matrix3dc matrix3dc) {
        this.m00 = matrix3dc.m00();
        this.m01 = matrix3dc.m01();
        this.m02 = matrix3dc.m02();
        this.m10 = matrix3dc.m10();
        this.m11 = matrix3dc.m11();
        this.m12 = matrix3dc.m12();
        this.m20 = matrix3dc.m20();
        this.m21 = matrix3dc.m21();
        this.m22 = matrix3dc.m22();
        this.properties = 0;
        return this;
    }

    public Matrix4x3d set3x3(Matrix3fc matrix3fc) {
        this.m00 = matrix3fc.m00();
        this.m01 = matrix3fc.m01();
        this.m02 = matrix3fc.m02();
        this.m10 = matrix3fc.m10();
        this.m11 = matrix3fc.m11();
        this.m12 = matrix3fc.m12();
        this.m20 = matrix3fc.m20();
        this.m21 = matrix3fc.m21();
        this.m22 = matrix3fc.m22();
        this.properties = 0;
        return this;
    }

    @Override
    public Matrix4x3d scale(Vector3dc vector3dc, Matrix4x3d matrix4x3d) {
        return this.scale(vector3dc.x(), vector3dc.y(), vector3dc.z(), matrix4x3d);
    }

    public Matrix4x3d scale(Vector3dc vector3dc) {
        return this.scale(vector3dc.x(), vector3dc.y(), vector3dc.z(), this);
    }

    @Override
    public Matrix4x3d scale(double d, double d2, double d3, Matrix4x3d matrix4x3d) {
        if ((this.properties & 4) != 0) {
            return matrix4x3d.scaling(d, d2, d3);
        }
        return this.scaleGeneric(d, d2, d3, matrix4x3d);
    }

    private Matrix4x3d scaleGeneric(double d, double d2, double d3, Matrix4x3d matrix4x3d) {
        matrix4x3d.m00 = this.m00 * d;
        matrix4x3d.m01 = this.m01 * d;
        matrix4x3d.m02 = this.m02 * d;
        matrix4x3d.m10 = this.m10 * d2;
        matrix4x3d.m11 = this.m11 * d2;
        matrix4x3d.m12 = this.m12 * d2;
        matrix4x3d.m20 = this.m20 * d3;
        matrix4x3d.m21 = this.m21 * d3;
        matrix4x3d.m22 = this.m22 * d3;
        matrix4x3d.m30 = this.m30;
        matrix4x3d.m31 = this.m31;
        matrix4x3d.m32 = this.m32;
        matrix4x3d.properties = this.properties & 0xFFFFFFE3;
        return matrix4x3d;
    }

    public Matrix4x3d scale(double d, double d2, double d3) {
        return this.scale(d, d2, d3, this);
    }

    @Override
    public Matrix4x3d scale(double d, Matrix4x3d matrix4x3d) {
        return this.scale(d, d, d, matrix4x3d);
    }

    public Matrix4x3d scale(double d) {
        return this.scale(d, d, d);
    }

    @Override
    public Matrix4x3d scaleXY(double d, double d2, Matrix4x3d matrix4x3d) {
        return this.scale(d, d2, 1.0, matrix4x3d);
    }

    public Matrix4x3d scaleXY(double d, double d2) {
        return this.scale(d, d2, 1.0);
    }

    @Override
    public Matrix4x3d scaleLocal(double d, double d2, double d3, Matrix4x3d matrix4x3d) {
        if ((this.properties & 4) != 0) {
            return matrix4x3d.scaling(d, d2, d3);
        }
        double d4 = d * this.m00;
        double d5 = d2 * this.m01;
        double d6 = d3 * this.m02;
        double d7 = d * this.m10;
        double d8 = d2 * this.m11;
        double d9 = d3 * this.m12;
        double d10 = d * this.m20;
        double d11 = d2 * this.m21;
        double d12 = d3 * this.m22;
        double d13 = d * this.m30;
        double d14 = d2 * this.m31;
        double d15 = d3 * this.m32;
        matrix4x3d.m00 = d4;
        matrix4x3d.m01 = d5;
        matrix4x3d.m02 = d6;
        matrix4x3d.m10 = d7;
        matrix4x3d.m11 = d8;
        matrix4x3d.m12 = d9;
        matrix4x3d.m20 = d10;
        matrix4x3d.m21 = d11;
        matrix4x3d.m22 = d12;
        matrix4x3d.m30 = d13;
        matrix4x3d.m31 = d14;
        matrix4x3d.m32 = d15;
        matrix4x3d.properties = this.properties & 0xFFFFFFE3;
        return matrix4x3d;
    }

    public Matrix4x3d scaleLocal(double d, double d2, double d3) {
        return this.scaleLocal(d, d2, d3, this);
    }

    @Override
    public Matrix4x3d rotate(double d, double d2, double d3, double d4, Matrix4x3d matrix4x3d) {
        if ((this.properties & 4) != 0) {
            return matrix4x3d.rotation(d, d2, d3, d4);
        }
        if ((this.properties & 8) != 0) {
            return this.rotateTranslation(d, d2, d3, d4, matrix4x3d);
        }
        return this.rotateGeneric(d, d2, d3, d4, matrix4x3d);
    }

    private Matrix4x3d rotateGeneric(double d, double d2, double d3, double d4, Matrix4x3d matrix4x3d) {
        if (d3 == 0.0 && d4 == 0.0 && Math.absEqualsOne(d2)) {
            return this.rotateX(d2 * d, matrix4x3d);
        }
        if (d2 == 0.0 && d4 == 0.0 && Math.absEqualsOne(d3)) {
            return this.rotateY(d3 * d, matrix4x3d);
        }
        if (d2 == 0.0 && d3 == 0.0 && Math.absEqualsOne(d4)) {
            return this.rotateZ(d4 * d, matrix4x3d);
        }
        return this.rotateGenericInternal(d, d2, d3, d4, matrix4x3d);
    }

    private Matrix4x3d rotateGenericInternal(double d, double d2, double d3, double d4, Matrix4x3d matrix4x3d) {
        double d5 = Math.sin(d);
        double d6 = Math.cosFromSin(d5, d);
        double d7 = 1.0 - d6;
        double d8 = d2 * d2;
        double d9 = d2 * d3;
        double d10 = d2 * d4;
        double d11 = d3 * d3;
        double d12 = d3 * d4;
        double d13 = d4 * d4;
        double d14 = d8 * d7 + d6;
        double d15 = d9 * d7 + d4 * d5;
        double d16 = d10 * d7 - d3 * d5;
        double d17 = d9 * d7 - d4 * d5;
        double d18 = d11 * d7 + d6;
        double d19 = d12 * d7 + d2 * d5;
        double d20 = d10 * d7 + d3 * d5;
        double d21 = d12 * d7 - d2 * d5;
        double d22 = d13 * d7 + d6;
        double d23 = this.m00 * d14 + this.m10 * d15 + this.m20 * d16;
        double d24 = this.m01 * d14 + this.m11 * d15 + this.m21 * d16;
        double d25 = this.m02 * d14 + this.m12 * d15 + this.m22 * d16;
        double d26 = this.m00 * d17 + this.m10 * d18 + this.m20 * d19;
        double d27 = this.m01 * d17 + this.m11 * d18 + this.m21 * d19;
        double d28 = this.m02 * d17 + this.m12 * d18 + this.m22 * d19;
        matrix4x3d.m20 = this.m00 * d20 + this.m10 * d21 + this.m20 * d22;
        matrix4x3d.m21 = this.m01 * d20 + this.m11 * d21 + this.m21 * d22;
        matrix4x3d.m22 = this.m02 * d20 + this.m12 * d21 + this.m22 * d22;
        matrix4x3d.m00 = d23;
        matrix4x3d.m01 = d24;
        matrix4x3d.m02 = d25;
        matrix4x3d.m10 = d26;
        matrix4x3d.m11 = d27;
        matrix4x3d.m12 = d28;
        matrix4x3d.m30 = this.m30;
        matrix4x3d.m31 = this.m31;
        matrix4x3d.m32 = this.m32;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    public Matrix4x3d rotate(double d, double d2, double d3, double d4) {
        return this.rotate(d, d2, d3, d4, this);
    }

    @Override
    public Matrix4x3d rotateTranslation(double d, double d2, double d3, double d4, Matrix4x3d matrix4x3d) {
        double d5 = this.m30;
        double d6 = this.m31;
        double d7 = this.m32;
        if (d3 == 0.0 && d4 == 0.0 && Math.absEqualsOne(d2)) {
            return matrix4x3d.rotationX(d2 * d).setTranslation(d5, d6, d7);
        }
        if (d2 == 0.0 && d4 == 0.0 && Math.absEqualsOne(d3)) {
            return matrix4x3d.rotationY(d3 * d).setTranslation(d5, d6, d7);
        }
        if (d2 == 0.0 && d3 == 0.0 && Math.absEqualsOne(d4)) {
            return matrix4x3d.rotationZ(d4 * d).setTranslation(d5, d6, d7);
        }
        return this.rotateTranslationInternal(d, d2, d3, d4, matrix4x3d);
    }

    private Matrix4x3d rotateTranslationInternal(double d, double d2, double d3, double d4, Matrix4x3d matrix4x3d) {
        double d5 = Math.sin(d);
        double d6 = Math.cosFromSin(d5, d);
        double d7 = 1.0 - d6;
        double d8 = d2 * d2;
        double d9 = d2 * d3;
        double d10 = d2 * d4;
        double d11 = d3 * d3;
        double d12 = d3 * d4;
        double d13 = d4 * d4;
        double d14 = d8 * d7 + d6;
        double d15 = d9 * d7 + d4 * d5;
        double d16 = d10 * d7 - d3 * d5;
        double d17 = d9 * d7 - d4 * d5;
        double d18 = d11 * d7 + d6;
        double d19 = d12 * d7 + d2 * d5;
        double d20 = d10 * d7 + d3 * d5;
        double d21 = d12 * d7 - d2 * d5;
        double d22 = d13 * d7 + d6;
        double d23 = d14;
        double d24 = d15;
        double d25 = d16;
        double d26 = d17;
        double d27 = d18;
        double d28 = d19;
        matrix4x3d.m20 = d20;
        matrix4x3d.m21 = d21;
        matrix4x3d.m22 = d22;
        matrix4x3d.m00 = d23;
        matrix4x3d.m01 = d24;
        matrix4x3d.m02 = d25;
        matrix4x3d.m10 = d26;
        matrix4x3d.m11 = d27;
        matrix4x3d.m12 = d28;
        matrix4x3d.m30 = this.m30;
        matrix4x3d.m31 = this.m31;
        matrix4x3d.m32 = this.m32;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    public Matrix4x3d rotateAround(Quaterniondc quaterniondc, double d, double d2, double d3) {
        return this.rotateAround(quaterniondc, d, d2, d3, this);
    }

    private Matrix4x3d rotateAroundAffine(Quaterniondc quaterniondc, double d, double d2, double d3, Matrix4x3d matrix4x3d) {
        double d4 = quaterniondc.w() * quaterniondc.w();
        double d5 = quaterniondc.x() * quaterniondc.x();
        double d6 = quaterniondc.y() * quaterniondc.y();
        double d7 = quaterniondc.z() * quaterniondc.z();
        double d8 = quaterniondc.z() * quaterniondc.w();
        double d9 = d8 + d8;
        double d10 = quaterniondc.x() * quaterniondc.y();
        double d11 = d10 + d10;
        double d12 = quaterniondc.x() * quaterniondc.z();
        double d13 = d12 + d12;
        double d14 = quaterniondc.y() * quaterniondc.w();
        double d15 = d14 + d14;
        double d16 = quaterniondc.y() * quaterniondc.z();
        double d17 = d16 + d16;
        double d18 = quaterniondc.x() * quaterniondc.w();
        double d19 = d18 + d18;
        double d20 = d4 + d5 - d7 - d6;
        double d21 = d11 + d9;
        double d22 = d13 - d15;
        double d23 = d11 - d9;
        double d24 = d6 - d7 + d4 - d5;
        double d25 = d17 + d19;
        double d26 = d15 + d13;
        double d27 = d17 - d19;
        double d28 = d7 - d6 - d5 + d4;
        double d29 = this.m00 * d + this.m10 * d2 + this.m20 * d3 + this.m30;
        double d30 = this.m01 * d + this.m11 * d2 + this.m21 * d3 + this.m31;
        double d31 = this.m02 * d + this.m12 * d2 + this.m22 * d3 + this.m32;
        double d32 = this.m00 * d20 + this.m10 * d21 + this.m20 * d22;
        double d33 = this.m01 * d20 + this.m11 * d21 + this.m21 * d22;
        double d34 = this.m02 * d20 + this.m12 * d21 + this.m22 * d22;
        double d35 = this.m00 * d23 + this.m10 * d24 + this.m20 * d25;
        double d36 = this.m01 * d23 + this.m11 * d24 + this.m21 * d25;
        double d37 = this.m02 * d23 + this.m12 * d24 + this.m22 * d25;
        matrix4x3d._m20(this.m00 * d26 + this.m10 * d27 + this.m20 * d28)._m21(this.m01 * d26 + this.m11 * d27 + this.m21 * d28)._m22(this.m02 * d26 + this.m12 * d27 + this.m22 * d28)._m00(d32)._m01(d33)._m02(d34)._m10(d35)._m11(d36)._m12(d37)._m30(-d32 * d - d35 * d2 - this.m20 * d3 + d29)._m31(-d33 * d - d36 * d2 - this.m21 * d3 + d30)._m32(-d34 * d - d37 * d2 - this.m22 * d3 + d31)._properties(this.properties & 0xFFFFFFF3);
        return matrix4x3d;
    }

    @Override
    public Matrix4x3d rotateAround(Quaterniondc quaterniondc, double d, double d2, double d3, Matrix4x3d matrix4x3d) {
        if ((this.properties & 4) != 0) {
            return this.rotationAround(quaterniondc, d, d2, d3);
        }
        return this.rotateAroundAffine(quaterniondc, d, d2, d3, matrix4x3d);
    }

    public Matrix4x3d rotationAround(Quaterniondc quaterniondc, double d, double d2, double d3) {
        double d4 = quaterniondc.w() * quaterniondc.w();
        double d5 = quaterniondc.x() * quaterniondc.x();
        double d6 = quaterniondc.y() * quaterniondc.y();
        double d7 = quaterniondc.z() * quaterniondc.z();
        double d8 = quaterniondc.z() * quaterniondc.w();
        double d9 = d8 + d8;
        double d10 = quaterniondc.x() * quaterniondc.y();
        double d11 = d10 + d10;
        double d12 = quaterniondc.x() * quaterniondc.z();
        double d13 = d12 + d12;
        double d14 = quaterniondc.y() * quaterniondc.w();
        double d15 = d14 + d14;
        double d16 = quaterniondc.y() * quaterniondc.z();
        double d17 = d16 + d16;
        double d18 = quaterniondc.x() * quaterniondc.w();
        double d19 = d18 + d18;
        this._m20(d15 + d13);
        this._m21(d17 - d19);
        this._m22(d7 - d6 - d5 + d4);
        this._m00(d4 + d5 - d7 - d6);
        this._m01(d11 + d9);
        this._m02(d13 - d15);
        this._m10(d11 - d9);
        this._m11(d6 - d7 + d4 - d5);
        this._m12(d17 + d19);
        this._m30(-this.m00 * d - this.m10 * d2 - this.m20 * d3 + d);
        this._m31(-this.m01 * d - this.m11 * d2 - this.m21 * d3 + d2);
        this._m32(-this.m02 * d - this.m12 * d2 - this.m22 * d3 + d3);
        this.properties = 16;
        return this;
    }

    @Override
    public Matrix4x3d rotateLocal(double d, double d2, double d3, double d4, Matrix4x3d matrix4x3d) {
        if (d3 == 0.0 && d4 == 0.0 && Math.absEqualsOne(d2)) {
            return this.rotateLocalX(d2 * d, matrix4x3d);
        }
        if (d2 == 0.0 && d4 == 0.0 && Math.absEqualsOne(d3)) {
            return this.rotateLocalY(d3 * d, matrix4x3d);
        }
        if (d2 == 0.0 && d3 == 0.0 && Math.absEqualsOne(d4)) {
            return this.rotateLocalZ(d4 * d, matrix4x3d);
        }
        return this.rotateLocalInternal(d, d2, d3, d4, matrix4x3d);
    }

    private Matrix4x3d rotateLocalInternal(double d, double d2, double d3, double d4, Matrix4x3d matrix4x3d) {
        double d5 = Math.sin(d);
        double d6 = Math.cosFromSin(d5, d);
        double d7 = 1.0 - d6;
        double d8 = d2 * d2;
        double d9 = d2 * d3;
        double d10 = d2 * d4;
        double d11 = d3 * d3;
        double d12 = d3 * d4;
        double d13 = d4 * d4;
        double d14 = d8 * d7 + d6;
        double d15 = d9 * d7 + d4 * d5;
        double d16 = d10 * d7 - d3 * d5;
        double d17 = d9 * d7 - d4 * d5;
        double d18 = d11 * d7 + d6;
        double d19 = d12 * d7 + d2 * d5;
        double d20 = d10 * d7 + d3 * d5;
        double d21 = d12 * d7 - d2 * d5;
        double d22 = d13 * d7 + d6;
        double d23 = d14 * this.m00 + d17 * this.m01 + d20 * this.m02;
        double d24 = d15 * this.m00 + d18 * this.m01 + d21 * this.m02;
        double d25 = d16 * this.m00 + d19 * this.m01 + d22 * this.m02;
        double d26 = d14 * this.m10 + d17 * this.m11 + d20 * this.m12;
        double d27 = d15 * this.m10 + d18 * this.m11 + d21 * this.m12;
        double d28 = d16 * this.m10 + d19 * this.m11 + d22 * this.m12;
        double d29 = d14 * this.m20 + d17 * this.m21 + d20 * this.m22;
        double d30 = d15 * this.m20 + d18 * this.m21 + d21 * this.m22;
        double d31 = d16 * this.m20 + d19 * this.m21 + d22 * this.m22;
        double d32 = d14 * this.m30 + d17 * this.m31 + d20 * this.m32;
        double d33 = d15 * this.m30 + d18 * this.m31 + d21 * this.m32;
        double d34 = d16 * this.m30 + d19 * this.m31 + d22 * this.m32;
        matrix4x3d.m00 = d23;
        matrix4x3d.m01 = d24;
        matrix4x3d.m02 = d25;
        matrix4x3d.m10 = d26;
        matrix4x3d.m11 = d27;
        matrix4x3d.m12 = d28;
        matrix4x3d.m20 = d29;
        matrix4x3d.m21 = d30;
        matrix4x3d.m22 = d31;
        matrix4x3d.m30 = d32;
        matrix4x3d.m31 = d33;
        matrix4x3d.m32 = d34;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    public Matrix4x3d rotateLocal(double d, double d2, double d3, double d4) {
        return this.rotateLocal(d, d2, d3, d4, this);
    }

    public Matrix4x3d rotateLocalX(double d, Matrix4x3d matrix4x3d) {
        double d2 = Math.sin(d);
        double d3 = Math.cosFromSin(d2, d);
        double d4 = d3 * this.m01 - d2 * this.m02;
        double d5 = d2 * this.m01 + d3 * this.m02;
        double d6 = d3 * this.m11 - d2 * this.m12;
        double d7 = d2 * this.m11 + d3 * this.m12;
        double d8 = d3 * this.m21 - d2 * this.m22;
        double d9 = d2 * this.m21 + d3 * this.m22;
        double d10 = d3 * this.m31 - d2 * this.m32;
        double d11 = d2 * this.m31 + d3 * this.m32;
        matrix4x3d.m00 = this.m00;
        matrix4x3d.m01 = d4;
        matrix4x3d.m02 = d5;
        matrix4x3d.m10 = this.m10;
        matrix4x3d.m11 = d6;
        matrix4x3d.m12 = d7;
        matrix4x3d.m20 = this.m20;
        matrix4x3d.m21 = d8;
        matrix4x3d.m22 = d9;
        matrix4x3d.m30 = this.m30;
        matrix4x3d.m31 = d10;
        matrix4x3d.m32 = d11;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    public Matrix4x3d rotateLocalX(double d) {
        return this.rotateLocalX(d, this);
    }

    public Matrix4x3d rotateLocalY(double d, Matrix4x3d matrix4x3d) {
        double d2 = Math.sin(d);
        double d3 = Math.cosFromSin(d2, d);
        double d4 = d3 * this.m00 + d2 * this.m02;
        double d5 = -d2 * this.m00 + d3 * this.m02;
        double d6 = d3 * this.m10 + d2 * this.m12;
        double d7 = -d2 * this.m10 + d3 * this.m12;
        double d8 = d3 * this.m20 + d2 * this.m22;
        double d9 = -d2 * this.m20 + d3 * this.m22;
        double d10 = d3 * this.m30 + d2 * this.m32;
        double d11 = -d2 * this.m30 + d3 * this.m32;
        matrix4x3d.m00 = d4;
        matrix4x3d.m01 = this.m01;
        matrix4x3d.m02 = d5;
        matrix4x3d.m10 = d6;
        matrix4x3d.m11 = this.m11;
        matrix4x3d.m12 = d7;
        matrix4x3d.m20 = d8;
        matrix4x3d.m21 = this.m21;
        matrix4x3d.m22 = d9;
        matrix4x3d.m30 = d10;
        matrix4x3d.m31 = this.m31;
        matrix4x3d.m32 = d11;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    public Matrix4x3d rotateLocalY(double d) {
        return this.rotateLocalY(d, this);
    }

    public Matrix4x3d rotateLocalZ(double d, Matrix4x3d matrix4x3d) {
        double d2 = Math.sin(d);
        double d3 = Math.cosFromSin(d2, d);
        double d4 = d3 * this.m00 - d2 * this.m01;
        double d5 = d2 * this.m00 + d3 * this.m01;
        double d6 = d3 * this.m10 - d2 * this.m11;
        double d7 = d2 * this.m10 + d3 * this.m11;
        double d8 = d3 * this.m20 - d2 * this.m21;
        double d9 = d2 * this.m20 + d3 * this.m21;
        double d10 = d3 * this.m30 - d2 * this.m31;
        double d11 = d2 * this.m30 + d3 * this.m31;
        matrix4x3d.m00 = d4;
        matrix4x3d.m01 = d5;
        matrix4x3d.m02 = this.m02;
        matrix4x3d.m10 = d6;
        matrix4x3d.m11 = d7;
        matrix4x3d.m12 = this.m12;
        matrix4x3d.m20 = d8;
        matrix4x3d.m21 = d9;
        matrix4x3d.m22 = this.m22;
        matrix4x3d.m30 = d10;
        matrix4x3d.m31 = d11;
        matrix4x3d.m32 = this.m32;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    public Matrix4x3d rotateLocalZ(double d) {
        return this.rotateLocalZ(d, this);
    }

    public Matrix4x3d translate(Vector3dc vector3dc) {
        return this.translate(vector3dc.x(), vector3dc.y(), vector3dc.z());
    }

    @Override
    public Matrix4x3d translate(Vector3dc vector3dc, Matrix4x3d matrix4x3d) {
        return this.translate(vector3dc.x(), vector3dc.y(), vector3dc.z(), matrix4x3d);
    }

    public Matrix4x3d translate(Vector3fc vector3fc) {
        return this.translate(vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    @Override
    public Matrix4x3d translate(Vector3fc vector3fc, Matrix4x3d matrix4x3d) {
        return this.translate(vector3fc.x(), vector3fc.y(), vector3fc.z(), matrix4x3d);
    }

    @Override
    public Matrix4x3d translate(double d, double d2, double d3, Matrix4x3d matrix4x3d) {
        if ((this.properties & 4) != 0) {
            return matrix4x3d.translation(d, d2, d3);
        }
        return this.translateGeneric(d, d2, d3, matrix4x3d);
    }

    private Matrix4x3d translateGeneric(double d, double d2, double d3, Matrix4x3d matrix4x3d) {
        matrix4x3d.m00 = this.m00;
        matrix4x3d.m01 = this.m01;
        matrix4x3d.m02 = this.m02;
        matrix4x3d.m10 = this.m10;
        matrix4x3d.m11 = this.m11;
        matrix4x3d.m12 = this.m12;
        matrix4x3d.m20 = this.m20;
        matrix4x3d.m21 = this.m21;
        matrix4x3d.m22 = this.m22;
        matrix4x3d.m30 = this.m00 * d + this.m10 * d2 + this.m20 * d3 + this.m30;
        matrix4x3d.m31 = this.m01 * d + this.m11 * d2 + this.m21 * d3 + this.m31;
        matrix4x3d.m32 = this.m02 * d + this.m12 * d2 + this.m22 * d3 + this.m32;
        matrix4x3d.properties = this.properties & 0xFFFFFFFB;
        return matrix4x3d;
    }

    public Matrix4x3d translate(double d, double d2, double d3) {
        if ((this.properties & 4) != 0) {
            return this.translation(d, d2, d3);
        }
        Matrix4x3d matrix4x3d = this;
        matrix4x3d.m30 = matrix4x3d.m00 * d + matrix4x3d.m10 * d2 + matrix4x3d.m20 * d3 + matrix4x3d.m30;
        matrix4x3d.m31 = matrix4x3d.m01 * d + matrix4x3d.m11 * d2 + matrix4x3d.m21 * d3 + matrix4x3d.m31;
        matrix4x3d.m32 = matrix4x3d.m02 * d + matrix4x3d.m12 * d2 + matrix4x3d.m22 * d3 + matrix4x3d.m32;
        matrix4x3d.properties &= 0xFFFFFFFB;
        return this;
    }

    public Matrix4x3d translateLocal(Vector3fc vector3fc) {
        return this.translateLocal(vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    @Override
    public Matrix4x3d translateLocal(Vector3fc vector3fc, Matrix4x3d matrix4x3d) {
        return this.translateLocal(vector3fc.x(), vector3fc.y(), vector3fc.z(), matrix4x3d);
    }

    public Matrix4x3d translateLocal(Vector3dc vector3dc) {
        return this.translateLocal(vector3dc.x(), vector3dc.y(), vector3dc.z());
    }

    @Override
    public Matrix4x3d translateLocal(Vector3dc vector3dc, Matrix4x3d matrix4x3d) {
        return this.translateLocal(vector3dc.x(), vector3dc.y(), vector3dc.z(), matrix4x3d);
    }

    @Override
    public Matrix4x3d translateLocal(double d, double d2, double d3, Matrix4x3d matrix4x3d) {
        matrix4x3d.m00 = this.m00;
        matrix4x3d.m01 = this.m01;
        matrix4x3d.m02 = this.m02;
        matrix4x3d.m10 = this.m10;
        matrix4x3d.m11 = this.m11;
        matrix4x3d.m12 = this.m12;
        matrix4x3d.m20 = this.m20;
        matrix4x3d.m21 = this.m21;
        matrix4x3d.m22 = this.m22;
        matrix4x3d.m30 = this.m30 + d;
        matrix4x3d.m31 = this.m31 + d2;
        matrix4x3d.m32 = this.m32 + d3;
        matrix4x3d.properties = this.properties & 0xFFFFFFFB;
        return matrix4x3d;
    }

    public Matrix4x3d translateLocal(double d, double d2, double d3) {
        return this.translateLocal(d, d2, d3, this);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeDouble(this.m00);
        objectOutput.writeDouble(this.m01);
        objectOutput.writeDouble(this.m02);
        objectOutput.writeDouble(this.m10);
        objectOutput.writeDouble(this.m11);
        objectOutput.writeDouble(this.m12);
        objectOutput.writeDouble(this.m20);
        objectOutput.writeDouble(this.m21);
        objectOutput.writeDouble(this.m22);
        objectOutput.writeDouble(this.m30);
        objectOutput.writeDouble(this.m31);
        objectOutput.writeDouble(this.m32);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        this.m00 = objectInput.readDouble();
        this.m01 = objectInput.readDouble();
        this.m02 = objectInput.readDouble();
        this.m10 = objectInput.readDouble();
        this.m11 = objectInput.readDouble();
        this.m12 = objectInput.readDouble();
        this.m20 = objectInput.readDouble();
        this.m21 = objectInput.readDouble();
        this.m22 = objectInput.readDouble();
        this.m30 = objectInput.readDouble();
        this.m31 = objectInput.readDouble();
        this.m32 = objectInput.readDouble();
        this.determineProperties();
    }

    @Override
    public Matrix4x3d rotateX(double d, Matrix4x3d matrix4x3d) {
        if ((this.properties & 4) != 0) {
            return matrix4x3d.rotationX(d);
        }
        if ((this.properties & 8) != 0) {
            double d2 = this.m30;
            double d3 = this.m31;
            double d4 = this.m32;
            return matrix4x3d.rotationX(d).setTranslation(d2, d3, d4);
        }
        return this.rotateXInternal(d, matrix4x3d);
    }

    private Matrix4x3d rotateXInternal(double d, Matrix4x3d matrix4x3d) {
        double d2;
        double d3 = Math.sin(d);
        double d4 = d2 = Math.cosFromSin(d3, d);
        double d5 = d3;
        double d6 = -d3;
        double d7 = d2;
        double d8 = this.m10 * d4 + this.m20 * d5;
        double d9 = this.m11 * d4 + this.m21 * d5;
        double d10 = this.m12 * d4 + this.m22 * d5;
        matrix4x3d.m20 = this.m10 * d6 + this.m20 * d7;
        matrix4x3d.m21 = this.m11 * d6 + this.m21 * d7;
        matrix4x3d.m22 = this.m12 * d6 + this.m22 * d7;
        matrix4x3d.m10 = d8;
        matrix4x3d.m11 = d9;
        matrix4x3d.m12 = d10;
        matrix4x3d.m00 = this.m00;
        matrix4x3d.m01 = this.m01;
        matrix4x3d.m02 = this.m02;
        matrix4x3d.m30 = this.m30;
        matrix4x3d.m31 = this.m31;
        matrix4x3d.m32 = this.m32;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    public Matrix4x3d rotateX(double d) {
        return this.rotateX(d, this);
    }

    @Override
    public Matrix4x3d rotateY(double d, Matrix4x3d matrix4x3d) {
        if ((this.properties & 4) != 0) {
            return matrix4x3d.rotationY(d);
        }
        if ((this.properties & 8) != 0) {
            double d2 = this.m30;
            double d3 = this.m31;
            double d4 = this.m32;
            return matrix4x3d.rotationY(d).setTranslation(d2, d3, d4);
        }
        return this.rotateYInternal(d, matrix4x3d);
    }

    private Matrix4x3d rotateYInternal(double d, Matrix4x3d matrix4x3d) {
        double d2;
        double d3 = Math.sin(d);
        double d4 = d2 = Math.cosFromSin(d3, d);
        double d5 = -d3;
        double d6 = d3;
        double d7 = d2;
        double d8 = this.m00 * d4 + this.m20 * d5;
        double d9 = this.m01 * d4 + this.m21 * d5;
        double d10 = this.m02 * d4 + this.m22 * d5;
        matrix4x3d.m20 = this.m00 * d6 + this.m20 * d7;
        matrix4x3d.m21 = this.m01 * d6 + this.m21 * d7;
        matrix4x3d.m22 = this.m02 * d6 + this.m22 * d7;
        matrix4x3d.m00 = d8;
        matrix4x3d.m01 = d9;
        matrix4x3d.m02 = d10;
        matrix4x3d.m10 = this.m10;
        matrix4x3d.m11 = this.m11;
        matrix4x3d.m12 = this.m12;
        matrix4x3d.m30 = this.m30;
        matrix4x3d.m31 = this.m31;
        matrix4x3d.m32 = this.m32;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    public Matrix4x3d rotateY(double d) {
        return this.rotateY(d, this);
    }

    @Override
    public Matrix4x3d rotateZ(double d, Matrix4x3d matrix4x3d) {
        if ((this.properties & 4) != 0) {
            return matrix4x3d.rotationZ(d);
        }
        if ((this.properties & 8) != 0) {
            double d2 = this.m30;
            double d3 = this.m31;
            double d4 = this.m32;
            return matrix4x3d.rotationZ(d).setTranslation(d2, d3, d4);
        }
        return this.rotateZInternal(d, matrix4x3d);
    }

    private Matrix4x3d rotateZInternal(double d, Matrix4x3d matrix4x3d) {
        double d2;
        double d3 = Math.sin(d);
        double d4 = d2 = Math.cosFromSin(d3, d);
        double d5 = d3;
        double d6 = -d3;
        double d7 = d2;
        double d8 = this.m00 * d4 + this.m10 * d5;
        double d9 = this.m01 * d4 + this.m11 * d5;
        double d10 = this.m02 * d4 + this.m12 * d5;
        matrix4x3d.m10 = this.m00 * d6 + this.m10 * d7;
        matrix4x3d.m11 = this.m01 * d6 + this.m11 * d7;
        matrix4x3d.m12 = this.m02 * d6 + this.m12 * d7;
        matrix4x3d.m00 = d8;
        matrix4x3d.m01 = d9;
        matrix4x3d.m02 = d10;
        matrix4x3d.m20 = this.m20;
        matrix4x3d.m21 = this.m21;
        matrix4x3d.m22 = this.m22;
        matrix4x3d.m30 = this.m30;
        matrix4x3d.m31 = this.m31;
        matrix4x3d.m32 = this.m32;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    public Matrix4x3d rotateZ(double d) {
        return this.rotateZ(d, this);
    }

    public Matrix4x3d rotateXYZ(Vector3d vector3d) {
        return this.rotateXYZ(vector3d.x, vector3d.y, vector3d.z);
    }

    public Matrix4x3d rotateXYZ(double d, double d2, double d3) {
        return this.rotateXYZ(d, d2, d3, this);
    }

    @Override
    public Matrix4x3d rotateXYZ(double d, double d2, double d3, Matrix4x3d matrix4x3d) {
        if ((this.properties & 4) != 0) {
            return matrix4x3d.rotationXYZ(d, d2, d3);
        }
        if ((this.properties & 8) != 0) {
            double d4 = this.m30;
            double d5 = this.m31;
            double d6 = this.m32;
            return matrix4x3d.rotationXYZ(d, d2, d3).setTranslation(d4, d5, d6);
        }
        return this.rotateXYZInternal(d, d2, d3, matrix4x3d);
    }

    private Matrix4x3d rotateXYZInternal(double d, double d2, double d3, Matrix4x3d matrix4x3d) {
        double d4 = Math.sin(d);
        double d5 = Math.cosFromSin(d4, d);
        double d6 = Math.sin(d2);
        double d7 = Math.cosFromSin(d6, d2);
        double d8 = Math.sin(d3);
        double d9 = Math.cosFromSin(d8, d3);
        double d10 = -d4;
        double d11 = -d6;
        double d12 = -d8;
        double d13 = this.m10 * d5 + this.m20 * d4;
        double d14 = this.m11 * d5 + this.m21 * d4;
        double d15 = this.m12 * d5 + this.m22 * d4;
        double d16 = this.m10 * d10 + this.m20 * d5;
        double d17 = this.m11 * d10 + this.m21 * d5;
        double d18 = this.m12 * d10 + this.m22 * d5;
        double d19 = this.m00 * d7 + d16 * d11;
        double d20 = this.m01 * d7 + d17 * d11;
        double d21 = this.m02 * d7 + d18 * d11;
        matrix4x3d.m20 = this.m00 * d6 + d16 * d7;
        matrix4x3d.m21 = this.m01 * d6 + d17 * d7;
        matrix4x3d.m22 = this.m02 * d6 + d18 * d7;
        matrix4x3d.m00 = d19 * d9 + d13 * d8;
        matrix4x3d.m01 = d20 * d9 + d14 * d8;
        matrix4x3d.m02 = d21 * d9 + d15 * d8;
        matrix4x3d.m10 = d19 * d12 + d13 * d9;
        matrix4x3d.m11 = d20 * d12 + d14 * d9;
        matrix4x3d.m12 = d21 * d12 + d15 * d9;
        matrix4x3d.m30 = this.m30;
        matrix4x3d.m31 = this.m31;
        matrix4x3d.m32 = this.m32;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    public Matrix4x3d rotateZYX(Vector3d vector3d) {
        return this.rotateZYX(vector3d.z, vector3d.y, vector3d.x);
    }

    public Matrix4x3d rotateZYX(double d, double d2, double d3) {
        return this.rotateZYX(d, d2, d3, this);
    }

    @Override
    public Matrix4x3d rotateZYX(double d, double d2, double d3, Matrix4x3d matrix4x3d) {
        if ((this.properties & 4) != 0) {
            return matrix4x3d.rotationZYX(d, d2, d3);
        }
        if ((this.properties & 8) != 0) {
            double d4 = this.m30;
            double d5 = this.m31;
            double d6 = this.m32;
            return matrix4x3d.rotationZYX(d, d2, d3).setTranslation(d4, d5, d6);
        }
        return this.rotateZYXInternal(d, d2, d3, matrix4x3d);
    }

    private Matrix4x3d rotateZYXInternal(double d, double d2, double d3, Matrix4x3d matrix4x3d) {
        double d4 = Math.sin(d3);
        double d5 = Math.cosFromSin(d4, d3);
        double d6 = Math.sin(d2);
        double d7 = Math.cosFromSin(d6, d2);
        double d8 = Math.sin(d);
        double d9 = Math.cosFromSin(d8, d);
        double d10 = -d8;
        double d11 = -d6;
        double d12 = -d4;
        double d13 = this.m00 * d9 + this.m10 * d8;
        double d14 = this.m01 * d9 + this.m11 * d8;
        double d15 = this.m02 * d9 + this.m12 * d8;
        double d16 = this.m00 * d10 + this.m10 * d9;
        double d17 = this.m01 * d10 + this.m11 * d9;
        double d18 = this.m02 * d10 + this.m12 * d9;
        double d19 = d13 * d6 + this.m20 * d7;
        double d20 = d14 * d6 + this.m21 * d7;
        double d21 = d15 * d6 + this.m22 * d7;
        matrix4x3d.m00 = d13 * d7 + this.m20 * d11;
        matrix4x3d.m01 = d14 * d7 + this.m21 * d11;
        matrix4x3d.m02 = d15 * d7 + this.m22 * d11;
        matrix4x3d.m10 = d16 * d5 + d19 * d4;
        matrix4x3d.m11 = d17 * d5 + d20 * d4;
        matrix4x3d.m12 = d18 * d5 + d21 * d4;
        matrix4x3d.m20 = d16 * d12 + d19 * d5;
        matrix4x3d.m21 = d17 * d12 + d20 * d5;
        matrix4x3d.m22 = d18 * d12 + d21 * d5;
        matrix4x3d.m30 = this.m30;
        matrix4x3d.m31 = this.m31;
        matrix4x3d.m32 = this.m32;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    public Matrix4x3d rotateYXZ(Vector3d vector3d) {
        return this.rotateYXZ(vector3d.y, vector3d.x, vector3d.z);
    }

    public Matrix4x3d rotateYXZ(double d, double d2, double d3) {
        return this.rotateYXZ(d, d2, d3, this);
    }

    @Override
    public Matrix4x3d rotateYXZ(double d, double d2, double d3, Matrix4x3d matrix4x3d) {
        if ((this.properties & 4) != 0) {
            return matrix4x3d.rotationYXZ(d, d2, d3);
        }
        if ((this.properties & 8) != 0) {
            double d4 = this.m30;
            double d5 = this.m31;
            double d6 = this.m32;
            return matrix4x3d.rotationYXZ(d, d2, d3).setTranslation(d4, d5, d6);
        }
        return this.rotateYXZInternal(d, d2, d3, matrix4x3d);
    }

    private Matrix4x3d rotateYXZInternal(double d, double d2, double d3, Matrix4x3d matrix4x3d) {
        double d4 = Math.sin(d2);
        double d5 = Math.cosFromSin(d4, d2);
        double d6 = Math.sin(d);
        double d7 = Math.cosFromSin(d6, d);
        double d8 = Math.sin(d3);
        double d9 = Math.cosFromSin(d8, d3);
        double d10 = -d6;
        double d11 = -d4;
        double d12 = -d8;
        double d13 = this.m00 * d6 + this.m20 * d7;
        double d14 = this.m01 * d6 + this.m21 * d7;
        double d15 = this.m02 * d6 + this.m22 * d7;
        double d16 = this.m00 * d7 + this.m20 * d10;
        double d17 = this.m01 * d7 + this.m21 * d10;
        double d18 = this.m02 * d7 + this.m22 * d10;
        double d19 = this.m10 * d5 + d13 * d4;
        double d20 = this.m11 * d5 + d14 * d4;
        double d21 = this.m12 * d5 + d15 * d4;
        matrix4x3d.m20 = this.m10 * d11 + d13 * d5;
        matrix4x3d.m21 = this.m11 * d11 + d14 * d5;
        matrix4x3d.m22 = this.m12 * d11 + d15 * d5;
        matrix4x3d.m00 = d16 * d9 + d19 * d8;
        matrix4x3d.m01 = d17 * d9 + d20 * d8;
        matrix4x3d.m02 = d18 * d9 + d21 * d8;
        matrix4x3d.m10 = d16 * d12 + d19 * d9;
        matrix4x3d.m11 = d17 * d12 + d20 * d9;
        matrix4x3d.m12 = d18 * d12 + d21 * d9;
        matrix4x3d.m30 = this.m30;
        matrix4x3d.m31 = this.m31;
        matrix4x3d.m32 = this.m32;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    public Matrix4x3d rotation(AxisAngle4f axisAngle4f) {
        return this.rotation(axisAngle4f.angle, axisAngle4f.x, axisAngle4f.y, axisAngle4f.z);
    }

    public Matrix4x3d rotation(AxisAngle4d axisAngle4d) {
        return this.rotation(axisAngle4d.angle, axisAngle4d.x, axisAngle4d.y, axisAngle4d.z);
    }

    public Matrix4x3d rotation(Quaterniondc quaterniondc) {
        double d = quaterniondc.w() * quaterniondc.w();
        double d2 = quaterniondc.x() * quaterniondc.x();
        double d3 = quaterniondc.y() * quaterniondc.y();
        double d4 = quaterniondc.z() * quaterniondc.z();
        double d5 = quaterniondc.z() * quaterniondc.w();
        double d6 = d5 + d5;
        double d7 = quaterniondc.x() * quaterniondc.y();
        double d8 = d7 + d7;
        double d9 = quaterniondc.x() * quaterniondc.z();
        double d10 = d9 + d9;
        double d11 = quaterniondc.y() * quaterniondc.w();
        double d12 = d11 + d11;
        double d13 = quaterniondc.y() * quaterniondc.z();
        double d14 = d13 + d13;
        double d15 = quaterniondc.x() * quaterniondc.w();
        double d16 = d15 + d15;
        this._m00(d + d2 - d4 - d3);
        this._m01(d8 + d6);
        this._m02(d10 - d12);
        this._m10(d8 - d6);
        this._m11(d3 - d4 + d - d2);
        this._m12(d14 + d16);
        this._m20(d12 + d10);
        this._m21(d14 - d16);
        this._m22(d4 - d3 - d2 + d);
        this._m30(0.0);
        this._m31(0.0);
        this._m32(0.0);
        this.properties = 16;
        return this;
    }

    public Matrix4x3d rotation(Quaternionfc quaternionfc) {
        double d = quaternionfc.w() * quaternionfc.w();
        double d2 = quaternionfc.x() * quaternionfc.x();
        double d3 = quaternionfc.y() * quaternionfc.y();
        double d4 = quaternionfc.z() * quaternionfc.z();
        double d5 = quaternionfc.z() * quaternionfc.w();
        double d6 = d5 + d5;
        double d7 = quaternionfc.x() * quaternionfc.y();
        double d8 = d7 + d7;
        double d9 = quaternionfc.x() * quaternionfc.z();
        double d10 = d9 + d9;
        double d11 = quaternionfc.y() * quaternionfc.w();
        double d12 = d11 + d11;
        double d13 = quaternionfc.y() * quaternionfc.z();
        double d14 = d13 + d13;
        double d15 = quaternionfc.x() * quaternionfc.w();
        double d16 = d15 + d15;
        this._m00(d + d2 - d4 - d3);
        this._m01(d8 + d6);
        this._m02(d10 - d12);
        this._m10(d8 - d6);
        this._m11(d3 - d4 + d - d2);
        this._m12(d14 + d16);
        this._m20(d12 + d10);
        this._m21(d14 - d16);
        this._m22(d4 - d3 - d2 + d);
        this._m30(0.0);
        this._m31(0.0);
        this._m32(0.0);
        this.properties = 16;
        return this;
    }

    public Matrix4x3d translationRotateScale(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        double d11 = d4 + d4;
        double d12 = d5 + d5;
        double d13 = d6 + d6;
        double d14 = d11 * d4;
        double d15 = d12 * d5;
        double d16 = d13 * d6;
        double d17 = d11 * d5;
        double d18 = d11 * d6;
        double d19 = d11 * d7;
        double d20 = d12 * d6;
        double d21 = d12 * d7;
        double d22 = d13 * d7;
        this.m00 = d8 - (d15 + d16) * d8;
        this.m01 = (d17 + d22) * d8;
        this.m02 = (d18 - d21) * d8;
        this.m10 = (d17 - d22) * d9;
        this.m11 = d9 - (d16 + d14) * d9;
        this.m12 = (d20 + d19) * d9;
        this.m20 = (d18 + d21) * d10;
        this.m21 = (d20 - d19) * d10;
        this.m22 = d10 - (d15 + d14) * d10;
        this.m30 = d;
        this.m31 = d2;
        this.m32 = d3;
        this.properties = 0;
        return this;
    }

    public Matrix4x3d translationRotateScale(Vector3fc vector3fc, Quaternionfc quaternionfc, Vector3fc vector3fc2) {
        return this.translationRotateScale(vector3fc.x(), vector3fc.y(), vector3fc.z(), quaternionfc.x(), quaternionfc.y(), quaternionfc.z(), quaternionfc.w(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z());
    }

    public Matrix4x3d translationRotateScale(Vector3dc vector3dc, Quaterniondc quaterniondc, Vector3dc vector3dc2) {
        return this.translationRotateScale(vector3dc.x(), vector3dc.y(), vector3dc.z(), quaterniondc.x(), quaterniondc.y(), quaterniondc.z(), quaterniondc.w(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z());
    }

    public Matrix4x3d translationRotateScaleMul(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, Matrix4x3dc matrix4x3dc) {
        double d11 = d4 + d4;
        double d12 = d5 + d5;
        double d13 = d6 + d6;
        double d14 = d11 * d4;
        double d15 = d12 * d5;
        double d16 = d13 * d6;
        double d17 = d11 * d5;
        double d18 = d11 * d6;
        double d19 = d11 * d7;
        double d20 = d12 * d6;
        double d21 = d12 * d7;
        double d22 = d13 * d7;
        double d23 = d8 - (d15 + d16) * d8;
        double d24 = (d17 + d22) * d8;
        double d25 = (d18 - d21) * d8;
        double d26 = (d17 - d22) * d9;
        double d27 = d9 - (d16 + d14) * d9;
        double d28 = (d20 + d19) * d9;
        double d29 = (d18 + d21) * d10;
        double d30 = (d20 - d19) * d10;
        double d31 = d10 - (d15 + d14) * d10;
        double d32 = d23 * matrix4x3dc.m00() + d26 * matrix4x3dc.m01() + d29 * matrix4x3dc.m02();
        double d33 = d24 * matrix4x3dc.m00() + d27 * matrix4x3dc.m01() + d30 * matrix4x3dc.m02();
        this.m02 = d25 * matrix4x3dc.m00() + d28 * matrix4x3dc.m01() + d31 * matrix4x3dc.m02();
        this.m00 = d32;
        this.m01 = d33;
        double d34 = d23 * matrix4x3dc.m10() + d26 * matrix4x3dc.m11() + d29 * matrix4x3dc.m12();
        double d35 = d24 * matrix4x3dc.m10() + d27 * matrix4x3dc.m11() + d30 * matrix4x3dc.m12();
        this.m12 = d25 * matrix4x3dc.m10() + d28 * matrix4x3dc.m11() + d31 * matrix4x3dc.m12();
        this.m10 = d34;
        this.m11 = d35;
        double d36 = d23 * matrix4x3dc.m20() + d26 * matrix4x3dc.m21() + d29 * matrix4x3dc.m22();
        double d37 = d24 * matrix4x3dc.m20() + d27 * matrix4x3dc.m21() + d30 * matrix4x3dc.m22();
        this.m22 = d25 * matrix4x3dc.m20() + d28 * matrix4x3dc.m21() + d31 * matrix4x3dc.m22();
        this.m20 = d36;
        this.m21 = d37;
        double d38 = d23 * matrix4x3dc.m30() + d26 * matrix4x3dc.m31() + d29 * matrix4x3dc.m32() + d;
        double d39 = d24 * matrix4x3dc.m30() + d27 * matrix4x3dc.m31() + d30 * matrix4x3dc.m32() + d2;
        this.m32 = d25 * matrix4x3dc.m30() + d28 * matrix4x3dc.m31() + d31 * matrix4x3dc.m32() + d3;
        this.m30 = d38;
        this.m31 = d39;
        this.properties = 0;
        return this;
    }

    public Matrix4x3d translationRotateScaleMul(Vector3dc vector3dc, Quaterniondc quaterniondc, Vector3dc vector3dc2, Matrix4x3dc matrix4x3dc) {
        return this.translationRotateScaleMul(vector3dc.x(), vector3dc.y(), vector3dc.z(), quaterniondc.x(), quaterniondc.y(), quaterniondc.z(), quaterniondc.w(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), matrix4x3dc);
    }

    public Matrix4x3d translationRotate(double d, double d2, double d3, Quaterniondc quaterniondc) {
        double d4 = quaterniondc.x() + quaterniondc.x();
        double d5 = quaterniondc.y() + quaterniondc.y();
        double d6 = quaterniondc.z() + quaterniondc.z();
        double d7 = d4 * quaterniondc.x();
        double d8 = d5 * quaterniondc.y();
        double d9 = d6 * quaterniondc.z();
        double d10 = d4 * quaterniondc.y();
        double d11 = d4 * quaterniondc.z();
        double d12 = d4 * quaterniondc.w();
        double d13 = d5 * quaterniondc.z();
        double d14 = d5 * quaterniondc.w();
        double d15 = d6 * quaterniondc.w();
        this.m00 = 1.0 - (d8 + d9);
        this.m01 = d10 + d15;
        this.m02 = d11 - d14;
        this.m10 = d10 - d15;
        this.m11 = 1.0 - (d9 + d7);
        this.m12 = d13 + d12;
        this.m20 = d11 + d14;
        this.m21 = d13 - d12;
        this.m22 = 1.0 - (d8 + d7);
        this.m30 = d;
        this.m31 = d2;
        this.m32 = d3;
        this.properties = 16;
        return this;
    }

    public Matrix4x3d translationRotateMul(double d, double d2, double d3, Quaternionfc quaternionfc, Matrix4x3dc matrix4x3dc) {
        return this.translationRotateMul(d, d2, d3, quaternionfc.x(), quaternionfc.y(), quaternionfc.z(), quaternionfc.w(), matrix4x3dc);
    }

    public Matrix4x3d translationRotateMul(double d, double d2, double d3, double d4, double d5, double d6, double d7, Matrix4x3dc matrix4x3dc) {
        double d8 = d7 * d7;
        double d9 = d4 * d4;
        double d10 = d5 * d5;
        double d11 = d6 * d6;
        double d12 = d6 * d7;
        double d13 = d4 * d5;
        double d14 = d4 * d6;
        double d15 = d5 * d7;
        double d16 = d5 * d6;
        double d17 = d4 * d7;
        double d18 = d8 + d9 - d11 - d10;
        double d19 = d13 + d12 + d12 + d13;
        double d20 = d14 - d15 + d14 - d15;
        double d21 = -d12 + d13 - d12 + d13;
        double d22 = d10 - d11 + d8 - d9;
        double d23 = d16 + d16 + d17 + d17;
        double d24 = d15 + d14 + d14 + d15;
        double d25 = d16 + d16 - d17 - d17;
        double d26 = d11 - d10 - d9 + d8;
        this.m00 = d18 * matrix4x3dc.m00() + d21 * matrix4x3dc.m01() + d24 * matrix4x3dc.m02();
        this.m01 = d19 * matrix4x3dc.m00() + d22 * matrix4x3dc.m01() + d25 * matrix4x3dc.m02();
        this.m02 = d20 * matrix4x3dc.m00() + d23 * matrix4x3dc.m01() + d26 * matrix4x3dc.m02();
        this.m10 = d18 * matrix4x3dc.m10() + d21 * matrix4x3dc.m11() + d24 * matrix4x3dc.m12();
        this.m11 = d19 * matrix4x3dc.m10() + d22 * matrix4x3dc.m11() + d25 * matrix4x3dc.m12();
        this.m12 = d20 * matrix4x3dc.m10() + d23 * matrix4x3dc.m11() + d26 * matrix4x3dc.m12();
        this.m20 = d18 * matrix4x3dc.m20() + d21 * matrix4x3dc.m21() + d24 * matrix4x3dc.m22();
        this.m21 = d19 * matrix4x3dc.m20() + d22 * matrix4x3dc.m21() + d25 * matrix4x3dc.m22();
        this.m22 = d20 * matrix4x3dc.m20() + d23 * matrix4x3dc.m21() + d26 * matrix4x3dc.m22();
        this.m30 = d18 * matrix4x3dc.m30() + d21 * matrix4x3dc.m31() + d24 * matrix4x3dc.m32() + d;
        this.m31 = d19 * matrix4x3dc.m30() + d22 * matrix4x3dc.m31() + d25 * matrix4x3dc.m32() + d2;
        this.m32 = d20 * matrix4x3dc.m30() + d23 * matrix4x3dc.m31() + d26 * matrix4x3dc.m32() + d3;
        this.properties = 0;
        return this;
    }

    @Override
    public Matrix4x3d rotate(Quaterniondc quaterniondc, Matrix4x3d matrix4x3d) {
        if ((this.properties & 4) != 0) {
            return matrix4x3d.rotation(quaterniondc);
        }
        if ((this.properties & 8) != 0) {
            return this.rotateTranslation(quaterniondc, matrix4x3d);
        }
        return this.rotateGeneric(quaterniondc, matrix4x3d);
    }

    private Matrix4x3d rotateGeneric(Quaterniondc quaterniondc, Matrix4x3d matrix4x3d) {
        double d = quaterniondc.w() * quaterniondc.w();
        double d2 = quaterniondc.x() * quaterniondc.x();
        double d3 = quaterniondc.y() * quaterniondc.y();
        double d4 = quaterniondc.z() * quaterniondc.z();
        double d5 = quaterniondc.z() * quaterniondc.w();
        double d6 = d5 + d5;
        double d7 = quaterniondc.x() * quaterniondc.y();
        double d8 = d7 + d7;
        double d9 = quaterniondc.x() * quaterniondc.z();
        double d10 = d9 + d9;
        double d11 = quaterniondc.y() * quaterniondc.w();
        double d12 = d11 + d11;
        double d13 = quaterniondc.y() * quaterniondc.z();
        double d14 = d13 + d13;
        double d15 = quaterniondc.x() * quaterniondc.w();
        double d16 = d15 + d15;
        double d17 = d + d2 - d4 - d3;
        double d18 = d8 + d6;
        double d19 = d10 - d12;
        double d20 = d8 - d6;
        double d21 = d3 - d4 + d - d2;
        double d22 = d14 + d16;
        double d23 = d12 + d10;
        double d24 = d14 - d16;
        double d25 = d4 - d3 - d2 + d;
        double d26 = this.m00 * d17 + this.m10 * d18 + this.m20 * d19;
        double d27 = this.m01 * d17 + this.m11 * d18 + this.m21 * d19;
        double d28 = this.m02 * d17 + this.m12 * d18 + this.m22 * d19;
        double d29 = this.m00 * d20 + this.m10 * d21 + this.m20 * d22;
        double d30 = this.m01 * d20 + this.m11 * d21 + this.m21 * d22;
        double d31 = this.m02 * d20 + this.m12 * d21 + this.m22 * d22;
        matrix4x3d.m20 = this.m00 * d23 + this.m10 * d24 + this.m20 * d25;
        matrix4x3d.m21 = this.m01 * d23 + this.m11 * d24 + this.m21 * d25;
        matrix4x3d.m22 = this.m02 * d23 + this.m12 * d24 + this.m22 * d25;
        matrix4x3d.m00 = d26;
        matrix4x3d.m01 = d27;
        matrix4x3d.m02 = d28;
        matrix4x3d.m10 = d29;
        matrix4x3d.m11 = d30;
        matrix4x3d.m12 = d31;
        matrix4x3d.m30 = this.m30;
        matrix4x3d.m31 = this.m31;
        matrix4x3d.m32 = this.m32;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    @Override
    public Matrix4x3d rotate(Quaternionfc quaternionfc, Matrix4x3d matrix4x3d) {
        if ((this.properties & 4) != 0) {
            return matrix4x3d.rotation(quaternionfc);
        }
        if ((this.properties & 8) != 0) {
            return this.rotateTranslation(quaternionfc, matrix4x3d);
        }
        return this.rotateGeneric(quaternionfc, matrix4x3d);
    }

    private Matrix4x3d rotateGeneric(Quaternionfc quaternionfc, Matrix4x3d matrix4x3d) {
        double d = quaternionfc.w() * quaternionfc.w();
        double d2 = quaternionfc.x() * quaternionfc.x();
        double d3 = quaternionfc.y() * quaternionfc.y();
        double d4 = quaternionfc.z() * quaternionfc.z();
        double d5 = quaternionfc.z() * quaternionfc.w();
        double d6 = quaternionfc.x() * quaternionfc.y();
        double d7 = quaternionfc.x() * quaternionfc.z();
        double d8 = quaternionfc.y() * quaternionfc.w();
        double d9 = quaternionfc.y() * quaternionfc.z();
        double d10 = quaternionfc.x() * quaternionfc.w();
        double d11 = d + d2 - d4 - d3;
        double d12 = d6 + d5 + d5 + d6;
        double d13 = d7 - d8 + d7 - d8;
        double d14 = -d5 + d6 - d5 + d6;
        double d15 = d3 - d4 + d - d2;
        double d16 = d9 + d9 + d10 + d10;
        double d17 = d8 + d7 + d7 + d8;
        double d18 = d9 + d9 - d10 - d10;
        double d19 = d4 - d3 - d2 + d;
        double d20 = this.m00 * d11 + this.m10 * d12 + this.m20 * d13;
        double d21 = this.m01 * d11 + this.m11 * d12 + this.m21 * d13;
        double d22 = this.m02 * d11 + this.m12 * d12 + this.m22 * d13;
        double d23 = this.m00 * d14 + this.m10 * d15 + this.m20 * d16;
        double d24 = this.m01 * d14 + this.m11 * d15 + this.m21 * d16;
        double d25 = this.m02 * d14 + this.m12 * d15 + this.m22 * d16;
        matrix4x3d.m20 = this.m00 * d17 + this.m10 * d18 + this.m20 * d19;
        matrix4x3d.m21 = this.m01 * d17 + this.m11 * d18 + this.m21 * d19;
        matrix4x3d.m22 = this.m02 * d17 + this.m12 * d18 + this.m22 * d19;
        matrix4x3d.m00 = d20;
        matrix4x3d.m01 = d21;
        matrix4x3d.m02 = d22;
        matrix4x3d.m10 = d23;
        matrix4x3d.m11 = d24;
        matrix4x3d.m12 = d25;
        matrix4x3d.m30 = this.m30;
        matrix4x3d.m31 = this.m31;
        matrix4x3d.m32 = this.m32;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    public Matrix4x3d rotate(Quaterniondc quaterniondc) {
        return this.rotate(quaterniondc, this);
    }

    public Matrix4x3d rotate(Quaternionfc quaternionfc) {
        return this.rotate(quaternionfc, this);
    }

    @Override
    public Matrix4x3d rotateTranslation(Quaterniondc quaterniondc, Matrix4x3d matrix4x3d) {
        double d = quaterniondc.w() * quaterniondc.w();
        double d2 = quaterniondc.x() * quaterniondc.x();
        double d3 = quaterniondc.y() * quaterniondc.y();
        double d4 = quaterniondc.z() * quaterniondc.z();
        double d5 = quaterniondc.z() * quaterniondc.w();
        double d6 = d5 + d5;
        double d7 = quaterniondc.x() * quaterniondc.y();
        double d8 = d7 + d7;
        double d9 = quaterniondc.x() * quaterniondc.z();
        double d10 = d9 + d9;
        double d11 = quaterniondc.y() * quaterniondc.w();
        double d12 = d11 + d11;
        double d13 = quaterniondc.y() * quaterniondc.z();
        double d14 = d13 + d13;
        double d15 = quaterniondc.x() * quaterniondc.w();
        double d16 = d15 + d15;
        double d17 = d + d2 - d4 - d3;
        double d18 = d8 + d6;
        double d19 = d10 - d12;
        double d20 = d8 - d6;
        double d21 = d3 - d4 + d - d2;
        double d22 = d14 + d16;
        double d23 = d12 + d10;
        double d24 = d14 - d16;
        double d25 = d4 - d3 - d2 + d;
        matrix4x3d.m20 = d23;
        matrix4x3d.m21 = d24;
        matrix4x3d.m22 = d25;
        matrix4x3d.m00 = d17;
        matrix4x3d.m01 = d18;
        matrix4x3d.m02 = d19;
        matrix4x3d.m10 = d20;
        matrix4x3d.m11 = d21;
        matrix4x3d.m12 = d22;
        matrix4x3d.m30 = this.m30;
        matrix4x3d.m31 = this.m31;
        matrix4x3d.m32 = this.m32;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    @Override
    public Matrix4x3d rotateTranslation(Quaternionfc quaternionfc, Matrix4x3d matrix4x3d) {
        double d = quaternionfc.w() * quaternionfc.w();
        double d2 = quaternionfc.x() * quaternionfc.x();
        double d3 = quaternionfc.y() * quaternionfc.y();
        double d4 = quaternionfc.z() * quaternionfc.z();
        double d5 = quaternionfc.z() * quaternionfc.w();
        double d6 = quaternionfc.x() * quaternionfc.y();
        double d7 = quaternionfc.x() * quaternionfc.z();
        double d8 = quaternionfc.y() * quaternionfc.w();
        double d9 = quaternionfc.y() * quaternionfc.z();
        double d10 = quaternionfc.x() * quaternionfc.w();
        double d11 = d + d2 - d4 - d3;
        double d12 = d6 + d5 + d5 + d6;
        double d13 = d7 - d8 + d7 - d8;
        double d14 = -d5 + d6 - d5 + d6;
        double d15 = d3 - d4 + d - d2;
        double d16 = d9 + d9 + d10 + d10;
        double d17 = d8 + d7 + d7 + d8;
        double d18 = d9 + d9 - d10 - d10;
        double d19 = d4 - d3 - d2 + d;
        double d20 = d11;
        double d21 = d12;
        double d22 = d13;
        double d23 = d14;
        double d24 = d15;
        double d25 = d16;
        matrix4x3d.m20 = d17;
        matrix4x3d.m21 = d18;
        matrix4x3d.m22 = d19;
        matrix4x3d.m00 = d20;
        matrix4x3d.m01 = d21;
        matrix4x3d.m02 = d22;
        matrix4x3d.m10 = d23;
        matrix4x3d.m11 = d24;
        matrix4x3d.m12 = d25;
        matrix4x3d.m30 = this.m30;
        matrix4x3d.m31 = this.m31;
        matrix4x3d.m32 = this.m32;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    @Override
    public Matrix4x3d rotateLocal(Quaterniondc quaterniondc, Matrix4x3d matrix4x3d) {
        double d = quaterniondc.w() * quaterniondc.w();
        double d2 = quaterniondc.x() * quaterniondc.x();
        double d3 = quaterniondc.y() * quaterniondc.y();
        double d4 = quaterniondc.z() * quaterniondc.z();
        double d5 = quaterniondc.z() * quaterniondc.w();
        double d6 = d5 + d5;
        double d7 = quaterniondc.x() * quaterniondc.y();
        double d8 = d7 + d7;
        double d9 = quaterniondc.x() * quaterniondc.z();
        double d10 = d9 + d9;
        double d11 = quaterniondc.y() * quaterniondc.w();
        double d12 = d11 + d11;
        double d13 = quaterniondc.y() * quaterniondc.z();
        double d14 = d13 + d13;
        double d15 = quaterniondc.x() * quaterniondc.w();
        double d16 = d15 + d15;
        double d17 = d + d2 - d4 - d3;
        double d18 = d8 + d6;
        double d19 = d10 - d12;
        double d20 = d8 - d6;
        double d21 = d3 - d4 + d - d2;
        double d22 = d14 + d16;
        double d23 = d12 + d10;
        double d24 = d14 - d16;
        double d25 = d4 - d3 - d2 + d;
        double d26 = d17 * this.m00 + d20 * this.m01 + d23 * this.m02;
        double d27 = d18 * this.m00 + d21 * this.m01 + d24 * this.m02;
        double d28 = d19 * this.m00 + d22 * this.m01 + d25 * this.m02;
        double d29 = d17 * this.m10 + d20 * this.m11 + d23 * this.m12;
        double d30 = d18 * this.m10 + d21 * this.m11 + d24 * this.m12;
        double d31 = d19 * this.m10 + d22 * this.m11 + d25 * this.m12;
        double d32 = d17 * this.m20 + d20 * this.m21 + d23 * this.m22;
        double d33 = d18 * this.m20 + d21 * this.m21 + d24 * this.m22;
        double d34 = d19 * this.m20 + d22 * this.m21 + d25 * this.m22;
        double d35 = d17 * this.m30 + d20 * this.m31 + d23 * this.m32;
        double d36 = d18 * this.m30 + d21 * this.m31 + d24 * this.m32;
        double d37 = d19 * this.m30 + d22 * this.m31 + d25 * this.m32;
        matrix4x3d.m00 = d26;
        matrix4x3d.m01 = d27;
        matrix4x3d.m02 = d28;
        matrix4x3d.m10 = d29;
        matrix4x3d.m11 = d30;
        matrix4x3d.m12 = d31;
        matrix4x3d.m20 = d32;
        matrix4x3d.m21 = d33;
        matrix4x3d.m22 = d34;
        matrix4x3d.m30 = d35;
        matrix4x3d.m31 = d36;
        matrix4x3d.m32 = d37;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    public Matrix4x3d rotateLocal(Quaterniondc quaterniondc) {
        return this.rotateLocal(quaterniondc, this);
    }

    @Override
    public Matrix4x3d rotateLocal(Quaternionfc quaternionfc, Matrix4x3d matrix4x3d) {
        double d = quaternionfc.w() * quaternionfc.w();
        double d2 = quaternionfc.x() * quaternionfc.x();
        double d3 = quaternionfc.y() * quaternionfc.y();
        double d4 = quaternionfc.z() * quaternionfc.z();
        double d5 = quaternionfc.z() * quaternionfc.w();
        double d6 = d5 + d5;
        double d7 = quaternionfc.x() * quaternionfc.y();
        double d8 = d7 + d7;
        double d9 = quaternionfc.x() * quaternionfc.z();
        double d10 = d9 + d9;
        double d11 = quaternionfc.y() * quaternionfc.w();
        double d12 = d11 + d11;
        double d13 = quaternionfc.y() * quaternionfc.z();
        double d14 = d13 + d13;
        double d15 = quaternionfc.x() * quaternionfc.w();
        double d16 = d15 + d15;
        double d17 = d + d2 - d4 - d3;
        double d18 = d8 + d6;
        double d19 = d10 - d12;
        double d20 = d8 - d6;
        double d21 = d3 - d4 + d - d2;
        double d22 = d14 + d16;
        double d23 = d12 + d10;
        double d24 = d14 - d16;
        double d25 = d4 - d3 - d2 + d;
        double d26 = d17 * this.m00 + d20 * this.m01 + d23 * this.m02;
        double d27 = d18 * this.m00 + d21 * this.m01 + d24 * this.m02;
        double d28 = d19 * this.m00 + d22 * this.m01 + d25 * this.m02;
        double d29 = d17 * this.m10 + d20 * this.m11 + d23 * this.m12;
        double d30 = d18 * this.m10 + d21 * this.m11 + d24 * this.m12;
        double d31 = d19 * this.m10 + d22 * this.m11 + d25 * this.m12;
        double d32 = d17 * this.m20 + d20 * this.m21 + d23 * this.m22;
        double d33 = d18 * this.m20 + d21 * this.m21 + d24 * this.m22;
        double d34 = d19 * this.m20 + d22 * this.m21 + d25 * this.m22;
        double d35 = d17 * this.m30 + d20 * this.m31 + d23 * this.m32;
        double d36 = d18 * this.m30 + d21 * this.m31 + d24 * this.m32;
        double d37 = d19 * this.m30 + d22 * this.m31 + d25 * this.m32;
        matrix4x3d.m00 = d26;
        matrix4x3d.m01 = d27;
        matrix4x3d.m02 = d28;
        matrix4x3d.m10 = d29;
        matrix4x3d.m11 = d30;
        matrix4x3d.m12 = d31;
        matrix4x3d.m20 = d32;
        matrix4x3d.m21 = d33;
        matrix4x3d.m22 = d34;
        matrix4x3d.m30 = d35;
        matrix4x3d.m31 = d36;
        matrix4x3d.m32 = d37;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    public Matrix4x3d rotateLocal(Quaternionfc quaternionfc) {
        return this.rotateLocal(quaternionfc, this);
    }

    public Matrix4x3d rotate(AxisAngle4f axisAngle4f) {
        return this.rotate(axisAngle4f.angle, axisAngle4f.x, axisAngle4f.y, axisAngle4f.z);
    }

    @Override
    public Matrix4x3d rotate(AxisAngle4f axisAngle4f, Matrix4x3d matrix4x3d) {
        return this.rotate(axisAngle4f.angle, axisAngle4f.x, axisAngle4f.y, axisAngle4f.z, matrix4x3d);
    }

    public Matrix4x3d rotate(AxisAngle4d axisAngle4d) {
        return this.rotate(axisAngle4d.angle, axisAngle4d.x, axisAngle4d.y, axisAngle4d.z);
    }

    @Override
    public Matrix4x3d rotate(AxisAngle4d axisAngle4d, Matrix4x3d matrix4x3d) {
        return this.rotate(axisAngle4d.angle, axisAngle4d.x, axisAngle4d.y, axisAngle4d.z, matrix4x3d);
    }

    public Matrix4x3d rotate(double d, Vector3dc vector3dc) {
        return this.rotate(d, vector3dc.x(), vector3dc.y(), vector3dc.z());
    }

    @Override
    public Matrix4x3d rotate(double d, Vector3dc vector3dc, Matrix4x3d matrix4x3d) {
        return this.rotate(d, vector3dc.x(), vector3dc.y(), vector3dc.z(), matrix4x3d);
    }

    public Matrix4x3d rotate(double d, Vector3fc vector3fc) {
        return this.rotate(d, vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    @Override
    public Matrix4x3d rotate(double d, Vector3fc vector3fc, Matrix4x3d matrix4x3d) {
        return this.rotate(d, vector3fc.x(), vector3fc.y(), vector3fc.z(), matrix4x3d);
    }

    @Override
    public Vector4d getRow(int n, Vector4d vector4d) throws IndexOutOfBoundsException {
        switch (n) {
            case 0: {
                vector4d.x = this.m00;
                vector4d.y = this.m10;
                vector4d.z = this.m20;
                vector4d.w = this.m30;
                break;
            }
            case 1: {
                vector4d.x = this.m01;
                vector4d.y = this.m11;
                vector4d.z = this.m21;
                vector4d.w = this.m31;
                break;
            }
            case 2: {
                vector4d.x = this.m02;
                vector4d.y = this.m12;
                vector4d.z = this.m22;
                vector4d.w = this.m32;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        return vector4d;
    }

    public Matrix4x3d setRow(int n, Vector4dc vector4dc) throws IndexOutOfBoundsException {
        switch (n) {
            case 0: {
                this.m00 = vector4dc.x();
                this.m10 = vector4dc.y();
                this.m20 = vector4dc.z();
                this.m30 = vector4dc.w();
                break;
            }
            case 1: {
                this.m01 = vector4dc.x();
                this.m11 = vector4dc.y();
                this.m21 = vector4dc.z();
                this.m31 = vector4dc.w();
                break;
            }
            case 2: {
                this.m02 = vector4dc.x();
                this.m12 = vector4dc.y();
                this.m22 = vector4dc.z();
                this.m32 = vector4dc.w();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        this.properties = 0;
        return this;
    }

    @Override
    public Vector3d getColumn(int n, Vector3d vector3d) throws IndexOutOfBoundsException {
        switch (n) {
            case 0: {
                vector3d.x = this.m00;
                vector3d.y = this.m01;
                vector3d.z = this.m02;
                break;
            }
            case 1: {
                vector3d.x = this.m10;
                vector3d.y = this.m11;
                vector3d.z = this.m12;
                break;
            }
            case 2: {
                vector3d.x = this.m20;
                vector3d.y = this.m21;
                vector3d.z = this.m22;
                break;
            }
            case 3: {
                vector3d.x = this.m30;
                vector3d.y = this.m31;
                vector3d.z = this.m32;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        return vector3d;
    }

    public Matrix4x3d setColumn(int n, Vector3dc vector3dc) throws IndexOutOfBoundsException {
        switch (n) {
            case 0: {
                this.m00 = vector3dc.x();
                this.m01 = vector3dc.y();
                this.m02 = vector3dc.z();
                break;
            }
            case 1: {
                this.m10 = vector3dc.x();
                this.m11 = vector3dc.y();
                this.m12 = vector3dc.z();
                break;
            }
            case 2: {
                this.m20 = vector3dc.x();
                this.m21 = vector3dc.y();
                this.m22 = vector3dc.z();
                break;
            }
            case 3: {
                this.m30 = vector3dc.x();
                this.m31 = vector3dc.y();
                this.m32 = vector3dc.z();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        this.properties = 0;
        return this;
    }

    public Matrix4x3d normal() {
        return this.normal(this);
    }

    @Override
    public Matrix4x3d normal(Matrix4x3d matrix4x3d) {
        if ((this.properties & 4) != 0) {
            return matrix4x3d.identity();
        }
        if ((this.properties & 0x10) != 0) {
            return this.normalOrthonormal(matrix4x3d);
        }
        return this.normalGeneric(matrix4x3d);
    }

    private Matrix4x3d normalOrthonormal(Matrix4x3d matrix4x3d) {
        if (matrix4x3d != this) {
            matrix4x3d.set(this);
        }
        return matrix4x3d._properties(16);
    }

    private Matrix4x3d normalGeneric(Matrix4x3d matrix4x3d) {
        double d = this.m00 * this.m11;
        double d2 = this.m01 * this.m10;
        double d3 = this.m02 * this.m10;
        double d4 = this.m00 * this.m12;
        double d5 = this.m01 * this.m12;
        double d6 = this.m02 * this.m11;
        double d7 = (d - d2) * this.m22 + (d3 - d4) * this.m21 + (d5 - d6) * this.m20;
        double d8 = 1.0 / d7;
        double d9 = (this.m11 * this.m22 - this.m21 * this.m12) * d8;
        double d10 = (this.m20 * this.m12 - this.m10 * this.m22) * d8;
        double d11 = (this.m10 * this.m21 - this.m20 * this.m11) * d8;
        double d12 = (this.m21 * this.m02 - this.m01 * this.m22) * d8;
        double d13 = (this.m00 * this.m22 - this.m20 * this.m02) * d8;
        double d14 = (this.m20 * this.m01 - this.m00 * this.m21) * d8;
        double d15 = (d5 - d6) * d8;
        double d16 = (d3 - d4) * d8;
        double d17 = (d - d2) * d8;
        matrix4x3d.m00 = d9;
        matrix4x3d.m01 = d10;
        matrix4x3d.m02 = d11;
        matrix4x3d.m10 = d12;
        matrix4x3d.m11 = d13;
        matrix4x3d.m12 = d14;
        matrix4x3d.m20 = d15;
        matrix4x3d.m21 = d16;
        matrix4x3d.m22 = d17;
        matrix4x3d.m30 = 0.0;
        matrix4x3d.m31 = 0.0;
        matrix4x3d.m32 = 0.0;
        matrix4x3d.properties = this.properties & 0xFFFFFFF7;
        return matrix4x3d;
    }

    @Override
    public Matrix3d normal(Matrix3d matrix3d) {
        if ((this.properties & 0x10) != 0) {
            return this.normalOrthonormal(matrix3d);
        }
        return this.normalGeneric(matrix3d);
    }

    private Matrix3d normalOrthonormal(Matrix3d matrix3d) {
        return matrix3d.set(this);
    }

    private Matrix3d normalGeneric(Matrix3d matrix3d) {
        double d = this.m00 * this.m11;
        double d2 = this.m01 * this.m10;
        double d3 = this.m02 * this.m10;
        double d4 = this.m00 * this.m12;
        double d5 = this.m01 * this.m12;
        double d6 = this.m02 * this.m11;
        double d7 = (d - d2) * this.m22 + (d3 - d4) * this.m21 + (d5 - d6) * this.m20;
        double d8 = 1.0 / d7;
        matrix3d.m00((this.m11 * this.m22 - this.m21 * this.m12) * d8);
        matrix3d.m01((this.m20 * this.m12 - this.m10 * this.m22) * d8);
        matrix3d.m02((this.m10 * this.m21 - this.m20 * this.m11) * d8);
        matrix3d.m10((this.m21 * this.m02 - this.m01 * this.m22) * d8);
        matrix3d.m11((this.m00 * this.m22 - this.m20 * this.m02) * d8);
        matrix3d.m12((this.m20 * this.m01 - this.m00 * this.m21) * d8);
        matrix3d.m20((d5 - d6) * d8);
        matrix3d.m21((d3 - d4) * d8);
        matrix3d.m22((d - d2) * d8);
        return matrix3d;
    }

    public Matrix4x3d cofactor3x3() {
        return this.cofactor3x3(this);
    }

    @Override
    public Matrix3d cofactor3x3(Matrix3d matrix3d) {
        matrix3d.m00 = this.m11 * this.m22 - this.m21 * this.m12;
        matrix3d.m01 = this.m20 * this.m12 - this.m10 * this.m22;
        matrix3d.m02 = this.m10 * this.m21 - this.m20 * this.m11;
        matrix3d.m10 = this.m21 * this.m02 - this.m01 * this.m22;
        matrix3d.m11 = this.m00 * this.m22 - this.m20 * this.m02;
        matrix3d.m12 = this.m20 * this.m01 - this.m00 * this.m21;
        matrix3d.m20 = this.m01 * this.m12 - this.m02 * this.m11;
        matrix3d.m21 = this.m02 * this.m10 - this.m00 * this.m12;
        matrix3d.m22 = this.m00 * this.m11 - this.m01 * this.m10;
        return matrix3d;
    }

    @Override
    public Matrix4x3d cofactor3x3(Matrix4x3d matrix4x3d) {
        double d = this.m11 * this.m22 - this.m21 * this.m12;
        double d2 = this.m20 * this.m12 - this.m10 * this.m22;
        double d3 = this.m10 * this.m21 - this.m20 * this.m11;
        double d4 = this.m21 * this.m02 - this.m01 * this.m22;
        double d5 = this.m00 * this.m22 - this.m20 * this.m02;
        double d6 = this.m20 * this.m01 - this.m00 * this.m21;
        double d7 = this.m01 * this.m12 - this.m11 * this.m02;
        double d8 = this.m02 * this.m10 - this.m12 * this.m00;
        double d9 = this.m00 * this.m11 - this.m10 * this.m01;
        matrix4x3d.m00 = d;
        matrix4x3d.m01 = d2;
        matrix4x3d.m02 = d3;
        matrix4x3d.m10 = d4;
        matrix4x3d.m11 = d5;
        matrix4x3d.m12 = d6;
        matrix4x3d.m20 = d7;
        matrix4x3d.m21 = d8;
        matrix4x3d.m22 = d9;
        matrix4x3d.m30 = 0.0;
        matrix4x3d.m31 = 0.0;
        matrix4x3d.m32 = 0.0;
        matrix4x3d.properties = this.properties & 0xFFFFFFF7;
        return matrix4x3d;
    }

    public Matrix4x3d normalize3x3() {
        return this.normalize3x3(this);
    }

    @Override
    public Matrix4x3d normalize3x3(Matrix4x3d matrix4x3d) {
        double d = Math.invsqrt(this.m00 * this.m00 + this.m01 * this.m01 + this.m02 * this.m02);
        double d2 = Math.invsqrt(this.m10 * this.m10 + this.m11 * this.m11 + this.m12 * this.m12);
        double d3 = Math.invsqrt(this.m20 * this.m20 + this.m21 * this.m21 + this.m22 * this.m22);
        matrix4x3d.m00 = this.m00 * d;
        matrix4x3d.m01 = this.m01 * d;
        matrix4x3d.m02 = this.m02 * d;
        matrix4x3d.m10 = this.m10 * d2;
        matrix4x3d.m11 = this.m11 * d2;
        matrix4x3d.m12 = this.m12 * d2;
        matrix4x3d.m20 = this.m20 * d3;
        matrix4x3d.m21 = this.m21 * d3;
        matrix4x3d.m22 = this.m22 * d3;
        return matrix4x3d;
    }

    @Override
    public Matrix3d normalize3x3(Matrix3d matrix3d) {
        double d = Math.invsqrt(this.m00 * this.m00 + this.m01 * this.m01 + this.m02 * this.m02);
        double d2 = Math.invsqrt(this.m10 * this.m10 + this.m11 * this.m11 + this.m12 * this.m12);
        double d3 = Math.invsqrt(this.m20 * this.m20 + this.m21 * this.m21 + this.m22 * this.m22);
        matrix3d.m00(this.m00 * d);
        matrix3d.m01(this.m01 * d);
        matrix3d.m02(this.m02 * d);
        matrix3d.m10(this.m10 * d2);
        matrix3d.m11(this.m11 * d2);
        matrix3d.m12(this.m12 * d2);
        matrix3d.m20(this.m20 * d3);
        matrix3d.m21(this.m21 * d3);
        matrix3d.m22(this.m22 * d3);
        return matrix3d;
    }

    @Override
    public Matrix4x3d reflect(double d, double d2, double d3, double d4, Matrix4x3d matrix4x3d) {
        if ((this.properties & 4) != 0) {
            return matrix4x3d.reflection(d, d2, d3, d4);
        }
        double d5 = d + d;
        double d6 = d2 + d2;
        double d7 = d3 + d3;
        double d8 = d4 + d4;
        double d9 = 1.0 - d5 * d;
        double d10 = -d5 * d2;
        double d11 = -d5 * d3;
        double d12 = -d6 * d;
        double d13 = 1.0 - d6 * d2;
        double d14 = -d6 * d3;
        double d15 = -d7 * d;
        double d16 = -d7 * d2;
        double d17 = 1.0 - d7 * d3;
        double d18 = -d8 * d;
        double d19 = -d8 * d2;
        double d20 = -d8 * d3;
        matrix4x3d.m30 = this.m00 * d18 + this.m10 * d19 + this.m20 * d20 + this.m30;
        matrix4x3d.m31 = this.m01 * d18 + this.m11 * d19 + this.m21 * d20 + this.m31;
        matrix4x3d.m32 = this.m02 * d18 + this.m12 * d19 + this.m22 * d20 + this.m32;
        double d21 = this.m00 * d9 + this.m10 * d10 + this.m20 * d11;
        double d22 = this.m01 * d9 + this.m11 * d10 + this.m21 * d11;
        double d23 = this.m02 * d9 + this.m12 * d10 + this.m22 * d11;
        double d24 = this.m00 * d12 + this.m10 * d13 + this.m20 * d14;
        double d25 = this.m01 * d12 + this.m11 * d13 + this.m21 * d14;
        double d26 = this.m02 * d12 + this.m12 * d13 + this.m22 * d14;
        matrix4x3d.m20 = this.m00 * d15 + this.m10 * d16 + this.m20 * d17;
        matrix4x3d.m21 = this.m01 * d15 + this.m11 * d16 + this.m21 * d17;
        matrix4x3d.m22 = this.m02 * d15 + this.m12 * d16 + this.m22 * d17;
        matrix4x3d.m00 = d21;
        matrix4x3d.m01 = d22;
        matrix4x3d.m02 = d23;
        matrix4x3d.m10 = d24;
        matrix4x3d.m11 = d25;
        matrix4x3d.m12 = d26;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    public Matrix4x3d reflect(double d, double d2, double d3, double d4) {
        return this.reflect(d, d2, d3, d4, this);
    }

    public Matrix4x3d reflect(double d, double d2, double d3, double d4, double d5, double d6) {
        return this.reflect(d, d2, d3, d4, d5, d6, this);
    }

    @Override
    public Matrix4x3d reflect(double d, double d2, double d3, double d4, double d5, double d6, Matrix4x3d matrix4x3d) {
        double d7 = Math.invsqrt(d * d + d2 * d2 + d3 * d3);
        double d8 = d * d7;
        double d9 = d2 * d7;
        double d10 = d3 * d7;
        return this.reflect(d8, d9, d10, -d8 * d4 - d9 * d5 - d10 * d6, matrix4x3d);
    }

    public Matrix4x3d reflect(Vector3dc vector3dc, Vector3dc vector3dc2) {
        return this.reflect(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z());
    }

    public Matrix4x3d reflect(Quaterniondc quaterniondc, Vector3dc vector3dc) {
        return this.reflect(quaterniondc, vector3dc, this);
    }

    @Override
    public Matrix4x3d reflect(Quaterniondc quaterniondc, Vector3dc vector3dc, Matrix4x3d matrix4x3d) {
        double d = quaterniondc.x() + quaterniondc.x();
        double d2 = quaterniondc.y() + quaterniondc.y();
        double d3 = quaterniondc.z() + quaterniondc.z();
        double d4 = quaterniondc.x() * d3 + quaterniondc.w() * d2;
        double d5 = quaterniondc.y() * d3 - quaterniondc.w() * d;
        double d6 = 1.0 - (quaterniondc.x() * d + quaterniondc.y() * d2);
        return this.reflect(d4, d5, d6, vector3dc.x(), vector3dc.y(), vector3dc.z(), matrix4x3d);
    }

    @Override
    public Matrix4x3d reflect(Vector3dc vector3dc, Vector3dc vector3dc2, Matrix4x3d matrix4x3d) {
        return this.reflect(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), matrix4x3d);
    }

    public Matrix4x3d reflection(double d, double d2, double d3, double d4) {
        double d5 = d + d;
        double d6 = d2 + d2;
        double d7 = d3 + d3;
        double d8 = d4 + d4;
        this.m00 = 1.0 - d5 * d;
        this.m01 = -d5 * d2;
        this.m02 = -d5 * d3;
        this.m10 = -d6 * d;
        this.m11 = 1.0 - d6 * d2;
        this.m12 = -d6 * d3;
        this.m20 = -d7 * d;
        this.m21 = -d7 * d2;
        this.m22 = 1.0 - d7 * d3;
        this.m30 = -d8 * d;
        this.m31 = -d8 * d2;
        this.m32 = -d8 * d3;
        this.properties = 16;
        return this;
    }

    public Matrix4x3d reflection(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = Math.invsqrt(d * d + d2 * d2 + d3 * d3);
        double d8 = d * d7;
        double d9 = d2 * d7;
        double d10 = d3 * d7;
        return this.reflection(d8, d9, d10, -d8 * d4 - d9 * d5 - d10 * d6);
    }

    public Matrix4x3d reflection(Vector3dc vector3dc, Vector3dc vector3dc2) {
        return this.reflection(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z());
    }

    public Matrix4x3d reflection(Quaterniondc quaterniondc, Vector3dc vector3dc) {
        double d = quaterniondc.x() + quaterniondc.x();
        double d2 = quaterniondc.y() + quaterniondc.y();
        double d3 = quaterniondc.z() + quaterniondc.z();
        double d4 = quaterniondc.x() * d3 + quaterniondc.w() * d2;
        double d5 = quaterniondc.y() * d3 - quaterniondc.w() * d;
        double d6 = 1.0 - (quaterniondc.x() * d + quaterniondc.y() * d2);
        return this.reflection(d4, d5, d6, vector3dc.x(), vector3dc.y(), vector3dc.z());
    }

    @Override
    public Matrix4x3d ortho(double d, double d2, double d3, double d4, double d5, double d6, boolean bl, Matrix4x3d matrix4x3d) {
        double d7 = 2.0 / (d2 - d);
        double d8 = 2.0 / (d4 - d3);
        double d9 = (bl ? 1.0 : 2.0) / (d5 - d6);
        double d10 = (d + d2) / (d - d2);
        double d11 = (d4 + d3) / (d3 - d4);
        double d12 = (bl ? d5 : d6 + d5) / (d5 - d6);
        matrix4x3d.m30 = this.m00 * d10 + this.m10 * d11 + this.m20 * d12 + this.m30;
        matrix4x3d.m31 = this.m01 * d10 + this.m11 * d11 + this.m21 * d12 + this.m31;
        matrix4x3d.m32 = this.m02 * d10 + this.m12 * d11 + this.m22 * d12 + this.m32;
        matrix4x3d.m00 = this.m00 * d7;
        matrix4x3d.m01 = this.m01 * d7;
        matrix4x3d.m02 = this.m02 * d7;
        matrix4x3d.m10 = this.m10 * d8;
        matrix4x3d.m11 = this.m11 * d8;
        matrix4x3d.m12 = this.m12 * d8;
        matrix4x3d.m20 = this.m20 * d9;
        matrix4x3d.m21 = this.m21 * d9;
        matrix4x3d.m22 = this.m22 * d9;
        matrix4x3d.properties = this.properties & 0xFFFFFFE3;
        return matrix4x3d;
    }

    @Override
    public Matrix4x3d ortho(double d, double d2, double d3, double d4, double d5, double d6, Matrix4x3d matrix4x3d) {
        return this.ortho(d, d2, d3, d4, d5, d6, false, matrix4x3d);
    }

    public Matrix4x3d ortho(double d, double d2, double d3, double d4, double d5, double d6, boolean bl) {
        return this.ortho(d, d2, d3, d4, d5, d6, bl, this);
    }

    public Matrix4x3d ortho(double d, double d2, double d3, double d4, double d5, double d6) {
        return this.ortho(d, d2, d3, d4, d5, d6, false);
    }

    @Override
    public Matrix4x3d orthoLH(double d, double d2, double d3, double d4, double d5, double d6, boolean bl, Matrix4x3d matrix4x3d) {
        double d7 = 2.0 / (d2 - d);
        double d8 = 2.0 / (d4 - d3);
        double d9 = (bl ? 1.0 : 2.0) / (d6 - d5);
        double d10 = (d + d2) / (d - d2);
        double d11 = (d4 + d3) / (d3 - d4);
        double d12 = (bl ? d5 : d6 + d5) / (d5 - d6);
        matrix4x3d.m30 = this.m00 * d10 + this.m10 * d11 + this.m20 * d12 + this.m30;
        matrix4x3d.m31 = this.m01 * d10 + this.m11 * d11 + this.m21 * d12 + this.m31;
        matrix4x3d.m32 = this.m02 * d10 + this.m12 * d11 + this.m22 * d12 + this.m32;
        matrix4x3d.m00 = this.m00 * d7;
        matrix4x3d.m01 = this.m01 * d7;
        matrix4x3d.m02 = this.m02 * d7;
        matrix4x3d.m10 = this.m10 * d8;
        matrix4x3d.m11 = this.m11 * d8;
        matrix4x3d.m12 = this.m12 * d8;
        matrix4x3d.m20 = this.m20 * d9;
        matrix4x3d.m21 = this.m21 * d9;
        matrix4x3d.m22 = this.m22 * d9;
        matrix4x3d.properties = this.properties & 0xFFFFFFE3;
        return matrix4x3d;
    }

    @Override
    public Matrix4x3d orthoLH(double d, double d2, double d3, double d4, double d5, double d6, Matrix4x3d matrix4x3d) {
        return this.orthoLH(d, d2, d3, d4, d5, d6, false, matrix4x3d);
    }

    public Matrix4x3d orthoLH(double d, double d2, double d3, double d4, double d5, double d6, boolean bl) {
        return this.orthoLH(d, d2, d3, d4, d5, d6, bl, this);
    }

    public Matrix4x3d orthoLH(double d, double d2, double d3, double d4, double d5, double d6) {
        return this.orthoLH(d, d2, d3, d4, d5, d6, false);
    }

    public Matrix4x3d setOrtho(double d, double d2, double d3, double d4, double d5, double d6, boolean bl) {
        this.m00 = 2.0 / (d2 - d);
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = 2.0 / (d4 - d3);
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = (bl ? 1.0 : 2.0) / (d5 - d6);
        this.m30 = (d2 + d) / (d - d2);
        this.m31 = (d4 + d3) / (d3 - d4);
        this.m32 = (bl ? d5 : d6 + d5) / (d5 - d6);
        this.properties = 0;
        return this;
    }

    public Matrix4x3d setOrtho(double d, double d2, double d3, double d4, double d5, double d6) {
        return this.setOrtho(d, d2, d3, d4, d5, d6, false);
    }

    public Matrix4x3d setOrthoLH(double d, double d2, double d3, double d4, double d5, double d6, boolean bl) {
        this.m00 = 2.0 / (d2 - d);
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = 2.0 / (d4 - d3);
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = (bl ? 1.0 : 2.0) / (d6 - d5);
        this.m30 = (d2 + d) / (d - d2);
        this.m31 = (d4 + d3) / (d3 - d4);
        this.m32 = (bl ? d5 : d6 + d5) / (d5 - d6);
        this.properties = 0;
        return this;
    }

    public Matrix4x3d setOrthoLH(double d, double d2, double d3, double d4, double d5, double d6) {
        return this.setOrthoLH(d, d2, d3, d4, d5, d6, false);
    }

    @Override
    public Matrix4x3d orthoSymmetric(double d, double d2, double d3, double d4, boolean bl, Matrix4x3d matrix4x3d) {
        double d5 = 2.0 / d;
        double d6 = 2.0 / d2;
        double d7 = (bl ? 1.0 : 2.0) / (d3 - d4);
        double d8 = (bl ? d3 : d4 + d3) / (d3 - d4);
        matrix4x3d.m30 = this.m20 * d8 + this.m30;
        matrix4x3d.m31 = this.m21 * d8 + this.m31;
        matrix4x3d.m32 = this.m22 * d8 + this.m32;
        matrix4x3d.m00 = this.m00 * d5;
        matrix4x3d.m01 = this.m01 * d5;
        matrix4x3d.m02 = this.m02 * d5;
        matrix4x3d.m10 = this.m10 * d6;
        matrix4x3d.m11 = this.m11 * d6;
        matrix4x3d.m12 = this.m12 * d6;
        matrix4x3d.m20 = this.m20 * d7;
        matrix4x3d.m21 = this.m21 * d7;
        matrix4x3d.m22 = this.m22 * d7;
        matrix4x3d.properties = this.properties & 0xFFFFFFE3;
        return matrix4x3d;
    }

    @Override
    public Matrix4x3d orthoSymmetric(double d, double d2, double d3, double d4, Matrix4x3d matrix4x3d) {
        return this.orthoSymmetric(d, d2, d3, d4, false, matrix4x3d);
    }

    public Matrix4x3d orthoSymmetric(double d, double d2, double d3, double d4, boolean bl) {
        return this.orthoSymmetric(d, d2, d3, d4, bl, this);
    }

    public Matrix4x3d orthoSymmetric(double d, double d2, double d3, double d4) {
        return this.orthoSymmetric(d, d2, d3, d4, false, this);
    }

    @Override
    public Matrix4x3d orthoSymmetricLH(double d, double d2, double d3, double d4, boolean bl, Matrix4x3d matrix4x3d) {
        double d5 = 2.0 / d;
        double d6 = 2.0 / d2;
        double d7 = (bl ? 1.0 : 2.0) / (d4 - d3);
        double d8 = (bl ? d3 : d4 + d3) / (d3 - d4);
        matrix4x3d.m30 = this.m20 * d8 + this.m30;
        matrix4x3d.m31 = this.m21 * d8 + this.m31;
        matrix4x3d.m32 = this.m22 * d8 + this.m32;
        matrix4x3d.m00 = this.m00 * d5;
        matrix4x3d.m01 = this.m01 * d5;
        matrix4x3d.m02 = this.m02 * d5;
        matrix4x3d.m10 = this.m10 * d6;
        matrix4x3d.m11 = this.m11 * d6;
        matrix4x3d.m12 = this.m12 * d6;
        matrix4x3d.m20 = this.m20 * d7;
        matrix4x3d.m21 = this.m21 * d7;
        matrix4x3d.m22 = this.m22 * d7;
        matrix4x3d.properties = this.properties & 0xFFFFFFE3;
        return matrix4x3d;
    }

    @Override
    public Matrix4x3d orthoSymmetricLH(double d, double d2, double d3, double d4, Matrix4x3d matrix4x3d) {
        return this.orthoSymmetricLH(d, d2, d3, d4, false, matrix4x3d);
    }

    public Matrix4x3d orthoSymmetricLH(double d, double d2, double d3, double d4, boolean bl) {
        return this.orthoSymmetricLH(d, d2, d3, d4, bl, this);
    }

    public Matrix4x3d orthoSymmetricLH(double d, double d2, double d3, double d4) {
        return this.orthoSymmetricLH(d, d2, d3, d4, false, this);
    }

    public Matrix4x3d setOrthoSymmetric(double d, double d2, double d3, double d4, boolean bl) {
        this.m00 = 2.0 / d;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = 2.0 / d2;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = (bl ? 1.0 : 2.0) / (d3 - d4);
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = (bl ? d3 : d4 + d3) / (d3 - d4);
        this.properties = 0;
        return this;
    }

    public Matrix4x3d setOrthoSymmetric(double d, double d2, double d3, double d4) {
        return this.setOrthoSymmetric(d, d2, d3, d4, false);
    }

    public Matrix4x3d setOrthoSymmetricLH(double d, double d2, double d3, double d4, boolean bl) {
        this.m00 = 2.0 / d;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = 2.0 / d2;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = (bl ? 1.0 : 2.0) / (d4 - d3);
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = (bl ? d3 : d4 + d3) / (d3 - d4);
        this.properties = 0;
        return this;
    }

    public Matrix4x3d setOrthoSymmetricLH(double d, double d2, double d3, double d4) {
        return this.setOrthoSymmetricLH(d, d2, d3, d4, false);
    }

    @Override
    public Matrix4x3d ortho2D(double d, double d2, double d3, double d4, Matrix4x3d matrix4x3d) {
        double d5 = 2.0 / (d2 - d);
        double d6 = 2.0 / (d4 - d3);
        double d7 = -(d2 + d) / (d2 - d);
        double d8 = -(d4 + d3) / (d4 - d3);
        matrix4x3d.m30 = this.m00 * d7 + this.m10 * d8 + this.m30;
        matrix4x3d.m31 = this.m01 * d7 + this.m11 * d8 + this.m31;
        matrix4x3d.m32 = this.m02 * d7 + this.m12 * d8 + this.m32;
        matrix4x3d.m00 = this.m00 * d5;
        matrix4x3d.m01 = this.m01 * d5;
        matrix4x3d.m02 = this.m02 * d5;
        matrix4x3d.m10 = this.m10 * d6;
        matrix4x3d.m11 = this.m11 * d6;
        matrix4x3d.m12 = this.m12 * d6;
        matrix4x3d.m20 = -this.m20;
        matrix4x3d.m21 = -this.m21;
        matrix4x3d.m22 = -this.m22;
        matrix4x3d.properties = this.properties & 0xFFFFFFE3;
        return matrix4x3d;
    }

    public Matrix4x3d ortho2D(double d, double d2, double d3, double d4) {
        return this.ortho2D(d, d2, d3, d4, this);
    }

    @Override
    public Matrix4x3d ortho2DLH(double d, double d2, double d3, double d4, Matrix4x3d matrix4x3d) {
        double d5 = 2.0 / (d2 - d);
        double d6 = 2.0 / (d4 - d3);
        double d7 = -(d2 + d) / (d2 - d);
        double d8 = -(d4 + d3) / (d4 - d3);
        matrix4x3d.m30 = this.m00 * d7 + this.m10 * d8 + this.m30;
        matrix4x3d.m31 = this.m01 * d7 + this.m11 * d8 + this.m31;
        matrix4x3d.m32 = this.m02 * d7 + this.m12 * d8 + this.m32;
        matrix4x3d.m00 = this.m00 * d5;
        matrix4x3d.m01 = this.m01 * d5;
        matrix4x3d.m02 = this.m02 * d5;
        matrix4x3d.m10 = this.m10 * d6;
        matrix4x3d.m11 = this.m11 * d6;
        matrix4x3d.m12 = this.m12 * d6;
        matrix4x3d.m20 = this.m20;
        matrix4x3d.m21 = this.m21;
        matrix4x3d.m22 = this.m22;
        matrix4x3d.properties = this.properties & 0xFFFFFFE3;
        return matrix4x3d;
    }

    public Matrix4x3d ortho2DLH(double d, double d2, double d3, double d4) {
        return this.ortho2DLH(d, d2, d3, d4, this);
    }

    public Matrix4x3d setOrtho2D(double d, double d2, double d3, double d4) {
        this.m00 = 2.0 / (d2 - d);
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = 2.0 / (d4 - d3);
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = -1.0;
        this.m30 = -(d2 + d) / (d2 - d);
        this.m31 = -(d4 + d3) / (d4 - d3);
        this.m32 = 0.0;
        this.properties = 0;
        return this;
    }

    public Matrix4x3d setOrtho2DLH(double d, double d2, double d3, double d4) {
        this.m00 = 2.0 / (d2 - d);
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = 2.0 / (d4 - d3);
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
        this.m30 = -(d2 + d) / (d2 - d);
        this.m31 = -(d4 + d3) / (d4 - d3);
        this.m32 = 0.0;
        this.properties = 0;
        return this;
    }

    public Matrix4x3d lookAlong(Vector3dc vector3dc, Vector3dc vector3dc2) {
        return this.lookAlong(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), this);
    }

    @Override
    public Matrix4x3d lookAlong(Vector3dc vector3dc, Vector3dc vector3dc2, Matrix4x3d matrix4x3d) {
        return this.lookAlong(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), matrix4x3d);
    }

    @Override
    public Matrix4x3d lookAlong(double d, double d2, double d3, double d4, double d5, double d6, Matrix4x3d matrix4x3d) {
        if ((this.properties & 4) != 0) {
            return this.setLookAlong(d, d2, d3, d4, d5, d6);
        }
        double d7 = Math.invsqrt(d * d + d2 * d2 + d3 * d3);
        double d8 = d5 * (d3 *= -d7) - d6 * (d2 *= -d7);
        double d9 = d6 * (d *= -d7) - d4 * d3;
        double d10 = d4 * d2 - d5 * d;
        double d11 = Math.invsqrt(d8 * d8 + d9 * d9 + d10 * d10);
        double d12 = d2 * (d10 *= d11) - d3 * (d9 *= d11);
        double d13 = d3 * (d8 *= d11) - d * d10;
        double d14 = d * d9 - d2 * d8;
        double d15 = d8;
        double d16 = d12;
        double d17 = d;
        double d18 = d9;
        double d19 = d13;
        double d20 = d2;
        double d21 = d10;
        double d22 = d14;
        double d23 = d3;
        double d24 = this.m00 * d15 + this.m10 * d16 + this.m20 * d17;
        double d25 = this.m01 * d15 + this.m11 * d16 + this.m21 * d17;
        double d26 = this.m02 * d15 + this.m12 * d16 + this.m22 * d17;
        double d27 = this.m00 * d18 + this.m10 * d19 + this.m20 * d20;
        double d28 = this.m01 * d18 + this.m11 * d19 + this.m21 * d20;
        double d29 = this.m02 * d18 + this.m12 * d19 + this.m22 * d20;
        matrix4x3d.m20 = this.m00 * d21 + this.m10 * d22 + this.m20 * d23;
        matrix4x3d.m21 = this.m01 * d21 + this.m11 * d22 + this.m21 * d23;
        matrix4x3d.m22 = this.m02 * d21 + this.m12 * d22 + this.m22 * d23;
        matrix4x3d.m00 = d24;
        matrix4x3d.m01 = d25;
        matrix4x3d.m02 = d26;
        matrix4x3d.m10 = d27;
        matrix4x3d.m11 = d28;
        matrix4x3d.m12 = d29;
        matrix4x3d.m30 = this.m30;
        matrix4x3d.m31 = this.m31;
        matrix4x3d.m32 = this.m32;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    public Matrix4x3d lookAlong(double d, double d2, double d3, double d4, double d5, double d6) {
        return this.lookAlong(d, d2, d3, d4, d5, d6, this);
    }

    public Matrix4x3d setLookAlong(Vector3dc vector3dc, Vector3dc vector3dc2) {
        return this.setLookAlong(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z());
    }

    public Matrix4x3d setLookAlong(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = Math.invsqrt(d * d + d2 * d2 + d3 * d3);
        double d8 = d5 * (d3 *= -d7) - d6 * (d2 *= -d7);
        double d9 = d6 * (d *= -d7) - d4 * d3;
        double d10 = d4 * d2 - d5 * d;
        double d11 = Math.invsqrt(d8 * d8 + d9 * d9 + d10 * d10);
        double d12 = d2 * (d10 *= d11) - d3 * (d9 *= d11);
        double d13 = d3 * (d8 *= d11) - d * d10;
        double d14 = d * d9 - d2 * d8;
        this.m00 = d8;
        this.m01 = d12;
        this.m02 = d;
        this.m10 = d9;
        this.m11 = d13;
        this.m12 = d2;
        this.m20 = d10;
        this.m21 = d14;
        this.m22 = d3;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.properties = 16;
        return this;
    }

    public Matrix4x3d setLookAt(Vector3dc vector3dc, Vector3dc vector3dc2, Vector3dc vector3dc3) {
        return this.setLookAt(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), vector3dc3.x(), vector3dc3.y(), vector3dc3.z());
    }

    public Matrix4x3d setLookAt(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double d10 = d - d4;
        double d11 = d2 - d5;
        double d12 = d3 - d6;
        double d13 = Math.invsqrt(d10 * d10 + d11 * d11 + d12 * d12);
        double d14 = d8 * (d12 *= d13) - d9 * (d11 *= d13);
        double d15 = d9 * (d10 *= d13) - d7 * d12;
        double d16 = d7 * d11 - d8 * d10;
        double d17 = Math.invsqrt(d14 * d14 + d15 * d15 + d16 * d16);
        double d18 = d11 * (d16 *= d17) - d12 * (d15 *= d17);
        double d19 = d12 * (d14 *= d17) - d10 * d16;
        double d20 = d10 * d15 - d11 * d14;
        this.m00 = d14;
        this.m01 = d18;
        this.m02 = d10;
        this.m10 = d15;
        this.m11 = d19;
        this.m12 = d11;
        this.m20 = d16;
        this.m21 = d20;
        this.m22 = d12;
        this.m30 = -(d14 * d + d15 * d2 + d16 * d3);
        this.m31 = -(d18 * d + d19 * d2 + d20 * d3);
        this.m32 = -(d10 * d + d11 * d2 + d12 * d3);
        this.properties = 16;
        return this;
    }

    @Override
    public Matrix4x3d lookAt(Vector3dc vector3dc, Vector3dc vector3dc2, Vector3dc vector3dc3, Matrix4x3d matrix4x3d) {
        return this.lookAt(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), vector3dc3.x(), vector3dc3.y(), vector3dc3.z(), matrix4x3d);
    }

    public Matrix4x3d lookAt(Vector3dc vector3dc, Vector3dc vector3dc2, Vector3dc vector3dc3) {
        return this.lookAt(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), vector3dc3.x(), vector3dc3.y(), vector3dc3.z(), this);
    }

    @Override
    public Matrix4x3d lookAt(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, Matrix4x3d matrix4x3d) {
        if ((this.properties & 4) != 0) {
            return matrix4x3d.setLookAt(d, d2, d3, d4, d5, d6, d7, d8, d9);
        }
        return this.lookAtGeneric(d, d2, d3, d4, d5, d6, d7, d8, d9, matrix4x3d);
    }

    private Matrix4x3d lookAtGeneric(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, Matrix4x3d matrix4x3d) {
        double d10 = d - d4;
        double d11 = d2 - d5;
        double d12 = d3 - d6;
        double d13 = Math.invsqrt(d10 * d10 + d11 * d11 + d12 * d12);
        double d14 = d8 * (d12 *= d13) - d9 * (d11 *= d13);
        double d15 = d9 * (d10 *= d13) - d7 * d12;
        double d16 = d7 * d11 - d8 * d10;
        double d17 = Math.invsqrt(d14 * d14 + d15 * d15 + d16 * d16);
        double d18 = d11 * (d16 *= d17) - d12 * (d15 *= d17);
        double d19 = d12 * (d14 *= d17) - d10 * d16;
        double d20 = d10 * d15 - d11 * d14;
        double d21 = d14;
        double d22 = d18;
        double d23 = d10;
        double d24 = d15;
        double d25 = d19;
        double d26 = d11;
        double d27 = d16;
        double d28 = d20;
        double d29 = d12;
        double d30 = -(d14 * d + d15 * d2 + d16 * d3);
        double d31 = -(d18 * d + d19 * d2 + d20 * d3);
        double d32 = -(d10 * d + d11 * d2 + d12 * d3);
        matrix4x3d.m30 = this.m00 * d30 + this.m10 * d31 + this.m20 * d32 + this.m30;
        matrix4x3d.m31 = this.m01 * d30 + this.m11 * d31 + this.m21 * d32 + this.m31;
        matrix4x3d.m32 = this.m02 * d30 + this.m12 * d31 + this.m22 * d32 + this.m32;
        double d33 = this.m00 * d21 + this.m10 * d22 + this.m20 * d23;
        double d34 = this.m01 * d21 + this.m11 * d22 + this.m21 * d23;
        double d35 = this.m02 * d21 + this.m12 * d22 + this.m22 * d23;
        double d36 = this.m00 * d24 + this.m10 * d25 + this.m20 * d26;
        double d37 = this.m01 * d24 + this.m11 * d25 + this.m21 * d26;
        double d38 = this.m02 * d24 + this.m12 * d25 + this.m22 * d26;
        matrix4x3d.m20 = this.m00 * d27 + this.m10 * d28 + this.m20 * d29;
        matrix4x3d.m21 = this.m01 * d27 + this.m11 * d28 + this.m21 * d29;
        matrix4x3d.m22 = this.m02 * d27 + this.m12 * d28 + this.m22 * d29;
        matrix4x3d.m00 = d33;
        matrix4x3d.m01 = d34;
        matrix4x3d.m02 = d35;
        matrix4x3d.m10 = d36;
        matrix4x3d.m11 = d37;
        matrix4x3d.m12 = d38;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    public Matrix4x3d lookAt(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        return this.lookAt(d, d2, d3, d4, d5, d6, d7, d8, d9, this);
    }

    public Matrix4x3d setLookAtLH(Vector3dc vector3dc, Vector3dc vector3dc2, Vector3dc vector3dc3) {
        return this.setLookAtLH(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), vector3dc3.x(), vector3dc3.y(), vector3dc3.z());
    }

    public Matrix4x3d setLookAtLH(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double d10 = d4 - d;
        double d11 = d5 - d2;
        double d12 = d6 - d3;
        double d13 = Math.invsqrt(d10 * d10 + d11 * d11 + d12 * d12);
        double d14 = d8 * (d12 *= d13) - d9 * (d11 *= d13);
        double d15 = d9 * (d10 *= d13) - d7 * d12;
        double d16 = d7 * d11 - d8 * d10;
        double d17 = Math.invsqrt(d14 * d14 + d15 * d15 + d16 * d16);
        double d18 = d11 * (d16 *= d17) - d12 * (d15 *= d17);
        double d19 = d12 * (d14 *= d17) - d10 * d16;
        double d20 = d10 * d15 - d11 * d14;
        this.m00 = d14;
        this.m01 = d18;
        this.m02 = d10;
        this.m10 = d15;
        this.m11 = d19;
        this.m12 = d11;
        this.m20 = d16;
        this.m21 = d20;
        this.m22 = d12;
        this.m30 = -(d14 * d + d15 * d2 + d16 * d3);
        this.m31 = -(d18 * d + d19 * d2 + d20 * d3);
        this.m32 = -(d10 * d + d11 * d2 + d12 * d3);
        this.properties = 16;
        return this;
    }

    @Override
    public Matrix4x3d lookAtLH(Vector3dc vector3dc, Vector3dc vector3dc2, Vector3dc vector3dc3, Matrix4x3d matrix4x3d) {
        return this.lookAtLH(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), vector3dc3.x(), vector3dc3.y(), vector3dc3.z(), matrix4x3d);
    }

    public Matrix4x3d lookAtLH(Vector3dc vector3dc, Vector3dc vector3dc2, Vector3dc vector3dc3) {
        return this.lookAtLH(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), vector3dc3.x(), vector3dc3.y(), vector3dc3.z(), this);
    }

    @Override
    public Matrix4x3d lookAtLH(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, Matrix4x3d matrix4x3d) {
        if ((this.properties & 4) != 0) {
            return matrix4x3d.setLookAtLH(d, d2, d3, d4, d5, d6, d7, d8, d9);
        }
        return this.lookAtLHGeneric(d, d2, d3, d4, d5, d6, d7, d8, d9, matrix4x3d);
    }

    private Matrix4x3d lookAtLHGeneric(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, Matrix4x3d matrix4x3d) {
        double d10 = d4 - d;
        double d11 = d5 - d2;
        double d12 = d6 - d3;
        double d13 = Math.invsqrt(d10 * d10 + d11 * d11 + d12 * d12);
        double d14 = d8 * (d12 *= d13) - d9 * (d11 *= d13);
        double d15 = d9 * (d10 *= d13) - d7 * d12;
        double d16 = d7 * d11 - d8 * d10;
        double d17 = Math.invsqrt(d14 * d14 + d15 * d15 + d16 * d16);
        double d18 = d11 * (d16 *= d17) - d12 * (d15 *= d17);
        double d19 = d12 * (d14 *= d17) - d10 * d16;
        double d20 = d10 * d15 - d11 * d14;
        double d21 = d14;
        double d22 = d18;
        double d23 = d10;
        double d24 = d15;
        double d25 = d19;
        double d26 = d11;
        double d27 = d16;
        double d28 = d20;
        double d29 = d12;
        double d30 = -(d14 * d + d15 * d2 + d16 * d3);
        double d31 = -(d18 * d + d19 * d2 + d20 * d3);
        double d32 = -(d10 * d + d11 * d2 + d12 * d3);
        matrix4x3d.m30 = this.m00 * d30 + this.m10 * d31 + this.m20 * d32 + this.m30;
        matrix4x3d.m31 = this.m01 * d30 + this.m11 * d31 + this.m21 * d32 + this.m31;
        matrix4x3d.m32 = this.m02 * d30 + this.m12 * d31 + this.m22 * d32 + this.m32;
        double d33 = this.m00 * d21 + this.m10 * d22 + this.m20 * d23;
        double d34 = this.m01 * d21 + this.m11 * d22 + this.m21 * d23;
        double d35 = this.m02 * d21 + this.m12 * d22 + this.m22 * d23;
        double d36 = this.m00 * d24 + this.m10 * d25 + this.m20 * d26;
        double d37 = this.m01 * d24 + this.m11 * d25 + this.m21 * d26;
        double d38 = this.m02 * d24 + this.m12 * d25 + this.m22 * d26;
        matrix4x3d.m20 = this.m00 * d27 + this.m10 * d28 + this.m20 * d29;
        matrix4x3d.m21 = this.m01 * d27 + this.m11 * d28 + this.m21 * d29;
        matrix4x3d.m22 = this.m02 * d27 + this.m12 * d28 + this.m22 * d29;
        matrix4x3d.m00 = d33;
        matrix4x3d.m01 = d34;
        matrix4x3d.m02 = d35;
        matrix4x3d.m10 = d36;
        matrix4x3d.m11 = d37;
        matrix4x3d.m12 = d38;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    public Matrix4x3d lookAtLH(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        return this.lookAtLH(d, d2, d3, d4, d5, d6, d7, d8, d9, this);
    }

    @Override
    public Vector4d frustumPlane(int n, Vector4d vector4d) {
        switch (n) {
            case 0: {
                vector4d.set(this.m00, this.m10, this.m20, 1.0 + this.m30).normalize();
                break;
            }
            case 1: {
                vector4d.set(-this.m00, -this.m10, -this.m20, 1.0 - this.m30).normalize();
                break;
            }
            case 2: {
                vector4d.set(this.m01, this.m11, this.m21, 1.0 + this.m31).normalize();
                break;
            }
            case 3: {
                vector4d.set(-this.m01, -this.m11, -this.m21, 1.0 - this.m31).normalize();
                break;
            }
            case 4: {
                vector4d.set(this.m02, this.m12, this.m22, 1.0 + this.m32).normalize();
                break;
            }
            case 5: {
                vector4d.set(-this.m02, -this.m12, -this.m22, 1.0 - this.m32).normalize();
                break;
            }
            default: {
                throw new IllegalArgumentException("which");
            }
        }
        return vector4d;
    }

    @Override
    public Vector3d positiveZ(Vector3d vector3d) {
        vector3d.x = this.m10 * this.m21 - this.m11 * this.m20;
        vector3d.y = this.m20 * this.m01 - this.m21 * this.m00;
        vector3d.z = this.m00 * this.m11 - this.m01 * this.m10;
        return vector3d.normalize(vector3d);
    }

    @Override
    public Vector3d normalizedPositiveZ(Vector3d vector3d) {
        vector3d.x = this.m02;
        vector3d.y = this.m12;
        vector3d.z = this.m22;
        return vector3d;
    }

    @Override
    public Vector3d positiveX(Vector3d vector3d) {
        vector3d.x = this.m11 * this.m22 - this.m12 * this.m21;
        vector3d.y = this.m02 * this.m21 - this.m01 * this.m22;
        vector3d.z = this.m01 * this.m12 - this.m02 * this.m11;
        return vector3d.normalize(vector3d);
    }

    @Override
    public Vector3d normalizedPositiveX(Vector3d vector3d) {
        vector3d.x = this.m00;
        vector3d.y = this.m10;
        vector3d.z = this.m20;
        return vector3d;
    }

    @Override
    public Vector3d positiveY(Vector3d vector3d) {
        vector3d.x = this.m12 * this.m20 - this.m10 * this.m22;
        vector3d.y = this.m00 * this.m22 - this.m02 * this.m20;
        vector3d.z = this.m02 * this.m10 - this.m00 * this.m12;
        return vector3d.normalize(vector3d);
    }

    @Override
    public Vector3d normalizedPositiveY(Vector3d vector3d) {
        vector3d.x = this.m01;
        vector3d.y = this.m11;
        vector3d.z = this.m21;
        return vector3d;
    }

    @Override
    public Vector3d origin(Vector3d vector3d) {
        double d = this.m00 * this.m11 - this.m01 * this.m10;
        double d2 = this.m00 * this.m12 - this.m02 * this.m10;
        double d3 = this.m01 * this.m12 - this.m02 * this.m11;
        double d4 = this.m20 * this.m31 - this.m21 * this.m30;
        double d5 = this.m20 * this.m32 - this.m22 * this.m30;
        double d6 = this.m21 * this.m32 - this.m22 * this.m31;
        vector3d.x = -this.m10 * d6 + this.m11 * d5 - this.m12 * d4;
        vector3d.y = this.m00 * d6 - this.m01 * d5 + this.m02 * d4;
        vector3d.z = -this.m30 * d3 + this.m31 * d2 - this.m32 * d;
        return vector3d;
    }

    public Matrix4x3d shadow(Vector4dc vector4dc, double d, double d2, double d3, double d4) {
        return this.shadow(vector4dc.x(), vector4dc.y(), vector4dc.z(), vector4dc.w(), d, d2, d3, d4, this);
    }

    @Override
    public Matrix4x3d shadow(Vector4dc vector4dc, double d, double d2, double d3, double d4, Matrix4x3d matrix4x3d) {
        return this.shadow(vector4dc.x(), vector4dc.y(), vector4dc.z(), vector4dc.w(), d, d2, d3, d4, matrix4x3d);
    }

    public Matrix4x3d shadow(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        return this.shadow(d, d2, d3, d4, d5, d6, d7, d8, this);
    }

    @Override
    public Matrix4x3d shadow(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, Matrix4x3d matrix4x3d) {
        double d9 = Math.invsqrt(d5 * d5 + d6 * d6 + d7 * d7);
        double d10 = d5 * d9;
        double d11 = d6 * d9;
        double d12 = d7 * d9;
        double d13 = d8 * d9;
        double d14 = d10 * d + d11 * d2 + d12 * d3 + d13 * d4;
        double d15 = d14 - d10 * d;
        double d16 = -d10 * d2;
        double d17 = -d10 * d3;
        double d18 = -d10 * d4;
        double d19 = -d11 * d;
        double d20 = d14 - d11 * d2;
        double d21 = -d11 * d3;
        double d22 = -d11 * d4;
        double d23 = -d12 * d;
        double d24 = -d12 * d2;
        double d25 = d14 - d12 * d3;
        double d26 = -d12 * d4;
        double d27 = -d13 * d;
        double d28 = -d13 * d2;
        double d29 = -d13 * d3;
        double d30 = d14 - d13 * d4;
        double d31 = this.m00 * d15 + this.m10 * d16 + this.m20 * d17 + this.m30 * d18;
        double d32 = this.m01 * d15 + this.m11 * d16 + this.m21 * d17 + this.m31 * d18;
        double d33 = this.m02 * d15 + this.m12 * d16 + this.m22 * d17 + this.m32 * d18;
        double d34 = this.m00 * d19 + this.m10 * d20 + this.m20 * d21 + this.m30 * d22;
        double d35 = this.m01 * d19 + this.m11 * d20 + this.m21 * d21 + this.m31 * d22;
        double d36 = this.m02 * d19 + this.m12 * d20 + this.m22 * d21 + this.m32 * d22;
        double d37 = this.m00 * d23 + this.m10 * d24 + this.m20 * d25 + this.m30 * d26;
        double d38 = this.m01 * d23 + this.m11 * d24 + this.m21 * d25 + this.m31 * d26;
        double d39 = this.m02 * d23 + this.m12 * d24 + this.m22 * d25 + this.m32 * d26;
        matrix4x3d.m30 = this.m00 * d27 + this.m10 * d28 + this.m20 * d29 + this.m30 * d30;
        matrix4x3d.m31 = this.m01 * d27 + this.m11 * d28 + this.m21 * d29 + this.m31 * d30;
        matrix4x3d.m32 = this.m02 * d27 + this.m12 * d28 + this.m22 * d29 + this.m32 * d30;
        matrix4x3d.m00 = d31;
        matrix4x3d.m01 = d32;
        matrix4x3d.m02 = d33;
        matrix4x3d.m10 = d34;
        matrix4x3d.m11 = d35;
        matrix4x3d.m12 = d36;
        matrix4x3d.m20 = d37;
        matrix4x3d.m21 = d38;
        matrix4x3d.m22 = d39;
        matrix4x3d.properties = this.properties & 0xFFFFFFE3;
        return matrix4x3d;
    }

    @Override
    public Matrix4x3d shadow(Vector4dc vector4dc, Matrix4x3dc matrix4x3dc, Matrix4x3d matrix4x3d) {
        double d = matrix4x3dc.m10();
        double d2 = matrix4x3dc.m11();
        double d3 = matrix4x3dc.m12();
        double d4 = -d * matrix4x3dc.m30() - d2 * matrix4x3dc.m31() - d3 * matrix4x3dc.m32();
        return this.shadow(vector4dc.x(), vector4dc.y(), vector4dc.z(), vector4dc.w(), d, d2, d3, d4, matrix4x3d);
    }

    public Matrix4x3d shadow(Vector4dc vector4dc, Matrix4x3dc matrix4x3dc) {
        return this.shadow(vector4dc, matrix4x3dc, this);
    }

    @Override
    public Matrix4x3d shadow(double d, double d2, double d3, double d4, Matrix4x3dc matrix4x3dc, Matrix4x3d matrix4x3d) {
        double d5 = matrix4x3dc.m10();
        double d6 = matrix4x3dc.m11();
        double d7 = matrix4x3dc.m12();
        double d8 = -d5 * matrix4x3dc.m30() - d6 * matrix4x3dc.m31() - d7 * matrix4x3dc.m32();
        return this.shadow(d, d2, d3, d4, d5, d6, d7, d8, matrix4x3d);
    }

    public Matrix4x3d shadow(double d, double d2, double d3, double d4, Matrix4x3dc matrix4x3dc) {
        return this.shadow(d, d2, d3, d4, matrix4x3dc, this);
    }

    public Matrix4x3d billboardCylindrical(Vector3dc vector3dc, Vector3dc vector3dc2, Vector3dc vector3dc3) {
        double d = vector3dc2.x() - vector3dc.x();
        double d2 = vector3dc2.y() - vector3dc.y();
        double d3 = vector3dc2.z() - vector3dc.z();
        double d4 = vector3dc3.y() * d3 - vector3dc3.z() * d2;
        double d5 = vector3dc3.z() * d - vector3dc3.x() * d3;
        double d6 = vector3dc3.x() * d2 - vector3dc3.y() * d;
        double d7 = Math.invsqrt(d4 * d4 + d5 * d5 + d6 * d6);
        d = (d5 *= d7) * vector3dc3.z() - (d6 *= d7) * vector3dc3.y();
        d2 = d6 * vector3dc3.x() - (d4 *= d7) * vector3dc3.z();
        d3 = d4 * vector3dc3.y() - d5 * vector3dc3.x();
        double d8 = Math.invsqrt(d * d + d2 * d2 + d3 * d3);
        d *= d8;
        d2 *= d8;
        d3 *= d8;
        this.m00 = d4;
        this.m01 = d5;
        this.m02 = d6;
        this.m10 = vector3dc3.x();
        this.m11 = vector3dc3.y();
        this.m12 = vector3dc3.z();
        this.m20 = d;
        this.m21 = d2;
        this.m22 = d3;
        this.m30 = vector3dc.x();
        this.m31 = vector3dc.y();
        this.m32 = vector3dc.z();
        this.properties = 16;
        return this;
    }

    public Matrix4x3d billboardSpherical(Vector3dc vector3dc, Vector3dc vector3dc2, Vector3dc vector3dc3) {
        double d = vector3dc2.x() - vector3dc.x();
        double d2 = vector3dc2.y() - vector3dc.y();
        double d3 = vector3dc2.z() - vector3dc.z();
        double d4 = Math.invsqrt(d * d + d2 * d2 + d3 * d3);
        double d5 = vector3dc3.y() * (d3 *= d4) - vector3dc3.z() * (d2 *= d4);
        double d6 = vector3dc3.z() * (d *= d4) - vector3dc3.x() * d3;
        double d7 = vector3dc3.x() * d2 - vector3dc3.y() * d;
        double d8 = Math.invsqrt(d5 * d5 + d6 * d6 + d7 * d7);
        double d9 = d2 * (d7 *= d8) - d3 * (d6 *= d8);
        double d10 = d3 * (d5 *= d8) - d * d7;
        double d11 = d * d6 - d2 * d5;
        this.m00 = d5;
        this.m01 = d6;
        this.m02 = d7;
        this.m10 = d9;
        this.m11 = d10;
        this.m12 = d11;
        this.m20 = d;
        this.m21 = d2;
        this.m22 = d3;
        this.m30 = vector3dc.x();
        this.m31 = vector3dc.y();
        this.m32 = vector3dc.z();
        this.properties = 16;
        return this;
    }

    public Matrix4x3d billboardSpherical(Vector3dc vector3dc, Vector3dc vector3dc2) {
        double d = vector3dc2.x() - vector3dc.x();
        double d2 = vector3dc2.y() - vector3dc.y();
        double d3 = vector3dc2.z() - vector3dc.z();
        double d4 = -d2;
        double d5 = d;
        double d6 = Math.sqrt(d * d + d2 * d2 + d3 * d3) + d3;
        double d7 = Math.invsqrt(d4 * d4 + d5 * d5 + d6 * d6);
        double d8 = ((d4 *= d7) + d4) * d4;
        double d9 = ((d5 *= d7) + d5) * d5;
        double d10 = (d4 + d4) * d5;
        double d11 = (d4 + d4) * (d6 *= d7);
        double d12 = (d5 + d5) * d6;
        this.m00 = 1.0 - d9;
        this.m01 = d10;
        this.m02 = -d12;
        this.m10 = d10;
        this.m11 = 1.0 - d8;
        this.m12 = d11;
        this.m20 = d12;
        this.m21 = -d11;
        this.m22 = 1.0 - d9 - d8;
        this.m30 = vector3dc.x();
        this.m31 = vector3dc.y();
        this.m32 = vector3dc.z();
        this.properties = 16;
        return this;
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.m00);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.m01);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.m02);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.m10);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.m11);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.m12);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.m20);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.m21);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.m22);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.m30);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.m31);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.m32);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Matrix4x3d)) {
            return false;
        }
        Matrix4x3d matrix4x3d = (Matrix4x3d)object;
        if (Double.doubleToLongBits(this.m00) != Double.doubleToLongBits(matrix4x3d.m00)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m01) != Double.doubleToLongBits(matrix4x3d.m01)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m02) != Double.doubleToLongBits(matrix4x3d.m02)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m10) != Double.doubleToLongBits(matrix4x3d.m10)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m11) != Double.doubleToLongBits(matrix4x3d.m11)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m12) != Double.doubleToLongBits(matrix4x3d.m12)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m20) != Double.doubleToLongBits(matrix4x3d.m20)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m21) != Double.doubleToLongBits(matrix4x3d.m21)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m22) != Double.doubleToLongBits(matrix4x3d.m22)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m30) != Double.doubleToLongBits(matrix4x3d.m30)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m31) != Double.doubleToLongBits(matrix4x3d.m31)) {
            return false;
        }
        return Double.doubleToLongBits(this.m32) == Double.doubleToLongBits(matrix4x3d.m32);
    }

    @Override
    public boolean equals(Matrix4x3dc matrix4x3dc, double d) {
        if (this == matrix4x3dc) {
            return true;
        }
        if (matrix4x3dc == null) {
            return false;
        }
        if (!(matrix4x3dc instanceof Matrix4x3d)) {
            return false;
        }
        if (!Runtime.equals(this.m00, matrix4x3dc.m00(), d)) {
            return false;
        }
        if (!Runtime.equals(this.m01, matrix4x3dc.m01(), d)) {
            return false;
        }
        if (!Runtime.equals(this.m02, matrix4x3dc.m02(), d)) {
            return false;
        }
        if (!Runtime.equals(this.m10, matrix4x3dc.m10(), d)) {
            return false;
        }
        if (!Runtime.equals(this.m11, matrix4x3dc.m11(), d)) {
            return false;
        }
        if (!Runtime.equals(this.m12, matrix4x3dc.m12(), d)) {
            return false;
        }
        if (!Runtime.equals(this.m20, matrix4x3dc.m20(), d)) {
            return false;
        }
        if (!Runtime.equals(this.m21, matrix4x3dc.m21(), d)) {
            return false;
        }
        if (!Runtime.equals(this.m22, matrix4x3dc.m22(), d)) {
            return false;
        }
        if (!Runtime.equals(this.m30, matrix4x3dc.m30(), d)) {
            return false;
        }
        if (!Runtime.equals(this.m31, matrix4x3dc.m31(), d)) {
            return false;
        }
        return Runtime.equals(this.m32, matrix4x3dc.m32(), d);
    }

    @Override
    public Matrix4x3d pick(double d, double d2, double d3, double d4, int[] nArray, Matrix4x3d matrix4x3d) {
        double d5 = (double)nArray[2] / d3;
        double d6 = (double)nArray[3] / d4;
        double d7 = ((double)nArray[2] + 2.0 * ((double)nArray[0] - d)) / d3;
        double d8 = ((double)nArray[3] + 2.0 * ((double)nArray[1] - d2)) / d4;
        matrix4x3d.m30 = this.m00 * d7 + this.m10 * d8 + this.m30;
        matrix4x3d.m31 = this.m01 * d7 + this.m11 * d8 + this.m31;
        matrix4x3d.m32 = this.m02 * d7 + this.m12 * d8 + this.m32;
        matrix4x3d.m00 = this.m00 * d5;
        matrix4x3d.m01 = this.m01 * d5;
        matrix4x3d.m02 = this.m02 * d5;
        matrix4x3d.m10 = this.m10 * d6;
        matrix4x3d.m11 = this.m11 * d6;
        matrix4x3d.m12 = this.m12 * d6;
        matrix4x3d.properties = 0;
        return matrix4x3d;
    }

    public Matrix4x3d pick(double d, double d2, double d3, double d4, int[] nArray) {
        return this.pick(d, d2, d3, d4, nArray, this);
    }

    public Matrix4x3d swap(Matrix4x3d matrix4x3d) {
        double d = this.m00;
        this.m00 = matrix4x3d.m00;
        matrix4x3d.m00 = d;
        d = this.m01;
        this.m01 = matrix4x3d.m01;
        matrix4x3d.m01 = d;
        d = this.m02;
        this.m02 = matrix4x3d.m02;
        matrix4x3d.m02 = d;
        d = this.m10;
        this.m10 = matrix4x3d.m10;
        matrix4x3d.m10 = d;
        d = this.m11;
        this.m11 = matrix4x3d.m11;
        matrix4x3d.m11 = d;
        d = this.m12;
        this.m12 = matrix4x3d.m12;
        matrix4x3d.m12 = d;
        d = this.m20;
        this.m20 = matrix4x3d.m20;
        matrix4x3d.m20 = d;
        d = this.m21;
        this.m21 = matrix4x3d.m21;
        matrix4x3d.m21 = d;
        d = this.m22;
        this.m22 = matrix4x3d.m22;
        matrix4x3d.m22 = d;
        d = this.m30;
        this.m30 = matrix4x3d.m30;
        matrix4x3d.m30 = d;
        d = this.m31;
        this.m31 = matrix4x3d.m31;
        matrix4x3d.m31 = d;
        d = this.m32;
        this.m32 = matrix4x3d.m32;
        matrix4x3d.m32 = d;
        int n = this.properties;
        this.properties = matrix4x3d.properties;
        matrix4x3d.properties = n;
        return this;
    }

    @Override
    public Matrix4x3d arcball(double d, double d2, double d3, double d4, double d5, double d6, Matrix4x3d matrix4x3d) {
        double d7 = this.m20 * -d + this.m30;
        double d8 = this.m21 * -d + this.m31;
        double d9 = this.m22 * -d + this.m32;
        double d10 = Math.sin(d5);
        double d11 = Math.cosFromSin(d10, d5);
        double d12 = this.m10 * d11 + this.m20 * d10;
        double d13 = this.m11 * d11 + this.m21 * d10;
        double d14 = this.m12 * d11 + this.m22 * d10;
        double d15 = this.m20 * d11 - this.m10 * d10;
        double d16 = this.m21 * d11 - this.m11 * d10;
        double d17 = this.m22 * d11 - this.m12 * d10;
        d10 = Math.sin(d6);
        d11 = Math.cosFromSin(d10, d6);
        double d18 = this.m00 * d11 - d15 * d10;
        double d19 = this.m01 * d11 - d16 * d10;
        double d20 = this.m02 * d11 - d17 * d10;
        double d21 = this.m00 * d10 + d15 * d11;
        double d22 = this.m01 * d10 + d16 * d11;
        double d23 = this.m02 * d10 + d17 * d11;
        matrix4x3d.m30 = -d18 * d2 - d12 * d3 - d21 * d4 + d7;
        matrix4x3d.m31 = -d19 * d2 - d13 * d3 - d22 * d4 + d8;
        matrix4x3d.m32 = -d20 * d2 - d14 * d3 - d23 * d4 + d9;
        matrix4x3d.m20 = d21;
        matrix4x3d.m21 = d22;
        matrix4x3d.m22 = d23;
        matrix4x3d.m10 = d12;
        matrix4x3d.m11 = d13;
        matrix4x3d.m12 = d14;
        matrix4x3d.m00 = d18;
        matrix4x3d.m01 = d19;
        matrix4x3d.m02 = d20;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    @Override
    public Matrix4x3d arcball(double d, Vector3dc vector3dc, double d2, double d3, Matrix4x3d matrix4x3d) {
        return this.arcball(d, vector3dc.x(), vector3dc.y(), vector3dc.z(), d2, d3, matrix4x3d);
    }

    public Matrix4x3d arcball(double d, double d2, double d3, double d4, double d5, double d6) {
        return this.arcball(d, d2, d3, d4, d5, d6, this);
    }

    public Matrix4x3d arcball(double d, Vector3dc vector3dc, double d2, double d3) {
        return this.arcball(d, vector3dc.x(), vector3dc.y(), vector3dc.z(), d2, d3, this);
    }

    @Override
    public Matrix4x3d transformAab(double d, double d2, double d3, double d4, double d5, double d6, Vector3d vector3d, Vector3d vector3d2) {
        double d7;
        double d8;
        double d9;
        double d10;
        double d11;
        double d12;
        double d13;
        double d14;
        double d15;
        double d16;
        double d17;
        double d18;
        double d19;
        double d20;
        double d21;
        double d22;
        double d23;
        double d24;
        double d25 = this.m00 * d;
        double d26 = this.m01 * d;
        double d27 = this.m02 * d;
        double d28 = this.m00 * d4;
        double d29 = this.m01 * d4;
        double d30 = this.m02 * d4;
        double d31 = this.m10 * d2;
        double d32 = this.m11 * d2;
        double d33 = this.m12 * d2;
        double d34 = this.m10 * d5;
        double d35 = this.m11 * d5;
        double d36 = this.m12 * d5;
        double d37 = this.m20 * d3;
        double d38 = this.m21 * d3;
        double d39 = this.m22 * d3;
        double d40 = this.m20 * d6;
        double d41 = this.m21 * d6;
        double d42 = this.m22 * d6;
        if (d25 < d28) {
            d24 = d25;
            d23 = d28;
        } else {
            d24 = d28;
            d23 = d25;
        }
        if (d26 < d29) {
            d22 = d26;
            d21 = d29;
        } else {
            d22 = d29;
            d21 = d26;
        }
        if (d27 < d30) {
            d20 = d27;
            d19 = d30;
        } else {
            d20 = d30;
            d19 = d27;
        }
        if (d31 < d34) {
            d18 = d31;
            d17 = d34;
        } else {
            d18 = d34;
            d17 = d31;
        }
        if (d32 < d35) {
            d16 = d32;
            d15 = d35;
        } else {
            d16 = d35;
            d15 = d32;
        }
        if (d33 < d36) {
            d14 = d33;
            d13 = d36;
        } else {
            d14 = d36;
            d13 = d33;
        }
        if (d37 < d40) {
            d12 = d37;
            d11 = d40;
        } else {
            d12 = d40;
            d11 = d37;
        }
        if (d38 < d41) {
            d10 = d38;
            d9 = d41;
        } else {
            d10 = d41;
            d9 = d38;
        }
        if (d39 < d42) {
            d8 = d39;
            d7 = d42;
        } else {
            d8 = d42;
            d7 = d39;
        }
        vector3d.x = d24 + d18 + d12 + this.m30;
        vector3d.y = d22 + d16 + d10 + this.m31;
        vector3d.z = d20 + d14 + d8 + this.m32;
        vector3d2.x = d23 + d17 + d11 + this.m30;
        vector3d2.y = d21 + d15 + d9 + this.m31;
        vector3d2.z = d19 + d13 + d7 + this.m32;
        return this;
    }

    @Override
    public Matrix4x3d transformAab(Vector3dc vector3dc, Vector3dc vector3dc2, Vector3d vector3d, Vector3d vector3d2) {
        return this.transformAab(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), vector3d, vector3d2);
    }

    public Matrix4x3d lerp(Matrix4x3dc matrix4x3dc, double d) {
        return this.lerp(matrix4x3dc, d, this);
    }

    @Override
    public Matrix4x3d lerp(Matrix4x3dc matrix4x3dc, double d, Matrix4x3d matrix4x3d) {
        matrix4x3d.m00 = Math.fma(matrix4x3dc.m00() - this.m00, d, this.m00);
        matrix4x3d.m01 = Math.fma(matrix4x3dc.m01() - this.m01, d, this.m01);
        matrix4x3d.m02 = Math.fma(matrix4x3dc.m02() - this.m02, d, this.m02);
        matrix4x3d.m10 = Math.fma(matrix4x3dc.m10() - this.m10, d, this.m10);
        matrix4x3d.m11 = Math.fma(matrix4x3dc.m11() - this.m11, d, this.m11);
        matrix4x3d.m12 = Math.fma(matrix4x3dc.m12() - this.m12, d, this.m12);
        matrix4x3d.m20 = Math.fma(matrix4x3dc.m20() - this.m20, d, this.m20);
        matrix4x3d.m21 = Math.fma(matrix4x3dc.m21() - this.m21, d, this.m21);
        matrix4x3d.m22 = Math.fma(matrix4x3dc.m22() - this.m22, d, this.m22);
        matrix4x3d.m30 = Math.fma(matrix4x3dc.m30() - this.m30, d, this.m30);
        matrix4x3d.m31 = Math.fma(matrix4x3dc.m31() - this.m31, d, this.m31);
        matrix4x3d.m32 = Math.fma(matrix4x3dc.m32() - this.m32, d, this.m32);
        matrix4x3d.properties = this.properties & matrix4x3dc.properties();
        return matrix4x3d;
    }

    @Override
    public Matrix4x3d rotateTowards(Vector3dc vector3dc, Vector3dc vector3dc2, Matrix4x3d matrix4x3d) {
        return this.rotateTowards(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), matrix4x3d);
    }

    public Matrix4x3d rotateTowards(Vector3dc vector3dc, Vector3dc vector3dc2) {
        return this.rotateTowards(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), this);
    }

    public Matrix4x3d rotateTowards(double d, double d2, double d3, double d4, double d5, double d6) {
        return this.rotateTowards(d, d2, d3, d4, d5, d6, this);
    }

    @Override
    public Matrix4x3d rotateTowards(double d, double d2, double d3, double d4, double d5, double d6, Matrix4x3d matrix4x3d) {
        double d7 = Math.invsqrt(d * d + d2 * d2 + d3 * d3);
        double d8 = d * d7;
        double d9 = d2 * d7;
        double d10 = d3 * d7;
        double d11 = d5 * d10 - d6 * d9;
        double d12 = d6 * d8 - d4 * d10;
        double d13 = d4 * d9 - d5 * d8;
        double d14 = Math.invsqrt(d11 * d11 + d12 * d12 + d13 * d13);
        double d15 = d9 * (d13 *= d14) - d10 * (d12 *= d14);
        double d16 = d10 * (d11 *= d14) - d8 * d13;
        double d17 = d8 * d12 - d9 * d11;
        double d18 = d11;
        double d19 = d12;
        double d20 = d13;
        double d21 = d15;
        double d22 = d16;
        double d23 = d17;
        double d24 = d8;
        double d25 = d9;
        double d26 = d10;
        matrix4x3d.m30 = this.m30;
        matrix4x3d.m31 = this.m31;
        matrix4x3d.m32 = this.m32;
        double d27 = this.m00 * d18 + this.m10 * d19 + this.m20 * d20;
        double d28 = this.m01 * d18 + this.m11 * d19 + this.m21 * d20;
        double d29 = this.m02 * d18 + this.m12 * d19 + this.m22 * d20;
        double d30 = this.m00 * d21 + this.m10 * d22 + this.m20 * d23;
        double d31 = this.m01 * d21 + this.m11 * d22 + this.m21 * d23;
        double d32 = this.m02 * d21 + this.m12 * d22 + this.m22 * d23;
        matrix4x3d.m20 = this.m00 * d24 + this.m10 * d25 + this.m20 * d26;
        matrix4x3d.m21 = this.m01 * d24 + this.m11 * d25 + this.m21 * d26;
        matrix4x3d.m22 = this.m02 * d24 + this.m12 * d25 + this.m22 * d26;
        matrix4x3d.m00 = d27;
        matrix4x3d.m01 = d28;
        matrix4x3d.m02 = d29;
        matrix4x3d.m10 = d30;
        matrix4x3d.m11 = d31;
        matrix4x3d.m12 = d32;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    public Matrix4x3d rotationTowards(Vector3dc vector3dc, Vector3dc vector3dc2) {
        return this.rotationTowards(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z());
    }

    public Matrix4x3d rotationTowards(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = Math.invsqrt(d * d + d2 * d2 + d3 * d3);
        double d8 = d * d7;
        double d9 = d2 * d7;
        double d10 = d3 * d7;
        double d11 = d5 * d10 - d6 * d9;
        double d12 = d6 * d8 - d4 * d10;
        double d13 = d4 * d9 - d5 * d8;
        double d14 = Math.invsqrt(d11 * d11 + d12 * d12 + d13 * d13);
        double d15 = d9 * (d13 *= d14) - d10 * (d12 *= d14);
        double d16 = d10 * (d11 *= d14) - d8 * d13;
        double d17 = d8 * d12 - d9 * d11;
        this.m00 = d11;
        this.m01 = d12;
        this.m02 = d13;
        this.m10 = d15;
        this.m11 = d16;
        this.m12 = d17;
        this.m20 = d8;
        this.m21 = d9;
        this.m22 = d10;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.properties = 16;
        return this;
    }

    public Matrix4x3d translationRotateTowards(Vector3dc vector3dc, Vector3dc vector3dc2, Vector3dc vector3dc3) {
        return this.translationRotateTowards(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), vector3dc3.x(), vector3dc3.y(), vector3dc3.z());
    }

    public Matrix4x3d translationRotateTowards(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double d10 = Math.invsqrt(d4 * d4 + d5 * d5 + d6 * d6);
        double d11 = d4 * d10;
        double d12 = d5 * d10;
        double d13 = d6 * d10;
        double d14 = d8 * d13 - d9 * d12;
        double d15 = d9 * d11 - d7 * d13;
        double d16 = d7 * d12 - d8 * d11;
        double d17 = Math.invsqrt(d14 * d14 + d15 * d15 + d16 * d16);
        double d18 = d12 * (d16 *= d17) - d13 * (d15 *= d17);
        double d19 = d13 * (d14 *= d17) - d11 * d16;
        double d20 = d11 * d15 - d12 * d14;
        this.m00 = d14;
        this.m01 = d15;
        this.m02 = d16;
        this.m10 = d18;
        this.m11 = d19;
        this.m12 = d20;
        this.m20 = d11;
        this.m21 = d12;
        this.m22 = d13;
        this.m30 = d;
        this.m31 = d2;
        this.m32 = d3;
        this.properties = 16;
        return this;
    }

    @Override
    public Vector3d getEulerAnglesZYX(Vector3d vector3d) {
        vector3d.x = Math.atan2(this.m12, this.m22);
        vector3d.y = Math.atan2(-this.m02, Math.sqrt(this.m12 * this.m12 + this.m22 * this.m22));
        vector3d.z = Math.atan2(this.m01, this.m00);
        return vector3d;
    }

    public Matrix4x3d obliqueZ(double d, double d2) {
        this.m20 = this.m00 * d + this.m10 * d2 + this.m20;
        this.m21 = this.m01 * d + this.m11 * d2 + this.m21;
        this.m22 = this.m02 * d + this.m12 * d2 + this.m22;
        this.properties = 0;
        return this;
    }

    @Override
    public Matrix4x3d obliqueZ(double d, double d2, Matrix4x3d matrix4x3d) {
        matrix4x3d.m00 = this.m00;
        matrix4x3d.m01 = this.m01;
        matrix4x3d.m02 = this.m02;
        matrix4x3d.m10 = this.m10;
        matrix4x3d.m11 = this.m11;
        matrix4x3d.m12 = this.m12;
        matrix4x3d.m20 = this.m00 * d + this.m10 * d2 + this.m20;
        matrix4x3d.m21 = this.m01 * d + this.m11 * d2 + this.m21;
        matrix4x3d.m22 = this.m02 * d + this.m12 * d2 + this.m22;
        matrix4x3d.m30 = this.m30;
        matrix4x3d.m31 = this.m31;
        matrix4x3d.m32 = this.m32;
        matrix4x3d.properties = 0;
        return matrix4x3d;
    }

    @Override
    public boolean isFinite() {
        return Math.isFinite(this.m00) && Math.isFinite(this.m01) && Math.isFinite(this.m02) && Math.isFinite(this.m10) && Math.isFinite(this.m11) && Math.isFinite(this.m12) && Math.isFinite(this.m20) && Math.isFinite(this.m21) && Math.isFinite(this.m22) && Math.isFinite(this.m30) && Math.isFinite(this.m31) && Math.isFinite(this.m32);
    }
}

