/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.joml.Matrix4d;

public class Matrix4dStack
extends Matrix4d {
    private static final long serialVersionUID = 1L;
    private Matrix4d[] mats;
    private int curr;

    public Matrix4dStack(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("stackSize must be >= 1");
        }
        this.mats = new Matrix4d[n - 1];
        for (int i = 0; i < this.mats.length; ++i) {
            this.mats[i] = new Matrix4d();
        }
    }

    public Matrix4dStack() {
    }

    public Matrix4dStack clear() {
        this.curr = 0;
        this.identity();
        return this;
    }

    public Matrix4dStack pushMatrix() {
        if (this.curr == this.mats.length) {
            throw new IllegalStateException("max stack size of " + (this.curr + 1) + " reached");
        }
        this.mats[this.curr++].set(this);
        return this;
    }

    public Matrix4dStack popMatrix() {
        if (this.curr == 0) {
            throw new IllegalStateException("already at the buttom of the stack");
        }
        this.set(this.mats[--this.curr]);
        return this;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + this.curr;
        for (int i = 0; i < this.curr; ++i) {
            n = 31 * n + this.mats[i].hashCode();
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (object instanceof Matrix4dStack) {
            Matrix4dStack matrix4dStack = (Matrix4dStack)object;
            if (this.curr != matrix4dStack.curr) {
                return false;
            }
            for (int i = 0; i < this.curr; ++i) {
                if (this.mats[i].equals(matrix4dStack.mats[i])) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeInt(this.curr);
        for (int i = 0; i < this.curr; ++i) {
            objectOutput.writeObject(this.mats[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        super.readExternal(objectInput);
        this.curr = objectInput.readInt();
        this.mats = new Matrix4dStack[this.curr];
        for (int i = 0; i < this.curr; ++i) {
            Matrix4d matrix4d = new Matrix4d();
            matrix4d.readExternal(objectInput);
            this.mats[i] = matrix4d;
        }
    }
}

