/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.joml.Math;
import org.joml.Matrix2f;
import org.joml.Matrix2fc;
import org.joml.Matrix3x2fc;
import org.joml.MemUtil;
import org.joml.Options;
import org.joml.Runtime;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3f;

public class Matrix3x2f
implements Matrix3x2fc,
Externalizable {
    private static final long serialVersionUID = 1L;
    public float m00;
    public float m01;
    public float m10;
    public float m11;
    public float m20;
    public float m21;

    public Matrix3x2f() {
        this.m00 = 1.0f;
        this.m11 = 1.0f;
    }

    public Matrix3x2f(Matrix3x2fc matrix3x2fc) {
        if (matrix3x2fc instanceof Matrix3x2f) {
            MemUtil.INSTANCE.copy((Matrix3x2f)matrix3x2fc, this);
        } else {
            this.setMatrix3x2fc(matrix3x2fc);
        }
    }

    public Matrix3x2f(Matrix2fc matrix2fc) {
        if (matrix2fc instanceof Matrix2f) {
            MemUtil.INSTANCE.copy((Matrix2f)matrix2fc, this);
        } else {
            this.setMatrix2fc(matrix2fc);
        }
    }

    public Matrix3x2f(float f, float f2, float f3, float f4, float f5, float f6) {
        this.m00 = f;
        this.m01 = f2;
        this.m10 = f3;
        this.m11 = f4;
        this.m20 = f5;
        this.m21 = f6;
    }

    public Matrix3x2f(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.get(this, floatBuffer.position(), floatBuffer);
    }

    @Override
    public float m00() {
        return this.m00;
    }

    @Override
    public float m01() {
        return this.m01;
    }

    @Override
    public float m10() {
        return this.m10;
    }

    @Override
    public float m11() {
        return this.m11;
    }

    @Override
    public float m20() {
        return this.m20;
    }

    @Override
    public float m21() {
        return this.m21;
    }

    Matrix3x2f _m00(float f) {
        this.m00 = f;
        return this;
    }

    Matrix3x2f _m01(float f) {
        this.m01 = f;
        return this;
    }

    Matrix3x2f _m10(float f) {
        this.m10 = f;
        return this;
    }

    Matrix3x2f _m11(float f) {
        this.m11 = f;
        return this;
    }

    Matrix3x2f _m20(float f) {
        this.m20 = f;
        return this;
    }

    Matrix3x2f _m21(float f) {
        this.m21 = f;
        return this;
    }

    public Matrix3x2f set(Matrix3x2fc matrix3x2fc) {
        if (matrix3x2fc instanceof Matrix3x2f) {
            MemUtil.INSTANCE.copy((Matrix3x2f)matrix3x2fc, this);
        } else {
            this.setMatrix3x2fc(matrix3x2fc);
        }
        return this;
    }

    private void setMatrix3x2fc(Matrix3x2fc matrix3x2fc) {
        this.m00 = matrix3x2fc.m00();
        this.m01 = matrix3x2fc.m01();
        this.m10 = matrix3x2fc.m10();
        this.m11 = matrix3x2fc.m11();
        this.m20 = matrix3x2fc.m20();
        this.m21 = matrix3x2fc.m21();
    }

    public Matrix3x2f set(Matrix2fc matrix2fc) {
        if (matrix2fc instanceof Matrix2f) {
            MemUtil.INSTANCE.copy((Matrix2f)matrix2fc, this);
        } else {
            this.setMatrix2fc(matrix2fc);
        }
        return this;
    }

    private void setMatrix2fc(Matrix2fc matrix2fc) {
        this.m00 = matrix2fc.m00();
        this.m01 = matrix2fc.m01();
        this.m10 = matrix2fc.m10();
        this.m11 = matrix2fc.m11();
    }

    public Matrix3x2f mul(Matrix3x2fc matrix3x2fc) {
        return this.mul(matrix3x2fc, this);
    }

    @Override
    public Matrix3x2f mul(Matrix3x2fc matrix3x2fc, Matrix3x2f matrix3x2f) {
        float f = this.m00 * matrix3x2fc.m00() + this.m10 * matrix3x2fc.m01();
        float f2 = this.m01 * matrix3x2fc.m00() + this.m11 * matrix3x2fc.m01();
        float f3 = this.m00 * matrix3x2fc.m10() + this.m10 * matrix3x2fc.m11();
        float f4 = this.m01 * matrix3x2fc.m10() + this.m11 * matrix3x2fc.m11();
        float f5 = this.m00 * matrix3x2fc.m20() + this.m10 * matrix3x2fc.m21() + this.m20;
        float f6 = this.m01 * matrix3x2fc.m20() + this.m11 * matrix3x2fc.m21() + this.m21;
        matrix3x2f.m00 = f;
        matrix3x2f.m01 = f2;
        matrix3x2f.m10 = f3;
        matrix3x2f.m11 = f4;
        matrix3x2f.m20 = f5;
        matrix3x2f.m21 = f6;
        return matrix3x2f;
    }

    public Matrix3x2f mulLocal(Matrix3x2fc matrix3x2fc) {
        return this.mulLocal(matrix3x2fc, this);
    }

    @Override
    public Matrix3x2f mulLocal(Matrix3x2fc matrix3x2fc, Matrix3x2f matrix3x2f) {
        float f = matrix3x2fc.m00() * this.m00 + matrix3x2fc.m10() * this.m01;
        float f2 = matrix3x2fc.m01() * this.m00 + matrix3x2fc.m11() * this.m01;
        float f3 = matrix3x2fc.m00() * this.m10 + matrix3x2fc.m10() * this.m11;
        float f4 = matrix3x2fc.m01() * this.m10 + matrix3x2fc.m11() * this.m11;
        float f5 = matrix3x2fc.m00() * this.m20 + matrix3x2fc.m10() * this.m21 + matrix3x2fc.m20();
        float f6 = matrix3x2fc.m01() * this.m20 + matrix3x2fc.m11() * this.m21 + matrix3x2fc.m21();
        matrix3x2f.m00 = f;
        matrix3x2f.m01 = f2;
        matrix3x2f.m10 = f3;
        matrix3x2f.m11 = f4;
        matrix3x2f.m20 = f5;
        matrix3x2f.m21 = f6;
        return matrix3x2f;
    }

    public Matrix3x2f set(float f, float f2, float f3, float f4, float f5, float f6) {
        this.m00 = f;
        this.m01 = f2;
        this.m10 = f3;
        this.m11 = f4;
        this.m20 = f5;
        this.m21 = f6;
        return this;
    }

    public Matrix3x2f set(float[] fArray) {
        MemUtil.INSTANCE.copy(fArray, 0, this);
        return this;
    }

    @Override
    public float determinant() {
        return this.m00 * this.m11 - this.m01 * this.m10;
    }

    public Matrix3x2f invert() {
        return this.invert(this);
    }

    @Override
    public Matrix3x2f invert(Matrix3x2f matrix3x2f) {
        float f = 1.0f / (this.m00 * this.m11 - this.m01 * this.m10);
        float f2 = this.m11 * f;
        float f3 = -this.m01 * f;
        float f4 = -this.m10 * f;
        float f5 = this.m00 * f;
        float f6 = (this.m10 * this.m21 - this.m20 * this.m11) * f;
        float f7 = (this.m20 * this.m01 - this.m00 * this.m21) * f;
        matrix3x2f.m00 = f2;
        matrix3x2f.m01 = f3;
        matrix3x2f.m10 = f4;
        matrix3x2f.m11 = f5;
        matrix3x2f.m20 = f6;
        matrix3x2f.m21 = f7;
        return matrix3x2f;
    }

    public Matrix3x2f translation(float f, float f2) {
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        this.m20 = f;
        this.m21 = f2;
        return this;
    }

    public Matrix3x2f translation(Vector2fc vector2fc) {
        return this.translation(vector2fc.x(), vector2fc.y());
    }

    public Matrix3x2f setTranslation(float f, float f2) {
        this.m20 = f;
        this.m21 = f2;
        return this;
    }

    public Matrix3x2f setTranslation(Vector2f vector2f) {
        return this.setTranslation(vector2f.x, vector2f.y);
    }

    @Override
    public Matrix3x2f translate(float f, float f2, Matrix3x2f matrix3x2f) {
        float f3 = f;
        float f4 = f2;
        matrix3x2f.m20 = this.m00 * f3 + this.m10 * f4 + this.m20;
        matrix3x2f.m21 = this.m01 * f3 + this.m11 * f4 + this.m21;
        matrix3x2f.m00 = this.m00;
        matrix3x2f.m01 = this.m01;
        matrix3x2f.m10 = this.m10;
        matrix3x2f.m11 = this.m11;
        return matrix3x2f;
    }

    public Matrix3x2f translate(float f, float f2) {
        return this.translate(f, f2, this);
    }

    @Override
    public Matrix3x2f translate(Vector2fc vector2fc, Matrix3x2f matrix3x2f) {
        return this.translate(vector2fc.x(), vector2fc.y(), matrix3x2f);
    }

    public Matrix3x2f translate(Vector2fc vector2fc) {
        return this.translate(vector2fc.x(), vector2fc.y(), this);
    }

    public Matrix3x2f translateLocal(Vector2fc vector2fc) {
        return this.translateLocal(vector2fc.x(), vector2fc.y());
    }

    @Override
    public Matrix3x2f translateLocal(Vector2fc vector2fc, Matrix3x2f matrix3x2f) {
        return this.translateLocal(vector2fc.x(), vector2fc.y(), matrix3x2f);
    }

    @Override
    public Matrix3x2f translateLocal(float f, float f2, Matrix3x2f matrix3x2f) {
        matrix3x2f.m00 = this.m00;
        matrix3x2f.m01 = this.m01;
        matrix3x2f.m10 = this.m10;
        matrix3x2f.m11 = this.m11;
        matrix3x2f.m20 = this.m20 + f;
        matrix3x2f.m21 = this.m21 + f2;
        return matrix3x2f;
    }

    public Matrix3x2f translateLocal(float f, float f2) {
        return this.translateLocal(f, f2, this);
    }

    public String toString() {
        DecimalFormat decimalFormat = new DecimalFormat(" 0.000E0;-");
        String string = this.toString(decimalFormat);
        StringBuffer stringBuffer = new StringBuffer();
        int n = Integer.MIN_VALUE;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == 'E') {
                n = i;
            } else {
                if (c == ' ' && n == i - 1) {
                    stringBuffer.append('+');
                    continue;
                }
                if (Character.isDigit(c) && n == i - 1) {
                    stringBuffer.append('+');
                }
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public String toString(NumberFormat numberFormat) {
        return Runtime.format(this.m00, numberFormat) + " " + Runtime.format(this.m10, numberFormat) + " " + Runtime.format(this.m20, numberFormat) + "\n" + Runtime.format(this.m01, numberFormat) + " " + Runtime.format(this.m11, numberFormat) + " " + Runtime.format(this.m21, numberFormat) + "\n";
    }

    @Override
    public Matrix3x2f get(Matrix3x2f matrix3x2f) {
        return matrix3x2f.set(this);
    }

    @Override
    public FloatBuffer get(FloatBuffer floatBuffer) {
        return this.get(floatBuffer.position(), floatBuffer);
    }

    @Override
    public FloatBuffer get(int n, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.put(this, n, floatBuffer);
        return floatBuffer;
    }

    @Override
    public ByteBuffer get(ByteBuffer byteBuffer) {
        return this.get(byteBuffer.position(), byteBuffer);
    }

    @Override
    public ByteBuffer get(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, n, byteBuffer);
        return byteBuffer;
    }

    @Override
    public FloatBuffer get3x3(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.put3x3(this, 0, floatBuffer);
        return floatBuffer;
    }

    @Override
    public FloatBuffer get3x3(int n, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.put3x3(this, n, floatBuffer);
        return floatBuffer;
    }

    @Override
    public ByteBuffer get3x3(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put3x3(this, 0, byteBuffer);
        return byteBuffer;
    }

    @Override
    public ByteBuffer get3x3(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put3x3(this, n, byteBuffer);
        return byteBuffer;
    }

    @Override
    public FloatBuffer get4x4(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.put4x4(this, 0, floatBuffer);
        return floatBuffer;
    }

    @Override
    public FloatBuffer get4x4(int n, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.put4x4(this, n, floatBuffer);
        return floatBuffer;
    }

    @Override
    public ByteBuffer get4x4(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put4x4(this, 0, byteBuffer);
        return byteBuffer;
    }

    @Override
    public ByteBuffer get4x4(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put4x4(this, n, byteBuffer);
        return byteBuffer;
    }

    @Override
    public Matrix3x2fc getToAddress(long l) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil.MemUtilUnsafe.put(this, l);
        return this;
    }

    @Override
    public float[] get(float[] fArray, int n) {
        MemUtil.INSTANCE.copy(this, fArray, n);
        return fArray;
    }

    @Override
    public float[] get(float[] fArray) {
        return this.get(fArray, 0);
    }

    @Override
    public float[] get3x3(float[] fArray, int n) {
        MemUtil.INSTANCE.copy3x3(this, fArray, n);
        return fArray;
    }

    @Override
    public float[] get3x3(float[] fArray) {
        return this.get3x3(fArray, 0);
    }

    @Override
    public float[] get4x4(float[] fArray, int n) {
        MemUtil.INSTANCE.copy4x4(this, fArray, n);
        return fArray;
    }

    @Override
    public float[] get4x4(float[] fArray) {
        return this.get4x4(fArray, 0);
    }

    public Matrix3x2f set(FloatBuffer floatBuffer) {
        int n = floatBuffer.position();
        MemUtil.INSTANCE.get(this, n, floatBuffer);
        return this;
    }

    public Matrix3x2f set(ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        MemUtil.INSTANCE.get(this, n, byteBuffer);
        return this;
    }

    public Matrix3x2f setFromAddress(long l) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil.MemUtilUnsafe.get(this, l);
        return this;
    }

    public Matrix3x2f zero() {
        MemUtil.INSTANCE.zero(this);
        return this;
    }

    public Matrix3x2f identity() {
        MemUtil.INSTANCE.identity(this);
        return this;
    }

    @Override
    public Matrix3x2f scale(float f, float f2, Matrix3x2f matrix3x2f) {
        matrix3x2f.m00 = this.m00 * f;
        matrix3x2f.m01 = this.m01 * f;
        matrix3x2f.m10 = this.m10 * f2;
        matrix3x2f.m11 = this.m11 * f2;
        matrix3x2f.m20 = this.m20;
        matrix3x2f.m21 = this.m21;
        return matrix3x2f;
    }

    public Matrix3x2f scale(float f, float f2) {
        return this.scale(f, f2, this);
    }

    public Matrix3x2f scale(Vector2fc vector2fc) {
        return this.scale(vector2fc.x(), vector2fc.y(), this);
    }

    @Override
    public Matrix3x2f scale(Vector2fc vector2fc, Matrix3x2f matrix3x2f) {
        return this.scale(vector2fc.x(), vector2fc.y(), matrix3x2f);
    }

    @Override
    public Matrix3x2f scale(float f, Matrix3x2f matrix3x2f) {
        return this.scale(f, f, matrix3x2f);
    }

    public Matrix3x2f scale(float f) {
        return this.scale(f, f);
    }

    @Override
    public Matrix3x2f scaleLocal(float f, float f2, Matrix3x2f matrix3x2f) {
        matrix3x2f.m00 = f * this.m00;
        matrix3x2f.m01 = f2 * this.m01;
        matrix3x2f.m10 = f * this.m10;
        matrix3x2f.m11 = f2 * this.m11;
        matrix3x2f.m20 = f * this.m20;
        matrix3x2f.m21 = f2 * this.m21;
        return matrix3x2f;
    }

    public Matrix3x2f scaleLocal(float f, float f2) {
        return this.scaleLocal(f, f2, this);
    }

    @Override
    public Matrix3x2f scaleLocal(float f, Matrix3x2f matrix3x2f) {
        return this.scaleLocal(f, f, matrix3x2f);
    }

    public Matrix3x2f scaleLocal(float f) {
        return this.scaleLocal(f, f, this);
    }

    @Override
    public Matrix3x2f scaleAround(float f, float f2, float f3, float f4, Matrix3x2f matrix3x2f) {
        float f5 = this.m00 * f3 + this.m10 * f4 + this.m20;
        float f6 = this.m01 * f3 + this.m11 * f4 + this.m21;
        matrix3x2f.m00 = this.m00 * f;
        matrix3x2f.m01 = this.m01 * f;
        matrix3x2f.m10 = this.m10 * f2;
        matrix3x2f.m11 = this.m11 * f2;
        matrix3x2f.m20 = matrix3x2f.m00 * -f3 + matrix3x2f.m10 * -f4 + f5;
        matrix3x2f.m21 = matrix3x2f.m01 * -f3 + matrix3x2f.m11 * -f4 + f6;
        return matrix3x2f;
    }

    public Matrix3x2f scaleAround(float f, float f2, float f3, float f4) {
        return this.scaleAround(f, f2, f3, f4, this);
    }

    @Override
    public Matrix3x2f scaleAround(float f, float f2, float f3, Matrix3x2f matrix3x2f) {
        return this.scaleAround(f, f, f2, f3, this);
    }

    public Matrix3x2f scaleAround(float f, float f2, float f3) {
        return this.scaleAround(f, f, f2, f3, this);
    }

    @Override
    public Matrix3x2f scaleAroundLocal(float f, float f2, float f3, float f4, Matrix3x2f matrix3x2f) {
        matrix3x2f.m00 = f * this.m00;
        matrix3x2f.m01 = f2 * this.m01;
        matrix3x2f.m10 = f * this.m10;
        matrix3x2f.m11 = f2 * this.m11;
        matrix3x2f.m20 = f * this.m20 - f * f3 + f3;
        matrix3x2f.m21 = f2 * this.m21 - f2 * f4 + f4;
        return matrix3x2f;
    }

    @Override
    public Matrix3x2f scaleAroundLocal(float f, float f2, float f3, Matrix3x2f matrix3x2f) {
        return this.scaleAroundLocal(f, f, f2, f3, matrix3x2f);
    }

    public Matrix3x2f scaleAroundLocal(float f, float f2, float f3, float f4, float f5, float f6) {
        return this.scaleAroundLocal(f, f2, f4, f5, this);
    }

    public Matrix3x2f scaleAroundLocal(float f, float f2, float f3) {
        return this.scaleAroundLocal(f, f, f2, f3, this);
    }

    public Matrix3x2f scaling(float f) {
        return this.scaling(f, f);
    }

    public Matrix3x2f scaling(float f, float f2) {
        this.m00 = f;
        this.m01 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = f2;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        return this;
    }

    public Matrix3x2f rotation(float f) {
        float f2 = Math.cos(f);
        float f3 = Math.sin(f);
        this.m00 = f2;
        this.m10 = -f3;
        this.m20 = 0.0f;
        this.m01 = f3;
        this.m11 = f2;
        this.m21 = 0.0f;
        return this;
    }

    @Override
    public Vector3f transform(Vector3f vector3f) {
        return vector3f.mul(this);
    }

    @Override
    public Vector3f transform(Vector3f vector3f, Vector3f vector3f2) {
        return vector3f.mul(this, vector3f2);
    }

    @Override
    public Vector3f transform(float f, float f2, float f3, Vector3f vector3f) {
        return vector3f.set(this.m00 * f + this.m10 * f2 + this.m20 * f3, this.m01 * f + this.m11 * f2 + this.m21 * f3, f3);
    }

    @Override
    public Vector2f transformPosition(Vector2f vector2f) {
        vector2f.set(this.m00 * vector2f.x + this.m10 * vector2f.y + this.m20, this.m01 * vector2f.x + this.m11 * vector2f.y + this.m21);
        return vector2f;
    }

    @Override
    public Vector2f transformPosition(Vector2fc vector2fc, Vector2f vector2f) {
        vector2f.set(this.m00 * vector2fc.x() + this.m10 * vector2fc.y() + this.m20, this.m01 * vector2fc.x() + this.m11 * vector2fc.y() + this.m21);
        return vector2f;
    }

    @Override
    public Vector2f transformPosition(float f, float f2, Vector2f vector2f) {
        return vector2f.set(this.m00 * f + this.m10 * f2 + this.m20, this.m01 * f + this.m11 * f2 + this.m21);
    }

    @Override
    public Vector2f transformDirection(Vector2f vector2f) {
        vector2f.set(this.m00 * vector2f.x + this.m10 * vector2f.y, this.m01 * vector2f.x + this.m11 * vector2f.y);
        return vector2f;
    }

    @Override
    public Vector2f transformDirection(Vector2fc vector2fc, Vector2f vector2f) {
        vector2f.set(this.m00 * vector2fc.x() + this.m10 * vector2fc.y(), this.m01 * vector2fc.x() + this.m11 * vector2fc.y());
        return vector2f;
    }

    @Override
    public Vector2f transformDirection(float f, float f2, Vector2f vector2f) {
        return vector2f.set(this.m00 * f + this.m10 * f2, this.m01 * f + this.m11 * f2);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeFloat(this.m00);
        objectOutput.writeFloat(this.m01);
        objectOutput.writeFloat(this.m10);
        objectOutput.writeFloat(this.m11);
        objectOutput.writeFloat(this.m20);
        objectOutput.writeFloat(this.m21);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        this.m00 = objectInput.readFloat();
        this.m01 = objectInput.readFloat();
        this.m10 = objectInput.readFloat();
        this.m11 = objectInput.readFloat();
        this.m20 = objectInput.readFloat();
        this.m21 = objectInput.readFloat();
    }

    public Matrix3x2f rotate(float f) {
        return this.rotate(f, this);
    }

    @Override
    public Matrix3x2f rotate(float f, Matrix3x2f matrix3x2f) {
        float f2 = Math.cos(f);
        float f3 = Math.sin(f);
        float f4 = f2;
        float f5 = f3;
        float f6 = -f3;
        float f7 = f2;
        float f8 = this.m00 * f4 + this.m10 * f5;
        float f9 = this.m01 * f4 + this.m11 * f5;
        matrix3x2f.m10 = this.m00 * f6 + this.m10 * f7;
        matrix3x2f.m11 = this.m01 * f6 + this.m11 * f7;
        matrix3x2f.m00 = f8;
        matrix3x2f.m01 = f9;
        matrix3x2f.m20 = this.m20;
        matrix3x2f.m21 = this.m21;
        return matrix3x2f;
    }

    @Override
    public Matrix3x2f rotateLocal(float f, Matrix3x2f matrix3x2f) {
        float f2 = Math.sin(f);
        float f3 = Math.cosFromSin(f2, f);
        float f4 = f3 * this.m00 - f2 * this.m01;
        float f5 = f2 * this.m00 + f3 * this.m01;
        float f6 = f3 * this.m10 - f2 * this.m11;
        float f7 = f2 * this.m10 + f3 * this.m11;
        float f8 = f3 * this.m20 - f2 * this.m21;
        float f9 = f2 * this.m20 + f3 * this.m21;
        matrix3x2f.m00 = f4;
        matrix3x2f.m01 = f5;
        matrix3x2f.m10 = f6;
        matrix3x2f.m11 = f7;
        matrix3x2f.m20 = f8;
        matrix3x2f.m21 = f9;
        return matrix3x2f;
    }

    public Matrix3x2f rotateLocal(float f) {
        return this.rotateLocal(f, this);
    }

    public Matrix3x2f rotateAbout(float f, float f2, float f3) {
        return this.rotateAbout(f, f2, f3, this);
    }

    @Override
    public Matrix3x2f rotateAbout(float f, float f2, float f3, Matrix3x2f matrix3x2f) {
        float f4 = this.m00 * f2 + this.m10 * f3 + this.m20;
        float f5 = this.m01 * f2 + this.m11 * f3 + this.m21;
        float f6 = Math.cos(f);
        float f7 = Math.sin(f);
        float f8 = this.m00 * f6 + this.m10 * f7;
        float f9 = this.m01 * f6 + this.m11 * f7;
        matrix3x2f.m10 = this.m00 * -f7 + this.m10 * f6;
        matrix3x2f.m11 = this.m01 * -f7 + this.m11 * f6;
        matrix3x2f.m00 = f8;
        matrix3x2f.m01 = f9;
        matrix3x2f.m20 = matrix3x2f.m00 * -f2 + matrix3x2f.m10 * -f3 + f4;
        matrix3x2f.m21 = matrix3x2f.m01 * -f2 + matrix3x2f.m11 * -f3 + f5;
        return matrix3x2f;
    }

    @Override
    public Matrix3x2f rotateTo(Vector2fc vector2fc, Vector2fc vector2fc2, Matrix3x2f matrix3x2f) {
        float f = vector2fc.x() * vector2fc2.x() + vector2fc.y() * vector2fc2.y();
        float f2 = vector2fc.x() * vector2fc2.y() - vector2fc.y() * vector2fc2.x();
        float f3 = f;
        float f4 = f2;
        float f5 = -f2;
        float f6 = f;
        float f7 = this.m00 * f3 + this.m10 * f4;
        float f8 = this.m01 * f3 + this.m11 * f4;
        matrix3x2f.m10 = this.m00 * f5 + this.m10 * f6;
        matrix3x2f.m11 = this.m01 * f5 + this.m11 * f6;
        matrix3x2f.m00 = f7;
        matrix3x2f.m01 = f8;
        matrix3x2f.m20 = this.m20;
        matrix3x2f.m21 = this.m21;
        return matrix3x2f;
    }

    public Matrix3x2f rotateTo(Vector2fc vector2fc, Vector2fc vector2fc2) {
        return this.rotateTo(vector2fc, vector2fc2, this);
    }

    @Override
    public Matrix3x2f view(float f, float f2, float f3, float f4, Matrix3x2f matrix3x2f) {
        float f5 = 2.0f / (f2 - f);
        float f6 = 2.0f / (f4 - f3);
        float f7 = (f + f2) / (f - f2);
        float f8 = (f3 + f4) / (f3 - f4);
        matrix3x2f.m20 = this.m00 * f7 + this.m10 * f8 + this.m20;
        matrix3x2f.m21 = this.m01 * f7 + this.m11 * f8 + this.m21;
        matrix3x2f.m00 = this.m00 * f5;
        matrix3x2f.m01 = this.m01 * f5;
        matrix3x2f.m10 = this.m10 * f6;
        matrix3x2f.m11 = this.m11 * f6;
        return matrix3x2f;
    }

    public Matrix3x2f view(float f, float f2, float f3, float f4) {
        return this.view(f, f2, f3, f4, this);
    }

    public Matrix3x2f setView(float f, float f2, float f3, float f4) {
        this.m00 = 2.0f / (f2 - f);
        this.m01 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 2.0f / (f4 - f3);
        this.m20 = (f + f2) / (f - f2);
        this.m21 = (f3 + f4) / (f3 - f4);
        return this;
    }

    @Override
    public Vector2f origin(Vector2f vector2f) {
        float f = 1.0f / (this.m00 * this.m11 - this.m01 * this.m10);
        vector2f.x = (this.m10 * this.m21 - this.m20 * this.m11) * f;
        vector2f.y = (this.m20 * this.m01 - this.m00 * this.m21) * f;
        return vector2f;
    }

    @Override
    public float[] viewArea(float[] fArray) {
        float f = 1.0f / (this.m00 * this.m11 - this.m01 * this.m10);
        float f2 = this.m11 * f;
        float f3 = -this.m01 * f;
        float f4 = -this.m10 * f;
        float f5 = this.m00 * f;
        float f6 = (this.m10 * this.m21 - this.m20 * this.m11) * f;
        float f7 = (this.m20 * this.m01 - this.m00 * this.m21) * f;
        float f8 = -f2 - f4;
        float f9 = -f3 - f5;
        float f10 = f2 - f4;
        float f11 = f3 - f5;
        float f12 = -f2 + f4;
        float f13 = -f3 + f5;
        float f14 = f2 + f4;
        float f15 = f3 + f5;
        float f16 = f8;
        f16 = f16 < f12 ? f16 : f12;
        f16 = f16 < f10 ? f16 : f10;
        f16 = f16 < f14 ? f16 : f14;
        float f17 = f9;
        f17 = f17 < f13 ? f17 : f13;
        f17 = f17 < f11 ? f17 : f11;
        f17 = f17 < f15 ? f17 : f15;
        float f18 = f8;
        f18 = f18 > f12 ? f18 : f12;
        f18 = f18 > f10 ? f18 : f10;
        f18 = f18 > f14 ? f18 : f14;
        float f19 = f9;
        f19 = f19 > f13 ? f19 : f13;
        f19 = f19 > f11 ? f19 : f11;
        f19 = f19 > f15 ? f19 : f15;
        fArray[0] = f16 + f6;
        fArray[1] = f17 + f7;
        fArray[2] = f18 + f6;
        fArray[3] = f19 + f7;
        return fArray;
    }

    @Override
    public Vector2f positiveX(Vector2f vector2f) {
        float f = this.m00 * this.m11 - this.m01 * this.m10;
        f = 1.0f / f;
        vector2f.x = this.m11 * f;
        vector2f.y = -this.m01 * f;
        return vector2f.normalize(vector2f);
    }

    @Override
    public Vector2f normalizedPositiveX(Vector2f vector2f) {
        vector2f.x = this.m11;
        vector2f.y = -this.m01;
        return vector2f;
    }

    @Override
    public Vector2f positiveY(Vector2f vector2f) {
        float f = this.m00 * this.m11 - this.m01 * this.m10;
        f = 1.0f / f;
        vector2f.x = -this.m10 * f;
        vector2f.y = this.m00 * f;
        return vector2f.normalize(vector2f);
    }

    @Override
    public Vector2f normalizedPositiveY(Vector2f vector2f) {
        vector2f.x = -this.m10;
        vector2f.y = this.m00;
        return vector2f;
    }

    @Override
    public Vector2f unproject(float f, float f2, int[] nArray, Vector2f vector2f) {
        float f3 = 1.0f / (this.m00 * this.m11 - this.m01 * this.m10);
        float f4 = this.m11 * f3;
        float f5 = -this.m01 * f3;
        float f6 = -this.m10 * f3;
        float f7 = this.m00 * f3;
        float f8 = (this.m10 * this.m21 - this.m20 * this.m11) * f3;
        float f9 = (this.m20 * this.m01 - this.m00 * this.m21) * f3;
        float f10 = (f - (float)nArray[0]) / (float)nArray[2] * 2.0f - 1.0f;
        float f11 = (f2 - (float)nArray[1]) / (float)nArray[3] * 2.0f - 1.0f;
        vector2f.x = f4 * f10 + f6 * f11 + f8;
        vector2f.y = f5 * f10 + f7 * f11 + f9;
        return vector2f;
    }

    @Override
    public Vector2f unprojectInv(float f, float f2, int[] nArray, Vector2f vector2f) {
        float f3 = (f - (float)nArray[0]) / (float)nArray[2] * 2.0f - 1.0f;
        float f4 = (f2 - (float)nArray[1]) / (float)nArray[3] * 2.0f - 1.0f;
        vector2f.x = this.m00 * f3 + this.m10 * f4 + this.m20;
        vector2f.y = this.m01 * f3 + this.m11 * f4 + this.m21;
        return vector2f;
    }

    public Matrix3x2f shearX(float f) {
        return this.shearX(f, this);
    }

    public Matrix3x2f shearX(float f, Matrix3x2f matrix3x2f) {
        float f2 = this.m00 * f + this.m10;
        float f3 = this.m01 * f + this.m11;
        matrix3x2f.m00 = this.m00;
        matrix3x2f.m01 = this.m01;
        matrix3x2f.m10 = f2;
        matrix3x2f.m11 = f3;
        matrix3x2f.m20 = this.m20;
        matrix3x2f.m21 = this.m21;
        return matrix3x2f;
    }

    public Matrix3x2f shearY(float f) {
        return this.shearY(f, this);
    }

    public Matrix3x2f shearY(float f, Matrix3x2f matrix3x2f) {
        float f2 = this.m00 + this.m10 * f;
        float f3 = this.m01 + this.m11 * f;
        matrix3x2f.m00 = f2;
        matrix3x2f.m01 = f3;
        matrix3x2f.m10 = this.m10;
        matrix3x2f.m11 = this.m11;
        matrix3x2f.m20 = this.m20;
        matrix3x2f.m21 = this.m21;
        return matrix3x2f;
    }

    public Matrix3x2f span(Vector2f vector2f, Vector2f vector2f2, Vector2f vector2f3) {
        float f = 1.0f / (this.m00 * this.m11 - this.m01 * this.m10);
        float f2 = this.m11 * f;
        float f3 = -this.m01 * f;
        float f4 = -this.m10 * f;
        float f5 = this.m00 * f;
        vector2f.x = -f2 - f4 + (this.m10 * this.m21 - this.m20 * this.m11) * f;
        vector2f.y = -f3 - f5 + (this.m20 * this.m01 - this.m00 * this.m21) * f;
        vector2f2.x = 2.0f * f2;
        vector2f2.y = 2.0f * f3;
        vector2f3.x = 2.0f * f4;
        vector2f3.y = 2.0f * f5;
        return this;
    }

    @Override
    public boolean testPoint(float f, float f2) {
        float f3 = this.m00;
        float f4 = this.m10;
        float f5 = 1.0f + this.m20;
        float f6 = -this.m00;
        float f7 = -this.m10;
        float f8 = 1.0f - this.m20;
        float f9 = this.m01;
        float f10 = this.m11;
        float f11 = 1.0f + this.m21;
        float f12 = -this.m01;
        float f13 = -this.m11;
        float f14 = 1.0f - this.m21;
        return f3 * f + f4 * f2 + f5 >= 0.0f && f6 * f + f7 * f2 + f8 >= 0.0f && f9 * f + f10 * f2 + f11 >= 0.0f && f12 * f + f13 * f2 + f14 >= 0.0f;
    }

    @Override
    public boolean testCircle(float f, float f2, float f3) {
        float f4 = this.m00;
        float f5 = this.m10;
        float f6 = 1.0f + this.m20;
        float f7 = Math.invsqrt(f4 * f4 + f5 * f5);
        f4 *= f7;
        f5 *= f7;
        f6 *= f7;
        float f8 = -this.m00;
        float f9 = -this.m10;
        float f10 = 1.0f - this.m20;
        f7 = Math.invsqrt(f8 * f8 + f9 * f9);
        f8 *= f7;
        f9 *= f7;
        f10 *= f7;
        float f11 = this.m01;
        float f12 = this.m11;
        float f13 = 1.0f + this.m21;
        f7 = Math.invsqrt(f11 * f11 + f12 * f12);
        f11 *= f7;
        f12 *= f7;
        f13 *= f7;
        float f14 = -this.m01;
        float f15 = -this.m11;
        float f16 = 1.0f - this.m21;
        f7 = Math.invsqrt(f14 * f14 + f15 * f15);
        return f4 * f + f5 * f2 + f6 >= -f3 && f8 * f + f9 * f2 + f10 >= -f3 && f11 * f + f12 * f2 + f13 >= -f3 && (f14 *= f7) * f + (f15 *= f7) * f2 + (f16 *= f7) >= -f3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean testAar(float f, float f2, float f3, float f4) {
        float f5 = this.m00;
        float f6 = this.m10;
        float f7 = 1.0f + this.m20;
        float f8 = -this.m00;
        float f9 = -this.m10;
        float f10 = 1.0f - this.m20;
        float f11 = this.m01;
        float f12 = this.m11;
        float f13 = 1.0f + this.m21;
        float f14 = -this.m01;
        float f15 = -this.m11;
        float f16 = 1.0f - this.m21;
        float f17 = f5 * (f5 < 0.0f ? f : f3);
        float f18 = f6 < 0.0f ? f2 : f4;
        if (!(f17 + f6 * f18 >= -f7)) return false;
        float f19 = f8 * (f8 < 0.0f ? f : f3);
        float f20 = f9 < 0.0f ? f2 : f4;
        if (!(f19 + f9 * f20 >= -f10)) return false;
        float f21 = f11 * (f11 < 0.0f ? f : f3);
        float f22 = f12 < 0.0f ? f2 : f4;
        if (!(f21 + f12 * f22 >= -f13)) return false;
        float f23 = f14 * (f14 < 0.0f ? f : f3);
        float f24 = f15 < 0.0f ? f2 : f4;
        if (!(f23 + f15 * f24 >= -f16)) return false;
        return true;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + Float.floatToIntBits(this.m00);
        n = 31 * n + Float.floatToIntBits(this.m01);
        n = 31 * n + Float.floatToIntBits(this.m10);
        n = 31 * n + Float.floatToIntBits(this.m11);
        n = 31 * n + Float.floatToIntBits(this.m20);
        n = 31 * n + Float.floatToIntBits(this.m21);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Matrix3x2f matrix3x2f = (Matrix3x2f)object;
        if (Float.floatToIntBits(this.m00) != Float.floatToIntBits(matrix3x2f.m00)) {
            return false;
        }
        if (Float.floatToIntBits(this.m01) != Float.floatToIntBits(matrix3x2f.m01)) {
            return false;
        }
        if (Float.floatToIntBits(this.m10) != Float.floatToIntBits(matrix3x2f.m10)) {
            return false;
        }
        if (Float.floatToIntBits(this.m11) != Float.floatToIntBits(matrix3x2f.m11)) {
            return false;
        }
        if (Float.floatToIntBits(this.m20) != Float.floatToIntBits(matrix3x2f.m20)) {
            return false;
        }
        return Float.floatToIntBits(this.m21) == Float.floatToIntBits(matrix3x2f.m21);
    }

    @Override
    public boolean equals(Matrix3x2fc matrix3x2fc, float f) {
        if (this == matrix3x2fc) {
            return true;
        }
        if (matrix3x2fc == null) {
            return false;
        }
        if (!(matrix3x2fc instanceof Matrix3x2f)) {
            return false;
        }
        if (!Runtime.equals(this.m00, matrix3x2fc.m00(), f)) {
            return false;
        }
        if (!Runtime.equals(this.m01, matrix3x2fc.m01(), f)) {
            return false;
        }
        if (!Runtime.equals(this.m10, matrix3x2fc.m10(), f)) {
            return false;
        }
        if (!Runtime.equals(this.m11, matrix3x2fc.m11(), f)) {
            return false;
        }
        if (!Runtime.equals(this.m20, matrix3x2fc.m20(), f)) {
            return false;
        }
        return Runtime.equals(this.m21, matrix3x2fc.m21(), f);
    }

    @Override
    public boolean isFinite() {
        return Math.isFinite(this.m00) && Math.isFinite(this.m01) && Math.isFinite(this.m10) && Math.isFinite(this.m11) && Math.isFinite(this.m20) && Math.isFinite(this.m21);
    }
}

