/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.joml.Math;
import org.joml.Matrix2d;
import org.joml.Matrix2dc;
import org.joml.Matrix2fc;
import org.joml.Matrix3x2dc;
import org.joml.MemUtil;
import org.joml.Options;
import org.joml.Runtime;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.joml.Vector2fc;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class Matrix3x2d
implements Matrix3x2dc,
Externalizable {
    private static final long serialVersionUID = 1L;
    public double m00;
    public double m01;
    public double m10;
    public double m11;
    public double m20;
    public double m21;

    public Matrix3x2d() {
        this.m00 = 1.0;
        this.m11 = 1.0;
    }

    public Matrix3x2d(Matrix2dc matrix2dc) {
        if (matrix2dc instanceof Matrix2d) {
            MemUtil.INSTANCE.copy((Matrix2d)matrix2dc, this);
        } else {
            this.setMatrix2dc(matrix2dc);
        }
    }

    public Matrix3x2d(Matrix2fc matrix2fc) {
        this.m00 = matrix2fc.m00();
        this.m01 = matrix2fc.m01();
        this.m10 = matrix2fc.m10();
        this.m11 = matrix2fc.m11();
    }

    public Matrix3x2d(Matrix3x2dc matrix3x2dc) {
        if (matrix3x2dc instanceof Matrix3x2d) {
            MemUtil.INSTANCE.copy((Matrix3x2d)matrix3x2dc, this);
        } else {
            this.setMatrix3x2dc(matrix3x2dc);
        }
    }

    public Matrix3x2d(double d, double d2, double d3, double d4, double d5, double d6) {
        this.m00 = d;
        this.m01 = d2;
        this.m10 = d3;
        this.m11 = d4;
        this.m20 = d5;
        this.m21 = d6;
    }

    public Matrix3x2d(DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.get(this, doubleBuffer.position(), doubleBuffer);
    }

    @Override
    public double m00() {
        return this.m00;
    }

    @Override
    public double m01() {
        return this.m01;
    }

    @Override
    public double m10() {
        return this.m10;
    }

    @Override
    public double m11() {
        return this.m11;
    }

    @Override
    public double m20() {
        return this.m20;
    }

    @Override
    public double m21() {
        return this.m21;
    }

    Matrix3x2d _m00(double d) {
        this.m00 = d;
        return this;
    }

    Matrix3x2d _m01(double d) {
        this.m01 = d;
        return this;
    }

    Matrix3x2d _m10(double d) {
        this.m10 = d;
        return this;
    }

    Matrix3x2d _m11(double d) {
        this.m11 = d;
        return this;
    }

    Matrix3x2d _m20(double d) {
        this.m20 = d;
        return this;
    }

    Matrix3x2d _m21(double d) {
        this.m21 = d;
        return this;
    }

    public Matrix3x2d set(Matrix3x2dc matrix3x2dc) {
        if (matrix3x2dc instanceof Matrix3x2d) {
            MemUtil.INSTANCE.copy((Matrix3x2d)matrix3x2dc, this);
        } else {
            this.setMatrix3x2dc(matrix3x2dc);
        }
        return this;
    }

    private void setMatrix3x2dc(Matrix3x2dc matrix3x2dc) {
        this.m00 = matrix3x2dc.m00();
        this.m01 = matrix3x2dc.m01();
        this.m10 = matrix3x2dc.m10();
        this.m11 = matrix3x2dc.m11();
        this.m20 = matrix3x2dc.m20();
        this.m21 = matrix3x2dc.m21();
    }

    public Matrix3x2d set(Matrix2dc matrix2dc) {
        if (matrix2dc instanceof Matrix2d) {
            MemUtil.INSTANCE.copy((Matrix2d)matrix2dc, this);
        } else {
            this.setMatrix2dc(matrix2dc);
        }
        return this;
    }

    private void setMatrix2dc(Matrix2dc matrix2dc) {
        this.m00 = matrix2dc.m00();
        this.m01 = matrix2dc.m01();
        this.m10 = matrix2dc.m10();
        this.m11 = matrix2dc.m11();
    }

    public Matrix3x2d set(Matrix2fc matrix2fc) {
        this.m00 = matrix2fc.m00();
        this.m01 = matrix2fc.m01();
        this.m10 = matrix2fc.m10();
        this.m11 = matrix2fc.m11();
        return this;
    }

    public Matrix3x2d mul(Matrix3x2dc matrix3x2dc) {
        return this.mul(matrix3x2dc, this);
    }

    @Override
    public Matrix3x2d mul(Matrix3x2dc matrix3x2dc, Matrix3x2d matrix3x2d) {
        double d = this.m00 * matrix3x2dc.m00() + this.m10 * matrix3x2dc.m01();
        double d2 = this.m01 * matrix3x2dc.m00() + this.m11 * matrix3x2dc.m01();
        double d3 = this.m00 * matrix3x2dc.m10() + this.m10 * matrix3x2dc.m11();
        double d4 = this.m01 * matrix3x2dc.m10() + this.m11 * matrix3x2dc.m11();
        double d5 = this.m00 * matrix3x2dc.m20() + this.m10 * matrix3x2dc.m21() + this.m20;
        double d6 = this.m01 * matrix3x2dc.m20() + this.m11 * matrix3x2dc.m21() + this.m21;
        matrix3x2d.m00 = d;
        matrix3x2d.m01 = d2;
        matrix3x2d.m10 = d3;
        matrix3x2d.m11 = d4;
        matrix3x2d.m20 = d5;
        matrix3x2d.m21 = d6;
        return matrix3x2d;
    }

    public Matrix3x2d mulLocal(Matrix3x2dc matrix3x2dc) {
        return this.mulLocal(matrix3x2dc, this);
    }

    @Override
    public Matrix3x2d mulLocal(Matrix3x2dc matrix3x2dc, Matrix3x2d matrix3x2d) {
        double d = matrix3x2dc.m00() * this.m00 + matrix3x2dc.m10() * this.m01;
        double d2 = matrix3x2dc.m01() * this.m00 + matrix3x2dc.m11() * this.m01;
        double d3 = matrix3x2dc.m00() * this.m10 + matrix3x2dc.m10() * this.m11;
        double d4 = matrix3x2dc.m01() * this.m10 + matrix3x2dc.m11() * this.m11;
        double d5 = matrix3x2dc.m00() * this.m20 + matrix3x2dc.m10() * this.m21 + matrix3x2dc.m20();
        double d6 = matrix3x2dc.m01() * this.m20 + matrix3x2dc.m11() * this.m21 + matrix3x2dc.m21();
        matrix3x2d.m00 = d;
        matrix3x2d.m01 = d2;
        matrix3x2d.m10 = d3;
        matrix3x2d.m11 = d4;
        matrix3x2d.m20 = d5;
        matrix3x2d.m21 = d6;
        return matrix3x2d;
    }

    public Matrix3x2d set(double d, double d2, double d3, double d4, double d5, double d6) {
        this.m00 = d;
        this.m01 = d2;
        this.m10 = d3;
        this.m11 = d4;
        this.m20 = d5;
        this.m21 = d6;
        return this;
    }

    public Matrix3x2d set(double[] dArray) {
        MemUtil.INSTANCE.copy(dArray, 0, this);
        return this;
    }

    @Override
    public double determinant() {
        return this.m00 * this.m11 - this.m01 * this.m10;
    }

    public Matrix3x2d invert() {
        return this.invert(this);
    }

    @Override
    public Matrix3x2d invert(Matrix3x2d matrix3x2d) {
        double d = 1.0 / (this.m00 * this.m11 - this.m01 * this.m10);
        double d2 = this.m11 * d;
        double d3 = -this.m01 * d;
        double d4 = -this.m10 * d;
        double d5 = this.m00 * d;
        double d6 = (this.m10 * this.m21 - this.m20 * this.m11) * d;
        double d7 = (this.m20 * this.m01 - this.m00 * this.m21) * d;
        matrix3x2d.m00 = d2;
        matrix3x2d.m01 = d3;
        matrix3x2d.m10 = d4;
        matrix3x2d.m11 = d5;
        matrix3x2d.m20 = d6;
        matrix3x2d.m21 = d7;
        return matrix3x2d;
    }

    public Matrix3x2d translation(double d, double d2) {
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m20 = d;
        this.m21 = d2;
        return this;
    }

    public Matrix3x2d translation(Vector2dc vector2dc) {
        return this.translation(vector2dc.x(), vector2dc.y());
    }

    public Matrix3x2d setTranslation(double d, double d2) {
        this.m20 = d;
        this.m21 = d2;
        return this;
    }

    public Matrix3x2d setTranslation(Vector2dc vector2dc) {
        return this.setTranslation(vector2dc.x(), vector2dc.y());
    }

    @Override
    public Matrix3x2d translate(double d, double d2, Matrix3x2d matrix3x2d) {
        double d3 = d;
        double d4 = d2;
        matrix3x2d.m20 = this.m00 * d3 + this.m10 * d4 + this.m20;
        matrix3x2d.m21 = this.m01 * d3 + this.m11 * d4 + this.m21;
        matrix3x2d.m00 = this.m00;
        matrix3x2d.m01 = this.m01;
        matrix3x2d.m10 = this.m10;
        matrix3x2d.m11 = this.m11;
        return matrix3x2d;
    }

    public Matrix3x2d translate(double d, double d2) {
        return this.translate(d, d2, this);
    }

    @Override
    public Matrix3x2d translate(Vector2dc vector2dc, Matrix3x2d matrix3x2d) {
        return this.translate(vector2dc.x(), vector2dc.y(), matrix3x2d);
    }

    public Matrix3x2d translate(Vector2dc vector2dc) {
        return this.translate(vector2dc.x(), vector2dc.y(), this);
    }

    public Matrix3x2d translateLocal(Vector2dc vector2dc) {
        return this.translateLocal(vector2dc.x(), vector2dc.y());
    }

    @Override
    public Matrix3x2d translateLocal(Vector2dc vector2dc, Matrix3x2d matrix3x2d) {
        return this.translateLocal(vector2dc.x(), vector2dc.y(), matrix3x2d);
    }

    @Override
    public Matrix3x2d translateLocal(double d, double d2, Matrix3x2d matrix3x2d) {
        matrix3x2d.m00 = this.m00;
        matrix3x2d.m01 = this.m01;
        matrix3x2d.m10 = this.m10;
        matrix3x2d.m11 = this.m11;
        matrix3x2d.m20 = this.m20 + d;
        matrix3x2d.m21 = this.m21 + d2;
        return matrix3x2d;
    }

    public Matrix3x2d translateLocal(double d, double d2) {
        return this.translateLocal(d, d2, this);
    }

    public String toString() {
        DecimalFormat decimalFormat = new DecimalFormat(" 0.000E0;-");
        String string = this.toString(decimalFormat);
        StringBuffer stringBuffer = new StringBuffer();
        int n = Integer.MIN_VALUE;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == 'E') {
                n = i;
            } else {
                if (c == ' ' && n == i - 1) {
                    stringBuffer.append('+');
                    continue;
                }
                if (Character.isDigit(c) && n == i - 1) {
                    stringBuffer.append('+');
                }
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public String toString(NumberFormat numberFormat) {
        return Runtime.format(this.m00, numberFormat) + " " + Runtime.format(this.m10, numberFormat) + " " + Runtime.format(this.m20, numberFormat) + "\n" + Runtime.format(this.m01, numberFormat) + " " + Runtime.format(this.m11, numberFormat) + " " + Runtime.format(this.m21, numberFormat) + "\n";
    }

    @Override
    public Matrix3x2d get(Matrix3x2d matrix3x2d) {
        return matrix3x2d.set(this);
    }

    @Override
    public DoubleBuffer get(DoubleBuffer doubleBuffer) {
        return this.get(doubleBuffer.position(), doubleBuffer);
    }

    @Override
    public DoubleBuffer get(int n, DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.put(this, n, doubleBuffer);
        return doubleBuffer;
    }

    @Override
    public ByteBuffer get(ByteBuffer byteBuffer) {
        return this.get(byteBuffer.position(), byteBuffer);
    }

    @Override
    public ByteBuffer get(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, n, byteBuffer);
        return byteBuffer;
    }

    @Override
    public DoubleBuffer get3x3(DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.put3x3(this, 0, doubleBuffer);
        return doubleBuffer;
    }

    @Override
    public DoubleBuffer get3x3(int n, DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.put3x3(this, n, doubleBuffer);
        return doubleBuffer;
    }

    @Override
    public ByteBuffer get3x3(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put3x3(this, 0, byteBuffer);
        return byteBuffer;
    }

    @Override
    public ByteBuffer get3x3(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put3x3(this, n, byteBuffer);
        return byteBuffer;
    }

    @Override
    public DoubleBuffer get4x4(DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.put4x4(this, 0, doubleBuffer);
        return doubleBuffer;
    }

    @Override
    public DoubleBuffer get4x4(int n, DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.put4x4(this, n, doubleBuffer);
        return doubleBuffer;
    }

    @Override
    public ByteBuffer get4x4(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put4x4(this, 0, byteBuffer);
        return byteBuffer;
    }

    @Override
    public ByteBuffer get4x4(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put4x4(this, n, byteBuffer);
        return byteBuffer;
    }

    @Override
    public Matrix3x2dc getToAddress(long l) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil.MemUtilUnsafe.put(this, l);
        return this;
    }

    @Override
    public double[] get(double[] dArray, int n) {
        MemUtil.INSTANCE.copy(this, dArray, n);
        return dArray;
    }

    @Override
    public double[] get(double[] dArray) {
        return this.get(dArray, 0);
    }

    @Override
    public double[] get3x3(double[] dArray, int n) {
        MemUtil.INSTANCE.copy3x3(this, dArray, n);
        return dArray;
    }

    @Override
    public double[] get3x3(double[] dArray) {
        return this.get3x3(dArray, 0);
    }

    @Override
    public double[] get4x4(double[] dArray, int n) {
        MemUtil.INSTANCE.copy4x4(this, dArray, n);
        return dArray;
    }

    @Override
    public double[] get4x4(double[] dArray) {
        return this.get4x4(dArray, 0);
    }

    public Matrix3x2d set(DoubleBuffer doubleBuffer) {
        int n = doubleBuffer.position();
        MemUtil.INSTANCE.get(this, n, doubleBuffer);
        return this;
    }

    public Matrix3x2d set(ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        MemUtil.INSTANCE.get(this, n, byteBuffer);
        return this;
    }

    public Matrix3x2d setFromAddress(long l) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil.MemUtilUnsafe.get(this, l);
        return this;
    }

    public Matrix3x2d zero() {
        MemUtil.INSTANCE.zero(this);
        return this;
    }

    public Matrix3x2d identity() {
        MemUtil.INSTANCE.identity(this);
        return this;
    }

    @Override
    public Matrix3x2d scale(double d, double d2, Matrix3x2d matrix3x2d) {
        matrix3x2d.m00 = this.m00 * d;
        matrix3x2d.m01 = this.m01 * d;
        matrix3x2d.m10 = this.m10 * d2;
        matrix3x2d.m11 = this.m11 * d2;
        matrix3x2d.m20 = this.m20;
        matrix3x2d.m21 = this.m21;
        return matrix3x2d;
    }

    public Matrix3x2d scale(double d, double d2) {
        return this.scale(d, d2, this);
    }

    public Matrix3x2d scale(Vector2dc vector2dc) {
        return this.scale(vector2dc.x(), vector2dc.y(), this);
    }

    @Override
    public Matrix3x2d scale(Vector2dc vector2dc, Matrix3x2d matrix3x2d) {
        return this.scale(vector2dc.x(), vector2dc.y(), matrix3x2d);
    }

    public Matrix3x2d scale(Vector2fc vector2fc) {
        return this.scale(vector2fc.x(), vector2fc.y(), this);
    }

    @Override
    public Matrix3x2d scale(Vector2fc vector2fc, Matrix3x2d matrix3x2d) {
        return this.scale(vector2fc.x(), vector2fc.y(), matrix3x2d);
    }

    @Override
    public Matrix3x2d scale(double d, Matrix3x2d matrix3x2d) {
        return this.scale(d, d, matrix3x2d);
    }

    public Matrix3x2d scale(double d) {
        return this.scale(d, d);
    }

    @Override
    public Matrix3x2d scaleLocal(double d, double d2, Matrix3x2d matrix3x2d) {
        matrix3x2d.m00 = d * this.m00;
        matrix3x2d.m01 = d2 * this.m01;
        matrix3x2d.m10 = d * this.m10;
        matrix3x2d.m11 = d2 * this.m11;
        matrix3x2d.m20 = d * this.m20;
        matrix3x2d.m21 = d2 * this.m21;
        return matrix3x2d;
    }

    public Matrix3x2d scaleLocal(double d, double d2) {
        return this.scaleLocal(d, d2, this);
    }

    @Override
    public Matrix3x2d scaleLocal(double d, Matrix3x2d matrix3x2d) {
        return this.scaleLocal(d, d, matrix3x2d);
    }

    public Matrix3x2d scaleLocal(double d) {
        return this.scaleLocal(d, d, this);
    }

    @Override
    public Matrix3x2d scaleAround(double d, double d2, double d3, double d4, Matrix3x2d matrix3x2d) {
        double d5 = this.m00 * d3 + this.m10 * d4 + this.m20;
        double d6 = this.m01 * d3 + this.m11 * d4 + this.m21;
        matrix3x2d.m00 = this.m00 * d;
        matrix3x2d.m01 = this.m01 * d;
        matrix3x2d.m10 = this.m10 * d2;
        matrix3x2d.m11 = this.m11 * d2;
        matrix3x2d.m20 = matrix3x2d.m00 * -d3 + matrix3x2d.m10 * -d4 + d5;
        matrix3x2d.m21 = matrix3x2d.m01 * -d3 + matrix3x2d.m11 * -d4 + d6;
        return matrix3x2d;
    }

    public Matrix3x2d scaleAround(double d, double d2, double d3, double d4) {
        return this.scaleAround(d, d2, d3, d4, this);
    }

    @Override
    public Matrix3x2d scaleAround(double d, double d2, double d3, Matrix3x2d matrix3x2d) {
        return this.scaleAround(d, d, d2, d3, this);
    }

    public Matrix3x2d scaleAround(double d, double d2, double d3) {
        return this.scaleAround(d, d, d2, d3, this);
    }

    @Override
    public Matrix3x2d scaleAroundLocal(double d, double d2, double d3, double d4, Matrix3x2d matrix3x2d) {
        matrix3x2d.m00 = d * this.m00;
        matrix3x2d.m01 = d2 * this.m01;
        matrix3x2d.m10 = d * this.m10;
        matrix3x2d.m11 = d2 * this.m11;
        matrix3x2d.m20 = d * this.m20 - d * d3 + d3;
        matrix3x2d.m21 = d2 * this.m21 - d2 * d4 + d4;
        return matrix3x2d;
    }

    @Override
    public Matrix3x2d scaleAroundLocal(double d, double d2, double d3, Matrix3x2d matrix3x2d) {
        return this.scaleAroundLocal(d, d, d2, d3, matrix3x2d);
    }

    public Matrix3x2d scaleAroundLocal(double d, double d2, double d3, double d4, double d5, double d6) {
        return this.scaleAroundLocal(d, d2, d4, d5, this);
    }

    public Matrix3x2d scaleAroundLocal(double d, double d2, double d3) {
        return this.scaleAroundLocal(d, d, d2, d3, this);
    }

    public Matrix3x2d scaling(double d) {
        return this.scaling(d, d);
    }

    public Matrix3x2d scaling(double d, double d2) {
        this.m00 = d;
        this.m01 = 0.0;
        this.m10 = 0.0;
        this.m11 = d2;
        this.m20 = 0.0;
        this.m21 = 0.0;
        return this;
    }

    public Matrix3x2d rotation(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        this.m00 = d2;
        this.m10 = -d3;
        this.m20 = 0.0;
        this.m01 = d3;
        this.m11 = d2;
        this.m21 = 0.0;
        return this;
    }

    @Override
    public Vector3d transform(Vector3d vector3d) {
        return vector3d.mul(this);
    }

    @Override
    public Vector3d transform(Vector3dc vector3dc, Vector3d vector3d) {
        return vector3dc.mul(this, vector3d);
    }

    @Override
    public Vector3d transform(double d, double d2, double d3, Vector3d vector3d) {
        return vector3d.set(this.m00 * d + this.m10 * d2 + this.m20 * d3, this.m01 * d + this.m11 * d2 + this.m21 * d3, d3);
    }

    @Override
    public Vector2d transformPosition(Vector2d vector2d) {
        vector2d.set(this.m00 * vector2d.x + this.m10 * vector2d.y + this.m20, this.m01 * vector2d.x + this.m11 * vector2d.y + this.m21);
        return vector2d;
    }

    @Override
    public Vector2d transformPosition(Vector2dc vector2dc, Vector2d vector2d) {
        vector2d.set(this.m00 * vector2dc.x() + this.m10 * vector2dc.y() + this.m20, this.m01 * vector2dc.x() + this.m11 * vector2dc.y() + this.m21);
        return vector2d;
    }

    @Override
    public Vector2d transformPosition(double d, double d2, Vector2d vector2d) {
        return vector2d.set(this.m00 * d + this.m10 * d2 + this.m20, this.m01 * d + this.m11 * d2 + this.m21);
    }

    @Override
    public Vector2d transformDirection(Vector2d vector2d) {
        vector2d.set(this.m00 * vector2d.x + this.m10 * vector2d.y, this.m01 * vector2d.x + this.m11 * vector2d.y);
        return vector2d;
    }

    @Override
    public Vector2d transformDirection(Vector2dc vector2dc, Vector2d vector2d) {
        vector2d.set(this.m00 * vector2dc.x() + this.m10 * vector2dc.y(), this.m01 * vector2dc.x() + this.m11 * vector2dc.y());
        return vector2d;
    }

    @Override
    public Vector2d transformDirection(double d, double d2, Vector2d vector2d) {
        return vector2d.set(this.m00 * d + this.m10 * d2, this.m01 * d + this.m11 * d2);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeDouble(this.m00);
        objectOutput.writeDouble(this.m01);
        objectOutput.writeDouble(this.m10);
        objectOutput.writeDouble(this.m11);
        objectOutput.writeDouble(this.m20);
        objectOutput.writeDouble(this.m21);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        this.m00 = objectInput.readDouble();
        this.m01 = objectInput.readDouble();
        this.m10 = objectInput.readDouble();
        this.m11 = objectInput.readDouble();
        this.m20 = objectInput.readDouble();
        this.m21 = objectInput.readDouble();
    }

    public Matrix3x2d rotate(double d) {
        return this.rotate(d, this);
    }

    @Override
    public Matrix3x2d rotate(double d, Matrix3x2d matrix3x2d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = d2;
        double d5 = d3;
        double d6 = -d3;
        double d7 = d2;
        double d8 = this.m00 * d4 + this.m10 * d5;
        double d9 = this.m01 * d4 + this.m11 * d5;
        matrix3x2d.m10 = this.m00 * d6 + this.m10 * d7;
        matrix3x2d.m11 = this.m01 * d6 + this.m11 * d7;
        matrix3x2d.m00 = d8;
        matrix3x2d.m01 = d9;
        matrix3x2d.m20 = this.m20;
        matrix3x2d.m21 = this.m21;
        return matrix3x2d;
    }

    @Override
    public Matrix3x2d rotateLocal(double d, Matrix3x2d matrix3x2d) {
        double d2 = Math.sin(d);
        double d3 = Math.cosFromSin(d2, d);
        double d4 = d3 * this.m00 - d2 * this.m01;
        double d5 = d2 * this.m00 + d3 * this.m01;
        double d6 = d3 * this.m10 - d2 * this.m11;
        double d7 = d2 * this.m10 + d3 * this.m11;
        double d8 = d3 * this.m20 - d2 * this.m21;
        double d9 = d2 * this.m20 + d3 * this.m21;
        matrix3x2d.m00 = d4;
        matrix3x2d.m01 = d5;
        matrix3x2d.m10 = d6;
        matrix3x2d.m11 = d7;
        matrix3x2d.m20 = d8;
        matrix3x2d.m21 = d9;
        return matrix3x2d;
    }

    public Matrix3x2d rotateLocal(double d) {
        return this.rotateLocal(d, this);
    }

    public Matrix3x2d rotateAbout(double d, double d2, double d3) {
        return this.rotateAbout(d, d2, d3, this);
    }

    @Override
    public Matrix3x2d rotateAbout(double d, double d2, double d3, Matrix3x2d matrix3x2d) {
        double d4 = this.m00 * d2 + this.m10 * d3 + this.m20;
        double d5 = this.m01 * d2 + this.m11 * d3 + this.m21;
        double d6 = Math.cos(d);
        double d7 = Math.sin(d);
        double d8 = this.m00 * d6 + this.m10 * d7;
        double d9 = this.m01 * d6 + this.m11 * d7;
        matrix3x2d.m10 = this.m00 * -d7 + this.m10 * d6;
        matrix3x2d.m11 = this.m01 * -d7 + this.m11 * d6;
        matrix3x2d.m00 = d8;
        matrix3x2d.m01 = d9;
        matrix3x2d.m20 = matrix3x2d.m00 * -d2 + matrix3x2d.m10 * -d3 + d4;
        matrix3x2d.m21 = matrix3x2d.m01 * -d2 + matrix3x2d.m11 * -d3 + d5;
        return matrix3x2d;
    }

    @Override
    public Matrix3x2d rotateTo(Vector2dc vector2dc, Vector2dc vector2dc2, Matrix3x2d matrix3x2d) {
        double d = vector2dc.x() * vector2dc2.x() + vector2dc.y() * vector2dc2.y();
        double d2 = vector2dc.x() * vector2dc2.y() - vector2dc.y() * vector2dc2.x();
        double d3 = d;
        double d4 = d2;
        double d5 = -d2;
        double d6 = d;
        double d7 = this.m00 * d3 + this.m10 * d4;
        double d8 = this.m01 * d3 + this.m11 * d4;
        matrix3x2d.m10 = this.m00 * d5 + this.m10 * d6;
        matrix3x2d.m11 = this.m01 * d5 + this.m11 * d6;
        matrix3x2d.m00 = d7;
        matrix3x2d.m01 = d8;
        matrix3x2d.m20 = this.m20;
        matrix3x2d.m21 = this.m21;
        return matrix3x2d;
    }

    public Matrix3x2d rotateTo(Vector2dc vector2dc, Vector2dc vector2dc2) {
        return this.rotateTo(vector2dc, vector2dc2, this);
    }

    @Override
    public Matrix3x2d view(double d, double d2, double d3, double d4, Matrix3x2d matrix3x2d) {
        double d5 = 2.0 / (d2 - d);
        double d6 = 2.0 / (d4 - d3);
        double d7 = (d + d2) / (d - d2);
        double d8 = (d3 + d4) / (d3 - d4);
        matrix3x2d.m20 = this.m00 * d7 + this.m10 * d8 + this.m20;
        matrix3x2d.m21 = this.m01 * d7 + this.m11 * d8 + this.m21;
        matrix3x2d.m00 = this.m00 * d5;
        matrix3x2d.m01 = this.m01 * d5;
        matrix3x2d.m10 = this.m10 * d6;
        matrix3x2d.m11 = this.m11 * d6;
        return matrix3x2d;
    }

    public Matrix3x2d view(double d, double d2, double d3, double d4) {
        return this.view(d, d2, d3, d4, this);
    }

    public Matrix3x2d setView(double d, double d2, double d3, double d4) {
        this.m00 = 2.0 / (d2 - d);
        this.m01 = 0.0;
        this.m10 = 0.0;
        this.m11 = 2.0 / (d4 - d3);
        this.m20 = (d + d2) / (d - d2);
        this.m21 = (d3 + d4) / (d3 - d4);
        return this;
    }

    @Override
    public Vector2d origin(Vector2d vector2d) {
        double d = 1.0 / (this.m00 * this.m11 - this.m01 * this.m10);
        vector2d.x = (this.m10 * this.m21 - this.m20 * this.m11) * d;
        vector2d.y = (this.m20 * this.m01 - this.m00 * this.m21) * d;
        return vector2d;
    }

    @Override
    public double[] viewArea(double[] dArray) {
        double d = 1.0 / (this.m00 * this.m11 - this.m01 * this.m10);
        double d2 = this.m11 * d;
        double d3 = -this.m01 * d;
        double d4 = -this.m10 * d;
        double d5 = this.m00 * d;
        double d6 = (this.m10 * this.m21 - this.m20 * this.m11) * d;
        double d7 = (this.m20 * this.m01 - this.m00 * this.m21) * d;
        double d8 = -d2 - d4;
        double d9 = -d3 - d5;
        double d10 = d2 - d4;
        double d11 = d3 - d5;
        double d12 = -d2 + d4;
        double d13 = -d3 + d5;
        double d14 = d2 + d4;
        double d15 = d3 + d5;
        double d16 = d8;
        d16 = d16 < d12 ? d16 : d12;
        d16 = d16 < d10 ? d16 : d10;
        d16 = d16 < d14 ? d16 : d14;
        double d17 = d9;
        d17 = d17 < d13 ? d17 : d13;
        d17 = d17 < d11 ? d17 : d11;
        d17 = d17 < d15 ? d17 : d15;
        double d18 = d8;
        d18 = d18 > d12 ? d18 : d12;
        d18 = d18 > d10 ? d18 : d10;
        d18 = d18 > d14 ? d18 : d14;
        double d19 = d9;
        d19 = d19 > d13 ? d19 : d13;
        d19 = d19 > d11 ? d19 : d11;
        d19 = d19 > d15 ? d19 : d15;
        dArray[0] = d16 + d6;
        dArray[1] = d17 + d7;
        dArray[2] = d18 + d6;
        dArray[3] = d19 + d7;
        return dArray;
    }

    @Override
    public Vector2d positiveX(Vector2d vector2d) {
        double d = this.m00 * this.m11 - this.m01 * this.m10;
        d = 1.0 / d;
        vector2d.x = this.m11 * d;
        vector2d.y = -this.m01 * d;
        return vector2d.normalize(vector2d);
    }

    @Override
    public Vector2d normalizedPositiveX(Vector2d vector2d) {
        vector2d.x = this.m11;
        vector2d.y = -this.m01;
        return vector2d;
    }

    @Override
    public Vector2d positiveY(Vector2d vector2d) {
        double d = this.m00 * this.m11 - this.m01 * this.m10;
        d = 1.0 / d;
        vector2d.x = -this.m10 * d;
        vector2d.y = this.m00 * d;
        return vector2d.normalize(vector2d);
    }

    @Override
    public Vector2d normalizedPositiveY(Vector2d vector2d) {
        vector2d.x = -this.m10;
        vector2d.y = this.m00;
        return vector2d;
    }

    @Override
    public Vector2d unproject(double d, double d2, int[] nArray, Vector2d vector2d) {
        double d3 = 1.0 / (this.m00 * this.m11 - this.m01 * this.m10);
        double d4 = this.m11 * d3;
        double d5 = -this.m01 * d3;
        double d6 = -this.m10 * d3;
        double d7 = this.m00 * d3;
        double d8 = (this.m10 * this.m21 - this.m20 * this.m11) * d3;
        double d9 = (this.m20 * this.m01 - this.m00 * this.m21) * d3;
        double d10 = (d - (double)nArray[0]) / (double)nArray[2] * 2.0 - 1.0;
        double d11 = (d2 - (double)nArray[1]) / (double)nArray[3] * 2.0 - 1.0;
        vector2d.x = d4 * d10 + d6 * d11 + d8;
        vector2d.y = d5 * d10 + d7 * d11 + d9;
        return vector2d;
    }

    @Override
    public Vector2d unprojectInv(double d, double d2, int[] nArray, Vector2d vector2d) {
        double d3 = (d - (double)nArray[0]) / (double)nArray[2] * 2.0 - 1.0;
        double d4 = (d2 - (double)nArray[1]) / (double)nArray[3] * 2.0 - 1.0;
        vector2d.x = this.m00 * d3 + this.m10 * d4 + this.m20;
        vector2d.y = this.m01 * d3 + this.m11 * d4 + this.m21;
        return vector2d;
    }

    public Matrix3x2d span(Vector2d vector2d, Vector2d vector2d2, Vector2d vector2d3) {
        double d = 1.0 / (this.m00 * this.m11 - this.m01 * this.m10);
        double d2 = this.m11 * d;
        double d3 = -this.m01 * d;
        double d4 = -this.m10 * d;
        double d5 = this.m00 * d;
        vector2d.x = -d2 - d4 + (this.m10 * this.m21 - this.m20 * this.m11) * d;
        vector2d.y = -d3 - d5 + (this.m20 * this.m01 - this.m00 * this.m21) * d;
        vector2d2.x = 2.0 * d2;
        vector2d2.y = 2.0 * d3;
        vector2d3.x = 2.0 * d4;
        vector2d3.y = 2.0 * d5;
        return this;
    }

    @Override
    public boolean testPoint(double d, double d2) {
        double d3 = this.m00;
        double d4 = this.m10;
        double d5 = 1.0 + this.m20;
        double d6 = -this.m00;
        double d7 = -this.m10;
        double d8 = 1.0 - this.m20;
        double d9 = this.m01;
        double d10 = this.m11;
        double d11 = 1.0 + this.m21;
        double d12 = -this.m01;
        double d13 = -this.m11;
        double d14 = 1.0 - this.m21;
        return d3 * d + d4 * d2 + d5 >= 0.0 && d6 * d + d7 * d2 + d8 >= 0.0 && d9 * d + d10 * d2 + d11 >= 0.0 && d12 * d + d13 * d2 + d14 >= 0.0;
    }

    @Override
    public boolean testCircle(double d, double d2, double d3) {
        double d4 = this.m00;
        double d5 = this.m10;
        double d6 = 1.0 + this.m20;
        double d7 = Math.invsqrt(d4 * d4 + d5 * d5);
        d4 *= d7;
        d5 *= d7;
        d6 *= d7;
        double d8 = -this.m00;
        double d9 = -this.m10;
        double d10 = 1.0 - this.m20;
        d7 = Math.invsqrt(d8 * d8 + d9 * d9);
        d8 *= d7;
        d9 *= d7;
        d10 *= d7;
        double d11 = this.m01;
        double d12 = this.m11;
        double d13 = 1.0 + this.m21;
        d7 = Math.invsqrt(d11 * d11 + d12 * d12);
        d11 *= d7;
        d12 *= d7;
        d13 *= d7;
        double d14 = -this.m01;
        double d15 = -this.m11;
        double d16 = 1.0 - this.m21;
        d7 = Math.invsqrt(d14 * d14 + d15 * d15);
        return d4 * d + d5 * d2 + d6 >= -d3 && d8 * d + d9 * d2 + d10 >= -d3 && d11 * d + d12 * d2 + d13 >= -d3 && (d14 *= d7) * d + (d15 *= d7) * d2 + (d16 *= d7) >= -d3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean testAar(double d, double d2, double d3, double d4) {
        double d5 = this.m00;
        double d6 = this.m10;
        double d7 = 1.0 + this.m20;
        double d8 = -this.m00;
        double d9 = -this.m10;
        double d10 = 1.0 - this.m20;
        double d11 = this.m01;
        double d12 = this.m11;
        double d13 = 1.0 + this.m21;
        double d14 = -this.m01;
        double d15 = -this.m11;
        double d16 = 1.0 - this.m21;
        double d17 = d5 * (d5 < 0.0 ? d : d3);
        double d18 = d6 < 0.0 ? d2 : d4;
        if (!(d17 + d6 * d18 >= -d7)) return false;
        double d19 = d8 * (d8 < 0.0 ? d : d3);
        double d20 = d9 < 0.0 ? d2 : d4;
        if (!(d19 + d9 * d20 >= -d10)) return false;
        double d21 = d11 * (d11 < 0.0 ? d : d3);
        double d22 = d12 < 0.0 ? d2 : d4;
        if (!(d21 + d12 * d22 >= -d13)) return false;
        double d23 = d14 * (d14 < 0.0 ? d : d3);
        double d24 = d15 < 0.0 ? d2 : d4;
        if (!(d23 + d15 * d24 >= -d16)) return false;
        return true;
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.m00);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.m01);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.m10);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.m11);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.m20);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.m21);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Matrix3x2d matrix3x2d = (Matrix3x2d)object;
        if (Double.doubleToLongBits(this.m00) != Double.doubleToLongBits(matrix3x2d.m00)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m01) != Double.doubleToLongBits(matrix3x2d.m01)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m10) != Double.doubleToLongBits(matrix3x2d.m10)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m11) != Double.doubleToLongBits(matrix3x2d.m11)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m20) != Double.doubleToLongBits(matrix3x2d.m20)) {
            return false;
        }
        return Double.doubleToLongBits(this.m21) == Double.doubleToLongBits(matrix3x2d.m21);
    }

    @Override
    public boolean equals(Matrix3x2dc matrix3x2dc, double d) {
        if (this == matrix3x2dc) {
            return true;
        }
        if (matrix3x2dc == null) {
            return false;
        }
        if (!(matrix3x2dc instanceof Matrix3x2d)) {
            return false;
        }
        if (!Runtime.equals(this.m00, matrix3x2dc.m00(), d)) {
            return false;
        }
        if (!Runtime.equals(this.m01, matrix3x2dc.m01(), d)) {
            return false;
        }
        if (!Runtime.equals(this.m10, matrix3x2dc.m10(), d)) {
            return false;
        }
        if (!Runtime.equals(this.m11, matrix3x2dc.m11(), d)) {
            return false;
        }
        if (!Runtime.equals(this.m20, matrix3x2dc.m20(), d)) {
            return false;
        }
        return Runtime.equals(this.m21, matrix3x2dc.m21(), d);
    }

    @Override
    public boolean isFinite() {
        return Math.isFinite(this.m00) && Math.isFinite(this.m01) && Math.isFinite(this.m10) && Math.isFinite(this.m11) && Math.isFinite(this.m20) && Math.isFinite(this.m21);
    }
}

