/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.joml.AxisAngle4d;
import org.joml.AxisAngle4f;
import org.joml.Math;
import org.joml.Matrix2fc;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Matrix4x3fc;
import org.joml.MemUtil;
import org.joml.Options;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Runtime;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Matrix3f
implements Externalizable,
Matrix3fc {
    private static final long serialVersionUID = 1L;
    public float m00;
    public float m01;
    public float m02;
    public float m10;
    public float m11;
    public float m12;
    public float m20;
    public float m21;
    public float m22;

    public Matrix3f() {
        this.m00 = 1.0f;
        this.m11 = 1.0f;
        this.m22 = 1.0f;
    }

    public Matrix3f(Matrix2fc matrix2fc) {
        this.set(matrix2fc);
    }

    public Matrix3f(Matrix3fc matrix3fc) {
        this.set(matrix3fc);
    }

    public Matrix3f(Matrix4fc matrix4fc) {
        this.set(matrix4fc);
    }

    public Matrix3f(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.m00 = f;
        this.m01 = f2;
        this.m02 = f3;
        this.m10 = f4;
        this.m11 = f5;
        this.m12 = f6;
        this.m20 = f7;
        this.m21 = f8;
        this.m22 = f9;
    }

    public Matrix3f(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.get(this, floatBuffer.position(), floatBuffer);
    }

    public Matrix3f(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3fc vector3fc3) {
        this.set(vector3fc, vector3fc2, vector3fc3);
    }

    @Override
    public float m00() {
        return this.m00;
    }

    @Override
    public float m01() {
        return this.m01;
    }

    @Override
    public float m02() {
        return this.m02;
    }

    @Override
    public float m10() {
        return this.m10;
    }

    @Override
    public float m11() {
        return this.m11;
    }

    @Override
    public float m12() {
        return this.m12;
    }

    @Override
    public float m20() {
        return this.m20;
    }

    @Override
    public float m21() {
        return this.m21;
    }

    @Override
    public float m22() {
        return this.m22;
    }

    public Matrix3f m00(float f) {
        this.m00 = f;
        return this;
    }

    public Matrix3f m01(float f) {
        this.m01 = f;
        return this;
    }

    public Matrix3f m02(float f) {
        this.m02 = f;
        return this;
    }

    public Matrix3f m10(float f) {
        this.m10 = f;
        return this;
    }

    public Matrix3f m11(float f) {
        this.m11 = f;
        return this;
    }

    public Matrix3f m12(float f) {
        this.m12 = f;
        return this;
    }

    public Matrix3f m20(float f) {
        this.m20 = f;
        return this;
    }

    public Matrix3f m21(float f) {
        this.m21 = f;
        return this;
    }

    public Matrix3f m22(float f) {
        this.m22 = f;
        return this;
    }

    Matrix3f _m00(float f) {
        this.m00 = f;
        return this;
    }

    Matrix3f _m01(float f) {
        this.m01 = f;
        return this;
    }

    Matrix3f _m02(float f) {
        this.m02 = f;
        return this;
    }

    Matrix3f _m10(float f) {
        this.m10 = f;
        return this;
    }

    Matrix3f _m11(float f) {
        this.m11 = f;
        return this;
    }

    Matrix3f _m12(float f) {
        this.m12 = f;
        return this;
    }

    Matrix3f _m20(float f) {
        this.m20 = f;
        return this;
    }

    Matrix3f _m21(float f) {
        this.m21 = f;
        return this;
    }

    Matrix3f _m22(float f) {
        this.m22 = f;
        return this;
    }

    public Matrix3f set(Matrix3fc matrix3fc) {
        return this._m00(matrix3fc.m00())._m01(matrix3fc.m01())._m02(matrix3fc.m02())._m10(matrix3fc.m10())._m11(matrix3fc.m11())._m12(matrix3fc.m12())._m20(matrix3fc.m20())._m21(matrix3fc.m21())._m22(matrix3fc.m22());
    }

    public Matrix3f setTransposed(Matrix3fc matrix3fc) {
        float f = matrix3fc.m01();
        float f2 = matrix3fc.m21();
        float f3 = matrix3fc.m02();
        float f4 = matrix3fc.m12();
        return this._m00(matrix3fc.m00())._m01(matrix3fc.m10())._m02(matrix3fc.m20())._m10(f)._m11(matrix3fc.m11())._m12(f2)._m20(f3)._m21(f4)._m22(matrix3fc.m22());
    }

    public Matrix3f set(Matrix4x3fc matrix4x3fc) {
        this.m00 = matrix4x3fc.m00();
        this.m01 = matrix4x3fc.m01();
        this.m02 = matrix4x3fc.m02();
        this.m10 = matrix4x3fc.m10();
        this.m11 = matrix4x3fc.m11();
        this.m12 = matrix4x3fc.m12();
        this.m20 = matrix4x3fc.m20();
        this.m21 = matrix4x3fc.m21();
        this.m22 = matrix4x3fc.m22();
        return this;
    }

    public Matrix3f set(Matrix4fc matrix4fc) {
        this.m00 = matrix4fc.m00();
        this.m01 = matrix4fc.m01();
        this.m02 = matrix4fc.m02();
        this.m10 = matrix4fc.m10();
        this.m11 = matrix4fc.m11();
        this.m12 = matrix4fc.m12();
        this.m20 = matrix4fc.m20();
        this.m21 = matrix4fc.m21();
        this.m22 = matrix4fc.m22();
        return this;
    }

    public Matrix3f set(Matrix2fc matrix2fc) {
        this.m00 = matrix2fc.m00();
        this.m01 = matrix2fc.m01();
        this.m02 = 0.0f;
        this.m10 = matrix2fc.m10();
        this.m11 = matrix2fc.m11();
        this.m12 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 1.0f;
        return this;
    }

    public Matrix3f set(AxisAngle4f axisAngle4f) {
        float f = axisAngle4f.x;
        float f2 = axisAngle4f.y;
        float f3 = axisAngle4f.z;
        float f4 = axisAngle4f.angle;
        float f5 = Math.invsqrt(f * f + f2 * f2 + f3 * f3);
        f *= f5;
        f2 *= f5;
        f3 *= f5;
        float f6 = Math.sin(f4);
        float f7 = Math.cosFromSin(f6, f4);
        float f8 = 1.0f - f7;
        this.m00 = f7 + f * f * f8;
        this.m11 = f7 + f2 * f2 * f8;
        this.m22 = f7 + f3 * f3 * f8;
        float f9 = f * f2 * f8;
        float f10 = f3 * f6;
        this.m10 = f9 - f10;
        this.m01 = f9 + f10;
        f9 = f * f3 * f8;
        f10 = f2 * f6;
        this.m20 = f9 + f10;
        this.m02 = f9 - f10;
        f9 = f2 * f3 * f8;
        f10 = f * f6;
        this.m21 = f9 - f10;
        this.m12 = f9 + f10;
        return this;
    }

    public Matrix3f set(AxisAngle4d axisAngle4d) {
        double d = axisAngle4d.x;
        double d2 = axisAngle4d.y;
        double d3 = axisAngle4d.z;
        double d4 = axisAngle4d.angle;
        double d5 = Math.invsqrt(d * d + d2 * d2 + d3 * d3);
        d *= d5;
        d2 *= d5;
        d3 *= d5;
        double d6 = Math.sin(d4);
        double d7 = Math.cosFromSin(d6, d4);
        double d8 = 1.0 - d7;
        this.m00 = (float)(d7 + d * d * d8);
        this.m11 = (float)(d7 + d2 * d2 * d8);
        this.m22 = (float)(d7 + d3 * d3 * d8);
        double d9 = d * d2 * d8;
        double d10 = d3 * d6;
        this.m10 = (float)(d9 - d10);
        this.m01 = (float)(d9 + d10);
        d9 = d * d3 * d8;
        d10 = d2 * d6;
        this.m20 = (float)(d9 + d10);
        this.m02 = (float)(d9 - d10);
        d9 = d2 * d3 * d8;
        d10 = d * d6;
        this.m21 = (float)(d9 - d10);
        this.m12 = (float)(d9 + d10);
        return this;
    }

    public Matrix3f set(Quaternionfc quaternionfc) {
        return this.rotation(quaternionfc);
    }

    public Matrix3f set(Quaterniondc quaterniondc) {
        double d = quaterniondc.w() * quaterniondc.w();
        double d2 = quaterniondc.x() * quaterniondc.x();
        double d3 = quaterniondc.y() * quaterniondc.y();
        double d4 = quaterniondc.z() * quaterniondc.z();
        double d5 = quaterniondc.z() * quaterniondc.w();
        double d6 = quaterniondc.x() * quaterniondc.y();
        double d7 = quaterniondc.x() * quaterniondc.z();
        double d8 = quaterniondc.y() * quaterniondc.w();
        double d9 = quaterniondc.y() * quaterniondc.z();
        double d10 = quaterniondc.x() * quaterniondc.w();
        this.m00 = (float)(d + d2 - d4 - d3);
        this.m01 = (float)(d6 + d5 + d5 + d6);
        this.m02 = (float)(d7 - d8 + d7 - d8);
        this.m10 = (float)(-d5 + d6 - d5 + d6);
        this.m11 = (float)(d3 - d4 + d - d2);
        this.m12 = (float)(d9 + d9 + d10 + d10);
        this.m20 = (float)(d8 + d7 + d7 + d8);
        this.m21 = (float)(d9 + d9 - d10 - d10);
        this.m22 = (float)(d4 - d3 - d2 + d);
        return this;
    }

    public Matrix3f mul(Matrix3fc matrix3fc) {
        return this.mul(matrix3fc, this);
    }

    @Override
    public Matrix3f mul(Matrix3fc matrix3fc, Matrix3f matrix3f) {
        float f = Math.fma(this.m00, matrix3fc.m00(), Math.fma(this.m10, matrix3fc.m01(), this.m20 * matrix3fc.m02()));
        float f2 = Math.fma(this.m01, matrix3fc.m00(), Math.fma(this.m11, matrix3fc.m01(), this.m21 * matrix3fc.m02()));
        float f3 = Math.fma(this.m02, matrix3fc.m00(), Math.fma(this.m12, matrix3fc.m01(), this.m22 * matrix3fc.m02()));
        float f4 = Math.fma(this.m00, matrix3fc.m10(), Math.fma(this.m10, matrix3fc.m11(), this.m20 * matrix3fc.m12()));
        float f5 = Math.fma(this.m01, matrix3fc.m10(), Math.fma(this.m11, matrix3fc.m11(), this.m21 * matrix3fc.m12()));
        float f6 = Math.fma(this.m02, matrix3fc.m10(), Math.fma(this.m12, matrix3fc.m11(), this.m22 * matrix3fc.m12()));
        float f7 = Math.fma(this.m00, matrix3fc.m20(), Math.fma(this.m10, matrix3fc.m21(), this.m20 * matrix3fc.m22()));
        float f8 = Math.fma(this.m01, matrix3fc.m20(), Math.fma(this.m11, matrix3fc.m21(), this.m21 * matrix3fc.m22()));
        float f9 = Math.fma(this.m02, matrix3fc.m20(), Math.fma(this.m12, matrix3fc.m21(), this.m22 * matrix3fc.m22()));
        matrix3f.m00 = f;
        matrix3f.m01 = f2;
        matrix3f.m02 = f3;
        matrix3f.m10 = f4;
        matrix3f.m11 = f5;
        matrix3f.m12 = f6;
        matrix3f.m20 = f7;
        matrix3f.m21 = f8;
        matrix3f.m22 = f9;
        return matrix3f;
    }

    public Matrix3f mulLocal(Matrix3fc matrix3fc) {
        return this.mulLocal(matrix3fc, this);
    }

    @Override
    public Matrix3f mulLocal(Matrix3fc matrix3fc, Matrix3f matrix3f) {
        float f = matrix3fc.m00() * this.m00 + matrix3fc.m10() * this.m01 + matrix3fc.m20() * this.m02;
        float f2 = matrix3fc.m01() * this.m00 + matrix3fc.m11() * this.m01 + matrix3fc.m21() * this.m02;
        float f3 = matrix3fc.m02() * this.m00 + matrix3fc.m12() * this.m01 + matrix3fc.m22() * this.m02;
        float f4 = matrix3fc.m00() * this.m10 + matrix3fc.m10() * this.m11 + matrix3fc.m20() * this.m12;
        float f5 = matrix3fc.m01() * this.m10 + matrix3fc.m11() * this.m11 + matrix3fc.m21() * this.m12;
        float f6 = matrix3fc.m02() * this.m10 + matrix3fc.m12() * this.m11 + matrix3fc.m22() * this.m12;
        float f7 = matrix3fc.m00() * this.m20 + matrix3fc.m10() * this.m21 + matrix3fc.m20() * this.m22;
        float f8 = matrix3fc.m01() * this.m20 + matrix3fc.m11() * this.m21 + matrix3fc.m21() * this.m22;
        float f9 = matrix3fc.m02() * this.m20 + matrix3fc.m12() * this.m21 + matrix3fc.m22() * this.m22;
        matrix3f.m00 = f;
        matrix3f.m01 = f2;
        matrix3f.m02 = f3;
        matrix3f.m10 = f4;
        matrix3f.m11 = f5;
        matrix3f.m12 = f6;
        matrix3f.m20 = f7;
        matrix3f.m21 = f8;
        matrix3f.m22 = f9;
        return matrix3f;
    }

    public Matrix3f set(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.m00 = f;
        this.m01 = f2;
        this.m02 = f3;
        this.m10 = f4;
        this.m11 = f5;
        this.m12 = f6;
        this.m20 = f7;
        this.m21 = f8;
        this.m22 = f9;
        return this;
    }

    public Matrix3f set(float[] fArray) {
        MemUtil.INSTANCE.copy(fArray, 0, this);
        return this;
    }

    public Matrix3f set(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3fc vector3fc3) {
        this.m00 = vector3fc.x();
        this.m01 = vector3fc.y();
        this.m02 = vector3fc.z();
        this.m10 = vector3fc2.x();
        this.m11 = vector3fc2.y();
        this.m12 = vector3fc2.z();
        this.m20 = vector3fc3.x();
        this.m21 = vector3fc3.y();
        this.m22 = vector3fc3.z();
        return this;
    }

    @Override
    public float determinant() {
        return (this.m00 * this.m11 - this.m01 * this.m10) * this.m22 + (this.m02 * this.m10 - this.m00 * this.m12) * this.m21 + (this.m01 * this.m12 - this.m02 * this.m11) * this.m20;
    }

    public Matrix3f invert() {
        return this.invert(this);
    }

    @Override
    public Matrix3f invert(Matrix3f matrix3f) {
        float f = Math.fma(this.m00, this.m11, -this.m01 * this.m10);
        float f2 = Math.fma(this.m02, this.m10, -this.m00 * this.m12);
        float f3 = Math.fma(this.m01, this.m12, -this.m02 * this.m11);
        float f4 = Math.fma(f, this.m22, Math.fma(f2, this.m21, f3 * this.m20));
        float f5 = 1.0f / f4;
        float f6 = Math.fma(this.m11, this.m22, -this.m21 * this.m12) * f5;
        float f7 = Math.fma(this.m21, this.m02, -this.m01 * this.m22) * f5;
        float f8 = f3 * f5;
        float f9 = Math.fma(this.m20, this.m12, -this.m10 * this.m22) * f5;
        float f10 = Math.fma(this.m00, this.m22, -this.m20 * this.m02) * f5;
        float f11 = f2 * f5;
        float f12 = Math.fma(this.m10, this.m21, -this.m20 * this.m11) * f5;
        float f13 = Math.fma(this.m20, this.m01, -this.m00 * this.m21) * f5;
        float f14 = f * f5;
        matrix3f.m00 = f6;
        matrix3f.m01 = f7;
        matrix3f.m02 = f8;
        matrix3f.m10 = f9;
        matrix3f.m11 = f10;
        matrix3f.m12 = f11;
        matrix3f.m20 = f12;
        matrix3f.m21 = f13;
        matrix3f.m22 = f14;
        return matrix3f;
    }

    public Matrix3f transpose() {
        return this.transpose(this);
    }

    @Override
    public Matrix3f transpose(Matrix3f matrix3f) {
        return matrix3f.set(this.m00, this.m10, this.m20, this.m01, this.m11, this.m21, this.m02, this.m12, this.m22);
    }

    public String toString() {
        DecimalFormat decimalFormat = new DecimalFormat(" 0.000E0;-");
        String string = this.toString(decimalFormat);
        StringBuffer stringBuffer = new StringBuffer();
        int n = Integer.MIN_VALUE;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == 'E') {
                n = i;
            } else {
                if (c == ' ' && n == i - 1) {
                    stringBuffer.append('+');
                    continue;
                }
                if (Character.isDigit(c) && n == i - 1) {
                    stringBuffer.append('+');
                }
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public String toString(NumberFormat numberFormat) {
        return Runtime.format(this.m00, numberFormat) + " " + Runtime.format(this.m10, numberFormat) + " " + Runtime.format(this.m20, numberFormat) + "\n" + Runtime.format(this.m01, numberFormat) + " " + Runtime.format(this.m11, numberFormat) + " " + Runtime.format(this.m21, numberFormat) + "\n" + Runtime.format(this.m02, numberFormat) + " " + Runtime.format(this.m12, numberFormat) + " " + Runtime.format(this.m22, numberFormat) + "\n";
    }

    @Override
    public Matrix3f get(Matrix3f matrix3f) {
        return matrix3f.set(this);
    }

    @Override
    public Matrix4f get(Matrix4f matrix4f) {
        return matrix4f.set(this);
    }

    @Override
    public AxisAngle4f getRotation(AxisAngle4f axisAngle4f) {
        return axisAngle4f.set(this);
    }

    @Override
    public Quaternionf getUnnormalizedRotation(Quaternionf quaternionf) {
        return quaternionf.setFromUnnormalized(this);
    }

    @Override
    public Quaternionf getNormalizedRotation(Quaternionf quaternionf) {
        return quaternionf.setFromNormalized(this);
    }

    @Override
    public Quaterniond getUnnormalizedRotation(Quaterniond quaterniond) {
        return quaterniond.setFromUnnormalized(this);
    }

    @Override
    public Quaterniond getNormalizedRotation(Quaterniond quaterniond) {
        return quaterniond.setFromNormalized(this);
    }

    @Override
    public FloatBuffer get(FloatBuffer floatBuffer) {
        return this.get(floatBuffer.position(), floatBuffer);
    }

    @Override
    public FloatBuffer get(int n, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.put(this, n, floatBuffer);
        return floatBuffer;
    }

    @Override
    public ByteBuffer get(ByteBuffer byteBuffer) {
        return this.get(byteBuffer.position(), byteBuffer);
    }

    @Override
    public ByteBuffer get(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, n, byteBuffer);
        return byteBuffer;
    }

    @Override
    public FloatBuffer get3x4(FloatBuffer floatBuffer) {
        return this.get3x4(floatBuffer.position(), floatBuffer);
    }

    @Override
    public FloatBuffer get3x4(int n, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.put3x4(this, n, floatBuffer);
        return floatBuffer;
    }

    @Override
    public ByteBuffer get3x4(ByteBuffer byteBuffer) {
        return this.get3x4(byteBuffer.position(), byteBuffer);
    }

    @Override
    public ByteBuffer get3x4(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put3x4(this, n, byteBuffer);
        return byteBuffer;
    }

    @Override
    public FloatBuffer getTransposed(FloatBuffer floatBuffer) {
        return this.getTransposed(floatBuffer.position(), floatBuffer);
    }

    @Override
    public FloatBuffer getTransposed(int n, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.putTransposed(this, n, floatBuffer);
        return floatBuffer;
    }

    @Override
    public ByteBuffer getTransposed(ByteBuffer byteBuffer) {
        return this.getTransposed(byteBuffer.position(), byteBuffer);
    }

    @Override
    public ByteBuffer getTransposed(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.putTransposed(this, n, byteBuffer);
        return byteBuffer;
    }

    @Override
    public Matrix3fc getToAddress(long l) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil.MemUtilUnsafe.put(this, l);
        return this;
    }

    @Override
    public float[] get(float[] fArray, int n) {
        MemUtil.INSTANCE.copy(this, fArray, n);
        return fArray;
    }

    @Override
    public float[] get(float[] fArray) {
        return this.get(fArray, 0);
    }

    public Matrix3f set(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.get(this, floatBuffer.position(), floatBuffer);
        return this;
    }

    public Matrix3f set(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
        return this;
    }

    public Matrix3f setFromAddress(long l) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil.MemUtilUnsafe.get(this, l);
        return this;
    }

    public Matrix3f zero() {
        MemUtil.INSTANCE.zero(this);
        return this;
    }

    public Matrix3f identity() {
        MemUtil.INSTANCE.identity(this);
        return this;
    }

    @Override
    public Matrix3f scale(Vector3fc vector3fc, Matrix3f matrix3f) {
        return this.scale(vector3fc.x(), vector3fc.y(), vector3fc.z(), matrix3f);
    }

    public Matrix3f scale(Vector3fc vector3fc) {
        return this.scale(vector3fc.x(), vector3fc.y(), vector3fc.z(), this);
    }

    @Override
    public Matrix3f scale(float f, float f2, float f3, Matrix3f matrix3f) {
        matrix3f.m00 = this.m00 * f;
        matrix3f.m01 = this.m01 * f;
        matrix3f.m02 = this.m02 * f;
        matrix3f.m10 = this.m10 * f2;
        matrix3f.m11 = this.m11 * f2;
        matrix3f.m12 = this.m12 * f2;
        matrix3f.m20 = this.m20 * f3;
        matrix3f.m21 = this.m21 * f3;
        matrix3f.m22 = this.m22 * f3;
        return matrix3f;
    }

    public Matrix3f scale(float f, float f2, float f3) {
        return this.scale(f, f2, f3, this);
    }

    @Override
    public Matrix3f scale(float f, Matrix3f matrix3f) {
        return this.scale(f, f, f, matrix3f);
    }

    public Matrix3f scale(float f) {
        return this.scale(f, f, f);
    }

    @Override
    public Matrix3f scaleLocal(float f, float f2, float f3, Matrix3f matrix3f) {
        float f4 = f * this.m00;
        float f5 = f2 * this.m01;
        float f6 = f3 * this.m02;
        float f7 = f * this.m10;
        float f8 = f2 * this.m11;
        float f9 = f3 * this.m12;
        float f10 = f * this.m20;
        float f11 = f2 * this.m21;
        float f12 = f3 * this.m22;
        matrix3f.m00 = f4;
        matrix3f.m01 = f5;
        matrix3f.m02 = f6;
        matrix3f.m10 = f7;
        matrix3f.m11 = f8;
        matrix3f.m12 = f9;
        matrix3f.m20 = f10;
        matrix3f.m21 = f11;
        matrix3f.m22 = f12;
        return matrix3f;
    }

    public Matrix3f scaleLocal(float f, float f2, float f3) {
        return this.scaleLocal(f, f2, f3, this);
    }

    public Matrix3f scaling(float f) {
        MemUtil.INSTANCE.zero(this);
        this.m00 = f;
        this.m11 = f;
        this.m22 = f;
        return this;
    }

    public Matrix3f scaling(float f, float f2, float f3) {
        MemUtil.INSTANCE.zero(this);
        this.m00 = f;
        this.m11 = f2;
        this.m22 = f3;
        return this;
    }

    public Matrix3f scaling(Vector3fc vector3fc) {
        return this.scaling(vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public Matrix3f rotation(float f, Vector3fc vector3fc) {
        return this.rotation(f, vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public Matrix3f rotation(AxisAngle4f axisAngle4f) {
        return this.rotation(axisAngle4f.angle, axisAngle4f.x, axisAngle4f.y, axisAngle4f.z);
    }

    public Matrix3f rotation(float f, float f2, float f3, float f4) {
        float f5 = Math.sin(f);
        float f6 = Math.cosFromSin(f5, f);
        float f7 = 1.0f - f6;
        float f8 = f2 * f3;
        float f9 = f2 * f4;
        float f10 = f3 * f4;
        this.m00 = f6 + f2 * f2 * f7;
        this.m10 = f8 * f7 - f4 * f5;
        this.m20 = f9 * f7 + f3 * f5;
        this.m01 = f8 * f7 + f4 * f5;
        this.m11 = f6 + f3 * f3 * f7;
        this.m21 = f10 * f7 - f2 * f5;
        this.m02 = f9 * f7 - f3 * f5;
        this.m12 = f10 * f7 + f2 * f5;
        this.m22 = f6 + f4 * f4 * f7;
        return this;
    }

    public Matrix3f rotationX(float f) {
        float f2 = Math.sin(f);
        float f3 = Math.cosFromSin(f2, f);
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = f3;
        this.m12 = f2;
        this.m20 = 0.0f;
        this.m21 = -f2;
        this.m22 = f3;
        return this;
    }

    public Matrix3f rotationY(float f) {
        float f2;
        float f3 = Math.sin(f);
        this.m00 = f2 = Math.cosFromSin(f3, f);
        this.m01 = 0.0f;
        this.m02 = -f3;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        this.m12 = 0.0f;
        this.m20 = f3;
        this.m21 = 0.0f;
        this.m22 = f2;
        return this;
    }

    public Matrix3f rotationZ(float f) {
        float f2;
        float f3 = Math.sin(f);
        this.m00 = f2 = Math.cosFromSin(f3, f);
        this.m01 = f3;
        this.m02 = 0.0f;
        this.m10 = -f3;
        this.m11 = f2;
        this.m12 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 1.0f;
        return this;
    }

    public Matrix3f rotationXYZ(float f, float f2, float f3) {
        float f4 = Math.sin(f);
        float f5 = Math.cosFromSin(f4, f);
        float f6 = Math.sin(f2);
        float f7 = Math.cosFromSin(f6, f2);
        float f8 = Math.sin(f3);
        float f9 = Math.cosFromSin(f8, f3);
        float f10 = -f4;
        float f11 = -f6;
        float f12 = -f8;
        float f13 = f5;
        float f14 = f4;
        float f15 = f10;
        float f16 = f5;
        float f17 = f7;
        float f18 = f15 * f11;
        float f19 = f16 * f11;
        this.m20 = f6;
        this.m21 = f15 * f7;
        this.m22 = f16 * f7;
        this.m00 = f17 * f9;
        this.m01 = f18 * f9 + f13 * f8;
        this.m02 = f19 * f9 + f14 * f8;
        this.m10 = f17 * f12;
        this.m11 = f18 * f12 + f13 * f9;
        this.m12 = f19 * f12 + f14 * f9;
        return this;
    }

    public Matrix3f rotationZYX(float f, float f2, float f3) {
        float f4 = Math.sin(f3);
        float f5 = Math.cosFromSin(f4, f3);
        float f6 = Math.sin(f2);
        float f7 = Math.cosFromSin(f6, f2);
        float f8 = Math.sin(f);
        float f9 = Math.cosFromSin(f8, f);
        float f10 = -f8;
        float f11 = -f6;
        float f12 = -f4;
        float f13 = f9;
        float f14 = f8;
        float f15 = f10;
        float f16 = f9;
        float f17 = f13 * f6;
        float f18 = f14 * f6;
        float f19 = f7;
        this.m00 = f13 * f7;
        this.m01 = f14 * f7;
        this.m02 = f11;
        this.m10 = f15 * f5 + f17 * f4;
        this.m11 = f16 * f5 + f18 * f4;
        this.m12 = f19 * f4;
        this.m20 = f15 * f12 + f17 * f5;
        this.m21 = f16 * f12 + f18 * f5;
        this.m22 = f19 * f5;
        return this;
    }

    public Matrix3f rotationYXZ(float f, float f2, float f3) {
        float f4 = Math.sin(f2);
        float f5 = Math.cosFromSin(f4, f2);
        float f6 = Math.sin(f);
        float f7 = Math.cosFromSin(f6, f);
        float f8 = Math.sin(f3);
        float f9 = Math.cosFromSin(f8, f3);
        float f10 = -f6;
        float f11 = -f4;
        float f12 = -f8;
        float f13 = f7;
        float f14 = f10;
        float f15 = f6;
        float f16 = f7;
        float f17 = f15 * f4;
        float f18 = f5;
        float f19 = f16 * f4;
        this.m20 = f15 * f5;
        this.m21 = f11;
        this.m22 = f16 * f5;
        this.m00 = f13 * f9 + f17 * f8;
        this.m01 = f18 * f8;
        this.m02 = f14 * f9 + f19 * f8;
        this.m10 = f13 * f12 + f17 * f9;
        this.m11 = f18 * f9;
        this.m12 = f14 * f12 + f19 * f9;
        return this;
    }

    public Matrix3f rotation(Quaternionfc quaternionfc) {
        float f = quaternionfc.w() * quaternionfc.w();
        float f2 = quaternionfc.x() * quaternionfc.x();
        float f3 = quaternionfc.y() * quaternionfc.y();
        float f4 = quaternionfc.z() * quaternionfc.z();
        float f5 = quaternionfc.z() * quaternionfc.w();
        float f6 = f5 + f5;
        float f7 = quaternionfc.x() * quaternionfc.y();
        float f8 = f7 + f7;
        float f9 = quaternionfc.x() * quaternionfc.z();
        float f10 = f9 + f9;
        float f11 = quaternionfc.y() * quaternionfc.w();
        float f12 = f11 + f11;
        float f13 = quaternionfc.y() * quaternionfc.z();
        float f14 = f13 + f13;
        float f15 = quaternionfc.x() * quaternionfc.w();
        float f16 = f15 + f15;
        this.m00 = f + f2 - f4 - f3;
        this.m01 = f8 + f6;
        this.m02 = f10 - f12;
        this.m10 = -f6 + f8;
        this.m11 = f3 - f4 + f - f2;
        this.m12 = f14 + f16;
        this.m20 = f12 + f10;
        this.m21 = f14 - f16;
        this.m22 = f4 - f3 - f2 + f;
        return this;
    }

    @Override
    public Vector3f transform(Vector3f vector3f) {
        return vector3f.mul(this);
    }

    @Override
    public Vector3f transform(Vector3fc vector3fc, Vector3f vector3f) {
        return vector3fc.mul(this, vector3f);
    }

    @Override
    public Vector3f transform(float f, float f2, float f3, Vector3f vector3f) {
        return vector3f.set(Math.fma(this.m00, f, Math.fma(this.m10, f2, this.m20 * f3)), Math.fma(this.m01, f, Math.fma(this.m11, f2, this.m21 * f3)), Math.fma(this.m02, f, Math.fma(this.m12, f2, this.m22 * f3)));
    }

    @Override
    public Vector3f transformTranspose(Vector3f vector3f) {
        return vector3f.mulTranspose(this);
    }

    @Override
    public Vector3f transformTranspose(Vector3fc vector3fc, Vector3f vector3f) {
        return vector3fc.mulTranspose(this, vector3f);
    }

    @Override
    public Vector3f transformTranspose(float f, float f2, float f3, Vector3f vector3f) {
        return vector3f.set(Math.fma(this.m00, f, Math.fma(this.m01, f2, this.m02 * f3)), Math.fma(this.m10, f, Math.fma(this.m11, f2, this.m12 * f3)), Math.fma(this.m20, f, Math.fma(this.m21, f2, this.m22 * f3)));
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeFloat(this.m00);
        objectOutput.writeFloat(this.m01);
        objectOutput.writeFloat(this.m02);
        objectOutput.writeFloat(this.m10);
        objectOutput.writeFloat(this.m11);
        objectOutput.writeFloat(this.m12);
        objectOutput.writeFloat(this.m20);
        objectOutput.writeFloat(this.m21);
        objectOutput.writeFloat(this.m22);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        this.m00 = objectInput.readFloat();
        this.m01 = objectInput.readFloat();
        this.m02 = objectInput.readFloat();
        this.m10 = objectInput.readFloat();
        this.m11 = objectInput.readFloat();
        this.m12 = objectInput.readFloat();
        this.m20 = objectInput.readFloat();
        this.m21 = objectInput.readFloat();
        this.m22 = objectInput.readFloat();
    }

    @Override
    public Matrix3f rotateX(float f, Matrix3f matrix3f) {
        float f2;
        float f3 = Math.sin(f);
        float f4 = f2 = Math.cosFromSin(f3, f);
        float f5 = -f3;
        float f6 = f3;
        float f7 = f2;
        float f8 = this.m10 * f4 + this.m20 * f6;
        float f9 = this.m11 * f4 + this.m21 * f6;
        float f10 = this.m12 * f4 + this.m22 * f6;
        matrix3f.m20 = this.m10 * f5 + this.m20 * f7;
        matrix3f.m21 = this.m11 * f5 + this.m21 * f7;
        matrix3f.m22 = this.m12 * f5 + this.m22 * f7;
        matrix3f.m10 = f8;
        matrix3f.m11 = f9;
        matrix3f.m12 = f10;
        matrix3f.m00 = this.m00;
        matrix3f.m01 = this.m01;
        matrix3f.m02 = this.m02;
        return matrix3f;
    }

    public Matrix3f rotateX(float f) {
        return this.rotateX(f, this);
    }

    @Override
    public Matrix3f rotateY(float f, Matrix3f matrix3f) {
        float f2;
        float f3 = Math.sin(f);
        float f4 = f2 = Math.cosFromSin(f3, f);
        float f5 = f3;
        float f6 = -f3;
        float f7 = f2;
        float f8 = this.m00 * f4 + this.m20 * f6;
        float f9 = this.m01 * f4 + this.m21 * f6;
        float f10 = this.m02 * f4 + this.m22 * f6;
        matrix3f.m20 = this.m00 * f5 + this.m20 * f7;
        matrix3f.m21 = this.m01 * f5 + this.m21 * f7;
        matrix3f.m22 = this.m02 * f5 + this.m22 * f7;
        matrix3f.m00 = f8;
        matrix3f.m01 = f9;
        matrix3f.m02 = f10;
        matrix3f.m10 = this.m10;
        matrix3f.m11 = this.m11;
        matrix3f.m12 = this.m12;
        return matrix3f;
    }

    public Matrix3f rotateY(float f) {
        return this.rotateY(f, this);
    }

    @Override
    public Matrix3f rotateZ(float f, Matrix3f matrix3f) {
        float f2;
        float f3 = Math.sin(f);
        float f4 = f2 = Math.cosFromSin(f3, f);
        float f5 = -f3;
        float f6 = f3;
        float f7 = f2;
        float f8 = this.m00 * f4 + this.m10 * f6;
        float f9 = this.m01 * f4 + this.m11 * f6;
        float f10 = this.m02 * f4 + this.m12 * f6;
        matrix3f.m10 = this.m00 * f5 + this.m10 * f7;
        matrix3f.m11 = this.m01 * f5 + this.m11 * f7;
        matrix3f.m12 = this.m02 * f5 + this.m12 * f7;
        matrix3f.m00 = f8;
        matrix3f.m01 = f9;
        matrix3f.m02 = f10;
        matrix3f.m20 = this.m20;
        matrix3f.m21 = this.m21;
        matrix3f.m22 = this.m22;
        return matrix3f;
    }

    public Matrix3f rotateZ(float f) {
        return this.rotateZ(f, this);
    }

    public Matrix3f rotateXYZ(Vector3f vector3f) {
        return this.rotateXYZ(vector3f.x, vector3f.y, vector3f.z);
    }

    public Matrix3f rotateXYZ(float f, float f2, float f3) {
        return this.rotateXYZ(f, f2, f3, this);
    }

    @Override
    public Matrix3f rotateXYZ(float f, float f2, float f3, Matrix3f matrix3f) {
        float f4 = Math.sin(f);
        float f5 = Math.cosFromSin(f4, f);
        float f6 = Math.sin(f2);
        float f7 = Math.cosFromSin(f6, f2);
        float f8 = Math.sin(f3);
        float f9 = Math.cosFromSin(f8, f3);
        float f10 = -f4;
        float f11 = -f6;
        float f12 = -f8;
        float f13 = this.m10 * f5 + this.m20 * f4;
        float f14 = this.m11 * f5 + this.m21 * f4;
        float f15 = this.m12 * f5 + this.m22 * f4;
        float f16 = this.m10 * f10 + this.m20 * f5;
        float f17 = this.m11 * f10 + this.m21 * f5;
        float f18 = this.m12 * f10 + this.m22 * f5;
        float f19 = this.m00 * f7 + f16 * f11;
        float f20 = this.m01 * f7 + f17 * f11;
        float f21 = this.m02 * f7 + f18 * f11;
        matrix3f.m20 = this.m00 * f6 + f16 * f7;
        matrix3f.m21 = this.m01 * f6 + f17 * f7;
        matrix3f.m22 = this.m02 * f6 + f18 * f7;
        matrix3f.m00 = f19 * f9 + f13 * f8;
        matrix3f.m01 = f20 * f9 + f14 * f8;
        matrix3f.m02 = f21 * f9 + f15 * f8;
        matrix3f.m10 = f19 * f12 + f13 * f9;
        matrix3f.m11 = f20 * f12 + f14 * f9;
        matrix3f.m12 = f21 * f12 + f15 * f9;
        return matrix3f;
    }

    public Matrix3f rotateZYX(Vector3f vector3f) {
        return this.rotateZYX(vector3f.z, vector3f.y, vector3f.x);
    }

    public Matrix3f rotateZYX(float f, float f2, float f3) {
        return this.rotateZYX(f, f2, f3, this);
    }

    @Override
    public Matrix3f rotateZYX(float f, float f2, float f3, Matrix3f matrix3f) {
        float f4 = Math.sin(f3);
        float f5 = Math.cosFromSin(f4, f3);
        float f6 = Math.sin(f2);
        float f7 = Math.cosFromSin(f6, f2);
        float f8 = Math.sin(f);
        float f9 = Math.cosFromSin(f8, f);
        float f10 = -f8;
        float f11 = -f6;
        float f12 = -f4;
        float f13 = this.m00 * f9 + this.m10 * f8;
        float f14 = this.m01 * f9 + this.m11 * f8;
        float f15 = this.m02 * f9 + this.m12 * f8;
        float f16 = this.m00 * f10 + this.m10 * f9;
        float f17 = this.m01 * f10 + this.m11 * f9;
        float f18 = this.m02 * f10 + this.m12 * f9;
        float f19 = f13 * f6 + this.m20 * f7;
        float f20 = f14 * f6 + this.m21 * f7;
        float f21 = f15 * f6 + this.m22 * f7;
        matrix3f.m00 = f13 * f7 + this.m20 * f11;
        matrix3f.m01 = f14 * f7 + this.m21 * f11;
        matrix3f.m02 = f15 * f7 + this.m22 * f11;
        matrix3f.m10 = f16 * f5 + f19 * f4;
        matrix3f.m11 = f17 * f5 + f20 * f4;
        matrix3f.m12 = f18 * f5 + f21 * f4;
        matrix3f.m20 = f16 * f12 + f19 * f5;
        matrix3f.m21 = f17 * f12 + f20 * f5;
        matrix3f.m22 = f18 * f12 + f21 * f5;
        return matrix3f;
    }

    public Matrix3f rotateYXZ(Vector3f vector3f) {
        return this.rotateYXZ(vector3f.y, vector3f.x, vector3f.z);
    }

    public Matrix3f rotateYXZ(float f, float f2, float f3) {
        return this.rotateYXZ(f, f2, f3, this);
    }

    @Override
    public Matrix3f rotateYXZ(float f, float f2, float f3, Matrix3f matrix3f) {
        float f4 = Math.sin(f2);
        float f5 = Math.cosFromSin(f4, f2);
        float f6 = Math.sin(f);
        float f7 = Math.cosFromSin(f6, f);
        float f8 = Math.sin(f3);
        float f9 = Math.cosFromSin(f8, f3);
        float f10 = -f6;
        float f11 = -f4;
        float f12 = -f8;
        float f13 = this.m00 * f6 + this.m20 * f7;
        float f14 = this.m01 * f6 + this.m21 * f7;
        float f15 = this.m02 * f6 + this.m22 * f7;
        float f16 = this.m00 * f7 + this.m20 * f10;
        float f17 = this.m01 * f7 + this.m21 * f10;
        float f18 = this.m02 * f7 + this.m22 * f10;
        float f19 = this.m10 * f5 + f13 * f4;
        float f20 = this.m11 * f5 + f14 * f4;
        float f21 = this.m12 * f5 + f15 * f4;
        matrix3f.m20 = this.m10 * f11 + f13 * f5;
        matrix3f.m21 = this.m11 * f11 + f14 * f5;
        matrix3f.m22 = this.m12 * f11 + f15 * f5;
        matrix3f.m00 = f16 * f9 + f19 * f8;
        matrix3f.m01 = f17 * f9 + f20 * f8;
        matrix3f.m02 = f18 * f9 + f21 * f8;
        matrix3f.m10 = f16 * f12 + f19 * f9;
        matrix3f.m11 = f17 * f12 + f20 * f9;
        matrix3f.m12 = f18 * f12 + f21 * f9;
        return matrix3f;
    }

    public Matrix3f rotate(float f, float f2, float f3, float f4) {
        return this.rotate(f, f2, f3, f4, this);
    }

    @Override
    public Matrix3f rotate(float f, float f2, float f3, float f4, Matrix3f matrix3f) {
        float f5 = Math.sin(f);
        float f6 = Math.cosFromSin(f5, f);
        float f7 = 1.0f - f6;
        float f8 = f2 * f2;
        float f9 = f2 * f3;
        float f10 = f2 * f4;
        float f11 = f3 * f3;
        float f12 = f3 * f4;
        float f13 = f4 * f4;
        float f14 = f8 * f7 + f6;
        float f15 = f9 * f7 + f4 * f5;
        float f16 = f10 * f7 - f3 * f5;
        float f17 = f9 * f7 - f4 * f5;
        float f18 = f11 * f7 + f6;
        float f19 = f12 * f7 + f2 * f5;
        float f20 = f10 * f7 + f3 * f5;
        float f21 = f12 * f7 - f2 * f5;
        float f22 = f13 * f7 + f6;
        float f23 = this.m00 * f14 + this.m10 * f15 + this.m20 * f16;
        float f24 = this.m01 * f14 + this.m11 * f15 + this.m21 * f16;
        float f25 = this.m02 * f14 + this.m12 * f15 + this.m22 * f16;
        float f26 = this.m00 * f17 + this.m10 * f18 + this.m20 * f19;
        float f27 = this.m01 * f17 + this.m11 * f18 + this.m21 * f19;
        float f28 = this.m02 * f17 + this.m12 * f18 + this.m22 * f19;
        matrix3f.m20 = this.m00 * f20 + this.m10 * f21 + this.m20 * f22;
        matrix3f.m21 = this.m01 * f20 + this.m11 * f21 + this.m21 * f22;
        matrix3f.m22 = this.m02 * f20 + this.m12 * f21 + this.m22 * f22;
        matrix3f.m00 = f23;
        matrix3f.m01 = f24;
        matrix3f.m02 = f25;
        matrix3f.m10 = f26;
        matrix3f.m11 = f27;
        matrix3f.m12 = f28;
        return matrix3f;
    }

    @Override
    public Matrix3f rotateLocal(float f, float f2, float f3, float f4, Matrix3f matrix3f) {
        float f5 = Math.sin(f);
        float f6 = Math.cosFromSin(f5, f);
        float f7 = 1.0f - f6;
        float f8 = f2 * f2;
        float f9 = f2 * f3;
        float f10 = f2 * f4;
        float f11 = f3 * f3;
        float f12 = f3 * f4;
        float f13 = f4 * f4;
        float f14 = f8 * f7 + f6;
        float f15 = f9 * f7 + f4 * f5;
        float f16 = f10 * f7 - f3 * f5;
        float f17 = f9 * f7 - f4 * f5;
        float f18 = f11 * f7 + f6;
        float f19 = f12 * f7 + f2 * f5;
        float f20 = f10 * f7 + f3 * f5;
        float f21 = f12 * f7 - f2 * f5;
        float f22 = f13 * f7 + f6;
        float f23 = f14 * this.m00 + f17 * this.m01 + f20 * this.m02;
        float f24 = f15 * this.m00 + f18 * this.m01 + f21 * this.m02;
        float f25 = f16 * this.m00 + f19 * this.m01 + f22 * this.m02;
        float f26 = f14 * this.m10 + f17 * this.m11 + f20 * this.m12;
        float f27 = f15 * this.m10 + f18 * this.m11 + f21 * this.m12;
        float f28 = f16 * this.m10 + f19 * this.m11 + f22 * this.m12;
        float f29 = f14 * this.m20 + f17 * this.m21 + f20 * this.m22;
        float f30 = f15 * this.m20 + f18 * this.m21 + f21 * this.m22;
        float f31 = f16 * this.m20 + f19 * this.m21 + f22 * this.m22;
        matrix3f.m00 = f23;
        matrix3f.m01 = f24;
        matrix3f.m02 = f25;
        matrix3f.m10 = f26;
        matrix3f.m11 = f27;
        matrix3f.m12 = f28;
        matrix3f.m20 = f29;
        matrix3f.m21 = f30;
        matrix3f.m22 = f31;
        return matrix3f;
    }

    public Matrix3f rotateLocal(float f, float f2, float f3, float f4) {
        return this.rotateLocal(f, f2, f3, f4, this);
    }

    @Override
    public Matrix3f rotateLocalX(float f, Matrix3f matrix3f) {
        float f2 = Math.sin(f);
        float f3 = Math.cosFromSin(f2, f);
        float f4 = f3 * this.m01 - f2 * this.m02;
        float f5 = f2 * this.m01 + f3 * this.m02;
        float f6 = f3 * this.m11 - f2 * this.m12;
        float f7 = f2 * this.m11 + f3 * this.m12;
        float f8 = f3 * this.m21 - f2 * this.m22;
        float f9 = f2 * this.m21 + f3 * this.m22;
        matrix3f.m00 = this.m00;
        matrix3f.m01 = f4;
        matrix3f.m02 = f5;
        matrix3f.m10 = this.m10;
        matrix3f.m11 = f6;
        matrix3f.m12 = f7;
        matrix3f.m20 = this.m20;
        matrix3f.m21 = f8;
        matrix3f.m22 = f9;
        return matrix3f;
    }

    public Matrix3f rotateLocalX(float f) {
        return this.rotateLocalX(f, this);
    }

    @Override
    public Matrix3f rotateLocalY(float f, Matrix3f matrix3f) {
        float f2 = Math.sin(f);
        float f3 = Math.cosFromSin(f2, f);
        float f4 = f3 * this.m00 + f2 * this.m02;
        float f5 = -f2 * this.m00 + f3 * this.m02;
        float f6 = f3 * this.m10 + f2 * this.m12;
        float f7 = -f2 * this.m10 + f3 * this.m12;
        float f8 = f3 * this.m20 + f2 * this.m22;
        float f9 = -f2 * this.m20 + f3 * this.m22;
        matrix3f.m00 = f4;
        matrix3f.m01 = this.m01;
        matrix3f.m02 = f5;
        matrix3f.m10 = f6;
        matrix3f.m11 = this.m11;
        matrix3f.m12 = f7;
        matrix3f.m20 = f8;
        matrix3f.m21 = this.m21;
        matrix3f.m22 = f9;
        return matrix3f;
    }

    public Matrix3f rotateLocalY(float f) {
        return this.rotateLocalY(f, this);
    }

    @Override
    public Matrix3f rotateLocalZ(float f, Matrix3f matrix3f) {
        float f2 = Math.sin(f);
        float f3 = Math.cosFromSin(f2, f);
        float f4 = f3 * this.m00 - f2 * this.m01;
        float f5 = f2 * this.m00 + f3 * this.m01;
        float f6 = f3 * this.m10 - f2 * this.m11;
        float f7 = f2 * this.m10 + f3 * this.m11;
        float f8 = f3 * this.m20 - f2 * this.m21;
        float f9 = f2 * this.m20 + f3 * this.m21;
        matrix3f.m00 = f4;
        matrix3f.m01 = f5;
        matrix3f.m02 = this.m02;
        matrix3f.m10 = f6;
        matrix3f.m11 = f7;
        matrix3f.m12 = this.m12;
        matrix3f.m20 = f8;
        matrix3f.m21 = f9;
        matrix3f.m22 = this.m22;
        return matrix3f;
    }

    public Matrix3f rotateLocalZ(float f) {
        return this.rotateLocalZ(f, this);
    }

    public Matrix3f rotate(Quaternionfc quaternionfc) {
        return this.rotate(quaternionfc, this);
    }

    @Override
    public Matrix3f rotate(Quaternionfc quaternionfc, Matrix3f matrix3f) {
        float f = quaternionfc.w() * quaternionfc.w();
        float f2 = quaternionfc.x() * quaternionfc.x();
        float f3 = quaternionfc.y() * quaternionfc.y();
        float f4 = quaternionfc.z() * quaternionfc.z();
        float f5 = quaternionfc.z() * quaternionfc.w();
        float f6 = f5 + f5;
        float f7 = quaternionfc.x() * quaternionfc.y();
        float f8 = f7 + f7;
        float f9 = quaternionfc.x() * quaternionfc.z();
        float f10 = f9 + f9;
        float f11 = quaternionfc.y() * quaternionfc.w();
        float f12 = f11 + f11;
        float f13 = quaternionfc.y() * quaternionfc.z();
        float f14 = f13 + f13;
        float f15 = quaternionfc.x() * quaternionfc.w();
        float f16 = f15 + f15;
        float f17 = f + f2 - f4 - f3;
        float f18 = f8 + f6;
        float f19 = f10 - f12;
        float f20 = f8 - f6;
        float f21 = f3 - f4 + f - f2;
        float f22 = f14 + f16;
        float f23 = f12 + f10;
        float f24 = f14 - f16;
        float f25 = f4 - f3 - f2 + f;
        float f26 = this.m00 * f17 + this.m10 * f18 + this.m20 * f19;
        float f27 = this.m01 * f17 + this.m11 * f18 + this.m21 * f19;
        float f28 = this.m02 * f17 + this.m12 * f18 + this.m22 * f19;
        float f29 = this.m00 * f20 + this.m10 * f21 + this.m20 * f22;
        float f30 = this.m01 * f20 + this.m11 * f21 + this.m21 * f22;
        float f31 = this.m02 * f20 + this.m12 * f21 + this.m22 * f22;
        matrix3f.m20 = this.m00 * f23 + this.m10 * f24 + this.m20 * f25;
        matrix3f.m21 = this.m01 * f23 + this.m11 * f24 + this.m21 * f25;
        matrix3f.m22 = this.m02 * f23 + this.m12 * f24 + this.m22 * f25;
        matrix3f.m00 = f26;
        matrix3f.m01 = f27;
        matrix3f.m02 = f28;
        matrix3f.m10 = f29;
        matrix3f.m11 = f30;
        matrix3f.m12 = f31;
        return matrix3f;
    }

    @Override
    public Matrix3f rotateLocal(Quaternionfc quaternionfc, Matrix3f matrix3f) {
        float f = quaternionfc.w() * quaternionfc.w();
        float f2 = quaternionfc.x() * quaternionfc.x();
        float f3 = quaternionfc.y() * quaternionfc.y();
        float f4 = quaternionfc.z() * quaternionfc.z();
        float f5 = quaternionfc.z() * quaternionfc.w();
        float f6 = f5 + f5;
        float f7 = quaternionfc.x() * quaternionfc.y();
        float f8 = f7 + f7;
        float f9 = quaternionfc.x() * quaternionfc.z();
        float f10 = f9 + f9;
        float f11 = quaternionfc.y() * quaternionfc.w();
        float f12 = f11 + f11;
        float f13 = quaternionfc.y() * quaternionfc.z();
        float f14 = f13 + f13;
        float f15 = quaternionfc.x() * quaternionfc.w();
        float f16 = f15 + f15;
        float f17 = f + f2 - f4 - f3;
        float f18 = f8 + f6;
        float f19 = f10 - f12;
        float f20 = f8 - f6;
        float f21 = f3 - f4 + f - f2;
        float f22 = f14 + f16;
        float f23 = f12 + f10;
        float f24 = f14 - f16;
        float f25 = f4 - f3 - f2 + f;
        float f26 = f17 * this.m00 + f20 * this.m01 + f23 * this.m02;
        float f27 = f18 * this.m00 + f21 * this.m01 + f24 * this.m02;
        float f28 = f19 * this.m00 + f22 * this.m01 + f25 * this.m02;
        float f29 = f17 * this.m10 + f20 * this.m11 + f23 * this.m12;
        float f30 = f18 * this.m10 + f21 * this.m11 + f24 * this.m12;
        float f31 = f19 * this.m10 + f22 * this.m11 + f25 * this.m12;
        float f32 = f17 * this.m20 + f20 * this.m21 + f23 * this.m22;
        float f33 = f18 * this.m20 + f21 * this.m21 + f24 * this.m22;
        float f34 = f19 * this.m20 + f22 * this.m21 + f25 * this.m22;
        matrix3f.m00 = f26;
        matrix3f.m01 = f27;
        matrix3f.m02 = f28;
        matrix3f.m10 = f29;
        matrix3f.m11 = f30;
        matrix3f.m12 = f31;
        matrix3f.m20 = f32;
        matrix3f.m21 = f33;
        matrix3f.m22 = f34;
        return matrix3f;
    }

    public Matrix3f rotateLocal(Quaternionfc quaternionfc) {
        return this.rotateLocal(quaternionfc, this);
    }

    public Matrix3f rotate(AxisAngle4f axisAngle4f) {
        return this.rotate(axisAngle4f.angle, axisAngle4f.x, axisAngle4f.y, axisAngle4f.z);
    }

    @Override
    public Matrix3f rotate(AxisAngle4f axisAngle4f, Matrix3f matrix3f) {
        return this.rotate(axisAngle4f.angle, axisAngle4f.x, axisAngle4f.y, axisAngle4f.z, matrix3f);
    }

    public Matrix3f rotate(float f, Vector3fc vector3fc) {
        return this.rotate(f, vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    @Override
    public Matrix3f rotate(float f, Vector3fc vector3fc, Matrix3f matrix3f) {
        return this.rotate(f, vector3fc.x(), vector3fc.y(), vector3fc.z(), matrix3f);
    }

    public Matrix3f lookAlong(Vector3fc vector3fc, Vector3fc vector3fc2) {
        return this.lookAlong(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), this);
    }

    @Override
    public Matrix3f lookAlong(Vector3fc vector3fc, Vector3fc vector3fc2, Matrix3f matrix3f) {
        return this.lookAlong(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), matrix3f);
    }

    @Override
    public Matrix3f lookAlong(float f, float f2, float f3, float f4, float f5, float f6, Matrix3f matrix3f) {
        float f7 = Math.invsqrt(f * f + f2 * f2 + f3 * f3);
        float f8 = f5 * (f3 *= -f7) - f6 * (f2 *= -f7);
        float f9 = f6 * (f *= -f7) - f4 * f3;
        float f10 = f4 * f2 - f5 * f;
        float f11 = Math.invsqrt(f8 * f8 + f9 * f9 + f10 * f10);
        float f12 = f2 * (f10 *= f11) - f3 * (f9 *= f11);
        float f13 = f3 * (f8 *= f11) - f * f10;
        float f14 = f * f9 - f2 * f8;
        float f15 = f8;
        float f16 = f12;
        float f17 = f;
        float f18 = f9;
        float f19 = f13;
        float f20 = f2;
        float f21 = f10;
        float f22 = f14;
        float f23 = f3;
        float f24 = this.m00 * f15 + this.m10 * f16 + this.m20 * f17;
        float f25 = this.m01 * f15 + this.m11 * f16 + this.m21 * f17;
        float f26 = this.m02 * f15 + this.m12 * f16 + this.m22 * f17;
        float f27 = this.m00 * f18 + this.m10 * f19 + this.m20 * f20;
        float f28 = this.m01 * f18 + this.m11 * f19 + this.m21 * f20;
        float f29 = this.m02 * f18 + this.m12 * f19 + this.m22 * f20;
        matrix3f.m20 = this.m00 * f21 + this.m10 * f22 + this.m20 * f23;
        matrix3f.m21 = this.m01 * f21 + this.m11 * f22 + this.m21 * f23;
        matrix3f.m22 = this.m02 * f21 + this.m12 * f22 + this.m22 * f23;
        matrix3f.m00 = f24;
        matrix3f.m01 = f25;
        matrix3f.m02 = f26;
        matrix3f.m10 = f27;
        matrix3f.m11 = f28;
        matrix3f.m12 = f29;
        return matrix3f;
    }

    public Matrix3f lookAlong(float f, float f2, float f3, float f4, float f5, float f6) {
        return this.lookAlong(f, f2, f3, f4, f5, f6, this);
    }

    public Matrix3f setLookAlong(Vector3fc vector3fc, Vector3fc vector3fc2) {
        return this.setLookAlong(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z());
    }

    public Matrix3f setLookAlong(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = Math.invsqrt(f * f + f2 * f2 + f3 * f3);
        float f8 = f5 * (f3 *= -f7) - f6 * (f2 *= -f7);
        float f9 = f6 * (f *= -f7) - f4 * f3;
        float f10 = f4 * f2 - f5 * f;
        float f11 = Math.invsqrt(f8 * f8 + f9 * f9 + f10 * f10);
        float f12 = f2 * (f10 *= f11) - f3 * (f9 *= f11);
        float f13 = f3 * (f8 *= f11) - f * f10;
        float f14 = f * f9 - f2 * f8;
        this.m00 = f8;
        this.m01 = f12;
        this.m02 = f;
        this.m10 = f9;
        this.m11 = f13;
        this.m12 = f2;
        this.m20 = f10;
        this.m21 = f14;
        this.m22 = f3;
        return this;
    }

    @Override
    public Vector3f getRow(int n, Vector3f vector3f) throws IndexOutOfBoundsException {
        switch (n) {
            case 0: {
                return vector3f.set(this.m00, this.m10, this.m20);
            }
            case 1: {
                return vector3f.set(this.m01, this.m11, this.m21);
            }
            case 2: {
                return vector3f.set(this.m02, this.m12, this.m22);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public Matrix3f setRow(int n, Vector3fc vector3fc) throws IndexOutOfBoundsException {
        return this.setRow(n, vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public Matrix3f setRow(int n, float f, float f2, float f3) throws IndexOutOfBoundsException {
        switch (n) {
            case 0: {
                this.m00 = f;
                this.m10 = f2;
                this.m20 = f3;
                break;
            }
            case 1: {
                this.m01 = f;
                this.m11 = f2;
                this.m21 = f3;
                break;
            }
            case 2: {
                this.m02 = f;
                this.m12 = f2;
                this.m22 = f3;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        return this;
    }

    @Override
    public Vector3f getColumn(int n, Vector3f vector3f) throws IndexOutOfBoundsException {
        switch (n) {
            case 0: {
                return vector3f.set(this.m00, this.m01, this.m02);
            }
            case 1: {
                return vector3f.set(this.m10, this.m11, this.m12);
            }
            case 2: {
                return vector3f.set(this.m20, this.m21, this.m22);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public Matrix3f setColumn(int n, Vector3fc vector3fc) throws IndexOutOfBoundsException {
        return this.setColumn(n, vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public Matrix3f setColumn(int n, float f, float f2, float f3) throws IndexOutOfBoundsException {
        switch (n) {
            case 0: {
                this.m00 = f;
                this.m01 = f2;
                this.m02 = f3;
                break;
            }
            case 1: {
                this.m10 = f;
                this.m11 = f2;
                this.m12 = f3;
                break;
            }
            case 2: {
                this.m20 = f;
                this.m21 = f2;
                this.m22 = f3;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        return this;
    }

    @Override
    public float get(int n, int n2) {
        return MemUtil.INSTANCE.get(this, n, n2);
    }

    public Matrix3f set(int n, int n2, float f) {
        return MemUtil.INSTANCE.set(this, n, n2, f);
    }

    @Override
    public float getRowColumn(int n, int n2) {
        return MemUtil.INSTANCE.get(this, n2, n);
    }

    public Matrix3f setRowColumn(int n, int n2, float f) {
        return MemUtil.INSTANCE.set(this, n2, n, f);
    }

    public Matrix3f normal() {
        return this.normal(this);
    }

    @Override
    public Matrix3f normal(Matrix3f matrix3f) {
        float f = this.m00 * this.m11;
        float f2 = this.m01 * this.m10;
        float f3 = this.m02 * this.m10;
        float f4 = this.m00 * this.m12;
        float f5 = this.m01 * this.m12;
        float f6 = this.m02 * this.m11;
        float f7 = (f - f2) * this.m22 + (f3 - f4) * this.m21 + (f5 - f6) * this.m20;
        float f8 = 1.0f / f7;
        float f9 = (this.m11 * this.m22 - this.m21 * this.m12) * f8;
        float f10 = (this.m20 * this.m12 - this.m10 * this.m22) * f8;
        float f11 = (this.m10 * this.m21 - this.m20 * this.m11) * f8;
        float f12 = (this.m21 * this.m02 - this.m01 * this.m22) * f8;
        float f13 = (this.m00 * this.m22 - this.m20 * this.m02) * f8;
        float f14 = (this.m20 * this.m01 - this.m00 * this.m21) * f8;
        float f15 = (f5 - f6) * f8;
        float f16 = (f3 - f4) * f8;
        float f17 = (f - f2) * f8;
        matrix3f.m00 = f9;
        matrix3f.m01 = f10;
        matrix3f.m02 = f11;
        matrix3f.m10 = f12;
        matrix3f.m11 = f13;
        matrix3f.m12 = f14;
        matrix3f.m20 = f15;
        matrix3f.m21 = f16;
        matrix3f.m22 = f17;
        return matrix3f;
    }

    public Matrix3f cofactor() {
        return this.cofactor(this);
    }

    @Override
    public Matrix3f cofactor(Matrix3f matrix3f) {
        float f = this.m11 * this.m22 - this.m21 * this.m12;
        float f2 = this.m20 * this.m12 - this.m10 * this.m22;
        float f3 = this.m10 * this.m21 - this.m20 * this.m11;
        float f4 = this.m21 * this.m02 - this.m01 * this.m22;
        float f5 = this.m00 * this.m22 - this.m20 * this.m02;
        float f6 = this.m20 * this.m01 - this.m00 * this.m21;
        float f7 = this.m01 * this.m12 - this.m11 * this.m02;
        float f8 = this.m02 * this.m10 - this.m12 * this.m00;
        float f9 = this.m00 * this.m11 - this.m10 * this.m01;
        matrix3f.m00 = f;
        matrix3f.m01 = f2;
        matrix3f.m02 = f3;
        matrix3f.m10 = f4;
        matrix3f.m11 = f5;
        matrix3f.m12 = f6;
        matrix3f.m20 = f7;
        matrix3f.m21 = f8;
        matrix3f.m22 = f9;
        return matrix3f;
    }

    @Override
    public Vector3f getScale(Vector3f vector3f) {
        return vector3f.set(Math.sqrt(this.m00 * this.m00 + this.m01 * this.m01 + this.m02 * this.m02), Math.sqrt(this.m10 * this.m10 + this.m11 * this.m11 + this.m12 * this.m12), Math.sqrt(this.m20 * this.m20 + this.m21 * this.m21 + this.m22 * this.m22));
    }

    @Override
    public Vector3f positiveZ(Vector3f vector3f) {
        vector3f.x = this.m10 * this.m21 - this.m11 * this.m20;
        vector3f.y = this.m20 * this.m01 - this.m21 * this.m00;
        vector3f.z = this.m00 * this.m11 - this.m01 * this.m10;
        return vector3f.normalize(vector3f);
    }

    @Override
    public Vector3f normalizedPositiveZ(Vector3f vector3f) {
        vector3f.x = this.m02;
        vector3f.y = this.m12;
        vector3f.z = this.m22;
        return vector3f;
    }

    @Override
    public Vector3f positiveX(Vector3f vector3f) {
        vector3f.x = this.m11 * this.m22 - this.m12 * this.m21;
        vector3f.y = this.m02 * this.m21 - this.m01 * this.m22;
        vector3f.z = this.m01 * this.m12 - this.m02 * this.m11;
        return vector3f.normalize(vector3f);
    }

    @Override
    public Vector3f normalizedPositiveX(Vector3f vector3f) {
        vector3f.x = this.m00;
        vector3f.y = this.m10;
        vector3f.z = this.m20;
        return vector3f;
    }

    @Override
    public Vector3f positiveY(Vector3f vector3f) {
        vector3f.x = this.m12 * this.m20 - this.m10 * this.m22;
        vector3f.y = this.m00 * this.m22 - this.m02 * this.m20;
        vector3f.z = this.m02 * this.m10 - this.m00 * this.m12;
        return vector3f.normalize(vector3f);
    }

    @Override
    public Vector3f normalizedPositiveY(Vector3f vector3f) {
        vector3f.x = this.m01;
        vector3f.y = this.m11;
        vector3f.z = this.m21;
        return vector3f;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + Float.floatToIntBits(this.m00);
        n = 31 * n + Float.floatToIntBits(this.m01);
        n = 31 * n + Float.floatToIntBits(this.m02);
        n = 31 * n + Float.floatToIntBits(this.m10);
        n = 31 * n + Float.floatToIntBits(this.m11);
        n = 31 * n + Float.floatToIntBits(this.m12);
        n = 31 * n + Float.floatToIntBits(this.m20);
        n = 31 * n + Float.floatToIntBits(this.m21);
        n = 31 * n + Float.floatToIntBits(this.m22);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Matrix3f matrix3f = (Matrix3f)object;
        if (Float.floatToIntBits(this.m00) != Float.floatToIntBits(matrix3f.m00)) {
            return false;
        }
        if (Float.floatToIntBits(this.m01) != Float.floatToIntBits(matrix3f.m01)) {
            return false;
        }
        if (Float.floatToIntBits(this.m02) != Float.floatToIntBits(matrix3f.m02)) {
            return false;
        }
        if (Float.floatToIntBits(this.m10) != Float.floatToIntBits(matrix3f.m10)) {
            return false;
        }
        if (Float.floatToIntBits(this.m11) != Float.floatToIntBits(matrix3f.m11)) {
            return false;
        }
        if (Float.floatToIntBits(this.m12) != Float.floatToIntBits(matrix3f.m12)) {
            return false;
        }
        if (Float.floatToIntBits(this.m20) != Float.floatToIntBits(matrix3f.m20)) {
            return false;
        }
        if (Float.floatToIntBits(this.m21) != Float.floatToIntBits(matrix3f.m21)) {
            return false;
        }
        return Float.floatToIntBits(this.m22) == Float.floatToIntBits(matrix3f.m22);
    }

    @Override
    public boolean equals(Matrix3fc matrix3fc, float f) {
        if (this == matrix3fc) {
            return true;
        }
        if (matrix3fc == null) {
            return false;
        }
        if (!(matrix3fc instanceof Matrix3f)) {
            return false;
        }
        if (!Runtime.equals(this.m00, matrix3fc.m00(), f)) {
            return false;
        }
        if (!Runtime.equals(this.m01, matrix3fc.m01(), f)) {
            return false;
        }
        if (!Runtime.equals(this.m02, matrix3fc.m02(), f)) {
            return false;
        }
        if (!Runtime.equals(this.m10, matrix3fc.m10(), f)) {
            return false;
        }
        if (!Runtime.equals(this.m11, matrix3fc.m11(), f)) {
            return false;
        }
        if (!Runtime.equals(this.m12, matrix3fc.m12(), f)) {
            return false;
        }
        if (!Runtime.equals(this.m20, matrix3fc.m20(), f)) {
            return false;
        }
        if (!Runtime.equals(this.m21, matrix3fc.m21(), f)) {
            return false;
        }
        return Runtime.equals(this.m22, matrix3fc.m22(), f);
    }

    public Matrix3f swap(Matrix3f matrix3f) {
        MemUtil.INSTANCE.swap(this, matrix3f);
        return this;
    }

    public Matrix3f add(Matrix3fc matrix3fc) {
        return this.add(matrix3fc, this);
    }

    @Override
    public Matrix3f add(Matrix3fc matrix3fc, Matrix3f matrix3f) {
        matrix3f.m00 = this.m00 + matrix3fc.m00();
        matrix3f.m01 = this.m01 + matrix3fc.m01();
        matrix3f.m02 = this.m02 + matrix3fc.m02();
        matrix3f.m10 = this.m10 + matrix3fc.m10();
        matrix3f.m11 = this.m11 + matrix3fc.m11();
        matrix3f.m12 = this.m12 + matrix3fc.m12();
        matrix3f.m20 = this.m20 + matrix3fc.m20();
        matrix3f.m21 = this.m21 + matrix3fc.m21();
        matrix3f.m22 = this.m22 + matrix3fc.m22();
        return matrix3f;
    }

    public Matrix3f sub(Matrix3fc matrix3fc) {
        return this.sub(matrix3fc, this);
    }

    @Override
    public Matrix3f sub(Matrix3fc matrix3fc, Matrix3f matrix3f) {
        matrix3f.m00 = this.m00 - matrix3fc.m00();
        matrix3f.m01 = this.m01 - matrix3fc.m01();
        matrix3f.m02 = this.m02 - matrix3fc.m02();
        matrix3f.m10 = this.m10 - matrix3fc.m10();
        matrix3f.m11 = this.m11 - matrix3fc.m11();
        matrix3f.m12 = this.m12 - matrix3fc.m12();
        matrix3f.m20 = this.m20 - matrix3fc.m20();
        matrix3f.m21 = this.m21 - matrix3fc.m21();
        matrix3f.m22 = this.m22 - matrix3fc.m22();
        return matrix3f;
    }

    public Matrix3f mulComponentWise(Matrix3fc matrix3fc) {
        return this.mulComponentWise(matrix3fc, this);
    }

    @Override
    public Matrix3f mulComponentWise(Matrix3fc matrix3fc, Matrix3f matrix3f) {
        matrix3f.m00 = this.m00 * matrix3fc.m00();
        matrix3f.m01 = this.m01 * matrix3fc.m01();
        matrix3f.m02 = this.m02 * matrix3fc.m02();
        matrix3f.m10 = this.m10 * matrix3fc.m10();
        matrix3f.m11 = this.m11 * matrix3fc.m11();
        matrix3f.m12 = this.m12 * matrix3fc.m12();
        matrix3f.m20 = this.m20 * matrix3fc.m20();
        matrix3f.m21 = this.m21 * matrix3fc.m21();
        matrix3f.m22 = this.m22 * matrix3fc.m22();
        return matrix3f;
    }

    public Matrix3f setSkewSymmetric(float f, float f2, float f3) {
        this.m22 = 0.0f;
        this.m11 = 0.0f;
        this.m00 = 0.0f;
        this.m01 = -f;
        this.m02 = f2;
        this.m10 = f;
        this.m12 = -f3;
        this.m20 = -f2;
        this.m21 = f3;
        return this;
    }

    public Matrix3f lerp(Matrix3fc matrix3fc, float f) {
        return this.lerp(matrix3fc, f, this);
    }

    @Override
    public Matrix3f lerp(Matrix3fc matrix3fc, float f, Matrix3f matrix3f) {
        matrix3f.m00 = Math.fma(matrix3fc.m00() - this.m00, f, this.m00);
        matrix3f.m01 = Math.fma(matrix3fc.m01() - this.m01, f, this.m01);
        matrix3f.m02 = Math.fma(matrix3fc.m02() - this.m02, f, this.m02);
        matrix3f.m10 = Math.fma(matrix3fc.m10() - this.m10, f, this.m10);
        matrix3f.m11 = Math.fma(matrix3fc.m11() - this.m11, f, this.m11);
        matrix3f.m12 = Math.fma(matrix3fc.m12() - this.m12, f, this.m12);
        matrix3f.m20 = Math.fma(matrix3fc.m20() - this.m20, f, this.m20);
        matrix3f.m21 = Math.fma(matrix3fc.m21() - this.m21, f, this.m21);
        matrix3f.m22 = Math.fma(matrix3fc.m22() - this.m22, f, this.m22);
        return matrix3f;
    }

    @Override
    public Matrix3f rotateTowards(Vector3fc vector3fc, Vector3fc vector3fc2, Matrix3f matrix3f) {
        return this.rotateTowards(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), matrix3f);
    }

    public Matrix3f rotateTowards(Vector3fc vector3fc, Vector3fc vector3fc2) {
        return this.rotateTowards(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), this);
    }

    public Matrix3f rotateTowards(float f, float f2, float f3, float f4, float f5, float f6) {
        return this.rotateTowards(f, f2, f3, f4, f5, f6, this);
    }

    @Override
    public Matrix3f rotateTowards(float f, float f2, float f3, float f4, float f5, float f6, Matrix3f matrix3f) {
        float f7 = Math.invsqrt(f * f + f2 * f2 + f3 * f3);
        float f8 = f * f7;
        float f9 = f2 * f7;
        float f10 = f3 * f7;
        float f11 = f5 * f10 - f6 * f9;
        float f12 = f6 * f8 - f4 * f10;
        float f13 = f4 * f9 - f5 * f8;
        float f14 = Math.invsqrt(f11 * f11 + f12 * f12 + f13 * f13);
        float f15 = f9 * (f13 *= f14) - f10 * (f12 *= f14);
        float f16 = f10 * (f11 *= f14) - f8 * f13;
        float f17 = f8 * f12 - f9 * f11;
        float f18 = f11;
        float f19 = f12;
        float f20 = f13;
        float f21 = f15;
        float f22 = f16;
        float f23 = f17;
        float f24 = f8;
        float f25 = f9;
        float f26 = f10;
        float f27 = this.m00 * f18 + this.m10 * f19 + this.m20 * f20;
        float f28 = this.m01 * f18 + this.m11 * f19 + this.m21 * f20;
        float f29 = this.m02 * f18 + this.m12 * f19 + this.m22 * f20;
        float f30 = this.m00 * f21 + this.m10 * f22 + this.m20 * f23;
        float f31 = this.m01 * f21 + this.m11 * f22 + this.m21 * f23;
        float f32 = this.m02 * f21 + this.m12 * f22 + this.m22 * f23;
        matrix3f.m20 = this.m00 * f24 + this.m10 * f25 + this.m20 * f26;
        matrix3f.m21 = this.m01 * f24 + this.m11 * f25 + this.m21 * f26;
        matrix3f.m22 = this.m02 * f24 + this.m12 * f25 + this.m22 * f26;
        matrix3f.m00 = f27;
        matrix3f.m01 = f28;
        matrix3f.m02 = f29;
        matrix3f.m10 = f30;
        matrix3f.m11 = f31;
        matrix3f.m12 = f32;
        return matrix3f;
    }

    public Matrix3f rotationTowards(Vector3fc vector3fc, Vector3fc vector3fc2) {
        return this.rotationTowards(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z());
    }

    public Matrix3f rotationTowards(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = Math.invsqrt(f * f + f2 * f2 + f3 * f3);
        float f8 = f * f7;
        float f9 = f2 * f7;
        float f10 = f3 * f7;
        float f11 = f5 * f10 - f6 * f9;
        float f12 = f6 * f8 - f4 * f10;
        float f13 = f4 * f9 - f5 * f8;
        float f14 = Math.invsqrt(f11 * f11 + f12 * f12 + f13 * f13);
        float f15 = f9 * (f13 *= f14) - f10 * (f12 *= f14);
        float f16 = f10 * (f11 *= f14) - f8 * f13;
        float f17 = f8 * f12 - f9 * f11;
        this.m00 = f11;
        this.m01 = f12;
        this.m02 = f13;
        this.m10 = f15;
        this.m11 = f16;
        this.m12 = f17;
        this.m20 = f8;
        this.m21 = f9;
        this.m22 = f10;
        return this;
    }

    @Override
    public Vector3f getEulerAnglesZYX(Vector3f vector3f) {
        vector3f.x = Math.atan2(this.m12, this.m22);
        vector3f.y = Math.atan2(-this.m02, Math.sqrt(this.m12 * this.m12 + this.m22 * this.m22));
        vector3f.z = Math.atan2(this.m01, this.m00);
        return vector3f;
    }

    public Matrix3f obliqueZ(float f, float f2) {
        this.m20 = this.m00 * f + this.m10 * f2 + this.m20;
        this.m21 = this.m01 * f + this.m11 * f2 + this.m21;
        this.m22 = this.m02 * f + this.m12 * f2 + this.m22;
        return this;
    }

    @Override
    public Matrix3f obliqueZ(float f, float f2, Matrix3f matrix3f) {
        matrix3f.m00 = this.m00;
        matrix3f.m01 = this.m01;
        matrix3f.m02 = this.m02;
        matrix3f.m10 = this.m10;
        matrix3f.m11 = this.m11;
        matrix3f.m12 = this.m12;
        matrix3f.m20 = this.m00 * f + this.m10 * f2 + this.m20;
        matrix3f.m21 = this.m01 * f + this.m11 * f2 + this.m21;
        matrix3f.m22 = this.m02 * f + this.m12 * f2 + this.m22;
        return matrix3f;
    }

    @Override
    public Matrix3f reflect(float f, float f2, float f3, Matrix3f matrix3f) {
        float f4 = f + f;
        float f5 = f2 + f2;
        float f6 = f3 + f3;
        float f7 = 1.0f - f4 * f;
        float f8 = -f4 * f2;
        float f9 = -f4 * f3;
        float f10 = -f5 * f;
        float f11 = 1.0f - f5 * f2;
        float f12 = -f5 * f3;
        float f13 = -f6 * f;
        float f14 = -f6 * f2;
        float f15 = 1.0f - f6 * f3;
        float f16 = this.m00 * f7 + this.m10 * f8 + this.m20 * f9;
        float f17 = this.m01 * f7 + this.m11 * f8 + this.m21 * f9;
        float f18 = this.m02 * f7 + this.m12 * f8 + this.m22 * f9;
        float f19 = this.m00 * f10 + this.m10 * f11 + this.m20 * f12;
        float f20 = this.m01 * f10 + this.m11 * f11 + this.m21 * f12;
        float f21 = this.m02 * f10 + this.m12 * f11 + this.m22 * f12;
        return matrix3f._m20(this.m00 * f13 + this.m10 * f14 + this.m20 * f15)._m21(this.m01 * f13 + this.m11 * f14 + this.m21 * f15)._m22(this.m02 * f13 + this.m12 * f14 + this.m22 * f15)._m00(f16)._m01(f17)._m02(f18)._m10(f19)._m11(f20)._m12(f21);
    }

    public Matrix3f reflect(float f, float f2, float f3) {
        return this.reflect(f, f2, f3, this);
    }

    public Matrix3f reflect(Vector3fc vector3fc) {
        return this.reflect(vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public Matrix3f reflect(Quaternionfc quaternionfc) {
        return this.reflect(quaternionfc, this);
    }

    @Override
    public Matrix3f reflect(Quaternionfc quaternionfc, Matrix3f matrix3f) {
        float f = quaternionfc.x() + quaternionfc.x();
        float f2 = quaternionfc.y() + quaternionfc.y();
        float f3 = quaternionfc.z() + quaternionfc.z();
        float f4 = quaternionfc.x() * f3 + quaternionfc.w() * f2;
        float f5 = quaternionfc.y() * f3 - quaternionfc.w() * f;
        float f6 = 1.0f - (quaternionfc.x() * f + quaternionfc.y() * f2);
        return this.reflect(f4, f5, f6, matrix3f);
    }

    @Override
    public Matrix3f reflect(Vector3fc vector3fc, Matrix3f matrix3f) {
        return this.reflect(vector3fc.x(), vector3fc.y(), vector3fc.z(), matrix3f);
    }

    public Matrix3f reflection(float f, float f2, float f3) {
        float f4 = f + f;
        float f5 = f2 + f2;
        float f6 = f3 + f3;
        this._m00(1.0f - f4 * f);
        this._m01(-f4 * f2);
        this._m02(-f4 * f3);
        this._m10(-f5 * f);
        this._m11(1.0f - f5 * f2);
        this._m12(-f5 * f3);
        this._m20(-f6 * f);
        this._m21(-f6 * f2);
        this._m22(1.0f - f6 * f3);
        return this;
    }

    public Matrix3f reflection(Vector3fc vector3fc) {
        return this.reflection(vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public Matrix3f reflection(Quaternionfc quaternionfc) {
        float f = quaternionfc.x() + quaternionfc.x();
        float f2 = quaternionfc.y() + quaternionfc.y();
        float f3 = quaternionfc.z() + quaternionfc.z();
        float f4 = quaternionfc.x() * f3 + quaternionfc.w() * f2;
        float f5 = quaternionfc.y() * f3 - quaternionfc.w() * f;
        float f6 = 1.0f - (quaternionfc.x() * f + quaternionfc.y() * f2);
        return this.reflection(f4, f5, f6);
    }

    @Override
    public boolean isFinite() {
        return Math.isFinite(this.m00) && Math.isFinite(this.m01) && Math.isFinite(this.m02) && Math.isFinite(this.m10) && Math.isFinite(this.m11) && Math.isFinite(this.m12) && Math.isFinite(this.m20) && Math.isFinite(this.m21) && Math.isFinite(this.m22);
    }

    @Override
    public float quadraticFormProduct(float f, float f2, float f3) {
        float f4 = this.m00 * f + this.m10 * f2 + this.m20 * f3;
        float f5 = this.m01 * f + this.m11 * f2 + this.m21 * f3;
        float f6 = this.m02 * f + this.m12 * f2 + this.m22 * f3;
        return f * f4 + f2 * f5 + f3 * f6;
    }

    @Override
    public float quadraticFormProduct(Vector3fc vector3fc) {
        return this.quadraticFormProduct(vector3fc.x(), vector3fc.y(), vector3fc.z());
    }
}

