/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import org.joml.Math;
import org.joml.Matrix4fc;
import org.joml.Vector2fc;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class FrustumIntersection {
    public static final int PLANE_NX = 0;
    public static final int PLANE_PX = 1;
    public static final int PLANE_NY = 2;
    public static final int PLANE_PY = 3;
    public static final int PLANE_NZ = 4;
    public static final int PLANE_PZ = 5;
    public static final int INTERSECT = -1;
    public static final int INSIDE = -2;
    public static final int OUTSIDE = -3;
    public static final int PLANE_MASK_NX = 1;
    public static final int PLANE_MASK_PX = 2;
    public static final int PLANE_MASK_NY = 4;
    public static final int PLANE_MASK_PY = 8;
    public static final int PLANE_MASK_NZ = 16;
    public static final int PLANE_MASK_PZ = 32;
    private float nxX;
    private float nxY;
    private float nxZ;
    private float nxW;
    private float pxX;
    private float pxY;
    private float pxZ;
    private float pxW;
    private float nyX;
    private float nyY;
    private float nyZ;
    private float nyW;
    private float pyX;
    private float pyY;
    private float pyZ;
    private float pyW;
    private float nzX;
    private float nzY;
    private float nzZ;
    private float nzW;
    private float pzX;
    private float pzY;
    private float pzZ;
    private float pzW;
    private final Vector4f[] planes = new Vector4f[6];

    public FrustumIntersection() {
        for (int i = 0; i < 6; ++i) {
            this.planes[i] = new Vector4f();
        }
    }

    public FrustumIntersection(Matrix4fc matrix4fc) {
        for (int i = 0; i < 6; ++i) {
            this.planes[i] = new Vector4f();
        }
        this.set(matrix4fc, true);
    }

    public FrustumIntersection(Matrix4fc matrix4fc, boolean bl) {
        for (int i = 0; i < 6; ++i) {
            this.planes[i] = new Vector4f();
        }
        this.set(matrix4fc, bl);
    }

    public FrustumIntersection set(Matrix4fc matrix4fc) {
        return this.set(matrix4fc, true);
    }

    public FrustumIntersection set(Matrix4fc matrix4fc, boolean bl) {
        float f;
        this.nxX = matrix4fc.m03() + matrix4fc.m00();
        this.nxY = matrix4fc.m13() + matrix4fc.m10();
        this.nxZ = matrix4fc.m23() + matrix4fc.m20();
        this.nxW = matrix4fc.m33() + matrix4fc.m30();
        if (bl) {
            f = Math.invsqrt(this.nxX * this.nxX + this.nxY * this.nxY + this.nxZ * this.nxZ);
            this.nxX *= f;
            this.nxY *= f;
            this.nxZ *= f;
            this.nxW *= f;
        }
        this.planes[0].set(this.nxX, this.nxY, this.nxZ, this.nxW);
        this.pxX = matrix4fc.m03() - matrix4fc.m00();
        this.pxY = matrix4fc.m13() - matrix4fc.m10();
        this.pxZ = matrix4fc.m23() - matrix4fc.m20();
        this.pxW = matrix4fc.m33() - matrix4fc.m30();
        if (bl) {
            f = Math.invsqrt(this.pxX * this.pxX + this.pxY * this.pxY + this.pxZ * this.pxZ);
            this.pxX *= f;
            this.pxY *= f;
            this.pxZ *= f;
            this.pxW *= f;
        }
        this.planes[1].set(this.pxX, this.pxY, this.pxZ, this.pxW);
        this.nyX = matrix4fc.m03() + matrix4fc.m01();
        this.nyY = matrix4fc.m13() + matrix4fc.m11();
        this.nyZ = matrix4fc.m23() + matrix4fc.m21();
        this.nyW = matrix4fc.m33() + matrix4fc.m31();
        if (bl) {
            f = Math.invsqrt(this.nyX * this.nyX + this.nyY * this.nyY + this.nyZ * this.nyZ);
            this.nyX *= f;
            this.nyY *= f;
            this.nyZ *= f;
            this.nyW *= f;
        }
        this.planes[2].set(this.nyX, this.nyY, this.nyZ, this.nyW);
        this.pyX = matrix4fc.m03() - matrix4fc.m01();
        this.pyY = matrix4fc.m13() - matrix4fc.m11();
        this.pyZ = matrix4fc.m23() - matrix4fc.m21();
        this.pyW = matrix4fc.m33() - matrix4fc.m31();
        if (bl) {
            f = Math.invsqrt(this.pyX * this.pyX + this.pyY * this.pyY + this.pyZ * this.pyZ);
            this.pyX *= f;
            this.pyY *= f;
            this.pyZ *= f;
            this.pyW *= f;
        }
        this.planes[3].set(this.pyX, this.pyY, this.pyZ, this.pyW);
        this.nzX = matrix4fc.m03() + matrix4fc.m02();
        this.nzY = matrix4fc.m13() + matrix4fc.m12();
        this.nzZ = matrix4fc.m23() + matrix4fc.m22();
        this.nzW = matrix4fc.m33() + matrix4fc.m32();
        if (bl) {
            f = Math.invsqrt(this.nzX * this.nzX + this.nzY * this.nzY + this.nzZ * this.nzZ);
            this.nzX *= f;
            this.nzY *= f;
            this.nzZ *= f;
            this.nzW *= f;
        }
        this.planes[4].set(this.nzX, this.nzY, this.nzZ, this.nzW);
        this.pzX = matrix4fc.m03() - matrix4fc.m02();
        this.pzY = matrix4fc.m13() - matrix4fc.m12();
        this.pzZ = matrix4fc.m23() - matrix4fc.m22();
        this.pzW = matrix4fc.m33() - matrix4fc.m32();
        if (bl) {
            f = Math.invsqrt(this.pzX * this.pzX + this.pzY * this.pzY + this.pzZ * this.pzZ);
            this.pzX *= f;
            this.pzY *= f;
            this.pzZ *= f;
            this.pzW *= f;
        }
        this.planes[5].set(this.pzX, this.pzY, this.pzZ, this.pzW);
        return this;
    }

    public boolean testPoint(Vector3fc vector3fc) {
        return this.testPoint(vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public boolean testPoint(float f, float f2, float f3) {
        return this.nxX * f + this.nxY * f2 + this.nxZ * f3 + this.nxW >= 0.0f && this.pxX * f + this.pxY * f2 + this.pxZ * f3 + this.pxW >= 0.0f && this.nyX * f + this.nyY * f2 + this.nyZ * f3 + this.nyW >= 0.0f && this.pyX * f + this.pyY * f2 + this.pyZ * f3 + this.pyW >= 0.0f && this.nzX * f + this.nzY * f2 + this.nzZ * f3 + this.nzW >= 0.0f && this.pzX * f + this.pzY * f2 + this.pzZ * f3 + this.pzW >= 0.0f;
    }

    public boolean testSphere(Vector3fc vector3fc, float f) {
        return this.testSphere(vector3fc.x(), vector3fc.y(), vector3fc.z(), f);
    }

    public boolean testSphere(float f, float f2, float f3, float f4) {
        return this.nxX * f + this.nxY * f2 + this.nxZ * f3 + this.nxW >= -f4 && this.pxX * f + this.pxY * f2 + this.pxZ * f3 + this.pxW >= -f4 && this.nyX * f + this.nyY * f2 + this.nyZ * f3 + this.nyW >= -f4 && this.pyX * f + this.pyY * f2 + this.pyZ * f3 + this.pyW >= -f4 && this.nzX * f + this.nzY * f2 + this.nzZ * f3 + this.nzW >= -f4 && this.pzX * f + this.pzY * f2 + this.pzZ * f3 + this.pzW >= -f4;
    }

    public int intersectSphere(Vector3fc vector3fc, float f) {
        return this.intersectSphere(vector3fc.x(), vector3fc.y(), vector3fc.z(), f);
    }

    public int intersectSphere(float f, float f2, float f3, float f4) {
        boolean bl = true;
        float f5 = this.nxX * f + this.nxY * f2 + this.nxZ * f3 + this.nxW;
        if (f5 >= -f4) {
            bl &= f5 >= f4;
            f5 = this.pxX * f + this.pxY * f2 + this.pxZ * f3 + this.pxW;
            if (f5 >= -f4) {
                bl &= f5 >= f4;
                f5 = this.nyX * f + this.nyY * f2 + this.nyZ * f3 + this.nyW;
                if (f5 >= -f4) {
                    bl &= f5 >= f4;
                    f5 = this.pyX * f + this.pyY * f2 + this.pyZ * f3 + this.pyW;
                    if (f5 >= -f4) {
                        bl &= f5 >= f4;
                        f5 = this.nzX * f + this.nzY * f2 + this.nzZ * f3 + this.nzW;
                        if (f5 >= -f4) {
                            bl &= f5 >= f4;
                            f5 = this.pzX * f + this.pzY * f2 + this.pzZ * f3 + this.pzW;
                            if (f5 >= -f4) {
                                return (bl &= f5 >= f4) ? -2 : -1;
                            }
                        }
                    }
                }
            }
        }
        return -3;
    }

    public boolean testAab(Vector3fc vector3fc, Vector3fc vector3fc2) {
        return this.testAab(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean testAab(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = this.nxX * (this.nxX < 0.0f ? f : f4) + this.nxY * (this.nxY < 0.0f ? f2 : f5);
        float f8 = this.nxZ < 0.0f ? f3 : f6;
        if (!(f7 + this.nxZ * f8 >= -this.nxW)) return false;
        float f9 = this.pxX * (this.pxX < 0.0f ? f : f4) + this.pxY * (this.pxY < 0.0f ? f2 : f5);
        float f10 = this.pxZ < 0.0f ? f3 : f6;
        if (!(f9 + this.pxZ * f10 >= -this.pxW)) return false;
        float f11 = this.nyX * (this.nyX < 0.0f ? f : f4) + this.nyY * (this.nyY < 0.0f ? f2 : f5);
        float f12 = this.nyZ < 0.0f ? f3 : f6;
        if (!(f11 + this.nyZ * f12 >= -this.nyW)) return false;
        float f13 = this.pyX * (this.pyX < 0.0f ? f : f4) + this.pyY * (this.pyY < 0.0f ? f2 : f5);
        float f14 = this.pyZ < 0.0f ? f3 : f6;
        if (!(f13 + this.pyZ * f14 >= -this.pyW)) return false;
        float f15 = this.nzX * (this.nzX < 0.0f ? f : f4) + this.nzY * (this.nzY < 0.0f ? f2 : f5);
        float f16 = this.nzZ < 0.0f ? f3 : f6;
        if (!(f15 + this.nzZ * f16 >= -this.nzW)) return false;
        float f17 = this.pzX * (this.pzX < 0.0f ? f : f4) + this.pzY * (this.pzY < 0.0f ? f2 : f5);
        float f18 = this.pzZ < 0.0f ? f3 : f6;
        if (!(f17 + this.pzZ * f18 >= -this.pzW)) return false;
        return true;
    }

    public boolean testPlaneXY(Vector2fc vector2fc, Vector2fc vector2fc2) {
        return this.testPlaneXY(vector2fc.x(), vector2fc.y(), vector2fc2.x(), vector2fc2.y());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean testPlaneXY(float f, float f2, float f3, float f4) {
        float f5 = this.nxX * (this.nxX < 0.0f ? f : f3);
        float f6 = this.nxY < 0.0f ? f2 : f4;
        if (!(f5 + this.nxY * f6 >= -this.nxW)) return false;
        float f7 = this.pxX * (this.pxX < 0.0f ? f : f3);
        float f8 = this.pxY < 0.0f ? f2 : f4;
        if (!(f7 + this.pxY * f8 >= -this.pxW)) return false;
        float f9 = this.nyX * (this.nyX < 0.0f ? f : f3);
        float f10 = this.nyY < 0.0f ? f2 : f4;
        if (!(f9 + this.nyY * f10 >= -this.nyW)) return false;
        float f11 = this.pyX * (this.pyX < 0.0f ? f : f3);
        float f12 = this.pyY < 0.0f ? f2 : f4;
        if (!(f11 + this.pyY * f12 >= -this.pyW)) return false;
        float f13 = this.nzX * (this.nzX < 0.0f ? f : f3);
        float f14 = this.nzY < 0.0f ? f2 : f4;
        if (!(f13 + this.nzY * f14 >= -this.nzW)) return false;
        float f15 = this.pzX * (this.pzX < 0.0f ? f : f3);
        float f16 = this.pzY < 0.0f ? f2 : f4;
        if (!(f15 + this.pzY * f16 >= -this.pzW)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean testPlaneXZ(float f, float f2, float f3, float f4) {
        float f5 = this.nxX * (this.nxX < 0.0f ? f : f3);
        float f6 = this.nxZ < 0.0f ? f2 : f4;
        if (!(f5 + this.nxZ * f6 >= -this.nxW)) return false;
        float f7 = this.pxX * (this.pxX < 0.0f ? f : f3);
        float f8 = this.pxZ < 0.0f ? f2 : f4;
        if (!(f7 + this.pxZ * f8 >= -this.pxW)) return false;
        float f9 = this.nyX * (this.nyX < 0.0f ? f : f3);
        float f10 = this.nyZ < 0.0f ? f2 : f4;
        if (!(f9 + this.nyZ * f10 >= -this.nyW)) return false;
        float f11 = this.pyX * (this.pyX < 0.0f ? f : f3);
        float f12 = this.pyZ < 0.0f ? f2 : f4;
        if (!(f11 + this.pyZ * f12 >= -this.pyW)) return false;
        float f13 = this.nzX * (this.nzX < 0.0f ? f : f3);
        float f14 = this.nzZ < 0.0f ? f2 : f4;
        if (!(f13 + this.nzZ * f14 >= -this.nzW)) return false;
        float f15 = this.pzX * (this.pzX < 0.0f ? f : f3);
        float f16 = this.pzZ < 0.0f ? f2 : f4;
        if (!(f15 + this.pzZ * f16 >= -this.pzW)) return false;
        return true;
    }

    public int intersectAab(Vector3fc vector3fc, Vector3fc vector3fc2) {
        return this.intersectAab(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z());
    }

    public int intersectAab(float f, float f2, float f3, float f4, float f5, float f6) {
        int n = 0;
        boolean bl = true;
        float f7 = this.nxX * (this.nxX < 0.0f ? f : f4) + this.nxY * (this.nxY < 0.0f ? f2 : f5);
        float f8 = this.nxZ < 0.0f ? f3 : f6;
        if (f7 + this.nxZ * f8 >= -this.nxW) {
            n = 1;
            bl &= this.nxX * (this.nxX < 0.0f ? f4 : f) + this.nxY * (this.nxY < 0.0f ? f5 : f2) + this.nxZ * (this.nxZ < 0.0f ? f6 : f3) >= -this.nxW;
            float f9 = this.pxX * (this.pxX < 0.0f ? f : f4) + this.pxY * (this.pxY < 0.0f ? f2 : f5);
            float f10 = this.pxZ < 0.0f ? f3 : f6;
            if (f9 + this.pxZ * f10 >= -this.pxW) {
                n = 2;
                bl &= this.pxX * (this.pxX < 0.0f ? f4 : f) + this.pxY * (this.pxY < 0.0f ? f5 : f2) + this.pxZ * (this.pxZ < 0.0f ? f6 : f3) >= -this.pxW;
                float f11 = this.nyX * (this.nyX < 0.0f ? f : f4) + this.nyY * (this.nyY < 0.0f ? f2 : f5);
                float f12 = this.nyZ < 0.0f ? f3 : f6;
                if (f11 + this.nyZ * f12 >= -this.nyW) {
                    n = 3;
                    bl &= this.nyX * (this.nyX < 0.0f ? f4 : f) + this.nyY * (this.nyY < 0.0f ? f5 : f2) + this.nyZ * (this.nyZ < 0.0f ? f6 : f3) >= -this.nyW;
                    float f13 = this.pyX * (this.pyX < 0.0f ? f : f4) + this.pyY * (this.pyY < 0.0f ? f2 : f5);
                    float f14 = this.pyZ < 0.0f ? f3 : f6;
                    if (f13 + this.pyZ * f14 >= -this.pyW) {
                        n = 4;
                        bl &= this.pyX * (this.pyX < 0.0f ? f4 : f) + this.pyY * (this.pyY < 0.0f ? f5 : f2) + this.pyZ * (this.pyZ < 0.0f ? f6 : f3) >= -this.pyW;
                        float f15 = this.nzX * (this.nzX < 0.0f ? f : f4) + this.nzY * (this.nzY < 0.0f ? f2 : f5);
                        float f16 = this.nzZ < 0.0f ? f3 : f6;
                        if (f15 + this.nzZ * f16 >= -this.nzW) {
                            n = 5;
                            bl &= this.nzX * (this.nzX < 0.0f ? f4 : f) + this.nzY * (this.nzY < 0.0f ? f5 : f2) + this.nzZ * (this.nzZ < 0.0f ? f6 : f3) >= -this.nzW;
                            float f17 = this.pzX * (this.pzX < 0.0f ? f : f4) + this.pzY * (this.pzY < 0.0f ? f2 : f5);
                            float f18 = this.pzZ < 0.0f ? f3 : f6;
                            if (f17 + this.pzZ * f18 >= -this.pzW) {
                                return (bl &= this.pzX * (this.pzX < 0.0f ? f4 : f) + this.pzY * (this.pzY < 0.0f ? f5 : f2) + this.pzZ * (this.pzZ < 0.0f ? f6 : f3) >= -this.pzW) ? -2 : -1;
                            }
                        }
                    }
                }
            }
        }
        return n;
    }

    public float distanceToPlane(float f, float f2, float f3, float f4, float f5, float f6, int n) {
        return this.planes[n].x * (this.planes[n].x < 0.0f ? f4 : f) + this.planes[n].y * (this.planes[n].y < 0.0f ? f5 : f2) + this.planes[n].z * (this.planes[n].z < 0.0f ? f6 : f3) + this.planes[n].w;
    }

    public int intersectAab(Vector3fc vector3fc, Vector3fc vector3fc2, int n) {
        return this.intersectAab(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), n);
    }

    public int intersectAab(float f, float f2, float f3, float f4, float f5, float f6, int n) {
        int n2;
        block3: {
            block8: {
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    n2 = 0;
                                    boolean bl = true;
                                    if ((n & 1) == 0) break block2;
                                    float f7 = this.nxX * (this.nxX < 0.0f ? f : f4) + this.nxY * (this.nxY < 0.0f ? f2 : f5);
                                    float f8 = this.nxZ < 0.0f ? f3 : f6;
                                    if (!(f7 + this.nxZ * f8 >= -this.nxW)) break block3;
                                }
                                n2 = 1;
                                bl &= this.nxX * (this.nxX < 0.0f ? f4 : f) + this.nxY * (this.nxY < 0.0f ? f5 : f2) + this.nxZ * (this.nxZ < 0.0f ? f6 : f3) >= -this.nxW;
                                if ((n & 2) == 0) break block4;
                                float f9 = this.pxX * (this.pxX < 0.0f ? f : f4) + this.pxY * (this.pxY < 0.0f ? f2 : f5);
                                float f10 = this.pxZ < 0.0f ? f3 : f6;
                                if (!(f9 + this.pxZ * f10 >= -this.pxW)) break block3;
                            }
                            n2 = 2;
                            bl &= this.pxX * (this.pxX < 0.0f ? f4 : f) + this.pxY * (this.pxY < 0.0f ? f5 : f2) + this.pxZ * (this.pxZ < 0.0f ? f6 : f3) >= -this.pxW;
                            if ((n & 4) == 0) break block5;
                            float f11 = this.nyX * (this.nyX < 0.0f ? f : f4) + this.nyY * (this.nyY < 0.0f ? f2 : f5);
                            float f12 = this.nyZ < 0.0f ? f3 : f6;
                            if (!(f11 + this.nyZ * f12 >= -this.nyW)) break block3;
                        }
                        n2 = 3;
                        bl &= this.nyX * (this.nyX < 0.0f ? f4 : f) + this.nyY * (this.nyY < 0.0f ? f5 : f2) + this.nyZ * (this.nyZ < 0.0f ? f6 : f3) >= -this.nyW;
                        if ((n & 8) == 0) break block6;
                        float f13 = this.pyX * (this.pyX < 0.0f ? f : f4) + this.pyY * (this.pyY < 0.0f ? f2 : f5);
                        float f14 = this.pyZ < 0.0f ? f3 : f6;
                        if (!(f13 + this.pyZ * f14 >= -this.pyW)) break block3;
                    }
                    n2 = 4;
                    bl &= this.pyX * (this.pyX < 0.0f ? f4 : f) + this.pyY * (this.pyY < 0.0f ? f5 : f2) + this.pyZ * (this.pyZ < 0.0f ? f6 : f3) >= -this.pyW;
                    if ((n & 0x10) == 0) break block7;
                    float f15 = this.nzX * (this.nzX < 0.0f ? f : f4) + this.nzY * (this.nzY < 0.0f ? f2 : f5);
                    float f16 = this.nzZ < 0.0f ? f3 : f6;
                    if (!(f15 + this.nzZ * f16 >= -this.nzW)) break block3;
                }
                n2 = 5;
                bl &= this.nzX * (this.nzX < 0.0f ? f4 : f) + this.nzY * (this.nzY < 0.0f ? f5 : f2) + this.nzZ * (this.nzZ < 0.0f ? f6 : f3) >= -this.nzW;
                if ((n & 0x20) == 0) break block8;
                float f17 = this.pzX * (this.pzX < 0.0f ? f : f4) + this.pzY * (this.pzY < 0.0f ? f2 : f5);
                float f18 = this.pzZ < 0.0f ? f3 : f6;
                if (!(f17 + this.pzZ * f18 >= -this.pzW)) break block3;
            }
            return (bl &= this.pzX * (this.pzX < 0.0f ? f4 : f) + this.pzY * (this.pzY < 0.0f ? f5 : f2) + this.pzZ * (this.pzZ < 0.0f ? f6 : f3) >= -this.pzW) ? -2 : -1;
        }
        return n2;
    }

    public int intersectAab(Vector3fc vector3fc, Vector3fc vector3fc2, int n, int n2) {
        return this.intersectAab(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), n, n2);
    }

    public int intersectAab(float f, float f2, float f3, float f4, float f5, float f6, int n, int n2) {
        int n3;
        block6: {
            block11: {
                block10: {
                    block9: {
                        block8: {
                            block7: {
                                block5: {
                                    n3 = n2;
                                    boolean bl = true;
                                    Vector4f vector4f = this.planes[n2];
                                    if ((n & 1 << n2) != 0) {
                                        float f7 = vector4f.x * (vector4f.x < 0.0f ? f : f4) + vector4f.y * (vector4f.y < 0.0f ? f2 : f5);
                                        float f8 = vector4f.z;
                                        float f9 = vector4f.z < 0.0f ? f3 : f6;
                                        if (f7 + f8 * f9 < -vector4f.w) {
                                            return n3;
                                        }
                                    }
                                    if ((n & 1) == 0) break block5;
                                    float f10 = this.nxX * (this.nxX < 0.0f ? f : f4) + this.nxY * (this.nxY < 0.0f ? f2 : f5);
                                    float f11 = this.nxZ < 0.0f ? f3 : f6;
                                    if (!(f10 + this.nxZ * f11 >= -this.nxW)) break block6;
                                }
                                n3 = 1;
                                bl &= this.nxX * (this.nxX < 0.0f ? f4 : f) + this.nxY * (this.nxY < 0.0f ? f5 : f2) + this.nxZ * (this.nxZ < 0.0f ? f6 : f3) >= -this.nxW;
                                if ((n & 2) == 0) break block7;
                                float f12 = this.pxX * (this.pxX < 0.0f ? f : f4) + this.pxY * (this.pxY < 0.0f ? f2 : f5);
                                float f13 = this.pxZ < 0.0f ? f3 : f6;
                                if (!(f12 + this.pxZ * f13 >= -this.pxW)) break block6;
                            }
                            n3 = 2;
                            bl &= this.pxX * (this.pxX < 0.0f ? f4 : f) + this.pxY * (this.pxY < 0.0f ? f5 : f2) + this.pxZ * (this.pxZ < 0.0f ? f6 : f3) >= -this.pxW;
                            if ((n & 4) == 0) break block8;
                            float f14 = this.nyX * (this.nyX < 0.0f ? f : f4) + this.nyY * (this.nyY < 0.0f ? f2 : f5);
                            float f15 = this.nyZ < 0.0f ? f3 : f6;
                            if (!(f14 + this.nyZ * f15 >= -this.nyW)) break block6;
                        }
                        n3 = 3;
                        bl &= this.nyX * (this.nyX < 0.0f ? f4 : f) + this.nyY * (this.nyY < 0.0f ? f5 : f2) + this.nyZ * (this.nyZ < 0.0f ? f6 : f3) >= -this.nyW;
                        if ((n & 8) == 0) break block9;
                        float f16 = this.pyX * (this.pyX < 0.0f ? f : f4) + this.pyY * (this.pyY < 0.0f ? f2 : f5);
                        float f17 = this.pyZ < 0.0f ? f3 : f6;
                        if (!(f16 + this.pyZ * f17 >= -this.pyW)) break block6;
                    }
                    n3 = 4;
                    bl &= this.pyX * (this.pyX < 0.0f ? f4 : f) + this.pyY * (this.pyY < 0.0f ? f5 : f2) + this.pyZ * (this.pyZ < 0.0f ? f6 : f3) >= -this.pyW;
                    if ((n & 0x10) == 0) break block10;
                    float f18 = this.nzX * (this.nzX < 0.0f ? f : f4) + this.nzY * (this.nzY < 0.0f ? f2 : f5);
                    float f19 = this.nzZ < 0.0f ? f3 : f6;
                    if (!(f18 + this.nzZ * f19 >= -this.nzW)) break block6;
                }
                n3 = 5;
                bl &= this.nzX * (this.nzX < 0.0f ? f4 : f) + this.nzY * (this.nzY < 0.0f ? f5 : f2) + this.nzZ * (this.nzZ < 0.0f ? f6 : f3) >= -this.nzW;
                if ((n & 0x20) == 0) break block11;
                float f20 = this.pzX * (this.pzX < 0.0f ? f : f4) + this.pzY * (this.pzY < 0.0f ? f2 : f5);
                float f21 = this.pzZ < 0.0f ? f3 : f6;
                if (!(f20 + this.pzZ * f21 >= -this.pzW)) break block6;
            }
            return (bl &= this.pzX * (this.pzX < 0.0f ? f4 : f) + this.pzY * (this.pzY < 0.0f ? f5 : f2) + this.pzZ * (this.pzZ < 0.0f ? f6 : f3) >= -this.pzW) ? -2 : -1;
        }
        return n3;
    }
}

