/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.NumberFormat;
import org.joml.AxisAngle4d;
import org.joml.Math;
import org.joml.Matrix3d;
import org.joml.Matrix3dc;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Matrix4x3fc;
import org.joml.Options;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Runtime;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class AxisAngle4f
implements Externalizable {
    private static final long serialVersionUID = 1L;
    public float angle;
    public float x;
    public float y;
    public float z;

    public AxisAngle4f() {
        this.z = 1.0f;
    }

    public AxisAngle4f(AxisAngle4f axisAngle4f) {
        this.x = axisAngle4f.x;
        this.y = axisAngle4f.y;
        this.z = axisAngle4f.z;
        this.angle = (float)(((double)axisAngle4f.angle < 0.0 ? java.lang.Math.PI * 2 + (double)axisAngle4f.angle % (java.lang.Math.PI * 2) : (double)axisAngle4f.angle) % (java.lang.Math.PI * 2));
    }

    public AxisAngle4f(Quaternionfc quaternionfc) {
        float f = Math.safeAcos(quaternionfc.w());
        float f2 = Math.invsqrt(1.0f - quaternionfc.w() * quaternionfc.w());
        if (Float.isInfinite(f2)) {
            this.x = 0.0f;
            this.y = 0.0f;
            this.z = 1.0f;
        } else {
            this.x = quaternionfc.x() * f2;
            this.y = quaternionfc.y() * f2;
            this.z = quaternionfc.z() * f2;
        }
        this.angle = f + f;
    }

    public AxisAngle4f(float f, float f2, float f3, float f4) {
        this.x = f2;
        this.y = f3;
        this.z = f4;
        this.angle = (float)(((double)f < 0.0 ? java.lang.Math.PI * 2 + (double)f % (java.lang.Math.PI * 2) : (double)f) % (java.lang.Math.PI * 2));
    }

    public AxisAngle4f(float f, Vector3fc vector3fc) {
        this(f, vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public AxisAngle4f set(AxisAngle4f axisAngle4f) {
        this.x = axisAngle4f.x;
        this.y = axisAngle4f.y;
        this.z = axisAngle4f.z;
        this.angle = axisAngle4f.angle;
        this.angle = (float)(((double)this.angle < 0.0 ? java.lang.Math.PI * 2 + (double)this.angle % (java.lang.Math.PI * 2) : (double)this.angle) % (java.lang.Math.PI * 2));
        return this;
    }

    public AxisAngle4f set(AxisAngle4d axisAngle4d) {
        this.x = (float)axisAngle4d.x;
        this.y = (float)axisAngle4d.y;
        this.z = (float)axisAngle4d.z;
        this.angle = (float)axisAngle4d.angle;
        this.angle = (float)(((double)this.angle < 0.0 ? java.lang.Math.PI * 2 + (double)this.angle % (java.lang.Math.PI * 2) : (double)this.angle) % (java.lang.Math.PI * 2));
        return this;
    }

    public AxisAngle4f set(float f, float f2, float f3, float f4) {
        this.x = f2;
        this.y = f3;
        this.z = f4;
        this.angle = (float)(((double)f < 0.0 ? java.lang.Math.PI * 2 + (double)f % (java.lang.Math.PI * 2) : (double)f) % (java.lang.Math.PI * 2));
        return this;
    }

    public AxisAngle4f set(float f, Vector3fc vector3fc) {
        return this.set(f, vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public AxisAngle4f set(Quaternionfc quaternionfc) {
        float f = Math.safeAcos(quaternionfc.w());
        float f2 = Math.invsqrt(1.0f - quaternionfc.w() * quaternionfc.w());
        if (Float.isInfinite(f2)) {
            this.x = 0.0f;
            this.y = 0.0f;
            this.z = 1.0f;
        } else {
            this.x = quaternionfc.x() * f2;
            this.y = quaternionfc.y() * f2;
            this.z = quaternionfc.z() * f2;
        }
        this.angle = f + f;
        return this;
    }

    public AxisAngle4f set(Quaterniondc quaterniondc) {
        double d = Math.safeAcos(quaterniondc.w());
        double d2 = Math.invsqrt(1.0 - quaterniondc.w() * quaterniondc.w());
        if (Double.isInfinite(d2)) {
            this.x = 0.0f;
            this.y = 0.0f;
            this.z = 1.0f;
        } else {
            this.x = (float)(quaterniondc.x() * d2);
            this.y = (float)(quaterniondc.y() * d2);
            this.z = (float)(quaterniondc.z() * d2);
        }
        this.angle = (float)(d + d);
        return this;
    }

    public AxisAngle4f set(Matrix3fc matrix3fc) {
        float f = matrix3fc.m00();
        float f2 = matrix3fc.m01();
        float f3 = matrix3fc.m02();
        float f4 = matrix3fc.m10();
        float f5 = matrix3fc.m11();
        float f6 = matrix3fc.m12();
        float f7 = matrix3fc.m20();
        float f8 = matrix3fc.m21();
        float f9 = matrix3fc.m22();
        float f10 = Math.invsqrt(matrix3fc.m00() * matrix3fc.m00() + matrix3fc.m01() * matrix3fc.m01() + matrix3fc.m02() * matrix3fc.m02());
        float f11 = Math.invsqrt(matrix3fc.m10() * matrix3fc.m10() + matrix3fc.m11() * matrix3fc.m11() + matrix3fc.m12() * matrix3fc.m12());
        float f12 = Math.invsqrt(matrix3fc.m20() * matrix3fc.m20() + matrix3fc.m21() * matrix3fc.m21() + matrix3fc.m22() * matrix3fc.m22());
        f *= f10;
        f2 *= f10;
        f3 *= f10;
        f4 *= f11;
        f5 *= f11;
        f6 *= f11;
        f7 *= f12;
        f8 *= f12;
        f9 *= f12;
        float f13 = 1.0E-4f;
        float f14 = 0.001f;
        if (Math.abs(f4 - f2) < f13 && Math.abs(f7 - f3) < f13 && Math.abs(f8 - f6) < f13) {
            if (Math.abs(f4 + f2) < f14 && Math.abs(f7 + f3) < f14 && Math.abs(f8 + f6) < f14 && Math.abs(f + f5 + f9 - 3.0f) < f14) {
                this.x = 0.0f;
                this.y = 0.0f;
                this.z = 1.0f;
                this.angle = 0.0f;
                return this;
            }
            this.angle = (float)java.lang.Math.PI;
            float f15 = (f + 1.0f) / 2.0f;
            float f16 = (f5 + 1.0f) / 2.0f;
            float f17 = (f9 + 1.0f) / 2.0f;
            float f18 = (f4 + f2) / 4.0f;
            float f19 = (f7 + f3) / 4.0f;
            float f20 = (f8 + f6) / 4.0f;
            if (f15 > f16 && f15 > f17) {
                this.x = Math.sqrt(f15);
                this.y = f18 / this.x;
                this.z = f19 / this.x;
            } else if (f16 > f17) {
                this.y = Math.sqrt(f16);
                this.x = f18 / this.y;
                this.z = f20 / this.y;
            } else {
                this.z = Math.sqrt(f17);
                this.x = f19 / this.z;
                this.y = f20 / this.z;
            }
            return this;
        }
        float f21 = Math.sqrt((f6 - f8) * (f6 - f8) + (f7 - f3) * (f7 - f3) + (f2 - f4) * (f2 - f4));
        this.angle = Math.safeAcos((f + f5 + f9 - 1.0f) / 2.0f);
        this.x = (f6 - f8) / f21;
        this.y = (f7 - f3) / f21;
        this.z = (f2 - f4) / f21;
        return this;
    }

    public AxisAngle4f set(Matrix3dc matrix3dc) {
        double d = matrix3dc.m00();
        double d2 = matrix3dc.m01();
        double d3 = matrix3dc.m02();
        double d4 = matrix3dc.m10();
        double d5 = matrix3dc.m11();
        double d6 = matrix3dc.m12();
        double d7 = matrix3dc.m20();
        double d8 = matrix3dc.m21();
        double d9 = matrix3dc.m22();
        double d10 = Math.invsqrt(matrix3dc.m00() * matrix3dc.m00() + matrix3dc.m01() * matrix3dc.m01() + matrix3dc.m02() * matrix3dc.m02());
        double d11 = Math.invsqrt(matrix3dc.m10() * matrix3dc.m10() + matrix3dc.m11() * matrix3dc.m11() + matrix3dc.m12() * matrix3dc.m12());
        double d12 = Math.invsqrt(matrix3dc.m20() * matrix3dc.m20() + matrix3dc.m21() * matrix3dc.m21() + matrix3dc.m22() * matrix3dc.m22());
        d *= d10;
        d2 *= d10;
        d3 *= d10;
        d4 *= d11;
        d5 *= d11;
        d6 *= d11;
        d7 *= d12;
        d8 *= d12;
        d9 *= d12;
        double d13 = 1.0E-4;
        double d14 = 0.001;
        if (Math.abs(d4 - d2) < d13 && Math.abs(d7 - d3) < d13 && Math.abs(d8 - d6) < d13) {
            if (Math.abs(d4 + d2) < d14 && Math.abs(d7 + d3) < d14 && Math.abs(d8 + d6) < d14 && Math.abs(d + d5 + d9 - 3.0) < d14) {
                this.x = 0.0f;
                this.y = 0.0f;
                this.z = 1.0f;
                this.angle = 0.0f;
                return this;
            }
            this.angle = (float)java.lang.Math.PI;
            double d15 = (d + 1.0) / 2.0;
            double d16 = (d5 + 1.0) / 2.0;
            double d17 = (d9 + 1.0) / 2.0;
            double d18 = (d4 + d2) / 4.0;
            double d19 = (d7 + d3) / 4.0;
            double d20 = (d8 + d6) / 4.0;
            if (d15 > d16 && d15 > d17) {
                this.x = (float)Math.sqrt(d15);
                this.y = (float)(d18 / (double)this.x);
                this.z = (float)(d19 / (double)this.x);
            } else if (d16 > d17) {
                this.y = (float)Math.sqrt(d16);
                this.x = (float)(d18 / (double)this.y);
                this.z = (float)(d20 / (double)this.y);
            } else {
                this.z = (float)Math.sqrt(d17);
                this.x = (float)(d19 / (double)this.z);
                this.y = (float)(d20 / (double)this.z);
            }
            return this;
        }
        double d21 = Math.sqrt((d6 - d8) * (d6 - d8) + (d7 - d3) * (d7 - d3) + (d2 - d4) * (d2 - d4));
        this.angle = (float)Math.safeAcos((d + d5 + d9 - 1.0) / 2.0);
        this.x = (float)((d6 - d8) / d21);
        this.y = (float)((d7 - d3) / d21);
        this.z = (float)((d2 - d4) / d21);
        return this;
    }

    public AxisAngle4f set(Matrix4fc matrix4fc) {
        float f = matrix4fc.m00();
        float f2 = matrix4fc.m01();
        float f3 = matrix4fc.m02();
        float f4 = matrix4fc.m10();
        float f5 = matrix4fc.m11();
        float f6 = matrix4fc.m12();
        float f7 = matrix4fc.m20();
        float f8 = matrix4fc.m21();
        float f9 = matrix4fc.m22();
        float f10 = Math.invsqrt(matrix4fc.m00() * matrix4fc.m00() + matrix4fc.m01() * matrix4fc.m01() + matrix4fc.m02() * matrix4fc.m02());
        float f11 = Math.invsqrt(matrix4fc.m10() * matrix4fc.m10() + matrix4fc.m11() * matrix4fc.m11() + matrix4fc.m12() * matrix4fc.m12());
        float f12 = Math.invsqrt(matrix4fc.m20() * matrix4fc.m20() + matrix4fc.m21() * matrix4fc.m21() + matrix4fc.m22() * matrix4fc.m22());
        f *= f10;
        f2 *= f10;
        f3 *= f10;
        f4 *= f11;
        f5 *= f11;
        f6 *= f11;
        f7 *= f12;
        f8 *= f12;
        f9 *= f12;
        float f13 = 1.0E-4f;
        float f14 = 0.001f;
        if (Math.abs(f4 - f2) < f13 && Math.abs(f7 - f3) < f13 && Math.abs(f8 - f6) < f13) {
            if (Math.abs(f4 + f2) < f14 && Math.abs(f7 + f3) < f14 && Math.abs(f8 + f6) < f14 && Math.abs(f + f5 + f9 - 3.0f) < f14) {
                this.x = 0.0f;
                this.y = 0.0f;
                this.z = 1.0f;
                this.angle = 0.0f;
                return this;
            }
            this.angle = (float)java.lang.Math.PI;
            float f15 = (f + 1.0f) / 2.0f;
            float f16 = (f5 + 1.0f) / 2.0f;
            float f17 = (f9 + 1.0f) / 2.0f;
            float f18 = (f4 + f2) / 4.0f;
            float f19 = (f7 + f3) / 4.0f;
            float f20 = (f8 + f6) / 4.0f;
            if (f15 > f16 && f15 > f17) {
                this.x = Math.sqrt(f15);
                this.y = f18 / this.x;
                this.z = f19 / this.x;
            } else if (f16 > f17) {
                this.y = Math.sqrt(f16);
                this.x = f18 / this.y;
                this.z = f20 / this.y;
            } else {
                this.z = Math.sqrt(f17);
                this.x = f19 / this.z;
                this.y = f20 / this.z;
            }
            return this;
        }
        float f21 = Math.sqrt((f6 - f8) * (f6 - f8) + (f7 - f3) * (f7 - f3) + (f2 - f4) * (f2 - f4));
        this.angle = Math.safeAcos((f + f5 + f9 - 1.0f) / 2.0f);
        this.x = (f6 - f8) / f21;
        this.y = (f7 - f3) / f21;
        this.z = (f2 - f4) / f21;
        return this;
    }

    public AxisAngle4f set(Matrix4x3fc matrix4x3fc) {
        float f = matrix4x3fc.m00();
        float f2 = matrix4x3fc.m01();
        float f3 = matrix4x3fc.m02();
        float f4 = matrix4x3fc.m10();
        float f5 = matrix4x3fc.m11();
        float f6 = matrix4x3fc.m12();
        float f7 = matrix4x3fc.m20();
        float f8 = matrix4x3fc.m21();
        float f9 = matrix4x3fc.m22();
        float f10 = Math.invsqrt(matrix4x3fc.m00() * matrix4x3fc.m00() + matrix4x3fc.m01() * matrix4x3fc.m01() + matrix4x3fc.m02() * matrix4x3fc.m02());
        float f11 = Math.invsqrt(matrix4x3fc.m10() * matrix4x3fc.m10() + matrix4x3fc.m11() * matrix4x3fc.m11() + matrix4x3fc.m12() * matrix4x3fc.m12());
        float f12 = Math.invsqrt(matrix4x3fc.m20() * matrix4x3fc.m20() + matrix4x3fc.m21() * matrix4x3fc.m21() + matrix4x3fc.m22() * matrix4x3fc.m22());
        f *= f10;
        f2 *= f10;
        f3 *= f10;
        f4 *= f11;
        f5 *= f11;
        f6 *= f11;
        f7 *= f12;
        f8 *= f12;
        f9 *= f12;
        float f13 = 1.0E-4f;
        float f14 = 0.001f;
        if (Math.abs(f4 - f2) < f13 && Math.abs(f7 - f3) < f13 && Math.abs(f8 - f6) < f13) {
            if (Math.abs(f4 + f2) < f14 && Math.abs(f7 + f3) < f14 && Math.abs(f8 + f6) < f14 && Math.abs(f + f5 + f9 - 3.0f) < f14) {
                this.x = 0.0f;
                this.y = 0.0f;
                this.z = 1.0f;
                this.angle = 0.0f;
                return this;
            }
            this.angle = (float)java.lang.Math.PI;
            float f15 = (f + 1.0f) / 2.0f;
            float f16 = (f5 + 1.0f) / 2.0f;
            float f17 = (f9 + 1.0f) / 2.0f;
            float f18 = (f4 + f2) / 4.0f;
            float f19 = (f7 + f3) / 4.0f;
            float f20 = (f8 + f6) / 4.0f;
            if (f15 > f16 && f15 > f17) {
                this.x = Math.sqrt(f15);
                this.y = f18 / this.x;
                this.z = f19 / this.x;
            } else if (f16 > f17) {
                this.y = Math.sqrt(f16);
                this.x = f18 / this.y;
                this.z = f20 / this.y;
            } else {
                this.z = Math.sqrt(f17);
                this.x = f19 / this.z;
                this.y = f20 / this.z;
            }
            return this;
        }
        float f21 = Math.sqrt((f6 - f8) * (f6 - f8) + (f7 - f3) * (f7 - f3) + (f2 - f4) * (f2 - f4));
        this.angle = Math.safeAcos((f + f5 + f9 - 1.0f) / 2.0f);
        this.x = (f6 - f8) / f21;
        this.y = (f7 - f3) / f21;
        this.z = (f2 - f4) / f21;
        return this;
    }

    public AxisAngle4f set(Matrix4dc matrix4dc) {
        double d = matrix4dc.m00();
        double d2 = matrix4dc.m01();
        double d3 = matrix4dc.m02();
        double d4 = matrix4dc.m10();
        double d5 = matrix4dc.m11();
        double d6 = matrix4dc.m12();
        double d7 = matrix4dc.m20();
        double d8 = matrix4dc.m21();
        double d9 = matrix4dc.m22();
        double d10 = Math.invsqrt(matrix4dc.m00() * matrix4dc.m00() + matrix4dc.m01() * matrix4dc.m01() + matrix4dc.m02() * matrix4dc.m02());
        double d11 = Math.invsqrt(matrix4dc.m10() * matrix4dc.m10() + matrix4dc.m11() * matrix4dc.m11() + matrix4dc.m12() * matrix4dc.m12());
        double d12 = Math.invsqrt(matrix4dc.m20() * matrix4dc.m20() + matrix4dc.m21() * matrix4dc.m21() + matrix4dc.m22() * matrix4dc.m22());
        d *= d10;
        d2 *= d10;
        d3 *= d10;
        d4 *= d11;
        d5 *= d11;
        d6 *= d11;
        d7 *= d12;
        d8 *= d12;
        d9 *= d12;
        double d13 = 1.0E-4;
        double d14 = 0.001;
        if (Math.abs(d4 - d2) < d13 && Math.abs(d7 - d3) < d13 && Math.abs(d8 - d6) < d13) {
            if (Math.abs(d4 + d2) < d14 && Math.abs(d7 + d3) < d14 && Math.abs(d8 + d6) < d14 && Math.abs(d + d5 + d9 - 3.0) < d14) {
                this.x = 0.0f;
                this.y = 0.0f;
                this.z = 1.0f;
                this.angle = 0.0f;
                return this;
            }
            this.angle = (float)java.lang.Math.PI;
            double d15 = (d + 1.0) / 2.0;
            double d16 = (d5 + 1.0) / 2.0;
            double d17 = (d9 + 1.0) / 2.0;
            double d18 = (d4 + d2) / 4.0;
            double d19 = (d7 + d3) / 4.0;
            double d20 = (d8 + d6) / 4.0;
            if (d15 > d16 && d15 > d17) {
                this.x = (float)Math.sqrt(d15);
                this.y = (float)(d18 / (double)this.x);
                this.z = (float)(d19 / (double)this.x);
            } else if (d16 > d17) {
                this.y = (float)Math.sqrt(d16);
                this.x = (float)(d18 / (double)this.y);
                this.z = (float)(d20 / (double)this.y);
            } else {
                this.z = (float)Math.sqrt(d17);
                this.x = (float)(d19 / (double)this.z);
                this.y = (float)(d20 / (double)this.z);
            }
            return this;
        }
        double d21 = Math.sqrt((d6 - d8) * (d6 - d8) + (d7 - d3) * (d7 - d3) + (d2 - d4) * (d2 - d4));
        this.angle = (float)Math.safeAcos((d + d5 + d9 - 1.0) / 2.0);
        this.x = (float)((d6 - d8) / d21);
        this.y = (float)((d7 - d3) / d21);
        this.z = (float)((d2 - d4) / d21);
        return this;
    }

    public Quaternionf get(Quaternionf quaternionf) {
        return quaternionf.set(this);
    }

    public Quaterniond get(Quaterniond quaterniond) {
        return quaterniond.set(this);
    }

    public Matrix4f get(Matrix4f matrix4f) {
        return matrix4f.set(this);
    }

    public Matrix3f get(Matrix3f matrix3f) {
        return matrix3f.set(this);
    }

    public Matrix4d get(Matrix4d matrix4d) {
        return matrix4d.set(this);
    }

    public Matrix3d get(Matrix3d matrix3d) {
        return matrix3d.set(this);
    }

    public AxisAngle4d get(AxisAngle4d axisAngle4d) {
        return axisAngle4d.set(this);
    }

    public AxisAngle4f get(AxisAngle4f axisAngle4f) {
        return axisAngle4f.set(this);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeFloat(this.angle);
        objectOutput.writeFloat(this.x);
        objectOutput.writeFloat(this.y);
        objectOutput.writeFloat(this.z);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.angle = objectInput.readFloat();
        this.x = objectInput.readFloat();
        this.y = objectInput.readFloat();
        this.z = objectInput.readFloat();
    }

    public AxisAngle4f normalize() {
        float f = Math.invsqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        this.x *= f;
        this.y *= f;
        this.z *= f;
        return this;
    }

    public AxisAngle4f rotate(float f) {
        this.angle += f;
        this.angle = (float)(((double)this.angle < 0.0 ? java.lang.Math.PI * 2 + (double)this.angle % (java.lang.Math.PI * 2) : (double)this.angle) % (java.lang.Math.PI * 2));
        return this;
    }

    public Vector3f transform(Vector3f vector3f) {
        return this.transform(vector3f, vector3f);
    }

    public Vector3f transform(Vector3fc vector3fc, Vector3f vector3f) {
        double d = Math.sin(this.angle);
        double d2 = Math.cosFromSin(d, (double)this.angle);
        float f = this.x * vector3fc.x() + this.y * vector3fc.y() + this.z * vector3fc.z();
        vector3f.set((float)((double)vector3fc.x() * d2 + d * (double)(this.y * vector3fc.z() - this.z * vector3fc.y()) + (1.0 - d2) * (double)f * (double)this.x), (float)((double)vector3fc.y() * d2 + d * (double)(this.z * vector3fc.x() - this.x * vector3fc.z()) + (1.0 - d2) * (double)f * (double)this.y), (float)((double)vector3fc.z() * d2 + d * (double)(this.x * vector3fc.y() - this.y * vector3fc.x()) + (1.0 - d2) * (double)f * (double)this.z));
        return vector3f;
    }

    public Vector4f transform(Vector4f vector4f) {
        return this.transform(vector4f, vector4f);
    }

    public Vector4f transform(Vector4fc vector4fc, Vector4f vector4f) {
        double d = Math.sin(this.angle);
        double d2 = Math.cosFromSin(d, (double)this.angle);
        float f = this.x * vector4fc.x() + this.y * vector4fc.y() + this.z * vector4fc.z();
        vector4f.set((float)((double)vector4fc.x() * d2 + d * (double)(this.y * vector4fc.z() - this.z * vector4fc.y()) + (1.0 - d2) * (double)f * (double)this.x), (float)((double)vector4fc.y() * d2 + d * (double)(this.z * vector4fc.x() - this.x * vector4fc.z()) + (1.0 - d2) * (double)f * (double)this.y), (float)((double)vector4fc.z() * d2 + d * (double)(this.x * vector4fc.y() - this.y * vector4fc.x()) + (1.0 - d2) * (double)f * (double)this.z), vector4f.w);
        return vector4f;
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat numberFormat) {
        return "(" + Runtime.format(this.x, numberFormat) + " " + Runtime.format(this.y, numberFormat) + " " + Runtime.format(this.z, numberFormat) + " <| " + Runtime.format(this.angle, numberFormat) + ")";
    }

    public int hashCode() {
        int n = 1;
        float f = (float)(((double)this.angle < 0.0 ? java.lang.Math.PI * 2 + (double)this.angle % (java.lang.Math.PI * 2) : (double)this.angle) % (java.lang.Math.PI * 2));
        n = 31 * n + Float.floatToIntBits(f);
        n = 31 * n + Float.floatToIntBits(this.x);
        n = 31 * n + Float.floatToIntBits(this.y);
        n = 31 * n + Float.floatToIntBits(this.z);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AxisAngle4f axisAngle4f = (AxisAngle4f)object;
        float f = (float)(((double)this.angle < 0.0 ? java.lang.Math.PI * 2 + (double)this.angle % (java.lang.Math.PI * 2) : (double)this.angle) % (java.lang.Math.PI * 2));
        float f2 = (float)(((double)axisAngle4f.angle < 0.0 ? java.lang.Math.PI * 2 + (double)axisAngle4f.angle % (java.lang.Math.PI * 2) : (double)axisAngle4f.angle) % (java.lang.Math.PI * 2));
        if (Float.floatToIntBits(f) != Float.floatToIntBits(f2)) {
            return false;
        }
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(axisAngle4f.x)) {
            return false;
        }
        if (Float.floatToIntBits(this.y) != Float.floatToIntBits(axisAngle4f.y)) {
            return false;
        }
        return Float.floatToIntBits(this.z) == Float.floatToIntBits(axisAngle4f.z);
    }
}

