/*
 * Decompiled with CFR 0.152.
 */
package fmod.fmod;

import fmod.fmod.FMOD_GUID;
import fmod.fmod.FMOD_STUDIO_EVENT_DESCRIPTION;
import fmod.fmod.FMOD_STUDIO_PARAMETER_DESCRIPTION;
import fmod.fmod.FMOD_STUDIO_PARAMETER_FLAGS;
import fmod.fmod.FMOD_STUDIO_PARAMETER_ID;
import fmod.fmod.SoundListener;
import fmod.javafmod;
import fmod.javafmodJNI;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import zombie.ZomboidFileSystem;
import zombie.characters.IsoPlayer;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.logger.ExceptionLogger;
import zombie.debug.DebugLog;
import zombie.iso.Vector2;

public class FMODManager {
    public static FMODManager instance = new FMODManager();
    public static int FMOD_STUDIO_INIT_NORMAL = 0;
    public static int FMOD_STUDIO_INIT_LIVEUPDATE = 1;
    public static int FMOD_STUDIO_INIT_ALLOW_MISSING_PLUGINS = 2;
    public static int FMOD_STUDIO_INIT_SYNCHRONOUS_UPDATE = 4;
    public static int FMOD_STUDIO_INIT_DEFERRED_CALLBACKS = 8;
    public static int FMOD_INIT_NORMAL = 0;
    public static int FMOD_INIT_STREAM_FROM_UPDATE = 1;
    public static int FMOD_INIT_MIX_FROM_UPDATE = 2;
    public static int FMOD_INIT_3D_RIGHTHANDED = 4;
    public static int FMOD_INIT_CHANNEL_LOWPASS = 256;
    public static int FMOD_INIT_CHANNEL_DISTANCEFILTER = 512;
    public static int FMOD_INIT_PROFILE_ENABLE = 65536;
    public static int FMOD_INIT_VOL0_BECOMES_VIRTUAL = 131072;
    public static int FMOD_INIT_GEOMETRY_USECLOSEST = 262144;
    public static int FMOD_INIT_PREFER_DOLBY_DOWNMIX = 524288;
    public static int FMOD_INIT_THREAD_UNSAFE = 0x100000;
    public static int FMOD_INIT_PROFILE_METER_ALL = 0x200000;
    public static int FMOD_DEFAULT = 0;
    public static int FMOD_LOOP_OFF = 1;
    public static int FMOD_LOOP_NORMAL = 2;
    public static int FMOD_LOOP_BIDI = 4;
    public static int FMOD_2D = 8;
    public static int FMOD_3D = 16;
    public static int FMOD_HARDWARE = 32;
    public static int FMOD_SOFTWARE = 64;
    public static int FMOD_CREATESTREAM = 128;
    public static int FMOD_CREATESAMPLE = 256;
    public static int FMOD_CREATECOMPRESSEDSAMPLE = 512;
    public static int FMOD_OPENUSER = 1024;
    public static int FMOD_OPENMEMORY = 2048;
    public static int FMOD_OPENMEMORY_POINT = 0x10000000;
    public static int FMOD_OPENRAW = 4096;
    public static int FMOD_OPENONLY = 8192;
    public static int FMOD_ACCURATETIME = 16384;
    public static int FMOD_MPEGSEARCH = 32768;
    public static int FMOD_NONBLOCKING = 65536;
    public static int FMOD_UNIQUE = 131072;
    public static int FMOD_3D_HEADRELATIVE = 262144;
    public static int FMOD_3D_WORLDRELATIVE = 524288;
    public static int FMOD_3D_INVERSEROLLOFF = 0x100000;
    public static int FMOD_3D_LINEARROLLOFF = 0x200000;
    public static int FMOD_3D_LINEARSQUAREROLLOFF = 0x400000;
    public static int FMOD_3D_INVERSETAPEREDROLLOFF = 0x800000;
    public static int FMOD_3D_CUSTOMROLLOFF = 0x4000000;
    public static int FMOD_3D_IGNOREGEOMETRY = 0x40000000;
    public static int FMOD_IGNORETAGS = 0x2000000;
    public static int FMOD_LOWMEM = 0x8000000;
    public static int FMOD_LOADSECONDARYRAM = 0x20000000;
    public static int FMOD_VIRTUAL_PLAYFROMSTART = Integer.MIN_VALUE;
    public static int FMOD_PRESET_OFF = 0;
    public static int FMOD_PRESET_GENERIC = 1;
    public static int FMOD_PRESET_PADDEDCELL = 2;
    public static int FMOD_PRESET_ROOM = 3;
    public static int FMOD_PRESET_BATHROOM = 4;
    public static int FMOD_PRESET_LIVINGROOM = 5;
    public static int FMOD_PRESET_STONEROOM = 6;
    public static int FMOD_PRESET_AUDITORIUM = 7;
    public static int FMOD_PRESET_CONCERTHALL = 8;
    public static int FMOD_PRESET_CAVE = 9;
    public static int FMOD_PRESET_ARENA = 10;
    public static int FMOD_PRESET_HANGAR = 11;
    public static int FMOD_PRESET_CARPETTEDHALLWAY = 12;
    public static int FMOD_PRESET_HALLWAY = 13;
    public static int FMOD_PRESET_STONECORRIDOR = 14;
    public static int FMOD_PRESET_ALLEY = 15;
    public static int FMOD_PRESET_FOREST = 16;
    public static int FMOD_PRESET_CITY = 17;
    public static int FMOD_PRESET_MOUNTAINS = 18;
    public static int FMOD_PRESET_QUARRY = 19;
    public static int FMOD_PRESET_PLAIN = 20;
    public static int FMOD_PRESET_PARKINGLOT = 21;
    public static int FMOD_PRESET_SEWERPIPE = 22;
    public static int FMOD_PRESET_UNDERWATER = 23;
    public static int FMOD_TIMEUNIT_MS = 1;
    public static int FMOD_TIMEUNIT_PCM = 2;
    public static int FMOD_TIMEUNIT_PCMBYTES = 4;
    public static int FMOD_STUDIO_PLAYBACK_PLAYING = 0;
    public static int FMOD_STUDIO_PLAYBACK_SUSTAINING = 1;
    public static int FMOD_STUDIO_PLAYBACK_STOPPED = 2;
    public static int FMOD_STUDIO_PLAYBACK_STARTING = 3;
    public static int FMOD_STUDIO_PLAYBACK_STOPPING = 4;
    public static int FMOD_SOUND_FORMAT_NONE = 0;
    public static int FMOD_SOUND_FORMAT_PCM8 = 1;
    public static int FMOD_SOUND_FORMAT_PCM16 = 2;
    public static int FMOD_SOUND_FORMAT_PCM24 = 3;
    public static int FMOD_SOUND_FORMAT_PCM32 = 4;
    public static int FMOD_SOUND_FORMAT_PCMFLOAT = 5;
    public static int FMOD_SOUND_FORMAT_BITSTREAM = 6;
    ArrayList<Long> Sounds = new ArrayList();
    ArrayList<Long> Instances = new ArrayList();
    public long channelGroupInGameNonBankSounds = 0L;
    private final HashMap<String, FMOD_STUDIO_PARAMETER_DESCRIPTION> parameterDescriptionMap = new HashMap();
    private final HashMap<String, FMOD_STUDIO_EVENT_DESCRIPTION> eventDescriptionMap = new HashMap();
    int c = 0;
    Vector2 move = new Vector2(0.0f, 0.0f);
    Vector2 pos = new Vector2(-400.0f, -400.0f);
    float x = 0.0f;
    float y = 0.0f;
    float z = 0.0f;
    float vx = 0.02f;
    float vy = 0.01f;
    float vz = 0.0f;
    private int numListeners = 1;
    private final HashMap<String, Long> fileToSoundMap = new HashMap();
    private final int[] reverbPreset = new int[]{-1, -1, -1, -1};

    public void init() {
        int n;
        javafmodJNI.init();
        int n2 = javafmod.FMOD_System_Create();
        if (n2 != 0) {
            Core.SoundDisabled = true;
            return;
        }
        int n3 = Core.bDebug ? FMOD_STUDIO_INIT_LIVEUPDATE : 0;
        n2 = javafmod.FMOD_System_Init(1024, FMOD_STUDIO_INIT_NORMAL | n3, FMOD_INIT_NORMAL | FMOD_INIT_CHANNEL_DISTANCEFILTER | FMOD_INIT_CHANNEL_LOWPASS | FMOD_INIT_VOL0_BECOMES_VIRTUAL | (n = Core.bDebug ? FMOD_INIT_PROFILE_ENABLE | FMOD_INIT_PROFILE_METER_ALL : 0));
        if (n2 != 0) {
            Core.SoundDisabled = true;
            return;
        }
        javafmod.FMOD_System_Set3DSettings(1.0f, 1.0f, 1.0f);
        this.loadBank("ZomboidSound.strings");
        this.loadBank("ZomboidMusic");
        this.loadBank("ZomboidSound");
        this.loadBank("ZomboidSoundMP");
        this.channelGroupInGameNonBankSounds = javafmod.FMOD_System_CreateChannelGroup("InGameNonBank");
        this.initGlobalParameters();
        this.initEvents();
    }

    private String bankPath(String string) throws IOException {
        return new File("./media/sound/banks/Desktop/" + string + ".bank").getCanonicalFile().getPath();
    }

    private long loadBank(String string) {
        try {
            String string2 = this.bankPath(string);
            long l = javafmod.FMOD_Studio_System_LoadBankFile(string2);
            if (l > 0L) {
                javafmod.FMOD_Studio_LoadSampleData(l);
            }
            return l;
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
            return 0L;
        }
    }

    private void loadZombieTest() {
        long l = javafmod.FMOD_Studio_System_LoadBankFile("media/sound/banks/chopper.bank");
        long l2 = javafmod.FMOD_Studio_System_LoadBankFile("media/sound/banks/chopper.strings.bank");
        javafmod.FMOD_Studio_LoadSampleData(l);
        long l3 = javafmod.FMOD_Studio_System_GetEvent("{5deff1b6-984c-42e0-98ec-c133a83d0513}");
        long l4 = javafmod.FMOD_Studio_System_GetEvent("{c00fed39-230a-4c6a-b9c0-b0924876f53a}");
        javafmod.FMOD_Studio_LoadEventSampleData(l3);
        javafmod.FMOD_Studio_LoadEventSampleData(l4);
        int n = 2000;
        int n2 = 2000;
        SoundListener soundListener = new SoundListener(0);
        soundListener.x = n;
        soundListener.y = n2;
        soundListener.tick();
        boolean bl = false;
        ArrayList<TestZombieInfo> arrayList = new ArrayList<TestZombieInfo>();
        ArrayList<TestZombieInfo> arrayList2 = new ArrayList<TestZombieInfo>();
        TestZombieInfo testZombieInfo = new TestZombieInfo(l3, n - 5, n2 - 5);
        javafmod.FMOD_Studio_EventInstance_SetParameterByName(testZombieInfo.inst, "Pitch", (float)Rand.Next(200) / 100.0f - 1.0f);
        javafmod.FMOD_Studio_EventInstance_SetParameterByName(testZombieInfo.inst, "Aggitation", 0.0f);
        arrayList.add(testZombieInfo);
        ++this.c;
        while (!bl) {
            TestZombieInfo testZombieInfo2;
            int n3;
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                testZombieInfo2 = (TestZombieInfo)arrayList.get(n3);
                if (Rand.Next(1000) != 0) continue;
                --this.c;
                arrayList2.add(testZombieInfo2);
                arrayList.remove(testZombieInfo2);
                float f = (float)(Rand.Next(40) + 60) / 100.0f;
                javafmod.FMOD_Studio_EventInstance_SetParameterByName(testZombieInfo2.inst, "Aggitation", f);
                --n3;
            }
            for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                testZombieInfo2 = (TestZombieInfo)arrayList2.get(n3);
                Vector2 vector22 = new Vector2((float)n - testZombieInfo2.X, (float)n2 - testZombieInfo2.Y);
                if (vector22.getLength() < 2.0f) {
                    arrayList2.remove(testZombieInfo2);
                    javafmod.FMOD_Studio_EventInstance_Stop(testZombieInfo2.inst, false);
                }
                vector22.setLength(0.01f);
                testZombieInfo2.X += vector22.x;
                testZombieInfo2.Y += vector22.y;
                javafmod.FMOD_Studio_EventInstance3D(testZombieInfo2.inst, testZombieInfo2.X, testZombieInfo2.Y, 0.0f);
            }
            javafmod.FMOD_System_Update();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    private void loadTestEvent() {
        long l = javafmod.FMOD_Studio_System_LoadBankFile("media/sound/banks/chopper.bank");
        javafmod.FMOD_Studio_LoadSampleData(l);
        long l2 = javafmod.FMOD_Studio_System_GetEvent("{47d0c496-7d0a-48e9-9bad-1c8fcf292986}");
        javafmod.FMOD_Studio_LoadEventSampleData(l2);
        long l3 = javafmod.FMOD_Studio_System_CreateEventInstance(l2);
        javafmod.FMOD_Studio_EventInstance3D(l3, this.pos.x, this.pos.y, 100.0f);
        javafmod.FMOD_Studio_Listener3D(0, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        javafmod.FMOD_Studio_StartEvent(l3);
        int n = 0;
        boolean bl = false;
        while (!bl) {
            if (n > 200) {
                this.pos.x = Rand.Next(400) - 200;
                this.pos.y = Rand.Next(400) - 200;
                if (Rand.Next(3) == 0) {
                    this.pos.x /= 4.0f;
                    this.pos.y /= 4.0f;
                }
                javafmod.FMOD_Studio_StartEvent(l3);
                javafmod.FMOD_Studio_EventInstance3D(l3, this.pos.x, this.pos.y, 0.0f);
                n = 0;
            }
            ++n;
            javafmod.FMOD_System_Update();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public void loadTest() {
        long l = javafmod.FMOD_System_CreateSound("media/sound/PZ_FemaleBeingEaten_Death.wav", FMOD_3D);
        javafmod.FMOD_Sound_Set3DMinMaxDistance(l, 0.005f, 100.0f);
        this.Sounds.add(l);
        this.playTest();
    }

    public void playTest() {
        long l = this.Sounds.get(0);
        long l2 = javafmod.FMOD_System_PlaySound(l, true);
        javafmod.FMOD_Channel_Set3DAttributes(l2, 10.0f, 10.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        javafmod.FMOD_Channel_SetPaused(l2, false);
        this.Instances.add(l2);
    }

    public void applyDSP() {
        javafmod.FMOD_System_PlayDSP();
    }

    public void tick() {
        int n;
        if (Rand.Next(100) == 0) {
            this.vx = -this.vx;
        }
        if (Rand.Next(100) == 0) {
            this.vy = -this.vy;
        }
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        this.x += this.vx;
        this.y += this.vy;
        this.z += this.vz;
        for (n = 0; n < this.Instances.size(); ++n) {
            long l = this.Instances.get(n);
            javafmod.FMOD_Channel_Set3DAttributes(l, this.x, this.y, this.z, this.x - f, this.y - f2, this.z - f3);
            float f4 = 40.0f;
            float f5 = (Math.abs(this.x) + Math.abs(this.y)) / f4;
            if (f5 < 0.1f) {
                f5 = 0.1f;
            }
            if (f5 > 1.0f) {
                f5 = 1.0f;
            }
            f5 *= f5;
            javafmod.FMOD_Channel_SetReverbProperties(l, 0, f5 *= 40.0f);
        }
        n = 0;
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            IsoPlayer isoPlayer = IsoPlayer.players[i];
            if (isoPlayer == null) continue;
            ++n;
        }
        if (n > 0) {
            if (n != this.numListeners) {
                javafmod.FMOD_Studio_SetNumListeners(n);
            }
        } else if (this.numListeners != 1) {
            javafmod.FMOD_Studio_SetNumListeners(1);
        }
        this.numListeners = n;
        this.updateReverbPreset();
        javafmod.FMOD_System_Update();
    }

    public int getNumListeners() {
        return this.numListeners;
    }

    public long loadSound(String string) {
        if ((string = ZomboidFileSystem.instance.getAbsolutePath(string)) == null) {
            return 0L;
        }
        Long l = this.fileToSoundMap.get(string);
        if (l != null) {
            return l;
        }
        l = javafmod.FMOD_System_CreateSound(string, FMOD_3D);
        if (Core.bDebug && l == 0L) {
            DebugLog.log("ERROR: failed to load sound " + string);
        }
        this.fileToSoundMap.put(string, l);
        return l;
    }

    public void stopSound(long l) {
        if (l == 0L) {
            return;
        }
        javafmod.FMOD_Channel_Stop(l);
    }

    public boolean isPlaying(long l) {
        return javafmod.FMOD_Channel_IsPlaying(l);
    }

    public long loadSound(String string, boolean bl) {
        if ((string = ZomboidFileSystem.instance.getAbsolutePath(string)) == null) {
            return 0L;
        }
        Long l = this.fileToSoundMap.get(string);
        if (l != null) {
            return l;
        }
        l = !bl ? Long.valueOf(javafmod.FMOD_System_CreateSound(string, FMOD_3D)) : Long.valueOf(javafmod.FMOD_System_CreateSound(string, FMOD_3D | FMOD_LOOP_NORMAL));
        this.fileToSoundMap.put(string, l);
        return l;
    }

    public void updateReverbPreset() {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        n2 = FMOD_PRESET_FOREST;
        n3 = FMOD_PRESET_CITY;
        n = FMOD_PRESET_OFF;
        n2 = FMOD_PRESET_OFF;
        n3 = FMOD_PRESET_OFF;
        if (this.reverbPreset[0] != n) {
            javafmod.FMOD_System_SetReverbDefault(0, n);
            this.reverbPreset[0] = n;
        }
        if (this.reverbPreset[1] != n2) {
            javafmod.FMOD_System_SetReverbDefault(1, n2);
            this.reverbPreset[1] = n2;
        }
        if (this.reverbPreset[2] != n3) {
            javafmod.FMOD_System_SetReverbDefault(2, n3);
            this.reverbPreset[2] = n3;
        }
    }

    private void initGlobalParameters() {
        int n = javafmodJNI.FMOD_Studio_System_GetParameterDescriptionCount();
        if (n <= 0) {
            return;
        }
        long[] lArray = new long[n];
        n = javafmodJNI.FMOD_Studio_System_GetParameterDescriptionList(lArray);
        for (int i = 0; i < n; ++i) {
            long l = lArray[i];
            this.initParameterDescription(l);
            javafmodJNI.FMOD_Studio_ParameterDescription_Free(l);
        }
    }

    private FMOD_STUDIO_PARAMETER_DESCRIPTION initParameterDescription(long l) {
        String string = javafmodJNI.FMOD_Studio_ParameterDescription_GetName(l);
        FMOD_STUDIO_PARAMETER_DESCRIPTION fMOD_STUDIO_PARAMETER_DESCRIPTION = this.parameterDescriptionMap.get(string);
        if (fMOD_STUDIO_PARAMETER_DESCRIPTION == null) {
            int n = javafmodJNI.FMOD_Studio_ParameterDescription_GetFlags(l);
            long l2 = javafmodJNI.FMOD_Studio_ParameterDescription_GetID(l);
            FMOD_STUDIO_PARAMETER_ID fMOD_STUDIO_PARAMETER_ID = new FMOD_STUDIO_PARAMETER_ID(l2);
            fMOD_STUDIO_PARAMETER_DESCRIPTION = new FMOD_STUDIO_PARAMETER_DESCRIPTION(string, fMOD_STUDIO_PARAMETER_ID, n, this.parameterDescriptionMap.size());
            this.parameterDescriptionMap.put(fMOD_STUDIO_PARAMETER_DESCRIPTION.name, fMOD_STUDIO_PARAMETER_DESCRIPTION);
            if ((fMOD_STUDIO_PARAMETER_DESCRIPTION.flags & FMOD_STUDIO_PARAMETER_FLAGS.FMOD_STUDIO_PARAMETER_GLOBAL.bit) != 0) {
                boolean bl = true;
            } else {
                boolean bl = true;
            }
        }
        return fMOD_STUDIO_PARAMETER_DESCRIPTION;
    }

    private void initEvents() {
        int n = javafmodJNI.FMOD_Studio_System_GetBankCount();
        if (n <= 0) {
            return;
        }
        long[] lArray = new long[n];
        n = javafmodJNI.FMOD_Studio_System_GetBankList(lArray);
        for (int i = 0; i < n; ++i) {
            int n2 = javafmodJNI.FMOD_Studio_Bank_GetEventCount(lArray[i]);
            if (n2 <= 0) continue;
            long[] lArray2 = new long[n2];
            n2 = javafmodJNI.FMOD_Studio_Bank_GetEventList(lArray[i], lArray2);
            for (int j = 0; j < n2; ++j) {
                this.initEvent(lArray2[j]);
            }
        }
    }

    private void initEvent(long l) {
        String string = javafmodJNI.FMOD_Studio_EventDescription_GetPath(l);
        long l2 = javafmodJNI.FMOD_Studio_EventDescription_GetID(l);
        FMOD_GUID fMOD_GUID = new FMOD_GUID(l2);
        boolean bl = javafmodJNI.FMOD_Studio_EventDescription_HasSustainPoint(l);
        long l3 = javafmodJNI.FMOD_Studio_EventDescription_GetLength(l);
        FMOD_STUDIO_EVENT_DESCRIPTION fMOD_STUDIO_EVENT_DESCRIPTION = new FMOD_STUDIO_EVENT_DESCRIPTION(l, string, fMOD_GUID, bl, l3);
        this.eventDescriptionMap.put(fMOD_STUDIO_EVENT_DESCRIPTION.path.toLowerCase(Locale.ENGLISH), fMOD_STUDIO_EVENT_DESCRIPTION);
        int n = javafmodJNI.FMOD_Studio_EventDescription_GetParameterDescriptionCount(l);
        for (int i = 0; i < n; ++i) {
            long l4 = javafmodJNI.FMOD_Studio_EventDescription_GetParameterDescriptionByIndex(l, i);
            FMOD_STUDIO_PARAMETER_DESCRIPTION fMOD_STUDIO_PARAMETER_DESCRIPTION = this.initParameterDescription(l4);
            fMOD_STUDIO_EVENT_DESCRIPTION.parameters.add(fMOD_STUDIO_PARAMETER_DESCRIPTION);
            javafmodJNI.FMOD_Studio_ParameterDescription_Free(l4);
        }
    }

    public FMOD_STUDIO_EVENT_DESCRIPTION getEventDescription(String string) {
        return this.eventDescriptionMap.get(string.toLowerCase(Locale.ENGLISH));
    }

    public FMOD_STUDIO_PARAMETER_DESCRIPTION getParameterDescription(String string) {
        return this.parameterDescriptionMap.get(string);
    }

    public FMOD_STUDIO_PARAMETER_ID getParameterID(String string) {
        FMOD_STUDIO_PARAMETER_DESCRIPTION fMOD_STUDIO_PARAMETER_DESCRIPTION = this.getParameterDescription(string);
        return fMOD_STUDIO_PARAMETER_DESCRIPTION == null ? null : fMOD_STUDIO_PARAMETER_DESCRIPTION.id;
    }

    public int getParameterCount() {
        return this.parameterDescriptionMap.size();
    }

    public static class TestZombieInfo {
        public float X;
        public float Y;
        public long event;
        public long inst;

        public TestZombieInfo(long l, float f, float f2) {
            this.createZombieInstance(l, f, f2);
        }

        public long createZombieInstance(long l, float f, float f2) {
            long l2 = javafmod.FMOD_Studio_System_CreateEventInstance(l);
            javafmod.FMOD_Studio_EventInstance3D(l2, f, f2, 0.0f);
            javafmod.FMOD_Studio_StartEvent(l2);
            this.X = f;
            this.Y = f2;
            this.event = l;
            this.inst = l2;
            return l2;
        }
    }
}

