/*
 * Decompiled with CFR 0.152.
 */
package EtherHack.utils;

import EtherHack.utils.Logger;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Consumer;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class Patch {
    private static final Map<String, ClassNode> classNodeMap = new HashMap<String, ClassNode>();

    public static boolean isInjectedAnnotationPresent(String filePath, String gameFolder) {
        boolean bl;
        Path currentPath = Paths.get("", new String[0]).toAbsolutePath();
        Path classPath = Paths.get(currentPath.toString(), gameFolder, filePath);
        FileInputStream fileInputStream = new FileInputStream(classPath.toString());
        try {
            ClassReader reader = new ClassReader(fileInputStream);
            final boolean[] isAnnotationFound = new boolean[]{false};
            reader.accept(new ClassVisitor(589824){

                @Override
                public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                    MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
                    return new MethodVisitor(589824, mv){

                        @Override
                        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                            if (descriptor.equals("LEtherHack/annotations/Injected;")) {
                                isAnnotationFound[0] = true;
                            }
                            return super.visitAnnotation(descriptor, visible);
                        }
                    };
                }
            }, 0);
            bl = isAnnotationFound[0];
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        fileInputStream.close();
        return bl;
    }

    private static void addInjectAnnotation(ClassNode classNode, String methodName) {
        for (MethodNode method : classNode.methods) {
            if (!method.name.equals(methodName)) continue;
            if (method.visibleAnnotations == null) {
                method.visibleAnnotations = new LinkedList<AnnotationNode>();
            } else {
                for (AnnotationNode annotation : method.visibleAnnotations) {
                    if (!annotation.desc.equals("LEtherHack/annotations/Injected;")) continue;
                    return;
                }
            }
            AnnotationNode annotationNode = new AnnotationNode("LEtherHack/annotations/Injected;");
            method.visibleAnnotations.add(annotationNode);
        }
    }

    private static boolean hasInjectedAnnotation(MethodNode method) {
        if (method.visibleAnnotations == null) {
            return false;
        }
        for (AnnotationNode annotation : method.visibleAnnotations) {
            if (!"LInjected;".equals(annotation.desc)) continue;
            return true;
        }
        return false;
    }

    public static void injectIntoClass(String className, String methodName, boolean isStatic, Consumer<MethodNode> modifyMethod) {
        Logger.print("Injection into a game file '" + className + "' in method: '" + methodName + "'");
        try {
            ClassNode classNode = classNodeMap.getOrDefault(className, new ClassNode());
            if (!classNodeMap.containsKey(className)) {
                ClassReader classReader = new ClassReader(className);
                classReader.accept(classNode, 0);
            }
            for (MethodNode method : classNode.methods) {
                if (!method.name.equals(methodName) || Modifier.isStatic(method.access) != isStatic) continue;
                if (!Patch.hasInjectedAnnotation(method)) {
                    Patch.addInjectAnnotation(classNode, methodName);
                }
                modifyMethod.accept(method);
            }
            classNodeMap.put(className, classNode);
        }
        catch (IOException e) {
            Logger.print("An error occurred during injection into '" + className + "': " + e.getMessage());
        }
    }

    public static void saveModifiedClasses() {
        for (Map.Entry<String, ClassNode> stringClassNodeEntry : classNodeMap.entrySet()) {
            String className = stringClassNodeEntry.getKey();
            ClassNode classNode = stringClassNodeEntry.getValue();
            ClassWriter classWriter = new ClassWriter(3);
            classNode.accept(classWriter);
            byte[] modifiedClass = classWriter.toByteArray();
            try (FileOutputStream fos = new FileOutputStream(className + ".class");){
                fos.write(modifiedClass);
            }
            catch (IOException except) {
                Logger.print("An error occurred while writing the modified class '" + className + "': " + except.getMessage());
            }
        }
    }
}

