/*
 * Decompiled with CFR 0.152.
 */
package EtherHack.Ether;

import EtherHack.Ether.EtherLuaMethods;
import EtherHack.Ether.EtherMain;
import EtherHack.annotations.LuaEvents;
import EtherHack.annotations.SubscribeLuaEvent;
import EtherHack.utils.ColorUtils;
import EtherHack.utils.ConfigUtils;
import EtherHack.utils.EventSubscriber;
import EtherHack.utils.Exposer;
import EtherHack.utils.Logger;
import EtherHack.utils.PlayerUtils;
import EtherHack.utils.Rendering;
import EtherHack.utils.VehicleUtils;
import EtherHack.utils.ZombieUtils;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import zombie.Lua.LuaManager;
import zombie.SandboxOptions;
import zombie.characterTextures.BloodBodyPartType;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.core.Color;
import zombie.core.Core;
import zombie.core.textures.Texture;
import zombie.inventory.InventoryItem;
import zombie.inventory.types.HandWeapon;
import zombie.iso.IsoWorld;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.ServerOptions;
import zombie.ui.UIFont;
import zombie.vehicles.BaseVehicle;

public class EtherAPI {
    private Exposer exposer;
    private final EtherLuaMethods etherLuaMethods = new EtherLuaMethods();
    public HashMap<String, Texture> textureCache = new HashMap();
    HashMap<String, float[]> originalWeaponStats = new HashMap();
    public Color mainUIAccentColor;
    public Color vehiclesUIColor;
    public Color zombiesUIColor;
    public Color playersUIColor;
    public boolean isPlayerInSafeTeleported;
    public boolean isMultiHitZombies;
    public boolean isExtraDamage;
    public boolean isTimedActionCheat;
    public boolean isEnableGodMode;
    public boolean isEnableNoclip;
    public boolean isEnableInvisible;
    public boolean isEnableNightVision;
    public boolean isZombieDontAttack;
    public boolean isNoRecoil;
    public boolean isBypassDebugMode;
    public boolean isUnlimitedCarry;
    public boolean isUnlimitedCondition;
    public boolean isUnlimitedEndurance;
    public boolean isUnlimitedAmmo;
    public boolean isAutoRepairItems;
    public boolean isDisableFatigue;
    public boolean isDisableHunger;
    public boolean isDisableThirst;
    public boolean isDisableDrunkenness;
    public boolean isDisableAnger;
    public boolean isDisableFear;
    public boolean isDisablePain;
    public boolean isDisablePanic;
    public boolean isDisableMorale;
    public boolean isDisableStress;
    public boolean isDisableSickness;
    public boolean isDisableStressFromCigarettes;
    public boolean isDisableSanity;
    public boolean isDisableBoredomLevel;
    public boolean isDisableUnhappynessLevel;
    public boolean isDisableWetness;
    public boolean isDisableInfectionLevel;
    public boolean isDisableFakeInfectionLevel;
    public boolean isOptimalCalories;
    public boolean isOptimalWeight;
    public boolean isVisualsEnable;
    public boolean isVisualsPlayersEnable;
    public boolean isVisualsVehiclesEnable;
    public boolean isVisualsZombiesEnable;
    public boolean isVisualDrawToLocalPlayer;
    public boolean isVisualDrawPlayerNickname;
    public boolean isVisualDrawCredits;
    public boolean isVisualDrawPlayerInfo;
    public boolean isVisualDrawLineToVehicle;
    public boolean isVisualDrawLineToPlayers;
    public boolean isVisualEnable360Vision;
    public boolean isMapDrawLocalPlayer;
    public boolean isMapDrawAllPlayers;
    public boolean isMapDrawVehicles;
    public boolean isMapDrawZombies;

    public void saveConfig(String configFileName) {
        String fixedFileName = "EtherHack/config/" + configFileName + ".properties";
        Properties config = new Properties();
        config.setProperty("mainUIAccentColor", ColorUtils.colorToString(this.mainUIAccentColor));
        config.setProperty("vehiclesUIColor", ColorUtils.colorToString(this.vehiclesUIColor));
        config.setProperty("zombiesUIColor", ColorUtils.colorToString(this.zombiesUIColor));
        config.setProperty("playersUIColor", ColorUtils.colorToString(this.playersUIColor));
        config.setProperty("isPlayerInSafeTeleported", Boolean.toString(this.isPlayerInSafeTeleported));
        config.setProperty("isMultiHitZombies", Boolean.toString(this.isMultiHitZombies));
        config.setProperty("isPlayerInSafeTeleported", Boolean.toString(this.isPlayerInSafeTeleported));
        config.setProperty("isMultiHitZombies", Boolean.toString(this.isMultiHitZombies));
        config.setProperty("isExtraDamage", Boolean.toString(this.isExtraDamage));
        config.setProperty("isTimedActionCheat", Boolean.toString(this.isTimedActionCheat));
        config.setProperty("isEnableGodMode", Boolean.toString(this.isEnableGodMode));
        config.setProperty("isEnableNoclip", Boolean.toString(this.isEnableNoclip));
        config.setProperty("isEnableInvisible", Boolean.toString(this.isEnableInvisible));
        config.setProperty("isEnableNightVision", Boolean.toString(this.isEnableNightVision));
        config.setProperty("isZombieDontAttack", Boolean.toString(this.isZombieDontAttack));
        config.setProperty("isNoRecoil", Boolean.toString(this.isNoRecoil));
        config.setProperty("isBypassDebugMode", Boolean.toString(this.isBypassDebugMode));
        config.setProperty("isUnlimitedCarry", Boolean.toString(this.isUnlimitedCarry));
        config.setProperty("isUnlimitedCondition", Boolean.toString(this.isUnlimitedCondition));
        config.setProperty("isUnlimitedEndurance", Boolean.toString(this.isUnlimitedEndurance));
        config.setProperty("isUnlimitedAmmo", Boolean.toString(this.isUnlimitedAmmo));
        config.setProperty("isAutoRepairItems", Boolean.toString(this.isAutoRepairItems));
        config.setProperty("isDisableFatigue", Boolean.toString(this.isDisableFatigue));
        config.setProperty("isDisableHunger", Boolean.toString(this.isDisableHunger));
        config.setProperty("isDisableThirst", Boolean.toString(this.isDisableThirst));
        config.setProperty("isDisableDrunkenness", Boolean.toString(this.isDisableDrunkenness));
        config.setProperty("isDisableAnger", Boolean.toString(this.isDisableAnger));
        config.setProperty("isDisableFear", Boolean.toString(this.isDisableFear));
        config.setProperty("isDisablePain", Boolean.toString(this.isDisablePain));
        config.setProperty("isDisablePanic", Boolean.toString(this.isDisablePanic));
        config.setProperty("isDisableMorale", Boolean.toString(this.isDisableMorale));
        config.setProperty("isDisableStress", Boolean.toString(this.isDisableStress));
        config.setProperty("isDisableSickness", Boolean.toString(this.isDisableSickness));
        config.setProperty("isDisableStressFromCigarettes", Boolean.toString(this.isDisableStressFromCigarettes));
        config.setProperty("isDisableSanity", Boolean.toString(this.isDisableSanity));
        config.setProperty("isDisableBoredomLevel", Boolean.toString(this.isDisableBoredomLevel));
        config.setProperty("isDisableUnhappynessLevel", Boolean.toString(this.isDisableUnhappynessLevel));
        config.setProperty("isDisableWetness", Boolean.toString(this.isDisableWetness));
        config.setProperty("isDisableInfectionLevel", Boolean.toString(this.isDisableInfectionLevel));
        config.setProperty("isDisableFakeInfectionLevel", Boolean.toString(this.isDisableFakeInfectionLevel));
        config.setProperty("isOptimalCalories", Boolean.toString(this.isOptimalCalories));
        config.setProperty("isOptimalWeight", Boolean.toString(this.isOptimalWeight));
        config.setProperty("isVisualsEnable", Boolean.toString(this.isVisualsEnable));
        config.setProperty("isVisualsPlayersEnable", Boolean.toString(this.isVisualsPlayersEnable));
        config.setProperty("isVisualsVehiclesEnable", Boolean.toString(this.isVisualsVehiclesEnable));
        config.setProperty("isVisualsZombiesEnable", Boolean.toString(this.isVisualsZombiesEnable));
        config.setProperty("isVisualDrawToLocalPlayer", Boolean.toString(this.isVisualDrawToLocalPlayer));
        config.setProperty("isVisualDrawPlayerNickname", Boolean.toString(this.isVisualDrawPlayerNickname));
        config.setProperty("isVisualDrawCredits", Boolean.toString(this.isVisualDrawCredits));
        config.setProperty("isVisualDrawPlayerInfo", Boolean.toString(this.isVisualDrawPlayerInfo));
        config.setProperty("isVisualDrawLineToVehicle", Boolean.toString(this.isVisualDrawLineToVehicle));
        config.setProperty("isVisualDrawLineToPlayers", Boolean.toString(this.isVisualDrawLineToPlayers));
        config.setProperty("isVisualEnable360Vision", Boolean.toString(this.isVisualEnable360Vision));
        config.setProperty("isMapDrawLocalPlayer", Boolean.toString(this.isMapDrawLocalPlayer));
        config.setProperty("isMapDrawAllPlayers", Boolean.toString(this.isMapDrawAllPlayers));
        config.setProperty("isMapDrawVehicles", Boolean.toString(this.isMapDrawVehicles));
        config.setProperty("isMapDrawZombies", Boolean.toString(this.isMapDrawZombies));
        try (FileOutputStream out = new FileOutputStream(fixedFileName);){
            config.store(out, null);
        }
        catch (IOException e) {
            Logger.printLog("Error while saving config: " + e);
        }
    }

    public void loadConfig(String configFileName) {
        String fixedFileName = "EtherHack/config/" + configFileName + ".properties";
        Properties config = new Properties();
        try (FileInputStream fis = new FileInputStream(fixedFileName);){
            config.load(fis);
        }
        catch (IOException e) {
            Logger.printLog("The config file was not found. Loading canceled.");
            return;
        }
        this.mainUIAccentColor = ConfigUtils.getColorFromConfig(config, "mainUIAccentColor", new Color(56, 239, 125));
        this.vehiclesUIColor = ConfigUtils.getColorFromConfig(config, "vehiclesUIColor", new Color(150, 150, 200));
        this.zombiesUIColor = ConfigUtils.getColorFromConfig(config, "zombiesUIColor", new Color(255, 150, 100));
        this.playersUIColor = ConfigUtils.getColorFromConfig(config, "playersUIColor", new Color(255, 50, 100));
        this.isPlayerInSafeTeleported = ConfigUtils.getBooleanFromConfig(config, "isPlayerInSafeTeleported", false);
        this.isMultiHitZombies = ConfigUtils.getBooleanFromConfig(config, "isMultiHitZombies", false);
        this.isExtraDamage = ConfigUtils.getBooleanFromConfig(config, "isExtraDamage", false);
        this.isTimedActionCheat = ConfigUtils.getBooleanFromConfig(config, "isTimedActionCheat", false);
        this.isEnableGodMode = ConfigUtils.getBooleanFromConfig(config, "isEnableGodMode", false);
        this.isEnableNoclip = ConfigUtils.getBooleanFromConfig(config, "isEnableNoclip", false);
        this.isEnableInvisible = ConfigUtils.getBooleanFromConfig(config, "isEnableInvisible", false);
        this.isEnableNightVision = ConfigUtils.getBooleanFromConfig(config, "isEnableNightVision", false);
        this.isZombieDontAttack = ConfigUtils.getBooleanFromConfig(config, "isZombieDontAttack", false);
        this.isNoRecoil = ConfigUtils.getBooleanFromConfig(config, "isNoRecoil", false);
        this.isBypassDebugMode = ConfigUtils.getBooleanFromConfig(config, "isBypassDebugMode", false);
        this.isUnlimitedCarry = ConfigUtils.getBooleanFromConfig(config, "isUnlimitedCarry", false);
        this.isUnlimitedCondition = ConfigUtils.getBooleanFromConfig(config, "isUnlimitedCondition", false);
        this.isUnlimitedEndurance = ConfigUtils.getBooleanFromConfig(config, "isUnlimitedEndurance", false);
        this.isUnlimitedAmmo = ConfigUtils.getBooleanFromConfig(config, "isUnlimitedAmmo", false);
        this.isAutoRepairItems = ConfigUtils.getBooleanFromConfig(config, "isAutoRepairItems", false);
        this.isDisableFatigue = ConfigUtils.getBooleanFromConfig(config, "isDisableFatigue", false);
        this.isDisableHunger = ConfigUtils.getBooleanFromConfig(config, "isDisableHunger", false);
        this.isDisableThirst = ConfigUtils.getBooleanFromConfig(config, "isDisableThirst", false);
        this.isDisableDrunkenness = ConfigUtils.getBooleanFromConfig(config, "isDisableDrunkenness", false);
        this.isDisableAnger = ConfigUtils.getBooleanFromConfig(config, "isDisableAnger", false);
        this.isDisableFear = ConfigUtils.getBooleanFromConfig(config, "isDisableFear", false);
        this.isDisablePain = ConfigUtils.getBooleanFromConfig(config, "isDisablePain", false);
        this.isDisablePanic = ConfigUtils.getBooleanFromConfig(config, "isDisablePanic", false);
        this.isDisableMorale = ConfigUtils.getBooleanFromConfig(config, "isDisableMorale", false);
        this.isDisableStress = ConfigUtils.getBooleanFromConfig(config, "isDisableStress", false);
        this.isDisableSickness = ConfigUtils.getBooleanFromConfig(config, "isDisableSickness", false);
        this.isDisableStressFromCigarettes = ConfigUtils.getBooleanFromConfig(config, "isDisableStressFromCigarettes", false);
        this.isDisableSanity = ConfigUtils.getBooleanFromConfig(config, "isDisableSanity", false);
        this.isDisableBoredomLevel = ConfigUtils.getBooleanFromConfig(config, "isDisableBoredomLevel", false);
        this.isDisableUnhappynessLevel = ConfigUtils.getBooleanFromConfig(config, "isDisableUnhappynessLevel", false);
        this.isDisableWetness = ConfigUtils.getBooleanFromConfig(config, "isDisableWetness", false);
        this.isDisableInfectionLevel = ConfigUtils.getBooleanFromConfig(config, "isDisableInfectionLevel", false);
        this.isDisableFakeInfectionLevel = ConfigUtils.getBooleanFromConfig(config, "isDisableFakeInfectionLevel", false);
        this.isOptimalCalories = ConfigUtils.getBooleanFromConfig(config, "isOptimalCalories", false);
        this.isOptimalWeight = ConfigUtils.getBooleanFromConfig(config, "isOptimalWeight", false);
        this.isVisualsEnable = ConfigUtils.getBooleanFromConfig(config, "isVisualsEnable", false);
        this.isVisualsPlayersEnable = ConfigUtils.getBooleanFromConfig(config, "isVisualsPlayersEnable", false);
        this.isVisualsVehiclesEnable = ConfigUtils.getBooleanFromConfig(config, "isVisualsVehiclesEnable", false);
        this.isVisualsZombiesEnable = ConfigUtils.getBooleanFromConfig(config, "isVisualsZombiesEnable", false);
        this.isVisualDrawToLocalPlayer = ConfigUtils.getBooleanFromConfig(config, "isVisualDrawToLocalPlayer", false);
        this.isVisualDrawPlayerNickname = ConfigUtils.getBooleanFromConfig(config, "isVisualDrawPlayerNickname", false);
        this.isVisualDrawCredits = ConfigUtils.getBooleanFromConfig(config, "isVisualDrawCredits", true);
        this.isVisualDrawPlayerInfo = ConfigUtils.getBooleanFromConfig(config, "isVisualDrawPlayerInfo", false);
        this.isVisualDrawLineToVehicle = ConfigUtils.getBooleanFromConfig(config, "isVisualDrawLineToVehicle", false);
        this.isVisualDrawLineToPlayers = ConfigUtils.getBooleanFromConfig(config, "isVisualDrawLineToPlayers", false);
        this.isVisualEnable360Vision = ConfigUtils.getBooleanFromConfig(config, "isVisualEnable360Vision", false);
        this.isMapDrawLocalPlayer = ConfigUtils.getBooleanFromConfig(config, "isMapDrawLocalPlayer", true);
        this.isMapDrawAllPlayers = ConfigUtils.getBooleanFromConfig(config, "isMapDrawAllPlayers", false);
        this.isMapDrawVehicles = ConfigUtils.getBooleanFromConfig(config, "isMapDrawVehicles", false);
        this.isMapDrawZombies = ConfigUtils.getBooleanFromConfig(config, "isMapDrawZombies", false);
    }

    private void initStartupConfig() {
        Properties config = new Properties();
        try (FileInputStream fis = new FileInputStream("EtherHack/config/startup.properties");){
            config.load(fis);
        }
        catch (IOException e) {
            Logger.printLog("Startup file not found. Loading default settings.");
        }
        this.mainUIAccentColor = ConfigUtils.getColorFromConfig(config, "mainUIAccentColor", new Color(56, 239, 125));
        this.vehiclesUIColor = ConfigUtils.getColorFromConfig(config, "vehiclesUIColor", new Color(150, 150, 200));
        this.zombiesUIColor = ConfigUtils.getColorFromConfig(config, "zombiesUIColor", new Color(255, 150, 100));
        this.playersUIColor = ConfigUtils.getColorFromConfig(config, "playersUIColor", new Color(255, 50, 100));
        this.isPlayerInSafeTeleported = ConfigUtils.getBooleanFromConfig(config, "isPlayerInSafeTeleported", false);
        this.isMultiHitZombies = ConfigUtils.getBooleanFromConfig(config, "isMultiHitZombies", false);
        this.isExtraDamage = ConfigUtils.getBooleanFromConfig(config, "isExtraDamage", false);
        this.isTimedActionCheat = ConfigUtils.getBooleanFromConfig(config, "isTimedActionCheat", false);
        this.isEnableGodMode = ConfigUtils.getBooleanFromConfig(config, "isEnableGodMode", false);
        this.isEnableNoclip = ConfigUtils.getBooleanFromConfig(config, "isEnableNoclip", false);
        this.isEnableInvisible = ConfigUtils.getBooleanFromConfig(config, "isEnableInvisible", false);
        this.isEnableNightVision = ConfigUtils.getBooleanFromConfig(config, "isEnableNightVision", false);
        this.isZombieDontAttack = ConfigUtils.getBooleanFromConfig(config, "isZombieDontAttack", false);
        this.isNoRecoil = ConfigUtils.getBooleanFromConfig(config, "isNoRecoil", false);
        this.isBypassDebugMode = ConfigUtils.getBooleanFromConfig(config, "isBypassDebugMode", false);
        this.isUnlimitedCarry = ConfigUtils.getBooleanFromConfig(config, "isUnlimitedCarry", false);
        this.isUnlimitedCondition = ConfigUtils.getBooleanFromConfig(config, "isUnlimitedCondition", false);
        this.isUnlimitedEndurance = ConfigUtils.getBooleanFromConfig(config, "isUnlimitedEndurance", false);
        this.isUnlimitedAmmo = ConfigUtils.getBooleanFromConfig(config, "isUnlimitedAmmo", false);
        this.isAutoRepairItems = ConfigUtils.getBooleanFromConfig(config, "isAutoRepairItems", false);
        this.isDisableFatigue = ConfigUtils.getBooleanFromConfig(config, "isDisableFatigue", false);
        this.isDisableHunger = ConfigUtils.getBooleanFromConfig(config, "isDisableHunger", false);
        this.isDisableThirst = ConfigUtils.getBooleanFromConfig(config, "isDisableThirst", false);
        this.isDisableDrunkenness = ConfigUtils.getBooleanFromConfig(config, "isDisableDrunkenness", false);
        this.isDisableAnger = ConfigUtils.getBooleanFromConfig(config, "isDisableAnger", false);
        this.isDisableFear = ConfigUtils.getBooleanFromConfig(config, "isDisableFear", false);
        this.isDisablePain = ConfigUtils.getBooleanFromConfig(config, "isDisablePain", false);
        this.isDisablePanic = ConfigUtils.getBooleanFromConfig(config, "isDisablePanic", false);
        this.isDisableMorale = ConfigUtils.getBooleanFromConfig(config, "isDisableMorale", false);
        this.isDisableStress = ConfigUtils.getBooleanFromConfig(config, "isDisableStress", false);
        this.isDisableSickness = ConfigUtils.getBooleanFromConfig(config, "isDisableSickness", false);
        this.isDisableStressFromCigarettes = ConfigUtils.getBooleanFromConfig(config, "isDisableStressFromCigarettes", false);
        this.isDisableSanity = ConfigUtils.getBooleanFromConfig(config, "isDisableSanity", false);
        this.isDisableBoredomLevel = ConfigUtils.getBooleanFromConfig(config, "isDisableBoredomLevel", false);
        this.isDisableUnhappynessLevel = ConfigUtils.getBooleanFromConfig(config, "isDisableUnhappynessLevel", false);
        this.isDisableWetness = ConfigUtils.getBooleanFromConfig(config, "isDisableWetness", false);
        this.isDisableInfectionLevel = ConfigUtils.getBooleanFromConfig(config, "isDisableInfectionLevel", false);
        this.isDisableFakeInfectionLevel = ConfigUtils.getBooleanFromConfig(config, "isDisableFakeInfectionLevel", false);
        this.isOptimalCalories = ConfigUtils.getBooleanFromConfig(config, "isOptimalCalories", false);
        this.isOptimalWeight = ConfigUtils.getBooleanFromConfig(config, "isOptimalWeight", false);
        this.isVisualsEnable = ConfigUtils.getBooleanFromConfig(config, "isVisualsEnable", false);
        this.isVisualsPlayersEnable = ConfigUtils.getBooleanFromConfig(config, "isVisualsPlayersEnable", false);
        this.isVisualsVehiclesEnable = ConfigUtils.getBooleanFromConfig(config, "isVisualsVehiclesEnable", false);
        this.isVisualsZombiesEnable = ConfigUtils.getBooleanFromConfig(config, "isVisualsZombiesEnable", false);
        this.isVisualDrawToLocalPlayer = ConfigUtils.getBooleanFromConfig(config, "isVisualDrawToLocalPlayer", false);
        this.isVisualDrawPlayerNickname = ConfigUtils.getBooleanFromConfig(config, "isVisualDrawPlayerNickname", false);
        this.isVisualDrawCredits = ConfigUtils.getBooleanFromConfig(config, "isVisualDrawCredits", true);
        this.isVisualDrawPlayerInfo = ConfigUtils.getBooleanFromConfig(config, "isVisualDrawPlayerInfo", false);
        this.isVisualDrawLineToVehicle = ConfigUtils.getBooleanFromConfig(config, "isVisualDrawLineToVehicle", false);
        this.isVisualDrawLineToPlayers = ConfigUtils.getBooleanFromConfig(config, "isVisualDrawLineToPlayers", false);
        this.isVisualEnable360Vision = ConfigUtils.getBooleanFromConfig(config, "isVisualEnable360Vision", false);
        this.isMapDrawLocalPlayer = ConfigUtils.getBooleanFromConfig(config, "isMapDrawLocalPlayer", true);
        this.isMapDrawAllPlayers = ConfigUtils.getBooleanFromConfig(config, "isMapDrawAllPlayers", false);
        this.isMapDrawVehicles = ConfigUtils.getBooleanFromConfig(config, "isMapDrawVehicles", false);
        this.isMapDrawZombies = ConfigUtils.getBooleanFromConfig(config, "isMapDrawZombies", false);
    }

    public EtherAPI() {
        this.initStartupConfig();
        EventSubscriber.register(this);
    }

    @LuaEvents(value={@SubscribeLuaEvent(eventName="OnResetLua"), @SubscribeLuaEvent(eventName="OnMainMenuEnter")})
    public void loadAPI() {
        Logger.printLog("Loading EtherAPI...");
        if (this.exposer != null) {
            this.exposer.destroy();
        }
        this.exposer = new Exposer(LuaManager.converterManager, LuaManager.platform, LuaManager.env);
        this.exposer.exposeAPI(this.etherLuaMethods);
    }

    public void resetWeaponsStats() {
        IsoPlayer localPlayer = IsoPlayer.getInstance();
        if (localPlayer == null) {
            return;
        }
        ArrayList<InventoryItem> inventoryItems = localPlayer.getInventory().getItems();
        if (inventoryItems != null && !inventoryItems.isEmpty()) {
            for (InventoryItem item : inventoryItems) {
                String type;
                if (!(item instanceof HandWeapon)) continue;
                HandWeapon weapon = (HandWeapon)item;
                if (!item.getStringItemType().equals("RangedWeapon") && !item.getStringItemType().equals("MeleeWeapon") || !this.originalWeaponStats.containsKey(type = weapon.getFullType())) continue;
                float[] values = this.originalWeaponStats.get(type);
                weapon.setExtraDamage(values[0]);
                weapon.setMaxDamage(values[1]);
                weapon.setMinDamage(values[2]);
                weapon.setMaxRange(values[3]);
                weapon.setMinRange(values[4]);
                weapon.setHitChance((int)values[5]);
                weapon.setCritDmgMultiplier(values[6]);
            }
        }
    }

    private void updateLocalPlayerFeatures() {
        ArrayList<InventoryItem> inventoryItems;
        HandWeapon weapon;
        IsoPlayer localPlayer = IsoPlayer.getInstance();
        if (localPlayer == null) {
            return;
        }
        InventoryItem playerItem = localPlayer.getPrimaryHandItem();
        if (this.isExtraDamage && playerItem != null && (playerItem.getStringItemType().equals("RangedWeapon") || playerItem.getStringItemType().equals("MeleeWeapon")) && playerItem instanceof HandWeapon) {
            weapon = (HandWeapon)playerItem;
            String weaponType = weapon.getFullType();
            if (!this.originalWeaponStats.containsKey(weaponType)) {
                this.originalWeaponStats.put(weaponType, new float[]{weapon.getExtraDamage(), weapon.getMaxDamage(), weapon.getMinDamage(), weapon.getMaxRange(), weapon.getMinRange(), weapon.getHitChance(), weapon.getCritDmgMultiplier()});
            }
            weapon.setExtraDamage(100000.0f);
            weapon.setMaxDamage(1000000.0f);
            weapon.setMinDamage(1000000.0f);
            weapon.setMaxRange(10000.0f);
            weapon.setMinRange(0.0f);
            weapon.setHitChance(100);
            weapon.setCritDmgMultiplier(100000.0f);
        }
        if ((Boolean)SandboxOptions.instance.getOptionByName("MultiHitZombies").asConfigOption().getValueAsObject() != this.isMultiHitZombies) {
            SandboxOptions.instance.set("MultiHitZombies", this.isMultiHitZombies);
        }
        if (localPlayer.isTimedActionInstantCheat() != this.isTimedActionCheat) {
            localPlayer.setTimedActionInstantCheat(this.isTimedActionCheat);
        }
        if (localPlayer.isWearingNightVisionGoggles() != this.isEnableNightVision) {
            localPlayer.setWearingNightVisionGoggles(this.isEnableNightVision);
        }
        if (localPlayer.isGodMod() != this.isEnableGodMode) {
            localPlayer.setGodMod(this.isEnableGodMode);
        }
        if (localPlayer.isNoClip() != this.isEnableNoclip) {
            localPlayer.setNoClip(this.isEnableNoclip);
        }
        if (localPlayer.isInvisible() != this.isEnableInvisible) {
            localPlayer.setInvisible(this.isEnableInvisible);
        }
        if (localPlayer.isZombiesDontAttack() != this.isZombieDontAttack) {
            localPlayer.setZombiesDontAttack(this.isZombieDontAttack);
        }
        if (this.isNoRecoil && playerItem != null && playerItem.getStringItemType().equals("RangedWeapon") && playerItem instanceof HandWeapon) {
            weapon = (HandWeapon)playerItem;
            weapon.setRecoilDelay(0);
            weapon.setCriticalChance(100.0f);
            weapon.setAlwaysKnockdown(true);
            weapon.setAimingTime(0);
        }
        if (this.isUnlimitedAmmo && playerItem != null && playerItem.getStringItemType().equals("RangedWeapon")) {
            playerItem.setCurrentAmmoCount(playerItem.getMaxAmmo());
        }
        if (this.isUnlimitedCondition && playerItem != null) {
            if (playerItem.getHaveBeenRepaired() > 1) {
                playerItem.setHaveBeenRepaired(1);
            }
            playerItem.setCondition(playerItem.getConditionMax());
        }
        if (this.isAutoRepairItems && (inventoryItems = localPlayer.getInventory().getItems()) != null && !inventoryItems.isEmpty()) {
            for (InventoryItem item : inventoryItems) {
                if (item == null) continue;
                if (item.isBroken()) {
                    item.setBroken(false);
                }
                item.setHaveBeenRepaired(1);
                if (item.getVisual() != null) {
                    for (int i = 0; i < BloodBodyPartType.MAX.index(); ++i) {
                        item.getVisual().removeHole(i);
                        item.getVisual().removeDirt();
                        item.getVisual().removeBlood();
                    }
                }
                item.setWet(false);
                item.setInfected(false);
                item.setCondition(item.getConditionMax());
            }
        }
        if (this.isUnlimitedEndurance) {
            localPlayer.getStats().setEndurance(1.0f);
        }
        if (this.isDisableFatigue) {
            localPlayer.getStats().setFatigue(0.0f);
        }
        if (this.isDisableHunger) {
            localPlayer.getStats().setHunger(0.0f);
        }
        if (this.isDisableThirst) {
            localPlayer.getStats().setThirst(0.0f);
        }
        if (this.isDisableDrunkenness) {
            localPlayer.getStats().setDrunkenness(0.0f);
        }
        if (this.isDisableAnger) {
            localPlayer.getStats().setAnger(0.0f);
        }
        if (this.isDisableFear) {
            localPlayer.getStats().setFear(0.0f);
        }
        if (this.isDisablePain) {
            localPlayer.getStats().setPain(0.0f);
        }
        if (this.isDisablePanic) {
            localPlayer.getStats().setPanic(0.0f);
        }
        if (this.isDisableMorale) {
            localPlayer.getStats().setMorale(1.0f);
        }
        if (this.isDisableStress) {
            localPlayer.getStats().setStress(0.0f);
        }
        if (this.isDisableSickness) {
            localPlayer.getStats().setSickness(0.0f);
        }
        if (this.isDisableStressFromCigarettes) {
            localPlayer.getStats().setStressFromCigarettes(0.0f);
        }
        if (this.isDisableSanity) {
            localPlayer.getStats().setSanity(1.0f);
        }
        if (this.isDisableBoredomLevel) {
            localPlayer.getBodyDamage().setBoredomLevel(0.0f);
        }
        if (this.isDisableUnhappynessLevel) {
            localPlayer.getBodyDamage().setUnhappynessLevel(0.0f);
        }
        if (this.isDisableWetness) {
            localPlayer.getBodyDamage().setWetness(0.0f);
        }
        if (this.isDisableInfectionLevel) {
            localPlayer.getBodyDamage().setInfectionLevel(0.0f);
        }
        if (this.isDisableFakeInfectionLevel) {
            localPlayer.getBodyDamage().setFakeInfectionLevel(0.0f);
        }
        if (this.isOptimalCalories) {
            localPlayer.getNutrition().setCalories(1200.0f);
        }
        if (this.isOptimalWeight) {
            localPlayer.getNutrition().setWeight(80.0);
        }
    }

    private void bypassDebugMode() {
        boolean isGameActive = GameClient.bIngame;
        boolean isAntiCheatProtectionEnabled = ServerOptions.instance.getBoolean("AntiCheatProtectionType12");
        boolean isServerMode = GameServer.bServer;
        boolean isCooperativeMode = GameServer.bCoop;
        Core.bDebug = isGameActive && this.isBypassDebugMode && (!isAntiCheatProtectionEnabled && isServerMode || isCooperativeMode || !isServerMode);
    }

    @SubscribeLuaEvent(eventName="OnPostUIDraw")
    public void updateVisuals() {
        try {
            this.updatePlayersVisuals();
            this.updateVehiclesVisuals();
            this.updateZombiesVisuals();
            this.updateUltraPlayerVision();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateUltraPlayerVision() {
        ArrayList<IsoPlayer> arrayList;
        ArrayList<IsoZombie> zombies;
        if (!this.isVisualEnable360Vision) {
            return;
        }
        ArrayList<BaseVehicle> vehicles = IsoWorld.instance.getCell().getVehicles();
        if (vehicles != null && !vehicles.isEmpty()) {
            for (BaseVehicle baseVehicle : vehicles) {
                baseVehicle.setAlpha(100.0f);
            }
        }
        if ((zombies = IsoWorld.instance.getCell().getZombieList()) != null && !zombies.isEmpty()) {
            for (IsoZombie zombie : zombies) {
                zombie.setAlpha(100.0f);
            }
        }
        if ((arrayList = GameClient.instance.getPlayers()) != null && !arrayList.isEmpty()) {
            for (IsoPlayer player : arrayList) {
                if (player.isLocalPlayer()) continue;
                player.setAlpha(100.0f);
            }
        }
    }

    private void updateVehiclesVisuals() {
        if (!this.isVisualsEnable || !this.isVisualsVehiclesEnable) {
            return;
        }
        IsoPlayer localPlayer = IsoPlayer.getInstance();
        if (localPlayer == null) {
            return;
        }
        ArrayList<BaseVehicle> vehicles = IsoWorld.instance.getCell().getVehicles();
        float posLocalPlayerX = PlayerUtils.getScreenPositionX(localPlayer);
        float posLocalPlayerY = PlayerUtils.getScreenPositionY(localPlayer);
        float colorA = this.vehiclesUIColor.a;
        float colorR = this.vehiclesUIColor.r;
        float colorG = this.vehiclesUIColor.g;
        float colorB = this.vehiclesUIColor.b;
        if (vehicles == null && vehicles.isEmpty()) {
            return;
        }
        for (BaseVehicle vehicle : vehicles) {
            float vehiclePosX = VehicleUtils.getScreenPositionX(vehicle);
            float vehiclePosY = VehicleUtils.getScreenPositionY(vehicle);
            Rendering.drawTextCenterWithShadow("ID:" + vehicle.getScriptName(), UIFont.Small, vehiclePosX, vehiclePosY, colorR, colorG, colorB, colorA);
            Rendering.drawTextCenterWithShadow(EtherMain.getInstance().etherTranslator.getTranslate("UI_VisualsDraws_VehicleSpeed") + vehicle.getMaxSpeed(), UIFont.Small, vehiclePosX, vehiclePosY + 10.0f, colorR, colorG, colorB, colorA);
            if (!this.isVisualDrawLineToVehicle) continue;
            int distance = (int)PlayerUtils.getDistanceBetweenPlayerAndVehicle(localPlayer, vehicle);
            int textDistance = Math.max(30, Math.min(150, distance));
            float totalLength = (float)Math.sqrt(Math.pow(vehiclePosX - posLocalPlayerX, 2.0) + Math.pow(vehiclePosY - posLocalPlayerY, 2.0));
            float ratio = (float)textDistance / totalLength;
            float textPosX = posLocalPlayerX + ratio * (vehiclePosX - posLocalPlayerX);
            float textPosY = posLocalPlayerY + 60.0f + ratio * (vehiclePosY - posLocalPlayerY);
            Rendering.drawLine((int)vehiclePosX, (int)vehiclePosY, (int)posLocalPlayerX, (int)posLocalPlayerY + 60, colorR, colorG, colorB, 0.8f, 1);
            Rendering.drawTextCenterWithShadow(String.valueOf(distance), UIFont.Small, textPosX, textPosY, colorR, colorG, colorB, colorA);
        }
    }

    private void updateZombiesVisuals() {
        if (!this.isVisualsEnable || !this.isVisualsZombiesEnable) {
            return;
        }
        IsoPlayer localPlayer = IsoPlayer.getInstance();
        if (localPlayer == null) {
            return;
        }
        ArrayList<IsoZombie> zombies = IsoWorld.instance.getCell().getZombieList();
        float colorA = this.zombiesUIColor.a;
        float colorR = this.zombiesUIColor.r;
        float colorG = this.zombiesUIColor.g;
        float colorB = this.zombiesUIColor.b;
        if (zombies == null && zombies.isEmpty()) {
            return;
        }
        for (IsoZombie zombie : zombies) {
            float posX = ZombieUtils.getScreenPositionX(zombie);
            float posY = ZombieUtils.getScreenPositionY(zombie);
            int health = (int)(zombie.getHealth() * 100.0f);
            Rendering.drawTextCenterWithShadow(EtherMain.getInstance().etherTranslator.getTranslate("UI_VisualsDraws_ZombieTitle"), UIFont.Small, posX, posY, colorR, colorG, colorB, colorA);
            Rendering.drawTextCenterWithShadow(EtherMain.getInstance().etherTranslator.getTranslate("UI_VisualsDraws_ZombieHealth") + health, UIFont.Small, posX, posY + 10.0f, colorR, colorG, colorB, colorA);
        }
    }

    private void updatePlayersVisuals() {
        if (!this.isVisualsEnable || !this.isVisualsPlayersEnable) {
            return;
        }
        IsoPlayer localPlayer = IsoPlayer.getInstance();
        if (localPlayer == null) {
            return;
        }
        ArrayList<IsoPlayer> players = GameClient.instance.getPlayers();
        float posLocalPlayerX = PlayerUtils.getScreenPositionX(localPlayer);
        float posLocalPlayerY = PlayerUtils.getScreenPositionY(localPlayer);
        float colorA = this.playersUIColor.a;
        float colorR = this.playersUIColor.r;
        float colorG = this.playersUIColor.g;
        float colorB = this.playersUIColor.b;
        if (players == null && players.isEmpty()) {
            return;
        }
        for (IsoPlayer player : players) {
            float playerPosX = PlayerUtils.getScreenPositionX(player);
            float playerPosY = PlayerUtils.getScreenPositionY(player);
            if (player.isLocalPlayer() && !this.isVisualDrawToLocalPlayer) continue;
            if (this.isVisualDrawPlayerNickname) {
                Rendering.drawTextCenterWithShadow(player.getUsername(), UIFont.Small, playerPosX, playerPosY - 30.0f, colorR, colorG, colorB, colorA);
            }
            if (this.isVisualDrawPlayerInfo) {
                String firstHandItem = player.getPrimaryHandItem() != null ? player.getPrimaryHandItem().getDisplayName() : "None";
                String secondHandItem = player.getSecondaryHandItem() != null ? player.getSecondaryHandItem().getDisplayName() : "None";
                Rendering.drawTextCenterWithShadow(EtherMain.getInstance().etherTranslator.getTranslate("UI_VisualsDraws_PrimaryHand") + firstHandItem, UIFont.Small, playerPosX, playerPosY + 70.0f, colorR, colorG, colorB, colorA);
                Rendering.drawTextCenterWithShadow(EtherMain.getInstance().etherTranslator.getTranslate("UI_VisualsDraws_SecondaryHand") + secondHandItem, UIFont.Small, playerPosX, playerPosY + 80.0f, colorR, colorG, colorB, colorA);
            }
            if (player.isLocalPlayer() || !this.isVisualDrawLineToPlayers || !(PlayerUtils.getDistanceBetweenPlayers(localPlayer, player) < 150.0f)) continue;
            int distance = (int)PlayerUtils.getDistanceBetweenPlayers(player, localPlayer);
            int textDistance = Math.max(30, Math.min(150, distance));
            float totalLength = (float)Math.sqrt(Math.pow(playerPosX - posLocalPlayerX, 2.0) + Math.pow(playerPosY - posLocalPlayerY, 2.0));
            float ratio = (float)textDistance / totalLength;
            float textPosX = posLocalPlayerX + ratio * (playerPosX - posLocalPlayerX);
            float textPosY = posLocalPlayerY + 60.0f + ratio * (playerPosY - posLocalPlayerY);
            Rendering.drawLine((int)playerPosX, (int)playerPosY, (int)posLocalPlayerX, (int)posLocalPlayerY + 60, colorR, colorG, colorB, 0.8f, 1);
            Rendering.drawTextCenterWithShadow(String.valueOf(distance), UIFont.Small, textPosX, textPosY, colorR, colorG, colorB, colorA);
        }
    }

    @SubscribeLuaEvent(eventName="OnRenderTick")
    public void updateAPI() {
        this.updateLocalPlayerFeatures();
        this.bypassDebugMode();
    }
}

