/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import btw.AddonHandler;
import btw.network.packet.TimerSpeedPacket;
import btw.world.util.difficulty.Difficulties;
import btw.world.util.difficulty.Difficulty;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.security.KeyPair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public abstract class MinecraftServer
implements ab,
Runnable,
mc {
    private static MinecraftServer k = null;
    private final aki l;
    private final ma m = new ma("server", this);
    private final File n;
    private final List o = new ArrayList();
    public final hs commandManager;
    public final la a = new la();
    private String q;
    private int r = -1;
    public iz[] b;
    private gu s;
    private boolean t = true;
    private boolean u = false;
    private int v = 0;
    public String c;
    public int d;
    private boolean w;
    private boolean x;
    private boolean y;
    private boolean z;
    private boolean A;
    private String B;
    private int C;
    private long D;
    private long E;
    private long F;
    private long G;
    public final long[] e = new long[100];
    public final long[] f = new long[100];
    public final long[] g = new long[100];
    public final long[] h = new long[100];
    public final long[] i = new long[100];
    public long[][] j;
    private KeyPair H;
    private String I;
    private String J;
    @Environment(value=EnvType.CLIENT)
    private String K;
    private boolean L;
    private boolean M;
    private Difficulty difficultyLevel = Difficulties.STANDARD;
    private boolean N;
    private String O = "";
    private boolean P = false;
    private long Q;
    private String R;
    private boolean S;
    private boolean T = false;
    private static boolean isServer = false;
    private boolean sendTimerSpeedImmediately = false;

    public MinecraftServer(File par1File) {
        k = this;
        this.n = par1File;
        this.commandManager = new hs();
        this.l = new ajq(par1File);
        this.an();
    }

    private void an() {
        fx.a();
    }

    protected abstract boolean c() throws IOException;

    protected void b(String par1Str) {
        if (this.N().b(par1Str)) {
            this.al().a("Converting map!");
            this.c("menu.convertingLevel");
            this.N().a(par1Str, new gn(this));
        }
    }

    protected synchronized void c(String par1Str) {
        this.R = par1Str;
    }

    @Environment(value=EnvType.CLIENT)
    public synchronized String d() {
        return this.R;
    }

    protected void a(String par1Str, String par2Str, long par3, aal par5WorldType, String par6Str) {
        aai var8;
        this.b(par1Str);
        this.c("menu.loadingLevel");
        this.b = new iz[3];
        this.j = new long[this.b.length][100];
        akf var7 = this.l.a(par1Str, true);
        ajv var9 = var7.d();
        if (var9 == null) {
            var8 = new aai(par3, this.g(), this.f(), this.i(), par5WorldType, this.difficultyLevel);
            var8.a(par6Str);
        } else {
            var8 = new aai(var9);
        }
        this.difficultyLevel = var8.getDifficulty();
        if (this.M) {
            var8.a();
        }
        for (int var10 = 0; var10 < this.b.length; ++var10) {
            int var11 = 0;
            if (var10 == 1) {
                var11 = -1;
            }
            if (var10 == 2) {
                var11 = 1;
            }
            this.b[var10] = var10 == 0 ? (this.M() ? new iq(this, var7, par2Str, var11, this.a, this.al()) : new iz(this, var7, par2Str, var11, var8, this.a, this.al())) : new is(this, var7, par2Str, var11, var8, this.b[0], this.a, this.al());
            this.b[var10].a(new iv(this, this.b[var10]));
            if (!this.I()) {
                this.b[var10].M().a(this.g());
            }
            this.s.a(this.b);
        }
        this.setDifficultyForAllWorlds(var8.getDifficulty());
        this.e();
    }

    protected void e() {
        int var5 = 0;
        this.c("menu.generatingTerrain");
        int var6 = 0;
        this.al().a("Preparing start region for level " + var6);
        iz var7 = this.b[var6];
        t var8 = var7.J();
        long var9 = System.currentTimeMillis();
        for (int var11 = -192; var11 <= 192 && this.m(); var11 += 16) {
            for (int var12 = -192; var12 <= 192 && this.m(); var12 += 16) {
                long var13 = System.currentTimeMillis();
                if (var13 - var9 > 1000L) {
                    this.a_("Preparing spawn area", var5 * 100 / 625);
                    var9 = var13;
                }
                ++var5;
                var7.b.c(var8.a + var11 >> 4, var8.c + var12 >> 4);
            }
        }
        this.j();
    }

    public abstract boolean f();

    public abstract aaj g();

    public abstract int h();

    public abstract boolean i();

    protected void a_(String par1Str, int par2) {
        this.c = par1Str;
        this.d = par2;
        this.al().a(par1Str + ": " + par2 + "%");
    }

    protected void j() {
        this.c = null;
        this.d = 0;
    }

    protected void a(boolean par1) {
        if (!this.N) {
            for (iz var5 : this.b) {
                if (var5 == null) continue;
                if (!par1) {
                    this.al().a("Saving chunks for level '" + var5.M().k() + "'/" + var5.t.l());
                }
                try {
                    var5.a(true, (lc)null);
                }
                catch (aaf var7) {
                    this.al().b(var7.getMessage());
                }
            }
        }
    }

    public void k() {
        if (!this.N) {
            this.al().a("Stopping server");
            if (this.ae() != null) {
                this.ae().a();
            }
            if (this.s != null) {
                this.al().a("Saving players");
                this.s.g();
                this.s.r();
            }
            this.al().a("Saving worlds");
            this.a(false);
            for (int var1 = 0; var1 < this.b.length; ++var1) {
                iz var2 = this.b[var1];
                var2.n();
            }
            if (this.m != null && this.m.d()) {
                this.m.e();
            }
        }
    }

    public String l() {
        return this.q;
    }

    public void d(String par1Str) {
        this.q = par1Str;
    }

    public boolean m() {
        return this.t;
    }

    public void n() {
        this.t = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.c()) {
                long prevTimeMillis;
                long lastTimerUpdateTime = prevTimeMillis = System.currentTimeMillis();
                int ticksSinceLastTimerUpdate = 0;
                long timeSinceLastTick = 0L;
                while (this.t) {
                    long currentTimeMillis = System.currentTimeMillis();
                    long timeDiff = currentTimeMillis - prevTimeMillis;
                    if (timeDiff > 2000L && prevTimeMillis - this.Q >= 15000L) {
                        this.al().b("Can't keep up! Did the system time change, or is the server overloaded?");
                        timeDiff = 2000L;
                        this.Q = prevTimeMillis;
                    }
                    if (timeDiff < 0L) {
                        this.al().b("Time ran backwards! Did the system time change?");
                        timeDiff = 0L;
                    }
                    timeSinceLastTick += timeDiff;
                    prevTimeMillis = currentTimeMillis;
                    float speedModifier = this.getMinSpeedModifier();
                    if (speedModifier > 1.0f) {
                        if ((float)timeSinceLastTick > 50.0f / speedModifier) {
                            timeSinceLastTick -= (long)(50.0f / speedModifier);
                            this.q();
                            ++ticksSinceLastTimerUpdate;
                        }
                    } else if (timeSinceLastTick > 50L) {
                        timeSinceLastTick -= 50L;
                        this.q();
                        ++ticksSinceLastTimerUpdate;
                    }
                    if ((currentTimeMillis = System.currentTimeMillis()) - lastTimerUpdateTime > 1000L || this.sendTimerSpeedImmediately) {
                        speedModifier = this.getMinSpeedModifier();
                        this.sendTimerSpeedUpdate(Math.min(50.0f / ((float)(currentTimeMillis - lastTimerUpdateTime) / (float)ticksSinceLastTimerUpdate), speedModifier));
                        lastTimerUpdateTime = System.currentTimeMillis();
                        ticksSinceLastTimerUpdate = 0;
                        this.sendTimerSpeedImmediately = false;
                    }
                    Thread.sleep(1L);
                    this.P = true;
                }
            } else {
                this.a((b)null);
            }
        }
        catch (Throwable var48) {
            var48.printStackTrace();
            this.al().c("Encountered an unexpected exception " + var48.getClass().getSimpleName(), var48);
            b var2 = null;
            var2 = var48 instanceof u ? this.b(((u)var48).a()) : this.b(new b("Exception in server tick loop", var48));
            File var3 = new File(new File(this.o(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
            if (var2.a(var3, this.al())) {
                this.al().c("This crash report has been saved to: " + var3.getAbsolutePath());
            } else {
                this.al().c("We were unable to save this crash report to disk.");
            }
            this.a(var2);
        }
        finally {
            try {
                this.k();
                this.u = true;
            }
            catch (Throwable var46) {
                var46.printStackTrace();
            }
            finally {
                this.p();
            }
        }
    }

    protected File o() {
        return new File(".");
    }

    protected void a(b par1CrashReport) {
    }

    protected void p() {
    }

    public void q() {
        long var1 = System.nanoTime();
        aqx.a().a();
        ++this.v;
        if (this.S) {
            this.S = false;
            this.a.a = true;
            this.a.a();
        }
        this.a.a("root");
        this.r();
        if (this.v % 900 == 0) {
            this.a.a("save");
            this.s.g();
            this.a(true);
            this.a.b();
        }
        this.a.a("tallying");
        this.i[this.v % 100] = System.nanoTime() - var1;
        this.e[this.v % 100] = ei.q - this.D;
        this.D = ei.q;
        this.f[this.v % 100] = ei.r - this.E;
        this.E = ei.r;
        this.g[this.v % 100] = ei.o - this.F;
        this.F = ei.o;
        this.h[this.v % 100] = ei.p - this.G;
        this.G = ei.p;
        this.a.b();
        this.a.a("snooper");
        if (!this.m.d() && this.v > 100) {
            this.m.a();
        }
        if (this.v % 6000 == 0) {
            this.m.b();
        }
        this.a.b();
        this.a.b();
    }

    public void r() {
        int var1;
        this.a.a("levels");
        for (var1 = 0; var1 < this.b.length; ++var1) {
            long var2 = System.nanoTime();
            if (var1 == 0 || this.s()) {
                iz var4 = this.b[var1];
                this.a.a(var4.M().k());
                this.a.a("pools");
                var4.U().a();
                this.a.b();
                if (this.v % 20 == 0) {
                    this.a.a("timeSync");
                    this.s.a((ei)new fh(var4.H(), var4.I()), var4.t.h);
                    this.a.b();
                }
                this.a.a("tick");
                try {
                    var4.b();
                }
                catch (Throwable var8) {
                    b var6 = b.a(var8, "Exception ticking world");
                    var4.a(var6);
                    throw new u(var6);
                }
                try {
                    var4.h();
                }
                catch (Throwable var7) {
                    b var6 = b.a(var7, "Exception ticking world entities");
                    var4.a(var6);
                    throw new u(var6);
                }
                this.a.b();
                this.a.a("tracker");
                var4.q().a();
                this.a.b();
                this.a.b();
            }
            this.j[var1][this.v % 100] = System.nanoTime() - var2;
        }
        this.a.c("connection");
        this.ae().b();
        this.a.c("players");
        this.s.b();
        this.a.c("tickables");
        for (var1 = 0; var1 < this.o.size(); ++var1) {
            ((gy)this.o.get(var1)).a();
        }
        this.a.b();
    }

    public boolean s() {
        return true;
    }

    public void a(gy par1IUpdatePlayerListBox) {
        this.o.add(par1IUpdatePlayerListBox);
    }

    public static void main(String[] par0ArrayOfStr) {
        isServer = true;
        kf.a();
        AddonHandler.initializeLogger();
        ku var1 = null;
        try {
            boolean var2 = !GraphicsEnvironment.isHeadless();
            String var3 = null;
            String var4 = ".";
            String var5 = null;
            boolean var6 = false;
            boolean var7 = false;
            int var8 = -1;
            for (int var9 = 0; var9 < par0ArrayOfStr.length; ++var9) {
                String var10 = par0ArrayOfStr[var9];
                String var11 = var9 == par0ArrayOfStr.length - 1 ? null : par0ArrayOfStr[var9 + 1];
                boolean var12 = false;
                if (!var10.equals("nogui") && !var10.equals("--nogui")) {
                    if (var10.equals("--port") && var11 != null) {
                        var12 = true;
                        try {
                            var8 = Integer.parseInt(var11);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else if (var10.equals("--singleplayer") && var11 != null) {
                        var12 = true;
                        var3 = var11;
                    } else if (var10.equals("--universe") && var11 != null) {
                        var12 = true;
                        var4 = var11;
                    } else if (var10.equals("--world") && var11 != null) {
                        var12 = true;
                        var5 = var11;
                    } else if (var10.equals("--demo")) {
                        var6 = true;
                    } else if (var10.equals("--bonusChest")) {
                        var7 = true;
                    }
                } else {
                    var2 = false;
                }
                if (!var12) continue;
                ++var9;
            }
            hz var16 = new hz(new File(var4));
            var1 = var16.al();
            if (var3 != null) {
                var16.k(var3);
            }
            if (var5 != null) {
                var16.l(var5);
            }
            if (var8 >= 0) {
                var16.b(var8);
            }
            if (var6) {
                var16.b(true);
            }
            if (var7) {
                var16.c(true);
            }
            if (var2) {
                var16.ap();
            }
            var16.t();
            Runtime.getRuntime().addShutdownHook(new go(var16));
        }
        catch (Exception var15) {
            if (var1 != null) {
                var1.c("Failed to start the minecraft server", var15);
            }
            Logger.getAnonymousLogger().log(Level.SEVERE, "Failed to start the minecraft server", var15);
        }
    }

    public void t() {
        new gp(this, "Server thread").start();
    }

    public File e(String par1Str) {
        return new File(this.o(), par1Str);
    }

    public void f(String par1Str) {
        this.al().a(par1Str);
    }

    public void g(String par1Str) {
        this.al().b(par1Str);
    }

    public iz a(int par1) {
        return par1 == -1 ? this.b[1] : (par1 == 1 ? this.b[2] : this.b[0]);
    }

    public String u() {
        return this.q;
    }

    public int v() {
        return this.r;
    }

    public String w() {
        return this.B;
    }

    public String x() {
        return "1.5.2";
    }

    public int y() {
        return this.s.k();
    }

    public int z() {
        return this.s.l();
    }

    public String[] A() {
        return this.s.d();
    }

    public String B() {
        return "";
    }

    public String h(String par1Str) {
        jn.a.c();
        this.commandManager.a((ab)jn.a, par1Str);
        return jn.a.d();
    }

    public boolean C() {
        return false;
    }

    public void i(String par1Str) {
        this.al().c(par1Str);
    }

    public void j(String par1Str) {
        if (this.C()) {
            this.al().a(par1Str);
        }
    }

    public String getServerModName() {
        return "vanilla";
    }

    public b b(b par1CrashReport) {
        par1CrashReport.g().a("Profiler Position", (Callable)new gq(this));
        if (this.b != null && this.b.length > 0 && this.b[0] != null) {
            par1CrashReport.g().a("Vec3 Pool Size", (Callable)new gr(this));
        }
        if (this.s != null) {
            par1CrashReport.g().a("Player Count", (Callable)new gs(this));
        }
        return par1CrashReport;
    }

    public List a(ab par1ICommandSender, String par2Str) {
        ArrayList<String> var3 = new ArrayList<String>();
        if (par2Str.startsWith("/")) {
            boolean var10 = !(par2Str = par2Str.substring(1)).contains(" ");
            List var11 = this.commandManager.b(par1ICommandSender, par2Str);
            if (var11 != null) {
                for (String var13 : var11) {
                    if (var10) {
                        var3.add("/" + var13);
                        continue;
                    }
                    var3.add(var13);
                }
            }
            return var3;
        }
        String[] var4 = par2Str.split(" ", -1);
        String var5 = var4[var4.length - 1];
        for (String var9 : this.s.d()) {
            if (!x.a((String)var5, (String)var9)) continue;
            var3.add(var9);
        }
        return var3;
    }

    public static MinecraftServer D() {
        return k;
    }

    public String c_() {
        return "Server";
    }

    public void a(String par1Str) {
        this.al().a(lf.a(par1Str));
    }

    public boolean a(int par1, String par2Str) {
        return true;
    }

    public String a(String par1Str, Object ... par2ArrayOfObj) {
        return bp.a().a(par1Str, par2ArrayOfObj);
    }

    public aa E() {
        return this.commandManager;
    }

    public KeyPair F() {
        return this.H;
    }

    public int G() {
        return this.r;
    }

    public void b(int par1) {
        this.r = par1;
    }

    public String H() {
        return this.I;
    }

    public void k(String par1Str) {
        this.I = par1Str;
    }

    public boolean I() {
        return this.I != null;
    }

    public String J() {
        return this.J;
    }

    public void l(String par1Str) {
        this.J = par1Str;
    }

    @Environment(value=EnvType.CLIENT)
    public void m(String par1Str) {
        this.K = par1Str;
    }

    @Environment(value=EnvType.CLIENT)
    public String K() {
        return this.K;
    }

    public void a(KeyPair par1KeyPair) {
        this.H = par1KeyPair;
    }

    public void setDifficultyForAllWorlds(Difficulty difficulty) {
        for (int var2 = 0; var2 < this.b.length; ++var2) {
            iz var3 = this.b[var2];
            if (var3 == null) continue;
            var3.x.setDifficulty(difficulty);
        }
    }

    protected boolean L() {
        return true;
    }

    public boolean M() {
        return this.L;
    }

    public void b(boolean par1) {
        this.L = par1;
    }

    public void c(boolean par1) {
        this.M = par1;
    }

    public aki N() {
        return this.l;
    }

    public void P() {
        this.N = true;
        this.N().d();
        for (int var1 = 0; var1 < this.b.length; ++var1) {
            iz var2 = this.b[var1];
            if (var2 == null) continue;
            var2.n();
        }
        this.N().e(this.b[0].L().g());
        this.n();
    }

    public String Q() {
        return this.O;
    }

    public void n(String par1Str) {
        this.O = par1Str;
    }

    public void a(ma par1PlayerUsageSnooper) {
        par1PlayerUsageSnooper.a("whitelist_enabled", false);
        par1PlayerUsageSnooper.a("whitelist_count", 0);
        par1PlayerUsageSnooper.a("players_current", this.y());
        par1PlayerUsageSnooper.a("players_max", this.z());
        par1PlayerUsageSnooper.a("players_seen", this.s.m().length);
        par1PlayerUsageSnooper.a("uses_auth", this.w);
        par1PlayerUsageSnooper.a("gui_state", this.ag() ? "enabled" : "disabled");
        par1PlayerUsageSnooper.a("avg_tick_ms", (int)(kx.a(this.i) * 1.0E-6));
        par1PlayerUsageSnooper.a("avg_sent_packet_count", (int)kx.a(this.e));
        par1PlayerUsageSnooper.a("avg_sent_packet_size", (int)kx.a(this.f));
        par1PlayerUsageSnooper.a("avg_rec_packet_count", (int)kx.a(this.g));
        par1PlayerUsageSnooper.a("avg_rec_packet_size", (int)kx.a(this.h));
        int var2 = 0;
        for (int var3 = 0; var3 < this.b.length; ++var3) {
            if (this.b[var3] == null) continue;
            iz var4 = this.b[var3];
            ajv var5 = var4.M();
            par1PlayerUsageSnooper.a("world[" + var2 + "][dimension]", var4.t.h);
            par1PlayerUsageSnooper.a("world[" + var2 + "][mode]", (Object)var5.r());
            par1PlayerUsageSnooper.a("world[" + var2 + "][difficulty]", var4.r);
            par1PlayerUsageSnooper.a("world[" + var2 + "][hardcore]", var5.t());
            par1PlayerUsageSnooper.a("world[" + var2 + "][generator_name]", var5.u().a());
            par1PlayerUsageSnooper.a("world[" + var2 + "][generator_version]", var5.u().c());
            par1PlayerUsageSnooper.a("world[" + var2 + "][height]", this.C);
            par1PlayerUsageSnooper.a("world[" + var2 + "][chunks_loaded]", var4.K().f());
            ++var2;
        }
        par1PlayerUsageSnooper.a("worlds", var2);
    }

    public void b(ma par1PlayerUsageSnooper) {
        par1PlayerUsageSnooper.a("singleplayer", this.I());
        par1PlayerUsageSnooper.a("server_brand", this.getServerModName());
        par1PlayerUsageSnooper.a("gui_supported", GraphicsEnvironment.isHeadless() ? "headless" : "supported");
        par1PlayerUsageSnooper.a("dedicated", this.T());
    }

    public boolean R() {
        return true;
    }

    public int S() {
        return 16;
    }

    public abstract boolean T();

    public boolean U() {
        return this.w;
    }

    public void d(boolean par1) {
        this.w = par1;
    }

    public boolean V() {
        return this.x;
    }

    public void e(boolean par1) {
        this.x = par1;
    }

    public boolean W() {
        return this.y;
    }

    public void f(boolean par1) {
        this.y = par1;
    }

    public boolean X() {
        return this.z;
    }

    public void g(boolean par1) {
        this.z = par1;
    }

    public boolean Y() {
        return this.A;
    }

    public void h(boolean par1) {
        this.A = par1;
    }

    public abstract boolean Z();

    public String aa() {
        return this.B;
    }

    public void o(String par1Str) {
        this.B = par1Str;
    }

    public int ab() {
        return this.C;
    }

    public void d(int par1) {
        this.C = par1;
    }

    public boolean ac() {
        return this.u;
    }

    public gu ad() {
        return this.s;
    }

    public void a(gu par1ServerConfigurationManager) {
        this.s = par1ServerConfigurationManager;
    }

    public void a(aaj par1EnumGameType) {
        for (int var2 = 0; var2 < this.b.length; ++var2) {
            MinecraftServer.D().b[var2].M().a(par1EnumGameType);
        }
    }

    public abstract jk ae();

    @Environment(value=EnvType.CLIENT)
    public boolean af() {
        return this.P;
    }

    public boolean ag() {
        return false;
    }

    public abstract String a(aaj var1, boolean var2);

    public int ah() {
        return this.v;
    }

    public void ai() {
        this.S = true;
    }

    @Environment(value=EnvType.CLIENT)
    public ma aj() {
        return this.m;
    }

    public t b() {
        return new t(0, 0, 0);
    }

    public int ak() {
        return 16;
    }

    public boolean a(aab par1World, int par2, int par3, int par4, sq par5EntityPlayer) {
        return false;
    }

    public abstract ku al();

    public void i(boolean par1) {
        this.T = par1;
    }

    public boolean am() {
        return this.T;
    }

    public static gu a(MinecraftServer par0MinecraftServer) {
        return par0MinecraftServer.s;
    }

    public static boolean getIsServer() {
        return isServer;
    }

    private float getMinSpeedModifier() {
        float minSpeedModifier = Float.MAX_VALUE;
        for (iz world : this.b) {
            float speedModifier;
            if (world == null || world.h.isEmpty() || !((speedModifier = world.getMinSpeedModifier()) < minSpeedModifier)) continue;
            minSpeedModifier = speedModifier;
        }
        return minSpeedModifier == Float.MAX_VALUE ? 1.0f : minSpeedModifier;
    }

    private void sendTimerSpeedUpdate(float speedModifier) {
        speedModifier = Math.max(speedModifier, 1.0f);
        this.ad().a(new TimerSpeedPacket(speedModifier));
    }

    public void sendTimerSpeedImmediately() {
        this.sendTimerSpeedImmediately = true;
    }

    public void setDifficultyFromName(String challengeLevel) {
        this.setDifficulty(Difficulties.getDifficultyFromName(challengeLevel));
    }

    public void setDifficulty(Difficulty difficultyLevel) {
        this.difficultyLevel = difficultyLevel;
    }
}

