/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.sky;

import com.prupe.mcpatcher.Config;
import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.mal.resource.BlendMethod;
import com.prupe.mcpatcher.mal.resource.FakeResourceLocation;
import com.prupe.mcpatcher.mal.resource.GLAPI;
import com.prupe.mcpatcher.mal.resource.PropertiesFile;
import com.prupe.mcpatcher.mal.resource.TexturePackAPI;
import com.prupe.mcpatcher.mal.resource.TexturePackChangeHandler;
import com.prupe.mcpatcher.mal.tessellator.TessellatorAPI;
import com.prupe.mcpatcher.sky.FireworksHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

@Environment(value=EnvType.CLIENT)
public class SkyRenderer {
    private static final MCLogger logger = MCLogger.getLogger("Better Skies");
    private static final boolean enable = Config.getBoolean("Better Skies", "skybox", true);
    private static final boolean unloadTextures = Config.getBoolean("Better Skies", "unloadTextures", true);
    public static final double horizonHeight = Config.getInt("Better Skies", "horizon", 16);
    private static double worldTime;
    private static float celestialAngle;
    private static float rainStrength;
    private static final HashMap<Integer, WorldEntry> worldSkies;
    private static WorldEntry currentWorld;
    public static boolean active;

    public static void setup(aab world, float partialTick, float celestialAngle) {
        if (TexturePackAPI.isDefaultTexturePack()) {
            active = false;
        } else {
            int worldType = Minecraft.x().e.t.getWorldType();
            WorldEntry newEntry = SkyRenderer.getWorldEntry(worldType);
            if (newEntry != currentWorld && currentWorld != null) {
                currentWorld.unloadTextures();
            }
            if (active = (currentWorld = newEntry).active()) {
                worldTime = (float)world.I() + partialTick;
                rainStrength = 1.0f - world.i(partialTick);
                SkyRenderer.celestialAngle = celestialAngle;
            }
        }
    }

    public static void renderAll() {
        if (active) {
            currentWorld.renderAll(TessellatorAPI.getTessellator());
        }
    }

    public static FakeResourceLocation setupCelestialObject(FakeResourceLocation defaultTexture) {
        if (active) {
            Layer.clearBlendingMethod();
            Layer layer = currentWorld.getCelestialObject(defaultTexture);
            if (layer != null) {
                layer.setBlendingMethod(rainStrength);
                return layer.texture;
            }
        }
        return defaultTexture;
    }

    private static WorldEntry getWorldEntry(int worldType) {
        WorldEntry entry = worldSkies.get(worldType);
        if (entry == null) {
            entry = new WorldEntry(worldType);
            worldSkies.put(worldType, entry);
        }
        return entry;
    }

    static {
        worldSkies = new HashMap();
        TexturePackChangeHandler.register(new TexturePackChangeHandler("Better Skies", 2){

            @Override
            public void beforeChange() {
                worldSkies.clear();
            }

            @Override
            public void afterChange() {
                bds world;
                if (enable && (world = Minecraft.x().e) != null) {
                    SkyRenderer.getWorldEntry(world.t.getWorldType());
                }
                FireworksHelper.reload();
            }
        });
    }

    @Environment(value=EnvType.CLIENT)
    private static class WorldEntry {
        private final int worldType;
        private final List<Layer> skies = new ArrayList<Layer>();
        private final Map<FakeResourceLocation, Layer> objects = new HashMap<FakeResourceLocation, Layer>();
        private final Set<FakeResourceLocation> textures = new HashSet<FakeResourceLocation>();

        WorldEntry(int worldType) {
            this.worldType = worldType;
            this.loadSkies();
            this.loadCelestialObject("sun");
            this.loadCelestialObject("moon_phases");
        }

        private void loadSkies() {
            int i2 = -1;
            while (true) {
                String path;
                FakeResourceLocation resource;
                Layer layer;
                if ((layer = Layer.create(resource = TexturePackAPI.newMCPatcherResourceLocation(path = "/environment/sky" + this.worldType + "/sky" + (i2 < 0 ? "" : String.valueOf(i2)) + ".properties"))) == null) {
                    if (i2 > 0) {
                        break;
                    }
                } else if (layer.properties.valid()) {
                    logger.fine("loaded %s", resource);
                    this.skies.add(layer);
                    this.textures.add(layer.texture);
                }
                ++i2;
            }
        }

        private void loadCelestialObject(String objName) {
            FakeResourceLocation textureName = new FakeResourceLocation("/environment/" + objName + ".png");
            String path = "/environment/sky" + this.worldType + "/" + objName + ".properties";
            FakeResourceLocation resource = TexturePackAPI.newMCPatcherResourceLocation(path);
            PropertiesFile properties = PropertiesFile.get(logger, resource);
            if (properties != null) {
                properties.setProperty("fade", "false");
                properties.setProperty("rotate", "true");
                Layer layer = new Layer(properties);
                if (properties.valid()) {
                    logger.fine("using %s (%s) for the %s", resource, layer.texture, objName);
                    this.objects.put(textureName, layer);
                }
            }
        }

        boolean active() {
            return !this.skies.isEmpty() || !this.objects.isEmpty();
        }

        void renderAll(bgd tessellator) {
            if (unloadTextures) {
                HashSet<FakeResourceLocation> texturesNeeded = new HashSet<FakeResourceLocation>();
                for (Layer layer : this.skies) {
                    if (!layer.prepare()) continue;
                    texturesNeeded.add(layer.texture);
                }
                HashSet<FakeResourceLocation> texturesToUnload = new HashSet<FakeResourceLocation>();
                texturesToUnload.addAll(this.textures);
                texturesToUnload.removeAll(texturesNeeded);
                for (FakeResourceLocation resource : texturesToUnload) {
                    TexturePackAPI.unloadTexture(resource);
                }
            }
            for (Layer layer : this.skies) {
                if (!unloadTextures) {
                    layer.prepare();
                }
                if (!(layer.brightness > 0.0f)) continue;
                layer.render(tessellator);
                Layer.clearBlendingMethod();
            }
        }

        Layer getCelestialObject(FakeResourceLocation defaultTexture) {
            return this.objects.get(defaultTexture);
        }

        void unloadTextures() {
            for (Layer layer : this.skies) {
                TexturePackAPI.unloadTexture(layer.texture);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class Layer {
        private static final int SECS_PER_DAY = 86400;
        private static final int TICKS_PER_DAY = 24000;
        private static final double TOD_OFFSET = -0.25;
        private static final double SKY_DISTANCE = 100.0;
        private final PropertiesFile properties;
        private FakeResourceLocation texture;
        private boolean fade;
        private boolean rotate;
        private float[] axis;
        private float speed;
        private BlendMethod blendMethod;
        private double a;
        private double b;
        private double c;
        float brightness;

        static Layer create(FakeResourceLocation resource) {
            PropertiesFile properties = PropertiesFile.get(logger, resource);
            if (properties == null) {
                return null;
            }
            return new Layer(properties);
        }

        Layer(PropertiesFile properties) {
            this.properties = properties;
            boolean valid = this.readTexture() && this.readRotation() & this.readBlendingMethod() && this.readFadeTimers();
        }

        private boolean readTexture() {
            this.texture = this.properties.getResourceLocation("source", this.properties.toString().replaceFirst("\\.properties$", ".png"));
            if (TexturePackAPI.hasResource(this.texture)) {
                return true;
            }
            return this.properties.error("source texture %s not found", this.texture);
        }

        private boolean readRotation() {
            this.rotate = this.properties.getBoolean("rotate", true);
            if (this.rotate) {
                this.speed = this.properties.getFloat("speed", 1.0f);
                String value = this.properties.getString("axis", "0.0 0.0 1.0");
                String[] tokens = value.split("\\s+");
                if (tokens.length == 3) {
                    float z2;
                    float y2;
                    float x2;
                    try {
                        x2 = Float.parseFloat(tokens[0]);
                        y2 = Float.parseFloat(tokens[1]);
                        z2 = Float.parseFloat(tokens[2]);
                    }
                    catch (NumberFormatException e2) {
                        return this.properties.error("invalid rotation axis", new Object[0]);
                    }
                    if (x2 * x2 + y2 * y2 + z2 * z2 == 0.0f) {
                        return this.properties.error("rotation axis cannot be 0", new Object[0]);
                    }
                    this.axis = new float[]{z2, y2, -x2};
                } else {
                    return this.properties.error("invalid rotate value %s", value);
                }
            }
            return true;
        }

        private boolean readBlendingMethod() {
            String value = this.properties.getString("blend", "add");
            this.blendMethod = BlendMethod.parse(value);
            if (this.blendMethod == null) {
                return this.properties.error("unknown blend method %s", value);
            }
            return true;
        }

        private boolean readFadeTimers() {
            int endFadeIn;
            this.fade = this.properties.getBoolean("fade", true);
            if (!this.fade) {
                return true;
            }
            int startFadeIn = this.parseTime(this.properties, "startFadeIn");
            int endFadeOut = this.parseTime(this.properties, "endFadeOut");
            if (!this.properties.valid()) {
                return false;
            }
            for (endFadeIn = this.parseTime(this.properties, "endFadeIn"); endFadeIn <= startFadeIn; endFadeIn += 86400) {
            }
            while (endFadeOut <= endFadeIn) {
                endFadeOut += 86400;
            }
            if (endFadeOut - startFadeIn >= 86400) {
                return this.properties.error("fade times must fall within a 24 hour period", new Object[0]);
            }
            int startFadeOut = startFadeIn + endFadeOut - endFadeIn;
            double s0 = Layer.normalize(startFadeIn, 86400, -0.25);
            double s1 = Layer.normalize(endFadeIn, 86400, -0.25);
            double e0 = Layer.normalize(startFadeOut, 86400, -0.25);
            double e1 = Layer.normalize(endFadeOut, 86400, -0.25);
            double det = Math.cos(s0) * Math.sin(s1) + Math.cos(e1) * Math.sin(s0) + Math.cos(s1) * Math.sin(e1) - Math.cos(s0) * Math.sin(e1) - Math.cos(s1) * Math.sin(s0) - Math.cos(e1) * Math.sin(s1);
            if (det == 0.0) {
                return this.properties.error("determinant is 0", new Object[0]);
            }
            this.a = (Math.sin(e1) - Math.sin(s0)) / det;
            this.b = (Math.cos(s0) - Math.cos(e1)) / det;
            this.c = (Math.cos(e1) * Math.sin(s0) - Math.cos(s0) * Math.sin(e1)) / det;
            logger.finer("%s: y = %f cos x + %f sin x + %f", this.properties, this.a, this.b, this.c);
            logger.finer("  at %f: %f", s0, this.f(s0));
            logger.finer("  at %f: %f", s1, this.f(s1));
            logger.finer("  at %f: %f", e0, this.f(e0));
            logger.finer("  at %f: %f", e1, this.f(e1));
            return true;
        }

        private int parseTime(PropertiesFile properties, String key) {
            String s2 = properties.getString(key, "");
            if ("".equals(s2)) {
                properties.error("missing value for %s", key);
                return -1;
            }
            String[] t2 = s2.split(":");
            if (t2.length >= 2) {
                try {
                    int hh = Integer.parseInt(t2[0].trim());
                    int mm2 = Integer.parseInt(t2[1].trim());
                    int ss2 = t2.length >= 3 ? Integer.parseInt(t2[2].trim()) : 0;
                    return (3600 * hh + 60 * mm2 + ss2) % 86400;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            properties.error("invalid %s time %s", key, s2);
            return -1;
        }

        private static double normalize(double time, int period, double offset) {
            return Math.PI * 2 * (time / (double)period + offset);
        }

        private double f(double x2) {
            return this.a * Math.cos(x2) + this.b * Math.sin(x2) + this.c;
        }

        boolean prepare() {
            this.brightness = rainStrength;
            if (this.fade) {
                double x2 = Layer.normalize(worldTime, 24000, 0.0);
                this.brightness *= (float)this.f(x2);
            }
            if (this.brightness <= 0.0f) {
                return false;
            }
            if (this.brightness > 1.0f) {
                this.brightness = 1.0f;
            }
            return true;
        }

        boolean render(bgd tessellator) {
            TexturePackAPI.bindTexture(this.texture);
            this.setBlendingMethod(this.brightness);
            GL11.glPushMatrix();
            if (this.rotate) {
                GL11.glRotatef((float)(celestialAngle * 360.0f * this.speed), (float)this.axis[0], (float)this.axis[1], (float)this.axis[2]);
            }
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            Layer.drawTile(tessellator, 4);
            GL11.glPushMatrix();
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            Layer.drawTile(tessellator, 1);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            Layer.drawTile(tessellator, 0);
            GL11.glPopMatrix();
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            Layer.drawTile(tessellator, 5);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            Layer.drawTile(tessellator, 2);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            Layer.drawTile(tessellator, 3);
            GL11.glPopMatrix();
            return true;
        }

        private static void drawTile(bgd tessellator, int tile) {
            double tileX = (double)(tile % 3) / 3.0;
            double tileY = (double)(tile / 3) / 2.0;
            TessellatorAPI.startDrawingQuads(tessellator);
            TessellatorAPI.addVertexWithUV(tessellator, -100.0, -100.0, -100.0, tileX, tileY);
            TessellatorAPI.addVertexWithUV(tessellator, -100.0, -100.0, 100.0, tileX, tileY + 0.5);
            TessellatorAPI.addVertexWithUV(tessellator, 100.0, -100.0, 100.0, tileX + 0.3333333333333333, tileY + 0.5);
            TessellatorAPI.addVertexWithUV(tessellator, 100.0, -100.0, -100.0, tileX + 0.3333333333333333, tileY);
            TessellatorAPI.draw(tessellator);
        }

        void setBlendingMethod(float brightness) {
            this.blendMethod.applyFade(brightness);
            this.blendMethod.applyAlphaTest();
            this.blendMethod.applyBlending();
            GL11.glEnable((int)3553);
        }

        static void clearBlendingMethod() {
            GL11.glDisable((int)3008);
            GL11.glEnable((int)3042);
            GLAPI.glBlendFunc(770, 1);
            GLAPI.glColor4f(1.0f, 1.0f, 1.0f, rainStrength);
        }
    }
}

