/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.renderpass;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public abstract class RenderPassMap {
    private static final int[] MAP = new int[]{0, 0, 0, 1, 2, 3};

    public static int map18To17(int pass) {
        return pass > 1 ? RenderPassMap.MCPatcherToVanilla(pass) : pass;
    }

    public static int map17To18(int pass) {
        return pass <= 1 ? RenderPassMap.vanillaToMCPatcher(pass) : pass;
    }

    protected static int vanillaToMCPatcher(int pass) {
        for (int i2 = 0; i2 < MAP.length; ++i2) {
            if (MAP[i2] != pass) continue;
            return i2;
        }
        return -1;
    }

    protected static int MCPatcherToVanilla(int pass) {
        return pass >= 0 && pass < MAP.length ? MAP[pass] : -1;
    }

    protected static int getDefaultRenderPass(apa block) {
        return RenderPassMap.vanillaToMCPatcher(block.n());
    }

    protected static int getCutoutRenderPass() {
        return 0;
    }
}

