/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.mob;

import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.mal.biome.BiomeAPI;
import com.prupe.mcpatcher.mal.resource.FakeResourceLocation;
import com.prupe.mcpatcher.mal.resource.PropertiesFile;
import com.prupe.mcpatcher.mal.resource.TexturePackAPI;
import com.prupe.mcpatcher.mal.util.WeightedIndex;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
class MobRuleList {
    private static final MCLogger logger = MCLogger.getLogger("Random Mobs");
    public static final String ALTERNATIVES_REGEX = "_(eyes|overlay|tame|angry|collar|fur|invulnerable|shooting)\\.properties$";
    private static final Map<FakeResourceLocation, MobRuleList> allRules = new HashMap<FakeResourceLocation, MobRuleList>();
    private final FakeResourceLocation baseSkin;
    private final List<FakeResourceLocation> allSkins;
    private final int skinCount;
    private final List<MobRuleEntry> entries;

    private MobRuleList(FakeResourceLocation baseSkin) {
        FakeResourceLocation skin;
        this.baseSkin = baseSkin;
        String newPath = baseSkin.getPath().replaceFirst("^textures/entity/", "/mob/");
        FakeResourceLocation newSkin = new FakeResourceLocation(baseSkin.getNamespace(), newPath);
        this.allSkins = new ArrayList<FakeResourceLocation>();
        this.allSkins.add(baseSkin);
        int i2 = 2;
        while (TexturePackAPI.hasResource(skin = TexturePackAPI.transformResourceLocation(newSkin, ".png", String.valueOf(i2) + ".png"))) {
            this.allSkins.add(skin);
            ++i2;
        }
        this.skinCount = this.allSkins.size();
        if (this.skinCount <= 1) {
            this.entries = null;
            return;
        }
        logger.fine("found %d variations for %s", this.skinCount, baseSkin);
        FakeResourceLocation filename = TexturePackAPI.transformResourceLocation(newSkin, ".png", ".properties");
        FakeResourceLocation altFilename = new FakeResourceLocation(newSkin.getNamespace(), filename.getPath().replaceFirst(ALTERNATIVES_REGEX, ".properties"));
        PropertiesFile properties = PropertiesFile.get(logger, filename);
        if (properties == null && !filename.equals(altFilename) && (properties = PropertiesFile.get(logger, altFilename)) != null) {
            logger.fine("using %s for %s", altFilename, baseSkin);
        }
        ArrayList<MobRuleEntry> tmpEntries = new ArrayList<MobRuleEntry>();
        if (properties != null) {
            int i3 = 0;
            while (true) {
                MobRuleEntry entry;
                if ((entry = MobRuleEntry.load(properties, i3, this.skinCount)) == null) {
                    if (i3 > 0) {
                        break;
                    }
                } else {
                    logger.fine("  %s", entry.toString());
                    tmpEntries.add(entry);
                }
                ++i3;
            }
        }
        this.entries = tmpEntries.isEmpty() ? null : tmpEntries;
    }

    FakeResourceLocation getSkin(long key, int i2, int j2, int k, Integer biome) {
        if (this.entries == null) {
            int index = (int)(key % (long)this.skinCount);
            if (index < 0) {
                index += this.skinCount;
            }
            return this.allSkins.get(index);
        }
        if (j2 < 0) {
            j2 = 0;
        }
        for (MobRuleEntry entry : this.entries) {
            if (!entry.match(i2, j2, k, biome)) continue;
            int index = entry.weightedIndex.choose(key);
            return this.allSkins.get(entry.skins[index]);
        }
        return this.baseSkin;
    }

    static MobRuleList get(FakeResourceLocation texture) {
        MobRuleList list = allRules.get(texture);
        if (list == null) {
            list = new MobRuleList(texture);
            allRules.put(texture, list);
        }
        return list;
    }

    static void clear() {
        allRules.clear();
    }

    @Environment(value=EnvType.CLIENT)
    private static class MobRuleEntry {
        final int[] skins;
        final WeightedIndex weightedIndex;
        private final BitSet biomes;
        private final BitSet height;

        static MobRuleEntry load(PropertiesFile properties, int index, int limit) {
            BitSet biomes;
            WeightedIndex chooser;
            int i2;
            int[] skins;
            String skinList = properties.getString("skins." + index, "").toLowerCase();
            if (skinList.equals("*") || skinList.equals("all") || skinList.equals("any")) {
                skins = new int[limit];
                for (i2 = 0; i2 < skins.length; ++i2) {
                    skins[i2] = i2;
                }
            } else {
                skins = MCPatcherUtils.parseIntegerList(skinList, 1, limit);
                if (skins.length <= 0) {
                    return null;
                }
                i2 = 0;
                while (i2 < skins.length) {
                    int n = i2++;
                    skins[n] = skins[n] - 1;
                }
            }
            if ((chooser = WeightedIndex.create(skins.length, properties.getString("weights." + index, ""))) == null) {
                return null;
            }
            String biomeList = properties.getString("biomes." + index, "");
            if (biomeList.isEmpty()) {
                biomes = null;
            } else {
                biomes = new BitSet();
                BiomeAPI.parseBiomeList(biomeList, biomes);
            }
            BitSet height = BiomeAPI.getHeightListProperty(properties, "." + index);
            return new MobRuleEntry(skins, chooser, biomes, height);
        }

        MobRuleEntry(int[] skins, WeightedIndex weightedIndex, BitSet biomes, BitSet height) {
            this.skins = skins;
            this.weightedIndex = weightedIndex;
            this.biomes = biomes;
            this.height = height;
        }

        boolean match(int i2, int j2, int k, Integer biome) {
            if (!(this.biomes == null || biome != null && this.biomes.get(biome))) {
                return false;
            }
            return this.height == null || this.height.get(j2);
        }

        public String toString() {
            StringBuilder sb2 = new StringBuilder();
            sb2.append("skins:");
            for (int i2 : this.skins) {
                sb2.append(' ').append(i2 + 1);
            }
            if (this.biomes != null) {
                sb2.append(", biomes:");
                int i3 = this.biomes.nextSetBit(0);
                while (i3 >= 0) {
                    sb2.append(' ').append(i3);
                    i3 = this.biomes.nextSetBit(i3 + 1);
                }
            }
            if (this.height != null) {
                sb2.append(", height:");
                int i4 = this.height.nextSetBit(0);
                while (i4 >= 0) {
                    sb2.append(' ').append(i4);
                    i4 = this.height.nextSetBit(i4 + 1);
                }
            }
            sb2.append(", weights: ").append(this.weightedIndex.toString());
            return sb2.toString();
        }
    }
}

