/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.mob;

import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.mal.biome.BiomeAPI;
import com.prupe.mcpatcher.mal.resource.FakeResourceLocation;
import com.prupe.mcpatcher.mal.resource.TexturePackChangeHandler;
import com.prupe.mcpatcher.mob.LineRenderer;
import com.prupe.mcpatcher.mob.MobOverlay;
import com.prupe.mcpatcher.mob.MobRuleList;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class MobRandomizer {
    private static final MCLogger logger = MCLogger.getLogger("Random Mobs");
    private static final LinkedHashMap<String, FakeResourceLocation> cache = new LinkedHashMap();

    static void init() {
    }

    public static FakeResourceLocation randomTexture(ng entity, FakeResourceLocation texture) {
        if (texture == null || !texture.getPath().endsWith(".png")) {
            return texture;
        }
        String key = texture.toString() + ":" + entity.k;
        FakeResourceLocation newTexture = cache.get(key);
        if (newTexture == null) {
            ExtraInfo info = ExtraInfo.getInfo(entity);
            MobRuleList list = MobRuleList.get(texture);
            newTexture = list.getSkin(info.skin, info.origX, info.origY, info.origZ, info.origBiome);
            cache.put(key, newTexture);
            logger.finer("entity %s using %s (cache: %d)", entity, newTexture, cache.size());
            if (cache.size() > 250) {
                while (cache.size() > 200) {
                    cache.remove(cache.keySet().iterator().next());
                }
            }
        }
        return newTexture;
    }

    public static FakeResourceLocation randomTexture(mp entity, FakeResourceLocation texture) {
        if (entity instanceof ng) {
            return MobRandomizer.randomTexture((ng)entity, texture);
        }
        return texture;
    }

    static {
        TexturePackChangeHandler.register(new TexturePackChangeHandler("Random Mobs", 2){

            @Override
            public void beforeChange() {
                cache.clear();
            }

            @Override
            public void afterChange() {
                MobRuleList.clear();
                MobOverlay.reset();
                LineRenderer.reset();
            }
        });
    }

    @Environment(value=EnvType.CLIENT)
    public static final class ExtraInfo {
        private static final String SKIN_TAG = "randomMobsSkin";
        private static final String ORIG_X_TAG = "origX";
        private static final String ORIG_Y_TAG = "origY";
        private static final String ORIG_Z_TAG = "origZ";
        private static final long MULTIPLIER = 25214903917L;
        private static final long ADDEND = 11L;
        private static final long MASK = 0xFFFFFFFFFFFFL;
        private static final HashMap<Integer, ExtraInfo> allInfo = new HashMap();
        private static final HashMap<WeakReference<ng>, ExtraInfo> allRefs = new HashMap();
        private static final ReferenceQueue<ng> refQueue = new ReferenceQueue();
        private final int entityId;
        private final HashSet<WeakReference<ng>> references;
        private final long skin;
        private final int origX;
        private final int origY;
        private final int origZ;
        private Integer origBiome;

        ExtraInfo(ng entity) {
            this(entity, ExtraInfo.getSkinId(entity.k), (int)entity.u, (int)entity.v, (int)entity.w);
        }

        ExtraInfo(ng entity, long skin, int origX, int origY, int origZ) {
            this.entityId = entity.k;
            this.references = new HashSet();
            this.skin = skin;
            this.origX = origX;
            this.origY = origY;
            this.origZ = origZ;
        }

        private void setBiome() {
            if (this.origBiome == null) {
                this.origBiome = BiomeAPI.getBiomeIDAt(BiomeAPI.getWorld(), this.origX, this.origY, this.origZ);
            }
        }

        public String toString() {
            return String.format("%s{%d, %d, %d, %d, %d, %s}", this.getClass().getSimpleName(), this.entityId, this.skin, this.origX, this.origY, this.origZ, this.origBiome);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void clearUnusedReferences() {
            HashMap<Integer, ExtraInfo> hashMap = allInfo;
            synchronized (hashMap) {
                Reference<ng> ref;
                while ((ref = refQueue.poll()) != null) {
                    ExtraInfo info = allRefs.get(ref);
                    if (info != null) {
                        info.references.remove(ref);
                        if (info.references.isEmpty()) {
                            logger.finest("removing unused ref %d", info.entityId);
                            allInfo.remove(info.entityId);
                        }
                    }
                    allRefs.remove(ref);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static ExtraInfo getInfo(ng entity) {
            ExtraInfo info;
            HashMap<Integer, ExtraInfo> hashMap = allInfo;
            synchronized (hashMap) {
                ExtraInfo.clearUnusedReferences();
                info = allInfo.get(entity.k);
                if (info == null) {
                    info = new ExtraInfo(entity);
                    ExtraInfo.putInfo(entity, info);
                }
                boolean found = false;
                for (WeakReference<ng> ref : info.references) {
                    if (ref.get() != entity) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    WeakReference<ng> reference = new WeakReference<ng>(entity, refQueue);
                    info.references.add(reference);
                    allRefs.put(reference, info);
                    logger.finest("added ref #%d for %d (%d entities)", info.references.size(), entity.k, allInfo.size());
                }
                info.setBiome();
            }
            return info;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void putInfo(ng entity, ExtraInfo info) {
            HashMap<Integer, ExtraInfo> hashMap = allInfo;
            synchronized (hashMap) {
                allInfo.put(entity.k, info);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void clearInfo() {
            HashMap<Integer, ExtraInfo> hashMap = allInfo;
            synchronized (hashMap) {
                allInfo.clear();
            }
        }

        private static long getSkinId(int entityId) {
            long n = entityId;
            n = n ^ n << 16 ^ n << 32 ^ n << 48;
            n = 25214903917L * n + 11L;
            n = 25214903917L * n + 11L;
            return (n &= 0xFFFFFFFFFFFFL) >> 32 ^ n;
        }

        public static void readFromNBT(ng entity, bs nbt) {
            long skin = nbt.f(SKIN_TAG);
            if (skin != 0L) {
                int x2 = nbt.e(ORIG_X_TAG);
                int y2 = nbt.e(ORIG_Y_TAG);
                int z2 = nbt.e(ORIG_Z_TAG);
                ExtraInfo.putInfo(entity, new ExtraInfo(entity, skin, x2, y2, z2));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void writeToNBT(ng entity, bs nbt) {
            HashMap<Integer, ExtraInfo> hashMap = allInfo;
            synchronized (hashMap) {
                ExtraInfo info = allInfo.get(entity.k);
                if (info != null) {
                    nbt.a(SKIN_TAG, info.skin);
                    nbt.a(ORIG_X_TAG, info.origX);
                    nbt.a(ORIG_Y_TAG, info.origY);
                    nbt.a(ORIG_Z_TAG, info.origZ);
                }
            }
        }
    }
}

