/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.mob;

import com.prupe.mcpatcher.Config;
import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.mal.resource.FakeResourceLocation;
import com.prupe.mcpatcher.mal.resource.GLAPI;
import com.prupe.mcpatcher.mal.resource.PropertiesFile;
import com.prupe.mcpatcher.mal.resource.TexturePackAPI;
import com.prupe.mcpatcher.mal.tessellator.TessellatorAPI;
import com.prupe.mcpatcher.mal.util.InputHandler;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.lwjgl.opengl.GL11;

@Environment(value=EnvType.CLIENT)
public class LineRenderer {
    private static final MCLogger logger = MCLogger.getLogger("Random Mobs");
    private static final double D_WIDTH = 9.765625E-4;
    private static final double D_POS = 0.00390625;
    private static final boolean enable = Config.getBoolean("Random Mobs", "leashLine", true);
    private static final LineRenderer[] renderers = new LineRenderer[2];
    private final FakeResourceLocation texture;
    private final double width;
    private final double a;
    private final double b;
    private final double sx;
    private final double sy;
    private final double sz;
    private final int segments;
    private final double tileFactor;
    private final boolean active;
    private final InputHandler keyboard;
    private double plusWidth;
    private double plusTile;
    private double plusSX;
    private double plusSY;
    private double plusSZ;

    public static boolean renderLine(int type, double x2, double y2, double z2, double dx2, double dy2, double dz2) {
        LineRenderer renderer = renderers[type];
        return renderer != null && renderer.render(x2, y2, z2, dx2, dy2, dz2);
    }

    static void reset() {
        if (enable) {
            LineRenderer.setup(0, "fishingline", 0.0075, 0.0, 0.25, 16);
            LineRenderer.setup(1, "lead", 0.025, 1.3333333333333333, 0.125, 24);
        }
    }

    private static void setup(int type, String name, double defaultWidth, double a2, double b2, int segments) {
        LineRenderer renderer = new LineRenderer(name, defaultWidth, a2, b2, segments);
        if (renderer.active) {
            logger.fine("using %s", renderer);
            LineRenderer.renderers[type] = renderer;
        } else {
            logger.fine("%s not found", renderer);
            LineRenderer.renderers[type] = null;
        }
    }

    private LineRenderer(String name, double width, double a2, double b2, int segments) {
        this.texture = TexturePackAPI.newMCPatcherResourceLocation("/misc/" + name + ".png");
        this.active = TexturePackAPI.hasResource(this.texture);
        PropertiesFile properties = PropertiesFile.getNonNull(logger, TexturePackAPI.transformResourceLocation(this.texture, ".png", ".properties"));
        this.width = properties.getDouble("width", width);
        this.a = properties.getDouble("a", a2);
        this.b = properties.getDouble("b", b2);
        this.sx = properties.getDouble("sx", 0.0);
        this.sy = properties.getDouble("sy", 0.0);
        this.sz = properties.getDouble("sz", 0.0);
        this.segments = properties.getInt("segments", segments);
        this.tileFactor = properties.getDouble("tileFactor", 24.0);
        this.keyboard = new InputHandler(name, properties.getBoolean("debug", false));
    }

    private boolean render(double x2, double y2, double z2, double dx2, double dy2, double dz2) {
        if (this.keyboard.isKeyDown(55)) {
            return false;
        }
        boolean changed = false;
        if (this.keyboard.isEnabled()) {
            if (this.keyboard.isKeyPressed(78)) {
                changed = true;
                this.plusWidth += 9.765625E-4;
            } else if (this.keyboard.isKeyPressed(74)) {
                changed = true;
                this.plusWidth -= 9.765625E-4;
            } else if (this.keyboard.isKeyPressed(181)) {
                changed = true;
                this.plusSZ = 0.0;
                this.plusSY = 0.0;
                this.plusSX = 0.0;
                this.plusTile = 0.0;
                this.plusWidth = 0.0;
            } else if (this.keyboard.isKeyPressed(81)) {
                changed = true;
                this.plusTile -= 1.0;
            } else if (this.keyboard.isKeyPressed(73)) {
                changed = true;
                this.plusTile += 1.0;
            } else if (this.keyboard.isKeyDown(75)) {
                changed = true;
                this.plusSX -= 0.00390625;
            } else if (this.keyboard.isKeyDown(77)) {
                changed = true;
                this.plusSX += 0.00390625;
            } else if (this.keyboard.isKeyDown(79)) {
                changed = true;
                this.plusSY -= 0.00390625;
            } else if (this.keyboard.isKeyDown(71)) {
                changed = true;
                this.plusSY += 0.00390625;
            } else if (this.keyboard.isKeyDown(80)) {
                changed = true;
                this.plusSZ += 0.00390625;
            } else if (this.keyboard.isKeyDown(72)) {
                changed = true;
                this.plusSZ -= 0.00390625;
            }
        }
        TexturePackAPI.bindTexture(this.texture);
        bgd tessellator = TessellatorAPI.getTessellator();
        TessellatorAPI.startDrawingQuads(tessellator);
        GL11.glDisable((int)2884);
        GLAPI.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        double x0 = x2;
        double y0 = y2 + this.a + this.b;
        double z0 = z2;
        double u0 = 0.0;
        double len = Math.sqrt((dx2 += this.sx + this.plusSX) * dx2 + (dy2 += this.sy + this.plusSY) * dy2 + (dz2 += this.sz + this.plusSZ) * dz2);
        double t2 = this.tileFactor + this.plusTile;
        double w2 = this.width + this.plusWidth;
        if (changed) {
            logger.info("%s: dx=%f, dy=%f, dz=%f, len=%f(*%d=%f), slen=%f", this, dx2, dy2, dz2, len, (int)t2, len * t2, len * t2 / (double)this.segments);
            System.out.printf("width=%f\n", w2);
            System.out.printf("tileFactor=%f\n", t2);
            System.out.printf("sx=%f\n", this.sx + this.plusSX);
            System.out.printf("sy=%f\n", this.sy + this.plusSY);
            System.out.printf("sz=%f\n", this.sz + this.plusSZ);
        }
        len *= t2 / (double)this.segments;
        for (int i2 = 1; i2 <= this.segments; ++i2) {
            double s2 = (double)i2 / (double)this.segments;
            double x1 = x2 + s2 * dx2;
            double y1 = y2 + (s2 * s2 + s2) * 0.5 * dy2 + this.a * (1.0 - s2) + this.b;
            double z1 = z2 + s2 * dz2;
            double u1 = (double)(this.segments - i2) * len;
            TessellatorAPI.addVertexWithUV(tessellator, x0, y0, z0, u0, 1.0);
            TessellatorAPI.addVertexWithUV(tessellator, x1, y1, z1, u1, 1.0);
            TessellatorAPI.addVertexWithUV(tessellator, x1 + w2, y1 + w2, z1, u1, 0.0);
            TessellatorAPI.addVertexWithUV(tessellator, x0 + w2, y0 + w2, z0, u0, 0.0);
            TessellatorAPI.addVertexWithUV(tessellator, x0, y0 + w2, z0, u0, 1.0);
            TessellatorAPI.addVertexWithUV(tessellator, x1, y1 + w2, z1, u1, 1.0);
            TessellatorAPI.addVertexWithUV(tessellator, x1 + w2, y1, z1 + w2, u1, 0.0);
            TessellatorAPI.addVertexWithUV(tessellator, x0 + w2, y0, z0 + w2, u0, 0.0);
            x0 = x1;
            y0 = y1;
            z0 = z1;
            u0 = u1;
        }
        TessellatorAPI.draw(tessellator);
        GL11.glEnable((int)2884);
        return true;
    }

    public String toString() {
        return "LineRenderer{" + this.texture + ", " + (this.width + this.plusWidth) + "}";
    }
}

