/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.mal.util;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public abstract class WeightedIndex {
    private static final long K1 = -5435081209227447693L;
    private static final long KMUL = -7070675565921424023L;
    final int size;

    public static WeightedIndex create(int size) {
        if (size <= 0) {
            return null;
        }
        return new WeightedIndex(size){

            @Override
            public int choose(long key) {
                return this.mod(key, this.size);
            }

            public String toString() {
                return "unweighted";
            }
        };
    }

    public static WeightedIndex create(int size, String weightList) {
        if (size <= 0 || weightList == null) {
            return WeightedIndex.create(size);
        }
        final int[] weights = new int[size];
        int sum1 = 0;
        boolean useWeight = false;
        String[] list = weightList.trim().split("\\s+");
        for (int i2 = 0; i2 < size; ++i2) {
            weights[i2] = i2 < list.length && list[i2].matches("^\\d+$") ? Math.max(Integer.parseInt(list[i2]), 0) : 1;
            if (i2 > 0 && weights[i2] != weights[0]) {
                useWeight = true;
            }
            sum1 += weights[i2];
        }
        if (!useWeight || sum1 <= 0) {
            return WeightedIndex.create(size);
        }
        final int sum = sum1;
        return new WeightedIndex(size){

            @Override
            public int choose(long key) {
                int index;
                int m2 = this.mod(key, sum);
                for (index = 0; index < this.size - 1 && m2 >= weights[index]; m2 -= weights[index], ++index) {
                }
                return index;
            }

            public String toString() {
                StringBuilder sb2 = new StringBuilder();
                sb2.append("%(");
                for (int i2 = 0; i2 < weights.length; ++i2) {
                    if (i2 > 0) {
                        sb2.append(", ");
                    }
                    sb2.append(String.format("%.1f", 100.0 * (double)weights[i2] / (double)sum));
                }
                sb2.append(")");
                return sb2.toString();
            }
        };
    }

    protected WeightedIndex(int size) {
        this.size = size;
    }

    protected final int mod(long n, int modulus) {
        return (int)((n >> 32 ^ n) & Integer.MAX_VALUE) % modulus;
    }

    public abstract int choose(long var1);

    public static long hash128To64(int i2, int j2, int k, int l2) {
        return WeightedIndex.hash128To64((long)i2 << 32 | (long)j2 & 0xFFFFFFFFL, (long)k << 32 | (long)l2 & 0xFFFFFFFFL);
    }

    public static long hash128To64(long a2, long b2) {
        a2 = WeightedIndex.shiftMix(a2 * -5435081209227447693L) * -5435081209227447693L;
        long c2 = b2 * -5435081209227447693L + WeightedIndex.mix128to64(a2, b2);
        long d2 = WeightedIndex.shiftMix(a2 + b2);
        a2 = WeightedIndex.mix128to64(a2, c2);
        b2 = WeightedIndex.mix128to64(d2, b2);
        return a2 ^ b2 ^ WeightedIndex.mix128to64(b2, a2);
    }

    private static long shiftMix(long val) {
        return val ^ val >>> 47;
    }

    private static long mix128to64(long u2, long v2) {
        long a2 = WeightedIndex.shiftMix((u2 ^ v2) * -7070675565921424023L);
        long b2 = WeightedIndex.shiftMix((u2 ^ a2) * -7070675565921424023L);
        return b2 *= -7070675565921424023L;
    }
}

