/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.mal.util;

import java.util.BitSet;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.lwjgl.input.Keyboard;

@Environment(value=EnvType.CLIENT)
public class InputHandler {
    private final BitSet keysDown = new BitSet();
    private final String name;
    private final boolean enabled;

    public InputHandler(String name, boolean enabled) {
        this.name = name;
        this.enabled = enabled;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isKeyPressed(int key) {
        if (this.enabled) {
            if (Keyboard.isKeyDown((int)key)) {
                if (!this.keysDown.get(key)) {
                    this.keysDown.set(key);
                    return true;
                }
            } else {
                this.keysDown.clear(key);
            }
        }
        return false;
    }

    public boolean isKeyDown(int key) {
        return this.enabled && Keyboard.isKeyDown((int)key);
    }

    public String toString() {
        StringBuilder sb2 = new StringBuilder();
        sb2.append("InputUtils{").append(this.name).append(':');
        int i2 = this.keysDown.nextSetBit(0);
        while (i2 >= 0) {
            sb2.append(' ').append(Keyboard.getKeyName((int)i2));
            i2 = this.keysDown.nextSetBit(i2 + 1);
        }
        sb2.append('}');
        return sb2.toString();
    }
}

