/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.mal.resource;

import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.mal.resource.FakeResourceLocation;
import com.prupe.mcpatcher.mal.resource.ResourceLocationWithSource;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;

@Environment(value=EnvType.CLIENT)
public class TexturePackAPI {
    private static final MCLogger logger = MCLogger.getLogger("Texture Pack");
    public static final String DEFAULT_NAMESPACE = "minecraft";
    private static final TexturePackAPI instance = new TexturePackAPI();
    public static final String MCPATCHER_SUBDIR = "/";
    public static final FakeResourceLocation ITEMS_PNG = new FakeResourceLocation("/gui/items.png");
    public static final FakeResourceLocation BLOCKS_PNG = new FakeResourceLocation("terrain.png");
    private final List<Field> textureMapFields = new ArrayList<Field>();

    public static boolean isInitialized() {
        return instance != null && Minecraft.x().D != null;
    }

    public static void scheduleTexturePackRefresh() {
        Minecraft.x().y();
    }

    public static List<bjt> getResourcePacks(String namespace) {
        ArrayList<bjt> resourcePacks = new ArrayList<bjt>();
        bjt resourcePack = instance.getTexturePack();
        if (resourcePack != null) {
            resourcePacks.add(resourcePack);
        }
        return resourcePacks;
    }

    public static Set<String> getNamespaces() {
        HashSet<String> set = new HashSet<String>();
        set.add(DEFAULT_NAMESPACE);
        return set;
    }

    public static boolean isDefaultTexturePack() {
        bjt texturePack = instance.getTexturePack();
        return texturePack == null || texturePack instanceof bjq;
    }

    public static InputStream getInputStream(FakeResourceLocation resource) {
        if (resource == null) {
            return null;
        }
        bjt resourcePack = resource instanceof ResourceLocationWithSource ? ((ResourceLocationWithSource)resource).getSource() : instance.getTexturePack();
        try {
            return resourcePack == null ? null : resourcePack.a(resource.getPath());
        }
        catch (IOException e2) {
            return null;
        }
    }

    public static boolean hasResource(FakeResourceLocation resource) {
        if (resource == null) {
            return false;
        }
        if (resource.getPath().endsWith(".png")) {
            return TexturePackAPI.getImage(resource) != null;
        }
        if (resource.getPath().endsWith(".properties")) {
            return TexturePackAPI.getProperties(resource) != null;
        }
        InputStream is2 = TexturePackAPI.getInputStream(resource);
        MCPatcherUtils.close(is2);
        return is2 != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasCustomResource(FakeResourceLocation resource) {
        InputStream pack;
        InputStream jar;
        block16: {
            boolean bl;
            block15: {
                boolean bl2;
                block14: {
                    jar = null;
                    pack = null;
                    try {
                        int read1;
                        String path = resource.getPath();
                        pack = TexturePackAPI.getInputStream(resource);
                        if (pack == null) {
                            boolean bl3 = false;
                            return bl3;
                        }
                        jar = Minecraft.class.getResourceAsStream(path);
                        if (jar == null) {
                            bl2 = true;
                            MCPatcherUtils.close(jar);
                            break block14;
                        }
                        byte[] buffer1 = new byte[4096];
                        byte[] buffer2 = new byte[4096];
                        while ((read1 = pack.read(buffer1)) > 0) {
                            int read2 = jar.read(buffer2);
                            if (read1 != read2) {
                                bl = true;
                                MCPatcherUtils.close(jar);
                                break block15;
                            }
                            for (int i2 = 0; i2 < read1; ++i2) {
                                if (buffer1[i2] == buffer2[i2]) continue;
                                boolean bl4 = true;
                                MCPatcherUtils.close(jar);
                                MCPatcherUtils.close(pack);
                                return bl4;
                            }
                        }
                        MCPatcherUtils.close(jar);
                        break block16;
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                        return false;
                    }
                }
                MCPatcherUtils.close(pack);
                return bl2;
            }
            MCPatcherUtils.close(pack);
            return bl;
        }
        MCPatcherUtils.close(pack);
        return false;
        finally {
            MCPatcherUtils.close(jar);
            MCPatcherUtils.close(pack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getImage(FakeResourceLocation resource) {
        if (resource == null) {
            return null;
        }
        InputStream input = TexturePackAPI.getInputStream(resource);
        BufferedImage image = null;
        if (input != null) {
            try {
                image = ImageIO.read(input);
            }
            catch (IOException e2) {
                logger.error("could not read %s", resource);
                e2.printStackTrace();
            }
            finally {
                MCPatcherUtils.close(input);
            }
        }
        return image;
    }

    public static Properties getProperties(FakeResourceLocation resource) {
        Properties properties = new Properties();
        if (TexturePackAPI.getProperties(resource, properties)) {
            return properties;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getProperties(FakeResourceLocation resource, Properties properties) {
        if (properties != null) {
            InputStream input = TexturePackAPI.getInputStream(resource);
            try {
                if (input != null) {
                    properties.load(input);
                    boolean bl = true;
                    return bl;
                }
            }
            catch (IOException e2) {
                logger.error("could not read %s", resource);
                e2.printStackTrace();
            }
            finally {
                MCPatcherUtils.close(input);
            }
        }
        return false;
    }

    public static FakeResourceLocation transformResourceLocation(FakeResourceLocation resource, String oldExt, String newExt) {
        return new FakeResourceLocation(resource.getNamespace(), resource.getPath().replaceFirst(Pattern.quote(oldExt) + "$", newExt));
    }

    public static FakeResourceLocation parsePath(String path) {
        return MCPatcherUtils.isNullOrEmpty(path) ? null : new FakeResourceLocation(path.replace(File.separatorChar, '/'));
    }

    public static FakeResourceLocation parseResourceLocation(String path) {
        return TexturePackAPI.parseResourceLocation(new FakeResourceLocation(DEFAULT_NAMESPACE, "a"), path);
    }

    public static FakeResourceLocation parseResourceLocation(FakeResourceLocation baseResource, String path) {
        if (MCPatcherUtils.isNullOrEmpty(path)) {
            return null;
        }
        if (path.startsWith("~/")) {
            path = path.substring(1);
        }
        if (path.startsWith("./")) {
            return new FakeResourceLocation(baseResource.getNamespace(), baseResource.getPath().replaceFirst("[^/]+$", "") + path.substring(2));
        }
        if (path.startsWith(MCPATCHER_SUBDIR)) {
            return new FakeResourceLocation(path);
        }
        return new FakeResourceLocation(baseResource.getNamespace(), baseResource.getPath().replaceFirst("[^/]+$", "") + path);
    }

    public static FakeResourceLocation newMCPatcherResourceLocation(String path) {
        return new FakeResourceLocation(MCPATCHER_SUBDIR + path.replaceFirst("^/+", ""));
    }

    public static int getTextureIfLoaded(FakeResourceLocation resource) {
        if (resource == null) {
            return -1;
        }
        bge renderEngine = Minecraft.x().p;
        String path = resource.getPath();
        if (path.equals("/terrain.png") || path.equals("/gui/items.png")) {
            return renderEngine.f(path);
        }
        for (Field field : TexturePackAPI.instance.textureMapFields) {
            try {
                Object value;
                HashMap map = (HashMap)field.get(renderEngine);
                if (map == null || !((value = map.get(resource.toString())) instanceof Integer)) continue;
                return (Integer)value;
            }
            catch (IllegalAccessException illegalAccessException) {
            }
        }
        return -1;
    }

    public static boolean isTextureLoaded(FakeResourceLocation resource) {
        return TexturePackAPI.getTextureIfLoaded(resource) >= 0;
    }

    public static void bindTexture(FakeResourceLocation resource) {
        if (resource != null) {
            Minecraft.x().p.b(resource.toString());
        }
    }

    public static void unloadTexture(FakeResourceLocation resource) {
        int texture;
        if (resource != null && (texture = TexturePackAPI.getTextureIfLoaded(resource)) >= 0) {
            logger.finest("unloading texture %s", resource);
            bge renderEngine = Minecraft.x().p;
            renderEngine.a(texture);
            for (Field field : TexturePackAPI.instance.textureMapFields) {
                try {
                    HashMap map = (HashMap)field.get(renderEngine);
                    if (map == null) continue;
                    map.remove(resource.toString());
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
        }
    }

    public static void flushUnusedTextures() {
    }

    private TexturePackAPI() {
        try {
            for (Field field : bge.class.getDeclaredFields()) {
                if (!HashMap.class.isAssignableFrom(field.getType())) continue;
                field.setAccessible(true);
                this.textureMapFields.add(field);
            }
        }
        catch (Throwable e2) {
            e2.printStackTrace();
        }
    }

    private bjt getTexturePack() {
        Minecraft minecraft = Minecraft.x();
        if (minecraft == null) {
            return null;
        }
        bju texturePackList = minecraft.D;
        if (texturePackList == null) {
            return null;
        }
        return texturePackList.e();
    }
}

