/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.mal.resource;

import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.mal.resource.FakeResourceLocation;
import com.prupe.mcpatcher.mal.resource.ResourceList;
import java.util.Comparator;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ResourceLocationWithSource
extends FakeResourceLocation {
    private final bjt source;
    private final int order;
    private final boolean isDirectory;

    public ResourceLocationWithSource(bjt source, FakeResourceLocation resource) {
        super(resource.getNamespace(), resource.getPath().replaceFirst("/$", ""));
        this.source = source;
        this.order = ResourceList.getResourcePackOrder(source);
        this.isDirectory = resource.getPath().endsWith("/");
    }

    public bjt getSource() {
        return this.source;
    }

    public int getOrder() {
        return this.order;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    @Environment(value=EnvType.CLIENT)
    static class Comparator1
    implements Comparator<ResourceLocationWithSource> {
        private final boolean bySource;
        private final String suffixExpr;

        Comparator1() {
            this(false, null);
        }

        Comparator1(boolean bySource, String suffix) {
            this.bySource = bySource;
            this.suffixExpr = MCPatcherUtils.isNullOrEmpty(suffix) ? null : Pattern.quote(suffix) + "$";
        }

        @Override
        public int compare(ResourceLocationWithSource o1, ResourceLocationWithSource o2) {
            String f2;
            String f1;
            String n2;
            int result;
            if (this.bySource && (result = o1.getOrder() - o2.getOrder()) != 0) {
                return result;
            }
            String n1 = o1.getNamespace();
            result = n1.compareTo(n2 = o2.getNamespace());
            if (result != 0) {
                return result;
            }
            String p1 = o1.getPath();
            String p2 = o2.getPath();
            if (this.suffixExpr != null && (result = (f1 = p1.replaceAll(".*/", "").replaceFirst(this.suffixExpr, "")).compareTo(f2 = p2.replaceAll(".*/", "").replaceFirst(this.suffixExpr, ""))) != 0) {
                return result;
            }
            return p1.compareTo(p2);
        }
    }
}

