/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.mal.resource;

import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.mal.resource.FakeResourceLocation;
import com.prupe.mcpatcher.mal.resource.ResourceLocationWithSource;
import com.prupe.mcpatcher.mal.resource.TexturePackAPI;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ResourceList {
    private static final MCLogger logger = MCLogger.getLogger("Texture Pack");
    private static ResourceList instance;
    private static final Map<bjt, Integer> resourcePackOrder;
    private final bjt resourcePack;
    private final Set<ResourceLocationWithSource> allResources = new TreeSet<ResourceLocationWithSource>(new ResourceLocationWithSource.Comparator1());

    public static ResourceList getInstance() {
        if (instance == null) {
            List<bjt> resourcePacks = TexturePackAPI.getResourcePacks(null);
            int order = resourcePacks.size();
            resourcePackOrder.clear();
            for (bjt resourcePack : resourcePacks) {
                resourcePackOrder.put(resourcePack, order);
                --order;
            }
            instance = new ResourceList();
        }
        return instance;
    }

    public static void clearInstance() {
        instance = null;
    }

    public static int getResourcePackOrder(bjt resourcePack) {
        Integer i2 = resourcePackOrder.get(resourcePack);
        return i2 == null ? Integer.MAX_VALUE : i2;
    }

    private ResourceList() {
        this.resourcePack = null;
        for (bjt resourcePack : TexturePackAPI.getResourcePacks(null)) {
            ResourceList sublist;
            if (resourcePack instanceof bjr) {
                sublist = new ResourceList((bjr)resourcePack);
            } else if (resourcePack instanceof bjq) {
                sublist = new ResourceList((bjq)resourcePack);
            } else {
                if (!(resourcePack instanceof bjp)) continue;
                sublist = new ResourceList((bjp)resourcePack);
            }
            this.allResources.removeAll(sublist.allResources);
            this.allResources.addAll(sublist.allResources);
        }
        logger.fine("new %s", this);
        if (logger.isLoggable(Level.FINEST)) {
            for (ResourceLocationWithSource resource : this.allResources) {
                logger.finest("%s -> %s", resource, resource.getSource().c());
            }
        }
    }

    private ResourceList(bjr resourcePack) {
        this.resourcePack = resourcePack;
        this.scanZipFile(resourcePack.e);
        logger.fine("new %s", this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceList(bjq resourcePack) {
        this.resourcePack = resourcePack;
        String version = MCPatcherUtils.getMinecraftVersion();
        File jar = MCPatcherUtils.getMinecraftPath("versions", version, version + ".jar");
        if (jar.isFile()) {
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(jar);
                this.scanZipFile(zipFile);
            }
            catch (Throwable e2) {
                try {
                    e2.printStackTrace();
                }
                catch (Throwable throwable) {
                    MCPatcherUtils.close(zipFile);
                    throw throwable;
                }
                MCPatcherUtils.close(zipFile);
            }
            MCPatcherUtils.close(zipFile);
        }
        if (!this.allResources.isEmpty()) {
            logger.fine("new %s", this);
        }
    }

    private ResourceList(bjp resourcePack) {
        this.resourcePack = resourcePack;
        File directory = resourcePack.a;
        if (directory == null || !directory.isDirectory()) {
            return;
        }
        HashSet<String> allFiles = new HashSet<String>();
        ResourceList.listAllFiles(directory, "", allFiles);
        for (String path : allFiles) {
            FakeResourceLocation resource = TexturePackAPI.parsePath(path);
            if (resource == null) continue;
            File file = new File(directory, path);
            this.addResource(resource, file.isFile(), file.isDirectory());
        }
        logger.fine("new %s", this);
    }

    private void scanZipFile(ZipFile zipFile) {
        if (zipFile == null) {
            return;
        }
        for (ZipEntry zipEntry : Collections.list(zipFile.entries())) {
            String path = zipEntry.getName();
            FakeResourceLocation resource = TexturePackAPI.parsePath(path);
            if (resource == null) continue;
            this.addResource(resource, !zipEntry.isDirectory(), zipEntry.isDirectory());
        }
    }

    private static void listAllFiles(File base, String subdir, Set<String> files) {
        File[] entries = new File(base, subdir).listFiles();
        if (entries == null) {
            return;
        }
        for (File file : entries) {
            String newPath = subdir + file.getName();
            if (!files.add(newPath) || !file.isDirectory()) continue;
            ResourceList.listAllFiles(base, subdir + file.getName() + '/', files);
        }
    }

    private void addResource(FakeResourceLocation resource, boolean isFile, boolean isDirectory) {
        if (isFile) {
            this.allResources.add(new ResourceLocationWithSource(this.resourcePack, resource));
        } else if (isDirectory) {
            if (!resource.getPath().endsWith("/")) {
                resource = new FakeResourceLocation(resource.getNamespace(), resource.getPath() + '/');
            }
            this.allResources.add(new ResourceLocationWithSource(this.resourcePack, resource));
        }
    }

    public List<FakeResourceLocation> listResources(String directory, String suffix, boolean sortByFilename) {
        return this.listResources(directory, suffix, true, false, sortByFilename);
    }

    public List<FakeResourceLocation> listResources(String directory, String suffix, boolean recursive, boolean directories, boolean sortByFilename) {
        return this.listResources(null, directory, suffix, recursive, directories, sortByFilename);
    }

    public List<FakeResourceLocation> listResources(String namespace, String directory, String suffix, boolean recursive, boolean directories, boolean sortByFilename) {
        if (suffix == null) {
            suffix = "";
        }
        if (MCPatcherUtils.isNullOrEmpty(directory)) {
            directory = "";
        } else if (!directory.endsWith("/")) {
            directory = directory + '/';
        }
        TreeSet<ResourceLocationWithSource> tmpList = new TreeSet<ResourceLocationWithSource>(new ResourceLocationWithSource.Comparator1(true, sortByFilename ? suffix : null));
        boolean allNamespaces = MCPatcherUtils.isNullOrEmpty(namespace);
        for (ResourceLocationWithSource resource : this.allResources) {
            String subpath;
            String path;
            if (directories != resource.isDirectory() || !allNamespaces && !namespace.equals(resource.getNamespace()) || !(path = resource.getPath()).endsWith(suffix) || !path.startsWith(directory) || !recursive && (subpath = path.substring(directory.length())).contains("/")) continue;
            tmpList.add(resource);
        }
        return new ArrayList<FakeResourceLocation>(tmpList);
    }

    public String toString() {
        StringBuilder sb2 = new StringBuilder("ResourceList: ");
        if (this.resourcePack == null) {
            sb2.append("(combined) ");
        } else {
            sb2.append(this.resourcePack.c()).append(' ');
        }
        int fileCount = 0;
        int directoryCount = 0;
        HashSet<String> namespaces = new HashSet<String>();
        for (ResourceLocationWithSource resource : this.allResources) {
            if (resource.isDirectory()) {
                ++directoryCount;
            } else {
                ++fileCount;
            }
            namespaces.add(resource.getNamespace());
        }
        sb2.append(fileCount).append(" files, ");
        sb2.append(directoryCount).append(" directories in ");
        sb2.append(namespaces.size()).append(" namespaces");
        return sb2.toString();
    }

    static {
        resourcePackOrder = new WeakHashMap<bjt, Integer>();
    }
}

