/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.mal.resource;

import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.MCPatcherUtils;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class FakeResourceLocation {
    private static final MCLogger logger = MCLogger.getLogger("Texture Pack");
    private static final String GRID = "##";
    private static final String BLUR = "%blur%";
    private static final String CLAMP = "%clamp%";
    private final String path;
    private final boolean grid;
    private final boolean blur;
    private final boolean clamp;
    private final String toString;
    private final int hashCode;

    public static FakeResourceLocation wrap(String path) {
        return MCPatcherUtils.isNullOrEmpty(path) ? null : new FakeResourceLocation(path);
    }

    public static String unwrap(FakeResourceLocation resourceLocation) {
        return resourceLocation == null ? null : resourceLocation.toString();
    }

    public static IntBuffer getIntBuffer(IntBuffer buffer, int[] data) {
        buffer.clear();
        int have = buffer.capacity();
        int needed = data.length;
        if (needed > have) {
            logger.finest("resizing gl buffer from 0x%x to 0x%x", have, needed);
            buffer = ByteBuffer.allocateDirect(4 * needed).order(buffer.order()).asIntBuffer();
        }
        buffer.put(data);
        buffer.position(0).limit(needed);
        return buffer;
    }

    public FakeResourceLocation(String namespace, String path) {
        this.grid = path.startsWith(GRID);
        if (this.grid) {
            path = path.substring(GRID.length());
        }
        if (this.blur = path.startsWith(BLUR)) {
            path = path.substring(BLUR.length());
        }
        if (this.clamp = path.startsWith(CLAMP)) {
            path = path.substring(CLAMP.length());
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        this.path = path;
        this.toString = (this.grid ? GRID : "") + (this.blur ? BLUR : "") + (this.clamp ? CLAMP : "") + path;
        this.hashCode = this.toString.hashCode();
    }

    public FakeResourceLocation(String path) {
        this("minecraft", path);
    }

    public String getNamespace() {
        return "minecraft";
    }

    public String getPath() {
        return this.path;
    }

    public boolean isGrid() {
        return this.grid;
    }

    public boolean isBlur() {
        return this.blur;
    }

    public boolean isClamp() {
        return this.clamp;
    }

    public String toString() {
        return this.toString;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof FakeResourceLocation)) {
            return false;
        }
        return this.toString().equals(that.toString());
    }

    public int hashCode() {
        return this.hashCode;
    }
}

