/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.mal.nbt;

import java.lang.reflect.Method;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public abstract class NBTRule {
    public static final String NBT_RULE_PREFIX = "nbt.";
    public static final String NBT_RULE_SEPARATOR = ".";
    public static final String NBT_RULE_WILDCARD = "*";
    public static final String NBT_REGEX_PREFIX = "regex:";
    public static final String NBT_IREGEX_PREFIX = "iregex:";
    public static final String NBT_GLOB_PREFIX = "pattern:";
    public static final String NBT_IGLOB_PREFIX = "ipattern:";
    private final String[] tagName;
    private final Integer[] tagIndex;

    public static NBTRule create(String tag, String value) {
        if (tag == null || value == null || !tag.startsWith(NBT_RULE_PREFIX)) {
            return null;
        }
        try {
            tag = tag.substring(NBT_RULE_PREFIX.length());
            if (value.startsWith(NBT_REGEX_PREFIX)) {
                return new Regex(tag, value.substring(NBT_REGEX_PREFIX.length()), true);
            }
            if (value.startsWith(NBT_IREGEX_PREFIX)) {
                return new Regex(tag, value.substring(NBT_IREGEX_PREFIX.length()), false);
            }
            if (value.startsWith(NBT_GLOB_PREFIX)) {
                return new Glob(tag, value.substring(NBT_GLOB_PREFIX.length()), true);
            }
            if (value.startsWith(NBT_IGLOB_PREFIX)) {
                return new Glob(tag, value.substring(NBT_IGLOB_PREFIX.length()), false);
            }
            return new Exact(tag, value);
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            return null;
        }
    }

    protected NBTRule(String tag, String value) {
        this.tagName = tag.split(Pattern.quote(NBT_RULE_SEPARATOR));
        this.tagIndex = new Integer[this.tagName.length];
        for (int i2 = 0; i2 < this.tagName.length; ++i2) {
            if (NBT_RULE_WILDCARD.equals(this.tagName[i2])) {
                this.tagName[i2] = null;
                this.tagIndex[i2] = null;
                continue;
            }
            try {
                this.tagIndex[i2] = Integer.valueOf(this.tagName[i2]);
                continue;
            }
            catch (NumberFormatException e2) {
                this.tagIndex[i2] = -1;
            }
        }
    }

    public final boolean match(bs nbt) {
        return nbt != null && this.match(nbt, 0);
    }

    private boolean match(bs nbt, int index) {
        if (index >= this.tagName.length) {
            return false;
        }
        if (this.tagName[index] == null) {
            for (Object nbtBase : nbt.c()) {
                if (!this.match1((cf)nbtBase, index + 1)) continue;
                return true;
            }
            return false;
        }
        cf nbtBase = nbt.a(this.tagName[index]);
        return this.match1(nbtBase, index + 1);
    }

    private boolean match(ca nbt, int index) {
        if (index >= this.tagIndex.length) {
            return false;
        }
        if (this.tagIndex[index] == null) {
            for (int i2 = 0; i2 < nbt.c(); ++i2) {
                if (!this.match1(nbt.b(i2), index + 1)) continue;
                return true;
            }
            return false;
        }
        int tagNum = this.tagIndex[index];
        return tagNum >= 0 && tagNum < nbt.c() && this.match1(nbt.b(tagNum), index + 1);
    }

    private boolean match1(cf nbt, int index) {
        if (nbt == null) {
            return false;
        }
        if (nbt instanceof bs) {
            return this.match((bs)nbt, index);
        }
        if (nbt instanceof ca) {
            return this.match((ca)nbt, index);
        }
        if (index < this.tagName.length) {
            return false;
        }
        if (nbt instanceof ce) {
            return this.match((ce)nbt);
        }
        if (nbt instanceof bz) {
            return this.match((bz)nbt);
        }
        if (nbt instanceof bv) {
            return this.match((bv)nbt);
        }
        if (nbt instanceof bx) {
            return this.match((bx)nbt);
        }
        if (nbt instanceof cb) {
            return this.match((cb)nbt);
        }
        if (nbt instanceof cd) {
            return this.match((cd)nbt);
        }
        if (nbt instanceof br) {
            return this.match((br)nbt);
        }
        return false;
    }

    protected boolean match(br nbt) {
        return false;
    }

    protected boolean match(bv nbt) {
        return false;
    }

    protected boolean match(bx nbt) {
        return false;
    }

    protected boolean match(bz nbt) {
        return false;
    }

    protected boolean match(cb nbt) {
        return false;
    }

    protected boolean match(cd nbt) {
        return false;
    }

    protected boolean match(ce nbt) {
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    private static final class Regex
    extends NBTRule {
        private final Pattern pattern;

        Regex(String tag, String value, boolean caseSensitive) {
            super(tag, value);
            this.pattern = Pattern.compile(value, caseSensitive ? 0 : 2);
        }

        @Override
        protected boolean match(ce nbt) {
            return this.pattern.matcher(nbt.a).matches();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static final class Glob
    extends NBTRule {
        private static final char STAR = '*';
        private static final char SINGLE = '?';
        private static final char ESCAPE = '\\';
        private final String glob;
        private final boolean caseSensitive;

        protected Glob(String tag, String value, boolean caseSensitive) {
            super(tag, value);
            this.caseSensitive = caseSensitive;
            if (!caseSensitive) {
                value = value.toLowerCase();
            }
            this.glob = value;
        }

        @Override
        protected boolean match(ce nbt) {
            String value = nbt.a;
            return this.matchPartial(value, 0, value.length(), 0, this.glob.length());
        }

        private boolean matchPartial(String value, int curV, int maxV, int curG, int maxG) {
            while (curG < maxG) {
                char g2 = this.glob.charAt(curG);
                if (g2 == '*') {
                    while (true) {
                        if (this.matchPartial(value, curV, maxV, curG + 1, maxG)) {
                            return true;
                        }
                        if (curV >= maxV) break;
                        ++curV;
                    }
                    return false;
                }
                if (curV >= maxV) break;
                if (g2 != '?') {
                    if (g2 == '\\' && curG + 1 < maxG) {
                        g2 = this.glob.charAt(++curG);
                    }
                    if (!this.matchChar(g2, value.charAt(curV))) {
                        return false;
                    }
                }
                ++curG;
                ++curV;
            }
            return curG == maxG && curV == maxV;
        }

        private boolean matchChar(char a2, char b2) {
            return a2 == (this.caseSensitive ? b2 : Character.toLowerCase(b2));
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static final class Exact
    extends NBTRule {
        private final Byte byteValue;
        private final Double doubleValue;
        private final Float floatValue;
        private final Integer integerValue;
        private final Long longValue;
        private final Short shortValue;
        private final String stringValue;

        Exact(String tag, String value) {
            super(tag, value);
            this.stringValue = value;
            this.doubleValue = Exact.parse(Double.class, value);
            this.floatValue = this.doubleValue == null ? null : Float.valueOf(this.doubleValue.floatValue());
            this.longValue = Exact.parse(Long.class, value);
            if (this.longValue == null) {
                this.byteValue = null;
                this.integerValue = null;
                this.shortValue = null;
            } else {
                this.byteValue = this.longValue.byteValue();
                this.integerValue = this.longValue.intValue();
                this.shortValue = this.longValue.shortValue();
            }
        }

        private static <T extends Number> T parse(Class<T> cl2, String value) {
            try {
                Method valueOf = cl2.getDeclaredMethod("valueOf", String.class);
                Object result = valueOf.invoke(null, value);
                if (result != null && cl2.isAssignableFrom(result.getClass())) {
                    return (T)((Number)cl2.cast(result));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }

        @Override
        protected boolean match(br nbt) {
            return this.byteValue != null && this.byteValue == nbt.a;
        }

        @Override
        protected boolean match(bv nbt) {
            return this.doubleValue != null && this.doubleValue == nbt.a;
        }

        @Override
        protected boolean match(bx nbt) {
            return this.floatValue != null && this.floatValue.floatValue() == nbt.a;
        }

        @Override
        protected boolean match(bz nbt) {
            return this.integerValue != null && this.integerValue == nbt.a;
        }

        @Override
        protected boolean match(cb nbt) {
            return this.longValue != null && this.longValue == nbt.a;
        }

        @Override
        protected boolean match(cd nbt) {
            return this.shortValue != null && this.shortValue == nbt.a;
        }

        @Override
        protected boolean match(ce nbt) {
            return nbt.a.equals(this.stringValue);
        }
    }
}

