/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.mal.block;

import btw.block.BTWBlocks;
import btw.block.blocks.GrassBlock;
import btw.block.blocks.GrassSlabBlock;
import com.prupe.mcpatcher.mal.block.BlockAPI;
import com.prupe.mcpatcher.mal.block.RenderPassAPI;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;

@Environment(value=EnvType.CLIENT)
public class RenderBlocksUtils {
    public static boolean enableBetterGrass = false;
    public static apa grassBlock = BlockAPI.getFixedBlock("minecraft:grass");
    public static apa snowBlock = BlockAPI.getFixedBlock("minecraft:snow_layer");
    public static apa craftedSnowBlock = BlockAPI.getFixedBlock("minecraft:snow");
    public static apa fcDirtSlab = BTWBlocks.dirtSlab;
    private static final int COLOR = 0;
    private static final int NONCOLOR = 1;
    private static final int COLOR_AND_NONCOLOR = 2;
    private static final int[] colorMultiplierType = new int[6];
    private static final float[][] nonAOMultipliers = new float[6][3];
    public static final float[] AO_BASE = new float[]{0.5f, 1.0f, 0.8f, 0.8f, 0.6f, 0.6f};
    public static int layerIndex;
    public static lx blankIcon;
    private static int grassFace;
    private static lx grassIcon;

    public static void setupColorMultiplier(apa block, aak blockAccess, int i2, int j2, int k, boolean haveOverrideTexture, float r2, float g2, float b2) {
        if (haveOverrideTexture || !RenderPassAPI.instance.useColorMultiplierThisPass(block)) {
            RenderBlocksUtils.colorMultiplierType[0] = 0;
            RenderBlocksUtils.colorMultiplierType[1] = 0;
            RenderBlocksUtils.colorMultiplierType[2] = 0;
            RenderBlocksUtils.colorMultiplierType[3] = 0;
            RenderBlocksUtils.colorMultiplierType[4] = 0;
            RenderBlocksUtils.colorMultiplierType[5] = 0;
        } else if (block == grassBlock && !GrassBlock.secondPass || block.cz == BTWBlocks.grassSlab.cz && !GrassSlabBlock.secondPass) {
            RenderBlocksUtils.colorMultiplierType[0] = 1;
            RenderBlocksUtils.colorMultiplierType[1] = 1;
            RenderBlocksUtils.colorMultiplierType[2] = 1;
            RenderBlocksUtils.colorMultiplierType[3] = 1;
            RenderBlocksUtils.colorMultiplierType[4] = 1;
            RenderBlocksUtils.colorMultiplierType[5] = 1;
        } else if (fcDirtSlab != null && block == fcDirtSlab) {
            if (RenderBlocksUtils.isSnowCovered(blockAccess, i2, j2, k)) {
                RenderBlocksUtils.colorMultiplierType[2] = 1;
                RenderBlocksUtils.colorMultiplierType[3] = 1;
                RenderBlocksUtils.colorMultiplierType[4] = 1;
                RenderBlocksUtils.colorMultiplierType[5] = 1;
            } else {
                RenderBlocksUtils.colorMultiplierType[0] = 0;
                RenderBlocksUtils.colorMultiplierType[1] = 0;
                RenderBlocksUtils.colorMultiplierType[2] = 2;
                RenderBlocksUtils.colorMultiplierType[3] = 2;
                RenderBlocksUtils.colorMultiplierType[4] = 2;
                RenderBlocksUtils.colorMultiplierType[5] = 2;
            }
        } else {
            RenderBlocksUtils.colorMultiplierType[0] = 0;
            RenderBlocksUtils.colorMultiplierType[1] = 0;
            RenderBlocksUtils.colorMultiplierType[2] = 0;
            RenderBlocksUtils.colorMultiplierType[3] = 0;
            RenderBlocksUtils.colorMultiplierType[4] = 0;
            RenderBlocksUtils.colorMultiplierType[5] = 0;
        }
        if (!RenderBlocksUtils.isAmbientOcclusionEnabled() || BlockAPI.getBlockLightValue(block) != 0) {
            RenderBlocksUtils.setupColorMultiplier(0, r2, g2, b2);
            RenderBlocksUtils.setupColorMultiplier(1, r2, g2, b2);
            RenderBlocksUtils.setupColorMultiplier(2, r2, g2, b2);
            RenderBlocksUtils.setupColorMultiplier(3, r2, g2, b2);
            RenderBlocksUtils.setupColorMultiplier(4, r2, g2, b2);
            RenderBlocksUtils.setupColorMultiplier(5, r2, g2, b2);
        }
    }

    public static void setupColorMultiplierForceNoAO(apa block, aak blockAccess, int i2, int j2, int k, float r2, float g2, float b2, boolean useColor) {
        if (useColor) {
            RenderBlocksUtils.colorMultiplierType[0] = 0;
            RenderBlocksUtils.colorMultiplierType[1] = 0;
            RenderBlocksUtils.colorMultiplierType[2] = 0;
            RenderBlocksUtils.colorMultiplierType[3] = 0;
            RenderBlocksUtils.colorMultiplierType[4] = 0;
            RenderBlocksUtils.colorMultiplierType[5] = 0;
        } else {
            RenderBlocksUtils.colorMultiplierType[0] = 1;
            RenderBlocksUtils.colorMultiplierType[1] = 1;
            RenderBlocksUtils.colorMultiplierType[2] = 1;
            RenderBlocksUtils.colorMultiplierType[3] = 1;
            RenderBlocksUtils.colorMultiplierType[4] = 1;
            RenderBlocksUtils.colorMultiplierType[5] = 1;
        }
        RenderBlocksUtils.setupColorMultiplier(0, r2, g2, b2);
        RenderBlocksUtils.setupColorMultiplier(1, r2, g2, b2);
        RenderBlocksUtils.setupColorMultiplier(2, r2, g2, b2);
        RenderBlocksUtils.setupColorMultiplier(3, r2, g2, b2);
        RenderBlocksUtils.setupColorMultiplier(4, r2, g2, b2);
        RenderBlocksUtils.setupColorMultiplier(5, r2, g2, b2);
    }

    public static void setupColorMultiplier(apa block, int metadata, boolean useColor) {
        if (block == grassBlock || block == fcDirtSlab && metadata == 1 || !useColor) {
            RenderBlocksUtils.colorMultiplierType[0] = 1;
            RenderBlocksUtils.colorMultiplierType[2] = 1;
            RenderBlocksUtils.colorMultiplierType[3] = 1;
            RenderBlocksUtils.colorMultiplierType[4] = 1;
            RenderBlocksUtils.colorMultiplierType[5] = 1;
        } else {
            RenderBlocksUtils.colorMultiplierType[0] = 0;
            RenderBlocksUtils.colorMultiplierType[2] = 0;
            RenderBlocksUtils.colorMultiplierType[3] = 0;
            RenderBlocksUtils.colorMultiplierType[4] = 0;
            RenderBlocksUtils.colorMultiplierType[5] = 0;
        }
    }

    private static void setupColorMultiplier(int face, float r2, float g2, float b2) {
        float ao;
        float[] mult = nonAOMultipliers[face];
        mult[0] = ao = AO_BASE[face];
        mult[1] = ao;
        mult[2] = ao;
        if (colorMultiplierType[face] != 1) {
            mult[0] = mult[0] * r2;
            mult[1] = mult[1] * g2;
            mult[2] = mult[2] * b2;
        }
    }

    public static boolean useColorMultiplier(int face) {
        layerIndex = 0;
        return RenderBlocksUtils.useColorMultiplier1(face);
    }

    private static boolean useColorMultiplier1(int face) {
        if (layerIndex == 0) {
            return colorMultiplierType[RenderBlocksUtils.getFaceIndex(face)] == 0;
        }
        return colorMultiplierType[RenderBlocksUtils.getFaceIndex(face)] != 1;
    }

    public static boolean useColorMultiplier(boolean useTint, int face) {
        return useTint || layerIndex++ == 0 && RenderBlocksUtils.useColorMultiplier1(face);
    }

    public static float getColorMultiplierRed(int face) {
        return nonAOMultipliers[RenderBlocksUtils.getFaceIndex(face)][0];
    }

    public static float getColorMultiplierGreen(int face) {
        return nonAOMultipliers[RenderBlocksUtils.getFaceIndex(face)][1];
    }

    public static float getColorMultiplierBlue(int face) {
        return nonAOMultipliers[RenderBlocksUtils.getFaceIndex(face)][2];
    }

    private static int getFaceIndex(int face) {
        return face < 0 ? 1 : face % 6;
    }

    public static lx getGrassTexture(apa block, aak blockAccess, int i2, int j2, int k, int face, lx topIcon) {
        boolean neighborIsSnow;
        if (!enableBetterGrass || face < 2) {
            return null;
        }
        boolean isSnow = RenderBlocksUtils.isSnowCovered(blockAccess, i2, j2, k);
        switch (face) {
            case 2: {
                --k;
                break;
            }
            case 3: {
                ++k;
                break;
            }
            case 4: {
                --i2;
                break;
            }
            case 5: {
                ++i2;
                break;
            }
            default: {
                return null;
            }
        }
        if (block == apa.y && BlockAPI.getBlockAt(blockAccess, i2, j2 - 1, k) != apa.y && (BlockAPI.getBlockAt(blockAccess, i2, j2, k) != BTWBlocks.dirtSlab || BTWBlocks.dirtSlab.getSubtype(BlockAPI.getMetadataAt(blockAccess, i2, j2, k)) != 1) && BlockAPI.getBlockAt(blockAccess, i2, j2, k) != BTWBlocks.grassSlab && BlockAPI.getBlockAt(blockAccess, i2, j2, k) != BTWBlocks.looseSparseGrass && BlockAPI.getBlockAt(blockAccess, i2, j2, k) != BTWBlocks.looseSparseGrassSlab) {
            return null;
        }
        if (block == apa.bC && BlockAPI.getBlockAt(blockAccess, i2, j2 - 1, k) != apa.bC && BlockAPI.getBlockAt(blockAccess, i2, j2, k) != BTWBlocks.myceliumSlab) {
            return null;
        }
        boolean bl = neighborIsSnow = RenderBlocksUtils.isSnowCovered(blockAccess, i2, j2, k) || RenderBlocksUtils.isSnowCovered(blockAccess, i2, j2 - 1, k);
        if (isSnow != neighborIsSnow) {
            return null;
        }
        return isSnow ? BlockAPI.getBlockIcon(snowBlock, blockAccess, i2, j2, k, face) : topIcon;
    }

    public static lx getGrassIconBTW(lx origIcon, int face) {
        grassFace = face;
        if (blankIcon != null && colorMultiplierType[face] == 0) {
            grassIcon = origIcon;
            return blankIcon;
        }
        grassIcon = null;
        return origIcon;
    }

    public static lx getGrassOverlayIconBTW(lx origIcon) {
        if (grassIcon != null) {
            lx t2 = grassIcon;
            grassIcon = null;
            return t2;
        }
        if (blankIcon != null && colorMultiplierType[grassFace] == 1) {
            return blankIcon;
        }
        return origIcon;
    }

    private static boolean isSnowCovered(aak blockAccess, int i2, int j2, int k) {
        apa topBlock = BlockAPI.getBlockAt(blockAccess, i2, j2 + 1, k);
        return topBlock == snowBlock || topBlock == craftedSnowBlock;
    }

    public static boolean isAmbientOcclusionEnabled() {
        return Minecraft.u();
    }
}

