/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.mal.biome;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ColorUtils {
    public static void intToFloat3(int rgb, float[] f2, int offset) {
        if ((rgb & 0xFFFFFF) == 0xFFFFFF) {
            f2[offset + 2] = 1.0f;
            f2[offset + 1] = 1.0f;
            f2[offset] = 1.0f;
        } else {
            f2[offset] = (float)(rgb & 0xFF0000) / 1.671168E7f;
            f2[offset + 1] = (float)(rgb & 0xFF00) / 65280.0f;
            f2[offset + 2] = (float)(rgb & 0xFF) / 255.0f;
        }
    }

    public static void intToFloat3(int rgb, float[] f2) {
        ColorUtils.intToFloat3(rgb, f2, 0);
    }

    public static int float3ToInt(float[] f2, int offset) {
        return (int)(255.0f * f2[offset]) << 16 | (int)(255.0f * f2[offset + 1]) << 8 | (int)(255.0f * f2[offset + 2]);
    }

    public static int float3ToInt(float[] f2) {
        return ColorUtils.float3ToInt(f2, 0);
    }

    public static float clamp(float f2) {
        if (f2 < 0.0f) {
            return 0.0f;
        }
        if (f2 > 1.0f) {
            return 1.0f;
        }
        return f2;
    }

    public static double clamp(double d2) {
        if (d2 < 0.0) {
            return 0.0;
        }
        if (d2 > 1.0) {
            return 1.0;
        }
        return d2;
    }

    public static void clamp(float[] f2) {
        for (int i2 = 0; i2 < f2.length; ++i2) {
            f2[i2] = ColorUtils.clamp(f2[i2]);
        }
    }
}

