/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.mal.biome;

import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.mal.biome.ColorUtils;
import com.prupe.mcpatcher.mal.biome.IColorMap;
import com.prupe.mcpatcher.mal.resource.FakeResourceLocation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public abstract class ColorMapBase {
    private static final MCLogger logger = MCLogger.getLogger("Custom Colors");
    public static final int DEFAULT_HEIGHT = 64;

    @Environment(value=EnvType.CLIENT)
    public static final class Outer
    implements IColorMap {
        private final IColorMap parent;
        private final boolean isHeightDependent;
        private final int mapDefault;

        public Outer(IColorMap parent) {
            this.parent = parent;
            this.isHeightDependent = parent.isHeightDependent();
            this.mapDefault = parent.getColorMultiplier();
        }

        public String toString() {
            return this.parent.toString();
        }

        @Override
        public boolean isHeightDependent() {
            return this.parent.isHeightDependent();
        }

        @Override
        public int getColorMultiplier() {
            return this.mapDefault;
        }

        @Override
        public int getColorMultiplier(aak blockAccess, int i2, int j2, int k) {
            if (!this.isHeightDependent) {
                j2 = 64;
            }
            return this.parent.getColorMultiplier(blockAccess, i2, j2, k);
        }

        @Override
        public float[] getColorMultiplierF(aak blockAccess, int i2, int j2, int k) {
            if (!this.isHeightDependent) {
                j2 = 64;
            }
            return this.parent.getColorMultiplierF(blockAccess, i2, j2, k);
        }

        @Override
        public void claimResources(Collection<FakeResourceLocation> resources) {
            this.parent.claimResources(resources);
        }

        @Override
        public IColorMap copy() {
            return new Outer(this.parent.copy());
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static final class Chunked
    implements IColorMap {
        private static final int I_MASK = -16;
        private static final int K_MASK = -16;
        private static final int I_SIZE = 17;
        private static final int J_SIZE = 2;
        private static final int K_SIZE = 17;
        private static final int IK_SIZE = 289;
        private static final int IJK_SIZE = 578;
        private final IColorMap parent;
        private int baseI = Integer.MIN_VALUE;
        private int baseJ = Integer.MIN_VALUE;
        private int baseK = Integer.MIN_VALUE;
        private int baseOffset;
        private final float[][] data = new float[578][];
        private final float[][] data1 = new float[578][3];
        private final boolean logEnabled = ColorMapBase.access$000().isLoggable(Level.FINEST);
        private long lastLogTime = System.currentTimeMillis();
        private int calls;
        private int missChunk;
        private int missSheet;
        private int missBlock;

        public Chunked(IColorMap parent) {
            this.parent = parent;
        }

        public String toString() {
            return this.parent.toString();
        }

        @Override
        public boolean isHeightDependent() {
            return this.parent.isHeightDependent();
        }

        @Override
        public int getColorMultiplier() {
            return this.parent.getColorMultiplier();
        }

        @Override
        public int getColorMultiplier(aak blockAccess, int i2, int j2, int k) {
            return ColorUtils.float3ToInt(this.getColorMultiplierF(blockAccess, i2, j2, k));
        }

        @Override
        public float[] getColorMultiplierF(aak blockAccess, int i2, int j2, int k) {
            long now;
            float[] color;
            int offset = this.getChunkOffset(i2, j2, k);
            ++this.calls;
            if (offset < 0) {
                this.setChunkBase(i2, j2, k);
                offset = this.getChunkOffset(i2, j2, k);
                ++this.missChunk;
            }
            if ((color = this.data[offset]) == null) {
                this.data[offset] = this.data1[offset];
                color = this.data[offset];
                Chunked.copy3f(color, this.parent.getColorMultiplierF(blockAccess, i2, j2, k));
                ++this.missBlock;
            }
            if (this.logEnabled && (now = System.currentTimeMillis()) - this.lastLogTime > 5000L) {
                float mult = 100.0f / (float)this.calls;
                logger.finest("%s: calls: %d, miss chunk: %.2f%%, miss sheet: %.2f%%, miss block: %.2f%%", this, this.calls, Float.valueOf((float)this.missChunk * mult), Float.valueOf((float)this.missSheet * mult), Float.valueOf((float)this.missBlock * mult));
                this.lastLogTime = now;
            }
            return color;
        }

        @Override
        public void claimResources(Collection<FakeResourceLocation> resources) {
            this.parent.claimResources(resources);
        }

        @Override
        public IColorMap copy() {
            return new Chunked(this.parent.copy());
        }

        private static void copy3f(float[] dst, float[] src) {
            dst[0] = src[0];
            dst[1] = src[1];
            dst[2] = src[2];
        }

        private void setChunkBase(int i2, int j2, int k) {
            this.baseI = i2 & 0xFFFFFFF0;
            this.baseJ = j2;
            this.baseK = k & 0xFFFFFFF0;
            this.baseOffset = 0;
            Arrays.fill((Object[])this.data, null);
        }

        private int getChunkOffset(int i2, int j2, int k) {
            if ((j2 -= this.baseJ) >= 0 && j2 <= 2 && (k -= this.baseK) >= 0 && k < 17 && (i2 -= this.baseI) >= 0 && i2 < 17) {
                if (j2 == 2) {
                    --j2;
                    ++this.baseJ;
                    ++this.missSheet;
                    Arrays.fill((Object[])this.data, this.baseOffset, 578, null);
                    this.baseOffset ^= 0x121;
                }
                return (this.baseOffset + j2 * 289 + k * 17 + i2) % 578;
            }
            return -1;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static final class Smoothed
    implements IColorMap {
        private final IColorMap parent;
        private final float smoothTime;
        private final float[] lastColor = new float[3];
        private long lastTime;

        public Smoothed(IColorMap parent, float smoothTime) {
            this.parent = parent;
            this.smoothTime = smoothTime;
        }

        public String toString() {
            return this.parent.toString();
        }

        @Override
        public boolean isHeightDependent() {
            return this.parent.isHeightDependent();
        }

        @Override
        public int getColorMultiplier() {
            return this.parent.getColorMultiplier();
        }

        @Override
        public int getColorMultiplier(aak blockAccess, int i2, int j2, int k) {
            return ColorUtils.float3ToInt(this.getColorMultiplierF(blockAccess, i2, j2, k));
        }

        @Override
        public float[] getColorMultiplierF(aak blockAccess, int i2, int j2, int k) {
            float[] currentColor = this.parent.getColorMultiplierF(blockAccess, i2, j2, k);
            long now = System.currentTimeMillis();
            if (this.lastTime == 0L) {
                this.lastColor[0] = currentColor[0];
                this.lastColor[1] = currentColor[1];
                this.lastColor[2] = currentColor[2];
            } else {
                float r2 = ColorUtils.clamp((float)(now - this.lastTime) / this.smoothTime);
                float s2 = 1.0f - r2;
                this.lastColor[0] = r2 * currentColor[0] + s2 * this.lastColor[0];
                this.lastColor[1] = r2 * currentColor[1] + s2 * this.lastColor[1];
                this.lastColor[2] = r2 * currentColor[2] + s2 * this.lastColor[2];
            }
            this.lastTime = now;
            return this.lastColor;
        }

        @Override
        public void claimResources(Collection<FakeResourceLocation> resources) {
            this.parent.claimResources(resources);
        }

        @Override
        public IColorMap copy() {
            return new Smoothed(this.parent.copy(), this.smoothTime);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static final class Cached
    implements IColorMap {
        private final IColorMap parent;
        private int lastI = Integer.MIN_VALUE;
        private int lastJ = Integer.MIN_VALUE;
        private int lastK = Integer.MIN_VALUE;
        private int lastColorI;
        private float[] lastColorF;

        public Cached(IColorMap parent) {
            this.parent = parent;
        }

        public String toString() {
            return this.parent.toString();
        }

        @Override
        public boolean isHeightDependent() {
            return this.parent.isHeightDependent();
        }

        @Override
        public int getColorMultiplier() {
            return this.parent.getColorMultiplier();
        }

        @Override
        public int getColorMultiplier(aak blockAccess, int i2, int j2, int k) {
            if (i2 != this.lastI || j2 != this.lastJ || k != this.lastK) {
                this.lastColorI = this.parent.getColorMultiplier(blockAccess, i2, j2, k);
                this.lastI = i2;
                this.lastJ = j2;
                this.lastK = k;
            }
            return this.lastColorI;
        }

        @Override
        public float[] getColorMultiplierF(aak blockAccess, int i2, int j2, int k) {
            if (i2 != this.lastI || j2 != this.lastJ || k != this.lastK) {
                this.lastColorF = this.parent.getColorMultiplierF(blockAccess, i2, j2, k);
                this.lastI = i2;
                this.lastJ = j2;
                this.lastK = k;
            }
            return this.lastColorF;
        }

        @Override
        public void claimResources(Collection<FakeResourceLocation> resources) {
            this.parent.claimResources(resources);
        }

        @Override
        public IColorMap copy() {
            return new Cached(this.parent.copy());
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static final class Blended
    implements IColorMap {
        private final IColorMap parent;
        private final int blendRadius;
        private final int[][] offset;
        private final float[] weight;
        private final float[] lastColor = new float[3];

        public Blended(IColorMap parent, int blendRadius) {
            this.parent = parent;
            this.blendRadius = blendRadius;
            ArrayList<int[]> blendOffset = new ArrayList<int[]>();
            ArrayList<Float> blendWeight = new ArrayList<Float>();
            float blendScale = 0.0f;
            block6: for (int r2 = 0; r2 <= blendRadius; ++r2) {
                if (r2 == 0) {
                    blendScale += Blended.addSample(blendOffset, blendWeight, 0, 0);
                    continue;
                }
                switch (r2 % 8) {
                    case 1: {
                        blendScale += Blended.addSamples(blendOffset, blendWeight, r2, 0, 1);
                        continue block6;
                    }
                    case 2: {
                        blendScale += Blended.addSamples(blendOffset, blendWeight, r2, 1, 1);
                        continue block6;
                    }
                    case 3: 
                    case 4: {
                        blendScale += Blended.addSamples(blendOffset, blendWeight, r2, 1, 2);
                        continue block6;
                    }
                    case 5: 
                    case 6: {
                        blendScale += Blended.addSamples(blendOffset, blendWeight, r2, 1, 3);
                        continue block6;
                    }
                    default: {
                        blendScale += Blended.addSamples(blendOffset, blendWeight, r2, 2, 3);
                    }
                }
            }
            this.offset = (int[][])blendOffset.toArray((T[])new int[blendOffset.size()][]);
            this.weight = new float[blendWeight.size()];
            for (int i2 = 0; i2 < blendWeight.size(); ++i2) {
                this.weight[i2] = ((Float)blendWeight.get(i2)).floatValue() / blendScale;
            }
        }

        private static float addSample(List<int[]> blendOffset, List<Float> blendWeight, int di2, int dk2) {
            float weight = (float)Math.pow(1.0f + (float)Math.max(Math.abs(di2), Math.abs(dk2)), -0.5);
            blendOffset.add(new int[]{di2, dk2});
            blendWeight.add(Float.valueOf(weight));
            return weight;
        }

        private static float addSamples(List<int[]> blendOffset, List<Float> blendWeight, int r2, int num, int denom) {
            int s2 = num * r2 / denom;
            float sum = 0.0f;
            if (r2 % 2 == 0) {
                r2 ^= s2;
                s2 ^= r2;
                r2 ^= s2;
            }
            sum += Blended.addSample(blendOffset, blendWeight, r2, s2);
            sum += Blended.addSample(blendOffset, blendWeight, -s2, r2);
            sum += Blended.addSample(blendOffset, blendWeight, -r2, -s2);
            return sum += Blended.addSample(blendOffset, blendWeight, s2, -r2);
        }

        public String toString() {
            return this.parent.toString();
        }

        @Override
        public boolean isHeightDependent() {
            return this.parent.isHeightDependent();
        }

        @Override
        public int getColorMultiplier() {
            return this.parent.getColorMultiplier();
        }

        @Override
        public int getColorMultiplier(aak blockAccess, int i2, int j2, int k) {
            return ColorUtils.float3ToInt(this.getColorMultiplierF(blockAccess, i2, j2, k));
        }

        @Override
        public float[] getColorMultiplierF(aak blockAccess, int i2, int j2, int k) {
            this.lastColor[0] = 0.0f;
            this.lastColor[1] = 0.0f;
            this.lastColor[2] = 0.0f;
            for (int n = 0; n < this.weight.length; ++n) {
                int[] offset = this.offset[n];
                float weight = this.weight[n];
                float[] tmpColor = this.parent.getColorMultiplierF(blockAccess, i2 + offset[0], j2, k + offset[1]);
                this.lastColor[0] = this.lastColor[0] + tmpColor[0] * weight;
                this.lastColor[1] = this.lastColor[1] + tmpColor[1] * weight;
                this.lastColor[2] = this.lastColor[2] + tmpColor[2] * weight;
            }
            return this.lastColor;
        }

        @Override
        public void claimResources(Collection<FakeResourceLocation> resources) {
            this.parent.claimResources(resources);
        }

        @Override
        public IColorMap copy() {
            return new Blended(this.parent.copy(), this.blendRadius);
        }
    }
}

