/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.mal.biome;

import com.prupe.mcpatcher.Config;
import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.mal.biome.BiomeAPI;
import com.prupe.mcpatcher.mal.biome.ColorUtils;
import com.prupe.mcpatcher.mal.biome.IColorMap;
import com.prupe.mcpatcher.mal.resource.FakeResourceLocation;
import com.prupe.mcpatcher.mal.resource.PropertiesFile;
import com.prupe.mcpatcher.mal.resource.ResourceList;
import com.prupe.mcpatcher.mal.resource.TexturePackAPI;
import com.prupe.mcpatcher.mal.util.WeightedIndex;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public abstract class ColorMap
implements IColorMap {
    private static final MCLogger logger = MCLogger.getLogger("Custom Colors");
    public static final boolean useSwampColors = Config.getBoolean("Custom Colors", "swamp", true);
    private static final int FIXED = 0;
    private static final int TEMPERATURE_HUMIDITY = 1;
    private static final int BIOME_HEIGHT = 2;
    private static final int COLORMAP_WIDTH = 256;
    private static final int COLORMAP_HEIGHT = 256;
    public static final String BLOCK_COLORMAP_DIR = "/colormap/blocks";
    public static final List<FakeResourceLocation> unusedPNGs = new ArrayList<FakeResourceLocation>();
    private static final String VANILLA_TYPE = "_vanillaType";
    private static final String ALT_SOURCE = "_altSource";
    private static int defaultColorMapFormat;
    private static boolean defaultFlipY;
    private static float defaultYVariance;
    protected final FakeResourceLocation resource;
    protected final int[] map;
    protected final int width;
    protected final int height;
    protected final float maxX;
    protected final float maxY;
    private final float[] xy = new float[2];
    private final float[] lastColor = new float[3];

    public static IColorMap loadVanillaColorMap(FakeResourceLocation vanillaImage, FakeResourceLocation swampImage) {
        Properties properties = new Properties();
        properties.setProperty("format", "1");
        properties.setProperty("source", vanillaImage.toString());
        if (!TexturePackAPI.hasCustomResource(vanillaImage)) {
            if (vanillaImage.getPath().contains("grass")) {
                properties.setProperty(VANILLA_TYPE, "grass");
            } else if (vanillaImage.getPath().contains("foliage")) {
                properties.setProperty(VANILLA_TYPE, "foliage");
            }
        }
        if (swampImage != null) {
            properties.setProperty(ALT_SOURCE, swampImage.toString());
        }
        return ColorMap.loadColorMap(true, vanillaImage, properties);
    }

    public static IColorMap loadFixedColorMap(boolean useCustom, FakeResourceLocation resource) {
        return ColorMap.loadColorMap(useCustom, resource, null);
    }

    public static IColorMap loadColorMap(boolean useCustom, FakeResourceLocation resource, Properties properties) {
        IColorMap map = ColorMap.loadColorMap1(useCustom, resource, properties);
        if (map != null) {
            map.claimResources(unusedPNGs);
        }
        return map;
    }

    private static IColorMap loadColorMap1(boolean useCustom, FakeResourceLocation resource, Properties properties) {
        BufferedImage image;
        int format;
        FakeResourceLocation imageResource;
        FakeResourceLocation propertiesResource;
        if (!useCustom || resource == null) {
            return null;
        }
        if (resource.toString().endsWith(".png")) {
            propertiesResource = TexturePackAPI.transformResourceLocation(resource, ".png", ".properties");
            imageResource = resource;
        } else if (resource.toString().endsWith(".properties")) {
            propertiesResource = resource;
            imageResource = TexturePackAPI.transformResourceLocation(resource, ".properties", ".png");
        } else {
            return null;
        }
        if (properties == null && (properties = TexturePackAPI.getProperties(propertiesResource)) == null) {
            properties = new Properties();
        }
        if ((format = ColorMap.parseFormat(MCPatcherUtils.getStringProperty(properties, "format", ""))) == 0) {
            int color = MCPatcherUtils.getHexProperty(properties, "color", 0xFFFFFF);
            return new Fixed(color);
        }
        String path = MCPatcherUtils.getStringProperty(properties, "source", "");
        if (!MCPatcherUtils.isNullOrEmpty(path)) {
            imageResource = TexturePackAPI.parseResourceLocation(resource, path);
        }
        if ((image = TexturePackAPI.getImage(imageResource)) == null) {
            return null;
        }
        switch (format) {
            case 1: {
                FakeResourceLocation swampResource;
                String vanillaSource = MCPatcherUtils.getStringProperty(properties, VANILLA_TYPE, "");
                IColorMap defaultMap = "grass".equals(vanillaSource) ? new Grass(image) : ("foliage".equals(vanillaSource) ? new Foliage(image) : new TempHumidity(imageResource, properties, image));
                path = MCPatcherUtils.getStringProperty(properties, ALT_SOURCE, "");
                if (useSwampColors && !MCPatcherUtils.isNullOrEmpty(path) && (image = TexturePackAPI.getImage(swampResource = TexturePackAPI.parseResourceLocation(resource, path))) != null) {
                    TempHumidity swampMap = new TempHumidity(swampResource, properties, image);
                    return new Swamp(defaultMap, swampMap);
                }
                return defaultMap;
            }
            case 2: {
                Grid grid = new Grid(imageResource, properties, image);
                if (grid.isInteger()) {
                    return new IntegerGrid(grid);
                }
                return grid;
            }
        }
        logger.error("%s: unknown format %d", resource, format);
        return null;
    }

    public static void reset() {
        unusedPNGs.clear();
        defaultColorMapFormat = 1;
        defaultFlipY = false;
        defaultYVariance = Config.getInt("Custom Colors", "yVariance", 0);
    }

    public static void reloadColorMapSettings(PropertiesFile properties) {
        unusedPNGs.addAll(ResourceList.getInstance().listResources(BLOCK_COLORMAP_DIR, ".png", false));
        defaultColorMapFormat = ColorMap.parseFormat(properties.getString("palette.format", ""));
        defaultFlipY = properties.getBoolean("palette.flipY", false);
        defaultYVariance = properties.getFloat("palette.yVariance", 0.0f);
    }

    private static int parseFormat(String value) {
        if (MCPatcherUtils.isNullOrEmpty(value)) {
            return defaultColorMapFormat;
        }
        if ((value = value.toLowerCase()).matches("^\\d+$")) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e2) {
                e2.printStackTrace();
            }
        } else {
            if (value.equals("fixed")) {
                return 0;
            }
            if (value.equals("temperature+humidity") || value.equals("t+h") || value.equals("vanilla")) {
                return 1;
            }
            if (value.equals("biome+height") || value.equals("b+h") || value.equals("grid")) {
                return 2;
            }
        }
        return defaultColorMapFormat;
    }

    ColorMap(FakeResourceLocation resource, Properties properties, BufferedImage image) {
        this(resource, MCPatcherUtils.getImageRGB(image), image.getWidth(), image.getHeight());
    }

    ColorMap(FakeResourceLocation resource, int[] map, int width, int height) {
        this.resource = resource;
        this.map = map;
        this.width = width;
        this.height = height;
        int i2 = 0;
        while (i2 < map.length) {
            int n = i2++;
            map[n] = map[n] & 0xFFFFFF;
        }
        this.maxX = (float)width - 1.0f;
        this.maxY = (float)height - 1.0f;
    }

    protected abstract void computeXY(aav var1, int var2, int var3, int var4, float[] var5);

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.resource + "}";
    }

    @Override
    public final int getColorMultiplier(aak blockAccess, int i2, int j2, int k) {
        this.computeXY(BiomeAPI.getBiomeGenAt(blockAccess, i2, j2, k), i2, j2, k, this.xy);
        return this.getRGB(this.xy[0], this.xy[1]);
    }

    @Override
    public final float[] getColorMultiplierF(aak blockAccess, int i2, int j2, int k) {
        int rgb = this.getColorMultiplier(blockAccess, i2, j2, k);
        ColorUtils.intToFloat3(rgb, this.lastColor);
        return this.lastColor;
    }

    @Override
    public void claimResources(Collection<FakeResourceLocation> resources) {
        resources.remove(this.resource);
    }

    protected int getRGB(float x2, float y2) {
        x2 = ColorMap.clamp(x2, 0.0f, this.maxX);
        y2 = ColorMap.clamp(y2, 0.0f, this.maxY);
        int x0 = (int)x2;
        int dx2 = (int)(256.0f * (x2 - (float)x0));
        int x1 = x0 + 1;
        int y0 = (int)y2;
        int dy2 = (int)(256.0f * (y2 - (float)y0));
        int y1 = y0 + 1;
        if (dx2 == 0 && dy2 == 0) {
            return this.getRGB(x0, y0);
        }
        if (dx2 == 0) {
            return this.interpolate(x0, y0, x0, y1, dy2);
        }
        if (dy2 == 0) {
            return this.interpolate(x0, y0, x1, y0, dx2);
        }
        return ColorMap.interpolate(this.interpolate(x0, y0, x1, y0, dx2), this.interpolate(x0, y1, x1, y1, dx2), dy2);
    }

    private int getRGB(int x2, int y2) {
        return this.map[x2 + this.width * y2];
    }

    private int interpolate(int x1, int y1, int x2, int y2, int a2) {
        return ColorMap.interpolate(this.getRGB(x1, y1), this.getRGB(x2, y2), a2);
    }

    private static int interpolate(int rgb1, int rgb2, int a2) {
        int a1 = 256 - a2;
        int r1 = rgb1 >> 16 & 0xFF;
        int g1 = rgb1 >> 8 & 0xFF;
        int b1 = rgb1 & 0xFF;
        int r2 = rgb2 >> 16 & 0xFF;
        int g2 = rgb2 >> 8 & 0xFF;
        int b2 = rgb2 & 0xFF;
        int r3 = a1 * r1 + a2 * r2 >> 8;
        int g3 = a1 * g1 + a2 * g2 >> 8;
        int b3 = a1 * b1 + a2 * b2 >> 8;
        return r3 << 16 | g3 << 8 | b3;
    }

    protected static float noise0to1(int i2, int j2, int k, int l2) {
        int hash = (int)WeightedIndex.hash128To64(i2, j2, k, l2) & Integer.MAX_VALUE;
        return (float)((double)hash / 2.147483647E9);
    }

    protected static float noiseMinus1to1(int i2, int j2, int k, int l2) {
        int hash = (int)WeightedIndex.hash128To64(i2, j2, k, l2);
        return (float)((double)hash / -2.147483648E9);
    }

    protected static float clamp(float i2, float min, float max) {
        if (i2 < min) {
            return min;
        }
        if (i2 > max) {
            return max;
        }
        return i2;
    }

    protected static int clamp(int i2, int min, int max) {
        if (i2 < min) {
            return min;
        }
        if (i2 > max) {
            return max;
        }
        return i2;
    }

    @Environment(value=EnvType.CLIENT)
    public static final class Fixed
    implements IColorMap {
        private final int colorI;
        private final float[] colorF = new float[3];

        public Fixed(int color) {
            this.colorI = color;
            ColorUtils.intToFloat3(this.colorI, this.colorF);
        }

        public String toString() {
            return String.format("Fixed{%06x}", this.colorI);
        }

        @Override
        public boolean isHeightDependent() {
            return false;
        }

        @Override
        public int getColorMultiplier() {
            return this.colorI;
        }

        @Override
        public int getColorMultiplier(aak blockAccess, int i2, int j2, int k) {
            return this.colorI;
        }

        @Override
        public float[] getColorMultiplierF(aak blockAccess, int i2, int j2, int k) {
            return this.colorF;
        }

        @Override
        public void claimResources(Collection<FakeResourceLocation> resources) {
        }

        @Override
        public IColorMap copy() {
            return this;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static final class Grass
    extends Vanilla {
        Grass(BufferedImage image) {
            super(image);
        }

        Grass(int defaultColor) {
            super(defaultColor);
        }

        @Override
        public IColorMap copy() {
            return new Grass(this.defaultColor);
        }

        @Override
        int getColorMultiplier(aav biome, int i2, int j2, int k) {
            return BiomeAPI.getGrassColor(biome, i2, j2, k);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static final class Foliage
    extends Vanilla {
        Foliage(BufferedImage image) {
            super(image);
        }

        Foliage(int defaultColor) {
            super(defaultColor);
        }

        @Override
        public IColorMap copy() {
            return new Foliage(this.defaultColor);
        }

        @Override
        int getColorMultiplier(aav biome, int i2, int j2, int k) {
            return BiomeAPI.getFoliageColor(biome, i2, j2, k);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static final class TempHumidity
    extends ColorMap {
        private final int defaultColor;

        private TempHumidity(FakeResourceLocation resource, Properties properties, BufferedImage image) {
            super(resource, properties, image);
            this.defaultColor = MCPatcherUtils.getHexProperty(properties, "color", this.getRGB(this.maxX * 0.5f, this.maxY * 0.5f));
        }

        private TempHumidity(FakeResourceLocation resource, int[] map, int width, int height, int defaultColor) {
            super(resource, map, width, height);
            this.defaultColor = defaultColor;
        }

        @Override
        public boolean isHeightDependent() {
            return false;
        }

        @Override
        public int getColorMultiplier() {
            return this.defaultColor;
        }

        @Override
        public IColorMap copy() {
            return new TempHumidity(this.resource, this.map, this.width, this.height, this.defaultColor);
        }

        @Override
        protected void computeXY(aav biome, int i2, int j2, int k, float[] f2) {
            float temperature = ColorUtils.clamp(BiomeAPI.getTemperature(biome, i2, j2, k));
            float rainfall = ColorUtils.clamp(BiomeAPI.getRainfall(biome, i2, j2, k));
            f2[0] = this.maxX * (1.0f - temperature);
            f2[1] = this.maxY * (1.0f - temperature * rainfall);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static final class Swamp
    implements IColorMap {
        private final IColorMap defaultMap;
        private final IColorMap swampMap;
        private final aav swampBiome;

        Swamp(IColorMap defaultMap, IColorMap swampMap) {
            this.defaultMap = defaultMap;
            this.swampMap = swampMap;
            this.swampBiome = BiomeAPI.findBiomeByName("Swampland");
        }

        public String toString() {
            return this.defaultMap.toString();
        }

        @Override
        public boolean isHeightDependent() {
            return this.defaultMap.isHeightDependent() || this.swampMap.isHeightDependent();
        }

        @Override
        public int getColorMultiplier() {
            return this.defaultMap.getColorMultiplier();
        }

        @Override
        public int getColorMultiplier(aak blockAccess, int i2, int j2, int k) {
            IColorMap map = BiomeAPI.getBiomeGenAt(blockAccess, i2, j2, k) == this.swampBiome ? this.swampMap : this.defaultMap;
            return map.getColorMultiplier(blockAccess, i2, j2, k);
        }

        @Override
        public float[] getColorMultiplierF(aak blockAccess, int i2, int j2, int k) {
            IColorMap map = BiomeAPI.getBiomeGenAt(blockAccess, i2, j2, k) == this.swampBiome ? this.swampMap : this.defaultMap;
            return map.getColorMultiplierF(blockAccess, i2, j2, k);
        }

        @Override
        public void claimResources(Collection<FakeResourceLocation> resources) {
            this.defaultMap.claimResources(resources);
            this.swampMap.claimResources(resources);
        }

        @Override
        public IColorMap copy() {
            return new Swamp(this.defaultMap.copy(), this.swampMap.copy());
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static final class Grid
    extends ColorMap {
        private final float[] biomeX = new float[aav.a.length];
        private final float yVariance;
        private final float yOffset;
        private final int defaultColor;

        private Grid(FakeResourceLocation resource, Properties properties, BufferedImage image) {
            super(resource, properties, image);
            if (MCPatcherUtils.getBooleanProperty(properties, "flipY", defaultFlipY)) {
                int[] temp = new int[this.width];
                for (int i2 = 0; i2 < this.map.length / 2; i2 += this.width) {
                    int j2 = this.map.length - this.width - i2;
                    System.arraycopy(this.map, i2, temp, 0, this.width);
                    System.arraycopy(this.map, j2, this.map, i2, this.width);
                    System.arraycopy(temp, 0, this.map, j2, this.width);
                }
            }
            this.yVariance = Math.max(MCPatcherUtils.getFloatProperty(properties, "yVariance", defaultYVariance), 0.0f);
            this.yOffset = MCPatcherUtils.getFloatProperty(properties, "yOffset", 0.0f);
            for (int i3 = 0; i3 < this.biomeX.length; ++i3) {
                this.biomeX[i3] = i3 % this.width;
            }
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                aav biome;
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (!key.endsWith(".x") || MCPatcherUtils.isNullOrEmpty(value) || (biome = BiomeAPI.findBiomeByName(key = key.substring(0, key.length() - 2))) == null || biome.N < 0 || biome.N >= aav.a.length) continue;
                try {
                    this.biomeX[biome.N] = Float.parseFloat(value);
                }
                catch (NumberFormatException e2) {
                    e2.printStackTrace();
                }
            }
            this.defaultColor = MCPatcherUtils.getHexProperty(properties, "color", this.getRGB(this.biomeX[1], this.getY(64)));
        }

        private Grid(FakeResourceLocation resource, int[] map, int width, int height, float[] biomeX, float yVariance, float yOffset, int defaultColor) {
            super(resource, map, width, height);
            System.arraycopy(biomeX, 0, this.biomeX, 0, biomeX.length);
            this.yVariance = yVariance;
            this.yOffset = yOffset;
            this.defaultColor = defaultColor;
        }

        boolean isInteger() {
            if (this.yVariance != 0.0f || Math.floor(this.yOffset) != (double)this.yOffset) {
                return false;
            }
            for (int i2 = 0; i2 < this.biomeX.length; ++i2) {
                if (this.biomeX[i2] == (float)(i2 % this.width)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isHeightDependent() {
            return true;
        }

        @Override
        public int getColorMultiplier() {
            return this.defaultColor;
        }

        @Override
        public IColorMap copy() {
            return new Grid(this.resource, this.map, this.width, this.height, this.biomeX, this.yVariance, this.yOffset, this.defaultColor);
        }

        @Override
        protected void computeXY(aav biome, int i2, int j2, int k, float[] f2) {
            f2[0] = this.getX(biome, i2, j2, k);
            f2[1] = this.getY(biome, i2, j2, k);
        }

        private float getX(aav biome, int i2, int j2, int k) {
            return this.biomeX[biome.N];
        }

        private float getY(int j2) {
            return (float)j2 - this.yOffset;
        }

        private float getY(aav biome, int i2, int j2, int k) {
            float y2 = this.getY(j2);
            if (this.yVariance != 0.0f) {
                y2 += this.yVariance * Grid.noiseMinus1to1(k, -j2, i2, ~biome.N);
            }
            return y2;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static final class IntegerGrid
    implements IColorMap {
        private final FakeResourceLocation resource;
        private final int[] map;
        private final int width;
        private final int maxHeight;
        private final int yOffset;
        private final int defaultColor;
        private final float[] lastColor = new float[3];

        IntegerGrid(Grid grid) {
            this(grid.resource, grid.map, grid.width, grid.height - 1, (int)grid.yOffset, grid.defaultColor);
        }

        IntegerGrid(FakeResourceLocation resource, int[] map, int width, int maxHeight, int yOffset, int defaultColor) {
            this.resource = resource;
            this.map = map;
            this.width = width;
            this.maxHeight = maxHeight;
            this.yOffset = yOffset;
            this.defaultColor = defaultColor;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{" + this.resource + "}";
        }

        @Override
        public boolean isHeightDependent() {
            return true;
        }

        @Override
        public int getColorMultiplier() {
            return this.defaultColor;
        }

        @Override
        public int getColorMultiplier(aak blockAccess, int i2, int j2, int k) {
            return this.getRGB(BiomeAPI.getBiomeIDAt(blockAccess, i2, j2, k), j2);
        }

        @Override
        public float[] getColorMultiplierF(aak blockAccess, int i2, int j2, int k) {
            int rgb = this.getColorMultiplier(blockAccess, i2, j2, k);
            ColorUtils.intToFloat3(rgb, this.lastColor);
            return this.lastColor;
        }

        @Override
        public void claimResources(Collection<FakeResourceLocation> resources) {
            resources.remove(this.resource);
        }

        @Override
        public IColorMap copy() {
            return new IntegerGrid(this.resource, this.map, this.width, this.maxHeight, this.yOffset, this.defaultColor);
        }

        private int getRGB(int x2, int y2) {
            x2 = ColorMap.clamp(x2, 0, 255) % this.width;
            y2 = ColorMap.clamp(y2 - this.yOffset, 0, this.maxHeight);
            return this.map[y2 * this.width + x2];
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static abstract class Vanilla
    implements IColorMap {
        protected final int defaultColor;
        protected final float[] lastColor = new float[3];

        Vanilla(BufferedImage image) {
            this(image.getRGB(127, 127));
        }

        Vanilla(int defaultColor) {
            this.defaultColor = defaultColor & 0xFFFFFF;
        }

        public String toString() {
            return String.format("%s{%06x}", this.getClass().getSimpleName(), this.defaultColor);
        }

        @Override
        public final boolean isHeightDependent() {
            return false;
        }

        @Override
        public final int getColorMultiplier() {
            return this.defaultColor;
        }

        @Override
        public final int getColorMultiplier(aak blockAccess, int i2, int j2, int k) {
            return this.getColorMultiplier(BiomeAPI.getBiomeGenAt(blockAccess, i2, j2, k), i2, j2, k);
        }

        @Override
        public final float[] getColorMultiplierF(aak blockAccess, int i2, int j2, int k) {
            ColorUtils.intToFloat3(this.getColorMultiplier(blockAccess, i2, j2, k), this.lastColor);
            return this.lastColor;
        }

        @Override
        public final void claimResources(Collection<FakeResourceLocation> resources) {
        }

        abstract int getColorMultiplier(aav var1, int var2, int var3, int var4);
    }

    @Environment(value=EnvType.CLIENT)
    public static final class Water
    implements IColorMap {
        private final float[] lastColor = new float[3];

        public String toString() {
            return String.format("Water{%06x}", this.getColorMultiplier());
        }

        @Override
        public boolean isHeightDependent() {
            return false;
        }

        @Override
        public int getColorMultiplier() {
            return BiomeAPI.getWaterColorMultiplier(BiomeAPI.findBiomeByName("Ocean"));
        }

        @Override
        public int getColorMultiplier(aak blockAccess, int i2, int j2, int k) {
            return BiomeAPI.getWaterColorMultiplier(BiomeAPI.getBiomeGenAt(blockAccess, i2, j2, k));
        }

        @Override
        public float[] getColorMultiplierF(aak blockAccess, int i2, int j2, int k) {
            ColorUtils.intToFloat3(this.getColorMultiplier(blockAccess, i2, j2, k), this.lastColor);
            return this.lastColor;
        }

        @Override
        public void claimResources(Collection<FakeResourceLocation> resources) {
        }

        @Override
        public IColorMap copy() {
            return new Water();
        }
    }
}

