/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.mal.biome;

import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.mal.resource.PropertiesFile;
import java.lang.reflect.Method;
import java.util.BitSet;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;

@Environment(value=EnvType.CLIENT)
public class BiomeAPI {
    private static final MCLogger logger = MCLogger.getLogger("Custom Colors");
    public static final int WORLD_MAX_HEIGHT = 255;
    public static final boolean isColorHeightDependent = false;
    private static boolean biomesLogged;
    private static Method getWaterColorMultiplier;
    private static aav lastBiome;
    private static int lastI;
    private static int lastK;

    private BiomeAPI() {
    }

    public static void parseBiomeList(String list, BitSet bits) {
        BiomeAPI.logBiomes();
        if (MCPatcherUtils.isNullOrEmpty(list)) {
            return;
        }
        for (String s2 : list.split(list.contains(",") ? "\\s*,\\s*" : "\\s+")) {
            aav biome = BiomeAPI.findBiomeByName(s2);
            if (biome == null) continue;
            bits.set(biome.N);
        }
    }

    public static BitSet getHeightListProperty(PropertiesFile properties, String suffix) {
        int minHeight = Math.max(properties.getInt("minHeight" + suffix, 0), 0);
        int maxHeight = Math.min(properties.getInt("maxHeight" + suffix, 255), 255);
        String heightStr = properties.getString("heights" + suffix, "");
        if (minHeight == 0 && maxHeight == 255 && heightStr.length() == 0) {
            return null;
        }
        BitSet heightBits = new BitSet(256);
        if (heightStr.length() == 0) {
            heightStr = String.valueOf(minHeight) + "-" + String.valueOf(maxHeight);
        }
        for (int i2 : MCPatcherUtils.parseIntegerList(heightStr, 0, 255)) {
            heightBits.set(i2);
        }
        return heightBits;
    }

    public static aav findBiomeByName(String name) {
        BiomeAPI.logBiomes();
        if (name == null) {
            return null;
        }
        if ((name = name.replace(" ", "")).isEmpty()) {
            return null;
        }
        for (aav biome : aav.a) {
            if (biome == null || biome.y == null || !name.equalsIgnoreCase(biome.y) && !name.equalsIgnoreCase(biome.y.replace(" ", "")) || biome.N < 0 || biome.N >= aav.a.length) continue;
            return biome;
        }
        return null;
    }

    public static aak getWorld() {
        return Minecraft.x().e;
    }

    public static int getBiomeIDAt(aak blockAccess, int i2, int j2, int k) {
        aav biome = BiomeAPI.getBiomeGenAt(blockAccess, i2, j2, k);
        return biome == null ? aav.a.length : biome.N;
    }

    public static aav getBiomeGenAt(aak blockAccess, int i2, int j2, int k) {
        if (lastBiome == null || i2 != lastI || k != lastK) {
            lastI = i2;
            lastK = k;
            lastBiome = blockAccess.a(i2, k);
        }
        return lastBiome;
    }

    public static float getTemperature(aav biome, int i2, int j2, int k) {
        return biome.j();
    }

    public static float getTemperature(aak blockAccess, int i2, int j2, int k) {
        return BiomeAPI.getTemperature(BiomeAPI.getBiomeGenAt(blockAccess, i2, j2, k), i2, j2, k);
    }

    public static float getRainfall(aav biome, int i2, int j2, int k) {
        return biome.i();
    }

    public static float getRainfall(aak blockAccess, int i2, int j2, int k) {
        return BiomeAPI.getRainfall(BiomeAPI.getBiomeGenAt(blockAccess, i2, j2, k), i2, j2, k);
    }

    public static int getGrassColor(aav biome, int i2, int j2, int k) {
        return biome.k();
    }

    public static int getFoliageColor(aav biome, int i2, int j2, int k) {
        return biome.l();
    }

    public static int getWaterColorMultiplier(aav biome) {
        if (getWaterColorMultiplier != null) {
            try {
                return (Integer)getWaterColorMultiplier.invoke((Object)biome, new Object[0]);
            }
            catch (Throwable e2) {
                e2.printStackTrace();
                getWaterColorMultiplier = null;
            }
        }
        return biome == null ? 0xFFFFFF : biome.H;
    }

    private static void logBiomes() {
        if (!biomesLogged) {
            biomesLogged = true;
            for (int i2 = 0; i2 < aav.a.length; ++i2) {
                aav biome = aav.a[i2];
                if (biome == null) continue;
                int x2 = (int)(255.0f * (1.0f - biome.F));
                int y2 = (int)(255.0f * (1.0f - biome.F * biome.G));
                logger.config("setupBiome #%d id=%d \"%s\" %06x (%d,%d)", i2, biome.N, biome.y, biome.H, x2, y2);
            }
        }
    }

    static {
        try {
            getWaterColorMultiplier = aav.class.getDeclaredMethod("getWaterColorMultiplier", new Class[0]);
            getWaterColorMultiplier.setAccessible(true);
            logger.config("forge getWaterColorMultiplier detected", new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

