/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.hd;

import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.hd.AAHelper;
import com.prupe.mcpatcher.hd.BorderedTexture;
import com.prupe.mcpatcher.hd.MipmapHelper;
import com.prupe.mcpatcher.mal.resource.FakeResourceLocation;
import com.prupe.mcpatcher.mal.resource.GLAPI;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.lwjgl.opengl.GL11;

@Environment(value=EnvType.CLIENT)
public class Wrapper15 {
    private static final MCLogger logger = MCLogger.getLogger("Mipmap");
    public static bir currentAtlas;
    private static boolean flippedTextureLogged;

    public static void setupTexture(bio texture, String textureName) {
        int width = texture.d();
        int height = texture.e();
        MipmapHelper.setupTexture(width, height, false, false, textureName);
        Wrapper15.copySubTexture(texture, texture.h(), 0, 0, width, height);
    }

    public static void setupTexture(bge renderEngine, BufferedImage image, int glTextureId, boolean blur, boolean clamp, FakeResourceLocation textureName) {
        if (image != null) {
            int width = image.getWidth();
            int height = image.getHeight();
            int[] rgb = MCPatcherUtils.getImageRGB(image);
            GLAPI.glBindTexture(glTextureId);
            MipmapHelper.setupTexture(rgb, width, height, 0, 0, blur, clamp, textureName.getPath());
        }
    }

    public static void copySubTexture(bio dst, bio src, int x2, int y2, boolean flipped) {
        if (flipped && !flippedTextureLogged) {
            flippedTextureLogged = true;
            logger.warning("copySubTexture(%s, %s, %d, %d, %s): flipped texture not yet supported", dst.f(), src.f(), x2, y2, flipped);
        }
        GLAPI.glBindTexture(dst.c());
        Wrapper15.copySubTexture(Wrapper15.getMipmaps(src), x2, y2, src.d(), src.e());
    }

    public static void copySubTexture(bio dst, ByteBuffer srcBuffer, int x2, int y2, int width, int height) {
        Wrapper15.copySubTexture(Wrapper15.getMipmaps(Wrapper15.reformatTextureData(srcBuffer), width, height), x2, y2, width, height);
    }

    private static void copySubTexture(IntBuffer[] mipmaps, int x2, int y2, int width, int height) {
        if (mipmaps == null) {
            return;
        }
        for (int level = 0; level < mipmaps.length; ++level) {
            IntBuffer mipmap = mipmaps[level];
            if (mipmap != null) {
                GL11.glTexSubImage2D((int)3553, (int)level, (int)x2, (int)y2, (int)width, (int)height, (int)6408, (int)5121, (IntBuffer)mipmap);
            }
            if (level >= mipmaps.length) break;
            x2 >>= 1;
            y2 >>= 1;
            width >>= 1;
            height >>= 1;
        }
    }

    private static IntBuffer[] getMipmaps(IntBuffer buffer, int width, int height) {
        if (buffer.capacity() == 0) {
            return null;
        }
        int levels = MipmapHelper.getMipmapLevelsForCurrentTexture();
        IntBuffer[] mipmaps = new IntBuffer[levels + 1];
        buffer.position(0);
        mipmaps[0] = buffer;
        for (int level = 1; level < mipmaps.length; ++level) {
            mipmaps[level] = MipmapHelper.newIntBuffer(mipmaps[level - 1].capacity());
            MipmapHelper.scaleHalf(mipmaps[level - 1], width, height, mipmaps[level], 0);
            width >>= 1;
            height >>= 1;
        }
        return mipmaps;
    }

    private static IntBuffer[] getMipmaps(bio texture) {
        if (texture.mipmapData == null) {
            texture.mipmapData = Wrapper15.getMipmaps(Wrapper15.reformatTextureData(texture.h()), texture.d(), texture.e());
        }
        return texture.mipmapData;
    }

    private static IntBuffer reformatTextureData(ByteBuffer buffer) {
        buffer.position(0);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        return Wrapper15.getDirectByteBuffer(buffer).asIntBuffer();
    }

    private static ByteBuffer getDirectByteBuffer(ByteBuffer buffer) {
        if (buffer.isDirect()) {
            return buffer;
        }
        ByteBuffer newBuffer = ByteBuffer.allocateDirect(buffer.capacity());
        newBuffer.order(buffer.order());
        newBuffer.put(buffer);
        newBuffer.flip();
        return newBuffer;
    }

    public static BufferedImage addAABorder(String name, BufferedImage input) {
        if (input == null || currentAtlas == null || !MipmapHelper.useMipmapsForTexture(Wrapper15.currentAtlas.c)) {
            return input;
        }
        return AAHelper.addBorder(new FakeResourceLocation(Wrapper15.currentAtlas.c), input);
    }

    public static bil createSprite(String name) {
        if (currentAtlas == null) {
            return new bil(name);
        }
        return BorderedTexture.create(Wrapper15.currentAtlas.c, name);
    }
}

