/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.hd;

import com.prupe.mcpatcher.Config;
import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.mal.resource.FakeResourceLocation;
import com.prupe.mcpatcher.mal.resource.PropertiesFile;
import com.prupe.mcpatcher.mal.resource.TexturePackAPI;
import com.prupe.mcpatcher.mal.resource.TexturePackChangeHandler;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class FontUtils {
    private static final MCLogger logger = MCLogger.getLogger("HD Font");
    private static final boolean enable = Config.getBoolean("Extended HD", "hdFont", true);
    private static final boolean enableNonHD = Config.getBoolean("Extended HD", "nonHDFontWidth", false);
    private static final int ROWS = 16;
    private static final int COLS = 16;
    public static final char[] AVERAGE_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123467890".toCharArray();
    public static final int[] SPACERS = new int[]{33721342, 0x2808080, 0xDFFFFFF};
    private static final boolean showLines = false;
    private static final Set<awv> allRenderers = new HashSet<awv>();

    static void init() {
    }

    public static FakeResourceLocation getFontName(awv fontRenderer, FakeResourceLocation font, float hdFontAdj) {
        FakeResourceLocation newFont;
        if (fontRenderer.getDefaultFont() == null) {
            fontRenderer.setDefaultFont(font);
        }
        FakeResourceLocation defaultFont = fontRenderer.getDefaultFont();
        if (fontRenderer.getHDFont() == null) {
            String namespace = defaultFont.getNamespace();
            String name = defaultFont.getPath().replaceAll(".*/", "");
            fontRenderer.setHDFont(new FakeResourceLocation(namespace, "/font/" + name));
        }
        FakeResourceLocation hdFont = fontRenderer.getHDFont();
        if (enable && TexturePackAPI.hasResource(hdFont)) {
            if (!hdFont.equals(defaultFont)) {
                logger.fine("using %s instead of %s", hdFont, defaultFont);
            }
            fontRenderer.isHD = true;
            newFont = hdFont;
        } else {
            logger.fine("using default %s", defaultFont);
            fontRenderer.isHD = enable && enableNonHD;
            newFont = defaultFont;
        }
        fontRenderer.fontAdj = fontRenderer.isHD ? hdFontAdj : 1.0f;
        return newFont;
    }

    public static float[] computeCharWidthsf(awv fontRenderer, FakeResourceLocation filename, BufferedImage image, int[] rgb, int[] charWidth) {
        int ch2;
        float[] charWidthf = new float[charWidth.length];
        if (!fontRenderer.isHD) {
            for (int i2 = 0; i2 < charWidth.length; ++i2) {
                charWidthf[i2] = charWidth[i2];
            }
            charWidthf[32] = 4.0f;
            return charWidthf;
        }
        allRenderers.add(fontRenderer);
        int width = image.getWidth();
        int height = image.getHeight();
        int colWidth = width / 16;
        int rowHeight = height / 16;
        block3: for (ch2 = 0; ch2 < charWidth.length; ++ch2) {
            int row = ch2 / 16;
            int col = ch2 % 16;
            for (int colIdx = colWidth - 1; colIdx >= 0; --colIdx) {
                int x2 = col * colWidth + colIdx;
                for (int rowIdx = 0; rowIdx < rowHeight; ++rowIdx) {
                    int y2 = row * rowHeight + rowIdx;
                    int pixel = rgb[x2 + y2 * width];
                    if (!FontUtils.isOpaque(pixel)) continue;
                    if (FontUtils.printThis(ch2)) {
                        logger.finer("%d '%c' pixel (%d, %d) = %08x, colIdx = %d", ch2, Character.valueOf((char)ch2), x2, y2, pixel, colIdx);
                    }
                    charWidthf[ch2] = 128.0f * (float)(colIdx + 1) / (float)width + 1.0f;
                    continue block3;
                }
            }
        }
        for (ch2 = 0; ch2 < charWidthf.length; ++ch2) {
            if (charWidthf[ch2] <= 0.0f) {
                charWidthf[ch2] = 2.0f;
                continue;
            }
            if (!(charWidthf[ch2] >= 7.99f)) continue;
            charWidthf[ch2] = 7.99f;
        }
        boolean[] isOverride = new boolean[charWidth.length];
        try {
            FontUtils.getCharWidthOverrides(filename, charWidthf, isOverride);
        }
        catch (Throwable e2) {
            e2.printStackTrace();
        }
        if (!isOverride[32]) {
            charWidthf[32] = FontUtils.defaultSpaceWidth(charWidthf);
        }
        for (int ch3 = 0; ch3 < charWidth.length; ++ch3) {
            charWidth[ch3] = Math.round(charWidthf[ch3]);
            if (!FontUtils.printThis(ch3)) continue;
            logger.finer("charWidth[%d '%c'] = %f", ch3, Character.valueOf((char)ch3), Float.valueOf(charWidthf[ch3]));
        }
        return charWidthf;
    }

    private static float getCharWidthf(awv fontRenderer, char ch2) {
        float width = fontRenderer.a(ch2);
        if (width < 0.0f || fontRenderer.charWidthf == null || ch2 >= fontRenderer.charWidthf.length) {
            return width;
        }
        return fontRenderer.charWidthf[ch2];
    }

    public static float getCharWidthf(awv fontRenderer, int[] charWidth, int ch2) {
        return fontRenderer.isHD ? fontRenderer.charWidthf[ch2] * (float)fontRenderer.a / 8.0f : (float)charWidth[ch2];
    }

    public static float getStringWidthf(awv fontRenderer, String s2) {
        float totalWidth = 0.0f;
        if (s2 != null) {
            boolean isLink = false;
            for (int i2 = 0; i2 < s2.length(); ++i2) {
                char c2 = s2.charAt(i2);
                float cWidth = FontUtils.getCharWidthf(fontRenderer, c2);
                if (cWidth < 0.0f && i2 < s2.length() - 1) {
                    if ((c2 = s2.charAt(++i2)) == 'l' || c2 == 'L') {
                        isLink = true;
                    } else if (c2 == 'r' || c2 == 'R') {
                        isLink = false;
                    }
                    cWidth = 0.0f;
                }
                totalWidth += cWidth;
                if (!isLink) continue;
                totalWidth += 1.0f;
            }
        }
        return totalWidth;
    }

    public static FakeResourceLocation getUnicodePage(FakeResourceLocation resource) {
        FakeResourceLocation newResource;
        if (enable && resource != null && !(newResource = new FakeResourceLocation(resource.getNamespace(), resource.getPath().replaceFirst("^textures/", "mcpatcher/"))).equals(resource) && TexturePackAPI.hasResource(newResource)) {
            logger.fine("using %s instead of %s", newResource, resource);
            return newResource;
        }
        return resource;
    }

    private static boolean isOpaque(int pixel) {
        for (int i2 : SPACERS) {
            if (pixel != i2) continue;
            return false;
        }
        return (pixel >> 24 & 0xF0) > 0;
    }

    private static boolean printThis(int ch2) {
        return "ABCDEF abcdef0123456789".indexOf(ch2) >= 0;
    }

    private static float defaultSpaceWidth(float[] charWidthf) {
        if (TexturePackAPI.isDefaultTexturePack()) {
            return 4.0f;
        }
        float sum = 0.0f;
        int n = 0;
        for (char ch2 : AVERAGE_CHARS) {
            if (!(charWidthf[ch2] > 0.0f)) continue;
            sum += charWidthf[ch2];
            ++n;
        }
        if (n > 0) {
            return sum / (float)n * 7.0f / 12.0f;
        }
        return 4.0f;
    }

    private static void getCharWidthOverrides(FakeResourceLocation font, float[] charWidthf, boolean[] isOverride) {
        FakeResourceLocation textFile = TexturePackAPI.transformResourceLocation(font, ".png", ".properties");
        PropertiesFile props = PropertiesFile.get(logger, textFile);
        if (props == null) {
            return;
        }
        logger.fine("reading character widths from %s", textFile);
        for (Map.Entry<String, String> entry : props.entrySet()) {
            String key = entry.getKey().trim();
            String value = entry.getValue().trim();
            if (!key.matches("^width\\.\\d+$") || value.equals("")) continue;
            try {
                int ch2 = Integer.parseInt(key.substring(6));
                float width = Float.parseFloat(value);
                if (ch2 < 0 || ch2 >= charWidthf.length) continue;
                logger.finer("setting charWidthf[%d '%c'] to %f", ch2, Character.valueOf((char)ch2), Float.valueOf(width));
                charWidthf[ch2] = width;
                isOverride[ch2] = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    static {
        TexturePackChangeHandler.register(new TexturePackChangeHandler("HD Font", 1){

            @Override
            public void initialize() {
            }

            @Override
            public void beforeChange() {
            }

            @Override
            public void afterChange() {
                for (awv renderer : allRenderers) {
                    renderer.a();
                }
            }
        });
    }
}

