/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.hd;

import com.prupe.mcpatcher.Config;
import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.hd.FancyDial;
import com.prupe.mcpatcher.hd.MipmapHelper;
import com.prupe.mcpatcher.mal.resource.FakeResourceLocation;
import com.prupe.mcpatcher.mal.resource.GLAPI;
import com.prupe.mcpatcher.mal.resource.PropertiesFile;
import com.prupe.mcpatcher.mal.resource.ResourceList;
import com.prupe.mcpatcher.mal.resource.TexturePackAPI;
import com.prupe.mcpatcher.mal.resource.TexturePackChangeHandler;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

@Environment(value=EnvType.CLIENT)
public class CustomAnimation
implements Comparable<CustomAnimation> {
    private static final MCLogger logger = MCLogger.getLogger("Custom Animations", "Animation");
    private static final boolean enable = Config.getBoolean("Extended HD", "animations", true);
    private static final Set<PropertiesFile> pending = new HashSet<PropertiesFile>();
    private static final List<CustomAnimation> animations = new ArrayList<CustomAnimation>();
    private final PropertiesFile properties;
    private final FakeResourceLocation dstName;
    private final FakeResourceLocation srcName;
    private final int mipmapLevel;
    private final ByteBuffer imageData;
    private final int x;
    private final int y;
    private final int w;
    private final int h;
    private int currentFrame;
    private int currentDelay;
    private int numFrames;
    private int[] tileOrder;
    private int[] tileDelay;
    private final int numTiles;
    private boolean error;

    public static void updateAll() {
        if (!pending.isEmpty()) {
            try {
                CustomAnimation.checkPendingAnimations();
            }
            catch (Throwable e2) {
                e2.printStackTrace();
                logger.error("%d remaining animations cleared", pending.size());
                pending.clear();
            }
        }
        for (CustomAnimation animation : animations) {
            animation.update();
        }
    }

    private static void checkPendingAnimations() {
        ArrayList<PropertiesFile> done = new ArrayList<PropertiesFile>();
        for (PropertiesFile properties : pending) {
            FakeResourceLocation textureName = properties.getResourceLocation("to", "");
            if (!TexturePackAPI.isTextureLoaded(textureName)) continue;
            CustomAnimation.addStrip(properties);
            done.add(properties);
        }
        if (!done.isEmpty()) {
            for (PropertiesFile name : done) {
                pending.remove(name);
            }
            Collections.sort(animations);
        }
    }

    private static void addStrip(PropertiesFile properties) {
        FakeResourceLocation dstName = properties.getResourceLocation("to", "");
        if (dstName == null) {
            properties.error("missing to= property", new Object[0]);
            return;
        }
        FakeResourceLocation srcName = properties.getResourceLocation("from", "");
        if (srcName == null) {
            properties.error("missing from= property", new Object[0]);
            return;
        }
        BufferedImage srcImage = TexturePackAPI.getImage(srcName);
        if (srcImage == null) {
            properties.error("image %s not found in texture pack", srcName);
            return;
        }
        int x2 = properties.getInt("x", 0);
        int y2 = properties.getInt("y", 0);
        int w2 = properties.getInt("w", 0);
        int h2 = properties.getInt("h", 0);
        if (dstName.toString().startsWith("minecraft:textures/atlas/")) {
            properties.error("animations cannot have a target of %s", dstName);
            return;
        }
        if (x2 < 0 || y2 < 0 || w2 <= 0 || h2 <= 0) {
            properties.error("%s has invalid dimensions x=%d,y=%d,w=%d,h=%d", srcName, x2, y2, w2, h2);
            return;
        }
        TexturePackAPI.bindTexture(dstName);
        int dstWidth = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
        int dstHeight = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
        int levels = MipmapHelper.getMipmapLevelsForCurrentTexture();
        if (x2 + w2 > dstWidth || y2 + h2 > dstHeight) {
            properties.error("%s dimensions x=%d,y=%d,w=%d,h=%d exceed %s size %dx%d", srcName, x2, y2, w2, h2, dstName, dstWidth, dstHeight);
            return;
        }
        int width = srcImage.getWidth();
        int height = srcImage.getHeight();
        if (width != w2) {
            srcImage = CustomAnimation.resizeImage(srcImage, w2);
            width = srcImage.getWidth();
            height = srcImage.getHeight();
        }
        if (width != w2 || height < h2) {
            properties.error("%s dimensions %dx%d do not match %dx%d", srcName, width, height, w2, h2);
            return;
        }
        ByteBuffer imageData = ByteBuffer.allocateDirect(4 * width * height);
        int[] argb = new int[width * height];
        byte[] rgba = new byte[4 * width * height];
        srcImage.getRGB(0, 0, width, height, argb, 0, width);
        CustomAnimation.ARGBtoRGBA(argb, rgba);
        imageData.put(rgba).flip();
        for (int mipmapLevel = 0; mipmapLevel <= levels; ++mipmapLevel) {
            CustomAnimation.add(new CustomAnimation(properties, srcName, dstName, mipmapLevel, x2, y2, w2, h2, imageData, height / h2));
            if (((x2 | y2 | w2 | h2) & 1) != 0 || w2 <= 0 || h2 <= 0) break;
            ByteBuffer newImage = ByteBuffer.allocateDirect(width * height);
            MipmapHelper.scaleHalf(imageData.asIntBuffer(), width, height, newImage.asIntBuffer(), 0);
            imageData = newImage;
            width >>= 1;
            height >>= 1;
            x2 >>= 1;
            y2 >>= 1;
            w2 >>= 1;
            h2 >>= 1;
        }
    }

    private static void add(CustomAnimation animation) {
        if (animation != null) {
            animations.add(animation);
            if (animation.mipmapLevel == 0) {
                logger.fine("new %s", animation);
            }
        }
    }

    private CustomAnimation(PropertiesFile properties, FakeResourceLocation srcName, FakeResourceLocation dstName, int mipmapLevel, int x2, int y2, int w2, int h2, ByteBuffer imageData, int numFrames) {
        this.properties = properties;
        this.srcName = srcName;
        this.dstName = dstName;
        this.mipmapLevel = mipmapLevel;
        this.x = x2;
        this.y = y2;
        this.w = w2;
        this.h = h2;
        this.imageData = imageData;
        this.numFrames = numFrames;
        this.currentFrame = -1;
        this.numTiles = numFrames;
        this.loadProperties(properties);
    }

    void update() {
        if (this.error) {
            return;
        }
        int texture = TexturePackAPI.getTextureIfLoaded(this.dstName);
        if (texture < 0) {
            return;
        }
        if (--this.currentDelay > 0) {
            return;
        }
        if (++this.currentFrame >= this.numFrames) {
            this.currentFrame = 0;
        }
        GLAPI.glBindTexture(texture);
        this.update(texture, 0, 0);
        int glError = GL11.glGetError();
        if (glError != 0) {
            logger.severe("%s: %s", this, GLU.gluErrorString((int)glError));
            this.error = true;
            return;
        }
        this.currentDelay = this.getDelay();
    }

    @Override
    public int compareTo(CustomAnimation o) {
        return this.dstName.toString().compareTo(o.dstName.toString());
    }

    public String toString() {
        return String.format("CustomAnimation{%s %s %dx%d -> %s%s @ %d,%d (%d frames)}", this.properties, this.srcName, this.w, this.h, this.dstName, this.mipmapLevel > 0 ? "#" + this.mipmapLevel : "", this.x, this.y, this.numFrames);
    }

    private static void ARGBtoRGBA(int[] src, byte[] dest) {
        for (int i2 = 0; i2 < src.length; ++i2) {
            int v2 = src[i2];
            dest[i2 * 4 + 3] = (byte)(v2 >> 24 & 0xFF);
            dest[i2 * 4 + 0] = (byte)(v2 >> 16 & 0xFF);
            dest[i2 * 4 + 1] = (byte)(v2 >> 8 & 0xFF);
            dest[i2 * 4 + 2] = (byte)(v2 >> 0 & 0xFF);
        }
    }

    private static BufferedImage resizeImage(BufferedImage image, int width) {
        if (width == image.getWidth()) {
            return image;
        }
        int height = image.getHeight() * width / image.getWidth();
        logger.finer("resizing to %dx%d", width, height);
        BufferedImage newImage = new BufferedImage(width, height, 2);
        Graphics2D graphics2D = newImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, width, height, null);
        return newImage;
    }

    private void loadProperties(PropertiesFile properties) {
        int i2;
        this.loadTileOrder(properties);
        if (this.tileOrder == null) {
            this.tileOrder = new int[this.numFrames];
            for (i2 = 0; i2 < this.numFrames; ++i2) {
                this.tileOrder[i2] = i2 % this.numTiles;
            }
        }
        this.tileDelay = new int[this.numFrames];
        this.loadTileDelay(properties);
        for (i2 = 0; i2 < this.numFrames; ++i2) {
            this.tileDelay[i2] = Math.max(this.tileDelay[i2], 1);
        }
    }

    private void loadTileOrder(PropertiesFile properties) {
        if (properties == null) {
            return;
        }
        int i2 = 0;
        while (CustomAnimation.getIntValue(properties, "tile.", i2) != null) {
            ++i2;
        }
        if (i2 > 0) {
            this.numFrames = i2;
            this.tileOrder = new int[this.numFrames];
            for (i2 = 0; i2 < this.numFrames; ++i2) {
                this.tileOrder[i2] = Math.abs(CustomAnimation.getIntValue(properties, "tile.", i2)) % this.numTiles;
            }
        }
    }

    private void loadTileDelay(PropertiesFile properties) {
        if (properties == null) {
            return;
        }
        Integer defaultValue = CustomAnimation.getIntValue(properties, "duration");
        for (int i2 = 0; i2 < this.numFrames; ++i2) {
            Integer value = CustomAnimation.getIntValue(properties, "duration.", i2);
            if (value != null) {
                this.tileDelay[i2] = value;
                continue;
            }
            if (defaultValue == null) continue;
            this.tileDelay[i2] = defaultValue;
        }
    }

    private static Integer getIntValue(PropertiesFile properties, String key) {
        try {
            String value = properties.getString(key, "");
            if (value != null && value.matches("^\\d+$")) {
                return Integer.parseInt(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    private static Integer getIntValue(PropertiesFile properties, String prefix, int index) {
        return CustomAnimation.getIntValue(properties, prefix + index);
    }

    private void update(int texture, int dx2, int dy2) {
        GL11.glTexSubImage2D((int)3553, (int)this.mipmapLevel, (int)(this.x + dx2), (int)(this.y + dy2), (int)this.w, (int)this.h, (int)6408, (int)5121, (ByteBuffer)((ByteBuffer)this.imageData.position(4 * this.w * this.h * this.tileOrder[this.currentFrame])));
    }

    private int getDelay() {
        return this.tileDelay[this.currentFrame];
    }

    static {
        TexturePackChangeHandler.register(new TexturePackChangeHandler("Extended HD", 1){

            @Override
            public void beforeChange() {
                if (!pending.isEmpty()) {
                    logger.fine("%d animations were never registered:", pending.size());
                    for (PropertiesFile properties : pending) {
                        logger.fine("  %s", properties);
                    }
                    pending.clear();
                }
                animations.clear();
                MipmapHelper.reset();
                FancyDial.clearAll();
            }

            @Override
            public void afterChange() {
                if (enable) {
                    for (FakeResourceLocation resource : ResourceList.getInstance().listResources("/anim", ".properties", false)) {
                        PropertiesFile properties = PropertiesFile.get(logger, resource);
                        if (properties == null) continue;
                        pending.add(properties);
                    }
                }
            }
        });
    }
}

