/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.hd;

import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.hd.AAHelper;
import com.prupe.mcpatcher.mal.tile.IconAPI;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class BorderedTexture
extends bil {
    private static final MCLogger logger = MCLogger.getLogger("Mipmap");
    private float minU;
    private float maxU;
    private float minV;
    private float maxV;
    private float scaledWidth;
    private float scaledHeight;
    private int tilesheetWidth;
    private int tilesheetHeight;
    private int x0;
    private int y0;
    private String tilesheet;
    int border;

    public static bil create(String tilesheet, String name) {
        if (AAHelper.useAAForTexture(tilesheet)) {
            return new BorderedTexture(tilesheet, name);
        }
        return new bil(name);
    }

    private BorderedTexture(String tilesheet, String name) {
        super(name);
        this.tilesheet = tilesheet;
    }

    @Override
    public void a(bio texture, List animations, int x0, int y0, int width, int height, boolean flipped) {
        super.a(texture, animations, x0, y0, width, height, flipped);
        this.tilesheetWidth = texture.d();
        this.tilesheetHeight = texture.e();
        this.x0 = x0;
        this.y0 = y0;
        this.border = MCPatcherUtils.isNullOrEmpty(animations) ? 0 : ((bio)animations.get((int)0)).border;
        this.setBorderWidth(width, height, this.border);
    }

    @Override
    public float e() {
        return this.minU;
    }

    @Override
    public float f() {
        return this.maxU;
    }

    @Override
    public float a(double u2) {
        return this.border > 0 ? this.minU + (float)u2 * this.scaledWidth : super.a(u2);
    }

    @Override
    public float g() {
        return this.minV;
    }

    @Override
    public float h() {
        return this.maxV;
    }

    @Override
    public float b(double v2) {
        return this.border > 0 ? this.minV + (float)v2 * this.scaledHeight : super.b(v2);
    }

    @Override
    public void a(bil stitched) {
        if (stitched instanceof BorderedTexture) {
            BorderedTexture bordered = (BorderedTexture)stitched;
            this.tilesheetWidth = bordered.tilesheetWidth;
            this.tilesheetHeight = bordered.tilesheetHeight;
            this.x0 = bordered.x0;
            this.y0 = bordered.y0;
            this.tilesheet = bordered.tilesheet;
            this.border = bordered.border;
        }
    }

    void setBorderWidth(int width, int height, int border) {
        this.border = border;
        if (width <= 0 || height <= 0) {
            this.y0 = 0;
            this.x0 = 0;
            this.maxV = 0.0f;
            this.minV = 0.0f;
            this.maxU = 0.0f;
            this.minU = 0.0f;
            this.scaledHeight = 0.0f;
            this.scaledWidth = 0.0f;
            return;
        }
        logger.finer("setBorderWidth(%s, %s, %d): %dx%d -> %dx%d", this.tilesheet, IconAPI.getIconName(this), border, width - 2 * border, height - 2 * border, width, height);
        if (border > 0) {
            this.x0 += border;
            this.y0 += border;
            this.minU = (float)this.x0 / (float)this.tilesheetWidth;
            this.maxU = (float)(this.x0 + (width -= 2 * border)) / (float)this.tilesheetWidth;
            this.minV = (float)this.y0 / (float)this.tilesheetHeight;
            this.maxV = (float)(this.y0 + (height -= 2 * border)) / (float)this.tilesheetHeight;
        } else {
            this.minU = super.e();
            this.maxU = super.f();
            this.minV = super.g();
            this.maxV = super.h();
        }
        this.scaledWidth = (this.maxU - this.minU) / 16.0f;
        this.scaledHeight = (this.maxV - this.minV) / 16.0f;
    }
}

