/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.hd;

import com.prupe.mcpatcher.Config;
import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.hd.MipmapHelper;
import com.prupe.mcpatcher.mal.resource.FakeResourceLocation;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.lwjgl.opengl.PixelFormat;

@Environment(value=EnvType.CLIENT)
public class AAHelper {
    private static final MCLogger logger = MCLogger.getLogger("Mipmap");
    private static final int debugColor = Config.getBoolean("Extended HD", "debugBorder", false) ? -16776961 : 0;
    private static final int aaSamples = Config.getInt("Extended HD", "antiAliasing", 1);
    private static Field addressField;
    public static int lastBorder;

    public static PixelFormat setupPixelFormat(PixelFormat pixelFormat) {
        if (aaSamples > 1) {
            logger.config("setting AA samples to %d", aaSamples);
            return pixelFormat.withSamples(aaSamples);
        }
        return pixelFormat;
    }

    static BufferedImage addBorder(FakeResourceLocation name, BufferedImage input) {
        lastBorder = 0;
        if (input == null) {
            return input;
        }
        if (name != null && MipmapHelper.useMipmapsForTexture(name.getPath())) {
            input = MipmapHelper.fixTransparency(name, input);
        }
        int width = input.getWidth();
        int height = input.getHeight();
        int numFrames = height / width;
        height = width;
        lastBorder = AAHelper.getBorderWidth(width);
        int border = lastBorder;
        if (border <= 0) {
            return input;
        }
        int newWidth = width + 2 * border;
        int newHeight = height + 2 * border;
        BufferedImage output = new BufferedImage(newWidth, numFrames * newHeight, 2);
        for (int frame = 0; frame < numFrames; ++frame) {
            int sy2 = frame * height;
            int dy2 = frame * newHeight;
            AAHelper.copyRegion(input, 0, sy2, output, 0, dy2, border, border, true, true);
            AAHelper.copyRegion(input, 0, sy2, output, border, dy2, width, border, false, true);
            AAHelper.copyRegion(input, width - border, sy2, output, width + border, dy2, border, border, true, true);
            AAHelper.copyRegion(input, 0, sy2, output, 0, dy2 + border, border, width, true, false);
            AAHelper.copyRegion(input, 0, sy2, output, border, dy2 + border, width, height, false, false);
            AAHelper.copyRegion(input, width - border, sy2, output, width + border, dy2 + border, border, width, true, false);
            AAHelper.copyRegion(input, 0, sy2 + height - border, output, 0, dy2 + height + border, border, border, true, true);
            AAHelper.copyRegion(input, 0, sy2 + height - border, output, border, dy2 + height + border, width, border, false, true);
            AAHelper.copyRegion(input, width - border, sy2 + height - border, output, width + border, dy2 + height + border, border, border, true, true);
            AAHelper.addDebugOutline(output, dy2, width, height, border);
        }
        return output;
    }

    static boolean useAAForTexture(String texture) {
        return (aaSamples > 1 || MipmapHelper.anisoLevel > 1) && MipmapHelper.useMipmapsForTexture(texture);
    }

    private static int getBorderWidth(int size) {
        int border = aaSamples <= 1 && MipmapHelper.anisoLevel <= 1 ? 0 : (MipmapHelper.mipmapEnabled && MipmapHelper.maxMipmapLevel > 0 ? 1 << Math.max(Math.min(MipmapHelper.maxMipmapLevel, 4), 0) : 2);
        return Math.min(border, size);
    }

    private static void copyRegion(BufferedImage input, int sx2, int sy2, BufferedImage output, int dx2, int dy2, int w2, int h2, boolean flipX, boolean flipY) {
        int[] rgb = new int[w2 * h2];
        input.getRGB(sx2, sy2, w2, h2, rgb, 0, w2);
        if (flipX || flipY) {
            int[] rgbFlipped = new int[w2 * h2];
            for (int i2 = 0; i2 < w2; ++i2) {
                for (int j2 = 0; j2 < h2; ++j2) {
                    rgbFlipped[w2 * j2 + i2] = rgb[w2 * (flipY ? h2 - 1 - j2 : j2) + (flipX ? w2 - 1 - i2 : i2)];
                }
            }
            output.setRGB(dx2, dy2, w2, h2, rgbFlipped, 0, w2);
        } else {
            output.setRGB(dx2, dy2, w2, h2, rgb, 0, w2);
        }
    }

    private static void addDebugOutline(BufferedImage output, int dy2, int width, int height, int border) {
        if (debugColor != 0) {
            int i2;
            for (i2 = 0; i2 < width; ++i2) {
                output.setRGB(i2 + border, dy2 + border, debugColor);
                output.setRGB(i2 + border, dy2 + height + border, debugColor);
            }
            for (i2 = 0; i2 < height; ++i2) {
                output.setRGB(border, dy2 + i2 + border, debugColor);
                output.setRGB(height + border, dy2 + i2 + border, debugColor);
            }
        }
    }
}

