/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.ctm;

import com.prupe.mcpatcher.Config;
import com.prupe.mcpatcher.ctm.ITileOverride;
import com.prupe.mcpatcher.ctm.RenderBlockState;
import com.prupe.mcpatcher.mal.block.BlockStateMatcher;
import com.prupe.mcpatcher.mal.tile.IconAPI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public abstract class TileOverrideIterator
implements Iterator<ITileOverride> {
    private static final int MAX_RECURSION = Config.getInt("Connected Textures", "maxRecursion", 4);
    private final Map<apa, List<BlockStateMatcher>> allBlockOverrides;
    private final Map<String, List<ITileOverride>> allTileOverrides;
    protected lx currentIcon;
    private List<BlockStateMatcher> blockOverrides;
    private List<ITileOverride> tileOverrides;
    private final Set<ITileOverride> skipOverrides = new HashSet<ITileOverride>();
    private RenderBlockState renderBlockState;
    private int blockPos;
    private int iconPos;
    private boolean foundNext;
    private ITileOverride nextOverride;
    private ITileOverride lastMatchedOverride;

    protected TileOverrideIterator(Map<apa, List<BlockStateMatcher>> allBlockOverrides, Map<String, List<ITileOverride>> allTileOverrides) {
        this.allBlockOverrides = allBlockOverrides;
        this.allTileOverrides = allTileOverrides;
    }

    void clear() {
        this.currentIcon = null;
        this.blockOverrides = null;
        this.tileOverrides = null;
        this.nextOverride = null;
        this.lastMatchedOverride = null;
        this.skipOverrides.clear();
    }

    private void resetForNextPass() {
        this.blockOverrides = null;
        this.tileOverrides = this.allTileOverrides.get(IconAPI.getIconName(this.currentIcon));
        this.blockPos = 0;
        this.iconPos = 0;
        this.foundNext = false;
    }

    @Override
    public boolean hasNext() {
        if (this.foundNext) {
            return true;
        }
        if (this.tileOverrides != null) {
            while (this.iconPos < this.tileOverrides.size()) {
                if (!this.checkOverride(this.tileOverrides.get(this.iconPos++))) continue;
                this.renderBlockState.setFilter(null);
                return true;
            }
        }
        if (this.blockOverrides != null) {
            while (this.blockPos < this.blockOverrides.size()) {
                BlockStateMatcher matcher;
                if (!this.renderBlockState.match(matcher = this.blockOverrides.get(this.blockPos++)) || !this.checkOverride((ITileOverride)matcher.getData())) continue;
                this.renderBlockState.setFilter(matcher);
                return true;
            }
        }
        return false;
    }

    @Override
    public ITileOverride next() {
        if (!this.foundNext) {
            throw new IllegalStateException("next called before hasNext() == true");
        }
        this.foundNext = false;
        return this.nextOverride;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove not supported");
    }

    private boolean checkOverride(ITileOverride override) {
        if (override != null && !override.isDisabled() && !this.skipOverrides.contains(override)) {
            this.foundNext = true;
            this.nextOverride = override;
            return true;
        }
        return false;
    }

    public ITileOverride go(RenderBlockState renderBlockState, lx origIcon) {
        this.renderBlockState = renderBlockState;
        renderBlockState.setFilter(null);
        this.currentIcon = origIcon;
        this.blockOverrides = this.allBlockOverrides.get(renderBlockState.getBlock());
        this.tileOverrides = this.allTileOverrides.get(IconAPI.getIconName(origIcon));
        this.blockPos = 0;
        this.iconPos = 0;
        this.foundNext = false;
        this.nextOverride = null;
        this.lastMatchedOverride = null;
        this.skipOverrides.clear();
        block0: for (int pass = 0; pass < MAX_RECURSION; ++pass) {
            while (this.hasNext()) {
                ITileOverride override = this.next();
                lx newIcon = this.getTile(override, renderBlockState, origIcon);
                if (newIcon == null) continue;
                this.lastMatchedOverride = override;
                this.skipOverrides.add(override);
                this.currentIcon = newIcon;
                this.resetForNextPass();
                continue block0;
            }
            break block0;
        }
        return this.lastMatchedOverride;
    }

    public lx getIcon() {
        return this.currentIcon;
    }

    protected abstract lx getTile(ITileOverride var1, RenderBlockState var2, lx var3);

    @Environment(value=EnvType.CLIENT)
    public static final class Metadata
    extends TileOverrideIterator {
        Metadata(Map<apa, List<BlockStateMatcher>> blockOverrides, Map<String, List<ITileOverride>> tileOverrides) {
            super(blockOverrides, tileOverrides);
        }

        @Override
        protected lx getTile(ITileOverride override, RenderBlockState renderBlockState, lx origIcon) {
            return override.getTileHeld(renderBlockState, origIcon);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static final class IJK
    extends TileOverrideIterator {
        IJK(Map<apa, List<BlockStateMatcher>> blockOverrides, Map<String, List<ITileOverride>> tileOverrides) {
            super(blockOverrides, tileOverrides);
        }

        @Override
        protected lx getTile(ITileOverride override, RenderBlockState renderBlockState, lx origIcon) {
            return override.getTileWorld(renderBlockState, origIcon);
        }
    }
}

