/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.ctm;

import com.prupe.mcpatcher.mal.block.BlockStateMatcher;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public abstract class RenderBlockState {
    public static final int BOTTOM_FACE = 0;
    public static final int TOP_FACE = 1;
    public static final int NORTH_FACE = 2;
    public static final int SOUTH_FACE = 3;
    public static final int WEST_FACE = 4;
    public static final int EAST_FACE = 5;
    public static final int[] GO_DOWN = new int[]{0, -1, 0};
    public static final int[] GO_UP = new int[]{0, 1, 0};
    public static final int[] GO_NORTH = new int[]{0, 0, -1};
    public static final int[] GO_SOUTH = new int[]{0, 0, 1};
    public static final int[] GO_WEST = new int[]{-1, 0, 0};
    public static final int[] GO_EAST = new int[]{1, 0, 0};
    public static final int[][] NORMALS = new int[][]{GO_DOWN, GO_UP, GO_NORTH, GO_SOUTH, GO_WEST, GO_EAST};
    public static final int REL_L = 0;
    public static final int REL_DL = 1;
    public static final int REL_D = 2;
    public static final int REL_DR = 3;
    public static final int REL_R = 4;
    public static final int REL_UR = 5;
    public static final int REL_U = 6;
    public static final int REL_UL = 7;
    public static final int CONNECT_BY_BLOCK = 0;
    public static final int CONNECT_BY_TILE = 1;
    public static final int CONNECT_BY_MATERIAL = 2;
    protected aak blockAccess;
    protected apa block;
    protected boolean useAO;
    protected boolean inWorld;
    protected BlockStateMatcher matcher;
    protected boolean offsetsComputed;
    protected boolean haveOffsets;
    protected int di;
    protected int dj;
    protected int dk;

    protected static int[] add(int[] a2, int[] b2) {
        if (a2.length != b2.length) {
            throw new RuntimeException("arrays to add are not same length");
        }
        int[] c2 = new int[a2.length];
        for (int i2 = 0; i2 < c2.length; ++i2) {
            c2[i2] = a2[i2] + b2[i2];
        }
        return c2;
    }

    protected static int[][] makeNeighborOffset(int left, int down, int right, int up2) {
        int[] l2 = NORMALS[left];
        int[] d2 = NORMALS[down];
        int[] r2 = NORMALS[right];
        int[] u2 = NORMALS[up2];
        return new int[][]{l2, RenderBlockState.add(l2, d2), d2, RenderBlockState.add(d2, r2), r2, RenderBlockState.add(r2, u2), u2, RenderBlockState.add(u2, l2)};
    }

    public final aak getBlockAccess() {
        return this.blockAccess;
    }

    public final apa getBlock() {
        return this.block;
    }

    public final boolean useAO() {
        return this.useAO;
    }

    public final boolean isInWorld() {
        return this.inWorld;
    }

    public final void setFilter(BlockStateMatcher matcher) {
        this.matcher = matcher;
    }

    public final BlockStateMatcher getFilter() {
        return this.matcher;
    }

    public void clear() {
        this.blockAccess = null;
        this.block = null;
        this.useAO = false;
        this.inWorld = false;
        this.offsetsComputed = false;
        this.haveOffsets = false;
        this.dk = 0;
        this.dj = 0;
        this.di = 0;
        this.setFilter(null);
    }

    public abstract int getI();

    public abstract int getJ();

    public abstract int getK();

    public abstract int getBlockFace();

    public abstract int getTextureFace();

    public abstract int getTextureFaceOrig();

    public abstract String getTextureFaceName();

    public abstract int getFaceForHV();

    public abstract boolean match(BlockStateMatcher var1);

    public abstract int[] getOffset(int var1, int var2);

    public abstract boolean setCoordOffsetsForRenderType();

    public final int getDI() {
        return this.di;
    }

    public final int getDJ() {
        return this.dj;
    }

    public final int getDK() {
        return this.dk;
    }

    public abstract boolean shouldConnectByBlock(apa var1, int var2, int var3, int var4);

    public abstract boolean shouldConnectByTile(apa var1, lx var2, int var3, int var4, int var5);
}

