/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.ctm;

import com.prupe.mcpatcher.Config;
import com.prupe.mcpatcher.ctm.CTMUtils;
import com.prupe.mcpatcher.mal.block.BlockAPI;
import com.prupe.mcpatcher.mal.tessellator.TessellatorAPI;
import java.util.Arrays;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class GlassPaneRenderer {
    private static final boolean enable = Config.getBoolean("Connected Textures", "glassPane", true);
    public static boolean skipPaneRendering;
    public static boolean skipTopEdgeRendering;
    public static boolean skipBottomEdgeRendering;
    private static final lx[] icons;
    private static double u0;
    private static double u1;
    private static double u2;
    private static double u3;
    private static double v0;
    private static double v1;
    private static double u1Scaled;
    private static double u2Scaled;

    public static void renderThin(bgf renderBlocks, apa blockPane, lx origIcon, int i2, int j2, int k, boolean connectNorth, boolean connectSouth, boolean connectWest, boolean connectEast) {
        if (GlassPaneRenderer.setupIcons(renderBlocks, blockPane, origIcon, i2, j2, k)) {
            GlassPaneRenderer.render(i2, j2, k, connectNorth, connectSouth, connectWest, connectEast, 0.0, 0.0, 0.0, false);
        }
    }

    public static void renderThick(bgf renderBlocks, apa blockPane, lx origIcon, int i2, int j2, int k, boolean connectNorth, boolean connectSouth, boolean connectWest, boolean connectEast) {
        if (GlassPaneRenderer.setupIcons(renderBlocks, blockPane, origIcon, i2, j2, k)) {
            GlassPaneRenderer.setupPaneEdges(renderBlocks, blockPane, i2, j2, k);
            GlassPaneRenderer.render(i2, j2, k, connectNorth, connectSouth, connectWest, connectEast, 0.0625, 1.0, 0.001, true);
        }
    }

    private static boolean setupIcons(bgf renderBlocks, apa blockPane, lx origIcon, int i2, int j2, int k) {
        skipTopEdgeRendering = false;
        skipBottomEdgeRendering = false;
        skipPaneRendering = false;
        if (!enable) {
            return false;
        }
        for (int face = 2; face <= 5; ++face) {
            GlassPaneRenderer.icons[face] = CTMUtils.getBlockIcon(origIcon, renderBlocks, blockPane, renderBlocks.a, i2, j2, k, face);
            if (icons[face] == null) {
                skipPaneRendering = false;
                return false;
            }
            if (icons[face] == origIcon) continue;
            skipPaneRendering = true;
        }
        return skipPaneRendering;
    }

    private static void setupPaneEdges(bgf renderBlocks, apa blockPane, int i2, int j2, int k) {
        aak blockAccess = renderBlocks.a;
        int metadata = BlockAPI.getMetadataAt(blockAccess, i2, j2, k);
        skipBottomEdgeRendering = BlockAPI.getBlockAt(blockAccess, i2, j2 - 1, k) == blockPane && BlockAPI.getMetadataAt(blockAccess, i2, j2 - 1, k) == metadata;
        skipTopEdgeRendering = BlockAPI.getBlockAt(blockAccess, i2, j2 + 1, k) == blockPane && BlockAPI.getMetadataAt(blockAccess, i2, j2 + 1, k) == metadata;
    }

    private static void render(int i2, int j2, int k, boolean connectNorth, boolean connectSouth, boolean connectWest, boolean connectEast, double thickness, double uOffset, double yOffset, boolean edges) {
        double i0 = i2;
        double i1 = i0 + 0.5 - thickness;
        double i22 = i0 + 0.5 + thickness;
        double i3 = i0 + 1.0;
        double j0 = (double)j2 + yOffset;
        double j1 = (double)j2 + 1.0 - yOffset;
        double k0 = k;
        double k1 = k0 + 0.5 - thickness;
        double k2 = k0 + 0.5 + thickness;
        double k3 = k0 + 1.0;
        u1Scaled = 8.0 - uOffset;
        u2Scaled = 8.0 + uOffset;
        if (!(connectNorth || connectSouth || connectWest || connectEast)) {
            connectEast = true;
            connectWest = true;
            connectSouth = true;
            connectNorth = true;
            if (edges) {
                GlassPaneRenderer.setupTileCoords(5);
                GlassPaneRenderer.drawFace(i3, j1, k2, u1, v0, i3, j0, k1, u2, v1);
                GlassPaneRenderer.setupTileCoords(4);
                GlassPaneRenderer.drawFace(i0, j1, k1, u1, v0, i0, j0, k2, u2, v1);
                GlassPaneRenderer.setupTileCoords(3);
                GlassPaneRenderer.drawFace(i1, j1, k3, u1, v0, i22, j0, k3, u2, v1);
                GlassPaneRenderer.setupTileCoords(2);
                GlassPaneRenderer.drawFace(i22, j1, k0, u1, v0, i1, j0, k0, u2, v1);
            }
        }
        if (connectEast && connectWest) {
            GlassPaneRenderer.setupTileCoords(3);
            GlassPaneRenderer.drawFace(i0, j1, k2, u0, v0, i3, j0, k2, u3, v1);
            GlassPaneRenderer.setupTileCoords(2);
            GlassPaneRenderer.drawFace(i3, j1, k1, u0, v0, i0, j0, k1, u3, v1);
        } else if (connectWest) {
            GlassPaneRenderer.setupTileCoords(3);
            if (connectSouth) {
                GlassPaneRenderer.drawFace(i0, j1, k2, u2, v0, i1, j0, k2, u3, v1);
            } else {
                GlassPaneRenderer.drawFace(i0, j1, k2, u1, v0, i22, j0, k2, u3, v1);
            }
            GlassPaneRenderer.setupTileCoords(2);
            if (connectNorth) {
                GlassPaneRenderer.drawFace(i1, j1, k1, u0, v0, i0, j0, k1, u1, v1);
            } else {
                GlassPaneRenderer.drawFace(i22, j1, k1, u0, v0, i0, j0, k1, u2, v1);
            }
            if (edges && !connectNorth && !connectSouth) {
                GlassPaneRenderer.setupTileCoords(5);
                GlassPaneRenderer.drawFace(i22, j1, k2, u1, v0, i22, j0, k1, u2, v1);
            }
        } else if (connectEast) {
            GlassPaneRenderer.setupTileCoords(3);
            if (connectSouth) {
                GlassPaneRenderer.drawFace(i22, j1, k2, u0, v0, i3, j0, k2, u1, v1);
            } else {
                GlassPaneRenderer.drawFace(i1, j1, k2, u0, v0, i3, j0, k2, u2, v1);
            }
            GlassPaneRenderer.setupTileCoords(2);
            if (connectNorth) {
                GlassPaneRenderer.drawFace(i3, j1, k1, u2, v0, i22, j0, k1, u3, v1);
            } else {
                GlassPaneRenderer.drawFace(i3, j1, k1, u1, v0, i1, j0, k1, u3, v1);
            }
            if (edges && !connectNorth && !connectSouth) {
                GlassPaneRenderer.setupTileCoords(4);
                GlassPaneRenderer.drawFace(i1, j1, k1, u1, v0, i1, j0, k2, u2, v1);
            }
        }
        if (connectNorth && connectSouth) {
            GlassPaneRenderer.setupTileCoords(4);
            GlassPaneRenderer.drawFace(i1, j1, k0, u0, v0, i1, j0, k3, u3, v1);
            GlassPaneRenderer.setupTileCoords(5);
            GlassPaneRenderer.drawFace(i22, j1, k3, u0, v0, i22, j0, k0, u3, v1);
        } else if (connectNorth) {
            GlassPaneRenderer.setupTileCoords(4);
            if (connectWest) {
                GlassPaneRenderer.drawFace(i1, j1, k0, u2, v0, i1, j0, k1, u3, v1);
            } else {
                GlassPaneRenderer.drawFace(i1, j1, k0, u1, v0, i1, j0, k2, u3, v1);
            }
            GlassPaneRenderer.setupTileCoords(5);
            if (connectEast) {
                GlassPaneRenderer.drawFace(i22, j1, k1, u0, v0, i22, j0, k0, u1, v1);
            } else {
                GlassPaneRenderer.drawFace(i22, j1, k2, u0, v0, i22, j0, k0, u2, v1);
            }
            if (edges && !connectWest && !connectEast) {
                GlassPaneRenderer.setupTileCoords(3);
                GlassPaneRenderer.drawFace(i1, j1, k2, u1, v0, i22, j0, k2, u2, v1);
            }
        } else if (connectSouth) {
            GlassPaneRenderer.setupTileCoords(4);
            if (connectWest) {
                GlassPaneRenderer.drawFace(i1, j1, k2, u0, v0, i1, j0, k3, u1, v1);
            } else {
                GlassPaneRenderer.drawFace(i1, j1, k1, u0, v0, i1, j0, k3, u2, v1);
            }
            GlassPaneRenderer.setupTileCoords(5);
            if (connectEast) {
                GlassPaneRenderer.drawFace(i22, j1, k3, u2, v0, i22, j0, k2, u3, v1);
            } else {
                GlassPaneRenderer.drawFace(i22, j1, k3, u1, v0, i22, j0, k1, u3, v1);
            }
            if (edges && !connectWest && !connectEast) {
                GlassPaneRenderer.setupTileCoords(2);
                GlassPaneRenderer.drawFace(i22, j1, k1, u1, v0, i1, j0, k1, u2, v1);
            }
        }
    }

    private static void setupTileCoords(int face) {
        lx icon = icons[face];
        u0 = icon.e();
        u1 = icon.a(u1Scaled);
        u2 = icon.a(u2Scaled);
        u3 = icon.f();
        v0 = icon.g();
        v1 = icon.h();
    }

    private static void drawFace(double x0, double y0, double z0, double u0, double v0, double x1, double y1, double z1, double u1, double v1) {
        bgd tessellator = TessellatorAPI.getTessellator();
        TessellatorAPI.addVertexWithUV(tessellator, x0, y0, z0, u0, v0);
        TessellatorAPI.addVertexWithUV(tessellator, x0, y1, z0, u0, v1);
        TessellatorAPI.addVertexWithUV(tessellator, x1, y1, z1, u1, v1);
        TessellatorAPI.addVertexWithUV(tessellator, x1, y0, z1, u1, v0);
    }

    static void clear() {
        Arrays.fill(icons, null);
        skipPaneRendering = false;
    }

    static {
        icons = new lx[6];
    }
}

