/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.ctm;

import com.prupe.mcpatcher.Config;
import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.ctm.BlockOrientation;
import com.prupe.mcpatcher.ctm.GlassPaneRenderer;
import com.prupe.mcpatcher.ctm.ITileOverride;
import com.prupe.mcpatcher.ctm.TileOverride;
import com.prupe.mcpatcher.ctm.TileOverrideIterator;
import com.prupe.mcpatcher.mal.block.BlockAPI;
import com.prupe.mcpatcher.mal.block.BlockStateMatcher;
import com.prupe.mcpatcher.mal.block.RenderBlocksUtils;
import com.prupe.mcpatcher.mal.block.RenderPassAPI;
import com.prupe.mcpatcher.mal.resource.BlendMethod;
import com.prupe.mcpatcher.mal.resource.FakeResourceLocation;
import com.prupe.mcpatcher.mal.resource.ResourceList;
import com.prupe.mcpatcher.mal.resource.TexturePackChangeHandler;
import com.prupe.mcpatcher.mal.tile.TileLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class CTMUtils {
    private static final MCLogger logger = MCLogger.getLogger("Connected Textures", "CTM");
    private static final boolean enableStandard = Config.getBoolean("Connected Textures", "standard", true);
    private static final boolean enableNonStandard = Config.getBoolean("Connected Textures", "nonStandard", true);
    private static final List<ITileOverride> allOverrides = new ArrayList<ITileOverride>();
    private static final Map<apa, List<BlockStateMatcher>> blockOverrides = new IdentityHashMap<apa, List<BlockStateMatcher>>();
    private static final Map<String, List<ITileOverride>> tileOverrides = new HashMap<String, List<ITileOverride>>();
    private static TileLoader tileLoader;
    private static ITileOverride lastOverride;
    private static final TileOverrideIterator.IJK ijkIterator;
    private static final TileOverrideIterator.Metadata metadataIterator;
    private static boolean haveBlockFace;
    private static final BlockOrientation renderBlockState;

    private static void clearBlockFace() {
        haveBlockFace = false;
    }

    public static lx getBlockIcon(lx icon, bgf renderBlocks, apa block, aak blockAccess, int i2, int j2, int k, int face) {
        lastOverride = null;
        if (blockAccess != null && CTMUtils.checkFace(face)) {
            if (!haveBlockFace) {
                renderBlockState.setBlock(block, blockAccess, i2, j2, k);
                renderBlockState.setFace(face);
            }
            if ((lastOverride = ijkIterator.go(renderBlockState, icon)) != null) {
                icon = ijkIterator.getIcon();
            }
        }
        CTMUtils.clearBlockFace();
        return lastOverride == null && CTMUtils.skipDefaultRendering(block) ? RenderBlocksUtils.blankIcon : icon;
    }

    public static lx getBlockIcon(lx icon, bgf renderBlocks, apa block, int face, int metadata) {
        lastOverride = null;
        if (CTMUtils.checkFace(face) && CTMUtils.checkRenderType(block)) {
            renderBlockState.setBlockMetadata(block, metadata, face);
            lastOverride = metadataIterator.go(renderBlockState, icon);
            if (lastOverride != null) {
                icon = metadataIterator.getIcon();
            }
        }
        return icon;
    }

    public static lx getBlockIcon(lx icon, bgf renderBlocks, apa block, int face) {
        return CTMUtils.getBlockIcon(icon, renderBlocks, block, face, 0);
    }

    public static void reset() {
    }

    private static boolean checkFace(int face) {
        return face < 0 ? enableNonStandard : enableStandard;
    }

    private static boolean checkRenderType(apa block) {
        switch (block.d()) {
            case 11: 
            case 21: {
                return false;
            }
        }
        return true;
    }

    private static boolean skipDefaultRendering(apa block) {
        return RenderPassAPI.instance.skipDefaultRendering(block);
    }

    private static void registerOverride(ITileOverride override) {
        if (override != null && !override.isDisabled()) {
            Set<String> matchingTiles;
            List<Object> list;
            boolean registered = false;
            List<BlockStateMatcher> matchingBlocks = override.getMatchingBlocks();
            if (!MCPatcherUtils.isNullOrEmpty(matchingBlocks)) {
                for (BlockStateMatcher matcher : matchingBlocks) {
                    if (matcher == null) continue;
                    apa block = matcher.getBlock();
                    list = blockOverrides.get(block);
                    if (list == null) {
                        list = new ArrayList();
                        blockOverrides.put(block, list);
                    }
                    list.add(matcher);
                    logger.fine("using %s for block %s", override, BlockAPI.getBlockName(block));
                    registered = true;
                }
            }
            if (!MCPatcherUtils.isNullOrEmpty(matchingTiles = override.getMatchingTiles())) {
                for (String name : matchingTiles) {
                    list = tileOverrides.get(name);
                    if (list == null) {
                        list = new ArrayList();
                        tileOverrides.put(name, list);
                    }
                    list.add(override);
                    logger.fine("using %s for tile %s", override, name);
                    registered = true;
                }
            }
            if (registered) {
                allOverrides.add(override);
            }
        }
    }

    public static void setBlankResource() {
        RenderBlocksUtils.blankIcon = tileLoader.getIcon(RenderPassAPI.instance.getBlankResource());
    }

    public static TileOverrideIterator.IJK newIJKIterator() {
        return new TileOverrideIterator.IJK(blockOverrides, tileOverrides);
    }

    public static TileOverrideIterator.Metadata newMetadataIterator() {
        return new TileOverrideIterator.Metadata(blockOverrides, tileOverrides);
    }

    static {
        ijkIterator = CTMUtils.newIJKIterator();
        metadataIterator = CTMUtils.newMetadataIterator();
        renderBlockState = new BlockOrientation();
        try {
            Class.forName("com.prupe.mcpatcher.renderpass.RenderPass").getMethod("finish", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        TexturePackChangeHandler.register(new TexturePackChangeHandler("Connected Textures", 3){

            @Override
            public void initialize() {
            }

            @Override
            public void beforeChange() {
                RenderPassAPI.instance.clear();
                try {
                    GlassPaneRenderer.clear();
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                }
                catch (Throwable e2) {
                    e2.printStackTrace();
                }
                renderBlockState.clear();
                ijkIterator.clear();
                metadataIterator.clear();
                allOverrides.clear();
                blockOverrides.clear();
                tileOverrides.clear();
                lastOverride = null;
                RenderBlocksUtils.blankIcon = null;
                tileLoader = new TileLoader("textures/blocks", logger);
                RenderPassAPI.instance.refreshBlendingOptions();
                if (enableStandard || enableNonStandard) {
                    for (FakeResourceLocation resource : ResourceList.getInstance().listResources("/ctm", ".properties", true)) {
                        CTMUtils.registerOverride(TileOverride.create(resource, tileLoader));
                    }
                }
                for (FakeResourceLocation resource : BlendMethod.getAllBlankResources()) {
                    tileLoader.preloadTile(resource, false);
                }
            }

            @Override
            public void afterChange() {
                for (ITileOverride iTileOverride : allOverrides) {
                    iTileOverride.registerIcons();
                }
                for (Map.Entry entry : blockOverrides.entrySet()) {
                    for (BlockStateMatcher matcher : (List)entry.getValue()) {
                        ITileOverride override = (ITileOverride)matcher.getData();
                        if (override.getRenderPass() < 0) continue;
                        RenderPassAPI.instance.setRenderPassForBlock((apa)entry.getKey(), override.getRenderPass());
                    }
                }
                for (List list : blockOverrides.values()) {
                    Collections.sort(list, new Comparator<BlockStateMatcher>(){

                        @Override
                        public int compare(BlockStateMatcher m1, BlockStateMatcher m2) {
                            ITileOverride o1 = (ITileOverride)m1.getData();
                            ITileOverride o2 = (ITileOverride)m2.getData();
                            return o1.compareTo(o2);
                        }
                    });
                }
                for (List list : tileOverrides.values()) {
                    Collections.sort(list);
                }
                CTMUtils.setBlankResource();
            }
        });
    }
}

