/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.ctm;

import com.prupe.mcpatcher.ctm.RenderBlockState;
import com.prupe.mcpatcher.mal.block.BlockAPI;
import com.prupe.mcpatcher.mal.block.BlockStateMatcher;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
final class BlockOrientation
extends RenderBlockState {
    private static final int[][][] NEIGHBOR_OFFSET = new int[][][]{BlockOrientation.makeNeighborOffset(4, 3, 5, 2), BlockOrientation.makeNeighborOffset(4, 3, 5, 2), BlockOrientation.makeNeighborOffset(5, 0, 4, 1), BlockOrientation.makeNeighborOffset(4, 0, 5, 1), BlockOrientation.makeNeighborOffset(2, 0, 3, 1), BlockOrientation.makeNeighborOffset(3, 0, 2, 1)};
    private static final int[][] ROTATE_UV_MAP = new int[][]{{4, 5, 2, 3, 1, 0, 2, -2, 2, -2, 0, 0}, {2, 3, 1, 0, 4, 5, 0, 0, 0, 0, -2, 2}, {4, 5, 2, 3, 1, 0, 2, -2, -2, -2, 0, 0}, {2, 3, 1, 0, 4, 5, 0, 0, 0, 0, -2, -2}};
    private int i;
    private int j;
    private int k;
    private int metadata;
    private int altMetadata;
    private int metadataBits;
    private int renderType;
    private int blockFace;
    private int textureFace;
    private int textureFaceOrig;
    private int rotateUV;

    BlockOrientation() {
    }

    @Override
    public void clear() {
        super.clear();
        this.k = 0;
        this.j = 0;
        this.i = 0;
        this.renderType = -1;
        this.metadata = 0;
        this.textureFace = 0;
        this.blockFace = 0;
        this.rotateUV = 0;
        this.offsetsComputed = false;
        this.haveOffsets = false;
        this.dk = 0;
        this.dj = 0;
        this.di = 0;
    }

    @Override
    public int getI() {
        return this.i;
    }

    @Override
    public int getJ() {
        return this.j;
    }

    @Override
    public int getK() {
        return this.k;
    }

    @Override
    public int getBlockFace() {
        return this.blockFace;
    }

    @Override
    public int getTextureFace() {
        return this.textureFace;
    }

    @Override
    public int getTextureFaceOrig() {
        return this.textureFaceOrig;
    }

    @Override
    public String getTextureFaceName() {
        throw new UnsupportedOperationException("getTextureName");
    }

    @Override
    public int getFaceForHV() {
        return this.blockFace;
    }

    @Override
    public boolean match(BlockStateMatcher matcher) {
        return this.isInWorld() ? matcher.match(this.blockAccess, this.i, this.j, this.k) : matcher.match(this.block, this.metadata);
    }

    @Override
    public int[] getOffset(int blockFace, int relativeDirection) {
        return NEIGHBOR_OFFSET[blockFace][this.rotateUV(relativeDirection)];
    }

    @Override
    public boolean setCoordOffsetsForRenderType() {
        if (this.offsetsComputed) {
            return this.haveOffsets;
        }
        this.offsetsComputed = true;
        this.haveOffsets = false;
        this.dk = 0;
        this.dj = 0;
        this.di = 0;
        switch (this.renderType) {
            case 1: {
                while (this.j + this.dj > 0 && this.block == BlockAPI.getBlockAt(this.blockAccess, this.i, this.j + this.dj - 1, this.k)) {
                    --this.dj;
                    this.haveOffsets = true;
                }
                break;
            }
            case 7: 
            case 40: {
                if ((this.metadata & 8) == 0 || this.block != BlockAPI.getBlockAt(this.blockAccess, this.i, this.j - 1, this.k)) break;
                --this.dj;
                this.haveOffsets = true;
                break;
            }
            case 14: {
                this.metadata = BlockAPI.getMetadataAt(this.blockAccess, this.i, this.j, this.k);
                switch (this.metadata) {
                    case 0: 
                    case 4: {
                        this.dk = 1;
                        break;
                    }
                    case 1: 
                    case 5: {
                        this.di = -1;
                        break;
                    }
                    case 2: 
                    case 6: {
                        this.dk = -1;
                        break;
                    }
                    case 3: 
                    case 7: {
                        this.di = 1;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                this.haveOffsets = this.block == BlockAPI.getBlockAt(this.blockAccess, this.i + this.di, this.j, this.k + this.dk);
                break;
            }
        }
        return this.haveOffsets;
    }

    @Override
    public boolean shouldConnectByBlock(apa neighbor, int neighborI, int neighborJ, int neighborK) {
        return this.block == neighbor && (this.metadataBits & 1 << BlockAPI.getMetadataAt(this.blockAccess, neighborI, neighborJ, neighborK)) != 0;
    }

    @Override
    public boolean shouldConnectByTile(apa neighbor, lx origIcon, int neighborI, int neighborJ, int neighborK) {
        return origIcon == BlockAPI.getBlockIcon(neighbor, this.blockAccess, neighborI, neighborJ, neighborK, this.getTextureFaceOrig());
    }

    void setBlock(apa block, aak blockAccess, int i2, int j2, int k) {
        this.block = block;
        this.blockAccess = blockAccess;
        this.inWorld = true;
        this.i = i2;
        this.j = j2;
        this.k = k;
        this.renderType = block.d();
        this.metadata = this.altMetadata = BlockAPI.getMetadataAt(blockAccess, i2, j2, k);
        this.offsetsComputed = false;
    }

    void setFace(int face) {
        this.blockFace = this.getBlockFaceByRenderType(face);
        this.textureFaceOrig = face;
        this.rotateUV = 0;
        this.textureFace = this.blockFaceToTextureFace(this.blockFace);
        this.metadataBits = 1 << this.metadata | 1 << this.altMetadata;
    }

    void setBlockMetadata(apa block, int metadata, int face) {
        this.block = block;
        this.blockAccess = null;
        this.inWorld = false;
        this.k = 0;
        this.j = 0;
        this.i = 0;
        this.renderType = block.d();
        this.textureFace = this.textureFaceOrig = face;
        this.blockFace = this.textureFaceOrig;
        this.metadata = metadata;
        this.metadataBits = 1 << metadata;
        this.dk = 0;
        this.dj = 0;
        this.di = 0;
        this.rotateUV = 0;
    }

    private int getBlockFaceByRenderType(int face) {
        switch (this.renderType) {
            case 1: {
                return 2;
            }
            case 8: {
                switch (this.metadata) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        return this.metadata;
                    }
                }
                break;
            }
            case 20: {
                switch (this.metadata) {
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 5;
                    }
                    case 4: {
                        return 3;
                    }
                    case 8: {
                        return 4;
                    }
                }
                break;
            }
        }
        return face;
    }

    private int blockFaceToTextureFace(int face) {
        switch (this.renderType) {
            case 31: {
                switch (this.metadata & 0xC) {
                    case 4: {
                        this.altMetadata &= 0xFFFFFFF3;
                        this.rotateUV = ROTATE_UV_MAP[0][face + 6];
                        return ROTATE_UV_MAP[0][face];
                    }
                    case 8: {
                        this.altMetadata &= 0xFFFFFFF3;
                        this.rotateUV = ROTATE_UV_MAP[1][face + 6];
                        return ROTATE_UV_MAP[1][face];
                    }
                }
                break;
            }
            case 39: {
                switch (this.metadata) {
                    case 3: {
                        this.altMetadata = 2;
                        this.rotateUV = ROTATE_UV_MAP[2][face + 6];
                        return ROTATE_UV_MAP[2][face];
                    }
                    case 4: {
                        this.altMetadata = 2;
                        this.rotateUV = ROTATE_UV_MAP[3][face + 6];
                        return ROTATE_UV_MAP[3][face];
                    }
                }
                break;
            }
        }
        return face;
    }

    private int rotateUV(int neighbor) {
        return neighbor + this.rotateUV & 7;
    }

    boolean logIt() {
        return false;
    }
}

