/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.ctm;

import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.ctm.RenderBlockState;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class BlockFaceMatcher {
    private final int faces;

    public static BlockFaceMatcher create(String propertyValue) {
        if (!MCPatcherUtils.isNullOrEmpty(propertyValue)) {
            String[] values = propertyValue.toLowerCase().split("\\s+");
            return new BlockFaceMatcher(values);
        }
        return null;
    }

    protected BlockFaceMatcher(String[] values) {
        int flags = 0;
        for (String face : values) {
            if (face.equals("bottom") || face.equals("down")) {
                flags |= 1;
                continue;
            }
            if (face.equals("top") || face.equals("up")) {
                flags |= 2;
                continue;
            }
            if (face.equals("north")) {
                flags |= 4;
                continue;
            }
            if (face.equals("south")) {
                flags |= 8;
                continue;
            }
            if (face.equals("east")) {
                flags |= 0x20;
                continue;
            }
            if (face.equals("west")) {
                flags |= 0x10;
                continue;
            }
            if (face.equals("side") || face.equals("sides")) {
                flags |= 0x3C;
                continue;
            }
            if (!face.equals("all")) continue;
            flags = -1;
        }
        this.faces = flags;
    }

    public boolean match(RenderBlockState renderBlockState) {
        int face = renderBlockState.getTextureFace();
        return face >= 0 && (this.faces & 1 << face) != 0;
    }

    protected boolean isAll() {
        return this.faces == -1;
    }
}

