/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.cit;

import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.cit.ItemOverride;
import com.prupe.mcpatcher.mal.resource.FakeResourceLocation;
import com.prupe.mcpatcher.mal.resource.PropertiesFile;
import com.prupe.mcpatcher.mal.resource.TexturePackAPI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
class PotionReplacer {
    private static final MCLogger logger = MCLogger.getLogger("Custom Item Textures", "CIT");
    private static final String ITEM_ID_POTION = "minecraft:potion";
    private static final String ITEM_ID_GLASS_BOTTLE = "minecraft:glass_bottle";
    private static final String LAYER_POTION_CONTENTS = "potion_contents";
    private static final String LAYER_POTION_DRINKABLE = "potion";
    private static final String LAYER_POTION_SPLASH = "potion_splash";
    private static final String LAYER_EMPTY_BOTTLE = "potion";
    private static final int SPLASH_BIT = 16384;
    private static final int EFFECT_BITS = 16399;
    private static final int MUNDANE_BITS = 16447;
    private static final int WATER_BITS = 65535;
    private static final int[] POTION_EFFECTS = new int[]{-1, 2, 10, -1, -1, 9, 5, 12, -1, -1, 1, -1, 3, -1, 14, -1, 6, -1, 8, 4, -1};
    private static final Map<String, Integer> mundanePotionMap = new HashMap<String, Integer>();
    private static int weight = -2;
    final List<ItemOverride> overrides = new ArrayList<ItemOverride>();

    PotionReplacer() {
        FakeResourceLocation path = PotionReplacer.getPotionPath("water", false);
        if (TexturePackAPI.hasResource(path)) {
            ++weight;
            this.registerVanillaPotion(path, 0, 65535, false);
            --weight;
        }
        if (TexturePackAPI.hasResource(path = PotionReplacer.getPotionPath("empty", false))) {
            this.registerEmptyBottle(path);
        }
        this.registerPotionsByEffect(false);
        this.registerPotionsByEffect(true);
        this.registerMundanePotions(false);
        this.registerMundanePotions(true);
        this.registerOtherPotions(false);
        this.registerOtherPotions(true);
    }

    private static FakeResourceLocation getPotionPath(String name, boolean splash) {
        String path = "cit/potion/" + (splash ? "splash/" : "normal/") + name + ".png";
        return TexturePackAPI.newMCPatcherResourceLocation(path);
    }

    private static Properties newProperties(FakeResourceLocation path, String itemID, String layer) {
        Properties properties = new Properties();
        properties.setProperty("type", "item");
        properties.setProperty("items", itemID);
        properties.setProperty("texture." + layer, path.toString());
        properties.setProperty("texture.potion_contents", "blank");
        properties.setProperty("weight", String.valueOf(weight));
        return properties;
    }

    private static Properties newProperties(FakeResourceLocation path, String itemID, boolean splash) {
        String layer = splash ? LAYER_POTION_SPLASH : "potion";
        return PotionReplacer.newProperties(path, itemID, layer);
    }

    private void registerPotionsByEffect(boolean splash) {
        for (int effect = 0; effect < mk.a.length; ++effect) {
            FakeResourceLocation path;
            if (mk.a[effect] == null || !TexturePackAPI.hasResource(path = PotionReplacer.getPotionPath(mk.a[effect].a().replaceFirst("^potion\\.", ""), splash))) continue;
            if (effect < POTION_EFFECTS.length && POTION_EFFECTS[effect] >= 0) {
                int damage = POTION_EFFECTS[effect];
                if (splash) {
                    damage |= 0x4000;
                }
                this.registerVanillaPotion(path, damage, 16399, splash);
            }
            if (splash) continue;
            this.registerCustomPotion(path, effect, splash);
        }
    }

    private void registerMundanePotions(boolean splash) {
        for (Map.Entry<String, Integer> entry : mundanePotionMap.entrySet()) {
            int damage = entry.getValue();
            if (splash) {
                damage |= 0x4000;
            }
            this.registerMundanePotion(entry.getKey(), damage, splash);
        }
    }

    private void registerMundanePotion(String name, int damage, boolean splash) {
        FakeResourceLocation path = PotionReplacer.getPotionPath(name, splash);
        if (TexturePackAPI.hasResource(path)) {
            this.registerVanillaPotion(path, damage, 16447, splash);
        }
    }

    private void registerOtherPotions(boolean splash) {
        FakeResourceLocation path = PotionReplacer.getPotionPath("other", splash);
        if (TexturePackAPI.hasResource(path)) {
            Properties properties = PotionReplacer.newProperties(path, ITEM_ID_POTION, splash);
            StringBuilder sb2 = new StringBuilder();
            for (int i2 : mundanePotionMap.values()) {
                if (splash) {
                    i2 |= 0x4000;
                }
                sb2.append(' ').append(i2);
            }
            properties.setProperty("damage", sb2.toString().trim());
            properties.setProperty("damageMask", String.valueOf(16447));
            this.addOverride(path, properties);
        }
    }

    private void registerVanillaPotion(FakeResourceLocation path, int damage, int mask, boolean splash) {
        Properties properties = PotionReplacer.newProperties(path, ITEM_ID_POTION, splash);
        properties.setProperty("damage", String.valueOf(damage));
        properties.setProperty("damageMask", String.valueOf(mask));
        this.addOverride(path, properties);
    }

    private void registerCustomPotion(FakeResourceLocation path, int effect, boolean splash) {
        Properties properties = PotionReplacer.newProperties(path, ITEM_ID_POTION, splash);
        properties.setProperty("nbt.CustomPotionEffects.0.Id", String.valueOf(effect));
        this.addOverride(path, properties);
    }

    private void registerEmptyBottle(FakeResourceLocation path) {
        Properties properties = PotionReplacer.newProperties(path, ITEM_ID_GLASS_BOTTLE, "potion");
        this.addOverride(path, properties);
    }

    private void addOverride(FakeResourceLocation path, Properties properties) {
        FakeResourceLocation propertiesName = TexturePackAPI.transformResourceLocation(path, ".png", ".properties");
        ItemOverride override = new ItemOverride(new PropertiesFile(logger, propertiesName, properties));
        if (override.properties.valid()) {
            this.overrides.add(override);
        }
    }

    static {
        try {
            for (int i2 : new int[]{0, 7, 11, 13, 15, 16, 23, 27, 29, 31, 32, 39, 43, 45, 47, 48, 55, 59, 61, 63}) {
                String name = xu.c(i2).replaceFirst("^potion\\.prefix\\.", "");
                mundanePotionMap.put(name, i2);
                logger.fine("%s potion -> damage value %d", name, i2);
            }
            for (int i3 = 0; i3 < mk.a.length; ++i3) {
                mk potion = mk.a[i3];
                if (potion == null) continue;
                logger.fine("%s potion -> effect %d", potion.a().replaceFirst("^potion\\.", ""), i3);
            }
        }
        catch (Throwable e2) {
            e2.printStackTrace();
        }
    }
}

