/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.cit;

import com.prupe.mcpatcher.cit.CITUtils;
import com.prupe.mcpatcher.cit.OverrideBase;
import com.prupe.mcpatcher.mal.resource.BlendMethod;
import com.prupe.mcpatcher.mal.resource.FakeResourceLocation;
import com.prupe.mcpatcher.mal.resource.GLAPI;
import com.prupe.mcpatcher.mal.resource.PropertiesFile;
import com.prupe.mcpatcher.mal.resource.TexturePackAPI;
import com.prupe.mcpatcher.mal.tessellator.TessellatorAPI;
import com.prupe.mcpatcher.mal.tile.IconAPI;
import java.awt.image.BufferedImage;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.lwjgl.opengl.GL11;

@Environment(value=EnvType.CLIENT)
final class Enchantment
extends OverrideBase {
    private static final float ITEM_2D_THICKNESS = 0.0625f;
    static float baseArmorWidth;
    static float baseArmorHeight;
    private static boolean lightingWasEnabled;
    final int layer;
    final BlendMethod blendMethod;
    private final float rotation;
    private final double speed;
    final float duration;
    private boolean armorScaleSet;
    private float armorScaleX;
    private float armorScaleY;

    static void beginOuter2D() {
        GL11.glEnable((int)3008);
        GLAPI.glAlphaFunc(516, 0.01f);
        GL11.glEnable((int)3042);
        GLAPI.glDepthFunc(514);
        GLAPI.glDepthMask(false);
        GL11.glDisable((int)2896);
        GL11.glMatrixMode((int)5890);
    }

    static void endOuter2D() {
        GLAPI.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GL11.glDisable((int)3042);
        GLAPI.glDepthFunc(515);
        GLAPI.glDepthMask(true);
        GL11.glEnable((int)2896);
        GL11.glMatrixMode((int)5888);
    }

    static void beginOuter3D() {
        GL11.glEnable((int)3008);
        GLAPI.glAlphaFunc(516, 0.01f);
        GL11.glEnable((int)3042);
        GLAPI.glDepthFunc(514);
        lightingWasEnabled = GL11.glGetBoolean((int)2896);
        GL11.glDisable((int)2896);
        GL11.glMatrixMode((int)5890);
    }

    static void endOuter3D() {
        GLAPI.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GL11.glDisable((int)3042);
        GLAPI.glDepthFunc(515);
        if (lightingWasEnabled) {
            GL11.glEnable((int)2896);
        }
        GL11.glMatrixMode((int)5888);
    }

    Enchantment(PropertiesFile properties) {
        super(properties);
        if (properties.valid() && this.textureName == null && this.alternateTextures == null) {
            properties.error("no source texture specified", new Object[0]);
        }
        this.layer = properties.getInt("layer", 0);
        String value = properties.getString("blend", "add");
        this.blendMethod = BlendMethod.parse(value);
        if (this.blendMethod == null) {
            properties.error("unknown blend type %s", value);
        }
        this.rotation = properties.getFloat("rotation", 0.0f);
        this.speed = properties.getDouble("speed", 0.0);
        this.duration = properties.getFloat("duration", 1.0f);
        String valueX = properties.getString("armorScaleX", "");
        String valueY = properties.getString("armorScaleY", "");
        if (!valueX.isEmpty() && !valueY.isEmpty()) {
            try {
                this.armorScaleX = Float.parseFloat(valueX);
                this.armorScaleY = Float.parseFloat(valueY);
                this.armorScaleSet = true;
            }
            catch (NumberFormatException e2) {
                e2.printStackTrace();
            }
        }
    }

    @Override
    String getType() {
        return "enchantment";
    }

    void render2D(bgd tessellator, float intensity, float x0, float y0, float x1, float y1, float z2) {
        if (intensity <= 0.0f) {
            return;
        }
        if (intensity > 1.0f) {
            intensity = 1.0f;
        }
        if (!this.bindTexture(CITUtils.lastOrigIcon)) {
            return;
        }
        this.begin(intensity);
        TessellatorAPI.startDrawingQuads(tessellator);
        TessellatorAPI.addVertexWithUV(tessellator, x0, y0, z2, 0.0, 0.0);
        TessellatorAPI.addVertexWithUV(tessellator, x0, y1, z2, 0.0, 1.0);
        TessellatorAPI.addVertexWithUV(tessellator, x1, y1, z2, 1.0, 1.0);
        TessellatorAPI.addVertexWithUV(tessellator, x1, y0, z2, 1.0, 0.0);
        TessellatorAPI.draw(tessellator);
        this.end();
    }

    void render3D(bgd tessellator, float intensity, int width, int height) {
        if (intensity <= 0.0f) {
            return;
        }
        if (intensity > 1.0f) {
            intensity = 1.0f;
        }
        if (!this.bindTexture(CITUtils.lastOrigIcon)) {
            return;
        }
        this.begin(intensity);
        bfx.a(tessellator, 1.0f, 0.0f, 0.0f, 1.0f, width, height, 0.0625f);
        this.end();
    }

    boolean bindTexture(lx icon) {
        FakeResourceLocation texture;
        if (this.alternateTextures != null && icon != null) {
            texture = (FakeResourceLocation)this.alternateTextures.get(IconAPI.getIconName(icon));
            if (texture == null) {
                texture = this.textureName;
            }
        } else {
            texture = this.textureName;
        }
        if (texture == null) {
            return false;
        }
        TexturePackAPI.bindTexture(texture);
        return true;
    }

    void beginArmor(float intensity) {
        GL11.glEnable((int)3042);
        GLAPI.glDepthFunc(514);
        GLAPI.glDepthMask(false);
        GL11.glDisable((int)2896);
        GL11.glMatrixMode((int)5890);
        this.begin(intensity);
        if (!this.armorScaleSet) {
            this.setArmorScale();
        }
        GL11.glScalef((float)this.armorScaleX, (float)this.armorScaleY, (float)1.0f);
        GL11.glMatrixMode((int)5888);
    }

    void endArmor() {
        GLAPI.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GL11.glDisable((int)3042);
        GLAPI.glDepthFunc(515);
        GLAPI.glDepthMask(true);
        GL11.glEnable((int)2896);
        GL11.glMatrixMode((int)5890);
        this.end();
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
    }

    void begin(float intensity) {
        this.blendMethod.applyBlending();
        this.blendMethod.applyDepthFunc();
        this.blendMethod.applyFade(intensity);
        GL11.glPushMatrix();
        if (this.speed != 0.0) {
            double offset = (double)System.currentTimeMillis() * this.speed / 3000.0;
            offset -= Math.floor(offset);
            GL11.glTranslatef((float)((float)offset * 8.0f), (float)0.0f, (float)0.0f);
        }
        GL11.glRotatef((float)this.rotation, (float)0.0f, (float)0.0f, (float)1.0f);
    }

    void end() {
        GL11.glPopMatrix();
    }

    private void setArmorScale() {
        this.armorScaleSet = true;
        this.armorScaleX = 1.0f;
        this.armorScaleY = 0.5f;
        BufferedImage overlayImage = TexturePackAPI.getImage(this.textureName);
        if (overlayImage != null) {
            if ((float)overlayImage.getWidth() < baseArmorWidth) {
                this.armorScaleX *= baseArmorWidth / (float)overlayImage.getWidth();
            }
            if ((float)overlayImage.getHeight() < baseArmorHeight) {
                this.armorScaleY *= baseArmorHeight / (float)overlayImage.getHeight();
            }
        }
        logger.finer("%s: scaling by %.3fx%.3f for armor model", this, Float.valueOf(this.armorScaleX), Float.valueOf(this.armorScaleY));
    }
}

