/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.cit;

import com.prupe.mcpatcher.Config;
import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.cit.ArmorOverride;
import com.prupe.mcpatcher.cit.Enchantment;
import com.prupe.mcpatcher.cit.EnchantmentList;
import com.prupe.mcpatcher.cit.ItemOverride;
import com.prupe.mcpatcher.cit.OverrideBase;
import com.prupe.mcpatcher.cit.PotionReplacer;
import com.prupe.mcpatcher.mal.item.ItemAPI;
import com.prupe.mcpatcher.mal.resource.FakeResourceLocation;
import com.prupe.mcpatcher.mal.resource.PropertiesFile;
import com.prupe.mcpatcher.mal.resource.ResourceList;
import com.prupe.mcpatcher.mal.resource.TexturePackAPI;
import com.prupe.mcpatcher.mal.resource.TexturePackChangeHandler;
import com.prupe.mcpatcher.mal.tessellator.TessellatorAPI;
import com.prupe.mcpatcher.mal.tile.IconAPI;
import com.prupe.mcpatcher.mal.tile.TileLoader;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class CITUtils {
    private static final MCLogger logger = MCLogger.getLogger("Custom Item Textures", "CIT");
    static final String CIT_PROPERTIES = "cit.properties";
    private static final FakeResourceLocation CIT_PROPERTIES1 = TexturePackAPI.newMCPatcherResourceLocation("cit.properties");
    private static final FakeResourceLocation CIT_PROPERTIES2 = TexturePackAPI.newMCPatcherResourceLocation("cit/cit.properties");
    static final FakeResourceLocation FIXED_ARMOR_RESOURCE = new FakeResourceLocation("textures/models/armor/iron_layer_1.png");
    static final int MAX_ENCHANTMENTS = 256;
    private static wk itemEnchantedBook;
    static wk itemCompass;
    static wk itemClock;
    static final boolean enableItems;
    static final boolean enableEnchantments;
    static final boolean enableArmor;
    private static TileLoader tileLoader;
    private static final Map<wk, List<ItemOverride>> items;
    private static final Map<wk, List<Enchantment>> enchantments;
    private static final List<Enchantment> allItemEnchantments;
    private static final Map<wk, List<ArmorOverride>> armors;
    static boolean useGlint;
    private static EnchantmentList armorMatches;
    private static int armorMatchIndex;
    private static wm lastItemStack;
    private static int lastRenderPass;
    static lx lastOrigIcon;
    private static lx lastIcon;
    private static Field potionItemStackField;

    public static void init() {
    }

    public static lx getIcon(lx icon, wm itemStack, int renderPass) {
        lx newIcon;
        ItemOverride override;
        if (icon == lastIcon && itemStack == lastItemStack && renderPass == lastRenderPass) {
            return icon;
        }
        lastOrigIcon = lastIcon = icon;
        lastItemStack = itemStack;
        lastRenderPass = renderPass;
        if (enableItems && (override = CITUtils.findItemOverride(itemStack)) != null && (newIcon = override.getReplacementIcon(icon)) != null) {
            lastIcon = newIcon;
        }
        return lastIcon;
    }

    public static lx getEntityIcon(lx icon, mp entity) {
        if (entity instanceof tf && potionItemStackField != null) {
            try {
                return CITUtils.getIcon(icon, (wm)potionItemStackField.get(entity), 1);
            }
            catch (IllegalAccessException e2) {
                e2.printStackTrace();
                potionItemStackField = null;
            }
        }
        return icon;
    }

    public static FakeResourceLocation getArmorTexture(FakeResourceLocation texture, ng entity, wm itemStack) {
        FakeResourceLocation newTexture;
        ArmorOverride override;
        if (enableArmor && (override = CITUtils.findArmorOverride(itemStack)) != null && (newTexture = override.getReplacementTexture(texture)) != null) {
            return newTexture;
        }
        return texture;
    }

    private static <T extends OverrideBase> T findMatch(Map<wk, List<T>> overrides, wm itemStack) {
        wk item = itemStack.b();
        List<T> list = overrides.get(item);
        if (list != null) {
            int[] enchantmentLevels = CITUtils.getEnchantmentLevels(item, itemStack.q());
            boolean hasEffect = itemStack.u();
            for (OverrideBase override : list) {
                if (!override.match(itemStack, enchantmentLevels, hasEffect)) continue;
                return (T)override;
            }
        }
        return null;
    }

    static ItemOverride findItemOverride(wm itemStack) {
        return (ItemOverride)CITUtils.findMatch(items, itemStack);
    }

    static ArmorOverride findArmorOverride(wm itemStack) {
        return (ArmorOverride)CITUtils.findMatch(armors, itemStack);
    }

    static EnchantmentList findEnchantments(wm itemStack) {
        return new EnchantmentList(enchantments, allItemEnchantments, itemStack);
    }

    public static boolean renderEnchantmentHeld(wm itemStack, int renderPass) {
        int width;
        int height;
        if (itemStack == null || renderPass != 0) {
            return true;
        }
        if (!enableEnchantments) {
            return false;
        }
        EnchantmentList matches = CITUtils.findEnchantments(itemStack);
        if (matches.isEmpty()) {
            return !useGlint;
        }
        if (lastIcon == null) {
            height = 256;
            width = 256;
        } else {
            width = IconAPI.getIconWidth(lastIcon);
            height = IconAPI.getIconHeight(lastIcon);
        }
        Enchantment.beginOuter3D();
        for (int i2 = 0; i2 < matches.size(); ++i2) {
            matches.getEnchantment(i2).render3D(TessellatorAPI.getTessellator(), matches.getIntensity(i2), width, height);
        }
        Enchantment.endOuter3D();
        return !useGlint;
    }

    public static boolean renderEnchantmentDropped(wm itemStack) {
        return CITUtils.renderEnchantmentHeld(itemStack, lastRenderPass);
    }

    public static boolean renderEnchantmentGUI(wm itemStack, int x2, int y2, float z2) {
        if (!enableEnchantments || itemStack == null) {
            return false;
        }
        EnchantmentList matches = CITUtils.findEnchantments(itemStack);
        if (matches.isEmpty()) {
            return !useGlint;
        }
        Enchantment.beginOuter2D();
        for (int i2 = 0; i2 < matches.size(); ++i2) {
            matches.getEnchantment(i2).render2D(TessellatorAPI.getTessellator(), matches.getIntensity(i2), x2, y2, x2 + 16, y2 + 16, z2);
        }
        Enchantment.endOuter2D();
        return !useGlint;
    }

    public static boolean setupArmorEnchantments(ng entity, int pass) {
        return CITUtils.setupArmorEnchantments(entity.p(4 - pass));
    }

    public static boolean setupArmorEnchantments(wm itemStack) {
        EnchantmentList tmpList;
        armorMatches = null;
        armorMatchIndex = 0;
        if (enableEnchantments && itemStack != null && !(tmpList = CITUtils.findEnchantments(itemStack)).isEmpty()) {
            armorMatches = tmpList;
        }
        return CITUtils.isArmorEnchantmentActive() || !useGlint;
    }

    public static boolean preRenderArmorEnchantment() {
        if (CITUtils.isArmorEnchantmentActive()) {
            Enchantment enchantment = armorMatches.getEnchantment(armorMatchIndex);
            if (enchantment.bindTexture(lastOrigIcon)) {
                enchantment.beginArmor(armorMatches.getIntensity(armorMatchIndex));
                return true;
            }
            return false;
        }
        armorMatches = null;
        armorMatchIndex = 0;
        return false;
    }

    public static boolean isArmorEnchantmentActive() {
        return armorMatches != null && armorMatchIndex < armorMatches.size();
    }

    public static void postRenderArmorEnchantment() {
        armorMatches.getEnchantment(armorMatchIndex).endArmor();
        ++armorMatchIndex;
    }

    static int[] getEnchantmentLevels(wk item, bs nbt) {
        cf base;
        int[] levels = null;
        if (nbt != null && (base = item == itemEnchantedBook ? nbt.a("StoredEnchantments") : nbt.a("ench")) instanceof ca) {
            ca list = (ca)base;
            for (int i2 = 0; i2 < list.c(); ++i2) {
                base = list.b(i2);
                if (!(base instanceof bs)) continue;
                short id = ((bs)base).d("id");
                short level = ((bs)base).d("lvl");
                if (id < 0 || id >= 256 || level <= 0) continue;
                if (levels == null) {
                    levels = new int[256];
                }
                short s2 = id;
                levels[s2] = levels[s2] + level;
            }
        }
        return levels;
    }

    static {
        enableItems = Config.getBoolean("Custom Item Textures", "items", true);
        enableEnchantments = Config.getBoolean("Custom Item Textures", "enchantments", true);
        enableArmor = Config.getBoolean("Custom Item Textures", "armor", true);
        items = new IdentityHashMap<wk, List<ItemOverride>>();
        enchantments = new IdentityHashMap<wk, List<Enchantment>>();
        allItemEnchantments = new ArrayList<Enchantment>();
        armors = new IdentityHashMap<wk, List<ArmorOverride>>();
        for (Field f2 : tf.class.getDeclaredFields()) {
            if (!wm.class.isAssignableFrom(f2.getType())) continue;
            f2.setAccessible(true);
            potionItemStackField = f2;
            break;
        }
        TexturePackChangeHandler.register(new TexturePackChangeHandler("Custom Item Textures", 3){

            @Override
            public void beforeChange() {
                itemEnchantedBook = ItemAPI.getFixedItem("minecraft:enchanted_book");
                itemCompass = ItemAPI.getFixedItem("minecraft:compass");
                itemClock = ItemAPI.getFixedItem("minecraft:clock");
                tileLoader = new TileLoader("textures/items", logger);
                items.clear();
                enchantments.clear();
                allItemEnchantments.clear();
                armors.clear();
                lastOrigIcon = null;
                lastIcon = null;
                BufferedImage image = TexturePackAPI.getImage(FIXED_ARMOR_RESOURCE);
                if (image == null) {
                    Enchantment.baseArmorWidth = 64.0f;
                    Enchantment.baseArmorHeight = 32.0f;
                } else {
                    Enchantment.baseArmorWidth = image.getWidth();
                    Enchantment.baseArmorHeight = image.getHeight();
                }
                PropertiesFile properties = PropertiesFile.get(logger, CIT_PROPERTIES1);
                if (properties == null) {
                    properties = PropertiesFile.getNonNull(logger, CIT_PROPERTIES2);
                }
                useGlint = properties.getBoolean("useGlint", true);
                EnchantmentList.setProperties(properties);
                if (enableItems || enableEnchantments || enableArmor) {
                    for (FakeResourceLocation resource : ResourceList.getInstance().listResources("/cit", ".properties", true)) {
                        this.registerOverride(OverrideBase.create(resource));
                    }
                    if (enableItems) {
                        PotionReplacer replacer = new PotionReplacer();
                        for (ItemOverride override : replacer.overrides) {
                            this.registerOverride(override);
                        }
                    }
                }
            }

            @Override
            public void afterChange() {
                for (List list : items.values()) {
                    for (OverrideBase override : list) {
                        ((ItemOverride)override).registerIcon(tileLoader);
                    }
                    Collections.sort(list);
                }
                for (List list : enchantments.values()) {
                    list.addAll(allItemEnchantments);
                    Collections.sort(list);
                }
                Collections.sort(allItemEnchantments);
                for (List list : armors.values()) {
                    Collections.sort(list);
                }
            }

            private void registerOverride(OverrideBase override) {
                if (override != null && override.properties.valid()) {
                    Map map;
                    if (override instanceof ItemOverride) {
                        ((ItemOverride)override).preload(tileLoader);
                        map = items;
                    } else if (override instanceof Enchantment) {
                        map = enchantments;
                    } else if (override instanceof ArmorOverride) {
                        map = armors;
                    } else {
                        logger.severe("unknown ItemOverride type %d", override.getClass().getName());
                        return;
                    }
                    if (override.items == null) {
                        if (override instanceof Enchantment) {
                            logger.fine("registered %s to all items", override);
                            allItemEnchantments.add((Enchantment)override);
                        }
                    } else {
                        int i2 = 0;
                        for (wk item : override.items) {
                            this.registerOverride(map, item, override);
                            if (i2 < 10) {
                                logger.fine("registered %s to item %s", override, ItemAPI.getItemName(item));
                            } else if (i2 == 10) {
                                logger.fine("... %d total", override.items.size());
                            }
                            ++i2;
                        }
                    }
                }
            }

            private void registerOverride(Map<wk, List<OverrideBase>> map, wk item, OverrideBase override) {
                List<OverrideBase> list = map.get(item);
                if (list == null) {
                    list = new ArrayList<OverrideBase>();
                    map.put(item, list);
                }
                list.add(override);
            }
        });
    }
}

