/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.cit;

import com.prupe.mcpatcher.cit.CITUtils;
import com.prupe.mcpatcher.cit.OverrideBase;
import com.prupe.mcpatcher.mal.resource.FakeResourceLocation;
import com.prupe.mcpatcher.mal.resource.PropertiesFile;
import com.prupe.mcpatcher.mal.resource.TexturePackAPI;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
final class ArmorOverride
extends OverrideBase {
    private final Map<FakeResourceLocation, FakeResourceLocation> armorMap;

    ArmorOverride(PropertiesFile properties) {
        super(properties);
        if (this.items == null) {
            properties.error("no matching items specified", new Object[0]);
        }
        if (this.textureName == null && this.alternateTextures == null) {
            properties.error("no replacement textures specified", new Object[0]);
        }
        if (this.alternateTextures == null) {
            this.armorMap = null;
        } else {
            this.armorMap = new HashMap<FakeResourceLocation, FakeResourceLocation>();
            for (Map.Entry entry : this.alternateTextures.entrySet()) {
                String key = (String)entry.getKey();
                FakeResourceLocation value = (FakeResourceLocation)entry.getValue();
                this.armorMap.put(TexturePackAPI.parseResourceLocation(CITUtils.FIXED_ARMOR_RESOURCE, key), value);
            }
        }
    }

    @Override
    String getType() {
        return "armor";
    }

    FakeResourceLocation getReplacementTexture(FakeResourceLocation origResource) {
        FakeResourceLocation newResource;
        if (this.armorMap != null && (newResource = this.armorMap.get(origResource)) != null) {
            return newResource;
        }
        return this.textureName;
    }

    @Override
    String preprocessAltTextureKey(String name) {
        if (!name.endsWith(".png")) {
            name = name + ".png";
        }
        if (!name.contains("/")) {
            name = "./" + name;
        }
        return TexturePackAPI.parseResourceLocation(CITUtils.FIXED_ARMOR_RESOURCE, name).toString();
    }
}

